/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import lsedit.ColorCache;
import lsedit.FontCache;
import lsedit.HiGraphLayout;
import lsedit.LandscapeEditorCore;

class HiGraphConfigure
extends JDialog
implements ActionListener {
    protected JTextField m_xgap_textField;
    protected JTextField m_ygap_textField;
    protected JTextField m_simplex_textField;
    protected JTextField m_crossing_textField;
    protected JTextField m_border_textField;
    protected JCheckBox m_fixedRatio_checkBox;
    protected JLabel m_message;
    protected JButton m_ok;
    protected JButton m_default;
    protected JButton m_cancel;

    public HiGraphConfigure(LandscapeEditorCore landscapeEditorCore) {
        super(landscapeEditorCore.getFrame(), "Set Simplex Algorithm parameters", true);
        Font font = FontCache.getDialogFont();
        Font font2 = font.deriveFont(1);
        this.setForeground(ColorCache.get(0, 0, 0));
        this.setBackground(ColorCache.get(192, 192, 192));
        this.setFont(font);
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        jPanel.setLayout(new BorderLayout());
        GridLayout gridLayout = new GridLayout(6, 1);
        gridLayout.setVgap(10);
        jPanel2.setLayout(gridLayout);
        gridLayout = new GridLayout(6, 1);
        gridLayout.setVgap(10);
        jPanel3.setLayout(gridLayout);
        JLabel jLabel = new JLabel("Minimum horizontal gap between nodes:", 4);
        jLabel.setFont(font2);
        jPanel2.add(jLabel);
        this.m_xgap_textField = new JTextField("" + HiGraphLayout.xgap(), 12);
        this.m_xgap_textField.setFont(font);
        jPanel3.add(this.m_xgap_textField);
        jLabel = new JLabel("Minimum vertical gap between nodes:", 4);
        jLabel.setFont(font2);
        jPanel2.add(jLabel);
        this.m_ygap_textField = new JTextField("" + HiGraphLayout.ygap(), 12);
        this.m_ygap_textField.setFont(font);
        jPanel3.add(this.m_ygap_textField);
        jLabel = new JLabel("Maximum allowed simplex pivots:", 4);
        jLabel.setFont(font2);
        jPanel2.add(jLabel);
        this.m_simplex_textField = new JTextField("" + HiGraphLayout.simplex(), 12);
        this.m_simplex_textField.setFont(font);
        jPanel3.add(this.m_simplex_textField);
        jLabel = new JLabel("Maximum reorderings of a row:", 4);
        jLabel.setFont(font2);
        jPanel2.add(jLabel);
        this.m_crossing_textField = new JTextField("" + HiGraphLayout.crossing(), 12);
        this.m_crossing_textField.setFont(font);
        jPanel3.add(this.m_crossing_textField);
        jLabel = new JLabel("Percentage for border", 4);
        jLabel.setFont(font2);
        jPanel2.add(jLabel);
        this.m_border_textField = new JTextField("" + HiGraphLayout.border(), 12);
        this.m_border_textField.setFont(font);
        jPanel3.add(this.m_border_textField);
        jLabel = new JLabel("Scale using fixed ratio", 4);
        jLabel.setFont(font2);
        jPanel2.add(jLabel);
        this.m_fixedRatio_checkBox = new JCheckBox("", HiGraphLayout.fixedRatio());
        jPanel3.add(this.m_fixedRatio_checkBox);
        jPanel.add("West", jPanel2);
        jPanel.add("East", jPanel3);
        Container container = this.getContentPane();
        container.add("North", jPanel);
        this.m_message = new JLabel(" ", 0);
        this.m_message.setFont(font);
        this.m_message.setForeground(Color.RED);
        this.m_message.setSize(400, 50);
        container.add("Center", this.m_message);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new FlowLayout(1, 15, 15));
        this.m_ok = new JButton("Ok");
        this.m_ok.setFont(font2);
        jPanel4.add(this.m_ok);
        this.m_ok.addActionListener(this);
        this.m_default = new JButton("Default");
        this.m_default.setFont(font2);
        jPanel4.add(this.m_default);
        this.m_default.addActionListener(this);
        this.m_cancel = new JButton("Cancel");
        this.m_cancel.setFont(font2);
        jPanel4.add(this.m_cancel);
        this.m_cancel.addActionListener(this);
        container.add("South", jPanel4);
        this.pack();
        this.show();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.m_default) {
            this.m_xgap_textField.setText("20");
            this.m_ygap_textField.setText("20");
            this.m_simplex_textField.setText("10000");
            this.m_crossing_textField.setText("125");
            this.m_border_textField.setText("0.04");
            this.m_fixedRatio_checkBox.setSelected(true);
            return;
        }
        if (object != this.m_cancel && object != this.m_ok) {
            return;
        }
        if (object == this.m_ok) {
            double d;
            int n;
            int n2;
            int n3;
            int n4;
            String string = this.m_xgap_textField.getText();
            try {
                n4 = Integer.parseInt(string);
                if (n4 < 0) {
                    this.m_message.setText("Horizontal gap negative");
                    return;
                }
            }
            catch (Throwable throwable) {
                this.m_message.setText("Horizontal gap not an integer string value");
                return;
            }
            string = this.m_ygap_textField.getText();
            try {
                n3 = Integer.parseInt(string);
                if (n3 < 0) {
                    this.m_message.setText("Vertical gap negative");
                    return;
                }
            }
            catch (Throwable throwable) {
                this.m_message.setText("Vertical gap not an integer string value");
                return;
            }
            string = this.m_simplex_textField.getText();
            try {
                n2 = Integer.parseInt(string);
                if (n2 < 0) {
                    this.m_message.setText("Maximum pivots negative");
                    return;
                }
            }
            catch (Throwable throwable) {
                this.m_message.setText("Maximum pivots not an integer string value");
                return;
            }
            string = this.m_crossing_textField.getText();
            try {
                n = Integer.parseInt(string);
                if (n < 0) {
                    this.m_message.setText("Maximum crossing cycles negative");
                    return;
                }
            }
            catch (Throwable throwable) {
                this.m_message.setText("Maximum crossing cycles not an integer string value");
                return;
            }
            string = this.m_border_textField.getText();
            try {
                d = Double.parseDouble(string);
                if (d < 0.0) {
                    this.m_message.setText("Border negative");
                    return;
                }
                if (d > 0.5) {
                    this.m_message.setText("Border > 0.5");
                    return;
                }
            }
            catch (Throwable throwable) {
                this.m_message.setText("Border percentage not a double string value");
                return;
            }
            HiGraphLayout.xgap(n4);
            HiGraphLayout.ygap(n3);
            HiGraphLayout.simplex(n2);
            HiGraphLayout.crossing(n);
            HiGraphLayout.border(d);
            HiGraphLayout.fixedRatio(this.m_fixedRatio_checkBox.isSelected());
        }
        this.setVisible(false);
    }
}

