/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import lsedit.HiChildren;
import lsedit.HiGraph;
import lsedit.HiGraphConfigure;
import lsedit.HiGraphCoordinates;
import lsedit.HiGraphException;
import lsedit.HiGroup;
import lsedit.HiRank;
import lsedit.HiRow;
import lsedit.LandscapeEditorCore;

public class HiGraphLayout {
    public static final int horizVertexGap = 20;
    public static final int vertVertexGap = 20;
    public static final int horizMargin = 2;
    public static final int vertMargin = 2;
    public static final int simplexDefault = 10000;
    public static final int crossingDefault = 125;
    public static final double borderDefault = 0.04;
    public static final boolean fixedRatioDefault = true;
    private static int m_xgap = 20;
    private static int m_ygap = 20;
    private static int m_simplex = 10000;
    private static int m_crossing = 125;
    private static int m_weight_1dummy = 0;
    private static int m_weight_2dummy = 0;
    private static int m_outside_bias = 1;
    private static int m_group_children = 0;
    private static double m_border = 0.04;
    private static boolean m_fixedRatio = true;
    private static boolean m_bends = false;

    public static void configure(LandscapeEditorCore landscapeEditorCore) {
        HiGraphConfigure hiGraphConfigure = new HiGraphConfigure(landscapeEditorCore);
        hiGraphConfigure.dispose();
    }

    public static void setBends(boolean bl) {
        if (bl) {
            m_weight_1dummy = 2;
            m_weight_2dummy = 8;
        } else {
            m_weight_1dummy = 0;
            m_weight_2dummy = 0;
        }
        m_bends = bl;
    }

    public static boolean hasBends() {
        return m_bends;
    }

    public static int xgap() {
        return m_xgap;
    }

    public static boolean xgap(int n) {
        if (n >= 1) {
            m_xgap = n;
            return true;
        }
        return false;
    }

    public static int ygap() {
        return m_ygap;
    }

    public static boolean ygap(int n) {
        if (n >= 1) {
            m_ygap = n;
            return true;
        }
        return false;
    }

    public static int simplex() {
        return m_simplex;
    }

    public static boolean simplex(int n) {
        if (n >= 0) {
            m_simplex = n;
            return true;
        }
        return false;
    }

    public static int crossing() {
        return m_crossing;
    }

    public static boolean crossing(int n) {
        if (n >= 0) {
            m_crossing = n;
            return true;
        }
        return false;
    }

    public static double border() {
        return m_border;
    }

    public static void border(double d) {
        m_border = d;
    }

    public static boolean fixedRatio() {
        return m_fixedRatio;
    }

    public static void fixedRatio(boolean bl) {
        m_fixedRatio = bl;
    }

    public static int weight_1dummy() {
        return m_weight_1dummy;
    }

    public static boolean weight_1dummy(int n) {
        if (n >= 1) {
            m_weight_1dummy = n;
            return true;
        }
        return false;
    }

    public static int weight_2dummy() {
        return m_weight_2dummy;
    }

    public static boolean weight_2dummy(int n) {
        if (n >= 1) {
            m_weight_2dummy = n;
            return true;
        }
        return false;
    }

    public static int outside_bias() {
        return m_outside_bias;
    }

    public static boolean outside_bias(int n) {
        if (n >= 0) {
            m_outside_bias = n;
            return true;
        }
        return false;
    }

    public static int group_children() {
        return m_group_children;
    }

    public static boolean group_children(int n) {
        if (n >= -1 && n <= 1) {
            m_group_children = n;
            return true;
        }
        return false;
    }

    public static int xmargin() {
        return 2;
    }

    public static int ymargin() {
        return 2;
    }

    public boolean coordinates(HiGraph hiGraph) {
        try {
            HiGraphCoordinates.coordinates(this, hiGraph);
            return true;
        }
        catch (HiGraphException hiGraphException) {
            System.out.println("HiGraph error in HiGraphCoordinates: " + hiGraphException.getMessage());
            hiGraphException.printStackTrace();
        }
        catch (Exception exception) {
            System.out.println("Error during HiGraph layout in HiGraphCoordinates: " + exception.getMessage());
            exception.printStackTrace();
        }
        return false;
    }

    public boolean layout(HiGraph hiGraph) {
        try {
            HiGroup.group(hiGraph, HiGraphLayout.group_children());
            HiRank.compute(hiGraph, HiGraphLayout.simplex());
            HiChildren.order(hiGraph, HiGraphLayout.outside_bias());
            HiRow.order(this, hiGraph);
            boolean bl = this.coordinates(hiGraph);
            return bl;
        }
        catch (HiGraphException hiGraphException) {
            System.out.println("HiGraph error in " + hiGraph + ": " + hiGraphException.getMessage());
            hiGraphException.printStackTrace();
        }
        catch (Exception exception) {
            System.out.println("Error during HiGraph layout in " + hiGraph + ": " + exception.getMessage());
            exception.printStackTrace();
        }
        return false;
    }
}

