/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.util.Vector;
import lsedit.HiArc;
import lsedit.HiGraph;
import lsedit.HiGraphException;
import lsedit.HiGraphLayout;

class HiRow {
    HiRow() {
    }

    static HiGraph[][] buildBoard(HiGraph hiGraph) {
        HiGraph hiGraph2;
        HiArc hiArc;
        int n;
        int[] nArray = new int[hiGraph.m_sink_rank - hiGraph.m_rank + 1];
        int[] nArray2 = new int[hiGraph.m_sink_rank - hiGraph.m_rank + 1];
        Vector vector = hiGraph.m_children;
        int n2 = vector.size();
        for (n = 0; n < n2; ++n) {
            hiArc = (HiArc)vector.elementAt(n);
            hiGraph2 = hiArc.to();
            int n3 = hiGraph2.m_rank - hiGraph.m_rank;
            nArray[n3] = nArray[n3] + 1;
        }
        int n4 = 0;
        for (n = 0; n < nArray.length; ++n) {
            nArray2[n] = n4++;
            if (nArray[n] == 0) continue;
        }
        HiGraph[][] hiGraphArray = new HiGraph[n4][];
        n4 = 0;
        for (n = 0; n < nArray.length; ++n) {
            if (nArray[n] == 0) continue;
            hiGraphArray[n4++] = new HiGraph[nArray[n]];
            nArray[n] = 0;
        }
        for (n = 0; n < n2; ++n) {
            int n5;
            hiArc = (HiArc)vector.elementAt(n);
            hiGraph2 = hiArc.to();
            int n6 = nArray2[hiGraph2.m_rank - hiGraph.m_rank];
            hiGraph2.m_position = n5 = nArray[n6];
            hiGraphArray[n6][n5] = hiGraph2;
            int n7 = n6;
            nArray[n7] = nArray[n7] + 1;
        }
        return hiGraphArray;
    }

    static void dumpBoard(HiGraph hiGraph, HiGraph[][] hiGraphArray) {
        System.out.println("Board for " + hiGraph);
        for (int i = 0; i < hiGraphArray.length; ++i) {
            HiGraph[] hiGraphArray2 = hiGraphArray[i];
            System.out.print(i + ":");
            for (int j = 0; j < hiGraphArray2.length; ++j) {
                System.out.print("{" + j);
                if (hiGraphArray2[j].m_position != j) {
                    System.out.print("??");
                }
                System.out.print(":" + hiGraphArray2[j].m_outside + "}" + hiGraphArray2[j]);
            }
            System.out.println("");
        }
    }

    private static int rowWeight(HiGraph hiGraph) {
        int n;
        HiGraph hiGraph2;
        HiArc hiArc;
        int n2;
        Vector vector = hiGraph.m_out;
        int n3 = vector.size();
        int n4 = 0;
        int n5 = hiGraph.m_position;
        for (n2 = 0; n2 < n3; ++n2) {
            hiArc = (HiArc)vector.elementAt(n2);
            hiGraph2 = hiArc.to();
            n = hiGraph2.m_position - n5;
            if (n < 0) {
                n = -n;
            }
            n4 += n;
        }
        vector = hiGraph.m_in;
        n3 = vector.size();
        for (n2 = 0; n2 < n3; ++n2) {
            hiArc = (HiArc)vector.elementAt(n2);
            hiGraph2 = hiArc.from();
            n = hiGraph2.m_position - n5;
            if (n < 0) {
                n = -n;
            }
            n4 += n;
        }
        return n4;
    }

    private static void initBoard(HiGraph[][] hiGraphArray) {
        int n = hiGraphArray.length;
        while (n > 0) {
            HiGraph[] hiGraphArray2 = hiGraphArray[--n];
            int n2 = hiGraphArray2.length;
            while (n2 > 0) {
                HiGraph hiGraph = hiGraphArray2[--n2];
                hiGraph.m_rowweight = HiRow.rowWeight(hiGraph);
            }
        }
    }

    private static boolean shake(HiGraph[] hiGraphArray) {
        boolean bl = false;
        int n = hiGraphArray.length;
        while (n > 1) {
            HiGraph hiGraph;
            HiGraph hiGraph2 = hiGraphArray[--n];
            int n2 = hiGraph2.m_rowweight;
            int n3 = -1;
            int n4 = 0;
            int n5 = n;
            while (n5 > 0) {
                hiGraph = hiGraphArray[--n5];
                int n6 = hiGraph.m_rowweight;
                hiGraph2.m_position = n5;
                hiGraph.m_position = n;
                int n7 = HiRow.rowWeight(hiGraph2);
                int n8 = HiRow.rowWeight(hiGraph);
                hiGraph2.m_position = n;
                hiGraph.m_position = n5;
                int n9 = n2 + n6 - n7 - n8;
                if (n9 <= n4) continue;
                n3 = n5;
                n4 = n9;
            }
            if (n4 <= 0) continue;
            hiGraphArray[n] = hiGraph = hiGraphArray[n3];
            hiGraphArray[n3] = hiGraph2;
            hiGraph.m_position = n;
            hiGraph2.m_position = n3;
            hiGraph2.m_rowweight = HiRow.rowWeight(hiGraph2);
            hiGraph.m_rowweight = HiRow.rowWeight(hiGraph);
            bl = true;
        }
        return bl;
    }

    private static boolean orderchildren(HiGraphLayout hiGraphLayout, HiGraph hiGraph) throws HiGraphException {
        boolean bl;
        int n;
        Vector vector = hiGraph.m_children;
        int n2 = vector.size();
        boolean bl2 = false;
        hiGraph.m_position = 0;
        if (n2 == 0) {
            return bl2;
        }
        for (n = 0; n < n2; ++n) {
            HiArc hiArc = (HiArc)vector.elementAt(n);
            HiGraph hiGraph2 = hiArc.to();
            bl2 |= HiRow.orderchildren(hiGraphLayout, hiGraph2);
        }
        if (bl2) {
            return bl2;
        }
        if (hiGraph.dontReorder()) {
            System.out.println("Don't reorder " + hiGraph);
            return true;
        }
        HiGraph[][] hiGraphArray = HiRow.buildBoard(hiGraph);
        int n3 = hiGraphLayout.crossing();
        HiRow.initBoard(hiGraphArray);
        int n4 = hiGraphArray.length - 1;
        do {
            bl = false;
            for (n = 1; n < n4; ++n) {
                bl |= HiRow.shake(hiGraphArray[n]);
            }
            if (!bl) break;
            bl = false;
            for (n = n4; n > 0; --n) {
                bl |= HiRow.shake(hiGraphArray[n]);
            }
        } while (bl && (n3 -= n4) >= 0);
        return true;
    }

    static void order(HiGraphLayout hiGraphLayout, HiGraph hiGraph) throws HiGraphException {
        HiRow.orderchildren(hiGraphLayout, hiGraph);
    }
}

