/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.Color;
import java.awt.Graphics;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.undo.UndoableEdit;
import lsedit.Attribute;
import lsedit.AttributeValueItem;
import lsedit.Diagram;
import lsedit.LandscapeClassObject;
import lsedit.MyPaintableUndoableEdit;
import lsedit.MyUndoableEdit;

public abstract class LandscapeObject {
    public static final String COLOUR_ID = "color";
    public static final String LABEL_COLOUR_ID = "labelcolor";
    public static final String OPEN_COLOUR_ID = "opencolor";
    public static final String STYLE_ID = "style";
    private static final int MAX_RGB = 255;
    public static LandscapeObject g_infoShown = null;
    private LandscapeClassObject m_parentClass;
    private Color m_objectColor = null;
    private int m_style = -1;
    private JComponent m_swingObject;
    private Hashtable m_attributes;

    protected String qt(String string) {
        return AttributeValueItem.qt(string);
    }

    private static String taColor(Color color) {
        int n = color.getRed();
        int n2 = color.getGreen();
        int n3 = color.getBlue();
        int n4 = color.getAlpha();
        String string = "(" + n + " " + n2 + " " + n3;
        if (n4 != 255) {
            string = string + " " + n4;
        }
        string = string + ")";
        return string;
    }

    protected boolean logEdit(UndoableEdit undoableEdit) {
        return this.getDiagram().logEdit(undoableEdit);
    }

    public JComponent getSwingObject() {
        return this.m_swingObject;
    }

    public void setSwingObject(JComponent jComponent) {
        this.m_swingObject = jComponent;
    }

    public LandscapeClassObject getParentClass() {
        return this.m_parentClass;
    }

    public LandscapeClassObject derivedFrom(int n) {
        return n == 0 ? this.m_parentClass : null;
    }

    public void setParentClass(LandscapeClassObject landscapeClassObject) {
        this.m_parentClass = landscapeClassObject;
    }

    public void updateParentClass(LandscapeClassObject landscapeClassObject) {
        if (landscapeClassObject != this.m_parentClass) {
            new UpdateParentClass(this, landscapeClassObject);
        }
    }

    public Diagram getDiagram() {
        return this.m_parentClass.getDiagram();
    }

    public int getStyle() {
        return this.m_style;
    }

    public void setStyle(int n) {
        this.m_style = n;
    }

    public int getInheritedStyle() {
        int n = this.getStyle();
        if (n < 0) {
            LandscapeClassObject landscapeClassObject;
            int n2 = 0;
            while ((landscapeClassObject = this.derivedFrom(n2)) != null && (n = landscapeClassObject.getInheritedStyle()) < 0) {
                ++n2;
            }
        }
        return n;
    }

    public String getStyleName(int n) {
        return "";
    }

    public void updateStyle(int n) {
        if (n != this.m_style) {
            new UpdateStyle(this, n);
        }
    }

    public Color getColorWhenOpen() {
        return null;
    }

    public Color getInheritedColorWhenOpen() {
        return null;
    }

    public void setColorWhenOpen(Color color) {
        System.out.println("Can't setColorWhenOpen(" + color + ") on " + this);
    }

    public Color getObjectColor() {
        return this.m_objectColor;
    }

    public void setObjectColor(Color color) {
        this.m_objectColor = color;
    }

    public Color getInheritedObjectColor() {
        Color color = this.getObjectColor();
        if (color == null) {
            LandscapeClassObject landscapeClassObject;
            int n = 0;
            while ((landscapeClassObject = this.derivedFrom(n)) != null && (color = landscapeClassObject.getInheritedObjectColor()) == null) {
                ++n;
            }
        }
        return color;
    }

    public void updateObjectColor(Color color) {
        Color color2 = this.getObjectColor();
        if (color == null ? color2 == null : color.equals(color2)) {
            return;
        }
        new UpdateObjectColor(this, color);
    }

    public Color getLabelColor() {
        return null;
    }

    public Color getInheritedLabelColor() {
        return null;
    }

    public void setLabelColor(Color color) {
        System.out.println("Can't setLabelColor(" + color + ") on " + this);
    }

    public void updateLabelColor(Color color) {
        System.out.println("Can't updateLabelColor(" + color + ") on " + this);
    }

    public int getLsAttributesSize() {
        if (this.m_attributes == null) {
            return 0;
        }
        return this.m_attributes.size();
    }

    public Attribute getLsAttribute(String string) {
        if (this.m_attributes != null) {
            return (Attribute)this.m_attributes.get(string);
        }
        return null;
    }

    public Attribute getLsAttributeAt(int n) {
        if (this.m_attributes != null) {
            Enumeration enumeration = this.m_attributes.elements();
            while (enumeration.hasMoreElements()) {
                Object v = enumeration.nextElement();
                if (n == 0) {
                    return (Attribute)v;
                }
                --n;
            }
        }
        return null;
    }

    public Enumeration getLsAttributesEnum() {
        if (this.m_attributes == null) {
            return null;
        }
        return this.m_attributes.elements();
    }

    public void putLsAttribute(Attribute attribute) {
        if (this.m_attributes == null) {
            this.m_attributes = new Hashtable(5);
        }
        this.m_attributes.put(attribute.id, attribute);
    }

    public void addAttribute(Attribute attribute) {
        if (this.processFirstOrder(attribute)) {
            return;
        }
        Attribute attribute2 = this.getLsAttribute(attribute.id);
        if (attribute2 != null) {
            this.m_attributes.remove(attribute.id);
        }
        this.putLsAttribute(attribute);
    }

    public void regRawAttribute(Vector vector, Hashtable hashtable, String string, Object object, Object object2) {
        Object[] objectArray = new Object[]{hashtable.get(string), object, object2};
        vector.addElement(objectArray);
    }

    public void regRawAttribute(Vector vector, Hashtable hashtable, String string, int n) {
        this.regRawAttribute(vector, hashtable, string, Attribute.INT, new Integer(n));
    }

    public void regRawAttribute(Vector vector, Hashtable hashtable, String string, double d) {
        this.regRawAttribute(vector, hashtable, string, Attribute.DOUBLE, new Double(d));
    }

    public void regRawAttribute(Vector vector, Hashtable hashtable, String string, String string2) {
        this.regRawAttribute(vector, hashtable, string, Attribute.STRING, string2);
    }

    public void regRawAttribute(Vector vector, Hashtable hashtable, String string, int[] nArray) {
        this.regRawAttribute(vector, hashtable, string, Attribute.INT_LIST, nArray);
    }

    public void regRawAttribute(Vector vector, Hashtable hashtable, String string, double[] dArray) {
        this.regRawAttribute(vector, hashtable, string, Attribute.DOUBLE_LIST, dArray);
    }

    public void regRawAttribute(Vector vector, Hashtable hashtable, String string, String[] stringArray) {
        this.regRawAttribute(vector, hashtable, string, Attribute.STRING_LIST, stringArray);
    }

    public void regAttributeRaw(Vector vector, Hashtable hashtable, Attribute attribute, boolean bl) {
        if (attribute.avi == null) {
            if (bl) {
                this.regRawAttribute(vector, hashtable, attribute.id, Attribute.NULL, null);
            }
        } else if (bl || !attribute.m_cloneOnAssign) {
            if (attribute.avi.next != null) {
                int n = 0;
                AttributeValueItem attributeValueItem = attribute.avi;
                while (attributeValueItem != null) {
                    attributeValueItem = attributeValueItem.next;
                    ++n;
                }
                String[] stringArray = new String[n];
                attributeValueItem = attribute.avi;
                int n2 = 0;
                attributeValueItem = attribute.avi;
                while (attributeValueItem != null) {
                    stringArray[n2] = attributeValueItem.value;
                    attributeValueItem = attributeValueItem.next;
                    ++n2;
                }
                this.regRawAttribute(vector, hashtable, attribute.id, stringArray);
            } else {
                this.regRawAttribute(vector, hashtable, attribute.id, attribute.avi.value);
            }
        }
    }

    public void regRawAttribute(Vector vector, Hashtable hashtable, String string, Color color) {
        int n = color.getRed();
        int n2 = color.getGreen();
        int n3 = color.getBlue();
        double[] dArray = new double[]{(double)n / 255.0, (double)n2 / 255.0, (double)n3 / 255.0};
        this.regRawAttribute(vector, hashtable, string, dArray);
    }

    public boolean processFirstOrder(Attribute attribute) {
        if (attribute.id.equals(COLOUR_ID)) {
            this.setObjectColor(attribute.parseColor());
            return true;
        }
        if (attribute.id.equals(LABEL_COLOUR_ID)) {
            this.setLabelColor(attribute.parseColor());
            return true;
        }
        if (attribute.id.equals(OPEN_COLOUR_ID)) {
            this.setColorWhenOpen(attribute.parseColor());
            return true;
        }
        return false;
    }

    public void replaceAttribute(Attribute attribute) {
        this.addAttribute(attribute);
    }

    public void writeAttributes(PrintStream printStream, LandscapeObject landscapeObject, boolean bl) throws IOException {
        Color color;
        Color color2 = this.getObjectColor();
        if (color2 != null && !color2.equals(color = landscapeObject != null ? landscapeObject.getInheritedObjectColor() : null)) {
            printStream.print(" color = " + LandscapeObject.taColor(color2) + "\n");
        }
        if ((color2 = this.getLabelColor()) != null && !color2.equals(color = landscapeObject != null ? landscapeObject.getInheritedLabelColor() : null)) {
            printStream.print(" labelcolor = " + LandscapeObject.taColor(color2) + "\n");
        }
        if ((color2 = this.getColorWhenOpen()) != null && !(color2 = this.getInheritedColorWhenOpen()).equals(color = landscapeObject != null ? landscapeObject.getInheritedColorWhenOpen() : null)) {
            printStream.print(" opencolor = " + LandscapeObject.taColor(color2) + "\n");
        }
        if (this.m_attributes != null) {
            Enumeration enumeration = this.m_attributes.elements();
            while (enumeration.hasMoreElements()) {
                Attribute attribute = (Attribute)enumeration.nextElement();
                attribute.writeAttribute(printStream, landscapeObject, bl);
            }
        }
    }

    public int getPrimaryAttributeCount() {
        return 0;
    }

    public int getLsAttributeCount() {
        return this.getPrimaryAttributeCount() + this.getLsAttributesSize() + 1;
    }

    public boolean canEditName(int n) {
        int n2 = this.getPrimaryAttributeCount();
        return n >= n2;
    }

    public boolean canEditAttribute(int n) {
        int n2 = this.getPrimaryAttributeCount();
        if (n < n2) {
            return true;
        }
        return (n -= n2) < this.getLsAttributesSize();
    }

    public String getLsAttributeNameAt(int n) {
        if ((n -= this.getPrimaryAttributeCount()) == this.getLsAttributesSize()) {
            return "";
        }
        Attribute attribute = this.getLsAttributeAt(n);
        if (attribute == null) {
            return null;
        }
        return attribute.id;
    }

    public Object getLsAttributeValueAt(int n) {
        if ((n -= this.getPrimaryAttributeCount()) == this.getLsAttributesSize()) {
            return "";
        }
        Attribute attribute = this.getLsAttributeAt(n);
        if (attribute == null) {
            return null;
        }
        return attribute.avi;
    }

    private boolean unknownAttributeName(String string) {
        String string2;
        int n = 0;
        while ((string2 = this.getLsAttributeNameAt(n)) != null) {
            if (string.equals(string2)) {
                System.out.println("Can't rename generic attribute to '" + string + "': attribute already exists");
                return false;
            }
            ++n;
        }
        return true;
    }

    public boolean setAttributeNameAt(int n, Object object) {
        int n2 = this.getPrimaryAttributeCount();
        if (n < n2) {
            return false;
        }
        String string = (String)object;
        if ((n -= n2) == this.getLsAttributesSize()) {
            if (string.equals("")) {
                return false;
            }
            if (!this.unknownAttributeName(string)) {
                return false;
            }
            new UpdateLsAttributeName(this, null, string);
            return true;
        }
        Attribute attribute = this.getLsAttributeAt(n);
        if (attribute == null) {
            return false;
        }
        if (string.equals("")) {
            new UpdateLsAttributeName(this, attribute.id, null);
            return true;
        }
        if (string.equals(attribute.id)) {
            return false;
        }
        if (!this.unknownAttributeName(string)) {
            return false;
        }
        new UpdateLsAttributeName(this, attribute.id, string);
        return true;
    }

    public void setAttributeValueAt(int n, Object object) {
        Attribute attribute = this.getLsAttributeAt(n -= this.getPrimaryAttributeCount());
        if (attribute == null) {
            return;
        }
        new UpdateLsAttributeValue(this, attribute, (AttributeValueItem)object);
    }

    public int getLsAttributeTypeAt(int n) {
        if (n < this.getLsAttributeCount() - 1) {
            return 11;
        }
        return 0;
    }

    public int getLsAttributeOffset(String string) {
        int n = 0;
        String string2;
        while ((string2 = this.getLsAttributeNameAt(n)) != null) {
            if (string2.equals(string)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public boolean defaultValue(String string, Object object) {
        Object object2;
        int n;
        return object != null && (n = this.getLsAttributeOffset(string)) >= 0 && object.equals(object2 = this.getLsAttributeValueAt(n));
    }

    class UpdateLsAttributeValue
    extends MyUndoableEdit
    implements UndoableEdit {
        LandscapeObject m_o;
        AttributeValueItem m_oldValue;
        AttributeValueItem m_newValue;
        Attribute m_attribute;

        UpdateLsAttributeValue(LandscapeObject landscapeObject2, Attribute attribute, AttributeValueItem attributeValueItem) {
            this.m_o = landscapeObject2;
            this.m_attribute = attribute;
            this.m_oldValue = attribute.avi;
            this.m_newValue = attributeValueItem;
            if (LandscapeObject.this.logEdit(this)) {
                this.redo();
            }
        }

        public String getPresentationName() {
            if (this.m_newValue == null) {
                return this.m_o + " remove Attribute " + this.m_attribute.id + " value";
            }
            if (this.m_oldValue == null) {
                return this.m_o + " add Attribute " + this.m_attribute.id + " value";
            }
            return this.m_o + " replace Attribute " + this.m_attribute.id + " value";
        }

        public void undo() {
            this.m_attribute.avi = this.m_oldValue;
        }

        public void redo() {
            this.m_attribute.avi = this.m_newValue;
        }
    }

    class UpdateLsAttributeName
    extends MyUndoableEdit
    implements UndoableEdit {
        LandscapeObject m_o;
        String m_oldName;
        String m_newName;
        Attribute m_attribute;

        protected void exchange(String string, String string2) {
            if (string != null) {
                LandscapeObject.this.m_attributes.remove(string);
            }
            if (string2 != null) {
                this.m_attribute.id = string2;
                LandscapeObject.this.putLsAttribute(this.m_attribute);
            } else if (LandscapeObject.this.getLsAttributesSize() == 0) {
                LandscapeObject.this.m_attributes = null;
            }
        }

        UpdateLsAttributeName(LandscapeObject landscapeObject2, String string, String string2) {
            this.m_o = landscapeObject2;
            if (string != null) {
                this.m_attribute = LandscapeObject.this.getLsAttribute(string);
                if (this.m_attribute == null) {
                    string = null;
                }
            }
            if (string == null) {
                if (string2 == null) {
                    return;
                }
                this.m_attribute = new Attribute(string2, null);
            } else if (string.equals(string2)) {
                return;
            }
            this.m_newName = string2;
            if (LandscapeObject.this.logEdit(this)) {
                this.exchange(this.m_oldName, this.m_newName);
            }
        }

        public String getPresentationName() {
            if (this.m_newName == null) {
                return this.m_o + " delete Attribute " + this.m_oldName;
            }
            if (this.m_oldName == null) {
                return this.m_o + " create Attribute " + this.m_newName;
            }
            return this.m_o + " rename Attribute " + this.m_oldName + " to " + this.m_newName;
        }

        public void undo() {
            this.exchange(this.m_newName, this.m_oldName);
        }

        public void redo() {
            this.exchange(this.m_oldName, this.m_newName);
        }
    }

    class UpdateStyle
    extends MyUndoableEdit
    implements UndoableEdit {
        LandscapeObject m_o;
        int m_old;
        int m_new;

        UpdateStyle(LandscapeObject landscapeObject2, int n) {
            this.m_o = landscapeObject2;
            this.m_old = landscapeObject2.getStyle();
            this.m_new = n;
            if (LandscapeObject.this.logEdit(this)) {
                landscapeObject2.setStyle(n);
            }
        }

        public String getPresentationName() {
            return this.m_o + " Style " + this.m_o.getStyleName(this.m_new);
        }

        public void undo() {
            this.m_o.setStyle(this.m_old);
        }

        public void redo() {
            this.m_o.setStyle(this.m_new);
        }
    }

    class UpdateObjectColor
    extends MyPaintableUndoableEdit
    implements UndoableEdit {
        LandscapeObject m_o;
        Color m_old;
        Color m_new;

        UpdateObjectColor(LandscapeObject landscapeObject2, Color color) {
            this.m_o = landscapeObject2;
            this.m_old = landscapeObject2.getObjectColor();
            this.m_new = color;
            if (LandscapeObject.this.logEdit(this)) {
                landscapeObject2.setObjectColor(color);
            }
        }

        public String getPresentationName() {
            return this.m_o + " ObjectColor ";
        }

        public void undo() {
            this.m_o.setObjectColor(this.m_old);
        }

        public void redo() {
            this.m_o.setObjectColor(this.m_new);
        }

        public void paintComponent(Graphics graphics, int n, int n2) {
            this.paintComponentColor(graphics, n, n2, this.m_new);
        }

        public int getPreferredWidth() {
            return this.getPreferredWidthColor(this.m_o);
        }
    }

    class UpdateParentClass
    extends MyUndoableEdit
    implements UndoableEdit {
        LandscapeObject m_o;
        LandscapeClassObject m_old;
        LandscapeClassObject m_new;

        UpdateParentClass(LandscapeObject landscapeObject2, LandscapeClassObject landscapeClassObject) {
            this.m_o = landscapeObject2;
            this.m_old = landscapeObject2.m_parentClass;
            this.m_new = landscapeClassObject;
            if (LandscapeObject.this.logEdit(this)) {
                landscapeObject2.m_parentClass = landscapeClassObject;
            }
        }

        public String getPresentationName() {
            return this.m_o + " ParentClass " + this.m_new;
        }

        public void undo() {
            this.m_o.m_parentClass = this.m_old;
        }

        public void redo() {
            this.m_o.m_parentClass = this.m_new;
        }
    }
}

