/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.Graphics;
import java.util.Vector;
import lsedit.Diagram;
import lsedit.EntityInstance;
import lsedit.LandscapeEditorCore;
import lsedit.LandscapeLayouter;
import lsedit.MatrixConfigure;
import lsedit.SortVector;
import lsedit.ToolBarEventHandler;
import lsedit.Util;

public class MatrixLayout
extends LandscapeLayouter
implements ToolBarEventHandler {
    public static final double BORDER = 0.0333;
    public static final double XGAP = 0.2;
    public static final double YGAP = 0.2;
    protected static double m_border = 0.0333;
    protected static double m_xgap = 0.2;
    protected static double m_ygap = 0.2;

    public MatrixLayout(LandscapeEditorCore landscapeEditorCore) {
        super(landscapeEditorCore);
    }

    public String getName() {
        return "Matrix";
    }

    public String getMenuLabel() {
        return "Layout in a matrix";
    }

    public static double getBorder() {
        return m_border;
    }

    public void setBorder(double d) {
        m_border = d;
    }

    public static double getXGap() {
        return m_xgap;
    }

    public void setXGap(double d) {
        m_xgap = d;
    }

    public static double getYGap() {
        return m_ygap;
    }

    public void setYGap(double d) {
        m_ygap = d;
    }

    public boolean isConfigurable() {
        return true;
    }

    public void configure(LandscapeEditorCore landscapeEditorCore) {
        MatrixConfigure matrixConfigure = new MatrixConfigure(this, 0.0333, 0.2, 0.2, m_border, m_xgap, m_ygap);
        matrixConfigure.dispose();
    }

    public void doLayout1(Vector vector, EntityInstance entityInstance, boolean bl) {
        double d;
        double d2;
        double d3;
        double d4;
        EntityInstance entityInstance2;
        int n;
        int n2;
        int n3 = vector.size();
        if (m_border < 0.0 || m_xgap < 0.0 || m_ygap < 0.0) {
            this.m_ls.error("MatrixLayout: some parameters -ve");
            return;
        }
        if (m_xgap + m_border >= 1.0) {
            this.m_ls.error("MatrixLayout: no space to layout horizontally");
            return;
        }
        if (m_ygap + m_border >= 1.0) {
            this.m_ls.error("MatrixLayout: no space to layout vertically");
            return;
        }
        double d5 = m_border / 2.0;
        double d6 = m_border / 2.0;
        switch (n3) {
            case 0: {
                return;
            }
            case 1: {
                n2 = 1;
                break;
            }
            default: {
                n2 = (int)Math.ceil(Math.sqrt(n3));
            }
        }
        int n4 = n2;
        EntityInstance entityInstance3 = null;
        for (n = 0; n < n3; ++n) {
            entityInstance2 = (EntityInstance)vector.elementAt(n);
            EntityInstance entityInstance4 = entityInstance2.getContainedBy();
            if (entityInstance4 == null) {
                System.out.println("MatrixLayout: Entity " + entityInstance2 + " has no parent");
                continue;
            }
            if (entityInstance3 == null) {
                entityInstance3 = entityInstance4;
                continue;
            }
            if (entityInstance3 == entityInstance4) continue;
            System.out.println("MatrixLayout: Entity " + entityInstance2 + " has different parent from other entities being laid out");
        }
        if (entityInstance3 == null) {
            return;
        }
        double d7 = entityInstance3.getWidth();
        Graphics graphics = this.m_ls.getGraphics();
        block5: while (true) {
            int n5;
            int n6;
            double d8;
            int n7;
            if (n2 == 1) {
                d4 = 0.0;
                d3 = 1.0 - m_border;
            } else {
                n7 = n2 - 1;
                d8 = n7;
                d4 = m_ygap / d8;
                d3 = (1.0 - m_ygap - m_border) / (d8 + 1.0);
            }
            if (n4 == 1) {
                d2 = 0.0;
                d = 1.0 - m_border;
                break;
            }
            n7 = n4 - 1;
            d8 = n7;
            d2 = m_xgap / d8;
            d = (1.0 - m_xgap - m_border) / (d8 + 1.0);
            if (d7 <= 0.0) break;
            for (n = 0; n < n3 && (n6 = (int)(d * d7)) >= (n5 = (entityInstance2 = (EntityInstance)vector.elementAt(n)).getMinFitWidth(graphics)); ++n) {
            }
            if (n == n3) break;
            --n4;
            while (true) {
                if (n2 * n4 >= n3) continue block5;
                ++n2;
            }
            break;
        }
        SortVector.byString(vector, true);
        double d9 = 0.0;
        int n8 = 0;
        int n9 = 0;
        for (n = 0; n < n3; ++n) {
            entityInstance2 = (EntityInstance)vector.elementAt(n);
            double d10 = d5;
            if (n8 != 0) {
                d10 += (double)n8 * (d + d2);
            }
            d9 = d10;
            double d11 = d6;
            if (n9 != 0) {
                d11 += (double)n9 * (d3 + d4);
            }
            if (bl) {
                entityInstance2.updateRelLocal(d10, d11, d, d3);
            } else {
                entityInstance2.setRelLocal(d10, d11, d, d3);
            }
            if (++n8 != n4) continue;
            ++n9;
            n8 = 0;
        }
    }

    public String doLayout(Diagram diagram) {
        this.m_ls.setLayouter(this);
        this.m_ls.setCursor(3);
        Vector vector = diagram.getGroup();
        if (vector == null) {
            Util.beep();
            return "No group selected";
        }
        String string = this.allInDiagram(vector);
        if (string != null) {
            return string;
        }
        EntityInstance entityInstance = this.parentOfSet(vector);
        if (entityInstance == null) {
            return "Matrix layouter requires that all things laid out share same parent";
        }
        diagram.beginUndoRedo("Matrix layout");
        this.doLayout1(vector, entityInstance, true);
        diagram.endUndoRedo();
        this.m_ls.setCursor(0);
        return "Graph redrawn using Matrix Layout";
    }

    public void processKeyEvent(int n, int n2, Object object) {
        Diagram diagram = this.m_ls.getDiagram();
        if (diagram != null) {
            String string = this.doLayout(diagram);
            this.m_ls.doFeedback(string);
            diagram.rescaleDiagram();
            this.m_ls.repaintDg();
        }
    }
}

