/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import lsedit.Diagram;
import lsedit.EdgePoint;
import lsedit.EditModeHandler;
import lsedit.EntityInstance;
import lsedit.LandscapeModeHandler;
import lsedit.RealPoint;
import lsedit.RelationInstance;

public class MoveModeHandler
extends LandscapeModeHandler {
    protected DrawOutline m_drawOutline;
    protected EditModeHandler m_parent;
    protected EdgePoint m_ept;
    protected int m_active = 0;
    protected int m_cursor = 0;

    protected EdgePoint overEdgePoint(Object object, int n, int n2) {
        EdgePoint edgePoint = null;
        if (object instanceof RelationInstance) {
            RelationInstance relationInstance = (RelationInstance)object;
            edgePoint = relationInstance.mouseOverEdgePoint(n, n2);
        }
        return edgePoint;
    }

    protected RealPoint getFactors(int n, int n2) {
        double d;
        double d2;
        Rectangle rectangle = this.m_ept.getEntity().getDiagramBounds();
        double d3 = n;
        double d4 = n2;
        double d5 = Math.abs(d3 - (double)rectangle.x);
        double d6 = Math.abs(d3 - (double)(rectangle.x + rectangle.width));
        double d7 = Math.abs(d4 - (double)rectangle.y);
        double d8 = Math.abs(d4 - (double)(rectangle.y + rectangle.height));
        if (d5 < d6) {
            if (d7 < d8) {
                if (d7 < d5) {
                    d2 = (d3 - (double)rectangle.x) / (double)rectangle.width;
                    d = 0.0;
                } else {
                    d2 = 0.0;
                    d = (d4 - (double)rectangle.y) / (double)rectangle.height;
                }
            } else if (d8 < d5) {
                d2 = (d3 - (double)rectangle.x) / (double)rectangle.width;
                d = 1.0;
            } else {
                d2 = 0.0;
                d = (d4 - (double)rectangle.y) / (double)rectangle.height;
            }
        } else if (d7 < d8) {
            if (d7 < d6) {
                d2 = (d3 - (double)rectangle.x) / (double)rectangle.width;
                d = 0.0;
            } else {
                d2 = 1.0;
                d = (d4 - (double)rectangle.y) / (double)rectangle.height;
            }
        } else if (d8 < d6) {
            d2 = (d3 - (double)rectangle.x) / (double)rectangle.width;
            d = 1.0;
        } else {
            d2 = 1.0;
            d = (d4 - (double)rectangle.y) / (double)rectangle.height;
        }
        d2 = Math.max(0.0, Math.min(1.0, d2));
        d = Math.max(0.0, Math.min(1.0, d));
        return new RealPoint(d2, d);
    }

    protected boolean moveIOStart(int n, int n2) {
        Diagram diagram = this.m_ls.getDiagram();
        this.m_active = 2;
        this.m_ls.setCursor(1);
        this.m_drawOutline.setBounds(0, 0, diagram.getWidth(), diagram.getHeight());
        this.m_drawOutline.setVisible(true);
        diagram.add((Component)this.m_drawOutline, 0);
        RealPoint realPoint = this.getFactors(n, n2);
        this.m_ls.doFeedback("I/O point at factors (" + realPoint.getX() + ", " + realPoint.getY() + ")");
        return true;
    }

    protected void moveIOMotion(int n, int n2) {
        RealPoint realPoint = this.getFactors(n, n2);
        this.m_ls.setCursor(1);
        this.m_ept.m_wf = realPoint.getX();
        this.m_ept.m_hf = realPoint.getY();
        this.m_ept.isDefault = false;
        this.m_ept.rescale();
        this.m_ept.computeRelationBounds();
        this.m_drawOutline.repaint();
        this.m_ls.doFeedback("I/O point at factors (" + this.m_ept.getX() + "/" + realPoint.getX() + ", " + this.m_ept.getY() + "/" + realPoint.getY() + ")");
    }

    public MoveModeHandler(EditModeHandler editModeHandler) {
        super(editModeHandler.m_ls);
        this.m_parent = editModeHandler;
        this.m_drawOutline = new DrawOutline();
    }

    public void cleanup() {
        this.m_ept = null;
        switch (this.m_active) {
            case 2: {
                Diagram diagram = this.m_ls.getDiagram();
                this.m_drawOutline.setVisible(false);
                diagram.remove(this.m_drawOutline);
            }
            case 1: {
                this.m_active = 0;
                if (this.m_cursor == 0) break;
                this.m_cursor = 0;
                this.m_ls.setCursor(this.m_cursor);
            }
        }
    }

    public void movedOverThing(MouseEvent mouseEvent, Object object, int n, int n2) {
        switch (this.m_active) {
            case 0: {
                this.m_ept = this.overEdgePoint(object, n, n2);
                if (this.m_ept == null) {
                    return;
                }
                this.m_cursor = 1;
                this.m_parent.setSubHandler(this);
                this.m_active = 1;
                break;
            }
            case 1: {
                this.m_ept = this.overEdgePoint(object, n, n2);
                if (this.m_ept != null) break;
                this.m_active = 0;
                this.m_parent.cleanup();
                return;
            }
        }
        this.m_ls.setCursor(this.m_cursor);
    }

    public void entityPressed(MouseEvent mouseEvent, EntityInstance entityInstance, int n, int n2) {
        if (this.m_active == 1) {
            this.moveIOStart(n, n2);
        }
    }

    public void relationPressed(MouseEvent mouseEvent, RelationInstance relationInstance, int n, int n2) {
        this.movedOverThing(mouseEvent, relationInstance, n, n2);
        if (this.m_active == 1) {
            this.moveIOStart(n, n2);
        }
    }

    public void relationDragged(MouseEvent mouseEvent, RelationInstance relationInstance, int n, int n2) {
        if (this.m_ept != null) {
            this.moveIOMotion(n, n2);
        }
    }

    public void relationReleased(MouseEvent mouseEvent, RelationInstance relationInstance, int n, int n2) {
        this.m_ls.clearFeedback();
        if (this.m_ept != null) {
            this.m_ls.redrawDg();
        }
        this.m_parent.cleanup();
    }

    protected class DrawOutline
    extends JComponent {
        public DrawOutline() {
            this.setForeground(Color.BLACK);
        }

        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            if (MoveModeHandler.this.m_ept != null) {
                graphics.drawOval((int)MoveModeHandler.this.m_ept.m_x - 6, (int)MoveModeHandler.this.m_ept.m_y - 6, 12, 12);
            }
        }
    }
}

