/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.Color;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Vector;
import lsedit.Attribute;
import lsedit.Diagram;
import lsedit.EntityClass;
import lsedit.EntityClassPair;
import lsedit.EntityInstance;
import lsedit.LandscapeClassObject;
import lsedit.RelationInstance;
import lsedit.Util;

public class RelationClass
extends LandscapeClassObject {
    protected static final String FACTOR_ID = "class_iofactor";
    protected static final String HIERARCHY_ID = "class_hierarchy";
    protected static final String ACTIVE_ID = "class_active";
    protected static final String VISIBLE_ID = "class_visible";
    protected static final String ISCONTAINS_ID = "class_iscontains";
    protected static final String RELATION_BASE_CLASS_ID = "$RELATION";
    protected boolean m_active = true;
    protected boolean m_visible = true;
    protected boolean m_contains = false;
    protected double m_iofactor = -1.0;
    protected int m_cIndex = -1;
    private Vector m_relationList = new Vector();
    protected int m_ordinal;

    public RelationClass(String string, int n, Diagram diagram) {
        this.setId(string);
        this.setNid(n);
        this.setLabel(string);
        this.setLandscapeObjectDiagram(diagram);
        this.setStyle(0);
        this.setObjectColor(Color.black);
    }

    public int getCIndex() {
        return this.m_cIndex;
    }

    public void setCIndex(int n) {
        this.m_cIndex = n;
    }

    public String getStyleName(int n) {
        return Util.getLineStyleName(n);
    }

    public void setContainsClass(boolean bl) {
        this.m_contains = bl;
    }

    public boolean isContainsClass() {
        return this.m_contains;
    }

    protected boolean processClassAttributes(Attribute attribute) {
        if (attribute.id.equals(HIERARCHY_ID)) {
            this.m_cIndex = Integer.parseInt(attribute.avi.value);
            return true;
        }
        if (attribute.id.equals(FACTOR_ID)) {
            this.m_iofactor = Double.parseDouble(attribute.avi.value);
            return true;
        }
        if (attribute.id.equals(ACTIVE_ID)) {
            this.m_active = Util.parseBoolean(attribute.avi.value);
            return true;
        }
        if (attribute.id.equals(VISIBLE_ID)) {
            this.m_visible = Util.parseBoolean(attribute.avi.value);
            return true;
        }
        if (attribute.id.equals(ISCONTAINS_ID)) {
            this.m_contains = Util.parseBoolean(attribute.avi.value);
            return true;
        }
        return super.processClassAttributes(attribute);
    }

    public void addRelation(EntityClass entityClass, EntityClass entityClass2) {
        EntityClassPair entityClassPair = new EntityClassPair(entityClass, entityClass2);
        if (this.m_relationList == null) {
            this.m_relationList = new Vector();
        }
        this.m_relationList.addElement(entityClassPair);
    }

    public RelationInstance newRelation(EntityInstance entityInstance, EntityInstance entityInstance2) {
        RelationInstance relationInstance = new RelationInstance(this, entityInstance, entityInstance2);
        this.makeInstanceOfUs(relationInstance);
        return relationInstance;
    }

    public void writeRelations(PrintStream printStream) throws IOException {
        Enumeration enumeration = this.m_relationList.elements();
        while (enumeration.hasMoreElements()) {
            EntityClassPair entityClassPair = (EntityClassPair)enumeration.nextElement();
            printStream.print(this.qt(this.getId()) + " " + this.qt(entityClassPair.entityClass1.getId()) + " " + this.qt(entityClassPair.entityClass2.getId()) + "\n");
        }
    }

    public void writeAttributes(PrintStream printStream) throws IOException {
        if (this.getNid() >= 2) {
            printStream.print("(" + this.qt(this.getId()) + ") {\n");
            if (this.m_cIndex >= 0) {
                printStream.print("class_hierarchy = " + this.m_cIndex + " ");
            }
            if (this.m_iofactor >= 0.0) {
                printStream.print("class_iofactor = " + this.m_iofactor + " ");
            }
            if (!this.m_active) {
                printStream.print("class_active = false ");
            }
            if (!this.m_visible) {
                printStream.print("class_visible = false ");
            }
            if (this.m_contains) {
                printStream.print("class_iscontains = true ");
            }
            super.writeAttributes(printStream);
            printStream.print("}\n\n");
        }
    }

    public boolean isClassVisible() {
        return this.m_visible && !this.m_contains;
    }

    public void setClassVisible(boolean bl) {
        this.m_visible = bl;
    }

    public boolean isActive() {
        return this.m_active;
    }

    public void setActiveState(boolean bl) {
        this.m_active = bl;
    }

    public void setOrdinal(int n) {
        this.m_ordinal = n;
    }

    public double getIOfactor() {
        if (this.m_iofactor >= 0.0) {
            return this.m_iofactor;
        }
        Diagram diagram = this.getDiagram();
        if (diagram.allowElision()) {
            double d = diagram.numVisibleRelationClasses();
            return (double)(this.m_ordinal + 1) / (d + 1.0);
        }
        double d = diagram.numRelationClasses();
        return d > 2.0 ? (double)(this.getNid() - 1) / (d - 1.0) : 0.5;
    }

    public void setIOfactor(double d) {
        this.m_iofactor = d;
    }

    public int getPrimaryAttributeCount() {
        return 7;
    }

    public String getLsAttributeNameAt(int n) {
        String string;
        switch (n) {
            case 0: {
                string = "id";
                break;
            }
            case 1: {
                string = "class_label";
                break;
            }
            case 2: {
                string = "class_description";
                break;
            }
            case 3: {
                string = "class_style";
                break;
            }
            case 4: {
                string = "color";
                break;
            }
            case 5: {
                string = "labelcolor";
                break;
            }
            case 6: {
                string = FACTOR_ID;
                break;
            }
            default: {
                string = super.getLsAttributeNameAt(n);
            }
        }
        return string;
    }

    public Object getLsAttributeValueAt(int n) {
        Object object;
        switch (n) {
            case 0: {
                object = this.getId();
                break;
            }
            case 1: {
                object = this.getLabel();
                break;
            }
            case 2: {
                object = this.getDescription();
                break;
            }
            case 3: {
                object = new Integer(this.getStyle());
                break;
            }
            case 4: {
                object = this.getObjectColor();
                break;
            }
            case 5: {
                object = this.getLabelColor();
                break;
            }
            case 6: {
                object = new Double(this.m_iofactor);
                break;
            }
            default: {
                object = super.getLsAttributeValueAt(n);
            }
        }
        return object;
    }

    public void setAttributeValueAt(int n, Object object) {
        switch (n) {
            case 0: {
                this.setId((String)object);
                break;
            }
            case 1: {
                this.updateLabel((String)object);
                break;
            }
            case 2: {
                this.updateDescription((String)object);
                break;
            }
            case 3: {
                this.updateStyle((Integer)object);
                break;
            }
            case 4: {
                this.updateObjectColor((Color)object);
                break;
            }
            case 5: {
                this.updateLabelColor((Color)object);
                break;
            }
            case 6: {
                this.m_iofactor = (Double)object;
                break;
            }
            default: {
                super.setAttributeValueAt(n, object);
            }
        }
    }

    public int getLsAttributeTypeAt(int n) {
        int n2;
        switch (n) {
            case 0: 
            case 1: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 12;
                break;
            }
            case 3: {
                n2 = 14;
                break;
            }
            case 4: {
                n2 = 8;
                break;
            }
            case 5: {
                n2 = 7;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
            default: {
                n2 = super.getLsAttributeTypeAt(n);
            }
        }
        return n2;
    }
}

