/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import lsedit.Diagram;
import lsedit.EditModeHandler;
import lsedit.EntityInstance;
import lsedit.LandscapeModeHandler;

public class ResizeModeHandler
extends LandscapeModeHandler {
    protected static final int[] resizeCursor = new int[]{6, 8, 7, 11, 5, 9, 4, 10};
    protected static final int RM_NONE = 0;
    protected static final int RM_LEFT = 1;
    protected static final int RM_RIGHT = 2;
    protected static final int RM_TOP = 4;
    protected static final int RM_BOTTOM = 8;
    protected static final int LR_MASK = 3;
    protected static final int TB_MASK = 12;
    protected static final int RZONE_SIZE = 5;
    protected static final double MIN_DIM = 10.0;
    protected EditModeHandler m_parent;
    protected int m_zn;
    protected DrawOutline m_drawOutline;
    protected Rectangle m_curLayout;
    private Rectangle m_plyt = null;
    protected int m_resizeMode = 0;
    protected int m_cursor = 0;
    protected int[] startMode = new int[]{5, 4, 6, 2, 10, 8, 9, 1};

    protected int overResizeTab(Object object, int n, int n2) {
        Diagram diagram;
        EntityInstance entityInstance;
        int n3 = -1;
        if (object instanceof EntityInstance && (entityInstance = (EntityInstance)object) != (diagram = this.m_ls.getDiagram()).getDrawRoot() && entityInstance.getGroupKeyFlag()) {
            n3 = entityInstance.overResizeTab(n, n2);
        }
        return n3;
    }

    protected void setCurLayout(int n, int n2, int n3, int n4) {
        if (this.m_curLayout == null) {
            Diagram diagram = this.m_ls.getDiagram();
            this.m_curLayout = new Rectangle(n, n2, n3, n4);
            this.m_drawOutline.setBounds(0, 0, diagram.getWidth(), diagram.getHeight());
            this.m_drawOutline.setVisible(true);
            diagram.add((Component)this.m_drawOutline, 0);
        } else {
            this.m_curLayout.x = n;
            this.m_curLayout.y = n2;
            this.m_curLayout.width = n3;
            this.m_curLayout.height = n4;
            this.m_drawOutline.repaint();
        }
    }

    protected void addMode(int n) {
        int n2 = 0;
        switch (n) {
            case 4: {
                n2 = 8;
                break;
            }
            case 8: {
                n2 = 4;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 1;
            }
        }
        if ((this.m_resizeMode & n2) == 0) {
            this.m_resizeMode |= n;
        }
    }

    private String resizeDescription() {
        String string;
        if (this.m_resizeMode == 0) {
            string = "NONE";
        } else {
            string = "";
            if ((this.m_resizeMode & 1) != 0) {
                string = string + "LEFT ";
            }
            if ((this.m_resizeMode & 2) != 0) {
                string = string + "RIGHT ";
            }
            if ((this.m_resizeMode & 4) != 0) {
                string = string + "TOP ";
            }
            if ((this.m_resizeMode & 8) != 0) {
                string = string + "BOTTOM";
            }
        }
        return string;
    }

    protected void doResizeAdjust(int n, int n2, int n3) {
        int n4 = 20;
        int n5 = this.m_curLayout.x;
        int n6 = this.m_curLayout.y;
        int n7 = this.m_curLayout.width;
        int n8 = this.m_curLayout.height;
        if (n2 - n5 < 4) {
            this.addMode(1);
        }
        if (n5 + n7 - n2 < 4) {
            this.addMode(2);
        }
        if (n3 - n6 < 4) {
            this.addMode(4);
        }
        if (n6 + n8 - n3 < 4) {
            this.addMode(8);
        }
        if ((n & 4) != 0) {
            if (n3 >= this.m_plyt.y + n4) {
                n8 += n6 - n3;
                n6 = n3;
            }
        } else if ((n & 8) != 0 && n3 <= this.m_plyt.y + this.m_plyt.height - n4) {
            n8 = n3 - n6;
        }
        if ((n & 1) != 0) {
            if (n2 >= this.m_plyt.x + n4) {
                n7 += n5 - n2;
                n5 = n2;
            }
        } else if ((n & 2) != 0 && n2 <= this.m_plyt.x + this.m_plyt.width - n4) {
            n7 = n2 - n5;
        }
        if ((double)n7 < 10.0) {
            n5 = this.m_curLayout.x;
            n7 = this.m_curLayout.width;
        }
        if ((double)n8 < 10.0) {
            n6 = this.m_curLayout.y;
            n8 = this.m_curLayout.height;
        }
        this.setCurLayout(n5, n6, n7, n8);
    }

    public ResizeModeHandler(EditModeHandler editModeHandler) {
        super(editModeHandler.m_ls);
        this.m_parent = editModeHandler;
        this.m_drawOutline = new DrawOutline();
    }

    public Rectangle getCurLayout() {
        return this.m_curLayout;
    }

    public void cleanup() {
        if (this.m_curLayout != null) {
            Diagram diagram = this.m_ls.getDiagram();
            diagram.remove(this.m_drawOutline);
            this.m_curLayout = null;
        }
        if (this.m_cursor != 0) {
            this.m_cursor = 0;
            this.m_ls.setCursor(this.m_cursor);
        }
    }

    public void movedOverThing(MouseEvent mouseEvent, Object object, int n, int n2) {
        this.m_zn = this.overResizeTab(object, n, n2);
        if (this.m_parent.getSubHandler() != this) {
            if (this.m_zn != -1) {
                this.m_cursor = resizeCursor[this.m_zn];
                this.m_ls.setCursor(this.m_cursor);
                this.m_parent.setSubHandler(this);
            }
        } else if (this.m_zn == -1) {
            this.m_parent.cleanup();
        }
    }

    public void entityPressed(MouseEvent mouseEvent, EntityInstance entityInstance, int n, int n2) {
        EntityInstance entityInstance2;
        this.movedOverThing(mouseEvent, entityInstance, n, n2);
        if (this.m_zn == -1) {
            return;
        }
        Diagram diagram = this.m_ls.getDiagram();
        if (diagram == null) {
            return;
        }
        this.m_resizeMode = this.startMode[this.m_zn];
        this.setCurLayout(entityInstance.getDiagramX(), entityInstance.getDiagramY(), entityInstance.getWidth(), entityInstance.getHeight());
        if (this.m_plyt == null) {
            this.m_plyt = new Rectangle();
        }
        if ((entityInstance2 = entityInstance.getContainedBy()) != null && entityInstance2.getContainedBy() != null) {
            Rectangle rectangle = entityInstance2.getDiagramBounds();
            this.m_plyt.x = rectangle.x;
            this.m_plyt.y = rectangle.y;
            this.m_plyt.width = rectangle.width;
            this.m_plyt.height = rectangle.height;
        } else {
            this.m_plyt = diagram.getBounds();
            this.m_plyt.x = 0;
            this.m_plyt.y = 0;
        }
        this.m_ls.doFeedback("Size: " + this.m_curLayout.width + " x " + this.m_curLayout.height);
    }

    public void entityDragged(MouseEvent mouseEvent, EntityInstance entityInstance, int n, int n2) {
        double d = n;
        double d2 = n2;
        if (this.m_resizeMode == 0) {
            boolean bl = d <= (double)this.m_curLayout.x;
            boolean bl2 = d >= (double)(this.m_curLayout.x + this.m_curLayout.width);
            boolean bl3 = d2 <= (double)this.m_curLayout.y;
            boolean bl4 = d2 >= (double)(this.m_curLayout.y + this.m_curLayout.height);
            Diagram diagram = this.m_ls.getDiagram();
            if (entityInstance == diagram.getDrawRoot()) {
                bl = false;
                bl3 = false;
            }
            if (bl) {
                this.m_resizeMode = bl3 || d2 - (double)this.m_curLayout.y < 4.0 ? 5 : (bl4 || (double)(this.m_curLayout.y + this.m_curLayout.height) - d2 < 4.0 ? 9 : 1);
            } else if (bl2) {
                this.m_resizeMode = bl3 || d2 - (double)this.m_curLayout.y < 4.0 ? 6 : (bl4 || (double)(this.m_curLayout.y + this.m_curLayout.height) - d2 < 4.0 ? 10 : 2);
            } else if (bl3) {
                this.m_resizeMode = d - (double)this.m_curLayout.x < 4.0 ? 5 : ((double)(this.m_curLayout.x + this.m_curLayout.width) - d < 4.0 ? 6 : 4);
            } else if (bl4) {
                this.m_resizeMode = d - (double)this.m_curLayout.x < 4.0 ? 9 : ((double)(this.m_curLayout.x + this.m_curLayout.width) - d < 4.0 ? 10 : 8);
            }
        }
        if (this.m_resizeMode != 0) {
            this.doResizeAdjust(this.m_resizeMode, n, n2);
            this.m_ls.doFeedback("Size: " + this.m_curLayout.width + " x " + this.m_curLayout.height);
        }
    }

    public void entityReleased(MouseEvent mouseEvent, EntityInstance entityInstance, int n, int n2) {
        if (entityInstance != null) {
            Diagram diagram = this.m_ls.getDiagram();
            entityInstance.updateDiagramBounds(this.m_curLayout);
            diagram.rescaleDiagram();
            entityInstance.validateEdges();
        }
        this.m_ls.clearFeedback();
        this.m_parent.cleanup();
    }

    protected class DrawOutline
    extends JComponent {
        public DrawOutline() {
            this.setForeground(Color.BLACK);
        }

        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            Rectangle rectangle = ResizeModeHandler.this.getCurLayout();
            if (rectangle != null) {
                graphics.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
        }
    }
}

