/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.util.Enumeration;
import java.util.Vector;
import lsedit.Diagram;
import lsedit.EntityInstance;
import lsedit.HiArc;
import lsedit.HiGraph;
import lsedit.HiGraphLayout;
import lsedit.LandscapeEditorCore;
import lsedit.LandscapeLayouter;
import lsedit.RelationClass;
import lsedit.RelationInstance;
import lsedit.ToolBarEventHandler;
import lsedit.Util;

public class SimplexLayout
extends LandscapeLayouter
implements ToolBarEventHandler {
    public SimplexLayout(LandscapeEditorCore landscapeEditorCore) {
        super(landscapeEditorCore);
    }

    public String getName() {
        return "Simplex";
    }

    public String getMenuLabel() {
        return "Layout using Simplex algorithm";
    }

    protected static int edgesBetween(EntityInstance entityInstance, EntityInstance entityInstance2) {
        EntityInstance entityInstance3;
        int n = 0;
        Enumeration enumeration = entityInstance.srcLiftedRelationElements();
        while (enumeration.hasMoreElements()) {
            RelationInstance relationInstance = (RelationInstance)enumeration.nextElement();
            RelationClass relationClass = relationInstance.getRelationClass();
            if (!relationClass.isClassVisible() || !entityInstance2.hasDescendantOrSelf(entityInstance3 = relationInstance.getDrawDst())) continue;
            ++n;
        }
        if (entityInstance.isOpen()) {
            enumeration = entityInstance.getChildren();
            while (enumeration.hasMoreElements()) {
                entityInstance3 = (EntityInstance)enumeration.nextElement();
                n += SimplexLayout.edgesBetween(entityInstance3, entityInstance2);
            }
        }
        return n;
    }

    protected static int edgesFromClient(EntityInstance entityInstance) {
        EntityInstance entityInstance2;
        int n = 0;
        Enumeration enumeration = entityInstance.dstLiftedRelationElements();
        while (enumeration.hasMoreElements()) {
            RelationInstance relationInstance = (RelationInstance)enumeration.nextElement();
            entityInstance2 = relationInstance.getDrawSrc();
            if (!entityInstance2.isMarked(2)) continue;
            ++n;
        }
        if (entityInstance.isOpen()) {
            enumeration = entityInstance.getChildren();
            while (enumeration.hasMoreElements()) {
                entityInstance2 = (EntityInstance)enumeration.nextElement();
                n += SimplexLayout.edgesFromClient(entityInstance2);
            }
        }
        return n;
    }

    protected static int edgesToSupplier(EntityInstance entityInstance) {
        EntityInstance entityInstance2;
        int n = 0;
        Enumeration enumeration = entityInstance.srcLiftedRelationElements();
        while (enumeration.hasMoreElements()) {
            RelationInstance relationInstance = (RelationInstance)enumeration.nextElement();
            entityInstance2 = relationInstance.getDrawDst();
            if (!entityInstance2.isMarked(4)) continue;
            ++n;
        }
        if (entityInstance.isOpen()) {
            enumeration = entityInstance.getChildren();
            while (enumeration.hasMoreElements()) {
                entityInstance2 = (EntityInstance)enumeration.nextElement();
                n += SimplexLayout.edgesToSupplier(entityInstance2);
            }
        }
        return n;
    }

    public boolean isConfigurable() {
        return true;
    }

    public void configure(LandscapeEditorCore landscapeEditorCore) {
        HiGraphLayout.configure(landscapeEditorCore);
    }

    public void doLayout1(Vector vector, EntityInstance entityInstance, boolean bl) {
        HiGraph hiGraph;
        int n;
        HiGraph hiGraph2;
        HiArc hiArc;
        EntityInstance entityInstance2;
        double d = HiGraphLayout.border();
        switch (vector.size()) {
            case 0: {
                return;
            }
            case 1: {
                EntityInstance entityInstance3 = (EntityInstance)vector.firstElement();
                double d2 = 1.0 - 2.0 * d;
                double d3 = 1.0 - 2.0 * d;
                double d4 = (1.0 - d2) / 2.0;
                double d5 = (1.0 - d3) / 2.0;
                if (bl) {
                    entityInstance3.updateRelLocal(d4, d5, d2, d3);
                } else {
                    entityInstance3.setRelLocal(d4, d5, d2, d3);
                }
                return;
            }
        }
        HiGraphLayout hiGraphLayout = new HiGraphLayout();
        Diagram diagram = this.m_ls.getDiagram();
        int n2 = diagram.getWidth();
        int n3 = diagram.getHeight();
        HiGraph hiGraph3 = new HiGraph(null, "root", 0, n3);
        double d6 = 0.0;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            entityInstance2 = (EntityInstance)enumeration.nextElement();
            d6 += entityInstance2.heightRelLocal();
        }
        d6 /= (double)vector.size();
        enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            entityInstance2 = (EntityInstance)enumeration.nextElement();
            hiGraph3.newChild(entityInstance2, entityInstance2.getEntityLabel(), (int)(entityInstance2.widthRelLocal() * (double)n2), (int)(d6 * (double)n3));
        }
        boolean bl2 = false;
        Vector vector2 = hiGraph3.children();
        enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            hiArc = (HiArc)enumeration.nextElement();
            hiGraph2 = hiArc.to();
            entityInstance2 = hiGraph2.getReferencedObject();
            Enumeration enumeration2 = vector2.elements();
            while (enumeration2.hasMoreElements()) {
                EntityInstance entityInstance4;
                HiArc hiArc2 = (HiArc)enumeration2.nextElement();
                if (hiArc2 == hiArc || (n = SimplexLayout.edgesBetween(entityInstance2, entityInstance4 = (hiGraph = hiArc2.to()).getReferencedObject())) <= 0) continue;
                bl2 = true;
                hiArc = hiGraph.newInputArc(hiGraph2);
                hiArc.setWeight(n);
                hiArc.setMinlength(1);
            }
        }
        HiGraph hiGraph4 = null;
        HiGraph hiGraph5 = null;
        if (bl2 && entityInstance != this.m_ls.getDiagram().getRootInstance()) {
            if (this.m_ls.isShowClients()) {
                enumeration = vector2.elements();
                while (enumeration.hasMoreElements()) {
                    hiArc = (HiArc)enumeration.nextElement();
                    hiGraph = hiArc.to();
                    entityInstance2 = hiGraph.getReferencedObject();
                    if (entityInstance2 == null || (n = SimplexLayout.edgesFromClient(entityInstance2)) <= 0) continue;
                    if (hiGraph4 == null) {
                        hiGraph4 = hiGraph3.newChild(null, "client", 0, 0);
                    }
                    hiArc = this.m_ls.isTopClients() ? hiGraph.newInputArc(hiGraph4) : hiGraph4.newInputArc(hiGraph);
                    hiArc.setWeight(n);
                    hiArc.setMinlength(1);
                }
            }
            if (this.m_ls.isShowSuppliers()) {
                enumeration = vector2.elements();
                while (enumeration.hasMoreElements()) {
                    hiArc = (HiArc)enumeration.nextElement();
                    hiGraph2 = hiArc.to();
                    entityInstance2 = hiGraph2.getReferencedObject();
                    if (entityInstance2 == null || (n = SimplexLayout.edgesToSupplier(entityInstance2)) <= 0) continue;
                    if (hiGraph5 == null) {
                        hiGraph5 = hiGraph3.newChild(null, "supplier", 0, 0);
                    }
                    hiArc = this.m_ls.isTopClients() ? hiGraph5.newInputArc(hiGraph2) : hiGraph2.newInputArc(hiGraph5);
                    hiArc.setWeight(n);
                    hiArc.setMinlength(1);
                }
            }
        }
        hiGraphLayout.layout(hiGraph3);
        int n4 = Integer.MAX_VALUE;
        int n5 = Integer.MAX_VALUE;
        int n6 = Integer.MIN_VALUE;
        int n7 = Integer.MIN_VALUE;
        vector2 = hiGraph3.children();
        enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            hiArc = (HiArc)enumeration.nextElement();
            hiGraph2 = hiArc.to();
            entityInstance2 = hiGraph2.getReferencedObject();
            if (entityInstance2 == null) continue;
            int n8 = hiGraph2.x() - hiGraph2.width() / 2;
            int n9 = n8 + hiGraph2.width();
            int n10 = hiGraph2.y() - hiGraph2.height() / 2;
            int n11 = n10 + hiGraph2.height();
            if (n8 < n5) {
                n5 = n8;
            }
            if (n9 > n7) {
                n7 = n9;
            }
            if (n10 < n4) {
                n4 = n10;
            }
            if (n11 <= n6) continue;
            n6 = n11;
        }
        double d7 = n7 - n5;
        double d8 = (double)n5 - d7 * d;
        d7 += 2.0 * d7 * d;
        double d9 = n6 - n4;
        double d10 = (double)n4 - d9 * d;
        d9 += 2.0 * d9 * d;
        if (d7 <= 0.0 || d9 <= 0.0) {
            return;
        }
        double d11 = 0.0;
        double d12 = 0.0;
        double d13 = 1.0;
        double d14 = 1.0;
        if (HiGraphLayout.fixedRatio()) {
            d13 = d7 * (double)n3 / (d9 * (double)n2);
            if (d13 <= 1.0) {
                d11 = (1.0 - d13) / 2.0;
            } else {
                d14 = 1.0 / d13;
                d13 = 1.0;
                d12 = (1.0 - d14) / 2.0;
            }
            d7 /= d13;
            d9 /= d14;
        }
        enumeration = hiGraph3.children().elements();
        while (enumeration.hasMoreElements()) {
            hiArc = (HiArc)enumeration.nextElement();
            hiGraph2 = hiArc.to();
            entityInstance2 = hiGraph2.getReferencedObject();
            if (entityInstance2 == null) continue;
            double d15 = (double)hiGraph2.width() / d7;
            double d16 = (double)hiGraph2.height() / d9;
            double d17 = ((double)hiGraph2.x() - d8) / d7;
            double d18 = ((double)hiGraph2.y() - d10) / d9;
            d17 += d11 - d15 / 2.0;
            d18 += d12 - d16 / 2.0;
            if (bl) {
                entityInstance2.updateRelLocal(d17, d18, d15, d16);
                continue;
            }
            entityInstance2.setRelLocal(d17, d18, d15, d16);
        }
    }

    public String doLayout(Diagram diagram) {
        this.m_ls.setLayouter(this);
        this.m_ls.setCursor(3);
        Vector vector = diagram.getGroup();
        if (vector == null) {
            Util.beep();
            return "No group selected";
        }
        String string = this.allInDiagram(vector);
        if (string != null) {
            return string;
        }
        EntityInstance entityInstance = this.parentOfSet(vector);
        if (entityInstance == null) {
            return "Simplex algorithm requires that all things laid out share same parent";
        }
        diagram.beginUndoRedo("Simplex layout");
        this.doLayout1(vector, entityInstance, true);
        diagram.endUndoRedo();
        this.m_ls.setCursor(0);
        return "Graph redrawn using Network Simplex algorithm";
    }

    public void processKeyEvent(int n, int n2, Object object) {
        Diagram diagram = this.m_ls.getDiagram();
        if (diagram != null) {
            String string = this.doLayout(diagram);
            this.m_ls.doFeedback(string);
            diagram.rescaleDiagram();
            this.m_ls.repaintDg();
        }
    }
}

