/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.util.Enumeration;
import java.util.Vector;
import lsedit.ClientSupplierCompareFn;
import lsedit.CompareFn;
import lsedit.EntityInstance;
import lsedit.HorizontalCompareFn;
import lsedit.IdCompareFn;
import lsedit.PostorderCompareFn;
import lsedit.StringCompareFn;
import lsedit.VerticalCompareFn;

public class SortVector {
    static final StringCompareFn m_stringCompareFn = new StringCompareFn();
    static final ClientSupplierCompareFn m_clientSupplierCompareFn = new ClientSupplierCompareFn();
    static final HorizontalCompareFn m_horizontalCompareFn = new HorizontalCompareFn();
    static final VerticalCompareFn m_verticalCompareFn = new VerticalCompareFn();
    static final PostorderCompareFn m_postorderCompareFn = new PostorderCompareFn();
    static final IdCompareFn m_idCompareFn = new IdCompareFn();

    private static final int partition(Vector vector, int n, int n2, CompareFn compareFn, boolean bl) {
        Object e = vector.elementAt(n);
        --n;
        ++n2;
        while (true) {
            boolean bl2;
            Object e2 = vector.elementAt(--n2);
            if (bl) {
                bl2 = compareFn.compare(e2, e) > 0;
            } else {
                boolean bl3 = bl2 = compareFn.compare(e2, e) < 0;
            }
            if (bl2) continue;
            do {
                e2 = vector.elementAt(++n);
                if (bl) {
                    bl2 = compareFn.compare(e2, e) < 0;
                    continue;
                }
                boolean bl4 = bl2 = compareFn.compare(e2, e) > 0;
            } while (bl2);
            if (n >= n2) break;
            if (compareFn.compare(vector.elementAt(n), vector.elementAt(n2)) == 0) continue;
            e2 = vector.elementAt(n);
            vector.setElementAt(vector.elementAt(n2), n);
            vector.setElementAt(e2, n2);
        }
        return n2;
    }

    private static final void qsort(Vector vector, int n, int n2, CompareFn compareFn, boolean bl) {
        if (n < n2) {
            int n3 = SortVector.partition(vector, n, n2, compareFn, bl);
            SortVector.qsort(vector, n, n3, compareFn, bl);
            SortVector.qsort(vector, n3 + 1, n2, compareFn, bl);
        }
    }

    private static final void sort(Vector vector, int n, int n2, CompareFn compareFn, boolean bl) {
        switch (n2) {
            case 0: {
                return;
            }
            case 1: {
                if (compareFn.compare(vector.elementAt(0), vector.elementAt(1)) == 1) {
                    Object e = vector.elementAt(0);
                    vector.setElementAt(vector.elementAt(1), 0);
                    vector.setElementAt(e, 1);
                }
                return;
            }
        }
        SortVector.qsort(vector, n, n2, compareFn, bl);
    }

    public static void sortVector(Vector vector, CompareFn compareFn, boolean bl) {
        SortVector.sort(vector, 0, vector.size() - 1, compareFn, bl);
    }

    public static void byString(Vector vector, boolean bl) {
        SortVector.sort(vector, 0, vector.size() - 1, m_stringCompareFn, bl);
    }

    public static void byString(Vector vector) {
        SortVector.byString(vector, true);
    }

    public static void byAvgX(Vector vector, boolean bl) {
        if (vector != null) {
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                EntityInstance entityInstance = (EntityInstance)enumeration.nextElement();
                entityInstance.computeAvgX();
            }
            SortVector.sort(vector, 0, vector.size() - 1, m_clientSupplierCompareFn, bl);
        }
    }

    public static void byAvgX(Vector vector) {
        SortVector.byAvgX(vector, true);
    }

    public static void byDiagramX(Vector vector, boolean bl) {
        SortVector.sort(vector, 0, vector.size() - 1, m_horizontalCompareFn, bl);
    }

    public static void byDiagramX(Vector vector) {
        SortVector.byDiagramX(vector, true);
    }

    public static void byDiagramY(Vector vector, boolean bl) {
        SortVector.sort(vector, 0, vector.size() - 1, m_verticalCompareFn, bl);
    }

    public static void byDiagramY(Vector vector) {
        SortVector.byDiagramY(vector, true);
    }

    public static void byPostorder(Vector vector, boolean bl) {
        SortVector.sort(vector, 0, vector.size() - 1, m_postorderCompareFn, bl);
    }

    public static void byPostorder(Vector vector) {
        SortVector.byPostorder(vector, true);
    }

    public static void byId(Vector vector) {
        SortVector.sort(vector, 0, vector.size() - 1, m_idCompareFn, true);
    }

    public static void byTreeNode(Vector vector) {
        SortVector.sort(vector, 0, vector.size() - 1, m_stringCompareFn, true);
    }
}

