/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.undo.UndoableEdit;
import lsedit.ColorCache;
import lsedit.Diagram;
import lsedit.FontCache;
import lsedit.LandscapeEditorCore;
import lsedit.MyCompoundEdit;
import lsedit.MyMenuItem;
import lsedit.MyPaintableUndoableEdit;
import lsedit.ToolBarEventHandler;

public class UndoBox
extends JComponent
implements ToolBarEventHandler,
MouseListener,
MouseMotionListener {
    protected static final int MARGIN = 5;
    protected static final int GAP = 5;
    protected static final int TY_CLEAR = 0;
    protected static final int TY_RAISED = 1;
    protected static final int TY_SUNK = 2;
    protected LandscapeEditorCore m_ls;
    protected JTabbedPane m_tabbedPane;
    protected JScrollPane m_scrollPane;
    public static Dimension m_preferredSize = new Dimension(0, 0);
    public static Dimension m_size = new Dimension(0, 0);
    public static final String m_helpStr = "This box shows the history of updates made in the current diagram.";
    protected int m_style;
    protected int m_over;
    public static final String DEFAULT_UNDO_FONT_NAME = "Helvetica";
    public static final int DEFAULT_UNDO_FONT_STYLE = 0;
    public static final int DEFAULT_UNDO_FONT_SIZE = 11;
    protected static Font m_textFont = null;
    protected static FontMetrics m_fm = null;
    public static int m_fontheight = 0;
    public static int m_baseline = 0;

    public UndoBox(LandscapeEditorCore landscapeEditorCore, JTabbedPane jTabbedPane) {
        this.setLayout(null);
        this.setLocation(0, 0);
        this.m_ls = landscapeEditorCore;
        this.m_tabbedPane = jTabbedPane;
        UndoBox.setTextFont(FontCache.get(DEFAULT_UNDO_FONT_NAME, 0, 11));
        this.textFontChanged(m_textFont);
        this.setBackground(Diagram.boxColour);
        this.m_scrollPane = new JScrollPane();
        this.m_scrollPane.setHorizontalScrollBarPolicy(30);
        this.m_scrollPane.setVerticalScrollBarPolicy(20);
        this.m_scrollPane.setViewportView(this);
        jTabbedPane.addTab("Undo", null, this.m_scrollPane, m_helpStr);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void activate() {
        this.m_tabbedPane.setSelectedComponent(this.m_scrollPane);
        this.fillUndoBox();
    }

    public boolean isActive() {
        if (!this.isVisible()) {
            return false;
        }
        Component component = this.m_tabbedPane.getSelectedComponent();
        return component != null && this.m_scrollPane == component;
    }

    public static Font getTextFont() {
        return m_textFont;
    }

    public static void setTextFont(Font font) {
        m_textFont = font;
        m_fm = null;
    }

    public void textFontChanged(Font font) {
        FontMetrics fontMetrics;
        m_fm = fontMetrics = this.getFontMetrics(font);
        m_fontheight = fontMetrics.getHeight();
        m_baseline = m_fontheight - fontMetrics.getDescent();
        this.fillUndoBox();
    }

    public boolean isPreferredSizeSet() {
        return UndoBox.m_preferredSize.height > 0;
    }

    public Dimension getPreferredSize() {
        return m_preferredSize;
    }

    public void fillUndoBox() {
        if (this.isActive()) {
            this.repaint();
        }
    }

    public void setNewPreferredSize(Vector vector, UndoableEdit undoableEdit) {
        int n = m_fontheight;
        int n2 = 10;
        int n3 = n + 15;
        if (undoableEdit instanceof MyPaintableUndoableEdit) {
            n2 += ((MyPaintableUndoableEdit)undoableEdit).getPreferredWidth();
        } else {
            FontMetrics fontMetrics = this.getFontMetrics(m_textFont);
            n2 += fontMetrics.stringWidth(undoableEdit.getPresentationName());
        }
        if (n2 > UndoBox.m_preferredSize.width) {
            UndoBox.m_preferredSize.width = n2;
        }
        if ((n3 += n * vector.size()) > UndoBox.m_preferredSize.height) {
            UndoBox.m_preferredSize.height = n3;
        }
        this.m_scrollPane.revalidate();
        this.fillUndoBox();
    }

    public void paintComponent(Graphics graphics) {
        int n = m_fontheight;
        int n2 = m_baseline;
        int n3 = n;
        Vector vector = this.m_ls.getEdits();
        if (vector != null) {
            UndoableEdit undoableEdit = this.m_ls.getEditToBeRedone();
            int n4 = this.m_over;
            graphics.setFont(m_textFont);
            graphics.setColor(Color.BLACK);
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                Color color;
                UndoableEdit undoableEdit2 = (UndoableEdit)enumeration.nextElement();
                if (undoableEdit2 == undoableEdit) {
                    graphics.setColor(Color.RED);
                }
                if (n4 == 0 && this.m_style != 0) {
                    color = graphics.getColor();
                    graphics.setColor(Color.BLACK);
                    graphics.draw3DRect(0, n3, UndoBox.m_preferredSize.width - 1, n - 2, this.m_style == 1);
                    graphics.setColor(color);
                }
                if (undoableEdit2 instanceof MyPaintableUndoableEdit) {
                    ((MyPaintableUndoableEdit)undoableEdit2).paintComponent(graphics, 5, n3);
                } else if (undoableEdit2 instanceof MyCompoundEdit) {
                    color = graphics.getColor();
                    graphics.setColor(Color.WHITE);
                    graphics.fill3DRect(0, n3, UndoBox.m_preferredSize.width - 1, n - 2, n4 == 0 && this.m_style == 1);
                    graphics.setColor(color);
                    graphics.drawString(undoableEdit2.getPresentationName(), 5, n3 + n2);
                } else {
                    graphics.drawString(undoableEdit2.getPresentationName(), 5, n3 + n2);
                }
                n3 += n;
                --n4;
            }
        }
    }

    protected void mouseAt(int n) {
        int n2;
        int n3 = n / m_fontheight - 1;
        if (n3 < 0) {
            n2 = 0;
            n3 = -1;
        } else {
            int n4 = this.m_ls.countEdits();
            if (n3 >= n4) {
                n2 = 0;
                n3 = n4;
            } else {
                n2 = 1;
            }
        }
        if (n2 != this.m_style || n3 != this.m_over) {
            this.m_style = n2;
            this.m_over = n3;
            this.repaint();
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.mouseAt(mouseEvent.getY());
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.m_style = 0;
        this.repaint();
    }

    public void mousePressed(MouseEvent mouseEvent) {
        Vector vector;
        int n;
        this.m_over = n = mouseEvent.getY() / m_fontheight - 1;
        if (mouseEvent.isMetaDown()) {
            JPopupMenu jPopupMenu = new JPopupMenu("Undo options");
            Vector vector2 = this.m_ls.getEdits();
            Diagram diagram = this.m_ls.getDiagram();
            if (diagram != null) {
                int n2;
                if (vector2 != null && (n2 = vector2.size()) > 0) {
                    UndoableEdit undoableEdit;
                    if (n >= 0 && n < n2 && (undoableEdit = (UndoableEdit)vector2.elementAt(n)) instanceof MyCompoundEdit) {
                        MyMenuItem myMenuItem = new MyMenuItem(jPopupMenu, "Show details", this, -1, 10, "Show the details of this edit");
                        myMenuItem.setObject(undoableEdit);
                    }
                    new MyMenuItem(jPopupMenu, "Dispose", this, -1, 127, "Discard undoable edits");
                }
                new MyMenuItem(jPopupMenu, "Limit", this, -1, 108, "Set the limit on the number of undoable edits");
                if (diagram.useCompoundEdit()) {
                    new MyMenuItem(jPopupMenu, "No Compound Edits", this, -1, 67, "Disallow compound edits");
                } else {
                    new MyMenuItem(jPopupMenu, "Use Compound Edits", this, -1, 67, "Allow compound edits");
                }
                FontCache.setMenuTreeFont(jPopupMenu);
                jPopupMenu.show(this, mouseEvent.getX(), mouseEvent.getY());
            }
            return;
        }
        this.m_style = 2;
        if (n >= 0 && (vector = this.m_ls.getEdits()) != null) {
            UndoableEdit undoableEdit = this.m_ls.getEditToBeRedone();
            int n3 = this.m_over;
            boolean bl = false;
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                UndoableEdit undoableEdit2 = (UndoableEdit)enumeration.nextElement();
                if (undoableEdit2 == undoableEdit) {
                    bl = true;
                }
                if (n3 == 0) {
                    this.m_ls.massChange(undoableEdit2, bl);
                    break;
                }
                --n3;
            }
        }
        this.repaint();
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.m_style = 0;
        this.repaint();
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.mouseAt(mouseEvent.getY());
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        this.mouseAt(mouseEvent.getY());
    }

    public void processKeyEvent(int n, int n2, Object object) {
        switch (n) {
            case 10: {
                ShowCompoundEdit showCompoundEdit = new ShowCompoundEdit(this.m_ls, this, (MyCompoundEdit)object);
                showCompoundEdit.dispose();
                break;
            }
            case 127: {
                ShowReallyDelete showReallyDelete = new ShowReallyDelete(this.m_ls, this);
                showReallyDelete.dispose();
                break;
            }
            case 67: 
            case 99: {
                Diagram diagram = this.m_ls.getDiagram();
                if (diagram == null) break;
                boolean bl = diagram.useCompoundEdit();
                diagram.setUseCompoundEdit(!bl);
                break;
            }
            case 76: 
            case 108: {
                ShowMaxUndo showMaxUndo = new ShowMaxUndo(this.m_ls, this);
                showMaxUndo.dispose();
                break;
            }
        }
    }

    public void showInfo(String string) {
    }

    public class ShowReallyDelete
    extends JDialog
    implements ActionListener {
        protected LandscapeEditorCore m_ls;
        protected UndoBox m_undoBox;
        protected JButton m_ok;
        protected JButton m_cancel;

        public ShowReallyDelete(LandscapeEditorCore landscapeEditorCore, UndoBox undoBox2) {
            super(landscapeEditorCore.getFrame(), "Delete Undo", true);
            this.m_ls = landscapeEditorCore;
            this.m_undoBox = undoBox2;
            int n = undoBox2.m_tabbedPane.getX() + 20;
            int n2 = undoBox2.m_tabbedPane.getY() + 20;
            this.setLocation(n, n2);
            this.setForeground(ColorCache.get(0, 0, 0));
            this.setBackground(ColorCache.get(192, 192, 192));
            this.setFont(FontCache.get("Dialog", 0, 12));
            Container container = this.getContentPane();
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new GridLayout(0, 1));
            JLabel jLabel = new JLabel("Confirm deletion?");
            jPanel.add(jLabel);
            container.add((Component)jPanel, "Center");
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new FlowLayout());
            this.m_ok = new JButton("Ok");
            jPanel2.add(this.m_ok);
            this.m_ok.addActionListener(this);
            this.m_cancel = new JButton("Cancel");
            jPanel2.add(this.m_cancel);
            this.m_cancel.addActionListener(this);
            container.add((Component)jPanel2, "South");
            this.pack();
            this.show();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == this.m_ok || object == this.m_cancel) {
                if (object == this.m_ok) {
                    this.m_ls.discardAllEdits();
                    this.m_undoBox.fillUndoBox();
                }
                this.setVisible(false);
                return;
            }
        }
    }

    public class ShowMaxUndo
    extends JDialog
    implements ActionListener {
        protected LandscapeEditorCore m_ls;
        protected Diagram m_diagram;
        protected UndoBox m_undoBox;
        protected JTextField m_max;
        protected int m_limit;
        protected JButton m_ok;
        protected JButton m_cancel;

        public ShowMaxUndo(LandscapeEditorCore landscapeEditorCore, UndoBox undoBox2) {
            super(landscapeEditorCore.getFrame(), "Maximum Undo", true);
            this.m_ls = landscapeEditorCore;
            this.m_diagram = landscapeEditorCore.getDiagram();
            int n = undoBox2.m_tabbedPane.getX() + 20;
            int n2 = undoBox2.m_tabbedPane.getY() + 20;
            this.setLocation(n, n2);
            this.setForeground(ColorCache.get(0, 0, 0));
            this.setBackground(ColorCache.get(192, 192, 192));
            this.setFont(FontCache.getDialogFont());
            Container container = this.getContentPane();
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new GridLayout(0, 1));
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new FlowLayout());
            JLabel jLabel = new JLabel("Maximum: ");
            jPanel2.add(jLabel);
            this.m_limit = this.m_diagram.getLimit();
            this.m_max = new JTextField("" + this.m_limit, 10);
            jPanel2.add(this.m_max);
            jPanel.add(jPanel2);
            container.add((Component)jPanel, "Center");
            jPanel2 = new JPanel();
            jPanel2.setLayout(new FlowLayout());
            this.m_ok = new JButton("Ok");
            jPanel2.add(this.m_ok);
            this.m_ok.addActionListener(this);
            this.m_cancel = new JButton("Cancel");
            jPanel2.add(this.m_cancel);
            this.m_cancel.addActionListener(this);
            container.add((Component)jPanel2, "South");
            this.pack();
            this.show();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == this.m_ok) {
                String string = this.m_max.getText();
                if ((string = string.trim()).length() > 0) {
                    try {
                        int n = Integer.parseInt(string);
                        if (n >= 0) {
                            this.m_diagram.setLimit(n);
                            this.m_undoBox.fillUndoBox();
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                this.setVisible(false);
                return;
            }
            if (object == this.m_cancel) {
                this.setVisible(false);
                return;
            }
        }
    }

    public class ShowCompoundEdit
    extends JDialog {
        MyCompoundEdit m_compoundEdit;

        public ShowCompoundEdit(LandscapeEditorCore landscapeEditorCore, UndoBox undoBox2, MyCompoundEdit myCompoundEdit) {
            super(landscapeEditorCore.getFrame(), myCompoundEdit.getPresentationName(), true);
            Dimension dimension = new Dimension();
            int n = undoBox2.m_tabbedPane.getX() + 20;
            int n2 = undoBox2.m_tabbedPane.getY() + 20;
            this.setLocation(n, n2);
            int n3 = undoBox2.getWidth();
            int n4 = undoBox2.getHeight();
            this.m_compoundEdit = myCompoundEdit;
            Vector vector = myCompoundEdit.getEdits();
            dimension.height = vector.size() * m_fontheight + 5 + 20;
            dimension.width = 0;
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                int n5;
                UndoableEdit undoableEdit = (UndoableEdit)enumeration.nextElement();
                if (undoableEdit instanceof MyPaintableUndoableEdit) {
                    n5 = ((MyPaintableUndoableEdit)undoableEdit).getPreferredWidth();
                } else {
                    FontMetrics fontMetrics = this.getFontMetrics(m_textFont);
                    n5 = fontMetrics.stringWidth(undoableEdit.getPresentationName());
                }
                if (n5 <= dimension.width) continue;
                dimension.width = n5;
            }
            dimension.width += 5;
            if (dimension.width < n3 / 2) {
                dimension.width = n3 / 2;
            }
            Container container = this.getContentPane();
            container.setLayout(new BorderLayout());
            container.setSize(dimension);
            ShowCompoundEditPanel showCompoundEditPanel = new ShowCompoundEditPanel(vector);
            showCompoundEditPanel.setPreferredSize(dimension);
            showCompoundEditPanel.setSize(dimension);
            container.add((Component)showCompoundEditPanel, "Center");
            this.pack();
            this.show();
        }

        public class ShowCompoundEditPanel
        extends JComponent {
            Vector m_v;

            ShowCompoundEditPanel(Vector vector) {
                this.m_v = vector;
            }

            public void paintComponent(Graphics graphics) {
                int n = m_fontheight;
                Vector vector = this.m_v;
                this.setBackground(Color.lightGray);
                if (vector != null) {
                    graphics.setFont(m_textFont);
                    graphics.setColor(Color.BLACK);
                    Enumeration enumeration = vector.elements();
                    while (enumeration.hasMoreElements()) {
                        UndoableEdit undoableEdit = (UndoableEdit)enumeration.nextElement();
                        if (undoableEdit instanceof MyPaintableUndoableEdit) {
                            ((MyPaintableUndoableEdit)undoableEdit).paintComponent(graphics, 5, n);
                        } else {
                            graphics.drawString(undoableEdit.getPresentationName(), 5, n + m_baseline);
                        }
                        n += m_fontheight;
                    }
                }
            }
        }
    }
}

