/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.util.Vector;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;
import lsedit.LandscapeEditorCore;
import lsedit.MyCompoundEdit;
import lsedit.Ta;

public class UndoableTa
extends Ta
implements UndoableEditListener {
    protected MyUndoManager m_undoManager = new MyUndoManager();
    protected String m_compoundEditName = null;
    protected MyCompoundEdit m_compoundEdit = null;
    protected int m_compoundEditCnt = -1;
    protected boolean m_useCompoundEdit = true;

    protected void updateMenu() {
        this.m_ls.setEnabledRedo(this.m_undoManager.canRedo());
        this.m_ls.setEnabledUndo(this.m_undoManager.canUndo());
    }

    public UndoableTa(LandscapeEditorCore landscapeEditorCore) {
        super(landscapeEditorCore);
    }

    public boolean useCompoundEdit() {
        return this.m_useCompoundEdit;
    }

    public void setUseCompoundEdit(boolean bl) {
        this.m_useCompoundEdit = bl;
    }

    public int getLimit() {
        return this.m_undoManager.getLimit();
    }

    public void setLimit(int n) {
        this.m_undoManager.setLimit(n);
    }

    public Vector getEdits() {
        return this.m_undoManager.getEdits();
    }

    public UndoableEdit getEditToBeRedone() {
        return this.m_undoManager.getEditToBeRedone();
    }

    public int countEdits() {
        return this.m_undoManager.countEdits();
    }

    public void massChange(UndoableEdit undoableEdit, boolean bl) {
        this.m_undoManager.massChange(undoableEdit, bl);
    }

    public void discardAllEdits() {
        this.m_undoManager.discardAllEdits();
    }

    public boolean addEditToManager(UndoableEdit undoableEdit) {
        boolean bl = this.m_undoManager.addEdit(undoableEdit);
        if (bl) {
            this.m_ls.setPreferredSizeUndo(this.getEdits(), undoableEdit);
        }
        return bl;
    }

    public void beginUndoRedo(String string) {
        if (this.m_useCompoundEdit) {
            this.m_compoundEditName = string;
            this.m_compoundEdit = null;
            this.m_compoundEditCnt = 0;
        }
    }

    public void endUndoRedo() {
        if (this.m_compoundEdit != null) {
            this.m_compoundEdit.end();
            this.m_compoundEdit = null;
        }
        this.m_compoundEditName = null;
        this.m_compoundEditCnt = -1;
    }

    public boolean logEdit(UndoableEdit undoableEdit) {
        boolean bl;
        this.m_changedFlag = true;
        if (this.m_compoundEditCnt < 0) {
            bl = this.addEditToManager(undoableEdit);
        } else {
            switch (this.m_compoundEditCnt) {
                case 0: {
                    bl = this.addEditToManager(undoableEdit);
                    break;
                }
                case 1: {
                    this.m_compoundEdit = new MyCompoundEdit(this.m_compoundEditName);
                    bl = this.m_compoundEdit.addEdit(undoableEdit);
                    bl = this.addEditToManager(this.m_compoundEdit);
                    break;
                }
                default: {
                    bl = this.m_compoundEdit.addEdit(undoableEdit);
                }
            }
            ++this.m_compoundEditCnt;
        }
        this.updateMenu();
        if (!bl) {
            this.m_ls.error("logEdit failed");
        }
        return bl;
    }

    public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
        this.m_undoManager.undoableEditHappened(undoableEditEvent);
        this.updateMenu();
    }

    public void undo() {
        String string;
        if (!this.m_undoManager.canUndo()) {
            string = "Nothing to undo";
        } else {
            this.m_undoManager.undo();
            this.updateMenu();
            string = "Undo done";
        }
        this.m_ls.fillUndoBox();
        this.m_ls.doFeedback(string);
    }

    public void redo() {
        String string;
        if (!this.m_undoManager.canRedo()) {
            string = "Nothing to redo";
        } else {
            this.m_undoManager.redo();
            this.m_ls.doFeedback("Redo done");
            this.updateMenu();
            string = "Redo done";
        }
        this.m_ls.fillUndoBox();
        this.m_ls.doFeedback(string);
    }

    class MyUndoManager
    extends UndoManager {
        MyUndoManager() {
        }

        public Vector getEdits() {
            return this.edits;
        }

        public UndoableEdit getEditToBeRedone() {
            return this.editToBeRedone();
        }

        public void massChange(UndoableEdit undoableEdit, boolean bl) {
            if (bl) {
                this.redoTo(undoableEdit);
            } else {
                this.undoTo(undoableEdit);
            }
        }

        public int countEdits() {
            return this.edits.size();
        }
    }
}

