/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.util.Enumeration;
import java.util.Vector;

class Vertex {
    private int layer = -1;
    private int inDegree = 0;
    private int outDegree = 0;
    private double width;
    private boolean visited = false;
    private boolean isDummy = false;
    private Vector parents = new Vector();
    private Vector children = new Vector();

    public Vertex(double d) {
        this.width = d;
    }

    public void addChild(Integer n) {
        if (this.children.indexOf(n) == -1) {
            this.children.addElement(n);
            ++this.outDegree;
        }
    }

    public boolean removeChild(Integer n) {
        return this.children.removeElement(n);
    }

    public void replaceChild(Integer n, Integer n2) {
        try {
            this.children.setElementAt(n2, this.children.indexOf(n));
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.exit(-1);
        }
    }

    public void addParent(Integer n) {
        if (this.parents.indexOf(n) == -1) {
            this.parents.addElement(n);
            ++this.inDegree;
        }
    }

    public boolean removeParent(Integer n) {
        return this.parents.removeElement(n);
    }

    public void replaceParent(Integer n, Integer n2) {
        try {
            this.parents.setElementAt(n2, this.parents.indexOf(n));
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.out.println("array problem");
            System.exit(-1);
        }
    }

    public void setLayer(int n) {
        this.layer = n;
    }

    public int getLayer() {
        return this.layer;
    }

    public void setDummy() {
        this.isDummy = true;
    }

    public double getWidth() {
        return this.width;
    }

    public int getInDegree() {
        return this.inDegree;
    }

    public int getOutDegree() {
        return this.outDegree;
    }

    public void decInDegree() {
        --this.inDegree;
    }

    public void decOutDegree() {
        --this.outDegree;
    }

    public void setVisited() {
        this.visited = true;
    }

    public boolean isVisited() {
        return this.visited;
    }

    public Vector getParents() {
        return this.parents;
    }

    public Vector getChildren() {
        return this.children;
    }

    public void print() {
        System.out.print("Parents: ");
        Enumeration enumeration = this.parents.elements();
        while (enumeration.hasMoreElements()) {
            System.out.print(enumeration.nextElement() + " ");
        }
        System.out.println();
        System.out.print("Children: ");
        enumeration = this.children.elements();
        while (enumeration.hasMoreElements()) {
            System.out.print(enumeration.nextElement() + " ");
        }
        System.out.println();
        System.out.println("Layer " + this.layer);
    }
}

