package lsedit;

import java.awt.Dimension;
import java.awt.Graphics;
import java.io.*;
import java.util.*;
import javax.swing.*;

public class Arrow extends JComponent { 

	private	int[]	  m_x;
	private int[]     m_y;
	private int		  m_style;

	protected Arrow(int width, int height)
	{
		Dimension dimension = new Dimension(width, height);
		m_x         = new int[3];
		m_y         = new int[3];

		Util.getArrow(0, height/2, width, height/2, m_x, m_y, 1);

		setMinimumSize(dimension);
		setPreferredSize(dimension);
		setMaximumSize(dimension);
		setSize(dimension);
		m_style = Util.LINE_STYLE_NORMAL;

	}

	public void setStyle(int style)
	{
		m_style = style;
	}

	public void paintComponent(Graphics g)
	{
		int	height = getHeight() / 2;

		g.setColor(getBackground());
		Util.drawSegment(g, m_style, 0, height, getWidth(), height);
//		g.drawLine(0,height, getWidth(), height);
		g.fillPolygon(m_x, m_y, 3);
}	}
