package lsedit;

import java.util.Enumeration;
import java.util.Vector;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.Scrollable;

class ShowLabel extends JLabel
{
	public ShowLabel(String value)
	{
		super(value);

		int width, width1;

		setHorizontalAlignment(LEFT);
		setHorizontalTextPosition(LEFT);
		setFont(AttributeBox.m_textFont);
}	}


class ShowAttributeColor extends ShowLabel {

	public ShowAttributeColor(Color color) 
	{
		super("COLOR");
		// The text COLOR helps distinguish white from null
		// Null's don't seem to get painted

		if (color == null) {
			setBackground(Color.WHITE);
			setForeground(Color.BLACK);
		} else {
			setBackground(color);
			setForeground(ColorCache.getInverse(color.getRGB()));
}	}	}

class ShowImage extends ShowLabel {

	int		m_image;

	public ShowImage(int image) 
	{
		super("  ");
		m_image = image;
	}

	public void paintComponent(Graphics g) 
	{
		int		width	= getWidth();
		int		height	= getHeight();
		int		size	= width;

		if (height < size) {
			size = height;
		}
		g.setColor(Color.BLACK);
		EntityComponent.paintImage(g, m_image, (width - size)/2, (height-size)/2, size, size);
}	}

class AttributeBoxPanel extends JPanel
{
	public AttributeBoxPanel()
	{
		super();
	}

	public void paintBorder(Graphics g)
	{
		super.paintBorder(g);

		int			width = getWidth();
		int			cnt   = getComponentCount();
		int			i, y, height;
		Component	component;
		boolean		flag;

		g.setColor(Diagram.lighterBoxColor);
		flag = false;
		for (i = 0; i < cnt; ++i) {
			component = getComponent(i);
			if (!(component instanceof JLabel)) {
				flag = false;
				continue;
			}
			if (!flag) {
				flag = true;
			} else {
				y         = component.getY();
				height    = component.getHeight();
				g.fillRect(0, y, width, height);
				flag = false;
	}	}	}
}	



public class AttributeBox extends MySplitPane implements Scrollable 
{
	protected static final Color	m_titleColor = Color.red.darker();

	public final static String DEFAULT_ATTRIBUTE_TITLE_FONT_NAME  = FontCache.DEFAULT_FONT_NAME;
	public final static int    DEFAULT_ATTRIBUTE_TITLE_FONT_STYLE = Font.BOLD;
	public final static int    DEFAULT_ATTRIBUTE_TITLE_FONT_SIZE  = 14;


	protected static Font	   m_titleFont  = FontCache.get(DEFAULT_ATTRIBUTE_TITLE_FONT_NAME, DEFAULT_ATTRIBUTE_TITLE_FONT_STYLE, DEFAULT_ATTRIBUTE_TITLE_FONT_SIZE);

	public final static String DEFAULT_ATTRIBUTE_TEXT_FONT_NAME  = FontCache.DEFAULT_FONT_NAME;
	public final static int    DEFAULT_ATTRIBUTE_TEXT_FONT_STYLE = Font.PLAIN;
	public final static int    DEFAULT_ATTRIBUTE_TEXT_FONT_SIZE  = 11;

	public    static       Font		m_textFont	 = FontCache.get(DEFAULT_ATTRIBUTE_TEXT_FONT_NAME, DEFAULT_ATTRIBUTE_TEXT_FONT_STYLE, DEFAULT_ATTRIBUTE_TEXT_FONT_SIZE);
	protected static final String	m_indent     = "    ";

	protected static final String	m_helpStr    = "Hold shift down to freeze";

	protected static final int	horizontal_margin    = 10;
	protected static final int	vertical_indent      = 10;

	protected LandscapeEditorCore	m_ls;
	protected JTabbedPane			m_tabbedPane;
	protected JScrollPane			m_scrollPane;
	protected GridLayout			m_layout;
	protected JPanel				m_left;
	protected JPanel				m_right;
	protected BoxLayout				m_left_layout;
	protected BoxLayout				m_right_layout;

	protected LandscapeObject		m_object = null;

	// --------------
	// Public methods 
	// --------------

	public AttributeBox(LandscapeEditorCore ls, JTabbedPane tabbedPane) 
	{
		super(JSplitPane.HORIZONTAL_SPLIT);

		Dimension d;
		BoxLayout layout;
		int		  width, height;

		m_ls         = ls;
		m_tabbedPane = tabbedPane;

		m_left  = new AttributeBoxPanel();
		m_right = new AttributeBoxPanel();

		m_left.setBackground(Diagram.boxColor);
		m_right.setBackground(Diagram.boxColor);
		
		m_left_layout  = layout = new BoxLayout(m_left, BoxLayout.Y_AXIS);
		m_left.setLayout(layout);
		m_right_layout = layout = new BoxLayout(m_right, BoxLayout.Y_AXIS);
		m_right.setLayout(layout);


		setLeftComponent(m_left);
		setRightComponent(m_right);
		setOneTouchExpandable(true);
		setDividerLocation(0.5);

		width  = tabbedPane.getWidth();
		height = tabbedPane.getHeight();
		m_scrollPane = new JScrollPane();
		m_scrollPane.setBounds(0, 0, width, height);
		d            = m_scrollPane.getSize();
		setSize(d);
		setPreferredSize(d);

		setToolTipText(m_helpStr);
		m_scrollPane.setViewportView(this);

		tabbedPane.addTab("Attrs", null, m_scrollPane, m_helpStr);
	}

	public static Font getTitleFont()
	{
		return m_titleFont;
	}

	public static void setTitleFont(Font font)
	{
		m_titleFont = font;
	}

	public static Font getTextFont()
	{
		return m_textFont;
	}

	public static void setTextFont(Font font)
	{
		m_textFont = font;
	}

	public void activate() 
	{
		m_tabbedPane.setSelectedComponent(m_scrollPane);
	}

	public boolean isActive() 
	{
		
		if (isVisible()) {
			Component active;

			active = m_tabbedPane.getSelectedComponent();
			return(active != null && m_scrollPane == active);
		}
		return(false);
	}

	public void validate()
	{
		Dimension d;

		d = m_scrollPane.getSize();
		setSize(d);
		setPreferredSize(d);
		super.validate();
	}

	public void fill(LandscapeObject object)
	{
		ShowLabel		label;
		int				attributes = 0;


		int			i, primary, type;
		String		name;
		Object		value;
		JComponent	right;
		Color		foreground;

		attributes = object.getLsAttributeCount();
		primary    = object.getPrimaryAttributeCount();
		for (i = 0; i < attributes; ++i) {
			type  = object.getLsAttributeTypeAt(i);
			if (type == Attribute.NULL_TYPE) {
				break;
			}

			name  = object.getLsAttributeNameAt(i);

			label = new ShowLabel(name);

			if (i < primary) {
				foreground = Color.blue;
			} else {
				foreground = Color.red;
			}
			label.setForeground(foreground);
			label.setFont(m_textFont);
			m_left.add(label);

			value = object.getLsAttributeValueAt(i);
			if (value == null) {
				label = new ShowLabel("null");
				label.setForeground(Color.red);
				right = label;
			} else {

				switch (type) {
				case Attribute.STRING_TYPE:
				case Attribute.TEXT_TYPE:
				case Attribute.AVI_TYPE:
				case Attribute.DOUBLE_TYPE:
				case Attribute.INT_TYPE:
				case Attribute.ENTITY_CLASS_TYPE:
				case Attribute.RELATION_CLASS_TYPE:
					right = new ShowLabel(value.toString());
					break;
				case Attribute.COLOR_TYPE:
				case Attribute.COLOR_OR_NULL_TYPE:
					right = new ShowAttributeColor((Color) value);
					right.setOpaque(true); // MUST do this for background to show up.
					break;
				case Attribute.ENTITY_IMAGE_TYPE:
					right = new ShowImage(((Integer) value).intValue());
					break;
				case Attribute.ENTITY_STYLE_TYPE:
				{
					int		style = ((Integer) value).intValue();
					String	description;

					if (style < 0 || style >= EntityClass.styleName.length) {
						description = "" + style;
					} else {
						description = EntityClass.styleName[style];
					}
					right = new ShowLabel(description);
					break;
				}
				case Attribute.REL_STYLE_TYPE:
				{
					int		style;
					String	description;

					style = ((Integer) value).intValue();

					if (style < 0 || style >= Util.lineStyleName.length) {
						description = "" + style;
					} else {
						description = Util.lineStyleName[style];
					}
					right = new ShowLabel(description);
					break;
				}
				default:
					right = new ShowLabel("");
			}	}
			m_right.add(right);
		}	

		m_left.add(Box.createVerticalStrut(10));
		m_right.add(Box.createVerticalStrut(10));
		label = new ShowLabel("Attributes");
		label.setForeground(Color.GREEN);
		m_left.add(label);
		label = new ShowLabel("" + attributes);
		m_right.add(label);

		LandscapeObject parent;

		if (object instanceof LandscapeObject3D) {
			name = ((LandscapeObject3D) object).getId();
		} else {
			name = "Relation";
		}

		for (i = 0; (parent = object.derivedFrom(i)) != null; ++i) {
			m_left.add(Box.createVerticalStrut(10));
			m_right.add(Box.createVerticalStrut(10));
			label = new ShowLabel("Superclass of");
			m_left.add(label);
			right = new ShowLabel(name);
			m_right.add(right);
			fill(parent);
		}
	}

	public void fill()
	{
		ShowLabel		label;
		LandscapeObject object     = m_object;
		int				attributes = 0;

		m_left.removeAll();
		m_right.removeAll();
		// Repaint when empty to clear stuff outside size of resized boxes
		m_left.repaint();
		m_right.repaint();
		if (object == null) {
			m_left.add(Box.createVerticalStrut(10));
			m_right.add(Box.createVerticalStrut(10));
			label = new ShowLabel("No object");
			m_left.add(label);
		} else {
			fill(object);
		}

//		m_left.setPreferredSize(m_left_layout.preferredLayoutSize(m_left));
//		m_right.setPreferredSize(m_right_layout.preferredLayoutSize(m_right));
//		m_left.validate();
//		m_right.validate();

		m_scrollPane.revalidate();
	}


	public void show(LandscapeObject object)
	{
		if (m_object != object) {
			m_object = object;
			fill();
	}	}
	
	// Scrollable interface
	// We need to implement this to stop iterative size changes..
	// The resultbox knows what size it wants to be and sets it on every validate
	// If we don't disable it the viewport tries to change the size to fit the window every time it validates

	public Dimension getPreferredScrollableViewportSize()
	{
		return(getSize());
	}
	 
	public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction)
	{
		return(50);
	}
	 
	public boolean getScrollableTracksViewportHeight() 
	{
		return(false);
	}

	public boolean getScrollableTracksViewportWidth() 
	{
		return(false);
	}

	public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction)
	{
		return(10);
	} 
}






