package lsedit;

import java.io.IOException;
import java.io.PrintStream;

public class AttributeValueItem extends Object 
{
	// Attribute values can be single nodes, or a linked list of nodes.
	// 

	public String				value;
	public AttributeValueItem	next;		// Next item within this attribute value (x y z)
	public AttributeValueItem	nextList;	// Next attribute value in the sublist of terms ( ... (x y z) ...)

	// If any of these characters appear in an id or an attribute 
	// value, this string should be output quoted. 
	//

	protected static final String specialChars = "\n\t\f\r\u001b\u007f\\\" /,:(){}^<>"; 

	public static String qt(String str) 
	{
		if (str.length() == 0) {
			return "\"\"";
		}
		for (int i = 0; i < specialChars.length(); i++) {
			if (str.indexOf(specialChars.charAt(i)) >= 0) {
				if (i < 8) {
					String	ret = "\"";
					char	c;

					c = 0;
					for (i = 0; i < str.length(); ++i) {
						c    = str.charAt(i);
						switch (c) {
						case '\n':
						case '\t':
						case '\f':
						case '\r':
						case '\u001b':
						case '\u007f':
						case '\\':
						case '"':
							ret += '\\';
							switch (c) {
							case '\n':
								c = 'n';
								break;
							case '\t':
								c = 't';
								break;
							case '\f':
								c = 'f';
								break;
							case '\r':
								c = 'r';
								break;
							case '\u001b':
								c = 'e';
								break;
							case '\u007f':
								c = 'd';
								break;
							}
							break;
						}
						ret += c;
					}
					return ret + '"';
				}
				return "\"" + str + "\"";
			}

		}
		return str;
	}

	// -------------- 
	// Public methods
	// -------------- 

	public AttributeValueItem(String string) 
	{
		value = string;
	}

	public AttributeValueItem(boolean bool)
	{
		value = (bool ? "true" : "false");
	}

	public Object clone() 
	{
		AttributeValueItem av = new AttributeValueItem(value);

		if (next != null) {
			av.next = (AttributeValueItem) next.clone();
		}

		if (nextList != null) {
			av.nextList = (AttributeValueItem) nextList.clone();
		}
		return av; 
	}

	public String toString() {

		AttributeValueItem avi;
		String			   ret;	  

		if (next != null) {
			ret = "(";
		} else {
			ret = "";
		}
		for (avi = this; avi != null; avi = avi.next) {
			if (avi != this) {
				ret += " ";
			}
			ret += qt(avi.value);
		}
		if (next != null) {
			ret += ")";
		}
		return(ret);
	}

	public void writeAttribute(PrintStream ps) throws IOException {

		if (next != null) {
			AttributeValueItem avi;

			ps.print("(");

			for (avi = this; avi != null; avi = avi.next) {
				if (avi != this) {
					ps.print(" ");
				}
				if (avi.nextList == null) {
					ps.print(qt(avi.value)); 
				} else {
					ps.print("(");
					for (AttributeValueItem avi1 = avi; avi1 != null; avi1 = avi1.nextList) {
						if (avi1 != avi) {
							ps.print(" ");
						}
						ps.print(qt(avi1.value));
					}
					ps.print(")");
			}	}
			ps.print(")\n"); 
		} else {
			// Single string value is output
			ps.print(qt(value) + "\n"); 
		}
	}

	public boolean equals(Object other)
	{
		if (other != null && other instanceof AttributeValueItem) {
			if (value != null && value.equals(((AttributeValueItem) other).value)) {
				if (next != null) {
					return(next.equals(((AttributeValueItem) other).next));
				} else if (((AttributeValueItem) other).next == null) {
					return(true);
		}	}	}
		return(false);
	}

	public RealPoint parsePoint() {

		if (value == null || next == null || next.value == null) {
			return new RealPoint(0.0, 0.0);
		}
		double v1 = (new Double(value)).doubleValue();
		double v2 = (new Double(next.value)).doubleValue();
		return new RealPoint(v1, v2);
	}
}

