package lsedit;

import java.util.Collection;
import java.util.Enumeration;
import java.util.Vector;

// The clipboard is implemented as a vector of entities that have been clipped plus 
// an optional earlier clipboard that this extends
//
// A clipboard may never contain zero items within it.  If it did enumeration and
// isEmpty would both break.

public class Clipboard extends Vector
{
	private	Vector		m_old_containers = new Vector();
	private Clipboard	m_extends        = null;

	public Clipboard(Vector v)
	{
		int	i;

		for (i = 0; i < v.size(); ++i) {
			add(v.elementAt(i));
		}

		// Descendants occurs before their anscestors
		// Make sure we cut descendants before ancestors so that we can still find them
		SortVector.byPostorder(this);
	}

	public int clipboardSize()
	{
		Clipboard	clipboard;
		int			ret;

		ret = 0;
		for (clipboard = this; clipboard != null; clipboard = clipboard.getExtendsClipboard()) {
			ret += clipboard.size();
		}
		return(ret);
	}

	public boolean add(Object o)
	{
		m_old_containers.add( ((EntityInstance) o).getContainedBy() );
		return super.add(o);
	}

	public Clipboard getExtendsClipboard()
	{
		return m_extends;
	}

	public void setExtendsClipboard(Clipboard clipboard)
	{
		m_extends              = clipboard;
	}
			
	public ClipboardEnumerator clipboardElements()
	{
		return new ClipboardEnumerator(this);
	}

	public EntityInstance oldContainer(int i)
	{
		return (EntityInstance) m_old_containers.elementAt(i);
	}
}

