package lsedit;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

import java.util.Enumeration;
import java.util.Vector;

import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;

public class ClipboardBox extends JComponent implements ToolBarEventHandler, MouseListener
{
	protected class ExpandedChkBox extends JCheckBox implements ItemListener
	{
		ExpandedChkBox(String label)
		{
			super(label);

			setSelected(false);
			addItemListener(this);
		}

		public void itemStateChanged(ItemEvent ev)
		{
			clipboardChanged(); 
	}	}

	protected static final int MARGIN    = 5;
	protected static final int INDENT    = 10;

	protected LandscapeEditorCore   m_ls;
	protected JTabbedPane			m_tabbedPane;
	protected JScrollPane			m_scrollPane;
	protected JCheckBox				m_addChk;
	protected ExpandedChkBox		m_expandChk;

	protected static Dimension      m_preferredSize    = new Dimension(0,0);

	public    static final String m_helpStr	 = "This box shows the contents of the clipboard within the current diagram.";


	public final static String DEFAULT_CLIPBOARD_FONT_NAME  = FontCache.DEFAULT_FONT_NAME;
	public final static int    DEFAULT_CLIPBOARD_FONT_STYLE = Font.PLAIN;
	public final static int    DEFAULT_CLIPBOARD_FONT_SIZE  = 11;

	protected static     Font		 m_textFont	 = FontCache.get(DEFAULT_CLIPBOARD_FONT_NAME, DEFAULT_CLIPBOARD_FONT_STYLE, DEFAULT_CLIPBOARD_FONT_SIZE);
	protected static	 FontMetrics m_fm;
	protected static	 int		 m_fontheight;
	protected static	 int		 m_baseline;
	protected static	 int		 m_height;
	protected static	 int		 m_top;

	// --------------
	// Public methods 
	// --------------

	public void setTop()
	{

		FontMetrics	fm;
		Dimension	d;
		int			y;

		m_fm = fm    = getFontMetrics(ClipboardBox.m_textFont);
		m_fontheight = fm.getHeight();
		m_baseline   = m_fontheight - fm.getDescent();
		
		y  = MARGIN;
		d  = m_addChk.getPreferredSize();
		m_addChk.setBounds(MARGIN, y, d.width, d.height);
		y += d.height;
	
		d = m_expandChk.getPreferredSize();
		m_expandChk.setBounds(MARGIN, y, d.width, d.height);
		y += d.height;

		m_top = y + m_fontheight + m_baseline;
	}

	public ClipboardBox(LandscapeEditorCore ls, JTabbedPane tabbedPane) 
	{
		int			y;

		m_ls          = ls;
		m_tabbedPane  = tabbedPane;

		setBackground(Diagram.boxColor);
		setToolTipText(m_helpStr);

		m_addChk = new JCheckBox("Add to clipboard");
		m_addChk.setFont(m_textFont);
		m_addChk.setForeground(Color.black);

		m_expandChk = new ExpandedChkBox("Expand trees");
		m_expandChk.setFont(m_textFont);
		m_expandChk.setForeground(Color.black);

		setTop();

		add(m_addChk);
		add(m_expandChk);

		m_scrollPane = new JScrollPane();

		m_scrollPane.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED); 
		m_scrollPane.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED); 
		m_scrollPane.setViewportView(this);
		tabbedPane.addTab("Clipboard", null, m_scrollPane, m_helpStr);
		addMouseListener(this);
		setNewPreferredSize();
	}

	public static Font getTextFont()
	{
		return m_textFont;
	}

	public static void setTextFont(Font font)
	{
		m_textFont = font;
	}

	public void activate() 
	{
		m_tabbedPane.setSelectedComponent(m_scrollPane);
	}

	public boolean isActive() 
	{
		Component active;

		if (!isVisible()) {
			return(false);
		}
		active = m_tabbedPane.getSelectedComponent();
		return(active != null && m_scrollPane == active);
	}

	public Dimension getMaximumSize()
	{
		return(getPreferredSize());
	}

	private void paintTree(Graphics g, EntityInstance e, RelationClass containsClass, int indent)
	{
		Enumeration		children;
		EntityInstance	child, parent1;
		String			label;

		label = e.getEntityLabel();
		if (g == null) {
			// Computing sizes
			int w = m_fm.stringWidth(label) + MARGIN * 2 + indent;
			if (w > m_preferredSize.width) {
				m_preferredSize.width = w;
			}
		} else {
			g.drawString(label, MARGIN+indent, m_height);
		}
		m_height += m_fontheight;

		if (m_expandChk.isSelected()) {
			for (children = e.getChildren(); children.hasMoreElements(); ) {
				child   = (EntityInstance) children.nextElement();
				parent1 = child.getContainedBy(containsClass);
				if (parent1 == e) {
					paintTree(g, child, containsClass, indent+INDENT);
	}	}	}	}

	public void paintComponent(Graphics g)
	{
		m_height = m_top;

		Diagram diagram = m_ls.getDiagram();
		if (diagram != null) {
			Clipboard clipboard = diagram.getClipboard();

			if (clipboard != null  && !clipboard.isEmpty()) {
				RelationClass	containsClass = diagram.getContainsClass();

				ClipboardEnumerator	en;
				EntityInstance		e;

				if (g != null) {
					g.setFont(m_textFont);
					g.setColor(Color.BLACK);
				}

				for (en = clipboard.clipboardElements(); en.hasMoreElements(); ) {
					e = (EntityInstance) en.nextElement();
					paintTree(g, e, containsClass, 0);
					m_height += m_fontheight;
	}	}	}	}

	protected void setNewPreferredSize()
	{
		int			oldwidth, oldheight;

		oldwidth  = ClipboardBox.m_preferredSize.width;
		oldheight = ClipboardBox.m_preferredSize.height;

		Dimension	d;

		d = m_addChk.getPreferredSize();
		m_preferredSize.width  = MARGIN + d.width;

		paintComponent(null);
		m_preferredSize.height =  m_height + m_fontheight;

		if (ClipboardBox.m_preferredSize.width != oldwidth || ClipboardBox.m_preferredSize.height != oldheight) {
			setPreferredSize(m_preferredSize);
			setSize(m_preferredSize);
			m_scrollPane.revalidate();
	}	}

	public void clipboardChanged()
	{
		setNewPreferredSize();
		repaint();
	}

	public void textFontChanged(Font font)
	{
		Dimension d;

		m_textFont = font;
		m_addChk.setFont(font);
		m_expandChk.setFont(font);
		setTop();
		clipboardChanged();
	}

	public boolean isAddToClipboard()
	{
		return m_addChk.isSelected();
	}

	public void clear()
	{
		Diagram diagram = m_ls.getDiagram();
		if (diagram != null) {
			diagram.setClipboard(null);
		}
		m_ls.doFeedback("Clipboard cleared");
	}

	// MouseListener interface

	public void mouseClicked(MouseEvent ev)
	{
	}

	public void mouseEntered(MouseEvent ev)
	{
	}

	public void mouseExited(MouseEvent ev)
	{
	}

	public void mousePressed(MouseEvent ev)
	{
		Diagram diagram = m_ls.getDiagram();
		if (diagram != null) {
			Clipboard clipboard = diagram.getClipboard();

			if (clipboard != null && !clipboard.isEmpty()) {
				if (ev.isMetaDown()) {
					JPopupMenu	m =  new JPopupMenu("Clipboard options");
					new MyMenuItem(m, "Dispose", this, -1, Do.DELETE, "Discard this clipboard");
					FontCache.setMenuTreeFont(m); 
					m.show(this, ev.getX(), ev.getY());
					return;
	}	}	}	}

	public void mouseReleased(MouseEvent ev)
	{
	}

	// ToolBarEventHandler

	 public void processKeyEvent(int key, int modifiers, Object object)
	 {
		switch (key) {
			case Do.DELETE:
			{
				ReallyDelete dialog    = new ReallyDelete(m_ls, "Delete Clipboard");
				dialog.setLocation(m_tabbedPane.getX() + 20, m_tabbedPane.getY() + 20);
				dialog.setVisible(true);
				boolean		 confirmed = dialog.confirmed();
				dialog.dispose();
				if (confirmed) {
					clear();
				}
				break;
	 }	}	}

	 public void showInfo(String msg)
	 {
	 }		
}



