package lsedit;

import java.awt.Rectangle;

import java.util.Enumeration;
import java.util.Vector;

import javax.swing.undo.UndoableEdit;

/* This class extends TA with basic update operations
 * It knows about the diagram
 */

class NoTaListener implements TaListener 
{
	public void setEnabledRedo(boolean value) {}
	public void setEnabledUndo(boolean value) {}
	public void setPreferredSizeUndo(Vector edits, UndoableEdit lastEdit) {}
	public void undoHistoryChanged() {}

	public void entityCut(EntityInstance e) {}
	public void containerCut(EntityInstance parent, EntityInstance e) {}
	public void containerUncut(EntityInstance e) {}
	public void entityPasted(EntityInstance e) {}
	public void entityBeingMoved(EntityInstance e) {}
	public void entityMoved(EntityInstance e) {}

	public void classChanges() {}	
	public void containsClassChanging() {}
	public void containsClassChanged() {}
}

public class EditableTa extends Ta 
{
	protected static TaListener	m_noTaListener = null;

	protected TaListener	m_taListener;
	protected Diagram		m_diagram;

	public EditableTa(TaListener taListener, TaFeedback taFeedback)
	{
		super(taFeedback);

		if (taListener == null) {
			if (m_noTaListener == null) {
				m_noTaListener = new NoTaListener();
			}
			taListener = m_noTaListener;
		}
		m_taListener = taListener;
	}

	public void setDiagram(Diagram diagram)
	{
		m_diagram = diagram;
	}

	public void removeEntitiesFromCache()
	{
		EntityInstance rootInstance = m_rootInstance;

		if (rootInstance != null) {
			rootInstance.removeTreeFromCache(m_entityCache);
		}
		int size = m_entityCache.size();

		if (size != 0) {
			System.out.println("Diagram.removeEntitiesFromCache failed count=" + size);
			m_entityCache.show();
	}	}

	public void addEntitiesToCache()
	{
		m_rootInstance.addTreeToCache(m_entityCache);
	}

	public void setInitialLocation(EntityInstance e, EntityInstance container)
	{
		int width, height;

		width = container.getWidth();
		height = container.getHeight();

		e.setInitialLocation(container);
		e.resize(width, height);
		e.relocate(container.getDiagramX(), container.getDiagramY(), width, height);
	}

	public EntityInstance getNewEntity(EntityClass ec, EntityInstance container)
	{
		int				n;
		String			ename;
		EntityInstance	e;

		for (n = 0; ; ++n) {
			ename = "Entity#" + n;
			if (!entityExists(ename)) {
				break;
		}	}

		if (ec == null) {
			ec  = m_defaultEntityClass;
			if (ec == null) {
				ec = m_entityBaseClass;
		}	}

		e = ec.newEntity(ename);
		putCache(e);
		addEdge(container, e, getContainsClass());
		prepostorder();
		m_taListener.entityPasted(e);

		return(e);
	}

	public void markDeleted(EntityInstance me)
	{
		removeCache(me);
		me.markDeleted();
	}

	public void clearDeleted(EntityInstance me)
	{
		me.clearDeleted();
		putCache(me);
	}

	// After this operation everything in/under top knows about its
	// edges but nothing else does

	public void disconnectEdges(EntityInstance me, EntityInstance top)
	{
		Enumeration			en;
		RelationInstance	ri;
		EntityInstance		other;
		EntityInstance		e;

		markDeleted(me);

		for (en = me.srcRelationElements(); en.hasMoreElements(); ) {
			ri    = (RelationInstance) en.nextElement();
			other = ri.getDst();
			if (!top.hasDescendantOrSelf(other)) {
				other.removeDstRelation(ri); 
		}	}

		for (en = me.dstRelationElements(); en.hasMoreElements(); ) {
			ri    = (RelationInstance) en.nextElement();
			other = ri.getSrc();
			if (!top.hasDescendantOrSelf(other)) {
				other.removeSrcRelation(ri);
		}	}

		// We continue to know who our children are but by this point they
		// don't know who their parent is

		for (en = me.getChildren(); en.hasMoreElements(); ) {
			e = (EntityInstance) en.nextElement();
			disconnectEdges(e, top);
		} 
	}

	public void reconnectEdges(EntityInstance me)
	{
		Enumeration			en;
		RelationInstance	ri;
		EntityInstance		other;
		EntityInstance		e;

		for (en = me.getChildren(); en.hasMoreElements(); ) {
			e = (EntityInstance) en.nextElement();
			reconnectEdges(e);
		}

		clearDeleted(me);

		for (en = me.srcRelationElements(); en.hasMoreElements(); ) {
			ri    = (RelationInstance) en.nextElement();
			other = ri.getDst();
			other.addDstRelationIfAbsent(ri); 
		}

		for (en = me.dstRelationElements(); en.hasMoreElements(); ) {
			ri    = (RelationInstance) en.nextElement();
			other = ri.getSrc();
			other.addSrcRelationIfAbsent(ri);
	}	}

	// Remove m_dstRelList relations from entities on our m_srcRelList.
	// Remove m_srcRelList relations from entities on our m_dstRelList. 
	// After this operation we continue to know all about all edges to/from
	// us, but other entitites know nothing about all edges to/from us.
	// Can't apply this to the root since no where to add children

	private EntityInstance disconnectEdgesJustMe(EntityInstance me)
	{
		RelationClass		containsClass = getContainsClass();
		EntityInstance		parent        = null;
		Enumeration			en;
		RelationInstance	ri;
		EntityInstance		other;

		// This entity can no longer belongs to any active group

		me.nandMark(EntityInstance.GROUP_MARK|EntityInstance.GROUPKEY_MARK);

		for (en = me.dstRelationElements(); en.hasMoreElements(); ) {
			ri    = (RelationInstance) en.nextElement();
			other = ri.getSrc();
			if (other != me) {
				if (parent == null) {
					if (ri.getRelationClass() == containsClass) {
						parent = other;
				}	}
				other.removeSrcRelation(ri);
		}	}

		for (en = me.srcRelationElements(); en.hasMoreElements(); ) {
			ri    = (RelationInstance) en.nextElement();
			other = ri.getDst();
			if (other != me) {
				other.removeDstRelation(ri); 
			}
			if (ri.getRelationClass() == containsClass) {
				// No longer a child of us -- make child of parent
				other.setContainedBy(parent);
				if (parent != null) {
					parent.addContainment(other);
		}	}	}
		return(parent);
	}

	// Add m_dstRelList relations from entities on our m_srcRelList.
	// Add m_srcRelList relations from entities on our m_dstRelList. 
	// Reverses changes made by disconnectEdgesJustMe
	
	private EntityInstance reconnectEdgesJustMe(EntityInstance me)
	{
		RelationClass		containsClass = getContainsClass();
		Enumeration			en;
		RelationInstance	ri, ri1;
		EntityInstance		other, parent;

		for (en = me.srcRelationElements(); en.hasMoreElements(); ) {
			ri    = (RelationInstance) en.nextElement();
			other = ri.getDst();
			if (other != me) {
				if (ri.getRelationClass() == containsClass) {
					ri1 = other.getContainedByRelation(containsClass);
					if (ri1 != null) {
						parent = ri1.getSrc();
						parent.removeSrcRelation(ri1);
						other.removeDstRelation(ri1);
						parent.removeContainment(other);
					}
					other.addDstRelation(ri);
					me.addContainment(other);
				} else {
					other.addDstRelation(ri);
		}	}	}

		parent = null;
		for (en = me.dstRelationElements(); en.hasMoreElements(); ) {
			ri    = (RelationInstance) en.nextElement();
			other = ri.getSrc();
			if (other != me) {
				other.addSrcRelation(ri);
				if (ri.getRelationClass() == containsClass) {
					parent = other;
					parent.addContainment(me);
		}	}	}
		return parent;
	}

	// We are cutting this entity

	public boolean cutEntity(EntityInstance e)
	{
		if (e == m_rootInstance) {
			error("Can't cut the root node in the diagram");
			return false;
		}

		EntityInstance parent    = e.getContainedBy();

		// Hide all edges out of whats cut
		disconnectEdges(e, e);

		// Remove our image from the diagram
		parent.removeContainment(e);

		m_taListener.entityCut(e);
		return true;
	}

	public boolean cutClipboard(Clipboard clipboard)
	{
		boolean ok = !clipboard.contains(m_rootInstance);

		if (!ok) {
			error("Can't cut the root node in the diagram");
		} else {
			int					i, size;
			EntityInstance		e;

			size    = clipboard.size();
			for (i = 0; i < size; ++i) {
				// Cut children and then ancestors
				e = (EntityInstance) clipboard.elementAt(i);
				cutEntity(e);
			}
			prepostorder();		// Can do at end when cutting
			m_diagram.setClipboard(clipboard);
			m_diagram.redrawDiagram();
		}
		return(ok);
	}

	public void pasteClipboard(Clipboard clipboard, EntityInstance container)
	{
		ClipboardEnumerator	en;
		EntityInstance		e;

		// Paste all elements in the composite clipboard
		for (en = clipboard.clipboardElements(); en.hasMoreElements(); ) {
			e = (EntityInstance) en.nextElement();
			pasteEntity(container, e);	// Uncached
		}
		// Erase current clipboard
		m_diagram.setClipboard(null);
		m_diagram.redrawDiagram();
	}


	public void pasteEntity(EntityInstance parent, EntityInstance e)
	{
		RelationInstance ri;

		if (parent == null) {
			ri     = null;
			parent = e.getContainedBy();
		} else {
			ri = e.getContainedByRelation(getContainsClass());
			ri.setSrc(parent);
		}
		reconnectEdges(e);
		prepostorder();
		// Add our image into the diagram
		if (parent != null) {
			parent.addContainment(e);
		}
		m_taListener.entityPasted(e);
	}

	public boolean moveEntityContainment(EntityInstance parent, EntityInstance e)
	{
		EntityInstance oldParent = e.getContainedBy();

		if (oldParent == parent) {
			return false;
		}
		m_taListener.entityBeingMoved(e);
		oldParent.removeContainment(e);
		e.setContainedBy(parent);
		parent.addContainment(e);
		prepostorder();
		m_taListener.entityMoved(e);
		return true;
	}
		
	public EntityInstance clusterEntity(EntityInstance container, EntityInstance e)
	{
		EntityInstance	ret;
		EntityClass		ec = e.getEntityClass();	// In other TA

		if (ec != null) {
			ec = getEntityClass(ec.getId());
		}

		if (ec == null) {
			ec = m_defaultEntityClass;
			if (ec == null) {
				ec = m_entityBaseClass;
		}	}

		String	ename = e.getId();
		if (entityExists(ename)) {
			int				n;
			for (n = 0; ; ++n) {
				ename = "Entity#" + n;
				if (!entityExists(ename)) {
					break;
		}	}	}
		ret = ec.newEntity(ename);
		putCache(ret);	
		addEdge(container, ret, getContainsClass());
		if (e.xRelLocal() >= 0 && e.yRelLocal() >= 0 && e.widthRelLocal() > 0 && e.heightRelLocal() > 0) {
			ret.setRelLocal(e);
		}
		return(ret);
	}
 
	// Used by ClusterInterface to move an entity from one TA to another
	// Container is the container the entity is to be contained in
	// match is the entity in my TA

	public EntityInstance importEntity(EntityInstance container /* My TA */, EntityInstance e /* Other TA */, EntityInstance match /* Corresponding thing in my TA */)
	{
		EntityClass	ec = e.getEntityClass();	// In other TA

		if (ec != null) {
			ec = getEntityClass(ec.getId());
		}
		if (ec != null) {
			match.setParentClass(ec);
		}
		moveEntityContainment(container, match);
		if (e.xRelLocal() >= 0 && e.yRelLocal() >= 0 && e.widthRelLocal() > 0 && e.heightRelLocal() > 0) {
			match.setRelLocal(e);
		}
		return(match);
	}

	// We are cutting this container but not its contents
	// May not cut the root of the forest

	public void deleteContainer(EntityInstance e)
	{
		EntityInstance parent;

		parent = disconnectEdgesJustMe(e);

		if (parent == null) {
			EntityInstance	child = e.getFirstChild();
			m_rootInstance = child;
			parent         = child;
		}
		markDeleted(e);
		m_taListener.containerCut(parent, e);
	}

	public void undeleteContainer(EntityInstance e)
	{
		EntityInstance parent;

		parent = reconnectEdgesJustMe(e);
		clearDeleted(e);
		m_taListener.containerUncut(e);
	}

	public void removeEntityClass(EntityClass ec)
	{
		Enumeration		en;
		RelationClass	rc;
		Vector			relationList;
		EntityClassPair	ep;
			int				i;
			
		for (en = m_relationClasses.elements(); en.hasMoreElements(); ) {
			rc           = (RelationClass) en.nextElement(); 
			relationList = rc.getRelationList();
			if (relationList != null) {
				for (i = relationList.size(); i > 0; ) {
					ep = (EntityClassPair) relationList.elementAt(--i);
					if (ep.m_entityClass1 == ec || ep.m_entityClass2 == ec) {
						relationList.removeElementAt(i);
		}	}	}	}

		if (m_defaultEntityClass == ec) {
			setDefaultEntityClass(m_entityBaseClass);
		}
		m_entityClasses.remove(ec.getId());
		m_taListener.classChanges();
	}

	public void removeRelationClass(RelationClass rc)
	{
		if (m_defaultRelationClass == rc) {
			setDefaultRelationClass(m_relationBaseClass);
		}
		m_relationClasses.remove(rc.getId());
		m_taListener.classChanges();
	}
}

