package lsedit;

import java.awt.Color;
import java.util.Vector;
import java.io.IOException;
import java.io.PrintStream;

import javax.swing.undo.UndoableEdit;

public class EntityClass extends LandscapeClassObject /* extends LandscapeObject3D extends LandscapeObject */ 
{
	public static final String ENTITY_BASE_CLASS_ID		= "$ENTITY";

	protected static final String CLASSANGLE_ID = "class_angle";
	protected static final String CLASSIMAGE_ID = "class_image";

	public static final int	ID_ATTR				= 0;
	public static final int	CLASSLABEL_ATTR		= 1;
	public static final int	CLASSDESC_ATTR		= 2;
	public static final int	CLASSSTYLE_ATTR		= 3;
	public static final int	CLASSANGLE_ATTR		= 4;
	public static final int	CLASSIMAGE_ATTR		= 5;
	public static final int	COLOR_ATTR			= 6;
	public static final int	LABEL_COLOR_ATTR	= 7;
	public static final int	OPEN_COLOR_ATTR		= 8;
	public static final int ATTRS               = 9;

	public static final String[] attributeName =
	{
		"id",
		CLASSLABEL_ID,
		CLASSDESC_ID,
		CLASSSTYLE_ID,
		CLASSANGLE_ID,
		CLASSIMAGE_ID,
		COLOR_ID,
		LABEL_COLOR_ID,
		OPEN_COLOR_ID
	};

	public static final int[] attributeType =
	{
		Attribute.STRING_TYPE,
		Attribute.STRING_TYPE,
		Attribute.TEXT_TYPE,
		Attribute.ENTITY_STYLE_TYPE,
		Attribute.DOUBLE_TYPE,
		Attribute.ENTITY_IMAGE_TYPE,
		Attribute.COLOR_OR_NULL_TYPE,
		Attribute.COLOR_OR_NULL_TYPE,
		Attribute.COLOR_OR_NULL_TYPE
	};


	public static final int ENTITY_STYLE_NONE           = -1;
	public static final int ENTITY_STYLE_3DBOX			= 0;
	public static final int ENTITY_STYLE_2DBOX			= 1;
	public static final int ENTITY_STYLE_FILE			= 2;
	public static final int ENTITY_STYLE_DISK			= 3;
	public static final int ENTITY_STYLE_FOLDER			= 4;
	public static final int ENTITY_STYLE_SOURCEOBJ		= 5;
	public static final int ENTITY_STYLE_CLASS			= 6;
	public static final int ENTITY_STYLE_GROUP			= 7;
	public static final int ENTITY_STYLE_LABELLED_GROUP = 8;
	public static final int ENTITY_STYLE_TRIANGLE       = 9;
	public static final int ENTITY_STYLE_ROMBUS		    = 10;
	public static final int ENTITY_STYLE_TRAPEZOID      = 11;
	public static final int ENTITY_STYLE_TRIANGLE2      = 12;

	public static final int ENTITY_STYLE_RECTANGLE      = 13;
	public static final int ENTITY_STYLE_PENTAGON       = 14;
	public static final int ENTITY_STYLE_HEXAGON        = 15;
	public static final int ENTITY_STYLE_OCTAGON        = 16;
	public static final int ENTITY_STYLE_DECAHEDRON     = 17;
	public static final int ENTITY_STYLE_12SIDED        = 18;
	public static final int ENTITY_STYLE_14SIDED        = 19;
	public static final int ENTITY_STYLE_16SIDED        = 20;
	public static final int ENTITY_STYLE_18SIDED        = 21;
	public static final int ENTITY_STYLE_20SIDED        = 22;
	public static final int ENTITY_STYLE_PAPER          = 23;
	public static final int ENTITY_STYLE_SUNK_BOX       = 24;


	public static final String[] styleName =
		{ 
				"3D Box", 
				"2D Box", 
				"File", 
				"Disk", 
				"Folder", 
				"Source Object", 
				"Class", 
				"Group", 
				"Labelled Group",
				"Triangle  (directed)",
				"Rombus    (directed)",
				"Trapezoid (directed)",
				"3-sided  Triangle",
				"4-sided  Diamond",
				"5-sided  Pentagon",
				"6-sided  Hexagon",
				"8-sided  Octagon",
				"10-sided Decahedron",
				"12 sided Polygon",
				"14 sided Polygon",
				"16 sided Polygon",
				"18 sided Polygon",
				"20 sided Dodecahedron",
				"Paper",
				"Sunken Box"
		};


	public static final int ENTITY_IMAGE_NONE           =   0x00;
	public static final int ENTITY_IMAGE_ACTOR          =   0x01;
	public static final int ENTITY_IMAGE_OVAL           =   0x02;
	public static final int ENTITY_IMAGE_FRAME          =   0x04;
	public static final int ENTITY_IMAGE_ROUNDED_FRAME  =   0x08;
	public static final int ENTITY_IMAGE_X              =   0x10;

	public static final int ENTITY_IMAGE_LAST           =   ENTITY_IMAGE_X;

	public static final String[] imageName =
		{ 
				"Actor",
				"Oval",
				"Frame",
				"Rounded Frame",
				"X"
		};

	protected int		m_image = 0;
	protected double	m_angle = 0;

	private boolean	m_shown = true;
	private	int		m_orderedId;

	// ----------------
	// Exported methods
	// ----------------

	// Constructor 

	public EntityClass(String id, int nid, Ta ta) 
	{
		super(ta);
		setId(id);
		setNid(nid); 
		setLabel(id); 
	}

	public void setOrderedId(int orderedId)
	{
		m_orderedId = orderedId;
	}

	public int getOrderedId()
	{
		return(m_orderedId);
	}

	public static String getEntityStyleName(int style) 
	{
		if (style < 0 || style >= EntityClass.styleName.length) {
			return "";
		}
		return styleName[style];
	}

	public String getStyleName(int style)
	{
		return EntityClass.getEntityStyleName(style);
	}

	public int	getImage()
	{
		return m_image;
	}

	public void setImage(int image)
	{
		m_image = image;
	}

	class SetImage extends MyUndoableEdit implements UndoableEdit
	{
		int                  m_old;
		int                  m_new;

		SetImage(int old)
		{
			m_old = old;
			m_new = getImage();
			logEdit(this);
		}

		public String getPresentationName() 
		{
			return EntityClass.this + " Change Image";
		}

		public void undo()
		{
			setImage(m_old);
		}

		public void redo()
		{
			setImage(m_new);
	}	}

	public void updateImage(int value)
	{
		int	old = m_image;
		if (old != value) {
			setImage(value);
			if (undoEnabled()) {
				new SetImage(old);
	}	}	}

	public double	getAngle()
	{
		return m_angle;
	}

	public void setAngle(double angle)
	{
		m_angle = angle;
	}

	class SetAngle extends MyUndoableEdit implements UndoableEdit
	{
		double               m_old;
		double               m_new;

		SetAngle(double old)
		{
			m_old = old;
			m_new = getAngle();
			logEdit(this);
		}	

		public String getPresentationName() 
		{
			return EntityClass.this + " Angle " + m_new;
		}

		public void undo()
		{
			setAngle(m_old);
		}

		public void redo()
		{
			setAngle(m_new);
	}	}

	public void updateAngle(double value)
	{
		double	old = m_angle;

		if (value != old) {
			setAngle(value);
			if (undoEnabled()) {
				new SetAngle(old);
	}	}	}

	public void setShown(boolean value)
	{
		if (m_shown != value) {
			if (!value) {
				Diagram	diagram = getDiagram();
				if (diagram != null) {
					Vector grp = getDiagram().getGroup();

					if (grp != null) {
						int				i;
						EntityInstance	e;
						EntityClass		ec;
						boolean			seenKeyEntry = false;

						for (i = grp.size(); --i >= 0; ) {
							e  = (EntityInstance) grp.elementAt(i);
							ec = e.getEntityClass();
							if (ec == this) {
								e.clearGroupFlag();
								grp.removeElementAt(i);
							} else {
								seenKeyEntry |= e.getGroupKeyFlag();
						}	}
						if (!seenKeyEntry && grp.size() > 0) {
							e = (EntityInstance) grp.elementAt(0);
							e.setGroupKeyFlag();
			}	}	}	}
			m_shown = value;
	}	}

	public boolean isShown()
	{
		return(m_shown);
	}

	protected boolean processClassAttributes(Attribute attr) 
	{
		if (attr.avi != null) {

			if (attr.id.equals(CLASSIMAGE_ID)) {
				setImage(Util.parseInt(attr.avi.value));
				return true;
			}
			if (attr.id.equals(CLASSANGLE_ID)) {
				setAngle(Util.parseReal(attr.avi.value));
				return true;
			}

			if (super.processClassAttributes(attr)) {
				return true;
			}
		}
		return false;
	}
	public void writeAttributes(PrintStream ps) throws IOException {

		ps.print(qt(getId()) + " {\n");
		super.writeAttributes(ps);

		double angle = getAngle();

		if (angle != 0) {
			ps.print(Attribute.indent + CLASSANGLE_ID + " = " + angle + "\n");
		}


		int image = getImage();

		if (image != 0) {
			ps.print(Attribute.indent + CLASSIMAGE_ID + " = " + image + "\n");
		}
		ps.print("}\n\n"); 
	}

	public void reportClassAttributes(ResultBox resultBox)
	{
		super.reportClassAttributes(resultBox);
		resultBox.addText(CLASSIMAGE_ID);
		resultBox.addText(CLASSANGLE_ID);
	}

	public EntityInstance newEntity(String id) 
	{
		EntityInstance e = new EntityInstance(this, id);
		return e;
	}

	public void shapeChanges(int oldStyle, double oldAngle)
	{
		Diagram			diagram;
		EntityInstance	root;
		int				style;

		style = getInheritedStyle();
		if (oldStyle == style) {
			if (style < ENTITY_STYLE_TRIANGLE || style > ENTITY_STYLE_20SIDED) {
				// Changing the angle is irrelevant for this style
				return;
		}	}

		diagram = getDiagram();
		if (diagram != null) {
			root = diagram.getRootInstance();
			if (root == null) {
				return;
			}
			root.shapeChanges(this);
	}	}

	// The routines that follow hide the complexity of getting/setting attribute values
	// from EditAttributes

	public int getPrimaryAttributeCount()
	{
		return(ATTRS);
	}

	public String getLsAttributeNameAt(int index)
	{
		String	name;

		if (index < ATTRS) {
			name = attributeName[index];
		} else {
			name  = super.getLsAttributeNameAt(index);
		}
		return(name);
	}

	// Need to know the type in cases where value might be null
	// For example with some colors

	public int getLsAttributeTypeAt(int index)
	{
		int		ret;
	
		if (index < ATTRS) {
			ret = attributeType[index];
		} else {
			ret = super.getLsAttributeTypeAt(index);
		}
		return(ret);
	}

	public Object getLsAttributeValueAt(int index)
	{
		Object	value;

		switch (index) {
		case ID_ATTR:
			value = getId();
			break;
		case CLASSLABEL_ATTR:
			value = getLabel();
			break;
		case CLASSDESC_ATTR:
			value = getDescription();
			break;
		case CLASSSTYLE_ATTR:
			value = new Integer(getStyle());
			break;
		case CLASSANGLE_ATTR:
			value = new Double(getAngle());
			break;
		case CLASSIMAGE_ATTR:
			value = new Integer(getImage());
			break;
		case COLOR_ATTR:
			value = getObjectColor();
			break;
		case LABEL_COLOR_ATTR:
			value = getLabelColor();
			break;
		case OPEN_COLOR_ATTR:
			value = getColorWhenOpen();
			break;
		default:
			value = super.getLsAttributeValueAt(index);
		}
		return(value);
	}

	public void updateAttributeValueAt(int index, Object value)
	{
		switch (index) {
		case EntityClass.ID_ATTR:
			setId((String) value);
			break;
		case EntityClass.CLASSLABEL_ATTR:
			updateLabel((String) value);
			break;
		case EntityClass.CLASSDESC_ATTR:
			updateDescription((String) value);
			break;
		case EntityClass.CLASSSTYLE_ATTR:
			updateStyle(((Integer) value).intValue());
			break;
		case EntityClass.CLASSANGLE_ATTR:
			updateAngle(((Double) value).doubleValue());
			break;
		case EntityClass.CLASSIMAGE_ATTR:
			updateImage(((Integer) value).intValue());
			break;
		case EntityClass.COLOR_ATTR:
			updateObjectColor((Color) value);
			break;
		case EntityClass.LABEL_COLOR_ATTR:
			updateLabelColor((Color) value);
			break;
		case EntityClass.OPEN_COLOR_ATTR:
			updateColorWhenOpen((Color) value);
			break;
		default:
			super.updateAttributeValueAt(index, value);
	}	}
}



