package lsedit;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.undo.UndoableEdit;

// Entities in a landscape 

class EntityBelow implements Enumeration
{
	Vector				m_srcRelList;
	RelationClass		m_rc;
	int					m_next;
	RelationInstance	m_ri;

	private void advance(int i)
	{
		Vector				srcRelList    = m_srcRelList;
		RelationClass		rc            = m_rc;
		int					size          = srcRelList.size();
		RelationInstance	ri;
		RelationClass		rc1;

		for (;;) {
			if (++i >= size) {
				m_ri = null;
				break;
			}
			ri = (RelationInstance) srcRelList.elementAt(i);
			rc1 = ri.getRelationClass();
			if (rc1 == rc) {
				m_ri = ri;
				break;
		}	}
		m_next = i;
	}
	
	public EntityBelow(Vector srcRelList, RelationClass rc)
	{
		m_srcRelList    = srcRelList;
		m_rc            = rc;
		advance(-1);
	}

	public boolean hasMoreElements()
	{
		return (m_ri != null);
	}

	public Object nextElement()
	{
		RelationInstance ri = m_ri;
		advance(m_next);
		return ri.getDst();
}	}

class EntityChildren implements Enumeration
{
	Vector				m_srcRelList;
	int					m_next;
	RelationInstance	m_ri;

	private void advance(int i)
	{
		Vector				srcRelList    = m_srcRelList;
		int					size          = srcRelList.size();
		RelationInstance	ri;
		RelationClass		rc;

		for (;;) {
			if (++i >= size) {
				m_ri = null;
				break;
			}
			ri = (RelationInstance) srcRelList.elementAt(i);
			rc = ri.getRelationClass();
			if (rc.isContainsClass()) {
				m_ri = ri;
				break;
		}	}
		m_next = i;
	}
			

	public EntityChildren(Vector srcRelList)
	{
		m_srcRelList    = srcRelList;
		advance(-1);
	}

	public boolean hasMoreElements()
	{
		return (m_ri != null);
	}

	public Object nextElement()
	{
		RelationInstance ri = m_ri;
		advance(m_next);
		return ri.getDst();
}	}

class EntityParents implements Enumeration
{
	Vector				m_dstRelList;
	int					m_next;
	RelationInstance	m_ri;

	private void advance(int i)
	{
		Vector				dstRelList    = m_dstRelList;
		int					size          = dstRelList.size();
		RelationInstance	ri;
		RelationClass		rc;

		for (;;) {
			if (++i >= size) {
				m_ri = null;
				break;
			}
			ri = (RelationInstance) dstRelList.elementAt(i);
			rc = ri.getRelationClass();
			if (rc.isContainsClass()) {
				m_ri = ri;
				break;
		}	}
		m_next = i;
	}

	public EntityParents(Vector dstRelList)
	{
		m_dstRelList    = dstRelList;
		advance(-1);
	}

	public boolean hasMoreElements()
	{
		return (m_ri != null);
	}

	public Object nextElement()
	{
		RelationInstance ri = m_ri;
		advance(m_next);
		return ri.getSrc();
}	}

class EntityPosition
{
	double	m_xrelLocal	     = -1.0;
	double	m_yrelLocal      = -1.0;
	double	m_widthrelLocal  = -1.0;
	double	m_heightrelLocal = -1.0;
};

public class EntityInstance extends LandscapeObject3D /* extends LandscapeObject */ implements Icon, DiagramCoordinates, MouseListener, MouseMotionListener {

	// Final values
	
	public final static int SMALL_FONT = 0;
	public final static int REG_FONT   = 1;

	public final static String LABEL_ID =			 "label";
	public final static String XPOSITION_ID =		 "x";
	public final static String YPOSITION_ID =		 "y";
	public final static String WIDTH_ID =			 "width";
	public final static String HEIGHT_ID =			 "height";

	public final static String XRELPOSITION_ID =	 "xrel";
	public final static String YRELPOSITION_ID =	 "yrel";
	public final static String WIDTHREL_ID =		 "widthrel";
	public final static String HEIGHTREL_ID =		 "heightrel";

	public final static String IN_ELISION_ID =		 "elision";
	public final static String OUT_ELISION_ID =		 "outelision";
	public final static String CLIENT_ELISION_ID =	 "clientelision";
	public final static String SUPPLIER_ELISION_ID = "supplierelision";
	public final static String INTERNAL_ELISION_ID = "internalelision";
	public final static String AGG_ELISION_ID =		 "aggelision";
	public final static String NAVLINK_ID =			 "navlink";
	public final static String INPOINT_ID =			 "inpoints";
	public final static String OUTPOINT_ID =		 "outpoints";
	public final static String LEFTPOINT_ID =		 "leftpoints";
	public final static String RIGHTPOINT_ID =		 "rightpoints";
	public final static String DESC_ID =			 "description";
	public final static String TITLE_ID =			 "title";
	public final static String FONTDELTA_ID =		 "fontdelta";


	public static final int	ID_ATTR				= 0;
	public static final int	CLASS_ATTR			= 1;
	public static final int	LABEL_ATTR			= 2;
	public static final int	TITLE_ATTR			= 3;
	public static final int	DESC_ATTR			= 4;
	public static final int	COLOR_ATTR			= 5;
	public static final int	LABEL_COLOR_ATTR	= 6;
	public static final int	OPEN_COLOR_ATTR		= 7;
	public static final int XRELPOSITION_ATTR   = 8;
	public static final int YRELPOSITION_ATTR   = 9;
	public static final int WIDTHREL_ATTR		= 10;
	public static final int HEIGHTREL_ATTR		= 11;
	public static final int FONTDELTA_ATTR      = 12;
	public static final int ATTRS               = 13;

	public static final String[] attributeName =
	{
		"id",
		"class",
		LABEL_ID,
		TITLE_ID,
		DESC_ID,
		COLOR_ID,
		LABEL_COLOR_ID,
		OPEN_COLOR_ID,
		XRELPOSITION_ID,
		YRELPOSITION_ID,
		WIDTHREL_ID,
		HEIGHTREL_ID,
		FONTDELTA_ID
	};

	public static final int[] attributeType =
	{
		Attribute.STRING_TYPE,
		Attribute.ENTITY_CLASS_TYPE,
		Attribute.STRING_TYPE,
		Attribute.STRING_TYPE,
		Attribute.TEXT_TYPE,
		Attribute.COLOR_OR_NULL_TYPE,
		Attribute.COLOR_OR_NULL_TYPE,
		Attribute.COLOR_OR_NULL_TYPE,
		Attribute.DOUBLE_TYPE,
		Attribute.DOUBLE_TYPE,
		Attribute.DOUBLE_TYPE,
		Attribute.DOUBLE_TYPE,
		Attribute.INT_TYPE
	};

	public  final static int RSZ_NONE = -1;
	private final static int RSZ_NW	= 0;
	private final static int RSZ_N	= 1;
	private final static int RSZ_NE	= 2; 
	private final static int RSZ_E	= 3;
	private final static int RSZ_SE	= 4;
	private final static int RSZ_S	= 5;
	private final static int RSZ_SW	= 6;
	private final static int RSZ_W	= 7;

	// Annotation tab constants

	private final static double TAB_HEIGHT = 16.0; 

	private final static int MOUSE_NEAR_EDGE_THRESHOLD = 4;
	private final static int SEP_THRESHOLD = 8;

	// Static font info 

	private final static int MARGIN = 5; 
	private final static int MIN_HEIGHT = 10;
	private final static int MIN_WIDTH = 30;

	private final static int CONTENTS_FLAG_DIM = 8;


	public final static String DEFAULT_OPEN_CLASS_FONT_NAME  = FontCache.DEFAULT_FONT_NAME;
	public final static int	   DEFAULT_OPEN_CLASS_FONT_STYLE = Font.PLAIN;
	public final static int    DEFAULT_OPEN_CLASS_FONT_SIZE  = 12;

	protected     static Font	m_openClassFont = FontCache.get(DEFAULT_OPEN_CLASS_FONT_NAME, DEFAULT_OPEN_CLASS_FONT_STYLE, DEFAULT_OPEN_CLASS_FONT_SIZE);

	public final static String DEFAULT_CLOSED_FONT_NAME      = FontCache.DEFAULT_FONT_NAME;
	public final static int    DEFAULT_CLOSED_FONT_STYLE     = Font.PLAIN;
	public final static int    DEFAULT_CLOSED_FONT_SIZE      = 12;

	protected	  static Font   m_closedFont    = FontCache.get(DEFAULT_CLOSED_FONT_NAME, DEFAULT_CLOSED_FONT_STYLE, DEFAULT_CLOSED_FONT_SIZE);

	public final static String DEFAULT_SMALL_FONT_NAME       = FontCache.DEFAULT_FONT_NAME;
	public final static int    DEFAULT_SMALL_FONT_STYLE      = Font.PLAIN;
	public final static int    DEFAULT_SMALL_FONT_SIZE      = 10;

	protected     static Font   m_smallFont     = FontCache.get(DEFAULT_SMALL_FONT_NAME, DEFAULT_SMALL_FONT_STYLE, DEFAULT_SMALL_FONT_SIZE);

	// Bits set in m_mark
	
	public final static int	DIAGRAM_MARK		= 0x01;		// This entity is visible in the main diagram  (at present)
	public final static int	CLIENT_MARK			= 0x02;		// This entity is in the set of clients   (at present)
	public final static int SUPPLIER_MARK		= 0x04;		// This entity is in the set of suppliers (at present)

	public final static int HIGHLIGHT_EDGE_MARK	= 0x01000;		// Highlight the edge of the object
	public final static int REDBOX_MARK         = 0x08000;	// Mark this box in deep red for (forward/back) edge tracing     
	public final static int	GROUP_MARK			= 0x10000;	// This entity is part of a group
	public final static int GROUPKEY_MARK		= 0x20000;	// This entity is the key entity in the group
	public final static int	OPEN_MARK			= 0x40000;	// This entity is open
	public final static int CLOSED_MARK			= 0x80000;	// This entity is closed

	public final static int CLIENT_SUPPLIER     = CLIENT_MARK | SUPPLIER_MARK;
	public final static int IN_DIAGRAM          = CLIENT_SUPPLIER | DIAGRAM_MARK;
	public final static int PRESENTATION_MARKS  = HIGHLIGHT_EDGE_MARK | REDBOX_MARK | GROUP_MARK | GROUPKEY_MARK;

	public final static int	IN_TREE_MARK		= 0x100000;
	public final static int	LIFTED_MARK			= 0x200000;
	public final static int IN_GRAPH_MARK       = 0x400000;

	/* Conceptually an EntityInstance should derive from a BendPoint but it is hard to change
	 * everything to have relations point at bend points that may or may not be EntityInstances
	 * For now take the hit of wasting memory by having a bend point internally represented by
	 * a zero size EentityInstance.
	 */

	public final static int DUMMY_NODE_MARK     = 0x800000;
	public final static int HAS_LABEL_MARK      = 0x1000000;
	public final static int DELETED_MARK        = 0x2000000;
	public final static int SPRING_MARK         = 0x4000000;
	public final static int	SHADING_KNOWN_MARK  = 0x10000000;
	public final static int	SHADES_MARK			= 0x20000000;


	public final static int PERMANENT_MARKS     = DUMMY_NODE_MARK | HAS_LABEL_MARK | DELETED_MARK;

	
	public final static double WIDTHRELLOCAL_DEFAULT  = 15.0/16.0;
	public final static double HEIGHTRELLOCAL_DEFAULT = 15.0/16.0;

	private static EntityInstance m_currentDescEntity = null;	// The current entry being described in the feedback box
	
	private int				m_mark = 0;
	private String			m_title;					// The title of this entity

	// First order attributes

	private Vector	 m_dstElision;
	private Vector	 m_srcElision;
	private Vector	 m_enteringElision;
	private Vector	 m_exitingElision;
	private Vector	 m_internalElision;

	private EdgePoint[] m_topPoints, m_bottomPoints, m_leftPoints, m_rightPoints;


	// We need the position within the diagram to compute coordinates for edges quickly

	private int		m_diagramX         = Integer.MIN_VALUE;
	private int		m_diagramY         = Integer.MIN_VALUE;

	// We need the bounds to be used when EntityComponents are created and manipulated

	private int		m_x;
	private int		m_y;
	private int		m_width;
	private int		m_height;

	// These are the master coordinates with respect to the parent node

	protected double	m_xrelLocal	     = -1.0;
	protected double	m_yrelLocal      = -1.0;
	protected double	m_widthrelLocal  = -1.0;
	protected double	m_heightrelLocal = -1.0;

	protected EntityPosition[] m_positions = null;

	// These are the top left coordinates of the object on the screen

	private int			m_fontDelta     = 0;

	private int			m_preorder;
	private int			m_postorder;
	
	/* keep tight control over the group flags so can draw changes at a low level */

	private Vector m_srcRelList    = new Vector();	// List of relations for which this entity is the source 
	private Vector m_dstRelList    = new Vector();	// List of relations for which this entity is the destination 
	private Vector m_srcLiftedList = new Vector();	// List of relations whose source is lifted to leave this entity
	private Vector m_dstLiftedList = new Vector();	// List of relations whose destination is lifted to address this entity

	// Stat gathering

/*
	private int m_debug_x      = Integer.MIN_VALUE;
	private int m_debug_y      = Integer.MIN_VALUE;
	private int m_debug_width  = Integer.MIN_VALUE;
	private int m_debug_height = Integer.MIN_VALUE;
*/
	// ---------------
	// Wrapper methods
	// ---------------

	// Used by legend box

	public EntityComponent neededPlainComponent()
	{
		EntityComponent entityComponent = (EntityComponent) getSwingObject();
		if (entityComponent == null) {
			entityComponent = new EntityComponent(this);
		}
		return(entityComponent);
	} 

	public void setToolTipText(EntityComponent entityComponent)
	{
		String text;

		if (isDrawRoot()) {
			text = null;
		} else {
			text = getFullEntityLabel();
		}
		entityComponent.setToolTipText(text);
	}
	
	public void setToolTipText()
	{
		EntityComponent	component = (EntityComponent) getSwingObject();
		
		if (component != null) {
			setToolTipText(component);
	}	}

	public void areaMoved()
	{
		if (isMarked(SHADING_KNOWN_MARK)) {
			EntityComponent	component = (EntityComponent) getSwingObject();
			if (component != null) {
				component.areaMoved();
	}	}	}

	public void areaChanged()
	{
		EntityComponent	component = (EntityComponent) getSwingObject();
		
		if (component != null) {
			component.areaChanged();
	}	}
		
	public EntityComponent neededComponent()
	{
		EntityComponent entityComponent = (EntityComponent) getSwingObject();
		if (entityComponent == null) {
			entityComponent = new EntityComponent(this);
			// Do this here so that the legend use of entities isn't compromised
			setToolTipText(entityComponent);
			entityComponent.addMouseListener(this);
			entityComponent.addMouseMotionListener(this);

		}
		return(entityComponent);
	} 

	private Vector neededDstElision()
	{
		Vector dstElision = m_dstElision;
		if (dstElision == null) {
			m_dstElision = dstElision = new Vector();
		}
		return(dstElision);
	}
	
	private Vector neededSrcElision()
	{
		Vector srcElision = m_srcElision;
		if (srcElision == null) {
			m_srcElision = srcElision = new Vector();
		}
		return(srcElision);
	}
	
	private Vector neededEnteringElision()
	{
		Vector enteringElision = m_enteringElision;
		if (enteringElision == null) {
			m_enteringElision = enteringElision = new Vector();
		}
		return(enteringElision);
	}
	
	private Vector neededExitingElision()
	{
		Vector exitingElision = m_exitingElision;
		if (exitingElision == null) {
			m_exitingElision = exitingElision = new Vector();
		}
		return(exitingElision);
	}
	
	private Vector neededInternalElision()
	{
		Vector internalElision = m_internalElision;
		if (internalElision == null) {
			m_internalElision = internalElision = new Vector();
		}
		return(internalElision);
	}

	public static Font getClosedFont()
	{
		return m_closedFont;
	}

	public Font getAdjustedClosedFont()
	{
		Font closedFont = m_closedFont;
		int	 delta      = m_fontDelta;

		if (delta != 0) {
			String fontname = closedFont.getFamily();
			int    style    = closedFont.getStyle();
			int	   size     = closedFont.getSize();
		
			size += delta;
			if (size < 1) {
				size = 1;
			}
			closedFont = FontCache.get(fontname, style, size);
		}
		return closedFont;
	}

	public static void setClosedFont(Font font)
	{
		m_closedFont = font;
	}

	public static Font getOpenClassFont()
	{
		return m_openClassFont;
	}
			    
	public static void setOpenClassFont(Font font)
	{
		m_openClassFont = font;
	}

	public static Font getSmallFont() 
	{
		return m_smallFont;
	}

	public static void setSmallFont(Font font)
	{
		m_smallFont = font;
	}

	public void removeTreeFromCache(EntityCache entityCache)
	{
		Enumeration			children;
		EntityInstance		child;


		entityCache.remove(this);
		for (children = getChildren(); children.hasMoreElements(); ) {
			child = (EntityInstance) children.nextElement();
			child.removeTreeFromCache(entityCache);
	}	}

	public void addTreeToCache(EntityCache entityCache)
	{
		Enumeration			children;
		EntityInstance		child;


		entityCache.put(this);
		for (children = getChildren(); children.hasMoreElements(); ) {
			child = (EntityInstance) children.nextElement();
			child.addTreeToCache(entityCache);
	}	}

	public void removeAll()
	{
		JComponent entityComponent = getSwingObject();
		if (entityComponent != null) {
			entityComponent.removeAll();
	}	}

	public void setVisible(boolean value)
	{
		JComponent entityComponent;
		
		if (value) {
			entityComponent = neededComponent();
			entityComponent.setVisible(true);
		} else {
			entityComponent = (EntityComponent) getSwingObject();
			if (entityComponent != null) {
				entityComponent.setVisible(false);
	}	}	}
	
	public void repaint()
	{
		JComponent entityComponent = getSwingObject();

		if (entityComponent != null) {
			entityComponent.repaint();
	}	}
		
	public void validate()
	{
		JComponent entityComponent = getSwingObject();

		if (entityComponent != null) {
			entityComponent.validate();
	}	}

	public void paintMap(Graphics g, int x, int y, int width, int height, EntityInstance onPath, int depth)
	{
		EntityComponent entityComponent = neededComponent();

		entityComponent.paintMap(g, x, y, width, height, onPath, depth);
	}

	public int getX()
	{
		return(m_x);
	}

	public int getY()
	{
		return(m_y);
	}

	public int getWidth()
	{
		return(m_width);
	}

	public int getHeight()
	{
		return(m_height);
	}

	// --------------
	// Wrapper methods
	// ---------------

	protected EntityInstance getDrawRoot()
	{
		return(getDiagram().getDrawRoot());
	}

	public boolean isDrawRoot()
	{
		return (this == getDrawRoot());
	}

	protected int numRelationClasses()
	{
		return(getTa().numRelationClasses());
	}

	protected RelationClass numToRelationClass(int i)
	{
		return(getTa().numToRelationClass(i));
	}

	// -----------------
	// Protected methods
	// -----------------

	protected void setFont(Graphics g, int type) 
	{
		switch(type) {
		case SMALL_FONT:
			g.setFont(m_smallFont);
			return;
		default:
			g.setFont(getAdjustedClosedFont());
			return;
	}	}

	public int getFontDelta()
	{
		return(m_fontDelta);
	}

	protected boolean setFontDelta(int value) 
	{
		if (m_fontDelta != value) {
			m_fontDelta = value;
			repaint();
			return true;
		}
		return false;
	}

	class SetFontDelta extends MyUndoableEdit implements UndoableEdit
	{
		int                  m_old;
		int                  m_new;

		SetFontDelta(int old)
		{
			m_old = old;
			m_new = m_fontDelta;
			logEdit(this);
		}

		public String getPresentationName() 
		{
			return EntityInstance.this.toString() + " FontDelta " + m_new;
		}

		public void undo()
		{
			setFontDelta(m_old);
		}

		public void redo()
		{
			setFontDelta(m_new);
	}	}

	public void updateFontDelta(int value)
	{
		int	old = m_fontDelta;
		if (setFontDelta(value) && undoEnabled()) {
			new SetFontDelta(old);
	}	}

	// Determine the bounding box of all children

	public void shiftDeltaFont(int delta) 
	{
		updateFontDelta(m_fontDelta + delta);
	}

	public Color getCurrentLabelColor() 
	{
		if (isMarked(REDBOX_MARK) && !isOpen()) {
			return Color.yellow;
		}
		return getInheritedLabelColor();
	}

	//
	// Parse an attribute record to set the appropriate edge point factors
	// supplied in an attribute record.

	protected void parsePoints(EdgePoint[] ept, Attribute attr) 
	{
		AttributeValueItem avi;

		for (avi = attr.avi; avi != null; avi = avi.nextList) {
			RelationClass rc = getTa().getRelationClass(avi.value);

			if (rc != null) {
				int nid = rc.getNid();

				double wf = Util.parseReal(avi.next.value);
				double hf = Util.parseReal(avi.next.next.value);

				if (ept[nid] == null) {
					ept[nid] = new EdgePoint(this);
				} else {
					if (rc != ept[nid].getRc()) {
						MsgOut.println("Class nid mismatch");
				}	}
				ept[nid].setProperties(rc, wf, hf);
				ept[nid].hasMoved();
			}
		}
	}

	static protected Hashtable est = new Hashtable();

	protected void processElision(Attribute attr, Vector list) 
	{
		AttributeValueItem av;

		for (av = attr.avi; av != null; av = av.next) {
			String str = (String) est.get(av.value);
			if (str == null) {
				str = av.value;
				est.put(str, str);
			}
			if (!list.contains(str)) {
				list.addElement(str);
	}	}	}

	protected void processRawElision(String[] sl, Vector list) 
	{
		for (int i = 0; i<sl.length; ++i) {
			list.addElement(sl[i]);
		}
	}

	private	void setPositionArraySize(int lth)
	{
		EntityPosition[]	positions = m_positions;

		if (positions == null) {
			m_positions = positions = new EntityPosition[lth];
		} else if (positions.length < lth) {
			EntityPosition[]	oldpositions = positions;
			int					i;
			
			m_positions = positions = new EntityPosition[lth];

			for (i = oldpositions.length; --i >= 0; ) {
				positions[i] = oldpositions[i];
	}	}	}

	//
	// Parse the values of any first order attributes into their storage.
	// 

	// First thing called by EntityInstance::AddAttributes
	// If the attribute is a known member of storage -- don't save attribute -- just store value

	protected boolean processFirstOrderAttributes(Attribute attr)
	{
		AttributeValueItem	avi = attr.avi;
		AttributeValueItem	avi1;
		int					values;

		values = 0;
		for (avi1 = avi; avi1 != null; avi1 = avi1.next) {
			++values;
		}


		if (attr.hasId(XPOSITION_ID)) {			
			if (values > 0) {
				setxLocal(attr.parseReal());		// Only valid in legacy code
				attr.id = XRELPOSITION_ID;			// So right name gets registered (A cheat)
			}
			return true; 
		}

		if (attr.hasId(YPOSITION_ID)) {
			if (values > 0) {
				setyLocal(attr.parseReal());		// Only valid in legacy code
				attr.id = YRELPOSITION_ID;
			}
			return true; 
		}

		if (attr.hasId(WIDTH_ID)) {
			if (values > 0) {
				setwidthLocal(attr.parseReal());	// Only valid in legacy code
				attr.id = WIDTHREL_ID;
			}
			return true; 
		}

		if (attr.hasId(HEIGHT_ID)) {
			if (values > 0) {
				setheightLocal(attr.parseReal());	// Only valid in legacy code
				attr.id = HEIGHTREL_ID;
			}
			return true; 
		}

		if (attr.hasId(XRELPOSITION_ID)) {
			if (values > 0) {
				setXRelLocalBounded(attr.parseReal());
				if (values > 1) {
					setPositionArraySize(values);

					EntityPosition[] positions = m_positions;
					EntityPosition	 position;
					int				 i;

					i = 0;
					for (avi1 = avi; avi1 != null; avi1 = avi1.next) {
						position = positions[i];
						if (position == null) {
							m_positions[i] = position = new EntityPosition();
						}
						position.m_xrelLocal = Util.parseReal(avi1.value);
						++i;
			}	}	}
			return true; 
		}

		if (attr.hasId(YRELPOSITION_ID)) {
			if (values > 0) {
				setYRelLocalBounded(attr.parseReal());
				if (values > 1) {
					setPositionArraySize(values);

					EntityPosition[] positions = m_positions;
					EntityPosition	 position;
					int				 i;

					i = 0;
					for (avi1 = avi; avi1 != null; avi1 = avi1.next) {
						position = positions[i];
						if (position == null) {
							m_positions[i] = position = new EntityPosition();
						}
						position.m_yrelLocal = Util.parseReal(avi1.value);
						++i;
			}	}	}
			return true; 
		}

		if (attr.hasId(WIDTHREL_ID)) {
			if (values > 0) {
				setWidthRelLocalBounded(attr.parseReal());

				if (values > 1) {
					setPositionArraySize(values);

					EntityPosition[] positions = m_positions;
					EntityPosition	 position;
					int				 i;

					i = 0;
					for (avi1 = avi; avi1 != null; avi1 = avi1.next) {
						position = positions[i];
						if (position == null) {
							m_positions[i] = position = new EntityPosition();
						}
						position.m_widthrelLocal = Util.parseReal(avi1.value);
						++i;
			}	}	}
			return true; 
		}

		if (attr.hasId(HEIGHTREL_ID)) {
			if (values > 0) {
				setHeightRelLocalBounded(attr.parseReal());
				if (values > 1) {
					setPositionArraySize(values);

					EntityPosition[] positions = m_positions;
					EntityPosition	 position;
					int				 i;

					i = 0;
					for (avi1 = avi; avi1 != null; avi1 = avi1.next) {
						position = positions[i];
						if (position == null) {
							m_positions[i] = position = new EntityPosition();
						}
						position.m_heightrelLocal = Util.parseReal(avi1.value);
						++i;
			}	}	}
			return true; 
		}

		if (attr.hasId(LABEL_ID)) {
			if (values > 0) {
				setLabel(attr.parseString());
			}
			return true; 
		}

		if (attr.hasId(DESC_ID)) {
			if (values > 0) { 
				setDescription(attr.parseString());
			}
			return true; 
		} 

		if (attr.hasId(TITLE_ID)) {
			if (values > 0) {
				setTitle(attr.parseString());
			}
			return true;
		}

		if (attr.hasId(FONTDELTA_ID)) {
			if (values > 0) {
				setFontDelta(attr.parseInt());
			}
			return true; 
		}

		if (attr.hasId(COLOR_ID)) {
			if (values > 0) {
				setObjectColor(attr.parseColor());
			}
			return true;
		}

		if (attr.hasId(OPEN_COLOR_ID)) {
			if (values > 0) {
				setColorWhenOpen(attr.parseColor());
			}
			return true;
		}

		if (attr.hasId(LABEL_COLOR_ID)) {
			if (values > 0) {
				setLabelColor(attr.parseColor());
			}
			return true;
		}

		if (attr.hasId(IN_ELISION_ID)) {
			if (values > 0) { 
				processElision(attr, neededDstElision()); 
			}
			return true; 
		}

		if (attr.hasId(OUT_ELISION_ID)) {
			if (values > 0) {
				processElision(attr, neededSrcElision());
			}
			return true;
		}

		if (attr.hasId(CLIENT_ELISION_ID)) {
			if (values > 0) {
				processElision(attr, neededEnteringElision());
			}
			return true;
		}

		if (attr.hasId(SUPPLIER_ELISION_ID)) {
			if (values > 0) {
				processElision(attr, neededExitingElision());
			}
			return true;
		}

		if (attr.hasId(INTERNAL_ELISION_ID)) {
			if (values > 0) {
				processElision(attr, neededInternalElision());
			}
			return true;
		}

		if (attr.hasId(INPOINT_ID)) {
			if (values > 0) {
				if (m_topPoints == null) {
					m_topPoints = new EdgePoint[numRelationClasses()];
				}
				parsePoints(m_topPoints, attr);
			}
			return true; 
		}

		if (attr.hasId(OUTPOINT_ID)) {
			if (values > 0) {
				if (m_bottomPoints == null) {
					m_bottomPoints = new EdgePoint[numRelationClasses()];
				}
				parsePoints(m_bottomPoints, attr); 
			}
			return true; 
		}

		if (attr.hasId(LEFTPOINT_ID)) {
			if (values > 0) {
				if (m_leftPoints == null) {
					m_leftPoints = new EdgePoint[numRelationClasses()];
				}
				parsePoints(m_leftPoints, attr); 
			}
			return true; 
		}

		if (attr.hasId(RIGHTPOINT_ID)) {
			if (values > 0) {
				if (m_rightPoints == null) {
					m_rightPoints = new EdgePoint[numRelationClasses()];
				}
				parsePoints(m_rightPoints, attr); 
			}
			return true; 
		}

		return false; 
	}

	public static void reportFirstOrderAttributes(ResultBox resultBox)
	{
		resultBox.addText(XRELPOSITION_ID);
		resultBox.addText(YRELPOSITION_ID);
		resultBox.addText(WIDTHREL_ID);
		resultBox.addText(HEIGHTREL_ID);
		resultBox.addText(LABEL_ID);
		resultBox.addText(DESC_ID);
		resultBox.addText(TITLE_ID);
		resultBox.addText(FONTDELTA_ID);
		resultBox.addText(COLOR_ID);
		resultBox.addText(OPEN_COLOR_ID);
		resultBox.addText(LABEL_COLOR_ID);
		resultBox.addText(IN_ELISION_ID);
		resultBox.addText(OUT_ELISION_ID);
		resultBox.addText(CLIENT_ELISION_ID);
		resultBox.addText(SUPPLIER_ELISION_ID);
		resultBox.addText(INTERNAL_ELISION_ID);
		resultBox.addText(INPOINT_ID);
		resultBox.addText(OUTPOINT_ID);
		resultBox.addText(LEFTPOINT_ID);
		resultBox.addText(RIGHTPOINT_ID);

		resultBox.addResultTitle("Legacy first order attributes");
		resultBox.addText(XPOSITION_ID);
		resultBox.addText(YPOSITION_ID);
		resultBox.addText(WIDTH_ID);
		resultBox.addText(HEIGHT_ID);
	}

/*
	protected String endSet[] = { 
		".ss",
		".dup",
		"__funcdef",
		"__funcdcl",
		"__vardef",
		"__vardcl",
		"__macro", 
		"__struct", 
		"__union", 
		"__enum", 
		"__type"
	}; 

	public String mungeId(String id) 
	{
		if (id.length() > 0) {

			for (int i = 0; i < endSet.length; ++i) {
				if (id.endsWith(endSet[i])) {
					id = id.substring(0, id.length()-endSet[i].length());
					break;
				}
			}

			if (id.charAt(0) != '<') {
				int lpi = id.lastIndexOf('/');

				if (lpi < 0) {
					lpi = id.lastIndexOf('\\');
				}
				if (lpi >= 0 && id.length() != lpi+1) {
					return id.substring(lpi+1);
				}
			}
		}
		return id;
	}
*/

	// --------------
	// Public methods
	// --------------

 	public EntityInstance(EntityClass parentClass, String id) 
	{
		setParentClass(parentClass);
		super.setLabel(id);	         // The default
		setId(id);
	}

	/* We must know if we assign our label mungeId(id) as the default because we should write the TA we
	 * get in, and we don't want to loose explicit label statements al-la PR-82. Cludgy but don't want
	 * to incur storage cost of extra string field per Entity.
	 */

	public String getLabel()
	{
		if (isMarked(HAS_LABEL_MARK)) {
			return super.getLabel();
		}
		return null;
	}
		
	public void setLabel(String value)
	{
		if (value == null || Util.isBlank(value)) {
			if (isMarked(HAS_LABEL_MARK)) {
				super.setLabel(getId());
				m_mark &= ~HAS_LABEL_MARK;
			}
		} else {
			super.setLabel(value);
			orMark(HAS_LABEL_MARK);
	}	}

	public String getEntityLabel()
	{
		return super.getLabel();
	}

	public String getFullEntityLabel()
	{
		if (isMarked(HAS_LABEL_MARK)) {
			return super.getLabel();
		}
		return super.getId();
	}

	public String getClassLabel()
	{
		return getEntityClass().getLabel();
	}

	public void closeAll(String containsId)
	{
		Enumeration			en;
		EntityInstance		e;

		for (en = getChildren(); en.hasMoreElements(); ) {
			e = (EntityInstance) en.nextElement();
			e.setContainElision(containsId);
			e.closeAll(containsId);
	}	}

	public void openAll(String containsId)
	{
		Enumeration			en;
		EntityInstance		e;

		for (en = getChildren(); en.hasMoreElements(); ) {
			e = (EntityInstance) en.nextElement();
			e.clearContainElision(containsId);
			e.openAll(containsId);
	}	}

	public void shapeChanges(EntityClass ec)
	{
		Enumeration			en;
		EntityInstance		e;

		if (ec == getParentClass()) {
			adjustEdgePoints();
			validateAllMyEdges();
		}
		for (en = getChildren(); en.hasMoreElements(); ) {
			e = (EntityInstance) en.nextElement();
			e.shapeChanges(ec);
	}	}

	public String getStyleName(int style)
	{
		return EntityClass.getEntityStyleName(style);
	}

	public void exchangePositioning(int oldindex, int newindex, int lth)
	{
		setPositionArraySize(lth);

		Enumeration			en;
		EntityInstance		e;
		EntityPosition		position;
		EntityPosition[]	positions = m_positions;
		int					i;

		if (m_xrelLocal >= 0 || m_yrelLocal >= 0 || m_widthrelLocal >= 0 || m_heightrelLocal >= 0) {
			position = positions[oldindex];
			if (position == null) {
				positions[oldindex] = position = new EntityPosition();
			}
			position.m_xrelLocal      = m_xrelLocal;
			position.m_yrelLocal      = m_yrelLocal;
			position.m_widthrelLocal  = m_widthrelLocal;
			position.m_heightrelLocal = m_heightrelLocal;
		}

		position = positions[newindex];
		if (position == null) {
			m_xrelLocal      = -1.0;
			m_yrelLocal      = -1.0;
			m_widthrelLocal  = -1.0;
			m_heightrelLocal = -1.0;
		} else {
			m_xrelLocal      = position.m_xrelLocal;
			m_yrelLocal      = position.m_yrelLocal;
			m_widthrelLocal  = position.m_widthrelLocal;
			m_heightrelLocal = position.m_heightrelLocal;
		}

		for (en = getChildren(); en.hasMoreElements(); ) {
			e = (EntityInstance) en.nextElement();
			e.exchangePositioning(oldindex, newindex, lth);
	}	}

	public String getTitle() 
	{
		return m_title;
	}

	public boolean setTitle(String value)
	{
		if (value == null) {
			if (m_title == null) {
				return(false);
			}
		} else if (value.equals(m_title)) {
			return(false);
		}
		m_title = value;
		return(true);
	}

	class SetTitle extends MyUndoableEdit implements UndoableEdit
	{
		String				 m_old;
		String				 m_new;

		SetTitle(String old)
		{
			m_old = old;
			m_new = m_title;
			logEdit(this);
		}

		public String getPresentationName() 
		{
			return EntityInstance.this.toString() + " Title";
		}

		public void undo()
		{
			m_title = m_old;
		}

		public void redo()
		{
			m_title = m_new;
		}
	}	

	public void updateTitle(String title)
	{
		String old = m_title;

		if (setTitle(title) && undoEnabled()) {
			new SetTitle(old);
	}	}

	public void addContainment(EntityInstance e) 
	{
		if (e.inDiagram()) {
			EntityComponent entityComponent = neededComponent();
			EntityComponent childComponent  = e.neededComponent();

			nandMark(OPEN_MARK|CLOSED_MARK);

			// Add e back into new containment
			entityComponent.add(childComponent); 
		}
	}

	public void addUnder(JComponent under)
	{
		EntityComponent entityComponent = neededComponent();

//		System.out.println("EntityInstance:addUnder " + this + " " + isOpen() + " " + numChildren());
		entityComponent.removeAll();
		orMark(DIAGRAM_MARK);

		if (isOpen()) {
			Enumeration		en;
			EntityInstance	e;
			for (en = getChildren(); en.hasMoreElements(); ) {
				e = (EntityInstance) en.nextElement();
				e.addUnderEntity(this); // Add all children of open parent to diagram
		}	}
		under.add(entityComponent);		// Add this entity to diagram
		// Adding causes call to validate
	}

	public void addUnderEntity(EntityInstance under)
	{
		EntityClass	ec = getEntityClass();

		if (ec.isShown()) {
			EntityComponent parentComponent = under.neededComponent();
			addUnder(parentComponent);
	}	}

	public boolean removeContainment(EntityInstance e) 
	{
		JComponent entityComponent = getSwingObject();
			
		if (entityComponent != null) {
			JComponent childComponent = e.getSwingObject();
			if (childComponent != null) {
				entityComponent.remove(childComponent);
		}	}
		e.m_mark       &= PERMANENT_MARKS;
		return true;
	}

	public RelationInstance getRelation(RelationClass rc, EntityInstance dst) 
	{
		// Return relation instance if present

		Enumeration		en;
		RelationInstance ri;

		for (en = m_srcRelList.elements(); en.hasMoreElements(); ) {
			ri = (RelationInstance) en.nextElement();
			if (ri.getRelationClass() == rc && ri.getDst() == dst) {
				return ri;
		}	}
		return null;
	}

	public void addSrcRelation(RelationInstance ri) 
	{
		m_srcRelList.addElement(ri); 
	}

	public void addSrcRelationIfAbsent(RelationInstance ri) 
	{
		if (!m_srcRelList.contains(ri)) {
			m_srcRelList.addElement(ri); 
	}	}

	public void removeSrcRelation(RelationInstance ri) 
	{
		m_srcRelList.removeElement(ri); 
	}

	public void addDstRelation(RelationInstance ri) 
	{
		m_dstRelList.addElement(ri); 
	}

	public void addDstRelationIfAbsent(RelationInstance ri) 
	{
		if (!m_dstRelList.contains(ri)) {
			m_dstRelList.addElement(ri); 
	}	}

	public void removeDstRelation(RelationInstance ri) 
	{
		m_dstRelList.removeElement(ri);
	}

	public void addAttribute(Attribute attr) {

		// Process first order attributes, and add all others 
		// to an attribute database

		if (processFirstOrderAttributes(attr)) {
			return;
		}
		super.addAttribute(attr);
	}

	public void assignAttributes(Attribute attr) 
	{
		// Passed list of attribute assignments

		for (; attr != null; attr = attr.next) {

			// For each attribute assignment, find the variable,
			// and assign the value.

			if (attr.avi == null) {
				MsgOut.println("Null attribute assignment");
			} else if (!processFirstOrderAttributes(attr)) {
				Attribute attrVar = getLsAttribute(attr.id);

				if (attrVar == null) {
					putLsAttribute(attr);
				} else {
					if (attrVar.m_cloneOnAssign) {
						attrVar = (Attribute) attrVar.clone();
						attrVar.m_cloneOnAssign = false;
						replaceAttribute(attrVar);
					}
					attrVar.avi = attr.avi;
				}
			}
		}
	} 

	// Used when edge points move

	public void validateAllMyEdgesForClass(RelationClass rc) 
	{
		Enumeration			en;
		RelationInstance	ri;

		for (en = srcLiftedRelationElements(); en.hasMoreElements(); ) {
			ri = (RelationInstance) en.nextElement();
			if (ri.getRelationClass() != rc) {
				continue;
			}
			if (ri.m_drawSrc != this) {
				System.out.println("validateAllMyEdges() " + this + " drawsrc " + ri.m_drawSrc);
				continue;
			}
			ri.validate();
		}

		for (en = dstLiftedRelationElements(); en.hasMoreElements(); ) {
			ri = (RelationInstance) en.nextElement();
			if (ri.getRelationClass() != rc) {
				continue;
			}
			if (ri.m_drawDst != this) {
				System.out.println("validateAllMyEdges() " + this + " drawdst " + ri.m_drawDst);
				continue;
			}
			ri.validate();
	}	}

/*
		v6.0.3
		Stupid to rescale -- might as well recalculate 
 */

	public void validateAllMyEdges() 
	{
		Enumeration			en;
		RelationInstance	ri;

		for (en = srcLiftedRelationElements(); en.hasMoreElements(); ) {
			ri = (RelationInstance) en.nextElement();
			if (ri.m_drawSrc != this) {
				System.out.println("validateAllMyEdges() " + this + " drawsrc " + ri.m_drawSrc);
				continue;
			}
			ri.validate();
		}

		for (en = dstLiftedRelationElements(); en.hasMoreElements(); ) {
			ri = (RelationInstance) en.nextElement();
			if (ri.m_drawDst != this) {
				System.out.println("validateAllMyEdges() " + this + " drawdst " + ri.m_drawDst);
				continue;
			}
			ri.validate();
	}	}

	protected void rescale(EdgePoint[] pts) {

		if (pts != null) {
			for (int i = 0; i < pts.length; ++i) {
				if (pts[i] != null) {
					pts[i].clearRc();
	}	}	}	}

	protected void adjustEdgePoints(EdgePoint[] pts) 
	{
		EdgePoint	edgePoint;

		if (pts != null) {
			for (int i = 0; i < pts.length; ++i) {
				edgePoint = pts[i];
				if (edgePoint != null) {
					edgePoint.adjustEdgePoint();
					edgePoint.rescale();
	}	}	}	}

	protected void adjustEdgePoints()
	{
		adjustEdgePoints(m_topPoints);
		adjustEdgePoints(m_bottomPoints);
		adjustEdgePoints(m_leftPoints);
		adjustEdgePoints(m_rightPoints);
	}

	/* Invoked when some of the children have no assigned relwidth/relheight 
	 * These operation never update only set
	 */

	protected void assignDimensions()
	{
		EntityInstance	e;
		Enumeration		en;
		int				total, rows;
		double			relWidth, relHeight;

		// Must be > 0 

		total     = numChildren();
		rows      = (int) Math.sqrt(total);
		relWidth  = (WIDTHRELLOCAL_DEFAULT  * rows) / (2 * total);
		relHeight = (HEIGHTRELLOCAL_DEFAULT * rows) / (2 * total);


		for (en = getChildren(); en.hasMoreElements(); ) {
			e = (EntityInstance) en.nextElement();
			if (e.m_widthrelLocal < 0) {
				e.setWidthRelLocalBounded(relWidth);
			}
			if (e.m_heightrelLocal < 0) {
				e.setHeightRelLocalBounded(relHeight);
			}
//			System.out.println("EntityInstance.assignDimensions " + e + " relWidth=" + e.m_widthrelLocal + " relHeight=" + e.m_heightrelLocal);
	}	}

	// Must invoke this after lifted all edges
	// Don't do when resizing because resizing must be done before
	// lifting of edges -- otherwise can't decide what is open and
	// what is closed

	protected void assignLocations()
	{
		Enumeration			en;
		EntityInstance		e;
		Vector				v = null;

//		System.out.println("EntityInstance.assignLocations " + this);

		for (en = getChildren(); en.hasMoreElements(); ) {
			e = (EntityInstance) en.nextElement();
			if (e.m_xrelLocal < 0 || e.m_yrelLocal < 0) {
				if (v == null) {
					v = new Vector();
				}
				v.add(e);
		}	}

		if (v != null) {
			/* These vertices have no position */
			Diagram				diagram       = getDiagram();
			LandscapeEditorCore	ls            = diagram.getLs();
			int					parent_width  = getWidth();
			int					parent_height = getHeight();
			int					new_width, new_height;
			boolean				undo          = diagram.undoEnabled();


			if (undo) {
				diagram.setUndoEnabled(false);
			}
			ls.getLayouter().doLayout1(v, this);

			// Handle the fact that sizes may have changed

			for (en = v.elements(); en.hasMoreElements(); ) {
				e = (EntityInstance) en.nextElement();

				e.resize(parent_width, parent_height);
			}

/*
			{
				int i, cnt;

				cnt = v.size();
				for (i = 0; i < cnt; ++i) {
					e = (EntityInstance) v.elementAt(i);
					System.out.println("EntityInstance.assignLocations " + e + " relX=" + e.m_xrelLocal + " relY=" + e.m_yrelLocal);
			}	}
*/
			if (undo) {
				diagram.setUndoEnabled(true);
			}
			v = null;

		}
//		System.out.println("EntityInstance.assignLocations " + this + " done");
	}


	protected void getEdgePoints(double[] xpoints, double[] ypoints)
	{
		xpoints[0] = xpoints[3] = m_xrelLocal;
		ypoints[0] = ypoints[1] = m_yrelLocal;
		xpoints[1] = xpoints[2] = m_xrelLocal + m_widthrelLocal;
		ypoints[2] = ypoints[3] = m_yrelLocal + m_heightrelLocal;
	}

	protected static void getFramePoints(double[] xpoints, double[] ypoints)
	{
		xpoints[0] = xpoints[3] = 0;
		ypoints[0] = ypoints[1] = 0;
		xpoints[1] = xpoints[2] = 1.0;
		ypoints[2] = ypoints[3] = 1.0;
	}

	protected void	setInitialLocation(EntityInstance container)
	{
		EntityInstance[]	children = new EntityInstance[container.numChildren()];
		double[]			xpoints1 = new double[4];
		double[]			ypoints1 = new double[4];
		double[]			xpoints2 = new double[4];
		double[]			ypoints2 = new double[4];
		double				xpoint1, ypoint1, xpoint2, ypoint2;
		double				x, y, width, height, xend, yend, area;
		double				x1, y1, x1end, y1end;
		double				bestx, besty, bestwidth, bestheight, bestarea;

		Enumeration			en;
		EntityInstance		child;
		int					i, j, i1, j1, k, size;

		size = 0;
		for (en = container.getChildren(); en.hasMoreElements(); ) {
			child = (EntityInstance) en.nextElement();
			if (child != this && child.xRelLocal() >= 0 && child.yRelLocal() >= 0 && child.widthRelLocal() > 0 && child.heightRelLocal() > 0) {
				children[size++] = child;
		}	}

		// Find largest free area within the container

		bestx      = 0;
		besty      = 0;
		bestwidth  = 0;
		bestheight = 0;
		bestarea   = 0;

		for (i = 0; i <= size; ++i) {		// For each child and the frame

			if (i < size) {
				child      = children[i];
				child.getEdgePoints(xpoints1, ypoints1);
			} else {
				getFramePoints(xpoints1, ypoints1);
			}
			
			for (j = i; j <= size; ++j) {	// For this and subsequent children and frame
				if (j < size) {
					child      = children[j];
					child.getEdgePoints(xpoints2, ypoints2);
				} else {
					getFramePoints(xpoints2, ypoints2);
				}

				for (i1 = 0; i1 < 4; ++i1) {	// For each edge point of i
					xpoint1 = xpoints1[i1];
					ypoint1 = ypoints1[i1];
					j1 = ((i == j) ? i1+1 : 0);
					for (; j1 < 4; ++j1) {	// For each edge point of j
						xpoint2 = xpoints2[j1];
						width = xpoint2 - xpoint1;
						if (width == 0) {
							continue;
						}
						ypoint2 = ypoints2[j1];
						height = ypoint2 - ypoint1;
						if (height == 0) {
							continue;
						}

						if (width < 0) {
							x     = xpoint2;
							width = -width;
						} else {
							x     = xpoint1;
						}
						if (height < 0) {
							y      = ypoint2;
							height = -height;
						} else {
							y      = ypoint1;
						}
						xend = x + width;
						yend = y + height;

						// Ignore choice if rectangle framed by two edge points selected overlaps with any child

						for (k = size; k > 0; ) {
							child = children[--k];
							x1    = child.xRelLocal();
							if (x1 >= xend) {
								continue;
							}
							x1end = x1 + child.widthRelLocal();
							if (x1end <= x) {
								continue;
							}
							y1    = child.yRelLocal();
							if (y1 >= yend) {
								continue;
							}
							y1end = y1 + child.heightRelLocal();
							if (y1end <= y) {
								continue;
							}
							++k;
							break;
						}
						if (k != 0) {
							// Overlap so ignore
							continue;
						}

						area = width * height;
						if (area > bestarea) {
							bestx      = x;
							besty      = y;
							bestarea   = area;
							bestwidth  = width;
							bestheight = height;
						}
					}
				}
			}
		}

		if (bestarea > 0) {
			bestwidth  /= 2.0;
			bestheight /= 2.0;
			x           = bestx + (bestwidth/2.0);
			y           = besty + (bestheight/2.0);
			setRelLocal(x, y, bestwidth, bestheight);
		}
	}

	// Global coordinate transform
	//
	// Calculate global values for Rectangle from local with scale.
	// The absolute x and y offsets of the parent are passed.
	//
	// This also handles calling the rescale on the containing entities.
	//

	public void setSize(int width, int height) 
	{
		JComponent entityComponent = getSwingObject();

		if (width <= 0 || height <= 0) {
			if (m_width > 0 && m_height > 0) {
				openStatusUnknown();
			}
			width = height = 0;
		} else if (m_width <= 0 || m_height <= 0) {
			if (!isOpen()) {
				// Don't remove the open status on the draw root
				openStatusUnknown();
		}	}

		m_width  = width;
		m_height = height;

		if (entityComponent != null) {
			entityComponent.setSize(width, height);
		}
		resizeChildren();
	}

	public void resize(int parent_width, int parent_height)
	{
		int 		new_width, new_height;

		new_width  = (int) (parent_width  * widthRelLocal());
		new_height = (int) (parent_height * heightRelLocal());

		// This set bounds causes children to be rescaled
		setSize(new_width, new_height);
	}

	public void resizeChildren() 
	{
		Enumeration		en;
		int				width, height;
		EntityInstance	e;
		
		width  = getWidth();
		height = getHeight();
		
		// rescale edge points

		rescale(m_topPoints);
		rescale(m_bottomPoints);
		rescale(m_leftPoints);
		rescale(m_rightPoints);
		
		if (isOpen()) {
			for (en = getChildren(); en.hasMoreElements(); ) {
				e = (EntityInstance) en.nextElement();
				if (e.m_widthrelLocal < 0 || e.m_heightrelLocal < 0) {
					assignDimensions();
					break;
			}	}

			for (en = getChildren(); en.hasMoreElements(); ) {
				e = (EntityInstance) en.nextElement();
				e.resize(width, height);
	}	}	}

	// Called from setBothLocations
	// Called from updateDiagramBounds

	public void setLocation(int x, int y) 
	{
		JComponent entityComponent = getSwingObject();

		m_x      = x;
		m_y      = y;

		if (entityComponent != null) {
			entityComponent.setLocation(x, y);
		}
		relocateChildren();
	}

	public void setBothLocations(int parentDiagramX, int parentDiagramY, int x, int y) 
	{
		m_diagramX = parentDiagramX + x;
		m_diagramY = parentDiagramY + y;
			
		setLocation(x, y);
	}

	public void relocate(int parentDiagramX, int parentDiagramY, int parent_width, int parent_height)
	{
		int 		new_x, new_y;

		new_x      = (int) (parent_width  * xRelLocal());
		new_y      = (int) (parent_height * yRelLocal());

		// This set bounds causes children to be rescaled
		setBothLocations(parentDiagramX, parentDiagramY, new_x, new_y);
	}

	// Called from rescaleDiagram
	// Called from setLocation

	public void relocateChildren() 
	{
		Enumeration		en;
		int				width, height;
		EntityInstance	e;
		
		width  = getWidth();
		height = getHeight();

		if (isOpen()) {
			for (en = getChildren(); en.hasMoreElements(); ) {
				e = (EntityInstance) en.nextElement();
				if (e.m_xrelLocal < 0 || e.m_yrelLocal < 0) {
					assignLocations();
					break;
			}	}

			for (en = getChildren(); en.hasMoreElements(); ) {
				e = (EntityInstance) en.nextElement();
				e.relocate(m_diagramX, m_diagramY, width, height);
	}	}	}

	// This is an external entry point

	public void setBothBounds(int parentDiagramX, int parentDiagramY, int x, int y, int width, int height) 
	{
		setSize(width, height);
		setBothLocations(parentDiagramX, parentDiagramY, x, y);
	}

	public Rectangle getDiagramBounds() 
	{
		return new Rectangle(getDiagramX(), getDiagramY(), getWidth(), getHeight());
	}

	protected void scale(double wf, double hf, boolean doContainer, boolean doPos)
	{
		// Scale ourselves 

//		System.out.println("EntityInstance.scale(" + wf + "," + hf + "," + doContainer + "," + doPos + ")");

		if (doContainer) {
			double x1, y1, w1, h1; 

			x1 = xRelLocal();		
			y1 = yRelLocal();
			w1 = widthRelLocal()  * wf;
			h1 = heightRelLocal() * hf;

			if (doPos) {
				x1 *= wf;
				y1 *= hf;
			}
			updateRelLocal(x1, y1, w1, h1);
		} else {
			Enumeration en;
			for (en = getChildren(); en.hasMoreElements(); ) {
				EntityInstance e = (EntityInstance) en.nextElement();
				e.scale(wf, hf, true, true);
		}	}
	}

	public void scale(double sf, boolean doContainer, boolean doPos) 
	{
		scale(sf, sf, doContainer, doPos);
	}

	public void scale(double sf, boolean doContainer) 
	{
		scale(sf, sf, doContainer, false);
	}

	public void scale(double sf) 
	{
		scale(sf, sf, true, false);
	}

	public void scaleX(double sf, boolean doContainer, boolean doPos) 
	{
		scale(sf, 1.0, doContainer, doPos);
	}

	public void scaleX(double sf, boolean doContainer) 
	{
		scale(sf, 1.0, doContainer, false);
	}

	public void scaleX(double sf) 
	{
		scale(sf, 1.0, true, false);
	}

	public void scaleY(double sf, boolean doContainer, boolean doPos) 
	{
		scale(1.0, sf, doContainer, doPos);
	}

	public void scaleY(double sf, boolean doContainer) 
	{
		scale(1.0, sf, doContainer, false); 
	}

	public void scaleY(double sf) 
	{
		scale(1.0, sf, true, false);
	}

	// Attempt to fit children to us  

	private void doFitScale(double dx, double dy, double wf, double hf) 
	{
		updateRelLocal(xRelLocal() * wf + dx, yRelLocal() * hf - dy, dx + widthRelLocal() * wf, dy + heightRelLocal() * hf);	
	}

	public Dimension getLabelDim(Graphics g, int type, boolean wParent) 
	{
		String	str = getEntityLabel();

		setFont(g, type);
		if (wParent) {
			EntityInstance pe = getContainedBy();

			if (pe != null) {
				str = pe.getEntityLabel() + " |\n" + str;
		}	} 
		return(Util.stringWrappedDim(g, str));
	}

	public Dimension getLabelDim(Graphics g, int type) 
	{
		return getLabelDim(g, type, false);
	}

	public int getMinFitWidth(Graphics graphics)
	{
		Dimension	ld       = getLabelDim(graphics, EntityInstance.REG_FONT);
		int			minWidth = ld.width + EntityComponent.MARGIN*2;

		if (hasChildren()) {
			minWidth += EntityComponent.CONTENTS_FLAG_X_RESERVE;
		}
		return minWidth;
	}

	public boolean hasChildren() 
	{
		Ta					ta            = getTa();
		RelationClass		containsClass = ta.getContainsClass();
		Vector				srcRelList    = m_srcRelList;
		int					size          = srcRelList.size();
		RelationInstance	ri;

		for (int i = 0; i < size; ++i) {
			ri = (RelationInstance) srcRelList.elementAt(i);
			if (ri.getRelationClass() == containsClass) {
				return true;
		}	}
		return false;
	}
			
	public int numChildren() 
	{
		Ta					ta            = getTa();
		RelationClass		containsClass = ta.getContainsClass();
		Vector				srcRelList    = m_srcRelList;
		int					size          = srcRelList.size();
		RelationInstance	ri;
		int					ret = 0;

		for (int i = 0; i < size; ++i) {
			ri = (RelationInstance) srcRelList.elementAt(i);
			if (ri.getRelationClass() == containsClass) {
				++ret;
		}	}
		return ret;	
	}

	public EntityInstance getFirstChild() 
	{
		Ta					ta            = getTa();
		RelationClass		containsClass = ta.getContainsClass();
		Vector				srcRelList    = m_srcRelList;
		int					size          = srcRelList.size();
		RelationInstance	ri;

		for (int i = 0; i < size; ++i) {
			ri = (RelationInstance) srcRelList.elementAt(i);
			if (ri.getRelationClass() == containsClass) {
				return ri.getDst();
		}	}
		return null;	
	}

	public Enumeration getBelow(RelationClass rc)
	{
		return new EntityBelow(m_srcRelList, rc);
	}

	public Enumeration getChildren() 
	{
		return new EntityChildren(m_srcRelList);
	}

	public Enumeration getParents()
	{
		return new EntityParents(m_dstRelList);
	}

	public Dimension getFitDim(Graphics g, int type, boolean wParent) 
	{
		Dimension dim = getLabelDim(g, type, wParent);

		if (hasChildren() && !isOpen()) {
			dim.width += CONTENTS_FLAG_DIM;
		}
		dim.width  += MARGIN*3;
		dim.height += (MARGIN*3)/2;

		return dim;
	}

	public Dimension getFitDim(Graphics g, int type) 
	{
		return getFitDim(g, type, false);
	}

	// Edges

	public void invalidateAllEdges() 
	{ 
		Enumeration		 en;
		RelationInstance ri;

//		System.out.println("EntityInstance.drawAllEdges " + this);
		
		for (en = srcLiftedRelationElements(); en.hasMoreElements(); ) {
			ri = (RelationInstance) en.nextElement();
			ri.invalidateEdge();
		}	

		for (en = dstLiftedRelationElements(); en.hasMoreElements(); ) {
			ri = (RelationInstance) en.nextElement();
			ri.invalidateEdge();
	}	}	

	public void drawAllEdges(EntityInstance under) 
	{ 
		Enumeration		 en;
		EntityInstance	 src;
		RelationInstance ri;

//		System.out.println("EntityInstance.drawAllEdges " + this);
		
		for (en = srcLiftedRelationElements(); en.hasMoreElements(); ) {
			ri = (RelationInstance) en.nextElement();
			ri.draw(true);	// allow elision from source
		}	

		for (en = dstLiftedRelationElements(); en.hasMoreElements(); ) {
			ri  = (RelationInstance) en.nextElement();
			src = ri.m_drawSrc;
			if (!under.hasDescendant(src)) {
				ri.draw(true);	// allow elision to destination
		}	}	

//		System.out.println("EntityInstance.drawAllEdges " + this + " done");
	}

	public void drawHighlightedEdges() 
	{ 
		Enumeration		 en;
		RelationInstance ri;

		for (en = srcLiftedRelationElements(); en.hasMoreElements(); ) {
			ri = (RelationInstance) en.nextElement();
			ri.drawHighlighted();  
		}	

		for (en = dstLiftedRelationElements(); en.hasMoreElements(); ) {
			ri = (RelationInstance) en.nextElement();
			ri.drawHighlighted(); 
		}	
	}

	// TA raw info routines

	public void getInstancesRaw(Vector v, Hashtable st) 
	{
		Enumeration en;
		EntityInstance child;

		// Not $ROOT 
		Integer[] pair = new Integer[2];
		pair[0] = (Integer) st.get(getId());
		pair[1] = (Integer) st.get(getParentClass().getId());
		v.addElement(pair);
		for (en = getChildren(); en.hasMoreElements(); ) {
			child = (EntityInstance) en.nextElement();
			child.getInstancesRaw(v, st);
		}
	}

	// TA file output routines 

	public void writeInstance(PrintStream ps) throws IOException 
	{
		// Write an instance line for ourself

		ps.print(Ta.INSTANCE_ID + " " + qt(getId()) + " " + qt(getParentClass().getId()) + "\n");
	}

	public void writeInstances(PrintStream ps) throws IOException 
	{
		Enumeration en;

		// Write an instance line for ourself, and then all our children

		writeInstance(ps);
		for (en = getChildren(); en.hasMoreElements(); ) {
			EntityInstance child = (EntityInstance) en.nextElement();
			child.writeInstances(ps);
		}
	}

	public void writeRelations(PrintStream ps) throws IOException {

		// Write out the relations on us, and then all our children
		// By writing out relations to us, we also include edges from m_rootInstance

		Enumeration		 en; 
		RelationInstance ri;

		for (en = m_srcRelList.elements(); en.hasMoreElements(); ) {
			ri = (RelationInstance) en.nextElement();
			ri.writeRelation(ps); 
		}				

		for (en = getChildren(); en.hasMoreElements(); ) {
			EntityInstance child = (EntityInstance) en.nextElement();
			child.writeRelations(ps);
		}
	}

	protected void writeElision(PrintStream ps, Vector ev, String id) 
	{
		if (ev != null && ev.size() > 0) {
			ps.print(Attribute.indent + id + " = (");
			for (Enumeration en = ev.elements(); en.hasMoreElements(); ) {
				String rcId = (String) en.nextElement(); 
				ps.print(rcId);
				if (en.hasMoreElements()) {
					ps.print(" ");
			}	}
			ps.print(")\n"); 
		}
	}

	protected void writePoints(PrintStream ps, EdgePoint[] pts, String name) 
	{
		if (pts != null) {
	
			int	i;

			for (i = 1; i < pts.length; ++i) {
				if (pts[i] != null && !pts[i].isDefault()) {
					break;
			}	}

			if (i == pts.length) {
				return;
			}

			ps.print("	" + name + " = ( ");

			for (i = 1; i < pts.length; ++i) {
				if (pts[i] != null) {
					pts[i].writePoint(ps);
				}
			}
			ps.print(")\n");
	}	}

	protected void regRawElision(Vector v, Hashtable st, Vector ev, String id) 
	{
		if (ev != null && ev.size() > 0) {
			int len = ev.size();
			String[] sl = new String[len];

			for (int i=0; i<len; ++i) {
				sl[i] = (String) ev.elementAt(i);
			}
			regRawAttribute(v, st, id, sl);
		}
	}

	public void	writeOptionsAttributes(PrintStream ps) throws IOException
	{  
		LandscapeClassObject parentClass = getParentClass();
		Enumeration			 en;

		// Write out attribute record for us, and then our children

		ps.print(qt(getId()) + " {\n");

		String label = getLabel();

		if (label == null) {
			label = getEntityLabel();
		}

		if (label != null) {
			ps.print(Attribute.indent + LABEL_ID + " = " + qt(label) + "\n");
		}

		String description = getDescription();

		if (description != null) {
			ps.print(Attribute.indent + DESC_ID + " = " + AttributeValueItem.qt(description) + "\n");
		}

		// Finally output the second-class attributes 

		super.writeAttributes(ps, parentClass, false); 

		// End the record 

		ps.print("}\n"); 
	}

	public void	writeAttribute(PrintStream ps, int cIndex) throws IOException
	{  
		LandscapeClassObject parentClass = getParentClass();
		double				 value;
		EntityPosition		 position;
		int					 i, last;

		// Write out attribute record for us

		ps.print(qt(getId()) + " {\n");

		// Write out Rectangle attributes

		if (m_positions == null) {
			last = -1;
		} else {
			for (last = m_positions.length; --last >= 0;) {
				if (last == cIndex) {
					if (m_xrelLocal >= 0 || m_yrelLocal >=0 || m_widthrelLocal >= 0 || m_heightrelLocal >= 0) {
						break;
					} 
				} else {
					position = m_positions[last];
					if (position != null) {
						if (position.m_xrelLocal >= 0 || position.m_yrelLocal >= 0 || position.m_widthrelLocal >=0 || position.m_heightrelLocal >= 0) {
							break;
		}	}	}	}	}

		if (last < 0) {
			value = m_xrelLocal;		// Use the actual values
			if (value >= 0 && value <= 1.0) {
				ps.print(Attribute.indent + "xrel      = " + value + "\n");
			}
			value = m_yrelLocal;		// Use the actual values
			if (value >= 0 && value <= 1.0) {
				ps.print(Attribute.indent + "yrel      = " + value + "\n");
			}
			value = m_widthrelLocal;
			if (value >= 0 && value <= 1.0) {
				ps.print(Attribute.indent + "widthrel  = " + value + "\n"); 
			}
			value = m_heightrelLocal;
			if (value >= 0 && value <= 1.0) {
				ps.print(Attribute.indent + "heightrel = " + value + "\n");
			}

		} else {
			ps.print(Attribute.indent + "xrel      = (");
			for (i = 0; i <= last; ++i) {
				if (i != 0) {
					ps.print(" ");
				}
				if (i == cIndex) {
					value = m_xrelLocal;
				} else {
					position = m_positions[i];
					if (position == null) {
						value = -1.0;
					} else {
						value = position.m_xrelLocal;
				}	}
				ps.print(value);
			}
			ps.print(")\n");
		
			ps.print(Attribute.indent + "yrel      = (");
			for (i = 0; i <= last; ++i) {
				if (i != 0) {
					ps.print(" ");
				}
				if (i == cIndex) {
					value = m_yrelLocal;
				} else {
					position = m_positions[i];
					if (position == null) {
						value = -1.0;
					} else {
						value = position.m_yrelLocal;
				}	}
				ps.print(value);
			}
			ps.print(")\n");

			ps.print(Attribute.indent + "widthrel  = ("); 
			for (i = 0; i <= last; ++i) {
				if (i != 0) {
					ps.print(" ");
				}
				if (i == cIndex) {
					value = m_widthrelLocal;
				} else {
					position = m_positions[i];
					if (position == null) {
						value = -1.0;
					} else {
						value = position.m_widthrelLocal;
				}	}
				ps.print(value);
			}
			ps.print(")\n");

			ps.print(Attribute.indent + "heightrel = (");
			for (i = 0; i <= last; ++i) {
				if (i != 0) {
					ps.print(" ");
				}
				if (i == cIndex) {
					value = m_heightrelLocal;
				} else {
					position = m_positions[i];
					if (position == null) {
						value = -1.0;
					} else {
						value = position.m_heightrelLocal;
				}	}
				ps.print(value);
			}
			ps.print(")\n");
		}

		String label = getLabel();

		if (label != null) {
			ps.print(Attribute.indent + LABEL_ID + " = " + qt(label) + "\n");
		}

		int style = getStyle();

		if (style >= 0) {
			if (parentClass == null || parentClass.getInheritedStyle() != style) {
				ps.print(Attribute.indent + STYLE_ID + " = " + style + "\n");
		}	}

		String description = getDescription();

		if (description != null) {
			if (isRoot() || !parentClass.defaultValue(DESC_ID, description)) {
				ps.print(Attribute.indent + DESC_ID + " = " + AttributeValueItem.qt(description) + "\n");
		}	}

		// First order attributes not associated with $ROOT 
		writeElision(ps, m_dstElision,      IN_ELISION_ID);
		writeElision(ps, m_srcElision,      OUT_ELISION_ID);
		writeElision(ps, m_enteringElision, CLIENT_ELISION_ID);
		writeElision(ps, m_exitingElision,  SUPPLIER_ELISION_ID);
		writeElision(ps, m_internalElision, INTERNAL_ELISION_ID);

		writePoints(ps, m_topPoints,    INPOINT_ID);
		writePoints(ps, m_bottomPoints, OUTPOINT_ID);
		writePoints(ps, m_leftPoints,   LEFTPOINT_ID);
		writePoints(ps, m_rightPoints,  RIGHTPOINT_ID);

		if (m_fontDelta != 0) {
			ps.print(Attribute.indent + FONTDELTA_ID + " = ");
			ps.print(m_fontDelta + "\n");
		}

		// Finally output the second-class attributes 

		super.writeAttributes(ps, parentClass, false); 

		// End the record 

		ps.print("}\n"); 
	}

	public void	writeAttributes(PrintStream ps, int cIndex) throws IOException
	{  
		Enumeration			en;
		RelationInstance	ri;
		EntityInstance		child;

		// Write out attribute record for us, and then our children
		
		writeAttribute(ps, cIndex);

		// Write any attributes of src relations

		for (en = m_srcRelList.elements(); en.hasMoreElements(); ) {
			ri = (RelationInstance) en.nextElement();
			ri.writeAttributes(ps);
		}

		// Recurse for contained children

		for (en = getChildren(); en.hasMoreElements(); ) {
			child = (EntityInstance) en.nextElement();
			child.writeAttributes(ps, cIndex);
		}
	}

	public void setOpen() 
	{
		if (!isMarked(OPEN_MARK)) {
			nandMark(CLOSED_MARK);
			orMark(OPEN_MARK);
	}	}

	public void setClosed()
	{
		if (!isMarked(CLOSED_MARK)) {
			nandMark(OPEN_MARK);
			orMark(CLOSED_MARK);
	}	}

	public void openStatusUnknown()
	{
		nandMark(OPEN_MARK|CLOSED_MARK);
	}

	public boolean isOpen() 
	{
		// If haven't yet decided if open or closed
		// We will treat zero sized objects as being closed so that we don't have to repaint edges to zero
		// sized objects which is very expensive if have huge tree and everything open

		if (!isMarked(OPEN_MARK|CLOSED_MARK)) {
			if (!hasChildren() || getWidth() <= 0 || getHeight() <= 0) {
				setClosed();
			} else {
				Ta ta              = getTa();
				String	containsId = ta.getContainsId();
			
				if (!isDstRelationElided(containsId)) {
					setOpen();
				} else {
					setClosed();
		}	}	}

		return(isMarked(OPEN_MARK));
	}

	public boolean red_closed()
	{
		return(isMarked(REDBOX_MARK) && !isOpen());
	}

	public boolean red_open()
	{
		return(isMarked(REDBOX_MARK) && isOpen());
	}

	public boolean close_with_children_under_drawroot()
	{
		return(!isOpen() && hasChildren() && !isMarked(EntityInstance.CLIENT_SUPPLIER));
	}

	public void removeAllEdges()
	{
		RelationInstance ri;
		int				 i;

		for (i = m_srcRelList.size(); i > 0;) {
			ri = (RelationInstance) m_srcRelList.elementAt(--i);
			ri.removeEdge();
		}
		for (i = m_dstRelList.size(); i > 0;) {
			ri = (RelationInstance) m_dstRelList.elementAt(--i);
			ri.removeEdge();
	}	}

	public RelationInstance getContainedByRelation(RelationClass containsClass) 
	{ 
		Enumeration			en;
		RelationInstance	ri;

		for (en = m_dstRelList.elements(); en.hasMoreElements(); ) {
			ri    = (RelationInstance) en.nextElement();
			if (ri.getRelationClass() == containsClass) {
				return ri;
		}	}
		return null;
	}	

	public EntityInstance getContainedBy(RelationClass containsClass) 
	{ 
		Enumeration			en;
		RelationInstance	ri;

		ri = getContainedByRelation(containsClass);
		if (ri != null) {
			return ri.getSrc();
		}
		return null;
	}	

	public EntityInstance getContainedBy() 
	{ 
		Ta					ta            = getTa();
		RelationClass		containsClass = ta.getContainsClass();

		return getContainedBy(containsClass);
	}	

	public void setContainedBy(EntityInstance container) 
	{ 
		Ta					ta            = getTa();
		RelationClass		containsClass = ta.getContainsClass();
		RelationInstance	ri            = getContainedByRelation(containsClass);

		if (ri != null) {
			if (ri.getSrc() == container) {
				return;
			}
			ri.removeEdge();
		}

		if (container != null) {
			ta.addEdge(container, this, containsClass);
	}	}	

	public EntityClass getEntityClass() 
	{
		return (EntityClass) getParentClass();
	}

	public boolean isRoot() 
	{
		return (getContainedBy() == null);
	}

	public int cntNodesInSubtree(RelationClass containsClass)
	{
		int				ret, ret1;
		Enumeration		en;
		EntityInstance	e;

		if (isMarked(IN_TREE_MARK)) {
			Ta	ta = getTa();
			ta.hasMultipleParents(containsClass, this);
			return -1;
		}
		ret = 1;
		orMark(IN_TREE_MARK);

		for (en = getBelow(containsClass); en.hasMoreElements(); ) {
			e = (EntityInstance) en.nextElement();
			ret1 = e.cntNodesInSubtree(containsClass);
			if (ret1 < 0) {
				return ret1;
			}
			ret += ret1;
		}
		return ret;
	}

	public void clearTreeMark()
	{
		Enumeration		en;
		EntityInstance	e;

		nandMark(IN_TREE_MARK);
		for (en = getChildren(); en.hasMoreElements(); ) {
			e = (EntityInstance) en.nextElement();
			e.clearTreeMark();
	}	}

	public void clearValidatedMark()
	{
		RelationInstance ri;
		Enumeration		en;
		EntityInstance	e;

		for (en = m_srcRelList.elements(); en.hasMoreElements(); ) {
			ri  = (RelationInstance) en.nextElement();
			ri.nandMark(RelationInstance.VALIDATED_MARK);
		}
		for (en = m_dstRelList.elements(); en.hasMoreElements(); ) {
			ri  = (RelationInstance) en.nextElement();
			ri.nandMark(RelationInstance.VALIDATED_MARK);
		}

		for (en = getChildren(); en.hasMoreElements(); ) {
			e = (EntityInstance) en.nextElement();
			e.clearValidatedMark();
	}	}

	public String toString() 
	{
		return getEntityLabel();
	}

	// Rectangle is global, adjust it to coords local to parent

	public void updateDiagramBounds(int diagramX, int diagramY, int width, int height) 
	{
		EntityInstance	parent;
		double			width1, height1;
		double			xRel, yRel, widthRel, heightRel;

		m_diagramX = diagramX;
		m_diagramY = diagramY;

		// Not sure what to do if parent not in diagram or null
		parent     = getContainedBy();
		width1     = parent.getWidth();
		height1    = parent.getHeight();
		if (width1 <= 0.0) {
			xRel     = 0;
			widthRel = 0;
		} else {
			xRel     = (diagramX - parent.m_diagramX)/width1;
			widthRel = width/width1;
		}

		if (height1 <= 0.0) {
			yRel      = 0;
			heightRel = 0;
		} else {
			yRel      = (diagramY - parent.m_diagramY)/height1;
			heightRel = height/height1;
		}
		updateRelLocal(xRel, yRel, widthRel, heightRel);
		
//		System.out.println("EntityInstance.updateDiagramBounds " + label + " xrel=" + m_xrelLocal + " yrel=" + m_yrelLocal + " widthrel=" + m_widthrelLocal + " heightrel=" + m_heightrelLocal );
		setSize(width, height);
		setLocation((int) (diagramX-getParentDiagramX()), (int) (diagramY-getParentDiagramY()));

		validateAllMyEdges();
		moveCardinals();
	} 

	public void updateDiagramBounds(Rectangle lyt) 
	{
		updateDiagramBounds(lyt.x, lyt.y, lyt.width, lyt.height);
	} 

	public Rectangle getChildBoundingBox() 
	{
		Enumeration en;
		EntityInstance e;

		// Calc the global bounding box of children

		if (!hasChildren()) {
			return null;
		}

		int x1 = Integer.MAX_VALUE;
		int x2 = Integer.MIN_VALUE;
		int y1 = Integer.MAX_VALUE;
		int y2 = Integer.MIN_VALUE;

		for (en = getChildren(); en.hasMoreElements(); ) {
			e = (EntityInstance) en.nextElement();
			if (e.getX() < x1) {
				x1 = e.getX();
			}
			if (e.getY() < y1) {
				y1 = e.getY();
			}
			if (e.getX() + e.getWidth() > x2) {
				x2 = e.getX() + e.getWidth();
			}
			if (e.getY() + e.getHeight() > y2) {
				y2 = e.getY() + e.getHeight();
		}	}
		return new Rectangle(x1, y1, x2-x1, y2-y1);
	}

	public Color getBackgroundWhenOpen() 
	{
		Color c;

		// (255 255 255) is white
		// Container is handled specially
		// Find color from depth

		c = getInheritedColorWhenOpen();
		if (c == null) {
			int            v    = Diagram.BG;
			EntityInstance b    = this;
			EntityInstance root = getDrawRoot();


			if (!root.hasDescendant(this)) {
				root = root.commonAncestor(this);
			}

			for (; b != root; b = b.getContainedBy()) {
				v -= 13;		// Darken
				if (v <= 0) {
					return Color.lightGray;
			}	}

			c = ColorCache.get(v, v, v);
		}
		return c;
	}
			

	public Color getCurrentObjectColor() 
	{
		Color c;

		if (isOpen()) {
			c = getBackgroundWhenOpen();
		} else {
			c = getInheritedObjectColor();
		}
		return c;
	}

	public boolean isRelationElided(Vector v, String id) 
	{
		return (v != null && v.contains(id));
	}

	protected boolean toggleElision(Vector v, String id) 
	{
		if (isRelationElided(v, id)) {
			if (!v.removeElement(id)) {
				MsgOut.println("remove() failed");
			}
			return false; 
		} 

		v.addElement(id); 
		return true; 
	}

	public boolean toggleDstElision(String id) 
	{
		MsgOut.dprintln("toggle target " + id);
		return toggleElision(neededDstElision(), id);
	}

	public void toggleContainElision(String containsId) 
	{
		toggleDstElision(containsId);
		openStatusUnknown();
	}

	public boolean setContainElision(String containsId) 
	{
		if (!isDstRelationElided(containsId)) {
			toggleContainElision(containsId);
			openStatusUnknown();
			return true;
		}
		return false;
	}

	public void clearContainElision(String containsId) 
	{
		if (m_dstElision != null) {
			m_dstElision.removeElement(containsId);
	}	}

	public boolean toggleDstElision(RelationClass rc) 
	{
		return toggleDstElision(rc.getId());
	}

	public boolean toggleSrcElision(String id) 
	{
		MsgOut.dprintln("toggle out " + id);
		return toggleElision(neededSrcElision(), id);
	}

	public boolean toggleSrcElision(RelationClass rc)
	{
		return toggleSrcElision(rc.getId());
	}

	public boolean toggleEnteringElision(String id) 
	{
		MsgOut.dprintln("toggle client " + id);
		return toggleElision(neededEnteringElision(), id);
	}

	public boolean toggleEnteringElision(RelationClass rc) 
	{
		return toggleEnteringElision(rc.getId());
	}

	public boolean toggleExitingElision(String id) 
	{
		MsgOut.dprintln("toggle exiting " + id);
		return toggleElision(neededExitingElision(), id);
	}

	public boolean toggleExitingElision(RelationClass rc) 
	{
		return toggleExitingElision(rc.getId());
	}

	public boolean toggleInternalElision(String id) 
	{
		MsgOut.dprintln("toggle internal " + id);
		return toggleElision(neededInternalElision(), id);
	}

	public boolean toggleInternalElision(RelationClass rc) 
	{
		return toggleInternalElision(rc.getId());
	}

	// Queries 

	public boolean isDstRelationElided(RelationClass rc) 
	{
		return isRelationElided( m_dstElision, rc.getId() );
	}

	public boolean isDstRelationElided(String id) 
	{
		return isRelationElided(m_dstElision, id);
	}

	public boolean isSrcRelationElided(RelationClass rc) 
	{
		return isRelationElided(m_srcElision, rc.getId());
	}

	public boolean isSrcRelationElided(String id) 
	{
		return isRelationElided(m_srcElision, id);
	}

	public boolean isEnteringRelationElided(RelationClass rc) 
	{
		return isRelationElided(m_enteringElision, rc.getId());
	}

	public boolean isEnteringRelationElided(String id) 
	{
		return isRelationElided(m_enteringElision, id);
	}

	public boolean isExitingRelationElided(RelationClass rc) 
	{
		return isRelationElided(m_exitingElision, rc.getId());
	}

	public boolean isExitingRelationElided(String id) 
	{
		return isRelationElided(m_exitingElision, id);
	}

	public boolean isInternalRelationElided(RelationClass rc) 
	{
		return isRelationElided(m_internalElision, rc.getId());
	}

	public boolean isInternalRelationElided(String id) 
	{
		return isRelationElided(m_internalElision, id);
	}

	public int getPostorder()
	{
		return (m_postorder);
	}

	public boolean hasAncestor(EntityInstance e) 
	{
		return(e.m_preorder < m_preorder && m_postorder <= e.m_postorder);
	}


	// Returns true if e is a descendant of me

	public boolean hasDescendant(EntityInstance e) 
	{
		return(m_preorder < e.m_preorder && e.m_postorder <= m_postorder);
	}

	public boolean hasDescendantOrSelf(EntityInstance e) 
	{
		return(m_preorder <= e.m_preorder && e.m_postorder <= m_postorder);
	}

	public boolean hasDescendantsOrSelf(Vector v)
	{
		int				cnt = v.size();
		int				i;
		EntityInstance	e;

		for (i = 0; i < cnt; ++i) {
			e = (EntityInstance) v.elementAt(i);
			if (!hasDescendantOrSelf(e)) {
				return false;
		}	}
		return true;
	}

	public boolean allDescendants(Vector v)
	{
		int				i;
		EntityInstance	e;

		for (i = v.size(); --i >= 0; ) {
			e = (EntityInstance) v.elementAt(i);
			if (!e.hasAncestor(this)) {
				return false;
		}	}
		return true;
	}

	/* Use when can't be certain that e is necessarily in the diagram 
	 * For example e was cut a long time ago and perhaps it has now been put back but then again perhaps it has not
	 */

	public boolean reallyHasDescendantOrSelf(EntityInstance e)
	{
		Enumeration en;
		EntityInstance e1;

		if (e == this) {
			return true;
		}
		for (en = getChildren(); en.hasMoreElements(); ) {
			e1 = (EntityInstance) en.nextElement();
			if (e1.hasDescendantOrSelf(e)) {
				return e1.reallyHasDescendantOrSelf(e);
		}	}
		return false;
	}

	public boolean isPathBetween(EntityInstance e)
	{
		return((m_preorder <= e.m_preorder && e.m_postorder <= m_postorder) || (e.m_preorder <= m_preorder && m_postorder <= e.m_postorder));
	}

	// Return the common ancestor entity

	public EntityInstance commonAncestor(EntityInstance e) 
	{
		EntityInstance e1;

		for (e1 = getContainedBy(); e1 != null; e1 = e1.getContainedBy()) {
			if (e1.hasDescendant(e)) {
				break;
		}	}
		return(e1);
	}

	// Finds that entity being displayed either as a client or a server
	// to which arrows to my entity should be addressed

	public EntityInstance clientServer() 
	{
		EntityInstance e1;

		for (e1 = this; e1 != null; e1 = e1.getContainedBy()) {
			if (e1.isMarked(CLIENT_MARK | SUPPLIER_MARK)) {
				break;
		}	}
		return(e1);
	}

	public boolean inDiagram()
	{
		return(isMarked(IN_DIAGRAM));
	}

	public EntityInstance getVisibleEntity() 
	{
		EntityInstance e;

		for (e = this; e != null; e = e.getContainedBy()) {
			if (inDiagram()) {
				break;
		}	}
		return e;
	}

	// Return reference to entity the cursor is over. 
	// Return null if none.

	public EntityInstance getMouseOver(int x, int y) 
	{
		JComponent entityComponent = getSwingObject();

		if (entityComponent != null && entityComponent.contains(x,y)) {
			if (isOpen()) {
				Enumeration en;
				EntityInstance e, over;

				for (en = getChildren(); en.hasMoreElements(); ) {
					e = (EntityInstance) en.nextElement();
					over = e.getMouseOver(x, y);
					if (over != null)
						return over; 
			}	}
			// It's not over any of our children, so it's over us.
			return this; 
		}
		return null;
	}

	public EntityInstance containing(Rectangle lyt) 
	{
		if (containsRectangle(lyt)) {
			if (hasChildren() && isOpen()) {
				// Check children
				Enumeration en;

				for (en = getChildren(); en.hasMoreElements(); ) {
					EntityInstance e = (EntityInstance) en.nextElement();
					EntityInstance oe = e.containing(lyt);
					if (oe != null) {
						return oe;
				}	}
			}
			return this;
		}
		return null;
	}

	public Vector getSrcRelList()
	{
		return m_srcRelList;
	}

	public Vector getDstRelList()
	{
		return m_dstRelList;
	}

	public Enumeration srcRelationElements() 
	{
		return m_srcRelList.elements(); 
	}

	public Enumeration dstRelationElements() 
	{
		return m_dstRelList.elements(); 
	}

	public Enumeration srcLiftedRelationElements() 
	{
		return m_srcLiftedList.elements(); 
	}

	public Enumeration dstLiftedRelationElements() 
	{
		return m_dstLiftedList.elements(); 
	}

	protected void addSrcRels(Vector v) 
	{
		Enumeration en;
		EntityInstance e;

		for (en = m_srcRelList.elements(); en.hasMoreElements(); ) {
			v.addElement(en.nextElement());
		}

		for (en = getChildren(); en.hasMoreElements(); ) {
			e = (EntityInstance) en.nextElement();
			e.addSrcRels(v);
		}
	}

	public Enumeration srcRelationAbstractedElements()
	{
		// Return enumeration for all edges which
		// have this entity as the source (real and abstracted).

		Vector v = new Vector();
		addSrcRels(v);
		return v.elements();
	}

	protected void addDstRels(Vector v) 
	{
		Enumeration en;
		EntityInstance e;

		for (en = m_dstRelList.elements(); en.hasMoreElements(); ) {
			v.addElement(en.nextElement());
		}

		for (en = getChildren(); en.hasMoreElements(); ) {
			e = (EntityInstance) en.nextElement();
			e.addDstRels(v);
		}
	}

	public Enumeration dstRelationAbstractedElements() 
	{
		// Return enumeration for all edges which
		// have this entity as the destination (real and abstracted).

		Vector v = new Vector();
		addDstRels(v);
		return v.elements();
	}

	public Vector groupRegion(Rectangle lyt) 
	{
		// This entity isn't in the group, but any children which
		// intersect the passed region are.

		if (!hasChildren()) {
			return null;
		}
		Vector grp = new Vector();
		Enumeration en;
		EntityInstance e;
		
		for (en = getChildren(); en.hasMoreElements(); ) {
			e = (EntityInstance) en.nextElement(); 
			if (e.intersectsLayout(lyt)) {
				e.setGroupFlag(); 
				grp.addElement(e);
			}
		}

		if (grp.isEmpty()) {
			return null;
		}
		return grp;
	}

	public void getGroup(Vector grp) 
	{
		Enumeration en;
		EntityInstance e;
		
		if (getGroupFlag()) {
			grp.addElement(this);
		}

		for (en = getChildren(); en.hasMoreElements();) {
			e = (EntityInstance) en.nextElement(); 
			e.getGroup(grp);
	}	}

	protected void setGroupFlag() 
	{
		if (!isMarked(GROUP_MARK)) {
			EntityClass	ec = getEntityClass();
			if (ec.isShown()) {
				orMark(GROUP_MARK);
				repaint(); 
	}	}	}

	protected void clearGroupFlag() 
	{
		if (isMarked(GROUP_MARK|GROUPKEY_MARK)) {
			nandMark(GROUP_MARK|GROUPKEY_MARK);
			repaint();
	}	}		

	public boolean getGroupFlag() 
	{
		return isMarked(GROUP_MARK);
	}

	protected void setGroupKeyFlag() 
	{
		if (!isMarked(GROUPKEY_MARK)) {
			orMark(GROUPKEY_MARK);
			repaint();
	}	}

	protected void clearGroupKeyFlag() 
	{
		if (isMarked(GROUPKEY_MARK)) {
			nandMark(GROUPKEY_MARK);
			repaint();
	}	}

	public boolean getGroupKeyFlag() 
	{
		return isMarked(GROUPKEY_MARK);
	}

	public void getRedBoxGroup(Vector grp) 
	{
		Enumeration		en;
		EntityInstance	e;

		if (isMarked(REDBOX_MARK)) {
			grp.addElement(this);
		}

		for (en = getChildren(); en.hasMoreElements(); ) {
			e = (EntityInstance) en.nextElement(); 
			e.getRedBoxGroup(grp);
	}	}

	public void setRedBoxFlag() 
	{
		if (!isMarked(REDBOX_MARK)) {
			orMark(REDBOX_MARK);
			repaint();
	}	}

	public void clearRedBoxFlag() 
	{
		if (isMarked(REDBOX_MARK)) {
			nandMark(REDBOX_MARK);
			repaint();
	}	}

	public void clearAllFlags() 
	{
		Enumeration en;
		RelationInstance ri;
		EntityInstance e;

		clearGroupFlag();
		clearGroupKeyFlag();
		clearRedBoxFlag();
		openStatusUnknown();

		for (en = m_srcRelList.elements(); en.hasMoreElements();) {
			ri = (RelationInstance) en.nextElement();
			ri.clearHighlightFlag();
			ri.clearGroupFlag();
		}
		for (en = getChildren(); en.hasMoreElements(); ) {
			e = (EntityInstance) en.nextElement(); 
			e.clearAllFlags();
		}
	}

	// Remove redbox and highlight flags at and under me

	public void clearQueryFlags() 
	{
		Enumeration en;
		RelationInstance ri;
		EntityInstance e;

		clearRedBoxFlag();

		for (en = m_srcRelList.elements(); en.hasMoreElements(); ) {
			ri = (RelationInstance) en.nextElement();
			ri.clearHighlightFlag();
		}

		for (en = getChildren(); en.hasMoreElements(); ) {
			e    = (EntityInstance) en.nextElement(); 
			e.clearQueryFlags();
	}	}

	public void clearGroupFlags() 
	{
		Enumeration en;
		EntityInstance e;

		clearGroupFlag();
		clearGroupKeyFlag();

		for (en = getChildren(); en.hasMoreElements(); ) {
			e = (EntityInstance) en.nextElement(); 
			e.clearGroupFlags();
		}
	}

	public boolean isClippedLabel() 
	{
		if (getWidth() < MIN_WIDTH || getHeight() < MIN_HEIGHT) {
			return(true);
		}
		return(false);
	}

	// Internal attributes of different entities

	public boolean isClickable() 
	{
		return true;
	}

	public void orMark(int val) 
	{
/*
		if ((m_mark & REDBOX_MARK) == 0) {
			if ((val & REDBOX_MARK) != 0) {
				System.out.println("EntityInstance.orMark(REDBOX_MARK) " + this);
		}	}
*/
		m_mark |= val;
	}

	public void andMark(int val)
	{
/*
		if ((m_mark & REDBOX_MARK) != 0) {
			if ((val & REDBOX_MARK) == 0) {
				System.out.println("EntityInstance.andMark(~REDBOX_MARK) " + this);
		}	}
*/	
		m_mark &= (val | PERMANENT_MARKS);
	}

	public void nandMark(int val) 
	{
/*
		if (((val & CLOSED_MARK) & m_mark) != 0) {
			catchme();
		}
		if ((m_mark & REDBOX_MARK) != 0) {
			if ((val & REDBOX_MARK) != 0) {
				System.out.println("EntityInstance.nandMark(REDBOX_MARK) " + this);
		}	}	
*/
		m_mark &= (~val | PERMANENT_MARKS);
	}
	
	public boolean isMarked(int val)
	{
		return((m_mark & val) != 0);
	}

	public int getMark()
	{
		return m_mark;
	}

	public boolean isClient()
	{
		return(isMarked(CLIENT_MARK));
	}

	public boolean isSupplier()
	{
		return(isMarked(SUPPLIER_MARK));
	}

	public boolean isClientOrSupplier()
	{
		return(isMarked(CLIENT_MARK|SUPPLIER_MARK));
	}

	public void markDeleted()
	{
		// Can't use orMark() -- permanent mark
		m_mark |= DELETED_MARK;
	}

	public void clearDeleted()
	{
		m_mark &= ~DELETED_MARK;
	}

	public double parentsWidthLocal()
	{
		EntityInstance parent;

		parent = getContainedBy();
		if (parent == null) {
			return(getDiagram().getWidth());
		} 
		return(parent.parentsWidthLocal() * parent.widthRelLocal());
	}

	public double parentsHeightLocal()
	{
		EntityInstance parent;

		parent = getContainedBy();
		if (parent == null) {
			return(getDiagram().getHeight());
		} 
		return(parent.parentsHeightLocal() * parent.heightRelLocal());
	}

	public double parentsWidth()
	{
		EntityInstance parent;

		parent = getContainedBy();
		if (parent == null) {
			return(getDiagram().getWidth());
		} 
		return(parent.getWidth());
	}

	public double parentsHeight()
	{
		EntityInstance parent;

		parent = getContainedBy();
		if (parent == null) {
			return(getDiagram().getHeight());
		} 
		return(parent.getHeight());
	}

	/* Relative local coordinate system
     *
     * 0 same offset as top/left hand edge of parent
     * 1 same offset as bottom/right hand edge of parent
     */

	public double xRelLocal()  
	{
		return(m_xrelLocal);
	}

	public void setXRelLocal(double xRelLocal) 
	{
		m_xrelLocal = xRelLocal;
	}

	public double yRelLocal() 
	{
		return(m_yrelLocal);
	}

	public void setYRelLocal(double yRelLocal) 
	{
		m_yrelLocal = yRelLocal;
	}

	public double widthRelLocal() 
	{
		return(m_widthrelLocal);
	}

	public void setWidthRelLocal(double widthRelLocal) 
	{
	/*
		if (getEntityLabel().equals("stdout")) {
			System.out.println("EntityInstance.setWidthRelLocal " + m_widthrelLocal + "->" + widthRelLocal);
		}
	 */
		m_widthrelLocal = widthRelLocal;
	}

	public double heightRelLocal() 
	{
		return(m_heightrelLocal);
	}

	public void setXRelLocalBounded(double xRelLocal)  
	{
		if (xRelLocal < 0) {
			xRelLocal = 0.0;
		}
		setXRelLocal(xRelLocal);
	}

	class SetXRelLocal extends MyUndoableEdit implements UndoableEdit
	{
		double               m_old;
		double               m_new;

		SetXRelLocal(double old)
		{
			m_old = old;
			m_new = m_xrelLocal;
			logEdit(this);
		}	

		public String getPresentationName() 
		{
			return EntityInstance.this.toString() + " xRelLocal " + Util.formatFraction(m_new);
		}

		public void undo()
		{
			setXRelLocal(m_old);
			getDiagram().redrawDiagram();
		}

		public void redo()
		{
			setXRelLocal(m_new);
			getDiagram().redrawDiagram();
	}	}

	public void updateXRelLocal(double value)
	{
		double old = m_xrelLocal;

		if (value < 0) {
			value = 0;
		} 
		if (value != old) {
			setXRelLocal(value);
			areaMoved();
			if (undoEnabled()) {
				new SetXRelLocal(old);
	}	}	}

	public void setYRelLocalBounded(double yRelLocal) 
	{
		if (yRelLocal < 0) {
			yRelLocal = 0.0;
		}
		setYRelLocal(yRelLocal);
	}	

	class SetYRelLocal extends MyUndoableEdit implements UndoableEdit
	{
		double               m_old;
		double               m_new;

		SetYRelLocal(double old)
		{
			m_old = old;
			m_new = m_yrelLocal;
			logEdit(this);
		}

		public String getPresentationName() 
		{
			return EntityInstance.this.toString() + " yRelLocal " + Util.formatFraction(m_new);
		}

		public void undo()
		{
			setYRelLocal(m_old);
			getDiagram().redrawDiagram();
		}

		public void redo()
		{
			setYRelLocal(m_new);
			getDiagram().redrawDiagram();
	}	}


	public void updateYRelLocal(double value)
	{
		double old = m_yrelLocal;

		if (value < 0) {
			value = 0;
		}
		if (value != old) {
			setYRelLocal(value);
			areaMoved();
			if (undoEnabled()) {
				new SetYRelLocal(old);
	}	}	}

	public void setWidthRelLocalBounded(double widthRelLocal) 
	{
		if (widthRelLocal > 1.0) {
			widthRelLocal = 1.0;
		}
		if ((m_xrelLocal + widthRelLocal) > 1.0) {
			setXRelLocal(1.0 - widthRelLocal);
		}
		setWidthRelLocal(widthRelLocal);
	}

	class SetWidthRelLocal extends MyUndoableEdit implements UndoableEdit
	{
		double               m_old;
		double               m_new;

		SetWidthRelLocal(double old)
		{
			m_old = old;
			m_new = m_widthrelLocal;
			logEdit(this);
		}

		public String getPresentationName() 
		{
			return EntityInstance.this.toString() + " widthRelLocal " + Util.formatFraction(m_new);
		}

		public void undo()
		{
			setWidthRelLocal(m_old);
			getDiagram().redrawDiagram();
		}

		public void redo()
		{
			setWidthRelLocal(m_new);
			getDiagram().redrawDiagram();
	}	}

	public void updateWidthRelLocal(double value)
	{
		double old = m_widthrelLocal;

		if (value > 1.0) {
			value = 1.0;
		}
		if ((m_xrelLocal + value) > 1.0) {
			updateXRelLocal(1.0 - value);
		}

		if (value != old) {
			setWidthRelLocal(value);
			if (undoEnabled()) {
				new SetWidthRelLocal(old);
			}
			areaChanged();
	}	}

	public void setHeightRelLocal(double heightRelLocal) 
	{
	/*
		if (getEntityLabel().equals("stdout")) {
			System.out.println("EntityInstance.setHeightRelLocal " + m_heightrelLocal + "->" + heightRelLocal);
		}
	 */
		m_heightrelLocal = heightRelLocal;
	}

	public void setHeightRelLocalBounded(double heightRelLocal) 
	{
		if (heightRelLocal > 1.0) {
			heightRelLocal = 1.0;
		}
		if (m_yrelLocal + heightRelLocal > 1.0) {
			setYRelLocal(1.0 - heightRelLocal);
		}
		setHeightRelLocal(heightRelLocal);
	}

	class SetHeightRelLocal extends MyUndoableEdit implements UndoableEdit
	{
		double               m_old;
		double               m_new;

		SetHeightRelLocal(double old)
		{
			m_old = old;
			m_new = m_heightrelLocal;
			logEdit(this);
		}

		public String getPresentationName() 
		{
			return EntityInstance.this.toString() + " heightRelLocal " + Util.formatFraction(m_new);
		}

		public void undo()
		{
			setHeightRelLocal(m_old);
			getDiagram().redrawDiagram();
		}

		public void redo()
		{
			setHeightRelLocal(m_new);
			getDiagram().redrawDiagram();
	}	}

	public void updateHeightRelLocal(double value)
	{
		double old = m_heightrelLocal;

		if (value > 1.0) {
			value = 1.0;
		}
		if (m_yrelLocal + value > 1.0) {
			updateYRelLocal(1.0 - value);
		}
		if (value != old) {
			setHeightRelLocal(value);
			if (undoEnabled()) {
				new SetHeightRelLocal(old);
			}
			areaChanged();
	}	}

	public void setRelLocal(double x, double y, double width, double height)
	{
		setXRelLocal(x);
		setYRelLocal(y);
		setWidthRelLocal(width);
		setHeightRelLocal(height);
	}

	public void setRelLocal(EntityInstance e)
	{
		setXRelLocal(e.xRelLocal());
		setYRelLocal(e.yRelLocal());
		setWidthRelLocal(e.widthRelLocal());
		setHeightRelLocal(e.heightRelLocal());
	}

	// Not currently used

	public void setRelLocalBounded(double x, double y, double width, double height)
	{
		if (x < 0) {
			x = 0;
		} 
		if (y < 0) {
			y = 0;
		}
		if (width > 1.0) {
			width = 1.0;
		}
		if (height > 1.0) {
			height = 1.0;
		}
		if ((x + width) > 1.0) {
			x = 1.0 - width;
		}
		if ((y + height) > 1.0) {
			y = 1.0 - height;
		}
		setRelLocal(x,y,width, height);
	}

	class SetRelLocal extends MyUndoableEdit implements UndoableEdit
	{
		double               m_oldX, m_oldY, m_oldWidth, m_oldHeight;
		double               m_newX, m_newY, m_newWidth, m_newHeight;

		SetRelLocal(double x, double y, double width, double height)
		{
			m_oldX      = x;
			m_oldY      = y;
			m_oldWidth  = width;
			m_oldHeight = height;
			m_newX      = m_xrelLocal;
			m_newY      = m_yrelLocal;
			m_newWidth  = m_widthrelLocal;
			m_newHeight = m_heightrelLocal;

			logEdit(this);
		}

		public String getPresentationName() 
		{
			return EntityInstance.this.toString() + " RelLocal {" + Util.formatFraction(m_newX) + "x" + Util.formatFraction(m_newY) + "," + Util.formatFraction(m_newWidth) + "x" + Util.formatFraction(m_newHeight) + "}";
		}

		public void undo()
		{
			setRelLocal(m_oldX, m_oldY, m_oldWidth, m_oldHeight);
			getDiagram().redrawDiagram();
		}

		public void redo()
		{
			setRelLocal(m_newX, m_newY, m_newWidth, m_newHeight);
			getDiagram().redrawDiagram();
	}	}

	public void updateRelLocal(double x, double y, double width, double height)
	{
		double oldX      = m_xrelLocal;
		double oldY      = m_yrelLocal;
		double oldWidth  = m_widthrelLocal;
		double oldHeight = m_heightrelLocal;

		if (x < 0) {
			x = 0;
		} 
		if (y < 0) {
			y = 0;
		}
		if (width > 1.0) {
			width = 1.0;
		}
		if (height > 1.0) {
			height = 1.0;
		}
		if ((x + width) > 1.0) {
			x = 1.0 - width;
		}
		if ((y + height) > 1.0) {
			y = 1.0 - height;
		}
		if (x != oldX || y != oldY || width != oldWidth || height != oldHeight) {
			setRelLocal(x, y, width, height);
			if (undoEnabled()) {
				new SetRelLocal(oldX, oldY, oldWidth, oldHeight);
			}
			if (width * height != oldWidth * oldHeight) {
				areaChanged();
	}	}	}

	/* Local coordinate system (obsoleted because of numeric underflow)
	 *
	 * 0 - Same as top/left edge of parent
	 * n - As position n while parent at position m.
     */

	/* This is only called if we are using legacy coordinate system..
	 * It is called after loading coordinates
	 * and converts the old local coordinates temporarily stored into relative ones
	 */

	public void computeRelCoordinates(double xParent, double yParent, double widthParent, double heightParent)
	{
		double			xLocal, yLocal, widthLocal, heightLocal;
		Enumeration		en;
		EntityInstance	e;

		xLocal      = m_xrelLocal;
		yLocal      = m_yrelLocal;
		widthLocal  = m_widthrelLocal;
		heightLocal = m_heightrelLocal;

		if (widthParent == 0.0) {
			setXRelLocal(0.0);
			setWidthRelLocal(0.0);
		} else {
			setXRelLocal(xLocal/widthParent);
			setWidthRelLocal(widthLocal/widthParent);
		}
		if (heightParent == 0.0) {
			setYRelLocal(0.0);
			setHeightRelLocal(0.0);
		} else {
			setYRelLocal(yLocal/heightParent);
			setHeightRelLocal(heightLocal/heightParent);
		}

		for (en = getChildren(); en.hasMoreElements(); ) {
			e = (EntityInstance) en.nextElement();
			e.computeRelCoordinates(xLocal, yLocal, widthLocal, heightLocal);
		}
//		System.out.println("EntityInstance:computeRelCoordinates(" + xParent + ", " + yParent + ", " + widthParent + ", " + heightParent + ") = {" + m_xrelLocal + ", " + m_yrelLocal + ", " + m_widthrelLocal + ", " + m_heightrelLocal + "}");
	}

	/* Store absolute coordinates as relative ones and later fix up */

	public void setxLocal(double xLocal)  
	{
		getTa().m_uses_local_coordinates = true;
		setXRelLocal(xLocal);
	}


	public void setyLocal(double yLocal) 
	{
		getTa().m_uses_local_coordinates = true;
		setYRelLocal(yLocal);
	}

	public void setwidthLocal(double widthLocal) 
	{
		getTa().m_uses_local_coordinates = true;
		setWidthRelLocal(widthLocal);
	}

	public void setheightLocal(double heightLocal) 
	{
		getTa().m_uses_local_coordinates = true;
		setHeightRelLocal(heightLocal);
	}

	// The routines that follow hide the complexity of getting/setting attribute values
	// from EditAttributes
 
	public int getPrimaryAttributeCount()
	{
		return(ATTRS);
	}

	public String getLsAttributeNameAt(int index)
	{
		String	name;

		if (index < ATTRS) {
			name = attributeName[index];
		} else {
			name  = super.getLsAttributeNameAt(index);
		}
		return(name);
	}

	// Need to know the type in cases where value might be null
	// For example with some colors

	public int getLsAttributeTypeAt(int index)
	{
		int		ret;
		
		if (index < ATTRS) {
			ret = attributeType[index];
		} else {
			ret = super.getLsAttributeTypeAt(index);
		}
		return(ret);
	}

	public Object getLsAttributeValueAt(int index)
	{
		Object				 value;

		switch (index) {
		case ID_ATTR:
			value = getId();
			break;
		case CLASS_ATTR:
		{
			LandscapeClassObject parentClass = getParentClass();

			if (parentClass == null) {
				value = null;
			} else {
				value = parentClass.getLabelId();
			}
			break;
		}
		case LABEL_ATTR:
			value = getLabel();
			break;
		case TITLE_ATTR:
			value = getTitle();
			break;
		case DESC_ATTR:
			value = getDescription();
			break;
		case COLOR_ATTR:
			value = getObjectColor();
			break;
		case LABEL_COLOR_ATTR:
			value = getLabelColor();
			break;
		case OPEN_COLOR_ATTR:
			value = getColorWhenOpen();
			break;
		case XRELPOSITION_ATTR:
			value = new Double(xRelLocal());
			break;
		case YRELPOSITION_ATTR:
			value = new Double(yRelLocal());
			break;
		case WIDTHREL_ATTR:
			value = new Double(widthRelLocal());
			break;
		case HEIGHTREL_ATTR:
			value = new Double(heightRelLocal());
			break;
		case FONTDELTA_ATTR:
			value = new Integer(m_fontDelta);
			break;
		default:
			value = super.getLsAttributeValueAt(index);
		}
		return(value);
	}

	public void updateAttributeValueAt(int index, Object value)
	{
		switch (index) {
		case ID_ATTR:
			setId((String) value);
			break;
		case CLASS_ATTR:
		{
			if (value != null) {
				LandscapeClassObject parentClass = getParentClass();
				String newId = (String) value;
				if (parentClass == null || !parentClass.getLabelId().equals(newId)) {
					Enumeration	en;
					EntityClass	ec;

					for (en = getTa().enumEntityClasses(); en.hasMoreElements(); ) {
						ec = (EntityClass) en.nextElement();
						if (ec.getLabelId().equals(newId)) {
							updateParentClass(ec);
							break;
			}	}	}	}
			break;
		}
		case LABEL_ATTR:
			updateLabel((String) value);
			break;
		case TITLE_ATTR:
			updateTitle((String) value);
			break;
		case DESC_ATTR:
			updateDescription((String) value);
			break;
		case COLOR_ATTR:
			updateObjectColor((Color) value);
			break;
		case LABEL_COLOR_ATTR:
			updateLabelColor((Color) value);
			break;
		case OPEN_COLOR_ATTR:
			updateColorWhenOpen((Color) value);
			break;
		case XRELPOSITION_ATTR:
			updateXRelLocal(((Double) value).doubleValue());
			break;
		case YRELPOSITION_ATTR:
			updateYRelLocal(((Double) value).doubleValue());
			break;
		case WIDTHREL_ATTR:
			updateWidthRelLocal(((Double) value).doubleValue());
			break;
		case HEIGHTREL_ATTR:
			updateHeightRelLocal(((Double) value).doubleValue());
			break;
		case FONTDELTA_ATTR:
			updateFontDelta(((Integer) value).intValue());
			break;
		default:
			super.updateAttributeValueAt(index, value);
	}	}

	public boolean containsDiagramPoint(int x, int y)
	{
		if (x < getDiagramX()) {
			return(false);
		}
		if (x > getDiagramX() + getWidth()) {
			return(false);
		}
		if (y < getDiagramY()) {
			return(false);
		}
		if (y > getDiagramY() + getHeight()) {
			return(false);
		}
		return(true);
	}

	public void dump(int indent)
	{
		Enumeration		en;
		EntityInstance	e;
		int				i;

		for (i = 0; i < indent; ++i) {
			System.out.print(" ");
		}
		System.out.println(this);

		// Handle children

		for (en = getChildren(); en.hasMoreElements(); ) {
			e = (EntityInstance) en.nextElement();
			e.dump(indent+2);
		}
	}

	// Postorder - Preorder == number of nodes below me

	public int prepostorder(int value)
	{
		Enumeration		en;
		EntityInstance	e;

		m_preorder = value;

		for (en = getChildren(); en.hasMoreElements(); ) {
			e = (EntityInstance) en.nextElement();
			value = e.prepostorder(value+1);
		}
		m_postorder = value;
		return(value);
	}

	public int	getPreorderNumber()
	{
		return m_preorder;
	}

	public int	nodesInSubtree()
	{
		return m_postorder - m_preorder + 1;
	}

	public void clearAllMarks(int preserve_entity_marks, int preserve_relation_marks) 
	{
		Enumeration			en;
		EntityInstance		e;
		RelationInstance	ri;

		andMark(preserve_entity_marks);
		
//		System.out.println("EntityInstance.clearAllMarks(" + preserve_entity_marks + ", " + preserve_relation_marks + ") " + getEntityLabel() + " srcLifted empty" );
		m_srcLiftedList.removeAllElements();
		m_dstLiftedList.removeAllElements();
		for (en = getChildren(); en.hasMoreElements(); ) {
			e = (EntityInstance) en.nextElement();
			e.clearAllMarks(preserve_entity_marks, preserve_relation_marks);
		}

		// Doing all the source points clears all edges since all edges have a source

		for (en = m_srcRelList.elements(); en.hasMoreElements(); ) {
			ri = (RelationInstance) en.nextElement();
			ri.clearMark(preserve_relation_marks);
	}	}

	/* It is cheaper to visit each node outside of the draw root and not above it
	 * and see once if it has anything into the drawing, than to examine the edges
	 * inside the diagram to see where they go
	 *
	 * Adds to the vector set all those top most nodes outside of the draw root but
	 * not above it which have edges into the drawing
	 */

	public void addClients(Vector set, EntityInstance drawRoot, boolean visibleEdges, boolean visibleEntities, boolean liftEdges)
	{
		Enumeration			en;
		RelationInstance	ri;
		EntityInstance		e;
		EntityClass			ec;

		if (this != drawRoot) {
			// Don't descend beneath the drawroot
			if (!hasDescendant(drawRoot)) {
				ec = null;
				if (visibleEntities) {
					ec = getEntityClass();
					if (ec.isShown()) {
						ec = null;
				}	}
				if (ec == null) {
					for (en = m_srcRelList.elements(); en.hasMoreElements(); ) {
						ri  = (RelationInstance) en.nextElement();
						if (visibleEdges) {
							RelationClass rc = ri.getRelationClass();
							if (!rc.isClassVisible()) {
								continue;
						}	}

						e   = ri.getDst();
						if (drawRoot.hasDescendant(e)) {
							ec = e.getEntityClass();
							if (!ec.isShown()) {
								continue;
							}
							if (!liftEdges) {
								do {
									e = e.getContainedBy();
									if (e == drawRoot) {
										orMark(CLIENT_MARK);
										set.addElement(this);
										return;
									}
								} while (e.isOpen());
							} else {
								orMark(CLIENT_MARK);
								set.addElement(this);
								return;
			}	}	}	}	}	
			for (en = getChildren(); en.hasMoreElements(); ) {
				e = (EntityInstance) en.nextElement();
				e.addClients(set, drawRoot, visibleEdges, visibleEntities, liftEdges);
	}	}	}

	/* It is cheaper to visit each node outside of the draw root and not above it
	 * and see once if it has anything into the drawing, than to examine the edges
	 * inside the diagram to see where they go
	 *
	 * Adds to the vector set all those top most nodes outside of the draw root but
	 * not above it which have edges from the drawing
	 */

	public void addSuppliers(Vector set, EntityInstance drawRoot, boolean visibleEdges, boolean visibleEntities, boolean liftEdges)
	{
		Enumeration			en;
		RelationInstance	ri;
		EntityInstance		e;
		EntityClass			ec;

		if (this != drawRoot) {
			// Don't descend beneath the drawroot
			if (!hasDescendant(drawRoot)) {
				ec = null;
				if (visibleEntities) {
					ec = getEntityClass();
					if (ec.isShown()) {
						ec = null;
				}	}
				if (ec == null) {
					for (en = m_dstRelList.elements(); en.hasMoreElements(); ) {
						ri  = (RelationInstance) en.nextElement();
						if (visibleEdges) {
							RelationClass rc = ri.getRelationClass();
							if (!rc.isClassVisible()) {
								continue;
						}	}
						e   = ri.getSrc();
						if (drawRoot.hasDescendant(e)) {
							ec = e.getEntityClass();
							if (!ec.isShown()) {
								continue;
							}
							if (!liftEdges) {
								do {
									e = e.getContainedBy();
									if (e == drawRoot) {
										orMark(SUPPLIER_MARK);
										set.addElement(this);
										return;
									}
								} while (e.isOpen());
							} else {
//								System.out.println("EntityInstance.addSuppliers " + this);
								orMark(SUPPLIER_MARK);
								set.addElement(this);
								return;
			}	}	}	}	}
			for (en = getChildren(); en.hasMoreElements(); ) {
				e = (EntityInstance) en.nextElement();
				e.addSuppliers(set, drawRoot, visibleEdges, visibleEntities, liftEdges);
	}	}	}

	protected boolean liftSrc(RelationInstance ri)
	{
		LandscapeClassObject	relationClass = ri.getParentClass();
		Enumeration				en;
		RelationInstance		other;

		if (!ri.isMarked(RelationInstance.PRESENTATION_MARKS)) {
			for (en = srcLiftedRelationElements(); en.hasMoreElements(); ) {
				other = (RelationInstance) en.nextElement();
				if (ri.m_drawSrc == other.m_drawSrc && ri.m_drawDst == other.m_drawDst && relationClass == other.getParentClass()) {
					other.incrementFrequency(ri);
					return(false);
		}	}	} 

//		System.out.println("EntityInstance.liftSrc into " + getEntityLabel() + " " + ri);
		m_srcLiftedList.add(ri);	// Add this relation to the vector of relations that have draw source in this entity
		return(true);
	}

	protected void liftDst(RelationInstance ri)
	{
//		System.out.println("EntityInstance.liftDst into " + getEntityLabel() + " " + ri);
		m_dstLiftedList.add(ri);	// Add this relation to the vector of relations that have draw destination to this entity
	}

	/* If there is any edge from me to/under under then perform openEdge operation */

	public boolean openEdgeExpansion(EntityInstance from, EntityInstance to, String containsId, String indent, ResultBox resultBox)
	{
		Enumeration			en;
		EntityInstance		e;
		RelationInstance	ri;
		EntityInstance		dst;
		boolean				ret = false;
		boolean				ret1, opened;
		String				indent1 = indent;

		for (en = m_srcRelList.elements(); en.hasMoreElements(); ) {
			ri  = (RelationInstance) en.nextElement();
			dst = ri.getDst();
			if (this != from || dst != to) {
				if (to.hasDescendantOrSelf(dst)) {
					ret = true;
					resultBox.addRelation(indent, ri);
					if (indent1 == indent) {
						indent1 = indent + "+- ";
					}
					ri.orMark(RelationInstance.HIGHLIGHT_FLAG_MARK);
					if (dst != to) {
						for (;;) {
							dst = dst.getContainedBy();
							dst.clearContainElision(containsId); 
							if (dst == to) {
								break;
		}	}	}	}	}	}

		opened = false;
		for (en = getChildren(); en.hasMoreElements(); ) {
			e = (EntityInstance) en.nextElement();
			ret1 = e.openEdgeExpansion(from, to, containsId, indent1, resultBox);
			if (ret1 && !opened) {
				ret = opened = true;
				clearContainElision(containsId);
		}	}
		return(ret);
	}

	public boolean openSrcEdgeExpansion(EntityInstance from, EntityInstance to, String containsId, String indent, ResultBox resultBox)
	{
		Enumeration			en;
		EntityInstance		e;
		RelationInstance	ri;
		EntityInstance		dst;
		boolean				ret = false;
		boolean				ret1, opened;
		String				indent1 = indent;

		for (en = m_srcRelList.elements(); en.hasMoreElements(); ) {
			ri  = (RelationInstance) en.nextElement();
			dst = ri.getDst();
			if (this != from || dst != to) {
				if (to.hasDescendantOrSelf(dst)) {
					ret = true;
					resultBox.addRelation(indent, ri);
					if (indent1 == indent) {
						indent1 = indent + "+- ";
					}
					ri.orMark(RelationInstance.HIGHLIGHT_FLAG_MARK);
		}	}	}

		opened = false;
		for (en = getChildren(); en.hasMoreElements(); ) {
			e = (EntityInstance) en.nextElement();
			ret1 = e.openSrcEdgeExpansion(from, to, containsId, indent1, resultBox);
			if (ret1 && !opened) {
				ret = opened = true;
				clearContainElision(containsId);
		}	}
		return(ret);
	}

	// Traverse the destination side

	public boolean openDstEdgeExpansion(EntityInstance from, EntityInstance to, String containsId, String indent, ResultBox resultBox)
	{
		Enumeration			en;
		EntityInstance		e;
		RelationInstance	ri;
		EntityInstance		src;
		boolean				ret = false;
		boolean				ret1, opened;
		String				indent1 = indent;

		for (en = m_dstRelList.elements(); en.hasMoreElements(); ) {
			ri  = (RelationInstance) en.nextElement();
			src = ri.getSrc();
			if (src != from || this != to) {
				if (from.hasDescendantOrSelf(src)) {
					ret = true;
					resultBox.addRelation(indent, ri);
					if (indent1 == indent) {
						indent1 = indent + "+- ";
					}
					ri.orMark(RelationInstance.HIGHLIGHT_FLAG_MARK);
		}	}	}

		opened = false;
		for (en = getChildren(); en.hasMoreElements(); ) {
			e = (EntityInstance) en.nextElement();
			ret1 = e.openDstEdgeExpansion(from, to, containsId, indent1, resultBox);
			if (ret1 && !opened) {
				ret = opened = true;
				clearContainElision(containsId);
		}	}
		return(ret);
	}

	/* Compute all the diagram edges before lifting them so that we can later when lifting them detect duplicate draw edges
	   and eliminate them.  That is we will set none null values for ri.m_drawSrc/ri.m_drawDst but not actually add them into
	   the entity vectors yet.
	 */

	public void computeAllDiagramEdges(EntityInstance drawRoot, Vector clients, Vector suppliers, EntityInstance closedEntity, boolean liftEdges)
	{
		Enumeration			en;
		RelationInstance	ri;
		EntityInstance		src, dst, e;
		EntityClass			ec;

		ec = getEntityClass();
		if (!ec.isShown()) {
			return;
		}

//		System.out.println("EntityInstance.computeAllDiagramEdges for " + this);

		// For every edge that comes to us (something in or beneath entities in the diagram)
		for (en = m_dstRelList.elements(); en.hasMoreElements(); ) {
			ri  = (RelationInstance) en.nextElement();
			ri.resetFrequency();
			src = ri.m_src;

			if (clients != null || suppliers != null) {
				// N.B. Clients may actually be classified as suppliers if one and the same
				if (!drawRoot.isPathBetween(src)) {
					ri.m_drawSrc = src.clientServer();
			}	}
			// The destination of ri comes to our entity

			if (closedEntity != null) {
				if (!closedEntity.hasDescendant(src)) {
					// Ignore internal loops beneath a closed entity
					ri.m_drawDst = closedEntity;
//					System.out.println("EntityInstance.computeAllDiagramEdges " + ri + " -> closed " + closedEntity + " not " + this);
				}
			} else {
				// The draw destination of ri is its actual destination
//				System.out.println("EntityInstance.computeAllDiagramEdges " + ri + " -> open " + this);
				ri.m_drawDst = this;
			}
//			System.out.println(" -> " + ri);
		}

		for (en = m_srcRelList.elements(); en.hasMoreElements(); ) {
			ri  = (RelationInstance) en.nextElement();
			ri.resetFrequency();
			dst = ri.m_dst;

			if (suppliers != null && !drawRoot.isPathBetween(dst)) {
				ri.m_drawDst = dst.clientServer();
			}

			// The source of ri comes from our entity

			if (closedEntity != null) {
				if (!closedEntity.hasDescendant(dst)) {
					// Ignore internal loops beneath a close entity
					ri.m_drawSrc = closedEntity;
				}
			} else {
				// The source destination of ri is its actual destination
				ri.m_drawSrc = this;
			}
//			System.out.println(" <- " + ri);
		}

		if (closedEntity == null) {
			orMark(DIAGRAM_MARK);
//			System.out.println("EntityInstance.computeAllDiagramEdges " + this + " width=" + getWidth() + " height=" + getHeight());
			if (!isOpen()) {
				closedEntity = this;
				if (!liftEdges) {
					return;
			}	}
		} else {
			setSwingObject(null);	// Release this EntityComponent -- its not visible
		}

		for (en = getChildren(); en.hasMoreElements(); ) {
			e = (EntityInstance) en.nextElement();
			e.computeAllDiagramEdges(drawRoot, clients, suppliers, closedEntity, liftEdges);
	}	}
	
	public void liftAllDiagramEdges(boolean liftEdges)
	{
		Enumeration			en;
		RelationInstance	ri;
		EntityInstance		e, src, dst;

//		System.out.println("EntityInstance.liftAllDiagramEdges " + this);

		for (en = m_dstRelList.elements(); en.hasMoreElements(); ) {
			ri  = (RelationInstance) en.nextElement();
//			System.out.println("==>" + ri);
			if (!ri.isMarked(LIFTED_MARK)) {
				ri.orMark(LIFTED_MARK);
				src = ri.m_drawSrc;
				if (src != null) {
					dst = ri.m_drawDst;
					if (dst != null) {
						if (src.liftSrc(ri)) {
							dst.liftDst(ri);
						}
//						System.out.println("EntityInstance.liftAllDiagramEdgees <-" + ri);
					}
		}	}	}
		
		for (en = m_srcRelList.elements(); en.hasMoreElements(); ) {
			ri  = (RelationInstance) en.nextElement();
//			System.out.println("<==" + ri);
			if (!ri.isMarked(LIFTED_MARK)) {
				ri.orMark(LIFTED_MARK);
				src = ri.m_drawSrc;
				if (src != null) {
					dst = ri.m_drawDst;
					if (dst != null) {
						if (src.liftSrc(ri)) {
							dst.liftDst(ri);
						}
//						System.out.println("EntityInstance.liftAllDiagramEdgees ->" + ri);
		}	}	}	}
		
		if (!liftEdges && !isOpen()) {
			return;
		}
		for (en = getChildren(); en.hasMoreElements(); ) {
			e = (EntityInstance) en.nextElement();
			e.liftAllDiagramEdges(liftEdges);
	}	}

	public void validateEdges()
	{
		Enumeration			en;
		RelationInstance	ri;
		EntityInstance		e;

		for (en = dstLiftedRelationElements(); en.hasMoreElements(); ) {
			ri  = (RelationInstance) en.nextElement();
			ri.validate();
		}

		for (en = srcLiftedRelationElements(); en.hasMoreElements(); ) {
			ri  = (RelationInstance) en.nextElement();
			ri.validate();
		}

		if (!isMarked(CLOSED_MARK)) {
			for (en = getChildren(); en.hasMoreElements(); ) {
				e = (EntityInstance) en.nextElement();
				e.validateEdges();
	}	}	}

	public boolean intersectsLayout(Rectangle rect)
	{
		// Return true if the intersection of passed layout and 
		// entities layout is non-null

		// It overlaps if any corner of layout is contained in
		// entity, or vice versa.

		Rectangle box = new Rectangle(getX(), getY(), getWidth(), getHeight());
		return box.intersects(rect);
	}

 	public boolean containsRectangle(Rectangle rect) 
	{
		int x = getDiagramX();
		int y = getDiagramY();

		return (x < rect.x && rect.x+rect.width < x+getWidth() && y < rect.y && rect.y+rect.height < y+getHeight()); 
	}

	public boolean isFramedBy(int x, int y, int width, int height)
	{
		int					myX = getDiagramX();
		int					myY = getDiagramY();
		EntityClass			ec;

		if (x > myX || y > myY) {
			return false;
		}
		myX += getWidth();
		if (x + width < myX) {
			return false;
		}
		myY += getHeight();
		if (y + height < myY) {
			return false;
		}
		ec = getEntityClass();
		if (!ec.isShown()) {
			return false;
		}
		return true;
	}
	 
	public int getParentDiagramX()
	{
		JComponent entityComponent = getSwingObject();

		if (entityComponent != null) {
			DiagramCoordinates above;
			Container          parentComponent = entityComponent.getParent();

			if (parentComponent instanceof EntityComponent) {
				above = (DiagramCoordinates) ((EntityComponent) parentComponent).getEntityInstance();
			} else {
				above = (DiagramCoordinates) parentComponent;
			}
			if (above != null) {
				return(above.getDiagramX());
		}	}
		return(0);
	}

	public int getParentDiagramY()
	{
		JComponent entityComponent = getSwingObject();

		if (entityComponent != null) {
			DiagramCoordinates above;
			Container          parentComponent = entityComponent.getParent();

			if (parentComponent instanceof EntityComponent) {
				above = (DiagramCoordinates) ((EntityComponent) parentComponent).getEntityInstance();
			} else {
				above = (DiagramCoordinates) parentComponent;
			}
			if (above != null) {
				return(above.getDiagramY());
		}	}
		return(0);
	}

	// Diagram Coordinates
	
	public int getDiagramX()
	{
		return(m_diagramX);
	}

	public int getDiagramY()
	{
		return(m_diagramY);
	}

	/* Compute the average position on the x axis of all drawn edges in/out of me */

	public void computeAvgX() 
	{
		EntityComponent ec = neededComponent();

		Enumeration			en;
		RelationInstance	ri;
		EntityInstance		src, dst;
		int					edgeMode;
		double				f, avg;
		double				x = 0.0;
		int					n = 0;

		edgeMode = getDiagram().getEdgeMode();
		if (edgeMode == Do.DIRECT_EDGE_STATE) {
			// For every edge coming out of us consider the destination
			for (en = srcLiftedRelationElements(); en.hasMoreElements(); ) {
				ri  = (RelationInstance) en.nextElement();
				dst = ri.m_drawDst;
				x  += (dst.getDiagramX() + dst.getWidth()/2);
				++n;
			}
			// For every edge coming into us consider the source
			for (en = dstLiftedRelationElements(); en.hasMoreElements(); ) {
				ri  = (RelationInstance) en.nextElement();
				src = ri.m_drawSrc;
				x  += (src.getDiagramX() + src.getWidth()/2);
				++n;
			}
		} else {
			for (en = srcLiftedRelationElements(); en.hasMoreElements(); ) {
				ri  = (RelationInstance) en.nextElement();
				dst = ri.m_drawDst;
				f   = ri.getRelationClass().getIOfactor();
				x  += (dst.getDiagramX() + dst.getWidth()*f);
				++n;
			}
			for (en = dstLiftedRelationElements(); en.hasMoreElements(); ) {
				ri  = (RelationInstance) en.nextElement();
				src = ri.m_drawSrc;
				f   = ri.getRelationClass().getIOfactor();
				x  += (src.getDiagramX() + src.getWidth()*f);
				++n;
		}	}
		if (n > 0) {
			avg = x/((double) n);
		} else {
			avg = -1.0;
		}
		ec.setAvgX(avg);
	}

	public double getAvgX()
	{
		EntityComponent ec = neededComponent();

		return ec.getAvgX();
	}

	// Reset all cardinals associated with this entity and things it contains

	public void resetDstCardinals(int numRelations) 
	{
		Enumeration en;

		EntityComponent entityComponent = (EntityComponent) getSwingObject();
		if (entityComponent != null) {
			entityComponent.resetDstCardinals(numRelations);

			for (en = getChildren(); en.hasMoreElements(); ) {
				EntityInstance e = (EntityInstance) en.nextElement();
				e.resetDstCardinals(numRelations);
	}	}	}

	public void resetSrcCardinals(int numRelations) 
	{
		Enumeration en;

		EntityComponent entityComponent = (EntityComponent) getSwingObject();
		if (entityComponent != null) {
			entityComponent.resetSrcCardinals(numRelations);

			for (en = getChildren(); en.hasMoreElements(); ) {
				EntityInstance e = (EntityInstance) en.nextElement();
				e.resetSrcCardinals(numRelations);
	}	}	}

	// Calculate the number of edges into me

	public void calcDstEdgeCardinals(boolean hOnly)
	{
		Enumeration			en;
		RelationInstance	ri;
		RelationClass		rc;
		EntityInstance		src, dst, target;
		EntityInstance		e;
		int					ind;
		Cardinal[]			cardinals;
		Cardinal			cardinal;
		EntityClass			ec;

//		System.out.println("EntityInstance.calcEdgeCardinals for " + this);

		EntityComponent entityComponent = (EntityComponent) getSwingObject();

		if (entityComponent != null) {
			cardinals = entityComponent.getDstCardinals();
			// For every edge that comes to us (something in or beneath entities in the diagram)
			for (en = m_dstLiftedList.elements(); en.hasMoreElements(); ) {
				ri  = (RelationInstance) en.nextElement();
			
				if (!hOnly || ri.getHighlightFlag()) {
					rc  = ri.getRelationClass();

					if (rc.isContainsClass()) {
						continue;
					}
					ind = rc.getNid();

					cardinal = cardinals[ind];
					if (cardinal == null) {
						cardinal            = new Cardinal();
						cardinals[ind] = cardinal;
					}
					cardinal.sum(ri);
				}
			}

			for (en = getChildren(); en.hasMoreElements(); ) {
				e = (EntityInstance) en.nextElement();
				e.calcDstEdgeCardinals(hOnly);
	}	}	}

	// Calculate the number of edges into me

	public void calcSrcEdgeCardinals(boolean hOnly)
	{
		Enumeration			en;
		RelationInstance	ri;
		RelationClass		rc;
		EntityInstance		src, dst, target;
		EntityInstance		e;
		int					ind;
		Cardinal[]			cardinals;
		Cardinal			cardinal;
		EntityClass			ec;

		EntityComponent entityComponent = (EntityComponent) getSwingObject();

//		System.out.println("EntityInstance.calcEdgeCardinals for " + this);

		if (entityComponent != null) {
			cardinals = entityComponent.getSrcCardinals();

			// For every edge that comes to us (something in or beneath entities in the diagram)
			for (en = m_srcLiftedList.elements(); en.hasMoreElements(); ) {
				ri  = (RelationInstance) en.nextElement();
			
				if (!hOnly || ri.getHighlightFlag()) {
					rc  = ri.getRelationClass();
					if (rc.isContainsClass()) {
						continue;
					}
					ind = rc.getNid();

					cardinal = cardinals[ind];
					if (cardinal == null) {
						cardinal       = new SrcCardinal();
						cardinals[ind] = cardinal;
					}
					cardinal.sum(ri);
				}
			}

			for (en = getChildren(); en.hasMoreElements(); ) {
				e = (EntityInstance) en.nextElement();
				e.calcSrcEdgeCardinals(hOnly);
	}	}	}
	
	public void showDstCardinals()
	{
		Enumeration		en;
		EntityInstance	e;
		int				width, height;
		EntityClass		ec;

//		System.out.println("EntityInstance.showCardinals " + this);

		width    = getWidth();
		height   = getHeight();

		if (width > 0 && height > 0) {

			EntityComponent entityComponent = (EntityComponent) getSwingObject();
			if (entityComponent != null) {
				
				Cardinal[]	cardinals;

				cardinals = entityComponent.getDstCardinals();

				if (cardinals != null) {
					ec = getEntityClass();
					if (ec.isShown()) {
						int				cnt;

						Diagram		diagram = getDiagram();
						Cardinal	cardinal;
						int			i, diagramX, diagramY, w1;
						RelationClass rc;
						double		f;

						diagramX = getDiagramX();
						diagramY = getDiagramY();

						for (i = cardinals.length; i > 0; ) {
							cardinal = cardinals[--i];
							if (cardinal != null) {
								cnt      = cardinal.getCnt();
								if (cnt > 0) {
									rc = diagram.numToRelationClass(i);
									f  = rc.getIOfactor();
									cardinal.setBackground(rc.getInheritedObjectColor());
									cardinal.setCenterTop(diagramX, diagramY, width, height, f);
									diagram.add(cardinal /* JLayeredPane.PALETTE_LAYER */);		// Add this cardinal to the diagram
				}	}	}	}	}

				for (en = getChildren(); en.hasMoreElements(); ) {
					e = (EntityInstance) en.nextElement();
					e.showDstCardinals();
	}	}	}	}

	public void showSrcCardinals()
	{
		Enumeration		en;
		EntityInstance	e;
		int				width, height;
		EntityClass		ec;

//		System.out.println("EntityInstance.showSrcCardinals " + this);

		width    = getWidth();
		height   = getHeight();

		if (width > 0 && height > 0) {

			EntityComponent entityComponent = (EntityComponent) getSwingObject();
			if (entityComponent != null) {
				Cardinal[]	cardinals;

				cardinals = entityComponent.getSrcCardinals();
				if (cardinals != null) {
					ec = getEntityClass();
					if (ec.isShown()) {
						int				cnt;

						Diagram		diagram = getDiagram();
						Cardinal	cardinal;
						int			i, diagramX, diagramY, w1;
						RelationClass rc;
						double		f;

						diagramX = getDiagramX();
						diagramY = getDiagramY();

						for (i = cardinals.length; i > 0; ) {
							cardinal = cardinals[--i];
							if (cardinal != null) {
								cnt      = cardinal.getCnt();
								if (cnt > 0) {
									rc = diagram.numToRelationClass(i);
									f  = rc.getIOfactor();
									cardinal.setBackground(rc.getInheritedObjectColor());
									cardinal.setCenterTop(diagramX, diagramY, width, height, f);
									diagram.add(cardinal /* JLayeredPane.PALETTE_LAYER */);		// Add this cardinal to the diagram
				}	}	}	}	}

				for (en = getChildren(); en.hasMoreElements(); ) {
					e = (EntityInstance) en.nextElement();
					e.showSrcCardinals();
	}	}	}	}

	public void moveCardinals()
	{
		Enumeration		en;
		EntityInstance	e;
		int				width, height;

		// Move cardinals in sync with entity

		EntityComponent entityComponent = (EntityComponent) getSwingObject();
		Cardinal[]		cardinals;

		if (entityComponent != null) {
			width  = getWidth();
			height = getHeight();

			if (width > 0 && height > 0) {
				Diagram			diagram = getDiagram();
				int				i, diagramX, diagramY;

				diagramX = getDiagramX();
				diagramY = getDiagramY();

				cardinals = entityComponent.getDstCardinals();
				if (cardinals != null) {	
					Cardinal		cardinal;
					RelationClass	rc;
					double			f;

					for (i = cardinals.length; i > 0; ) {
						cardinal = cardinals[--i];
						if (cardinal != null) {
							rc       = diagram.numToRelationClass(i);
							f        = rc.getIOfactor();
							cardinal.setCenterTop(diagramX, diagramY, width, height, f);
							cardinal.revalidate();
				}	}	}

				cardinals = entityComponent.getSrcCardinals();
				if (cardinals != null) {	
					Cardinal		cardinal;
					RelationClass	rc;
					double			f;

					for (i = cardinals.length; i > 0; ) {
						cardinal = cardinals[--i];
						if (cardinal != null) {
							rc       = diagram.numToRelationClass(i);
							f        = rc.getIOfactor();
							cardinal.setCenterTop(diagramX, diagramY, width, height, f);
							cardinal.revalidate();
				}	}	}
	}	}	}

	// Assuming p1 is in this object and p2 is outside,
	// return the point that is the intersection between this object 
	// and the line segment p1->p2.

	public RealPoint calculateIntercept(RealPoint p1, RealPoint p2) 
	{
		double x = 0.0;
		double y = 0.0;

		double t, b, l, r;	// Top, bottom, left, and right
		double x1, y1, x2, y2;

		t = getY() -1;
		b = getY() + getHeight() + 1;
		l = getX() - 1;
		r = getX() + getWidth() + 1;

		boolean found = true;

		x1 = p1.getX();
		y1 = p1.getY();
		
		if (x1 < l || x1 > r || y1 < t || y1 > b) {
			MsgOut.println("calculateIntercept: p1 is not in box");
			return new RealPoint(x, y);
		}

		x2 = p2.getX();
		y2 = p2.getY();
		
		if (x1 == x2 && y1 == y2) {
			MsgOut.println("calculateIntercept: p1 == p2");
			return new RealPoint(x, y);
		}

		if (r <= x2) {
			x = r;
		} else if (x2 < l) {
			x = l;
		} else {
			found = false;
		}

		if (found) {
			// y = mx + b
			y = y1 + (x - x1) * ( (y2 - y1) / (x2 - x1) );
			found = ( t <= y && y <= b );
		}

		if (!found) {
			found = true;

			if (y2 <= t) {
				y = t;
			} else if (y2 >= b) {
				y = b;
			} else {
				found = false;
			}

			if (found) {
				x = x1 + (y - y1) * ( (x2 - x1) / (y2 - y1) );
				found = (l <= x && x <= r);
			}

		}

		if (!found) {
			MsgOut.println("calculateIntercept failed: " + x1 + " " + y1 + " " + x2 + " " + y2); 
		}
		return new RealPoint(x, y);
	}

	public int overResizeTab(int x1, int y1) 
	{
		int xLeft, xMid, xRight;
		int	yTop,  yMid, yBottom;
		int	pos;

		xLeft  = getDiagramX();

		if (x1 < xLeft) {
			// Outside object
			return RSZ_NONE;
		}
		if (x1 <= xLeft + 6) {
			pos = 0;
		} else {
			xRight = xLeft + getWidth();
			if (x1 > xRight) {
				// Outside object
				return RSZ_NONE;
			}
			if (x1 >= xRight - 6) {
				pos = 2;
			} else {
				xMid   = (xLeft + xRight)  / 2;
				if (x1 < xMid - 3 || x1 > xMid + 3) {
					return RSZ_NONE;
				}
				pos = 1;
		}	}

		yTop = getDiagramY();
		if (y1 < yTop) {
			// Outside object
			return RSZ_NONE;
		}
		if (y1 > yTop + 6) {
			yBottom = (int) (yTop + getHeight());
			if (y1 > yBottom) {
				// Outside object
				return RSZ_NONE;
			}
			if (y1 >= yBottom - 6) {
				pos += 6;
			} else {
				yMid = (yTop  + yBottom) / 2;
				if (y1 < yMid - 3 || y1 > yMid + 3) {
					return RSZ_NONE;
				}
				pos += 3;
		}	}

		switch (pos) {
		case 0:
			return RSZ_NW;
		case 1:
			return RSZ_N;
		case 2:
			return RSZ_NE;
		case 3:
			return RSZ_W;
		case 5:
			return RSZ_E;
		case 6:
			return RSZ_SW;
		case 7:
			return RSZ_S;
		case 8:
			return RSZ_SE;
		}
		return RSZ_NONE;
	}

	public boolean isPointOverIO(EdgePoint pt, int x, int y) 
	{
		int	x1, y1;

		x1 = (int) (pt.getX() + 0.5);	// round
		y1 = (int) (pt.getY() + 0.5);	// round	

		return ((x1 - RelationInstance.NEAR_PIXEL_SIZE/2) < x && x < (x1 + RelationInstance.NEAR_PIXEL_SIZE/2) && (y1 - RelationInstance.NEAR_PIXEL_SIZE/2) < y && y < (y1 + RelationInstance.NEAR_PIXEL_SIZE/2));
	}

	public void drawHighlight() 
	{
		if (!isMarked(HIGHLIGHT_EDGE_MARK)) {
			orMark(HIGHLIGHT_EDGE_MARK);
			repaint();
	}	}

	public void undrawHighlight() 
	{
		if (isMarked(HIGHLIGHT_EDGE_MARK)) {
			nandMark(HIGHLIGHT_EDGE_MARK);
			repaint();
	}	}

	private EdgePoint getPoint(EdgePoint[] pts, RelationClass rc, int side) 
	{
		int		  nid;
		EdgePoint cached;

		nid	   = rc.getNid();
		cached = pts[nid];

		// Cache calculated points

		if (cached == null || cached.getRc() != rc) {

			double f  = rc.getIOfactor();
			double wf = 0.0;
			double hf = 0.0;

			switch(side) {
			case EdgePoint.TOP:
				wf = f;					// Put at entity x + width * f at top
				break;
			case EdgePoint.BOTTOM:
				wf = f;
				hf = 1.0;				// Put at bottom
				break;
			case EdgePoint.LEFT:
				hf = f;					// Put at left
				break;
			default:
				wf = 1.0;				// Put at right
				hf = f;
				break;
			}
			if (cached == null) {
				pts[nid] = cached = new EdgePoint(this);
				cached.setProperties(rc, wf, hf);
			} else {
				cached.setRc(rc);
			}
			cached.rescale();	// Compute actual point given current position of e
		}
/*
		if (side == EdgePoint.TOP && getEntityLabel().equals("code")) {
			System.out.println("EntityInstance.getPoint " + cached);
		}
*/  
		return cached;
	}

	public EdgePoint getPoint(RelationClass rc, int side) 
	{
		EdgePoint[] cache;

		switch(side) {
		case EdgePoint.TOP:
			cache = m_topPoints;
			if (cache == null) {
				m_topPoints = cache = new EdgePoint[numRelationClasses()];
			}
			break;
		case EdgePoint.BOTTOM:
			cache = m_bottomPoints;
			if (cache == null) {
				m_bottomPoints = cache = new EdgePoint[numRelationClasses()];
			}
			break;
		case EdgePoint.LEFT:
			cache = m_leftPoints;
			if (cache == null) {
				m_leftPoints = cache = new EdgePoint[numRelationClasses()];
			}
			break;
		default:
			cache = m_rightPoints;
			if (cache == null) {
				m_rightPoints = cache = new EdgePoint[numRelationClasses()];
		}	 }
		return getPoint(cache, rc, side);
	}


	// At what point does the ri relation hit this, given that it goes from the box specified by srcLyt to dstLyt
	// N.B. Most of the time anyway it appears that srcLyt is the srcLyt of this.

	public EdgePoint getOutPoint(RelationInstance ri, int edge_mode, Rectangle srcLyt, Rectangle dstLyt) 
	{
		RelationClass rc = ri.getRelationClass();

		if (edge_mode == Do.TB_EDGE_STATE) {
			// Only allow edges to be from top or bottom
			EntityInstance src = (EntityInstance) ri.getSrc();
			if (this == src || src.hasAncestor(this)) {
				return getPoint(rc, EdgePoint.BOTTOM);
			}
			return getPoint(rc, EdgePoint.TOP);
		}
		if ((dstLyt.y - (srcLyt.y+srcLyt.height)) > SEP_THRESHOLD) {

			// dstLyt strictly below srcLyt
			return getPoint(rc, EdgePoint.BOTTOM);
		}

		if ((srcLyt.y - (dstLyt.y+dstLyt.height)) > SEP_THRESHOLD) {
			// srcLyt strictly below dstLyt
			return getPoint(rc, EdgePoint.TOP);
		}

		if ((dstLyt.x - (srcLyt.x+srcLyt.width)) > SEP_THRESHOLD) {
			return getPoint(rc, EdgePoint.RIGHT);
		}

		if ((srcLyt.x - (dstLyt.x+dstLyt.width)) > SEP_THRESHOLD) {
			return getPoint(rc, EdgePoint.LEFT);
		}

		if (dstLyt.y > (srcLyt.y+srcLyt.height)) {
			return getPoint(rc, EdgePoint.BOTTOM);
		}
		return getPoint(rc, EdgePoint.TOP);
	}

	public EdgePoint getLeftOutPoint(RelationInstance ri) 
	{
		RelationClass rc = ri.getRelationClass();

		return getPoint(rc, EdgePoint.LEFT);
	}

	public EdgePoint getRightOutPoint(RelationInstance ri) 
	{
		RelationClass rc = ri.getRelationClass();

		return getPoint(rc, EdgePoint.RIGHT);
	}

	public EdgePoint getTopOutPoint(RelationInstance ri) 
	{
		RelationClass rc = ri.getRelationClass();

		return getPoint(rc, EdgePoint.TOP);
	}

	public EdgePoint getBottomOutPoint(RelationInstance ri) 
	{
		RelationClass rc = ri.getRelationClass();

		return getPoint(rc, EdgePoint.BOTTOM);
	}

	protected EdgePoint testMouseOverIO(EdgePoint[] pts, int x, int y) 
	{
		if (pts == null) {
			return null;
		}

		for (int i = 0; i < pts.length; i++) {
			EdgePoint pt = pts[i];

			if (pt != null) {
				if (isPointOverIO(pt, x, y)) {
					return pt;
				}
			}
		}
		return null;
	}

	public EdgePoint getMouseOverIO(int x, int y) 
	{
		EdgePoint pt = testMouseOverIO(m_topPoints, x, y);
		if (pt != null) {
			return pt;
		}

		pt = testMouseOverIO(m_bottomPoints, x, y);
		if (pt != null) {
			return pt;
		}

		pt = testMouseOverIO(m_leftPoints, x, y);
		if (pt != null) {
			return pt;
		}
		return testMouseOverIO(m_rightPoints, x, y);
	}

	// Icon interface (used to paint legends)

	public int getIconWidth()
	{
		return(getWidth());
	}

	public int getIconHeight()
	{
		return(getHeight());
	}

	public void paintIcon(Component c, Graphics g, int x, int y)
	{
		EntityComponent entityComponent = neededComponent();

		entityComponent.paintIcon(c, g, x, y);	
	}

	public int getClassImage() 
	{
		return getEntityClass().getImage();
	}

	public double getClassAngle() 
	{
		return getEntityClass().getAngle();
	}

	public int getClassDirection() 
	{
		int val = (int) getClassAngle();

		return( ((val + 45) / 90) % 4);
	}

	public int validateEntityAttributes(Vector v, Vector a[], ResultBox resultBox)
	{
		EntityClass		ec1  = getEntityClass();
		int				ret  = 0;
		Vector			attributes;
		Enumeration		en;
		EntityInstance	child;
		int				i, j, size;
		Attribute		attribute, attribute1;
		boolean			seen;
		String			id;

		size = v.size();
		for (i = 0; i < size; ++i) {
			if (ec1 == v.elementAt(i)) {
				attributes = a[i];
				if (attributes == null) {
					a[i] = attributes = ec1.getValidAttributes();
				}
				seen = false;
				en = getLsAttributesEnum();
				if (en != null) {
					for (; en.hasMoreElements(); ) {
						attribute = (Attribute) en.nextElement();
						id        = attribute.id;
						for (j = attributes.size(); ; ) {
							if (--j < 0) {
								if (!seen) {
									resultBox.addResultEntity(this);
									seen = true;
									++ret;
								}
								resultBox.addResultAttribute(attribute);
								break;
							}
							attribute1 = (Attribute) attributes.elementAt(j);
							if (id.equals(attribute1.id)) {
								break;
		}	}	}	}	}	}

		for (en = getChildren(); en.hasMoreElements(); ) {
			child = (EntityInstance) en.nextElement();
			ret += child.validateEntityAttributes(v, a, resultBox);
		}
		return(ret);
	}

	public int validateRelationAttributes(Vector v, Vector a[], ResultBox resultBox)
	{
		RelationClass	rc;
		RelationInstance ri;
		int				ret  = 0;
		Vector			attributes;
		Enumeration		en1, en;
		EntityInstance	child;
		int				i, j, size;
		Attribute		attribute, attribute1;
		boolean			seen;
		String			id;

		size = v.size();
		for (en1 = m_srcRelList.elements(); en1.hasMoreElements(); ) {
			ri  = (RelationInstance) en1.nextElement();
			rc  = ri.getRelationClass();
			for (i = 0; i < size; ++i) {
				if (rc == v.elementAt(i)) {
					attributes = a[i];
					if (attributes == null) {
						a[i] = attributes = rc.getValidAttributes();
					}
					seen = false;
					en = ri.getLsAttributesEnum();
					if (en != null) {
						for (; en.hasMoreElements(); ) {
							attribute = (Attribute) en.nextElement();
							id        = attribute.id;
							for (j = attributes.size(); ; ) {
								if (--j < 0) {
									if (!seen) {
										resultBox.addRelation(ri);
										seen = true;
										++ret;
									}
									resultBox.addResultAttribute(attribute);
									break;
								}
								attribute1 = (Attribute) attributes.elementAt(j);
								if (id.equals(attribute1.id)) {
									break;
					}	}	}	}
					break;
		}	}	}

		for (en = getChildren(); en.hasMoreElements(); ) {
			child = (EntityInstance) en.nextElement();
			ret += child.validateRelationAttributes(v, a, resultBox);
		}
		return(ret);
	}

	public int validateRelations(Vector v, boolean a[][][], ResultBox resultBox, EntityInstance root)
	{
		RelationClass	rc;
		RelationInstance ri;
		int				ret  = 0;
		boolean			relationArray[][];
		Enumeration		en1, en;
		EntityInstance	child;
		int				phase, i, j, size;
		Attribute		attribute, attribute1;
		boolean			seen;
		EntityInstance	s, d;
		EntityClass		src, dst;

		size = v.size();
		en1 = m_srcRelList.elements();
		for (phase = 0; phase < 2; ++phase) {
			for (; en1.hasMoreElements(); ) {
				ri  = (RelationInstance) en1.nextElement();
				if (ri.isMarked(RelationInstance.VALIDATED_MARK)) {
					continue;
				}
				ri.orMark(RelationInstance.VALIDATED_MARK);
				rc  = ri.getRelationClass();
				for (i = 0; i < size; ++i) {
					if (rc == v.elementAt(i)) {
						relationArray = a[i];
						if (relationArray == null) {
							a[i] = relationArray = rc.getInheritedRelationArray();
						}
						s    = ri.getSrc();
						d    = ri.getDst();
						if (s != root && d != root) {
							src  = s.getEntityClass();
							dst  = d.getEntityClass();
							if (!relationArray[src.getOrderedId()][dst.getOrderedId()]) {
								resultBox.addRelation("", ri);
								++ret;
						}	}
						break;
			}	}	}
			en1 = m_dstRelList.elements();
		}

		for (en = getChildren(); en.hasMoreElements(); ) {
			child = (EntityInstance) en.nextElement();
			ret += child.validateRelations(v, a, resultBox, root);
		}
		return(ret);
	}

	public void gatherLeaves(Vector v)
	{
		Enumeration		en;
		EntityInstance	child;

		child = null;
		for (en = getChildren(); en.hasMoreElements(); ) {
			child = (EntityInstance) en.nextElement();
			child.gatherLeaves(v);
		}
		if (child == null) {
			v.add(this);
	}	}

	// Used by ClusterInterface

	public void noEdges()
	{
		// Create a new source rel list so can continue to enumerate over this nodes children
		m_srcRelList    = new Vector();
		m_dstRelList.clear();	
		m_srcLiftedList.clear();
		m_dstLiftedList.clear();
	}

	// MouseListener interface

	public void mouseClicked(MouseEvent e)
	{
	}

	public void mouseEntered(MouseEvent e)
	{
	/*
	 	if (m_label.equals("code")) {
			System.out.println("EntityInstance.mouseEntered code " + getDiagramBounds());
			repaint();
		}
	*/
	}

	public void mouseExited(MouseEvent e)
	{
	}

	public void mousePressed(MouseEvent ev)
	{
		Diagram	diagram;
		int		x, y;

//		System.out.println("EntityInstance.mousePressed " + this);

		diagram = getDiagram();
		x       = ev.getX();
		y       = ev.getY();

		if (x       <= EntityComponent.CONTENTS_FLAG_X_RESERVE && 
		    y       <= EntityComponent.CONTENTS_FLAG_Y_RESERVE &&
		    x       >= EntityComponent.CONTENTS_FLAG_X &&
			y       >= EntityComponent.CONTENTS_FLAG_Y &&
			m_width  > EntityComponent.CONTENTS_FLAG_X_RESERVE &&
			m_height > EntityComponent.CONTENTS_FLAG_Y_RESERVE &&
			close_with_children_under_drawroot()) {
			LandscapeEditorCore	ls      = diagram.getLs();
			ls.processKey(Do.SHOW_CONTENTS, 0, this);
			return;
		}
		diagram.entityPressed(ev, this, ev.getX() + getDiagramX(), ev.getY() + getDiagramY());
	}

	public void mouseReleased(MouseEvent ev)
	{
		getDiagram().entityReleased(ev, this, ev.getX() + getDiagramX(), ev.getY() + getDiagramY());
	}

	// MouseMotionListener interface

	public void mouseDragged(MouseEvent ev)
	{
		getDiagram().entityDragged(ev, this, ev.getX() + getDiagramX(), ev.getY() + getDiagramY());
	}

	public void mouseMoved(MouseEvent ev)
	{
		Diagram				diagram = getDiagram();

		if (this != g_infoShown) {
			int	modifiers;

			LandscapeEditorCore	ls      = diagram.getLs();
			if (g_infoShown instanceof RelationInstance) {
				((RelationInstance) g_infoShown).repaint();
			}
		
			modifiers = ev.getModifiers();
			if ((modifiers & Event.SHIFT_MASK) == 0) {
				ls.infoShown(this);
			}

			String str = getEntityLabel();
			EntityInstance pe = getContainedBy();

			if (pe != null) {
				str = pe.getEntityLabel() + " . " + str /* + " " + getDiagramX() + "x" + getDiagramY() + " " + getX() + "X" + getY() */;
			} 
//			str += " " + getGroupFlag() + " " + getGroupKeyFlag();
			ls.showInfo(str);

			if (m_currentDescEntity != this && !isOpen() && getEntityClass() != null) {
				String label = getEntityLabel();
				String title = getTitle(); 
				String desc  = getDescription();

				if (desc == null) {
					desc = "The " + label + " " + getClassLabel() + ".";
				}

				String topline = " (" + getClassLabel() + (hasChildren() ? " - " + numChildren() + " items)" : ")" );

				if (title != null) {
					topline = title + topline;
				} else {
					topline = label + topline;
				}
				ls.setRightTextBox(topline, desc);
				m_currentDescEntity = this;
		}	}
		diagram.movedOverThing(ev, this, ev.getX() + getDiagramX(), ev.getY() + getDiagramY());
	}
}
