package lsedit;

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

import java.util.Enumeration;
import java.util.regex.Pattern;

import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class FindBox extends JDialog implements ActionListener
{
	protected JButton		m_findButton, m_canButton;
	protected JTextField	m_patternField;
	protected JComboBox		m_classes;
	protected JCheckBox		m_caseSensitive;

	protected static String	m_pattern = "";
	protected EntityClass	m_entityClass;

	public FindBox(JFrame f, Diagram diagram)
	{
		super(f, "Find Landscape Entities", true);

		JLabel		label;
		EntityClass	entityClass;
		Container	contentPane = getContentPane();
		Font		font, bold;
		Enumeration	e;

		m_entityClass = null;

		font          = FontCache.getDialogFont();
		bold          = font.deriveFont(Font.BOLD);

		// Create a dialog 

		contentPane.setLayout(new BorderLayout());

		setFont(font);

		label = new JLabel("Any java.util.regex.Pattern:");
		label.setFont(font);
		contentPane.add(label, BorderLayout.NORTH);

		JPanel p = new JPanel();
		p.setLayout(new BorderLayout());


		// Create input component and add it to the window

		m_patternField = new JTextField(m_pattern, 30);
		m_patternField.setFont(font);
		m_patternField.addActionListener(this);
		p.add(m_patternField, BorderLayout.NORTH);

		m_classes = new JComboBox();
		m_classes.addItem("");
		for (e = diagram.enumEntityClassesInOrder(); e.hasMoreElements(); ) { 
			entityClass = (EntityClass) e.nextElement();
			m_classes.addItem(entityClass);
		}
		p.add(m_classes, BorderLayout.CENTER);

		m_caseSensitive = new JCheckBox("Case sensitive");
		m_caseSensitive.setFont(bold);
		m_caseSensitive.setSelected(true);
		p.add(m_caseSensitive, BorderLayout.SOUTH);

		contentPane.add(p, BorderLayout.CENTER);

		p = new JPanel();
		p.setLayout(new FlowLayout());

		m_findButton = new JButton("Find");
		m_findButton.setFont(bold);
		p.add(m_findButton);
		m_findButton.addActionListener(this);

		m_canButton = new JButton("Cancel");
		m_canButton.setFont(bold);
		p.add(m_canButton);
		m_canButton.addActionListener(this);

		contentPane.add(p, BorderLayout.SOUTH);

		// Resize the window to the preferred size of its components

		this.pack();

		if (f != null) {	// ie. not an applet
			setLocation(f.getX()+200, f.getY()+300);
		}
		setVisible(true);
	}

	public Pattern pattern() 
	{
		Pattern pattern;
		int		flags;

		if (m_pattern == null || m_pattern.equals("") || m_pattern.equals("*")) {
			pattern = null;
		} else {
			try {
				if (m_caseSensitive.isSelected()) {
					flags = 0;
				} else {
					flags = Pattern.CASE_INSENSITIVE;
				}
				flags |= Pattern.DOTALL;
				
				pattern = Pattern.compile(m_pattern, flags);
			} catch (Exception e) {
				System.out.println("Syntax error is regular expression '" + m_pattern + "'");
				pattern = null;
		}	}
		return(pattern);
	}

	public EntityClass entityClass()
	{
		return m_entityClass;
	}

	// ActionListener interface

	public void actionPerformed(ActionEvent ev)
	{
		Object	source;

		// Pop down the window when the button is clicked.
		// System.out.println("event: " + ev);

		source = ev.getSource();

		if (source == m_patternField || source == m_findButton || source == m_canButton) {
			m_pattern = m_patternField.getText();
			if (source != m_canButton) {
				int	selected;

				selected  = m_classes.getSelectedIndex();
				if (selected > 0) {
					m_entityClass = (EntityClass) m_classes.getSelectedItem();
			}	}
			this.setVisible(false);
		}
		return;
	}
}

