package lsedit;

/*
* @(#)FontChooser.java   1.2 98/07/31
*/

import java.lang.Integer;

// import java.util.Vector;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

/*
 * This applet displays a String with the user's selected 
 * fontname, style and size attributes.
*/

public class FontChooser extends JDialog implements ItemListener, ActionListener {
 
	class FontPanel extends JPanel {

		public FontPanel()
		{ 
		}

		public Dimension getPreferredSize()
		{
			return (new Dimension(m_fontPanelWidth, m_fontPanelHeight));
		}

		public Dimension getMinimumSize()
		{
			return(getPreferredSize());
		}

		public Dimension getMaximumSize()
		{
			return(getPreferredSize());
		}

		public void paintComponent (Graphics g) 
		{
			super.paintComponent(g);

			g.setColor(Color.darkGray);
			g.setFont(m_font);

			String change = "Set " + m_targetname + " font " + m_fontname + " ";
			int	   width;

			if (m_style < 4) {
				change += m_stylenames[m_style+1];
			} else {
				change += "style " + m_style;
			}
			change += " size " + m_size;
			width   = FontChooser.this.getWidth();

			Util.drawStringWrapped(g, change, m_fontPanelXMargin, m_fontPanelYMargin, width - 2 * m_fontPanelXMargin, m_fontPanelHeight - m_fontPanelYMargin, true, false);
	}	}
	  
	private final static int	  m_fontPanelWidth   = 150;
	private final static int	  m_fontPanelHeight  = 100;
	private final static int	  m_fontPanelXMargin =   5;
	private final static int	  m_fontPanelYMargin =  10;

	public  final static int	  TARGET_ALL           = 0;
	public  final static int	  TARGET_CLOSED        = 1;
	public  final static int	  TARGET_OPEN          = 2;
	public  final static int	  TARGET_OPEN_CLASS    = 3;
	public  final static int	  TARGET_CLIENTS       = 4;
	public  final static int	  TARGET_CARDINALS     = 5;
	public  final static int	  TARGET_RESULTS_TITLE = 6;
	public  final static int	  TARGET_RESULTS_TEXT  = 7;
	public  final static int	  TARGET_LEGEND_TITLE  = 8;
	public  final static int      TARGET_LEGEND_TEXT   = 9;
	public  final static int	  TARGET_QUERY_TITLE   = 10;
	public  final static int	  TARGET_QUERY_TEXT    = 11;
	public  final static int	  TARGET_TOC           = 12;
	public  final static int	  TARGET_UNDO          = 13;
	public  final static int      TARGET_HISTORY       = 14;
	public  final static int      TARGET_MAP           = 15;
	public  final static int      TARGET_TITLE         = 16;
	public  final static int	  TARGET_TEXTBOX       = 17;
	public  final static int	  TARGET_FEEDBACK      = 18;
	public  final static int      TARGET_MENU          = 19;
	public  final static int	  TARGET_DIALOG        = 20;
	public	final static int	  TARGET_CLIPBOARD     = 21;
	public  final static int	  TARGET_ATTR_TITLE    = 22;
	public  final static int	  TARGET_ATTR_TEXT     = 23;
	public  final static int	  TARGET_LAST          = 23;

	private final static String[] m_targetnames = new String[]
								{
									"ALL FONTS",
									"CLOSED LABEL",
									"OPEN LABEL",
									"OPEN CLASS LABEL",
									"CLIENT/SUPPIER LABEL",
									"CARDINALS",
									"RESULTS TITLE",
									"RESULTS TEXT",
									"LEGEND TITLE",
									"LEGEND TEXT",
									"QUERY TITLE",
									"QUERY TEXT",
									"TOC",
									"UNDO",
									"HISTORY",
									"MAP",
									"TITLE",
									"TEXTBOX",
									"FEEDBACK",
									"MENU",
									"DIALOG",
									"CLIPBOARD",
									"ATTR BOX TITLE",
									"ATTR BOX TEXT"
								};

	private final static String[] m_targetDescription = new String[]
								{
									"***ALL***",
									"closed label",
									"small label",
									"open class label",
									"client/supplier",
									"cardinal",
									"results title",
									"results text",
									"legend title",
									"legend text",
									"query title",
									"query text",
									"TOC",
									"undo",
									"history",
									"map",
									"title",
									"text box",
									"feedback",
									"menu",
									"dialog",
									"clipboard",
									"attribute title",
									"attribute text"
								};
		

	private final static String[] m_stylenames = new String[] 
								{
									"DEFAULT",
									"PLAIN",
									"BOLD",
									"ITALIC",
									"BOLD & ITALIC"
								};

	private final static String[] m_sizenames = new String[]
								{	
									"DEFAULT", "4", "5", "6", "7", "8", "9", "10", "12", "14", "16", "18", "20", "22", "24", "26", "28", "30"
								};

	private static GraphicsEnvironment m_gEnv = null;
	private static String m_envfonts[]        = null;


	private LandscapeEditorCore	m_ls;

	private	int			m_target;
	private String		m_targetname;
	private Font		m_font;
	private String		m_fontname;
	private int			m_style;
    private	int			m_size;

	private boolean		m_name_default;
	private boolean		m_style_default;
	private boolean		m_size_default;

	private	FontPanel	m_fontPanel;
	private	JComboBox	m_targets, m_fonts, m_sizes, m_styles;
	private JButton		m_okButton, m_defaultButton, m_cancelButton, m_clearButton;

	protected void newFont(Font font)
	{
		m_font      = font;
		m_fontname  = font.getFamily();
		m_style     = font.getStyle();
		m_size      = font.getSize();
	}

	protected void newFont()
	{
		newFont(FontCache.get(m_fontname, m_style, m_size));
	}

	protected void setTarget(int index)
	{
		String	s;
		Font	font;
		int		i;

		font         = m_ls.getTargetFont(index);
		if (font == null) {
			return;
		}
	
		m_target     = index;
		m_targetname = m_targetDescription[index];
		newFont(font);

		m_targets.setSelectedIndex(index);

		m_name_default = true;
		for (i = 1; i < m_envfonts.length; i++ ) {
			if (m_fontname.equalsIgnoreCase(m_envfonts[i])) {
				m_fonts.setSelectedIndex(i);
				m_name_default = false;
				break;
		}	}
        
		if (m_name_default) {
			m_fonts.setSelectedIndex(0);
		}

		if (m_style < 4) {
			m_style_default = true;
			m_styles.setSelectedIndex(0);
		} else {
			m_style_default = false;	
			m_styles.setSelectedIndex(m_style+1);
		}

		s = "" + m_size;

		m_size_default = true;
		for (i = 1; i < m_sizenames.length; i++ ) {
			if (s.equals(m_sizenames[i])) {
				m_sizes.setSelectedIndex(i);
				m_size_default = false;
				break;
		}	}

		if (m_size_default) {
			m_sizes.setSelectedIndex(0);
	}	}

	public FontChooser(JFrame frame, LandscapeEditorCore ls)
	{
		super(frame, "Select font for target", true /* modal */);

		Container	contentPane;
		JLabel		label;
		Font		font, bold;
		int			i;

		m_ls        = ls;

		contentPane = getContentPane();
		font        = FontCache.getDialogFont();
		bold        = font.deriveFont(Font.BOLD);

        contentPane.setLayout( new BorderLayout() );

        JPanel topPanel          = new JPanel();
		JPanel targetPanel       = new JPanel();
        JPanel fontPanel         = new JPanel();
        JPanel sizePanel         = new JPanel();
        JPanel stylePanel        = new JPanel();
        JPanel sizeAndStylePanel = new JPanel();

        topPanel.setLayout( new BorderLayout() );

		targetPanel.setLayout( new GridLayout( 2, 1) );
        fontPanel.setLayout( new GridLayout( 2, 1 ) );
        sizePanel.setLayout( new GridLayout( 2, 1 ) );
        stylePanel.setLayout( new GridLayout( 2, 1 ) );
        
		sizeAndStylePanel.setLayout( new BorderLayout() );
        sizeAndStylePanel.add( BorderLayout.CENTER, stylePanel );
        sizeAndStylePanel.add( BorderLayout.EAST, sizePanel );

        topPanel.add( BorderLayout.WEST, targetPanel );
        topPanel.add( BorderLayout.CENTER, fontPanel );
        topPanel.add( BorderLayout.EAST, sizeAndStylePanel );

        contentPane.add( BorderLayout.NORTH, topPanel );

		{
			label = new JLabel();
			label.setText("Target");
			label.setFont(bold);
			label.setHorizontalAlignment(JLabel.CENTER);
			targetPanel.add(label);
		}

		{
			label = new JLabel();
			label.setText("Fonts");
			label.setFont(bold);
			label.setHorizontalAlignment(JLabel.CENTER);
			fontPanel.add(label);
		}

		{
			label = new JLabel();
			label.setText("Styles");
			label.setFont(bold);
			label.setHorizontalAlignment(JLabel.CENTER);
			stylePanel.add(label);
		}

		{
			label = new JLabel();
			label.setText("Sizes");
			label.setFont(bold);
			label.setHorizontalAlignment(JLabel.CENTER);
			sizePanel.add(label);
		}



		{
			m_targets = new JComboBox(m_targetnames);
			m_targetname = "target";

			m_targets.setFont(bold);
			m_targets.setSelectedIndex(0);
			m_targets.setMaximumRowCount( 9 );
			m_targets.addItemListener(this);
			targetPanel.add(m_targets);
		}

		{

			if (m_gEnv == null) {
				m_gEnv = GraphicsEnvironment.getLocalGraphicsEnvironment();
			}
			if (m_envfonts == null) {
				String	augmented[];

				m_envfonts = m_gEnv.getAvailableFontFamilyNames();
				i = m_envfonts.length;
				augmented = new String[i+1];
				for (; i > 0; --i) {
					augmented[i] = m_envfonts[i-1];
				}
				augmented[0] = "DEFAULT";
				m_envfonts   = augmented;
			}

			m_fonts = new JComboBox(m_envfonts);
			m_fonts.setFont(bold);
			m_fonts.setMaximumRowCount( 9 );
			m_fonts.addItemListener(this);
     		fontPanel.add(m_fonts);
		}

		{
			m_styles = new JComboBox( m_stylenames );
			m_styles.setFont(bold);
			m_styles.setMaximumRowCount( 9 );
			m_styles.addItemListener(this);
			stylePanel.add(m_styles);
		}

		{
			m_sizes = new JComboBox(m_sizenames);
			m_sizes.setFont(bold);
			m_sizes.setMaximumRowCount( 9 );
			m_sizes.addItemListener(this);
			sizePanel.add(m_sizes);
		}

        {
			m_fontPanel = new FontPanel();
			m_fontPanel.setBackground(Color.white);
			contentPane.add( BorderLayout.CENTER, m_fontPanel);
		}

		// Create an Okay button in a Panel; add the Panel to the window

		// Use a FlowLayout to center the button and give it margins.

		{
			JPanel bottomPanel = new JPanel();

			bottomPanel.setLayout(new FlowLayout(FlowLayout.CENTER, 15, 15));

			m_okButton = new JButton("OK");
			m_okButton.setFont(bold);
			m_okButton.addActionListener(this);
			bottomPanel.add(m_okButton);

			m_defaultButton = new JButton("Default");
			m_defaultButton.setFont(bold);
			m_defaultButton.addActionListener(this);
			bottomPanel.add(m_defaultButton);

			m_clearButton = new JButton("Clear Cache");
			m_clearButton.setFont(bold);
			m_clearButton.addActionListener(this);
			bottomPanel.add(m_clearButton);

			m_cancelButton = new JButton("Cancel");
			m_cancelButton.setFont(bold);
			m_cancelButton.addActionListener(this);
			bottomPanel.add(m_cancelButton);

			contentPane.add( BorderLayout.SOUTH, bottomPanel);
		}

		setLocation(20, 20);
		m_name_default  = false;
		m_style_default = false;
		m_size_default  = false;
		setTarget(0);
		
		// Resize the window to the preferred size of its components
		pack();
		setVisible(true);
    }

	public Font getFontChoice()
	{
		return (m_font);
	}

/*
 * ItemListener interface

 * Detects a state change in any of the Lists.  Resets the variable corresponding
 * to the selected item in a particular List.  Invokes changeFont with the currently
 * selected fontname, style and size attributes.
*/
    public void itemStateChanged(ItemEvent e) 
	{
        if ( e.getStateChange() == ItemEvent.SELECTED ) {

			Object	list  = e.getSource();
			int		index;

			if ( list == m_targets) {
				index = m_targets.getSelectedIndex();
				setTarget(index);
			} else {
				if ( list == m_fonts ) {
					index = m_fonts.getSelectedIndex();
					if (index == 0) {
						m_name_default = true;
						m_fontname     = m_ls.getDefaultFontName(m_target);
					} else {
						m_name_default = false;
						m_fontname     = (String) m_fonts.getSelectedItem();
					}
				} else if ( list == m_styles ) {
					index = m_styles.getSelectedIndex();
					if (index == 0) {
						m_style_default = true;
						m_style         = m_ls.getDefaultFontStyle(m_target);
					} else {
						m_style_default = false;
						m_style         = --index;
					}
				} else {
					index = m_sizes.getSelectedIndex();
					if (index == 0) {
						m_size_default  = true;
						m_size          = m_ls.getDefaultFontSize(m_target);
					} else { 
						String  sizename = (String) m_sizes.getSelectedItem();
						Integer newSize  = new Integer(sizename);
						m_size           = newSize.intValue();
						m_size_default   = false;
				}	}
				newFont();
			}
			m_fontPanel.repaint();
		}
    }

/* ActionListener interface */

	public void actionPerformed(ActionEvent e)
	{
		Object source = e.getSource();

		if (source == m_defaultButton) {
			m_targets.setSelectedIndex(0);
			m_fonts.setSelectedIndex(0);
			m_sizes.setSelectedIndex(0);
			m_styles.setSelectedIndex(0);
			return;
		}

		if (source != m_cancelButton) {
			if (source == m_clearButton) {
				int	cnt = FontCache.size();
				FontCache.clear();
				JOptionPane.showMessageDialog(this, cnt + " fonts have been removed from the cache");
				return;
			}
			if (source != m_okButton) {
				return;
			}
			m_ls.setTargetFont(m_target, m_font, m_name_default, m_style_default, m_size_default);
		}
		setVisible(false);
	}
}



