package lsedit;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.Vector;

import javax.swing.JComponent;

/* This handler is responsible for selecting things by dragging a box over them
 */

public class FrameModeHandler extends LandscapeModeHandler
{

	// A small JComponent so that the whole handler doesn't need to be one
	// This object just draws the outline of the thing(s) being moved

	protected class DrawOutline extends JComponent
	{
		public DrawOutline()
		{
			super();
			setForeground(Color.GREEN);
		}

		public void paintComponent(Graphics g)
		{
			int	x, y, width, height;

			x     = m_start_x;
			width = m_end_x - x;
			if (width == 0) {
				return;
			}
			y      = m_start_y;
			height = m_end_y - y;
			if (height == 0) {
				return;
			}
			if (width < 0) {
				x      = m_end_x;
				width  = -width;
			}
			if (height < 0) {
				y      = m_end_y;
				height = -height;
			}
			g.drawRect(x, y, width, height);

	}	}

	protected Diagram			m_diagram = null;		
	protected DrawOutline		m_drawOutline = null;				// The outline drawn

	protected boolean			m_shift_down;
	protected boolean			m_control_down;
	protected int				m_start_x, m_start_y;
	protected int				m_end_x,   m_end_y;
	protected EditModeHandler	m_parent;

	//
	// Public methods
	//

	public FrameModeHandler(EditModeHandler parent) 
	{
		super(parent.m_ls);
		m_parent      = parent;
		m_drawOutline = new DrawOutline();
	}

	public void cleanup()
	{
		if (m_diagram != null) {
			m_drawOutline.setVisible(false);
			m_diagram.remove(m_drawOutline);
			m_diagram = null;
			m_ls.setCursor(Cursor.DEFAULT_CURSOR);
	}	}

	public void entityPressed(MouseEvent ev, EntityInstance drawRoot, int x, int y) 
	{
		Diagram	diagram;

		m_diagram = diagram = m_ls.getDiagram();

		m_shift_down   = ev.isShiftDown();
		m_control_down = ev.isControlDown();

//		System.out.println("FrameModeHandler mousedown drawRoot=" + drawRoot + " x=" + x + " y=" + y);

		m_end_x = m_start_x  =  x;
		m_end_y = m_start_y  =  y;

		m_drawOutline.setBounds(0, 0, diagram.getWidth(), diagram.getHeight());
		m_drawOutline.setVisible(true);
		diagram.add(m_drawOutline /* JLayeredPane.PALETTE_LAYER */ , 0);
 
		m_parent.setSubHandler(this);
	}

	public void entityDragged(MouseEvent ev, EntityInstance drawRoot, int x, int y) 
	{
//		System.out.println("FrameModeHandler.entityDragged() drawRoot=" + drawRoot + " x=" + x + " y=" + y);

		m_end_x = x;
		m_end_y = y;
		m_drawOutline.repaint();
	}

	public void entityReleased(MouseEvent ev, EntityInstance drawRoot, int x, int y) 
	{
		Diagram diagram = m_diagram;

		if (diagram != null) {
			int					frameX, frameY, frameWidth, frameHeight;
			Enumeration			en;
			EntityInstance		e, keyEntity, newKeyEntity;
			boolean				change;

			frameX      = m_start_x;
			frameWidth  = m_end_x - frameX;
			frameY      = m_start_y;
			frameHeight = m_end_y - frameY;
			if (frameWidth < 0) {
				frameX      = m_end_x;
				frameWidth  = -frameWidth;
			}
			if (frameHeight < 0) {
				frameY      = m_end_y;
				frameHeight = -frameHeight;
			}

			if (frameWidth == 0 || frameHeight == 0) {
				if (!m_shift_down) {
					// Added 7.1.10 -- rather dubious in my opinion
					diagram.clearFlags();
				}
			} else {
				change       = false;
				newKeyEntity = null;

				if (m_control_down) {
					// Clear the groupings
					for (en = drawRoot.getChildren(); en.hasMoreElements(); ) {
						e = (EntityInstance) en.nextElement();
						if (e.isFramedBy(frameX, frameY, frameWidth, frameHeight)) {
							if (e.getGroupKeyFlag()) {
								newKeyEntity = e;
								e.clearGroupKeyFlag();
								diagram.clearKeyEntity();
							} else {
								if (e.getGroupFlag()) {
									e.clearGroupFlag();
					}	}	}	}
					if (newKeyEntity != null) {
						Vector v = diagram.getGroup();
						if (v != null) {
							diagram.setKeyEntity((EntityInstance) v.elementAt(0));
					}	}
				} else {
					keyEntity    = m_diagram.getKeyEntity();

					if (m_shift_down) {
						newKeyEntity = keyEntity;
					} else {
						if (keyEntity != null) {
							if (keyEntity.getContainedBy() == drawRoot) {
								if (keyEntity.isFramedBy(frameX, frameY, frameWidth, frameHeight)) {
									newKeyEntity = keyEntity;
					}	}	}	}

					if (!m_shift_down) {
						diagram.clearFlags();
					}

					for (en = drawRoot.getChildren(); en.hasMoreElements(); ) {
						e = (EntityInstance) en.nextElement();
						if (e.isFramedBy(frameX, frameY, frameWidth, frameHeight)) {
							if (!change) {
								if (newKeyEntity == null) {
									newKeyEntity = e;
								}
								change = true;
							}
							if (e == newKeyEntity) {
								if (!e.getGroupKeyFlag()) {
									diagram.setKeyEntity(e);
								}
							} else {
								if (!e.getGroupFlag()) {
									e.setGroupFlag();
				}	}	}	}	}
				if (change) {
					diagram.setPreserveEntityMarks(EntityInstance.GROUP_MARK | EntityInstance.GROUPKEY_MARK);
					diagram.setPreserveRelationMarks(0);
					m_ls.show_groupList();
				}
		}	}
		m_parent.cleanup();
	}

	public void relationPressed(MouseEvent ev, RelationInstance ri, int x, int y)
	{
		ri.setGroupAndHighlightFlag();
		m_parent.cleanup();
	}
}
