package lsedit;

import java.awt.Color;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

import javax.swing.undo.UndoableEdit;

public abstract class LandscapeClassObject extends LandscapeObject3D /* extends LandscapeObject extends JComponent */ {

	private Vector m_inherits = new Vector();							// Set of class's this class inherits from

	protected static final String CLASSLABEL_ID = "class_label";
	protected static final String CLASSSTYLE_ID = "class_style";
	protected static final String CLASSDESC_ID	= "class_description";

	private int					m_nid = -1;		// Used to output things in order entered
	private Diagram				m_dg;			// Diagram which contains it
	private Ta					m_ta;


	public LandscapeClassObject(Ta ta)
	{
		m_ta = ta;
		m_dg = ta.getDiagram();
	}

	public Enumeration getParentElements() 
	{
		return m_inherits.elements();
	}

	public int	getParentCnt()
	{
		return m_inherits.size();
	}

	public Vector getInherits()
	{
		return m_inherits;
	}

	public void setInherits(Vector inherits)
	{
		m_inherits = inherits;
		if (m_dg != null) {
			m_dg.getLs().repaint();
	}	}

	class SetInherits extends MyUndoableEdit implements UndoableEdit
	{
		Vector               m_old;
		Vector               m_new;

		SetInherits(Vector old)
		{
			m_old = old;
			m_new = getInherits();

			logEdit(this);
		}

		public String getPresentationName() 
		{
			return getLabel() + " inheritance";
		}

		public void undo()
		{
			setInherits(m_old);
		}

		public void redo()
		{
			setInherits(m_new);
	}	}

	public void updateInherits(Vector newv)
	{
		Vector oldv   = getInherits();

		if (oldv.size() != newv.size() || !newv.containsAll(oldv)) {
			setInherits(newv);
			if (undoEnabled()) {
				new SetInherits(oldv);
	}	}	}


	public boolean directlyInheritsFrom(Object thing)
	{
		return m_inherits.contains(thing);
	}

	public boolean subclassOf(LandscapeClassObject lco)
	{
		Enumeration				en;
		LandscapeClassObject	parent;

		for (en = getParentElements(); en.hasMoreElements(); ) {
			parent = (LandscapeClassObject) en.nextElement();
			if (parent == lco || parent.subclassOf(lco)) {
				return true;
		}	}
		return false;
	}

	// Get the set of classes that are this class or a subclass of it

	public Vector getClassAndSubclasses(Hashtable classes)
	{
		Vector				 v = new Vector();
		Vector				 inherits;
		LandscapeClassObject o;
		int					 i, size;
		boolean				 seen;
		Enumeration			 en;

		v.add(this);
		do {
			seen = false;
			for (en = classes.elements(); en.hasMoreElements();) {
				o = (LandscapeClassObject) en.nextElement();
				if (!v.contains(o)) {
					inherits = o.getInherits();
					size     = inherits.size();
					for (i = 0; i < size; ++i) {
						if (v.contains(inherits.elementAt(i))) {
							v.add(o);
							seen = true;
							break;
			}	}	}	}
		} while (seen);

		return v;
	}
	
	// This will return a vector in which nearer superclasses occur earlier than more distant ones

	public Vector getClassAndSuperclasses()
	{
		Vector				 v = new Vector();
		Vector				 inherits;
		LandscapeClassObject o, o1;
		int					 i, j, size;
		boolean				 seen;

		v.add(this);
		do {
			seen = false;
			for (i = 0; i < v.size(); ++i) {
				o        = (LandscapeClassObject) v.elementAt(i);
				inherits = o.getInherits();
				for (j = 0; j < inherits.size(); ++j) {
					o1 = (LandscapeClassObject) inherits.elementAt(j);
					if (!v.contains(o1)) {
						v.add(o1);
						seen = true;
			}	}	}
		} while (seen);

		return v;
	}
		
	public Vector getValidAttributes()
	{
		Vector	v1   = getClassAndSuperclasses();
		int		size = v1.size();
		Vector	v    = new Vector();
		LandscapeClassObject o;
		Enumeration	en;
		Attribute attribute, attribute1;
		String	id;
		int		i, j;

		for (i = 0; i < size; ++i) {
			o = (LandscapeClassObject) v1.elementAt(i);
			en = o.getLsAttributesEnum();
			if (en != null) {
				for (; en.hasMoreElements(); ) {
					attribute = (Attribute) en.nextElement();
					id        = attribute.id;
					for (j = v.size(); ; ) {
						if (--j < 0) {
							v.add(attribute);
							break;
						}
						attribute1 = (Attribute) v.elementAt(j);
						if (id.equals(attribute1.id)) {
							break;
		}	}	}	}	}
		return v;
	}

	public String addParentClass(LandscapeClassObject lco) 
	{
		int	i;
		LandscapeClassObject	o;

		if (lco == null) {
			return ("Can't inherit from null class");
		}

		// I already inherit from lco or some subclass of lco
		// then don't add lco to the things I inherit from

		if (subclassOf(lco)) {
			return ("Already inherits from " + lco.getId());	   
		}

		// If what I am adding is itself a subclass of something
		// I inherit from then remove those somethings.

		for (i = m_inherits.size(); --i >= 0; ) {
			o = (LandscapeClassObject) m_inherits.elementAt(i);
			if (lco.subclassOf(o)) {
				m_inherits.remove(i);
		}	}

		m_inherits.addElement(lco);
		return null;
	}

	protected boolean processClassAttributes(Attribute attr) 
	{
		if (attr.avi != null) {

			if (attr.id.equals(CLASSLABEL_ID)) {
				setLabel(attr.avi.value);
				return true;
			}
			if (attr.id.equals(CLASSSTYLE_ID)) {
				setStyle(Util.parseInt(attr.avi.value));
				return true;
			}
			if (attr.id.equals(CLASSDESC_ID)) {
				setDescription(attr.avi.value);
				return true;
			} 
		}
		return false;
	}

	public void reportClassAttributes(ResultBox resultBox)
	{
		resultBox.addText(CLASSLABEL_ID);
		resultBox.addText(CLASSSTYLE_ID);
		resultBox.addText(CLASSDESC_ID);
		resultBox.addText(COLOR_ID);
		resultBox.addText(LABEL_COLOR_ID);
		resultBox.addText(OPEN_COLOR_ID);
	}

	// --------------

	// Public methods

	// --------------

	public Ta getTa()
	{
		return m_ta;
	}

	public Diagram getDiagram()
	{
		return m_dg;
	}

 	public int getNid() 
	{
		return m_nid;
	}

	public void setNid(int nid) 
	{
		this.m_nid = nid;
	}

	public String getLabelId()
	{
		return  "(" + m_nid + ") " + getLabel();
	}

	public LandscapeClassObject derivedFrom(int i)
	{
		return((i < m_inherits.size()) ? (LandscapeClassObject) m_inherits.elementAt(i) : null);
	}

	// If a new attribute, add it to the attribute database,
	// otherwise merely update the value.

	public void addAttribute(Attribute attr) {

		if (attr.avi != null && attr.id.startsWith("class_")) {
			if (processClassAttributes(attr)) {
				return;
		}	}

		if (processFirstOrder(attr)) {
			return;
		}

		Attribute curAttr = getLsAttribute(attr.id);

		if (curAttr == null) {
			// New attribute
			putLsAttribute(attr);
			attr.m_cloneOnAssign = true;
		} else if (attr.avi != null) {
			// Simply change the value if value present
			curAttr.avi = attr.avi; 
		}
	}

	// Return the attribute with the associated id
	/* This logic is flawed -- it won't find the attribute in the
	 * nearest ancestor -- only the ancestor in the nearest leftmost ancestor
	 * IJD
	 */

	public Attribute getLsAttribute(String id) 
	{
		Attribute attr = (Attribute) super.getLsAttribute(id);

		if (attr != null) {
			return attr;
		}

		Enumeration			 en;
		LandscapeClassObject lco;

		for (en = getParentElements(); en.hasMoreElements(); ) {
			lco = (LandscapeClassObject) en.nextElement();
			attr = lco.getLsAttribute(id);
			if (attr != null) {
				return attr;
		}	}
		return null;
	}

	public void writeAttributes(PrintStream ps) throws IOException {

		super.writeAttributes(ps, null, true);
	
		String label = getLabel();

		if (!getId().equals(label)) {
			ps.print(Attribute.indent + CLASSLABEL_ID + " = " + qt(label) + "\n");
		}

		int style = getStyle();

		if (style >= 0) {
			ps.print(Attribute.indent + CLASSSTYLE_ID + " = " + style + "\n");
		}

		String description = getDescription();

		if (description != null) {
			ps.print(Attribute.indent + CLASSDESC_ID + " = " + AttributeValueItem.qt(description) + "\n");
		}
	}

	public void setColor(Color c) {

		Attribute attr = getLsAttribute(EntityInstance.COLOR_ID);

		double r = ((double) c.getRed())/255;
		double g = ((double) c.getGreen())/255;
		double b = ((double) c.getBlue())/255;

		attr.avi.value			 = "" + r;
		attr.avi.next.value		 = "" + g;
		attr.avi.next.next.value = "" + b;
	}
}

