package lsedit;

import java.applet.AppletContext;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import java.io.File;
import java.io.FileReader;
import java.io.BufferedReader;
import java.io.FileWriter;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;

import java.util.Enumeration;
import java.util.Vector;
import java.util.regex.Pattern;

import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.JViewport;
import javax.swing.MenuElement;
import javax.swing.undo.UndoableEdit;

class DefaultBrowserButton extends JButton implements ActionListener {

	protected JFileChooser		m_fileChooser;
	protected File				m_defaultFile;
	
	public DefaultBrowserButton(JFileChooser fileChooser, String os, File defaultFile)
	{
		super("default");
		setToolTipText(os + " default");
		m_fileChooser = fileChooser;
		m_defaultFile = defaultFile;
		addActionListener(this);
	}

	// ActionListener interface

	public void actionPerformed(ActionEvent ev)
	{
		if (ev.getSource() == this) {
			m_fileChooser.setSelectedFile(m_defaultFile);
}	}	}

public class LandscapeEditorCore extends Do /* extends JPanel */ implements TaListener, TaFeedback, ToolBarEventHandler
{
	protected final static int GRID_MAX			 = 100;

	protected final static int GAP               = 4;		// Gap between GUI objects

	protected final static String TITLE = "Software Landscape Editor";

	protected final static int FA_LOAD       = 0;
	protected final static int FA_SAVE		 = FA_LOAD+1;


	protected EditModeHandler m_editModeHandler;

	protected JMenuBar	m_menuBar;
	protected JMenu		m_fileMenu;
	protected JMenu		m_windowsMenu;

	/* Parameters */

	public	  String m_aboutURL    = "http://swag.uwaterloo.ca";
	public	  String m_helpURL     = "http://swag.uwaterloo.ca/lsedit";
	public    String m_startEntity = null;
	public    String m_lsPath      = null;

	protected JFrame        m_frame        = null;
	protected JApplet		m_applet       = null;	
	protected URL			m_documentBase = null;
	protected AppletContext m_ac           = null; 



	protected static final String m_leftTextBoxHelp  = "Displays the 'description' for the current landscape.";
	protected static final String m_rightTextBoxHelp = "Displays the 'description' for the closed (not a container) entity currently under the mouse cursor.";
	protected static final String m_feedbackHelp     = "Displays feedback from the program. Examples include errors, warnings, and confirmations of action.";
	protected static final String m_nameBoxHelp      = "Displays the landscape entity, edge, or application button/box currently under the mouse cursor.";

	protected static double m_mainSplitRatio   = 0.80;
	protected static double m_secondSplitRatio = 0.1;
	protected static double m_thirdSplitRatio  = 0.5;
	protected static String	m_browser          = null;

	// Frame contained in

	protected static int m_openFrames = 1;	// Number of open frames

	// Content pane

	protected Container			m_contentPane;

	// GUI compontents

	protected JToolBar			m_toolBar	         = null;

	protected MySplitPane		m_thirdSplitPane	 = null;	// Left and right diagnostic area
	protected JSplitPane		m_secondSplitPane    = null;	// Diagram below
	protected JSplitPane		m_mainSplitPane      = null;	// Tab box on right
	protected JScrollPane		m_scrollLeftTextBox  = null;		

	protected JPanel			m_leftPanel          = null;
	protected JPanel			m_rightPanel         = null;

	protected JLabel			m_leftTextBoxTitle   = null;
	protected TextBox			m_leftTextBox        = null;
	protected JScrollPane		m_scrollRightTextBox = null;
	protected JLabel			m_rightTextBoxTitle  = null;
	protected TextBox			m_rightTextBox       = null;
	protected Feedback			m_feedback           = null;
	protected Feedback			m_nameBox            = null; 

	public    JScrollPane		m_scrollDiagram      = null;
	protected Diagram			m_diagram            = null;		// Active diagram 

	protected RightTabbedPane	m_rightTabbedPane    = null;		// The right panel of the view
	protected LegendBox			m_legendBox          = null;
	protected MapBox			m_mapBox             = null;
	protected QueryBox			m_queryBox           = null;
	protected ResultBox			m_resultBox          = null;
	protected TextTree			m_tocBox             = null;
	protected UndoBox			m_undoBox            = null;
	protected HistoryBox		m_historyBox         = null;
	protected ClipboardBox		m_clipboardBox       = null;
	protected AttributeBox		m_attributeBox       = null;


	protected EntityInstance	m_currentNameEntity = null;

	/* Parameters */

	protected String lsSavePath, lsSaveSuffix, lsSaveCmd;	// Not used by viewer

	protected int mode = 0;

	protected boolean modeHandlingActive = false;

	protected RelationInstance	m_currentEdge       = null;
	protected EntityInstance	m_currentDescEntity = null;

	protected Find				m_findResults       = null;

	private int m_curCursor        = Cursor.DEFAULT_CURSOR;

	protected void setApplet(JApplet applet) 
	{
		m_applet = applet;
	}
		
	public boolean isApplet() 
	{
		return (m_applet != null);
	}

	public boolean isAddToClipboard()
	{
		return m_clipboardBox.isAddToClipboard();
	}

	public LandscapeEditorCore(JFrame frame)
	{
		m_frame       = frame;
		m_contentPane = frame.getContentPane();
	}

	public LandscapeEditorCore(JApplet applet)
	{
		setApplet(applet);
		m_documentBase = applet.getDocumentBase();
		m_contentPane  = applet.getContentPane();
	}

	public String getTitle() 
	{
		return TITLE;
	}

	public EditModeHandler getModeHandler()
	{
		return m_editModeHandler;
	}

	protected void repaintTabs() 
	{
		if (m_rightTabbedPane != null) {
			m_rightTabbedPane.revalidate();
		}
	}

	protected static String canonicalPath(String lseditFile)
	{
		File	file;
		String	path;

		try {
			file = new File(lseditFile);
			path = file.getCanonicalPath();
		} catch (Exception e) {
			path = lseditFile;
		}
		return(path);
	}

	protected String defaultIniFile()
	{
		String	os = Version.Detail("os.name");
		String	file;

		if (os != null && os.startsWith("Windows")) {
			file = "lsedit.ini";
		} else {
			file = ".lsedit";
		}
		return file;
	}

	protected String defaultIniDir()
	{
		return Version.Detail("user.home");
	}

	protected String defaultIniPath()
	{
		return defaultIniDir() + Version.Detail("file.separator") + defaultIniFile() ;
	}

	protected void loadLseditHistory(JMenu m, String file)
	{
		String				userHome;
		FileReader			fileReader;
		BufferedReader		bufferedReader;
		String				line;
		LandscapeLayouter	layouter;
		int					i;

		userHome = defaultIniDir();
		if (userHome == null || userHome == "") {
			System.out.println("Can't load state: Unknown home directory");
			return;
		}
//		System.out.println(userHome);

		try {
			if (file == null) {
				file = defaultIniPath();
			}
			if (file == null || file == "") {
				System.out.println("Can't load state: no filename"); 
				return;
			}
			System.out.println("Load state from " + file);

			fileReader     = new FileReader(file);
			bufferedReader = new BufferedReader(fileReader);

			while ((line = bufferedReader.readLine()) != null) {
//				System.out.println(line);
				if (line.startsWith("menu=")) {
					addLseditHistory(line.substring(5));
					continue;
				}
				if (line.startsWith("font=")) {
					loadSavedFont(line);
					continue;
				}
				if (line.startsWith("browser=")) {
					m_browser = line.substring(8);
					continue;
				}
				if (line.startsWith("option:")) {
					load(line);
					continue;
				}
				if (line.startsWith("arrow:")) {
					ArrowDimensions.load(line);
					continue;
				}

				for (i = 0; i < m_layouters.length; ++i) {
					layouter = m_layouters[i];
					if (line.startsWith(layouter.getTag())) {
						layouter.load(line);
						break;
				}	}
			}
			bufferedReader.close();
		} catch (Exception e) {
			System.out.println("Exception reading " + file + ": " + e);
		}
	}
	
	protected void addLseditHistory(String lseditPath)
	{
		int			i, cnt;
		String		path;
		JMenuItem	item;

		path = canonicalPath(lseditPath);
		cnt  = m_fileMenu.getItemCount();
		for (i = 0; i < cnt; ++i) {
			item = m_fileMenu.getItem(i);
			if (item instanceof MyHistoryMenuItem) {
				if (((MyHistoryMenuItem) item).isPath(path)) {
					return;
		}	}	}
		new MyHistoryMenuItem(m_fileMenu, path, this);
//		System.out.println("LandscapeEditorCore.addLseditHistory");
	}

	public void saveLseditHistory()
	{
		if (isApplet()) {
			// Can't invoke System.getProperty("user.home") 
			return;
		}
		int					i, cnt;
		JMenuItem			item;

		String				userHome, path, filename;
		FileWriter			fileWriter;
		BufferedWriter		bufferedWriter;
		String				browser;
		String				file = "";
		LandscapeLayouter	layouter;

		try {
			userHome       = defaultIniDir();

			if (userHome == null) {
				System.out.println("Can't save state: don't know location of $HOME");
			} else {
				file = defaultIniPath();
				System.out.println("Saving state in " + file);

				fileWriter     = new FileWriter(file);
				bufferedWriter = new BufferedWriter(fileWriter);

				cnt = m_fileMenu.getItemCount();
				for (i = 0; i < cnt; ++i) {
					item = m_fileMenu.getItem(i);
					if (item instanceof MyHistoryMenuItem) {
						path = ((MyHistoryMenuItem) item).getPath();
						bufferedWriter.write("menu=", 0, 5);
						bufferedWriter.write(path, 0, path.length());
						bufferedWriter.newLine();
				}	}
				saveFonts(bufferedWriter);
				browser = m_browser;
				if (browser != null) {
					bufferedWriter.write("browser=", 0, 8);
					bufferedWriter.write(browser, 0, browser.length());
					bufferedWriter.newLine();
				}

				save(bufferedWriter);
				ArrowDimensions.save(bufferedWriter);

				for (i = 0; i < m_layouters.length; ++i) {
					layouter = m_layouters[i];
					layouter.save(bufferedWriter);
				}
				bufferedWriter.close();
			}
		} catch (Exception e) {
			System.out.println("Exception  " + e + " caught when attempting to save history in " + file);
		}
	}
		
	public void removeHistoryMenu(MyHistoryMenuItem item)
	{
		m_fileMenu.remove(item);
	}

	public void removeHistory()
	{
		int			i, cnt;
		JMenuItem	item;

		cnt = m_fileMenu.getItemCount();
		for (i = cnt; i > 0; ) {
			item = m_fileMenu.getItem(--i);
			if (item instanceof MyHistoryMenuItem) {
				removeHistoryMenu((MyHistoryMenuItem) item);
	}	}	}

	protected void rememberDiagram(Diagram newDg, String path)
	{
		if (path != null) {
			int			i, cnt;
			JMenuItem	item;

			cnt  = m_windowsMenu.getItemCount();
			for (i = 0; i < cnt; ++i) {
				item = m_windowsMenu.getItem(i);
				if (item instanceof MyWindowsMenuItem) {
					if ( ((MyWindowsMenuItem) item).isDiagram(newDg) ) {
						return;
			}	}	}

			new MyWindowsMenuItem(m_windowsMenu, newDg, path, this);
		}
	}

	protected void changeDiagramPath(String path)
	{
		int			i, cnt;
		JMenuItem	item;

		cnt  = m_windowsMenu.getItemCount();
		for (i = 0; i < cnt; ++i) {
			item = m_windowsMenu.getItem(i);
			if (item instanceof MyWindowsMenuItem) {
				if ( ((MyWindowsMenuItem) item).isDiagram(m_diagram) ) {
					((MyWindowsMenuItem) item).setPath(path);
					return;
	}	}	}	}

	protected void activeDiagram(Diagram diagram)
	{
		int			i, cnt;
		JMenuItem	item;

		cnt  = m_windowsMenu.getItemCount();
		for (i = 0; i < cnt; ++i) {
			item = m_windowsMenu.getItem(i);
			if (item instanceof MyWindowsMenuItem) {
				((MyWindowsMenuItem) item).activeDiagram(diagram);
	}	}	}

	protected Diagram getOpenDiagram(String path)
	{
		int			i, cnt;
		JMenuItem	item;

		cnt  = m_windowsMenu.getItemCount();
		for (i = 0; i < cnt; ++i) {
			item = m_windowsMenu.getItem(i);
			if (item instanceof MyWindowsMenuItem) {
				Diagram diagram = ((MyWindowsMenuItem) item).getDiagram(path);
				if (diagram != null) {
					return diagram;
		}	}	}
		return null;
	}

	protected Diagram newDiagram()
	{
		return new Diagram(this);
	}

	protected void showDescription(RelationInstance ri, boolean showOpens)
	{
		if (ri != m_currentEdge) {
			EntityInstance	src, dst;
			String			info;

			m_currentEdge      = ri;
			m_currentNameEntity= null;
			src                = ri.m_drawSrc;
			dst                = ri.m_drawDst;
			if (src == null) {
				info = "??null??";
			} else {
				info = Util.quoted(src.getEntityLabel());
			}
			info += " " + ri.getClassLabel() + " ";
			if (dst == null) {
				info += "??null??";
			} else {
				info += Util.quoted(dst.getEntityLabel());
			}
			showInfo(info);
		} 
	}

	protected void showDescription(EntityInstance e, boolean showOpens)
	{
		if (e != m_currentNameEntity) {
			m_currentNameEntity = e;
			m_currentEdge       = null;
			String str;

			if (e == null) {
				str = "";
			} else {
				EntityInstance pe = e.getContainedBy();
				if (pe != null) {
					str = pe.getEntityLabel() + " . " + e.getEntityLabel();
				} else {
					str = e.getEntityLabel();
				}
			}
			showInfo(str);
		}
		if (e != null) {

			if (m_currentDescEntity != e && (!e.isOpen() || showOpens) &&	e.getEntityClass() != null)	{
				String label = e.getEntityLabel();
				String title = e.getTitle(); 
				String desc = e.getDescription();

				if (desc == null) {
					desc = "The " + label + " " + e.getClassLabel() + ".";
				}
				String topline = " (" + e.getClassLabel() + (e.hasChildren() ? " - " + e.numChildren() + " items)" : ")" );
				if (title != null) {
					topline = title + topline;
				} else {
					topline = label + topline;
				}
				m_rightTextBoxTitle.setText(topline);
				m_rightTextBox.set(desc);
				m_currentDescEntity = e;
		}	}
	}	
	public JMenuBar genMenu() 
	{ 
		JMenuBar			menuBar;
		JMenu				m;

		m_menuBar = menuBar = new JMenuBar();

		// Build File Menu

		m_fileMenu = m = new JMenu("File");
		fileMenuItem(m, this);
		if (!isApplet()) {
			Do.fileCloseMenuItem(m, this);
		}
		m.addSeparator();
		loadLseditHistory(m, null);
		menuBar.add(m);

		m = new JMenu("Edit");
		editMenuItem(m, this);
		menuBar.add(m);

		m = new JMenu("Layout");
		layoutMenuItem(m, this);
		menuBar.add(m);

		m = new JMenu("Explore");
		exploreMenuItem(m, this);
		menuBar.add(m);

		m = new JMenu("Options");
		optionsMenuItem(m, this);
		menuBar.add(m);

		m_windowsMenu = m = new JMenu("Windows");
		menuBar.add(m);

		m = new JMenu("Help");
		helpMenuItem(m, this, "Editor");
		menuBar.add(m);
		return menuBar;
	}

	protected void setMenuFont(Font font)
	{
		FontCache.setMenuFont(font);
		FontCache.setMenuFont((MenuElement) m_menuBar, font);
	}

/*
	Rough sketch of layout

	MENU BAR
    Buttons x x x                                     ****
	*********************** ******************* ***********
	*  Leftbox			  * * Right box		  * *		  *
	*********************** ******************* *		  *
											    *		  *
	******Feedback********* * Edge under mouse* * TABBED  *
	                                            * TABLE   *
	******************************************* *		  *
	*										  * *		  *
	*	    			DIAGRAM				  * *		  *
	*										  * *		  *
	******************************************* ***********
*/

	protected void genMainGUI(int diagramPercentWidth, int diagramPercentHeight) 
	{
		int			width, height;
		int			w, h;
		Dimension	d, min;

		width  = m_contentPane.getWidth();
		height = m_contentPane.getHeight();
		min    = new Dimension(100,50);

		if (diagramPercentWidth > 0 && diagramPercentHeight > 0) {
			// Specifies as percentages of total width x total height size of diagram
			m_secondSplitRatio = (double) (1.0 - (diagramPercentHeight/100.0));
			m_mainSplitRatio   = (double) (diagramPercentWidth / 100.0);
		}
			
//		System.out.println("LandscapeEditorCore width=" + width + " height=" + height);

		m_contentPane.setVisible(false);

		// Handle the tool bar

		m_toolBar = new JToolBar();
		m_toolBar.setRollover(true);
		toolButton[NEXT_FIND_BUTTON].setEnabled(false);
		toolButton[PREV_FIND_BUTTON].setEnabled(false);
		toolButton[NEXT_HISTORY_BUTTON].setEnabled(false);
		toolButton[PREV_HISTORY_BUTTON].setEnabled(false);

		for (int i = 0; i< toolButton.length ; ++i) {
			 m_toolBar.add(toolButton[i]);
		}
		m_toolBar.setFloatable(false);
		m_toolBar.setSize(width-2*GAP, ToolBarButton.HEIGHT);
		m_contentPane.add(m_toolBar, BorderLayout.NORTH);		

		// Handle the informational display above the diagram

		{
			w = (int) ((width  * m_mainSplitRatio) / 2.0);
			h = (int) (height * m_secondSplitRatio);

			d = new Dimension(w, h);

			m_leftPanel        = new JPanel(new BorderLayout());
//			m_leftPanel.setMinimumSize(min);
			m_leftPanel.setPreferredSize(d);
			m_leftPanel.setVisible(true);

			m_leftTextBoxTitle = new JLabel();
			m_leftTextBoxTitle.setBackground(Diagram.boxColor);
			m_leftTextBoxTitle.setForeground(TextBox.titleColor);
			m_leftTextBoxTitle.setFont(TextBox.m_titleFont);
			m_leftTextBoxTitle.setSize(w, 20);
			m_leftPanel.add(m_leftTextBoxTitle, BorderLayout.NORTH);
			m_scrollLeftTextBox = new JScrollPane();
			m_leftTextBox = new TextBox(m_scrollLeftTextBox, m_leftTextBoxHelp);
			m_leftTextBox.setSize(w, h-40);
			m_scrollLeftTextBox.setSize(w, h-40);
			m_leftPanel.add(m_scrollLeftTextBox,BorderLayout.CENTER);
			m_feedback = new Feedback(m_feedbackHelp);
			m_feedback.setSize(w, 20);
			m_leftPanel.add(m_feedback, BorderLayout.SOUTH);


			m_rightPanel       = new JPanel(new BorderLayout());
//			m_rightPanel.setMinimumSize(min);
			m_rightPanel.setPreferredSize(d);
			m_rightPanel.setVisible(true);


			m_rightTextBoxTitle = new JLabel();
			m_rightTextBoxTitle.setBackground(Diagram.boxColor);
			m_rightTextBoxTitle.setForeground(TextBox.titleColor);
			m_rightTextBoxTitle.setFont(TextBox.m_titleFont);
			m_rightTextBoxTitle.setSize(w,20);
			m_rightPanel.add(m_rightTextBoxTitle, BorderLayout.NORTH);
			m_scrollRightTextBox = new JScrollPane();
			m_rightTextBox = new TextBox(m_scrollRightTextBox, m_rightTextBoxHelp);
			m_rightTextBox.setSize(w, h-40);
			m_scrollRightTextBox.setSize(w, h-40);
			m_rightPanel.add(m_scrollRightTextBox, BorderLayout.CENTER);
			m_nameBox  = new Feedback(m_nameBoxHelp);
			m_nameBox.setSize(w, 20);
			m_rightPanel.add(m_nameBox, BorderLayout.SOUTH);

			computeMinInfoHeight();

			m_thirdSplitPane = new MySplitPane(JSplitPane.HORIZONTAL_SPLIT, m_leftPanel, m_rightPanel);
			m_thirdSplitPane.setOneTouchExpandable(true);
			m_thirdSplitPane.setDividerLocation(m_thirdSplitRatio);
		}

		// Handle the scroll diagram

		{
			h = height - h - ToolBarButton.HEIGHT;
			w = (int) (width  * m_mainSplitRatio);

			m_scrollDiagram = new JScrollPane(); 

			m_scrollDiagram.setSize(w, h);

			m_secondSplitPane = new JSplitPane(JSplitPane.VERTICAL_SPLIT, m_thirdSplitPane, m_scrollDiagram);
			m_secondSplitPane.setOneTouchExpandable(true);
			m_secondSplitPane.setDividerLocation(m_secondSplitRatio);
		}

		// Handle the right tabs

		{
			w = (int) (width  -  width * m_mainSplitRatio);
			h = height - ToolBarButton.HEIGHT;

			m_rightTabbedPane = new RightTabbedPane(this);

			m_legendBox    = new LegendBox(this,    m_rightTabbedPane);
			m_mapBox       = new MapBox(this,       m_rightTabbedPane);
			m_queryBox     = new QueryBox(this,     m_rightTabbedPane);
			m_resultBox    = new ResultBox(this,    m_rightTabbedPane);
			m_tocBox       = new TextTree(this,     m_rightTabbedPane);
			m_undoBox      = new UndoBox(this,      m_rightTabbedPane);
			m_historyBox   = new HistoryBox(this,   m_rightTabbedPane);
			m_clipboardBox = new ClipboardBox(this, m_rightTabbedPane);
			m_attributeBox = new AttributeBox(this, m_rightTabbedPane);

			d = new Dimension(w, h);

			m_legendBox.setSize(d);
			m_mapBox.setSize(d);
			m_queryBox.setSize(d);
			m_resultBox.setSize(d);
			m_tocBox.setSize(d);
			m_rightTabbedPane.setSize(d);
			m_undoBox.setSize(d);
			m_historyBox.setSize(d);
			m_clipboardBox.setSize(d);
			m_attributeBox.setSize(d);

			m_legendBox.setPreferredSize(d);
			m_mapBox.setPreferredSize(d);
			m_queryBox.setPreferredSize(d);
			m_resultBox.setPreferredSize(d);
			m_tocBox.setPreferredSize(d);
			m_rightTabbedPane.setPreferredSize(d);
			m_undoBox.setPreferredSize(d);
			m_historyBox.setPreferredSize(d);
			m_clipboardBox.setPreferredSize(d);
			m_attributeBox.setPreferredSize(d);

			m_legendBox.activate();
		}
		m_secondSplitPane.setMinimumSize(min);
		m_rightTabbedPane.setMinimumSize(min);

		m_mainSplitPane = new JSplitPane(JSplitPane.HORIZONTAL_SPLIT, m_secondSplitPane, m_rightTabbedPane);
		m_mainSplitPane.setOneTouchExpandable(true);
		m_mainSplitPane.setSize(width, height-ToolBarButton.HEIGHT);
		m_mainSplitPane.setDividerLocation(m_mainSplitRatio);

		m_contentPane.add(m_mainSplitPane, BorderLayout.CENTER);

		m_contentPane.setVisible(true);
 	}

	protected void genModeHandlers() 
	{
		m_editModeHandler = new EditModeHandler(this);
	}

	// Generate top of screen GUI 

	protected static int PREV_HISTORY_BUTTON = 13;
	protected static int NEXT_HISTORY_BUTTON = 14;
	protected static int PREV_FIND_BUTTON    = 15;	// Position in ToolBarButton
	protected static int NEXT_FIND_BUTTON    = 16;

	protected ToolBarButton[] toolButton = 
	{
		new Find_Button(this),	
		new Query_f_Button(this),
		new Query_b_Button(this), 
		new Query_C_Button(this),
		new Query_Clear_Button(this),
		new Elision_c_Button(this),

		new Elision_I_Button(this), 
		new Elision_u_Button(this),
		new Elision_CU_Button(this), 
		new Elision_s_Button(this),
		new Elision_CS_Button(this),
		new FontSmallerButton(this),
		new FontBiggerButton(this),
		new HistoryPrev_Button(this),
		new HistoryNext_Button(this),
		new FindPrev_Button(this),
		new FindNext_Button(this)
	};

	protected void computeMinInfoHeight()
	{
		Dimension d;

		int	left  = 0;
		int	right = 0;

		if (m_leftTextBoxTitle != null && m_leftTextBoxTitle.isVisible()) {
			d = m_leftTextBoxTitle.getMinimumSize();
			left += d.height;
		}
		if (m_scrollLeftTextBox != null && m_scrollLeftTextBox.isVisible()) {
			d = m_scrollLeftTextBox.getMinimumSize();
			left += d.height;
		}
		if (m_feedback != null && m_feedback.isVisible()) {
			d = m_feedback.getMinimumSize();
			left += d.height;
		}
		d = new Dimension(100, left);
		m_leftPanel.setMinimumSize(d);

		if (m_rightTextBoxTitle != null && m_rightTextBoxTitle.isVisible()) {
			d = m_rightTextBoxTitle.getMinimumSize();
			right += d.height;
		}
		if (m_scrollRightTextBox != null && m_scrollRightTextBox.isVisible()) {
			d = m_scrollRightTextBox.getMinimumSize();
			right += d.height;
		}
		if (m_nameBox != null && m_nameBox.isVisible()) {
			d = m_nameBox.getMinimumSize();
			right += d.height;
		}
		d = new Dimension(100, right);
		m_rightPanel.setMinimumSize(d);
	}

	protected void setLeftBox() 
	{
		if (m_diagram != null) {
			EntityInstance root = m_diagram.getDrawRoot();

			if (root != null) {
				String label = root.getEntityLabel();
				String title = root.getTitle();
				String desc  = root.getDescription();
				String topline;

				if (desc == null) {
					if (root.getContainedBy() == null) {
						desc = "The " + label + " landscape.";
					} else {
						desc = "The " + label + " " + root.getClassLabel();
				}	}

				if (title != null) {
					topline = title + " (" + label + ")";
				} else {
					topline = label;
				}
				m_leftTextBoxTitle.setText(topline);
				m_leftTextBox.set(desc);
		}	}
	}

	protected void changeDiagram(Diagram diagram) 
	{
		String	name, diagramName;
		int		i;

//		System.out.println("LandscapeEditorCore.changeDiagram " + m_scrollDiagram.getBounds());

		m_editModeHandler.cleanup();
		if (m_historyBox != null) {
			m_historyBox.clear();
		}
		if (m_findResults != null) {
			m_findResults.clear();
		}
		setDiagram(diagram);
		if (diagram != null) {
			diagram.setVisible(true);
		}
		activeDiagram(diagram);

		if (m_tocBox != null) {
			m_tocBox.firstTime();
			setTocHidden(TOC_HIDDEN_DEFAULT);
			m_tocBox.fillTOC();
		}
		if (m_legendBox != null) {
			m_legendBox.fillLegendBox();
		}
		if (m_queryBox != null) {
			m_queryBox.fillQueryBox();
		}
		if (m_rightTabbedPane != null) {
			m_rightTabbedPane.validate();
		}
		if (m_undoBox != null) {
			m_undoBox.fillUndoBox();
		}
		clipboardChanged();

		m_scrollDiagram.setViewportView(diagram);
		if (m_diagram != null) {
			diagramName = m_diagram.getContextName();
			if (diagramName == null) {
				doFeedback("No diagram");
			} else {
				doFeedback("Set to: " + diagramName);
		}	}
		setLeftBox();
	}

	protected void addDiagram(Diagram newDg, String path) 
	{
		rememberDiagram(newDg, path);
		changeDiagram(newDg);
		newDg.setToViewport();
	}

	public void switchDiagram(Diagram newDg, String lsPath)
	{
		Diagram	old;

		old    = m_diagram;
		if (old != newDg) {
			if (old != null) {
				old.removeEntitiesFromCache();
			}
			if (newDg != null) {
				newDg.addEntitiesToCache();
				changeDiagram(newDg);
			} else {
				newDg = newDiagram();
				String rc = newDg.loadDiagram(lsPath, m_documentBase);
		  		if (rc != null) {
					error("Attach failed: " + rc);
					old.addEntitiesToCache();
					return;
				}
				addDiagram(newDg, lsPath);
	}	}	}
	

	protected void attach(String lsPath) 
	{
		Diagram	newDg;

		newDg  = getOpenDiagram(lsPath);
		switchDiagram(newDg, lsPath);
	}

	public String getParameter(String name) 
	{
		if (isApplet()) {
			return m_applet.getParameter(name);
		} else {
			return System.getProperty(name);
	}	}

	public void repaintDg()
	{
		m_diagram.revalidate();
		if (m_mapBox.isActive()) {
			m_mapBox.revalidate();
		}
	}

	public void redrawDg() 
	{
		m_diagram.redrawDiagram();
	}

	protected String filePrompt(String banner, String default_file, int mode, FileFilter[] filters) 
	{
		File		file;
		FileFilter	filter;
		String		name;
		int			ret;

		if (isApplet()) {
			name = JOptionPane.showInputDialog("Which file do you wish to upload from the server"); 
		} else {
			JFileChooser fd = new JFileChooser();

			fd.setDialogTitle(banner);
			fd.setFileSelectionMode(JFileChooser.FILES_ONLY);
			if (default_file != null) {
				fd.setSelectedFile(new File(default_file));
			}
			if (filters != null) {
				for (int i = 0; i < filters.length; ++i) {
					fd.addChoosableFileFilter(filters[i]);
			}	} 

			if (mode == FA_LOAD) {
				ret = fd.showOpenDialog(m_contentPane);
			} else {
				ret = fd.showSaveDialog(m_contentPane);
			}
			if (ret == JFileChooser.APPROVE_OPTION) {
				file = fd.getSelectedFile();
				name = file.getAbsolutePath();
			} else {
				name = null;
		}	}
		return name;
	}

	protected void getBrowser()
	{
		JFileChooser	fileChooser = new JFileChooser();

		String	os              = Version.Detail("os.name");
		String	defaultFilename = null;
		String	browser         = null;
		File	defaultfile, startfile, file;
		int		ret;

		if (os != null) {
			if (os.startsWith("Windows")) {
				defaultFilename = "C:\\Program Files\\Internet Explorer\\IEXPLORE.EXE";
		}	}

		if (defaultFilename != null) {
			defaultfile = new File(defaultFilename);
		} else {
			defaultfile = null;
		}

		fileChooser.setDialogTitle("Identify internet browser");
		fileChooser.setFileSelectionMode(JFileChooser.FILES_ONLY);
		fileChooser.setApproveButtonText("Select");

		if (m_browser == null) {
			startfile = defaultfile;
		} else {
			startfile = new File(m_browser);
		}

		if (startfile != null) {
			fileChooser.setSelectedFile(startfile);
		}

		if (defaultfile != null) {
			fileChooser.setAccessory(new DefaultBrowserButton(fileChooser, os, defaultfile));
		}
		ret = fileChooser.showOpenDialog(m_contentPane);

		if (ret == JFileChooser.APPROVE_OPTION) {
			file = fileChooser.getSelectedFile();
			browser = file.getAbsolutePath();
			if (browser.equals(m_browser)) {
				return;
			}
			m_browser = browser;
	}	}

	protected void showURL(String urlName, int target) 
	{
		MsgOut.vprintln("URL: " + urlName + " - target: " + target);

		try {
			URL newURL;
			
			if (!isApplet()) {
				try {
					BrowserLauncher.openURL(urlName);
				} catch (Exception e) {
					System.out.println("Unable to execute BrowserLauncher " + e);

					String[]	argv    = new String[2];
					String		browser = m_browser;

					if (browser == null) {
						getBrowser();
						browser = m_browser;
						if (browser == null) {
							return;
					}	}

					argv[0] = browser;
					argv[1] = urlName;

					try {
						Runtime runtime = Runtime.getRuntime();
						runtime.exec(argv);
					} catch (Exception e1) {
						JOptionPane.showMessageDialog(m_frame, 	"Unable to execute " + argv[0] + " " + e1, "Browser error", JOptionPane.ERROR_MESSAGE | JOptionPane.OK_OPTION);
					}
				}
 
			} else {
				newURL = new URL(m_documentBase, urlName);
				if (m_ac == null) {
					m_ac = m_applet.getAppletContext();
				}
				// URLConnection urlCon = newURL.openConnection();
				// urlCon.connect();

				switch(target) {
				case LsLink.TARGET_TOP:
					m_ac.showDocument(newURL, "_top");
					break;
				case LsLink.TARGET_HELP:
					m_ac.showDocument(newURL, "_blank");
					break;
				case LsLink.TARGET_FRAME:
					m_ac.showDocument(newURL, "Map");
					break;
				case LsLink.TARGET_LIST:
					m_ac.showDocument(newURL, "List");
					break;
			}	}
		} catch (MalformedURLException ex) {
			MsgOut.println("Malformed URL: " + urlName + " " + ex);
		}
	}

	protected void about() 
	{
		if (m_aboutURL != null) {
			showURL(m_aboutURL, LsLink.TARGET_HELP);
		}
	}

	protected void help() 
	{
		if (m_helpURL != null) {
			showURL(m_helpURL, LsLink.TARGET_HELP);
		}
	}

	protected void setVisibility(JComponent bd, boolean state) 
	{
		if (bd != null) {
			bd.setVisible(state);
		}
	} 

	protected void readyMsg() 
	{
		doFeedback(getTitle() + " " + Version.MAJOR + "." + Version.MINOR + " (build " + Version.BUILD + ") Started.");
	}

	protected void followURL(String url, int target) 
	{
//		System.out.println("LandscapeEditorCore.followURL: " + target);

		switch (target) {
		case LsLink.TARGET_APP:
			attach(url);			//  Treat the url as the name of a TA file to be displayed
			break;
		case LsLink.TARGET_NEW:
			if (m_frame != null) {
				// Running under a frame -- not an applet
				LandscapeEditorFrame af = LandscapeEditorFrame.create();
				af.setLsPath(url);
				af.launch();
				m_openFrames++;
				break;
			}
		default:
			showURL(url, target);
	}	}

	public void clearFeedback() 
	{
		m_feedback.set("");
	}

	protected void loadLs(String file) 
	{
		Diagram old   = m_diagram;

		if (old != null) {
			old.removeEntitiesFromCache();
		}

		Diagram newDg = newDiagram();

		if (file == null) {
			doFeedback("No diagram");
			newDg.noDiagram();
		} else if (file.length() < 1) {
			doFeedback("New Diagram");
			newDg.emptyDiagram();
			newDg.navigateToRoot();
		} else {
			m_lsPath = file;

			doFeedback("Reading: " + file);
			String rc = newDg.loadDiagram(file, m_documentBase);

			if (rc != null) {
				error("Failed to load (" + rc + ")");
				old.addEntitiesToCache();
				return;
		}	}
		addDiagram(newDg, file);
		this.requestFocus();
		repaint();
	}

	protected void fitToLabel() 
	{
		Vector v = startGroupOp();

		if (v == null) {
			return;
		}

		Enumeration en;

		for (en = v.elements(); en.hasMoreElements(); ) {
			EntityInstance e = (EntityInstance) en.nextElement();

			Dimension ld = e.getLabelDim(getGraphics(), EntityInstance.REG_FONT);

			Rectangle curLayout = e.getDiagramBounds();

			curLayout.width  = ld.width + EntityComponent.MARGIN*2;	// Margin both sides
			curLayout.height = ld.height+ EntityComponent.MARGIN*2;

			if (e.hasChildren()) {
				curLayout.width += EntityComponent.CONTENTS_FLAG_X_RESERVE;
				if (curLayout.height < EntityComponent.CONTENTS_FLAG_Y_RESERVE) {
					curLayout.height = EntityComponent.CONTENTS_FLAG_Y_RESERVE;
				}
			}

			e.updateDiagramBounds(curLayout);
		}

		m_diagram.rescaleDiagram();
		redrawDg();
	}

	protected Vector startGroupOp() 
	{
		Vector grp = m_diagram.getGroup();

		if (grp == null) {
			error("Group not selected");
			return null;
		}
		return grp;
	}

	// Alignment

	protected void alignTop() 
	{
		Vector grp = startGroupOp();

		if (grp == null) {
			return;
		}

		// Align group based on alignment to key entity

		EntityInstance	ke   = m_diagram.getKeyEntity();
		double			top  = ke.yRelLocal();
		Enumeration		en;
		EntityInstance	e;

		for (en = grp.elements(); en.hasMoreElements(); ) {
			e = (EntityInstance) en.nextElement();
			if ((top + e.heightRelLocal()) > 1.0) {
				top = 1.0 - e.heightRelLocal();
		}	}

		for (en = grp.elements(); en.hasMoreElements(); ) {
			e = (EntityInstance) en.nextElement();
			e.updateYRelLocal(top);
		}

		m_diagram.rescaleDiagram();
		repaintDg();
	}

	protected void alignHorizontal() 
	{
		Vector grp = startGroupOp();

		if (grp == null) {
			return;
		}

		// Align group based on alignment to key entity

		EntityInstance	ke     = m_diagram.getKeyEntity();
		double			center = ke.yRelLocal() + (ke.heightRelLocal()/2);
		Enumeration		en;
		EntityInstance	e;

		for (en = grp.elements(); en.hasMoreElements(); ) {
			e = (EntityInstance) en.nextElement();
			if ((center + (e.heightRelLocal()/2.0)) > 1.0) {
				center = 1.0 - (e.heightRelLocal()/2.0);
		}	}

		for (en = grp.elements(); en.hasMoreElements(); ) {
			e = (EntityInstance) en.nextElement();
			if ((center - (e.heightRelLocal()/2.0)) < 0) {
				center = (e.heightRelLocal()/2.0);
		}	}

		for (en = grp.elements(); en.hasMoreElements(); ) {
			e = (EntityInstance) en.nextElement();
			e.updateYRelLocal(center - (e.heightRelLocal()/2.0));
		}

		m_diagram.rescaleDiagram();
		repaintDg();
	}

	protected void alignBottom() 
	{
		Vector grp = startGroupOp();

		if (grp == null) {
			return;
		}

		// Align group based on alignment to key entity

		EntityInstance	ke     = m_diagram.getKeyEntity();
		double			bottom = ke.yRelLocal() + ke.heightRelLocal();
		Enumeration		en;
		EntityInstance	e;

		for (en = grp.elements(); en.hasMoreElements(); ) {
			e = (EntityInstance) en.nextElement();
			if ((bottom - e.heightRelLocal()) < 0) {
				bottom = e.heightRelLocal();
		}	}

		for (en = grp.elements(); en.hasMoreElements(); ) {
			e = (EntityInstance) en.nextElement();
			e.updateYRelLocal(bottom - e.heightRelLocal());
		}

		m_diagram.rescaleDiagram();
		repaintDg();
	}

	protected void alignLeft() 
	{
		Vector grp = startGroupOp();

		if (grp == null) {
			return;
		}

		// Align group based on alignment to key entity

		EntityInstance	ke   = m_diagram.getKeyEntity();
		double			left = ke.xRelLocal();
		Enumeration		en;
		EntityInstance	e;

		for (en = grp.elements(); en.hasMoreElements(); ) {
			e = (EntityInstance) en.nextElement();
			if ((left + e.widthRelLocal()) > 1.0) {
				left = 1.0 - e.widthRelLocal();
		}	}

		for (en = grp.elements(); en.hasMoreElements(); ) {
			e = (EntityInstance) en.nextElement();
			e.updateXRelLocal(left);
		}

		m_diagram.rescaleDiagram();
		repaintDg();
	}

	protected void alignVertical() 
	{
		Vector grp = startGroupOp();

		if (grp == null) {
			return;
		}

		// Align group based on alignment to key entity

		EntityInstance	ke     = m_diagram.getKeyEntity();
		double			center = ke.xRelLocal() + (ke.widthRelLocal()/2);
		Enumeration		en;
		EntityInstance	e;

		for (en = grp.elements(); en.hasMoreElements(); ) {
			e = (EntityInstance) en.nextElement();
			if ((center + (e.widthRelLocal()/2.0)) > 1.0) {
				center = 1.0 - (e.widthRelLocal()/2.0);
		}	}

		for (en = grp.elements(); en.hasMoreElements(); ) {
			e = (EntityInstance) en.nextElement();
			if ((center - (e.widthRelLocal()/2.0)) < 0) {
				center = (e.widthRelLocal()/2.0);
		}	}

		for (en = grp.elements(); en.hasMoreElements(); ) {
			e = (EntityInstance) en.nextElement();
			e.updateXRelLocal(center - (e.widthRelLocal()/2.0));
		}

		m_diagram.rescaleDiagram();
		repaintDg();
	}

	protected void alignRight() 
	{
		Vector grp = startGroupOp();

		if (grp == null) {
			return;
		}

		// Align group based on alignment to key entity

		EntityInstance	ke    = m_diagram.getKeyEntity();
		double			right = ke.xRelLocal() + ke.widthRelLocal();
		Enumeration		en;
		EntityInstance	e;

		for (en = grp.elements(); en.hasMoreElements(); ) {
			e = (EntityInstance) en.nextElement();
			if ((right - e.widthRelLocal()) < 0) {
				right = e.widthRelLocal();
		}	}

		for (en = grp.elements(); en.hasMoreElements(); ) {
			e = (EntityInstance) en.nextElement();
			e.updateXRelLocal(right - e.widthRelLocal());
		}

		m_diagram.rescaleDiagram();
		repaintDg();
	}

	protected void sameWidth() 
	{
		Vector grp = startGroupOp();

		if (grp == null)
			return;

		// Size group based on size of key entity

		EntityInstance	ke   = m_diagram.getKeyEntity();
		Rectangle		klyt = ke.getDiagramBounds();

		Enumeration en;

		for (en = grp.elements(); en.hasMoreElements(); ) {
			EntityInstance e = (EntityInstance) en.nextElement();

			if (e != ke) {
				Rectangle elyt = (Rectangle) e.getDiagramBounds().clone();
				elyt.width = klyt.width;
				e.updateDiagramBounds(elyt);
			}
		}
		m_diagram.rescaleDiagram();
		repaintDg();
	} 

	protected void sameHeight() 
	{
		Vector grp = startGroupOp();

		if (grp == null)
			return;

		// Size group based on size of key entity

		EntityInstance	ke   = m_diagram.getKeyEntity();
		Rectangle		klyt = ke.getDiagramBounds();

		Enumeration en;

		for (en = grp.elements(); en.hasMoreElements(); ) {
			EntityInstance e = (EntityInstance) en.nextElement();
			if (e != ke) {
				Rectangle elyt = (Rectangle) e.getDiagramBounds().clone();
				elyt.height = klyt.height;
				e.updateDiagramBounds(elyt);
			}
		}

		m_diagram.rescaleDiagram();
		repaintDg();
	} 

	protected void sameSize() 
	{
		Vector grp = startGroupOp();

		if (grp == null)
			return;

		// Size group based on size of key entity

		EntityInstance	ke   = m_diagram.getKeyEntity();
		Rectangle		klyt = ke.getDiagramBounds();

		Enumeration en;

		for (en = grp.elements(); en.hasMoreElements(); ) {
			EntityInstance e = (EntityInstance) en.nextElement();

			if (e != ke) {
				Rectangle elyt = (Rectangle) e.getDiagramBounds().clone();
				elyt.width  = klyt.width;
				elyt.height = klyt.height;
				e.updateDiagramBounds(elyt);
			}
		}

		m_diagram.rescaleDiagram();
		repaintDg();
	} 

	// mode is either Do.SPC_HORIZ or Do.SPC_VERTICAL:

	protected void equalSpacing(int mode) 
	{
		Vector grp = startGroupOp();

		if (grp == null) {
			return;
		}

		if (grp.size() < 3) {
			error("Minimum group of three required");
			return;
		}

		Rectangle bb = m_diagram.getGroupBoundingBox();

		if (bb == null) {
			error("Group not selected");
			return;
		}

		// Sort entities based on vertical or horizontal position
		switch (mode) {
		case Do.SPC_HORIZ:
			SortVector.byDiagramX(grp);
			break;
		case Do.SPC_VERTICAL: 
			SortVector.byDiagramY(grp);
			break;
		}

		// Calculate sep

		double tw, th;
		double sep = 0.0;

		Enumeration en = grp.elements();

		tw = th = 0;

		while(en.hasMoreElements()) {
			EntityInstance e = (EntityInstance) en.nextElement();

			Rectangle lyt = e.getDiagramBounds();

			tw += lyt.width;
			th += lyt.height;
		}

		if (mode == Do.SPC_HORIZ) {
			sep = (bb.width - tw)/(grp.size()-1);
		}
		else {
			sep = (bb.height - th)/(grp.size()-1);
		}

		// Apply new layouts to second through penultimate entitites

		EntityInstance ce = (EntityInstance) grp.elementAt(0);
		Rectangle clyt = ce.getDiagramBounds();

		for (int i = 1; i < grp.size()-1; i++) {
			EntityInstance e = (EntityInstance) grp.elementAt(i);

			Rectangle lyt = e.getDiagramBounds();

			if (mode == Do.SPC_HORIZ) {
				lyt.x = (int) (clyt.x + clyt.width + sep);
			}
			else {
				lyt.y = (int) (clyt.y + clyt.height + sep);
			}

			clyt = (Rectangle) lyt.clone();
			e.updateDiagramBounds(lyt);
		}

		m_diagram.rescaleDiagram();
		repaintDg();
	}

	protected void updateCreateContainedGroup() 
	{
		Vector grp = startGroupOp();

		if (grp == null) {
			return;
		}

		EntityInstance pe = ((EntityInstance) grp.firstElement()).getContainedBy();

		Rectangle nlyt = m_diagram.getGroupBoundingBox();

		nlyt.y -= RelationInstance.CLIENT_SUPPLIER_EL_LEN+5;
		nlyt.x -= 5;
		nlyt.width += 10;
		nlyt.height += RelationInstance.CLIENT_SUPPLIER_EL_LEN+10;

		EntityInstance ne = updateNewEntity(pe, nlyt);
		if (ne != null) {

			Enumeration en = grp.elements();

			while (en.hasMoreElements()) {
				EntityInstance e = (EntityInstance) en.nextElement();

				Rectangle lyt = e.getDiagramBounds();

				m_diagram.updateMoveEntityContainment(ne, e);
				e.updateDiagramBounds(lyt);		
			}

			m_diagram.rescaleDiagram();
			repaintDg();
	}	}
		
	protected void saveStatus(String stat) 
	{
		doFeedback("Save status: " + stat);
	}


	// Save the landscape in the URL

	protected String doSaveByURL(String lsSaveURL) 
	{
		URL lsURL;

		try {
			lsURL = new URL(lsSaveURL);
		}
		catch(MalformedURLException e) {
		   return "Malformed URL on write";
		}

		URLConnection urlCon;

		try {
			urlCon = lsURL.openConnection();

			urlCon.setDoInput(false);
			urlCon.setDoOutput(true);
			urlCon.setAllowUserInteraction(false);
		}
		catch (IOException e) {
			return "Couldn't open connection";
		}

		OutputStream os;

		try {
			os = urlCon.getOutputStream();
		}
		catch (IOException e) {
			return "Couldn't openStream";
		}

		try {
			m_diagram.saveDiagram(os, false);
		}
		catch (IOException e) {
			return "IOException on write";
		}

		return null;
	}

	protected void saveByURL(String overridePath) 
	{
		MsgOut.dprintln("Save by URL");

		URL lsURL;

		String str = doSaveByURL(lsSavePath);

		if (str != null) {
			saveStatus(str);
			return;
		}

		if (lsSaveCmd == null) {
			saveStatus("Success");
			return;
		}

		try {
			lsURL = new URL(lsSaveCmd);
		}
		catch(MalformedURLException e) {
		   saveStatus("Malformed URL on write");
		   return;
		}

		InputStream is;
		try {
			is = lsURL.openStream();
		}
		catch (IOException e) {
			saveStatus("Couldn't openStream for store");
			return;
		}

		try {
			DataInputStream dis = new DataInputStream(is);

			str = dis.readLine();

			is.close();

			saveStatus(str);
		}
		catch(IOException e) {
			saveStatus("IOexception on store");
		}
	}

	protected String saveByFile(String newPath) 
	{
		String ret = m_diagram.saveByFile(newPath);
		if (ret == null && newPath != null) {
			changeDiagramPath(newPath);
		}
		return ret;
	}

	protected String saveWithCmd(String saveSuffix, String cmdTemplate)
	{
		File file = (File) m_diagram.getContext();

		String path = file.getPath() + saveSuffix;

		File nfile = new File(path);

		// Save away the monolithic TA file

		try {

			FileOutputStream os = new FileOutputStream(nfile);

			m_diagram.saveDiagram(os, true);
		}
		catch(IOException e) {
			return "IOException on file save";
		}
	
		// Run command after save

		String cmd = Util.expand(cmdTemplate, file.getName(), this);

		// System.out.println("Save command: " + cmd);

		String rc;

		try {
			Runtime rt = Runtime.getRuntime();

			Process p = rt.exec(cmd);

			DataInputStream es = 
				new DataInputStream(p.getErrorStream());

			rc = es.readLine();

			if (rc.equals("Done"))
				rc = "Save succeeded";

			p.destroy();
		}
		catch (Exception e) {
			rc = "Exec failed for: " + cmd;
		}

		return rc;
	}

	protected void doSaveLs(String overridePath) 
	{
		doFeedback("Saving landscape...");

		if (m_diagram.getContext() instanceof URL) {
			saveByURL(overridePath);
		}
		else {
			String rc;

			if (overridePath == null && lsSaveCmd != null) {
				MsgOut.dprintln("Save by app");
				rc = saveWithCmd(lsSaveSuffix, lsSaveCmd);
			} else {
				MsgOut.dprintln("Save by file");
				rc = saveByFile(overridePath); 
			}

			if (rc == null) {
				rc = "Success";
			}
			saveStatus(rc);
		}
	}

	protected void saveLs() 
	{
		Object context = m_diagram.getContext();
		String txt = null;

		if (context == null) {
			txt = filePrompt("Save Landscape", m_diagram.getAbsolutePath(), FA_SAVE, null);
			if (txt == null || txt.length() == 0) {
				return;
			}
		}

		doSaveLs(txt);
	}

	protected static final String indAdd = "  ";

	// Called to initialize component

	public void init_core(int diagramPercentWidth, int diagramPercentHeight) 
	{
		m_contentPane.setBackground(Color.lightGray);
//		m_contentPane.setBackground(Color.GREEN);

		// We must generate the mode handlers before the Diagram
		genModeHandlers();
		genMainGUI(diagramPercentWidth, diagramPercentHeight);

		initialLoad();
		showInfo("");
	}

	protected void initialLoad() 
	{
		setDirectEdge();	// Default if not specified in the diagram

		setDiagram(newDiagram());

		if (m_lsPath == null) {
			MsgOut.dprintln("Empty landscape");
			if (m_leftTextBox != null) {
				m_leftTextBoxTitle.setText("Empty Landscape");
				m_leftTextBox.set("Select 'Open landscape' from 'File' menu to load a new landscape.");
			}
			readyMsg();
		} else if (m_diagram != null) {

			MsgOut.dprintln("Load: " + m_lsPath);

			String rc = m_diagram.loadDiagram(m_lsPath, m_documentBase);

			if (rc != null) {
				error("Load failed (" + rc + ") for: " + m_lsPath);
				System.out.println("Load failed (" + rc + ") for: " + m_lsPath);
				return;
			} else {
				EntityInstance	e;

				changeDiagram(m_diagram);
				if (m_startEntity == null) {
					m_diagram.navigateToRoot();
					e = m_diagram.getRootInstance();
				} else {
					e = m_diagram.getCache(m_startEntity);
					if (e == null) {
						error("Entity not found: '" + m_startEntity + "'");		// IJD
					} else {
						m_diagram.setPreserveEntityMarks(0);
						m_diagram.setPreserveRelationMarks(0);
						m_diagram.navigateTo(e);
				}	}
				if (e != null) {
					addHistoryEntity(e);
				}
				setLeftBox();
				readyMsg();
		}	}

		if (m_rightTabbedPane != null && m_rightTabbedPane.isVisible()) {
			m_legendBox.activate();
		}

		requestFocus();
		rememberDiagram(m_diagram, m_lsPath);
		activeDiagram(m_diagram);
	}

	// Show the results in res highlighted

	protected void goTo(Vector res) 
	{
		Enumeration en;
		
		doFeedback("");

		m_diagram.clearFlags();

		EntityInstance e  = (EntityInstance) res.elementAt(0);
		EntityInstance pe = e.getContainedBy();

		for (en = res.elements(); en.hasMoreElements(); ) {
			e = (EntityInstance) en.nextElement();
			e.setRedBoxFlag();
		}
		
		m_diagram.setPreserveEntityMarks(EntityInstance.REDBOX_MARK);
		m_diagram.setPreserveRelationMarks(0);

		if (pe != m_diagram.getDrawRoot()) {
			m_diagram.navigateTo(pe);
		}

		SortVector.byString(res);
		m_resultBox.showResults("FIND RESULTS:", res, "-- Find step --");
		m_resultBox.activate();
		setLeftBox();
		m_rightTextBoxTitle.setText("");
		m_rightTextBox.set("");
		redrawDg();
	}

	// Called by Cntl.F3

	protected void findNext() 
	{
		if (m_findResults == null) {
			error("No search has occured.");
		} else if (m_findResults.isEmpty()) {
			error("No entities found which match search pattern.");
		} else {
			JButton button = toolButton[PREV_FIND_BUTTON];
			boolean change = false;
			boolean	state  = !m_findResults.atBeginning();

			if (button.isEnabled() != state) {
				button.setEnabled(state);
				change = true;
			}

			Vector result = m_findResults.nextResult();

			state  = !m_findResults.atEnd();
			button = toolButton[NEXT_FIND_BUTTON];
			if (button.isEnabled() != state) {
				button.setEnabled(state);
				change = true;
			}
			if (change) {
				m_toolBar.revalidate();
			}
			if (result == null) {
				error("No more results available.");
			} else {
				goTo(result);
	}	}	}

	// Called by Cntl F

	protected void find() 
	{
		FindBox		findBox     = new FindBox(m_frame, m_diagram);
		Pattern		pattern     = findBox.pattern();
		EntityClass	entityClass = findBox.entityClass();

		findBox.dispose();


		if (pattern != null || entityClass != null) {

			m_findResults = new Find(pattern, entityClass, m_diagram.getRootInstance());

			if (m_findResults.isEmpty()) {
				error("No entities found which match search pattern.");
			} else {
				m_diagram.clearQueryFlags();
				m_findResults.reset();
				findNext();
				if (!m_findResults.atEnd()) {
					m_rightTextBox.set("Use F3 to step forward through layers found and F2 to step back");
	}	}	}	}

	// Called by Cntl.F2

	protected void findPrev() 
	{
		Vector result;

		if (m_findResults == null) {
			error("No search has occured.");
		} else if (m_findResults.isEmpty()) {
			error("No search results.");
		} else {
			if (!m_findResults.regress()) {
				error("At first result.");
			} else {
				findNext();
	}	}	}

	public void setTocHidden(boolean value)
	{
		if (isTocHidden() != value) {
			super.setTocHidden(value);
			if (m_tocBox != null) {
				m_tocBox.fillTOC();
	}	}	}

	public RelationInstance updateNewRelation(EntityInstance from, EntityInstance to)
	{
		return m_diagram.updateNewRelation(null, from, to);
	}

	public EntityInstance updateNewEntity(EntityInstance container, Rectangle lyt)
	{
		return m_diagram.updateNewEntity(null, container, lyt, true);
	}

	protected boolean deleteContainer(EntityInstance e)
	{
		if (e == m_diagram.getRootInstance()) {
			error("Can't delete root instance");
			return false;
		}	

		m_diagram.updateDeleteContainer(e);
		doFeedback("Container " + e.getEntityLabel() + " has been deleted.");
		return true;
	}

	protected boolean testForClose(boolean windowClosing) 
	{
		if (m_frame == null) {
			return false;
		}
		if (m_diagram.getChangedFlag()) {
			Util.beep();

			int	option = (windowClosing ? JOptionPane.YES_NO_OPTION : JOptionPane.YES_NO_CANCEL_OPTION);
			int rc = JOptionPane.showConfirmDialog(m_frame, "Landscape has been changed.\nShould it be saved?", "Landscape Changed", option);

			switch(rc) {
			case JOptionPane.YES_OPTION:
				saveLs();
				// Drop through
			case JOptionPane.NO_OPTION:
				break;
			default:
				if (!windowClosing) {
					return false;
		}	}	}
		saveLseditHistory();
		return true;
	}

	protected void sleep(int ms) 
	{
		try {
			Thread.sleep(ms);
		} catch(Exception e) {
		}
	}

	protected void navigateTo(EntityInstance e) 
	{
		m_diagram.setPreserveEntityMarks(0);
		m_diagram.setPreserveRelationMarks(0);

		m_diagram.navigateTo(e);
		setRightTextBox("", "");
		m_diagram.clearFlags();
		validate();		
	}

	public void followLink(EntityInstance e, boolean newViewer) 
	{
		Attribute attr = e.getLsAttribute(EntityInstance.NAVLINK_ID);
		AttributeValueItem avi;

		m_editModeHandler.cleanup();

		m_diagram.setPreserveEntityMarks(0);
		m_diagram.setPreserveRelationMarks(0);

		if (attr == null) {
			navigateTo(e);
			return;
		}

		avi = attr.avi;
		if (avi == null) {
		   // This seems to be the case when going up
		   /* [irbull] if avi is null, just use the navigate to? */
			navigateTo(e);
			return;
		}

		for (; avi != null; avi = avi.nextList) {
			String file = LsLink.expand(avi.value, e, this);
			if (file != null) {
				if (newViewer) {
					followURL(file, LsLink.TARGET_NEW);
				} else if (attr.avi.next != null) {
					// The second argument here allows us to say how the target is to be followed
					String tgtStr = Util.expand(avi.next.value, this);
					int target = LsLink.convertTarget(tgtStr);
					if (target == LsLink.TARGET_APP) {
						// Eventually the link name should be resolved
						// we may want to allow a navigate on one 
						// entity to go to another
						navigateTo(e);
					} else {
						followURL(file, target);
					}
				} else {
					error("No target: " + attr.avi.value);
		}	}	}
	}

	protected void moveRedBoxes(Object object) 
	{
		Vector grp = m_diagram.getRedBoxGroup();

		if (grp == null) {
			error("No query result active.");
			return;
		}

		EntityInstance container = m_diagram.targetEntity(object);
		if (container == null) {
			return;
		}

		if (container == m_diagram.getRootInstance()) {
			error("Can't add objects into the root");
			return;
		}
		/*
		if (!container.isOpen()) {
			error("Entity to be inserted into is not open");
			return;
		}
		*/

		Enumeration en;

		beginUndoRedo("Move Redboxes");

		for (en = grp.elements(); en.hasMoreElements(); ) {
			EntityInstance e = (EntityInstance) en.nextElement();
			if (e.hasDescendantOrSelf(container)) {
				error("Entity " + e.getEntityLabel() + " can't be moved into " + container.getEntityLabel() + " because it contains the entity");
				continue;
			}
			m_diagram.updateMoveEntityContainment(container, e);
		}
		endUndoRedo();

		m_diagram.rescaleDiagram();
	}

	protected void shiftDeltaFont(int delta) 
	{
		Vector			grp = m_diagram.getGroup();
		EntityInstance	ge;
		String			msg;

		if (grp != null && !grp.isEmpty()) {
			Enumeration en;
			
			for (en = grp.elements(); en.hasMoreElements();) {
				ge = (EntityInstance) en.nextElement();
				ge.shiftDeltaFont(delta);
			}
			msg = "Selected entities font changed";
		} else { 
			ge = m_diagram.getDrawRoot();
			if (ge == null) {
				msg = "No entities exist";
			} else {
				ge.shiftDeltaFont(delta);
				msg = "Draw root font changed";
		}	} 
		doFeedback(msg);
	}

	public void show_groupList() 
	{
		Diagram diagram = m_diagram;
		String	msg;

		if (diagram != null) {
			msg = diagram.show_groupList(m_resultBox);
			if (msg != null) {
				doFeedback(msg);
	}	}	}

	public void groupAll() 
	{
		Diagram			diagram = m_diagram;
		String	msg;

		if (diagram != null) {
			msg = diagram.groupAll(m_resultBox);
			if (msg != null) {
				doFeedback(msg);
	}	}	}

	public JFrame getFrame()
	{
		return(m_frame);
	}

	public JPanel getContentPane()
	{
		return((JPanel) m_contentPane);
	}

	public Feedback getFeedbackBox()
	{
		return m_feedback;
	}

	public Feedback getNameBox()
	{
		return m_nameBox;
	}

	public Diagram getDiagram() 
	{
		return m_diagram;
	}

	protected void setDiagram(Diagram diagram)
	{
		m_diagram = diagram;
	}

	public TextTree getTocBox() 
	{
		return 	m_tocBox;
	}

	public UndoBox getUndoBox()
	{
		return m_undoBox;
	}

	public LegendBox getLegendBox() 
	{
		return 	m_legendBox;
	}

	public MapBox getMapBox()
	{
		return m_mapBox;
	}

	public QueryBox getQueryBox()
	{
		return m_queryBox;
	}

	public ResultBox getResultBox()
	{
		return m_resultBox;
	}

	public AttributeBox getAttributeBox()
	{
		return m_attributeBox;
	}

	public void add(JComponent c)
	{
		m_contentPane.add(c);
	}

	public void repaint()
	{
		m_contentPane.repaint();
	}

	public void validate()
	{
		m_contentPane.validate();
	}

	public void requestFocus()
	{
		m_contentPane.requestFocus();
	}

	public Graphics getGraphics()
	{
		return(m_contentPane.getGraphics());
	}

	public int getHeight()
	{
		return(m_contentPane.getHeight());
	}

	// Returns previous cursor so can stack/unstack

	public int getCursor()
	{
		return m_curCursor;
	}

	public int setCursor(int value) 
	{
		int	ret = m_curCursor;

		if (ret != value) {
			Cursor cursor = Cursor.getPredefinedCursor(value);

			m_curCursor = value;
			if (m_frame != null) {
				m_frame.setCursor(cursor);
			} else {
				m_applet.setCursor(cursor);
			}
/*
			System.out.println("LandscapeEditorCore.setCursor to " + m_frame.getCursor().getName() + "=" + cursor);
			java.lang.Thread.dumpStack();
			System.out.println("-----");
 */
		}
		return ret;
	}

	public void setRightTextBox(String title, String description)
	{
		m_rightTextBoxTitle.setText(title);
		m_rightTextBox.set(description);
	}

	public Enumeration enumEntityClasses() {

		return m_diagram.enumEntityClasses(); 
	}

	public Enumeration enumEntityClassesInOrder() {

		return m_diagram.enumEntityClassesInOrder(); 
	}

	public Enumeration enumRelationClassesInOrder() {

		return m_diagram.enumRelationClassesInOrder(); 
	}

	public void beginUndoRedo(String name)
	{
		if (m_diagram != null) {
			m_diagram.beginUndoRedo(name);
	}	}

	public void endUndoRedo()
	{
		if (m_diagram != null) {
			m_diagram.endUndoRedo();
	}	}

	public Vector getEdits()
	{
		if (m_diagram != null) {
			return m_diagram.getEdits();
		}
		return null;
	}

	public UndoableEdit getEditToBeRedone()
	{
		return m_diagram.getEditToBeRedone();
	}

	public int countEdits()
	{
		return m_diagram.countEdits();
	}

	public void massChange(UndoableEdit undoableEdit, boolean redo)
	{
		if (m_diagram != null) {
			m_diagram.massChange(undoableEdit, redo);
			redrawDg();
			doFeedback("Changes " + (redo ? "redone" : "undone"));
	}	}

	public void discardAllEdits()
	{
		if (m_diagram != null) {
			m_diagram.discardAllEdits();
	}	}

	public int getDiagramX()
	{
		return(m_scrollDiagram.getX());
	}

	public int getDiagramY()
	{
		return(m_scrollDiagram.getY());
	}

	protected void edgeNavigateSrc(Object object) 
	{
		Diagram			 diagram = getDiagram();
		RelationInstance ri      = diagram.targetRelation(object);

		if (ri == null) {
			return;
		}
		followLink(ri.getSrc(), false);
	}

	protected void edgeNavigateDst(Object object) 
	{
		Diagram			 diagram = getDiagram();
		RelationInstance ri      = diagram.targetRelation(object);

		if (ri == null) {
			return;
		}
		followLink(ri.getDst(), false);
	}

	public void setHistoryButtons(HistoryBox historyBox)
	{
		JButton		button     = toolButton[PREV_HISTORY_BUTTON];
		boolean		change     = false;
		boolean		state      = historyBox.hasPrevious();

		if (button.isEnabled() != state) {
			button.setEnabled(state);
			change = true;
		}
		state  = historyBox.hasNext();
		button = toolButton[NEXT_HISTORY_BUTTON];
		if (button.isEnabled() != state) {
			button.setEnabled(state);
			change = true;
		}
		if (change) {
			m_toolBar.revalidate();
	}	}

	public void addHistoryEntity(EntityInstance e)
	{
		HistoryBox historyBox = m_historyBox;

		if (historyBox != null) {
			historyBox.addEntity(e);
			setHistoryButtons(historyBox);
	}	}

	public void updateContainsRelation(RelationClass relationClass)
	{
		if (m_diagram.updateContainsRelation(relationClass)) {
			if (m_legendBox != null) {
				m_legendBox.fillLegendBox();
			}
			if (m_mapBox != null) {
				m_mapBox.fill(m_diagram.getDrawRoot());
			}
			if (m_queryBox != null) {
				m_queryBox.fillQueryBox();
			}
			if (m_tocBox != null) {
				m_tocBox.rebuildTOC();
			}
		}	
	}

	protected void closeEditor()
	{

		if (testForClose(false)) {
			int					i, cnt;
			JMenuItem			item;
			MyWindowsMenuItem	menuItem;

			cnt  = m_windowsMenu.getItemCount();
			for (i = cnt; i > 0; ) {
				item = m_windowsMenu.getItem(--i);
				if (item instanceof MyWindowsMenuItem) {
					menuItem = (MyWindowsMenuItem) item;
					if (menuItem.isDiagram(m_diagram)) {
						m_windowsMenu.remove(i);
						break;
			}	}	}

			cnt  = m_windowsMenu.getItemCount();
			for (i = cnt; i > 0; ) {
				item = m_windowsMenu.getItem(--i);
				if (item instanceof MyWindowsMenuItem) {
					menuItem = (MyWindowsMenuItem) item;
					menuItem.actionPerformed(null);
					return;
			}	}	
			System.exit(0);
		}
	}

	public void clipboardChanged()
	{
		if (m_clipboardBox != null) {
			m_clipboardBox.clipboardChanged();
	}	}

	public void changeEdgeMode(int mode)
	{
		setEdgeMode(mode);
		if (m_diagram != null) {
			m_diagram.setEdgeMode(mode);
	}	}

	public void switchShowClients()
	{
		boolean show = !isShowClients();

		setShowClients(show);
		if (m_diagram != null) {
			m_diagram.setShowClients(show);
	}	}

	public void switchShowSuppliers()
	{
		boolean show = !isShowSuppliers();

		setShowSuppliers(show);
		if (m_diagram != null) {
			m_diagram.setShowSuppliers(show);
	}	}

	public void switchDstCardinals()
	{
		boolean show = !isShowDstCardinals();

		setShowDstCardinals(show);
		if (m_diagram != null) {
			m_diagram.setShowDstCardinals(show);
	}	}

	public void switchTopClients()
	{
		boolean	value = !isTopClients();

		setTopClients(value);
		if (m_diagram != null) {
			m_diagram.setTopClients(value);
	}	}

	// --------------
	// Event handling 
	// --------------

	public void processKey(int key, int modifiers, Object object) 
	{
//		System.out.println("LandscapeEditorCore:processKey(" + key + ", " + modifiers + ", " + object +")");

		String str; 

		if ((modifiers & Event.CTRL_MASK) != 0) {
			switch(key) {
			case Do.GROUP_ALL:
				groupAll();
				redrawDg();
				break;
			case Do.QUIT_PROGRAM:
				if (testForClose(false)) {
					System.exit(0);
				}
				break;
			case Do.CLOSE_LANDSCAPE:
				closeEditor();
				break;
			case Do.NEW_LANDSCAPE:
				loadLs("");
				break;
			case Do.REFRESH:
				redrawDg();
				break;
			case Do.FIND_QUERY:
				find();
				break;
			case Do.SWITCH_TOC:
				if (m_tocBox != null) {
					m_tocBox.switch_TOC();
				}
				break;
			case Do.SET_TO_VIEWPORT:
				if (m_diagram.set_to_viewport()) {
					doFeedback( "Diagram set to viewport");
				}
				break;
			case Do.OPEN_LANDSCAPE:
			{
				Object context = null;
				String txt;

				if (m_diagram != null) {
					context = m_diagram.getContext();
				}
				if (context != null) {
					txt = filePrompt( "Load Landscape", m_diagram.getAbsolutePath(), FA_LOAD, null);
				} else {
					txt = filePrompt("Load Landscape", "", FA_LOAD, null);
				}
				if (txt != null) {
					loadLs(txt);
				}
				break;
			}
			case Do.OPEN_SETTINGS:
			{
				String file = filePrompt("Load settings", defaultIniPath(), FA_LOAD, null);
				if (file != null) {
					loadLseditHistory(m_fileMenu, file);
				}
				redrawDg();
				break;
			}
			case Do.SELECT_BROWSER:
				getBrowser();
				break;
			case Do.PRINT_LANDSCAPE:
			{
				Vista vista = new Vista(this); 
				break;
			}
			case Do.SAVE_AS:
			{
				Object context = m_diagram.getContext();
				String txt;

				if (context != null) {
					txt = filePrompt("Save Landscape As", m_diagram.getAbsolutePath(), FA_SAVE, null);
				} else {
					txt = filePrompt("Save Landscape As", "", FA_SAVE, null);
				}
				if (txt != null && txt.length() != 0) {
					doSaveLs(txt);
				}
				break;
			}
			case Do.SAVE:
				saveLs();
				break;
			case Do.PASTE:
				m_diagram.pasteGroup(object);
				break;
			case Do.CUT_GROUP:
				m_diagram.cutGroup(object);
				break;
			case Do.UNDO:
				if (m_diagram != null) {
					m_diagram.undo();
				}
				break;
			case Do.REDO:
				if (m_diagram != null) {
					m_diagram.redo();
				}
				break;
			}
		} else if ((modifiers & Event.ALT_MASK) != 0) {
			switch (key) {
			case Do.NAVIGATE_TO:
				if(object != null) {
					Diagram diagram = m_diagram;
					if (diagram != null) {
						diagram.navigateTo((EntityInstance) object);
				}	}
				break;
			case Do.EDGE_OPEN_LOW:
			case Do.EDGE_OPEN_SRC:
			case Do.EDGE_OPEN_DST:
			case Do.EDGE_CLOSE_LOW:
			case Do.EDGE_CLOSE_SRC:
			case Do.EDGE_CLOSE_DST:
			{		
				if (m_diagram != null) {
					if (m_diagram.handleEdgeExpansion(key, object, getResultBox())) {
						redrawDg();
				}	}
				break;
			}
			case Do.EDGE_NAVIGATE_SRC:
				edgeNavigateSrc(object);
				break;
			case Do.EDGE_NAVIGATE_DST:
				edgeNavigateDst(object);
				break;
			case Do.NEXT_HISTORY:
				if (m_historyBox != null) {
					m_historyBox.navigateNext();
				}
				break;
			case Do.PREV_HISTORY:
				if (m_historyBox != null) {
					m_historyBox.navigatePrevious();
				}
				break;
			case Do.CONTENT_CLOSURE:
			{		
				if (m_diagram != null) {
					m_diagram.queryContents(key, getResultBox(), isGroupQuery());
					redrawDg();
				}
				break;
			}
			case Do.QUERY_PERSIST:
			{
				boolean state = !isQueryPersist();
				setQueryPersist(state);
				doFeedback("Query persistence set to: " + (state ? "On" : "Off"));
				break;
			}
			case Do.TB_EDGE:
				changeEdgeMode(Do.TB_EDGE_STATE);
				navigateTo(m_diagram.getDrawRoot());
				doFeedback("Edge mode set to: top/bottom."); 
				break;
			case Do.SIDE_EDGE:
				changeEdgeMode(Do.SIDE_EDGE_STATE);
				navigateTo(m_diagram.getDrawRoot());
				doFeedback("Edge mode set to: direct+side."); 
				break;

			case Do.SHOW_DESC:
			{	
				boolean		show = !isShowDesc();

				setShowDesc(show);
				setVisibility(m_leftTextBoxTitle, show);
				setVisibility(m_scrollLeftTextBox, show);
				setVisibility(m_rightTextBoxTitle, show);
				setVisibility(m_scrollRightTextBox, show);
				computeMinInfoHeight();
//				m_leftPanel.revalidate();
//				m_rightPanel.revalidate();
				m_secondSplitPane.revalidate();
				
//				validate();
//				repaint();
				break;
			}
			case Do.SHOW_FB:
			{
				boolean show = !isShowFeedback();

				setShowFeedback(show);
				setVisibility(m_feedback, show);
				setVisibility(m_nameBox,  show); 
				computeMinInfoHeight();
//				m_leftPanel.revalidate();
//				m_rightPanel.revalidate();
				m_secondSplitPane.revalidate();

//				validate();
//				repaint();
				break;
			}
			case Do.SHOW_CLIENTS:
			{
				switchShowClients();
				navigateTo(m_diagram.getDrawRoot());
				break;
			}
			case Do.SHOW_SUPPLIERS:
			{
				switchShowSuppliers();
				navigateTo(m_diagram.getDrawRoot());
				break;
			}
			case Do.TOP_CLIENTS:
				switchTopClients();
				navigateTo(m_diagram.getDrawRoot());
				break;
			case Do.SHOW_DST_CARDINALS:
			{
				switchDstCardinals();
				m_diagram.redrawDiagram();
				break;
			}
			case Do.SHOW_SRC_CARDINALS:
			{
				boolean show = !isShowSrcCardinals();

				setShowSrcCardinals(show);
				m_diagram.redrawDiagram();
				break;
			}
			case Do.FOCUS_ANCESTOR:
			{
				boolean value = !isFocusAncestor();
				setFocusAncestor(value);
				break;
			}
			case Do.SORT_TOC:
			{
				boolean value = !isSortTOC();
				setSortTOC(value);
				if (m_tocBox != null) {
					m_tocBox.rebuildTOC();
				}
				break;
			}

			case Do.USE_COMPACTION:
			{
				boolean use = !isUseCompaction();
				setUseCompaction(use);
				m_diagram.redrawDiagram();
				break;
			}
			case Do.FIX_SCROLLBARS:
			{
				boolean state;

				state = !isFixScrollBars();
				setFixScrollBars(state);
				if (state) {
					m_scrollDiagram.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_ALWAYS);
					m_scrollDiagram.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_ALWAYS);
					doFeedback("Diagram scroll bars permanently enabled");
				} else {
					m_scrollDiagram.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED);
					m_scrollDiagram.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED);
					doFeedback("Diagram scroll bars will appear as needed");
				}
				break;
			}
			case LEFT_TABBOX:
			{
				boolean		state;
				JComponent	left, right;
				Dimension	min;
				int			divider;

				state = !isLeftTabbox();
				setLeftTabbox(state);
				
				m_mainSplitPane.setLeftComponent(null);
				m_mainSplitPane.setRightComponent(null);

				if (state) {
					left    = m_rightTabbedPane;
					right   = m_secondSplitPane;
				} else {
					left    = m_secondSplitPane;
					right   = m_rightTabbedPane;
				}
				divider = left.getWidth();

				min    = new Dimension(100,50);
				left.setMinimumSize(min);
				right.setMinimumSize(min);
				m_mainSplitPane.setLeftComponent(left);
				m_mainSplitPane.setRightComponent(right);
				m_mainSplitPane.setDividerLocation(divider);

//				If either min width is zero slider won't move
//				System.out.println("Min " + m_mainSplitPane.getMinimumDividerLocation() + " Max " + m_mainSplitPane.getMaximumDividerLocation()); 

				break;
			}
			case TABS_SCROLL:
			{
				boolean state;

				state = !isTabsScroll();
				setTabsScroll(state);
				m_rightTabbedPane.setTabsScroll(state);
				break;
			}
			case VISIBLE_EDGES:
			{
				boolean state = !isVisibleEdges();
				setVisibleEdges(state);
				redrawDg();
				break;
			}
			case VISIBLE_ENTITIES:
			{
				boolean state = !isVisibleEntities();
				setVisibleEntities(state);
				redrawDg();
				break;
			}
			case Do.TOC_HIDDEN:
			{
				boolean show = !isTocHidden();

				setTocHidden(show);
				break;
			}
			case Do.TOC_PATH:
				if (m_tocBox != null) {
					m_tocBox.toc_path();
				}
				break;
			case Do.A_HORIZ_TOP:
				beginUndoRedo("Align top");
				alignTop();
				endUndoRedo();
				break;
			case Do.A_HORIZ_CENTER:
				beginUndoRedo("Align horizontal center");
				alignHorizontal();
				endUndoRedo();
				break;
			case Do.A_HORIZ_BOTTOM:
				beginUndoRedo("Align bottom");
				alignBottom();
				endUndoRedo();
				break;
			case Do.A_VERTICAL_LEFT:
				beginUndoRedo("Align vertical left");
				alignLeft();
				endUndoRedo();
				break;
			case Do.A_VERTICAL_RIGHT:
				beginUndoRedo("Align vertical right");
				alignRight();
				endUndoRedo();
				break;
			case Do.A_VERTICAL_CENTER:
				beginUndoRedo("Align vertical center");
				alignVertical();
				endUndoRedo();
				break;
			case Do.A_FIT_LABEL:
				beginUndoRedo("Fit label");
				fitToLabel();
				endUndoRedo();
				break;
			case Do.A_GROUP:
				updateCreateContainedGroup();
				break;
			case Do.SZ_WIDTH:
				beginUndoRedo("Same width");
				sameWidth();
				endUndoRedo();
				break;
			case Do.SZ_HEIGHT:
				beginUndoRedo("Same height");
				sameHeight();
				endUndoRedo();
				break;
			case Do.SZ_WIDTH_HEIGHT:
				beginUndoRedo("Same size");
				sameSize();
				endUndoRedo();
				break;
			case Do.SPC_HORIZ:
				beginUndoRedo("Space horizontally");
				equalSpacing(key);
				endUndoRedo();
				break;
			case Do.SPC_VERTICAL:
				beginUndoRedo("Space vertically");
				equalSpacing(key);
				endUndoRedo();
				break;
			case Do.RELAYOUT_ALL:
			{
				String msg = m_diagram.relayoutAll();
				if (msg != null) {
					doFeedback(msg);
				}
				repaintDg();
				break;
			}
			case Do.CLOSE_ALL:
			{
				String msg = m_diagram.closeAll();
				if (msg != null) {
					doFeedback(msg);
				}
				repaintDg();
				break;
			}
			case Do.OPEN_ALL:
			{
				String msg = m_diagram.openAll();
				if (msg != null) {
					doFeedback(msg);
				}
				repaintDg();
				break;
			}
			case Do.SET_FONT:
			{
				FontChooser fontChooser = new FontChooser(m_frame, this);

				fontChooser.dispose();
				break;
			}
			case Do.DECREASE_MAG:
			case Do.INCREASE_MAG:
			{
				String			msg;

				if (m_diagram != null) {
					beginUndoRedo("Magnify");
					msg = m_diagram.scaleEntity(key, !m_editModeHandler.mouseIsDown());
					endUndoRedo();
					if (msg != null) {
						doFeedback(msg);
					}
					redrawDg();
				}
				break;
			}
			case Do.NEW_ECLASS:
			{
				Diagram		   diagram = getDiagram();
				if (diagram != null) {
					if (diagram.newEntityClass()) {
						classChanges();
				}	}
				break;
			}
			case Do.NEW_RCLASS:
			{
				Diagram		   diagram = getDiagram();
				if (diagram != null) {
					if (diagram.newRelationClass()) {
						classChanges();
				}	}
				break;
			}
			case Do.VALIDATE_ALL:
				validateAll();
				break;
			case Do.ARROW_DIMENSIONS:
				ArrowDimensions.create(this);
				repaint();
				break;
			}
		} else if (modifiers == Event.SHIFT_MASK) {
			// Only used for special keys
			switch (key) {
			case Do.ASCEND:	// Special key SHIFT still set
			{
				Diagram diagram = m_diagram;

				if (diagram != null) {
					diagram.navigateToDrawRootParent();
					redrawDg();
				}
				break;
			}
			case Do.TOGGLE_RELATION_ALL:
			case Do.TOGGLE_RELATION_1:
			case Do.TOGGLE_RELATION_2:
			case Do.TOGGLE_RELATION_3:
			case Do.TOGGLE_RELATION_4:
			case Do.TOGGLE_RELATION_5:
			case Do.TOGGLE_RELATION_6:
			case Do.TOGGLE_RELATION_7:
			case Do.TOGGLE_RELATION_8:
			case Do.TOGGLE_RELATION_9:
				m_queryBox.activate();
				m_queryBox.toggleRelationActivity(key - Do.TOGGLE_RELATION_ALL);
				repaintDg();
				requestFocus();
				break;
			}
		} else if (modifiers == 0) { 
			switch (key) {
			case Do.ESCAPE:	/* Escape */
				m_diagram.clearFlags();
				doFeedback("Query/selection cleared");
				m_diagram.setPreserveEntityMarks(0);
				m_diagram.setPreserveRelationMarks(0);
				redrawDg();
				m_resultBox.clear();
				m_editModeHandler.cleanup();
				break;
			case Do.CONTENTS_QUERY:
			{	
				if (m_diagram != null) {	
					m_diagram.queryContents(key, getResultBox(), isGroupQuery());
					redrawDg();
				}
				break;
			}
			case Do.FORWARD_QUERY:
			case Do.FORWARD_CLOSURE:
			case Do.BACKWARD_QUERY:
			case Do.BACKWARD_CLOSURE:
			{
				if (m_diagram != null) {		
					m_diagram.queryEntity(key, object, getResultBox(), isGroupQuery());
					redrawDg();
				}
				break;
			}
			case Do.SHOW_CONTENTS:
			case Do.DST_EDGES:
			case Do.ENTERING_EDGES:
			case Do.SRC_EDGES:
			case Do.EXITING_EDGES:
			case Do.INTERNAL_EDGES:
			{
				String			msg;

				if (m_diagram != null) {
					msg = m_diagram.handleElision(key, object);
					if (msg != null) {
						doFeedback(msg);
					}
					redrawDg();
				}
				break;
			}
			case Do.DECREASE_WIDTH:
			case Do.INCREASE_WIDTH:
			case Do.DECREASE_HEIGHT:
			case Do.INCREASE_HEIGHT:
			case Do.DECREASE_SIZE:
			case Do.INCREASE_SIZE:
			{
				String			msg;

				if (m_diagram != null) {
					beginUndoRedo("Scale");
					msg = m_diagram.scaleEntity(key, !m_editModeHandler.mouseIsDown());
					endUndoRedo();
					if (msg != null) {
						doFeedback(msg);
					}
					redrawDg();
				}
				break;
			}
			case Do.MOVE_GROUP_UP:
			case Do.MOVE_GROUP_DOWN:
			case Do.MOVE_GROUP_LEFT:
			case Do.MOVE_GROUP_RIGHT:
				beginUndoRedo("Move");
				m_editModeHandler.moveGroup(key);
				endUndoRedo();
				redrawDg();
				break;

			case Do.DESCEND:
			{
				Diagram			diagram = getDiagram();

				if (diagram != null) {
					EntityInstance	e       = diagram.targetEntity(object);
					if (e != null) {
						EntityInstance drawRoot = diagram.getDrawRoot();

						if (e == drawRoot) {
							error("Already in: " + e.getEntityLabel());
						} else if (e == drawRoot.getContainedBy()) {
							// Going up
							followLink(e, false);
						} else if (e.isClientOrSupplier()) {
							if (e.hasChildren()) {
								followLink(e, false);
							} else {
								followLink(e.getContainedBy(), false);
							}
						} else {
							// Going down
							followLink(e, false);
						}
						redrawDg();
				}	}
				break;
			}
			case Do.DELETE:
				m_diagram.doDelete(object);
				break;
			case Do.INCREASE_LABEL_FONT:
				beginUndoRedo("Increase Font");
				shiftDeltaFont(1);
				endUndoRedo();
				redrawDg();
				break;
			case Do.DECREASE_LABEL_FONT: 
				beginUndoRedo("Decrease Font");
				shiftDeltaFont(-1);
				endUndoRedo();
				redrawDg();
				break;
			case Do.NEW_EDGE:
			{
				m_editModeHandler.newEdge(object);
				break;
			}
			case Do.NEW_ENTITY:
			{
				Diagram		   diagram = getDiagram();
				if (diagram != null) {
					EntityInstance e = diagram.targetEntity(object);
					if (e != null) {
						updateNewEntity(e, null);
						redrawDg();
				}	}
				break;
			}

			case Do.EDIT_ENTITY_CLASS:
			{
				Diagram	diagram = getDiagram();
				if (diagram != null) {
					LandscapeObject landscapeObject = diagram.targetEntityRelation(object);
					if (landscapeObject != null) {
						if (landscapeObject instanceof EntityInstance) {
							EntityInstance e = (EntityInstance) landscapeObject;
							// edit class attributes
							EditAttribute.Create(this, e.getEntityClass());
						} else {
							RelationInstance ri = (RelationInstance) landscapeObject;
							// edit class attributes
							EditAttribute.Create(this, ri.getRelationClass());
						}
						redrawDg();
				}	}
				break;
			}
			case Do.EDIT_ATTRIBUTES:
			{
				Diagram			diagram         = getDiagram();
				if (diagram != null) {
					LandscapeObject landscapeObject = diagram.targetEntityRelation(object);
					if (landscapeObject != null) {
						if (landscapeObject instanceof EntityInstance) {
							EntityInstance e = (EntityInstance) landscapeObject;
							// edit attributes
							EditAttribute.Create(this, e);
						} else {
							RelationInstance ri = (RelationInstance) landscapeObject;
							// edit attributes
							EditAttribute.Create(this, ri);
						}
						redrawDg();
				}	}
				break;
			}
			case Do.DELETE_CONTAINER:
			{
				Diagram			diagram = getDiagram();
				if (diagram != null) {
					EntityInstance	e       = diagram.targetEntity(object);
					if (e != null) {
						if (deleteContainer(e)) {
							redrawDg();
				}	}	}
				break;
			}
			case Do.MOVE_REDBOXES:
				moveRedBoxes(object);
				redrawDg();
				break;
			case Do.TOGGLE_LEGEND_ALL:
			case Do.TOGGLE_LEGEND_1:
			case Do.TOGGLE_LEGEND_2:
			case Do.TOGGLE_LEGEND_3:
			case Do.TOGGLE_LEGEND_4:
			case Do.TOGGLE_LEGEND_5:
			case Do.TOGGLE_LEGEND_6:
			case Do.TOGGLE_LEGEND_7:
			case Do.TOGGLE_LEGEND_8:
			case Do.TOGGLE_LEGEND_9:
				m_legendBox.activate();
				m_legendBox.toggleRelationVisibility(key - Do.TOGGLE_LEGEND_ALL);
				redrawDg();
				requestFocus();
				break;
			case Do.FIND_PREV:
				findPrev();
				break;
			case Do.FIND_NEXT:
				findNext();
				break;
			case Do.LIFT_EDGES:
			{
				boolean show = !isLiftEdges();

				setLiftEdges(show);
				m_diagram.revalidate();
				break;
			}
			case Do.GROUP_QUERY:
			{
				boolean value = !isGroupQuery();
				setGroupQuery(value);
				m_queryBox.setGroupQuery(value);
				break;
			}
			case Do.SET_GRID:
			{
				int	grid = m_diagram.setNewGridValue();

				if (grid >= 0) {
					doFeedback("Grid set to " + grid + " pixels");
				}
				break;
			}
			case Do.SHOW_GRID:
			{
				boolean show = !isShowGrid();

				setShowGrid(show);
				if (isShowGrid()) {
					int		grid = m_diagram.getGrid();
					if (grid < 2) {
						error("Can't currently show grid since grid size is " + grid + ".");
				}	}
				m_diagram.repaint();
				break;
			}
			case Do.ABOUT_PROGRAM:
				JOptionPane.showMessageDialog(m_frame, 	getTitle() + " " + Version.Details(getDiagram()), "About " + getTitle(), JOptionPane.OK_OPTION);
				break;
			case Do.ABOUT_URL:
				about();
				break;
			case Do.HELP_URL:
				help();
				break;
			case Do.DIRECT_EDGE:
				changeEdgeMode(Do.DIRECT_EDGE_STATE);
				navigateTo(m_diagram.getDrawRoot());
				doFeedback("Edge mode set to: direct."); 
				break;
			case Do.INFLECTION_EDGE:
				changeEdgeMode(Do.INFLECTION_EDGE_STATE);
				navigateTo(m_diagram.getDrawRoot());
				doFeedback("Edge mode set to: inflection point edge."); 
				break;
			}
		}
		return;
	}

	public Font getFont()
	{
		if (m_frame != null) {
			return m_frame.getFont();
		} 
		return m_applet.getFont();
	}

	public String getDefaultFontName(int target)
	{
		String value;

		switch (target) {
		case FontChooser.TARGET_ALL:
			value = FontCache.DEFAULT_FONT_NAME;
			break;
		case FontChooser.TARGET_OPEN_CLASS:	// Open Entity
			value = EntityInstance.DEFAULT_OPEN_CLASS_FONT_NAME;
			break;
		case FontChooser.TARGET_CLOSED:	// Closed Entity
			value = EntityInstance.DEFAULT_CLOSED_FONT_NAME;
			break;
		case FontChooser.TARGET_OPEN:	// Small Font
			value = EntityInstance.DEFAULT_SMALL_FONT_NAME;
			break;
		case FontChooser.TARGET_CARDINALS:	// Cardinals
			value = Cardinal.DEFAULT_CARDINAL_FONT_NAME;
			break;
		case FontChooser.TARGET_CLIENTS:
			value = ClientSupplierSet.DEFAULT_CLIENT_FONT_NAME;
			break;
		case FontChooser.TARGET_RESULTS_TITLE:
			value = ResultBox.DEFAULT_RESULT_TITLE_FONT_NAME;
			break;
		case FontChooser.TARGET_RESULTS_TEXT:
			value = ResultBox.DEFAULT_RESULT_TEXT_FONT_NAME;
			break;
		case FontChooser.TARGET_LEGEND_TITLE:
			value = LegendBox.DEFAULT_LEGEND_TITLE_FONT_NAME;
			break;
		case FontChooser.TARGET_LEGEND_TEXT:
			value = LegendBox.DEFAULT_LEGEND_TEXT_FONT_NAME;
			break;
		case FontChooser.TARGET_QUERY_TITLE:
			value = QueryBox.DEFAULT_QUERY_TITLE_FONT_NAME;
			break;
		case FontChooser.TARGET_QUERY_TEXT:
			value = QueryBox.DEFAULT_QUERY_TEXT_FONT_NAME;
			break;
		case FontChooser.TARGET_TOC:
			value = TextTree.DEFAULT_TOC_FONT_NAME;
			break;
		case FontChooser.TARGET_UNDO:
			value = UndoBox.DEFAULT_UNDO_FONT_NAME;
			break;
		case FontChooser.TARGET_HISTORY:
			value = HistoryBox.DEFAULT_HISTORY_FONT_NAME;
			break;
		case FontChooser.TARGET_MAP:
			value = MapBox.DEFAULT_MAP_FONT_NAME;
			break;
		case FontChooser.TARGET_CLIPBOARD:
			value = ClipboardBox.DEFAULT_CLIPBOARD_FONT_NAME;
			break;
		case FontChooser.TARGET_TITLE:
			value = TextBox.DEFAULT_TEXT_TITLE_FONT_NAME;
			break;
		case FontChooser.TARGET_TEXTBOX:
			value = TextBox.DEFAULT_TEXT_TEXT_FONT_NAME;
			break;
		case FontChooser.TARGET_FEEDBACK:
			value = Feedback.DEFAULT_FEEDBACK_FONT_NAME;
			break;
		case FontChooser.TARGET_MENU:
			value = FontCache.DEFAULT_MENU_FONT_NAME;
			break;
		case FontChooser.TARGET_DIALOG:
			value = FontCache.DEFAULT_DIALOG_FONT_NAME;
			break;
		case FontChooser.TARGET_ATTR_TITLE:
			value = AttributeBox.DEFAULT_ATTRIBUTE_TITLE_FONT_NAME;
			break;
		case FontChooser.TARGET_ATTR_TEXT:
			value = AttributeBox.DEFAULT_ATTRIBUTE_TEXT_FONT_NAME;
			break;
		default:
			System.out.println("LandscapeEditorCore.getDefaultFontName() Illegal target " + target);
			value = FontCache.DEFAULT_FONT_NAME;
		}
		return(value);
	}

	public int getDefaultFontStyle(int target)
	{
		int value;

		switch (target) {
		case FontChooser.TARGET_ALL:
			value = FontCache.DEFAULT_FONT_STYLE;
			break;
		case FontChooser.TARGET_OPEN_CLASS:	// Open Entity
			value = EntityInstance.DEFAULT_OPEN_CLASS_FONT_STYLE;
			break;
		case FontChooser.TARGET_CLOSED:	// Closed Entity
			value = EntityInstance.DEFAULT_CLOSED_FONT_STYLE;
			break;
		case FontChooser.TARGET_OPEN:	// Small Font
			value = EntityInstance.DEFAULT_SMALL_FONT_STYLE;
			break;
		case FontChooser.TARGET_CARDINALS:	// Cardinals
			value = Cardinal.DEFAULT_CARDINAL_FONT_STYLE;
			break;
		case FontChooser.TARGET_CLIENTS:
			value = ClientSupplierSet.DEFAULT_CLIENT_FONT_STYLE;
			break;
		case FontChooser.TARGET_RESULTS_TITLE:
			value = ResultBox.DEFAULT_RESULT_TITLE_FONT_STYLE;
			break;
		case FontChooser.TARGET_RESULTS_TEXT:
			value = ResultBox.DEFAULT_RESULT_TEXT_FONT_STYLE;
			break;
		case FontChooser.TARGET_LEGEND_TITLE:
			value = LegendBox.DEFAULT_LEGEND_TITLE_FONT_STYLE;
			break;
		case FontChooser.TARGET_LEGEND_TEXT:
			value = LegendBox.DEFAULT_LEGEND_TEXT_FONT_STYLE;
			break;
		case FontChooser.TARGET_QUERY_TITLE:
			value = QueryBox.DEFAULT_QUERY_TITLE_FONT_STYLE;
			break;
		case FontChooser.TARGET_QUERY_TEXT:
			value = QueryBox.DEFAULT_QUERY_TEXT_FONT_STYLE;
			break;
		case FontChooser.TARGET_TOC:
			value = TextTree.DEFAULT_TOC_FONT_STYLE;
			break;
		case FontChooser.TARGET_UNDO:
			value = UndoBox.DEFAULT_UNDO_FONT_STYLE;
			break;
		case FontChooser.TARGET_HISTORY:
			value = HistoryBox.DEFAULT_HISTORY_FONT_STYLE;
			break;
		case FontChooser.TARGET_MAP:
			value = MapBox.DEFAULT_MAP_FONT_STYLE;
			break;
		case FontChooser.TARGET_CLIPBOARD:
			value = ClipboardBox.DEFAULT_CLIPBOARD_FONT_STYLE;
			break;
		case FontChooser.TARGET_TITLE:
			value = TextBox.DEFAULT_TEXT_TITLE_FONT_STYLE;
			break;
		case FontChooser.TARGET_TEXTBOX:
			value = TextBox.DEFAULT_TEXT_TEXT_FONT_STYLE;
			break;
		case FontChooser.TARGET_FEEDBACK:
			value = Feedback.DEFAULT_FEEDBACK_FONT_STYLE;
			break;
		case FontChooser.TARGET_MENU:
			value = FontCache.DEFAULT_MENU_FONT_STYLE;
			break;
		case FontChooser.TARGET_DIALOG:
			value = FontCache.DEFAULT_DIALOG_FONT_STYLE;
			break;
		case FontChooser.TARGET_ATTR_TITLE:
			value = AttributeBox.DEFAULT_ATTRIBUTE_TITLE_FONT_STYLE;
			break;
		case FontChooser.TARGET_ATTR_TEXT:
			value = AttributeBox.DEFAULT_ATTRIBUTE_TEXT_FONT_STYLE;
			break;

		default:
			System.out.println("LandscapeEditorCore.getDefaultFontStyle() Illegal target " + target);
			value = FontCache.DEFAULT_FONT_STYLE;
		}
		return(value);
	}

	public int getDefaultFontSize(int target)
	{
		int value;

		switch (target) {
		case FontChooser.TARGET_ALL:
			value = FontCache.DEFAULT_FONT_SIZE;
			break;
		case FontChooser.TARGET_OPEN_CLASS:	// Open Entity
			value = EntityInstance.DEFAULT_OPEN_CLASS_FONT_SIZE;
			break;
		case FontChooser.TARGET_CLOSED:	// Closed Entity
			value = EntityInstance.DEFAULT_CLOSED_FONT_SIZE;
			break;
		case FontChooser.TARGET_OPEN:	// Small Font
			value = EntityInstance.DEFAULT_SMALL_FONT_SIZE;
			break;
		case FontChooser.TARGET_CARDINALS:	// Cardinals
			value = Cardinal.DEFAULT_CARDINAL_FONT_SIZE;
			break;
		case FontChooser.TARGET_CLIENTS:
			value = ClientSupplierSet.DEFAULT_CLIENT_FONT_SIZE;
			break;
		case FontChooser.TARGET_RESULTS_TITLE:
			value = ResultBox.DEFAULT_RESULT_TITLE_FONT_SIZE;
			break;
		case FontChooser.TARGET_RESULTS_TEXT:
			value = ResultBox.DEFAULT_RESULT_TEXT_FONT_SIZE;
			break;
		case FontChooser.TARGET_LEGEND_TITLE:
			value = LegendBox.DEFAULT_LEGEND_TITLE_FONT_SIZE;
			break;
		case FontChooser.TARGET_LEGEND_TEXT:
			value = LegendBox.DEFAULT_LEGEND_TEXT_FONT_SIZE;
			break;
		case FontChooser.TARGET_QUERY_TITLE:
			value = QueryBox.DEFAULT_QUERY_TITLE_FONT_SIZE;
			break;
		case FontChooser.TARGET_QUERY_TEXT:
			value = QueryBox.DEFAULT_QUERY_TEXT_FONT_SIZE;
			break;
		case FontChooser.TARGET_TOC:
			value = TextTree.DEFAULT_TOC_FONT_SIZE;
			break;
		case FontChooser.TARGET_UNDO:
			value = UndoBox.DEFAULT_UNDO_FONT_SIZE;
			break;
		case FontChooser.TARGET_HISTORY:
			value = HistoryBox.DEFAULT_HISTORY_FONT_SIZE;
			break;
		case FontChooser.TARGET_MAP:
			value = MapBox.DEFAULT_MAP_FONT_SIZE;
			break;
		case FontChooser.TARGET_CLIPBOARD:
			value = ClipboardBox.DEFAULT_CLIPBOARD_FONT_SIZE;
			break;
		case FontChooser.TARGET_TITLE:
			value = TextBox.DEFAULT_TEXT_TITLE_FONT_SIZE;
			break;
		case FontChooser.TARGET_TEXTBOX:
			value = TextBox.DEFAULT_TEXT_TEXT_FONT_SIZE;
			break;
		case FontChooser.TARGET_FEEDBACK:
			value = Feedback.DEFAULT_FEEDBACK_FONT_SIZE;
			break;
		case FontChooser.TARGET_MENU:
			value = FontCache.DEFAULT_MENU_FONT_SIZE;
			break;
		case FontChooser.TARGET_DIALOG:
			value = FontCache.DEFAULT_DIALOG_FONT_SIZE;
		case FontChooser.TARGET_ATTR_TITLE:
			value = AttributeBox.DEFAULT_ATTRIBUTE_TITLE_FONT_SIZE;
			break;
		case FontChooser.TARGET_ATTR_TEXT:
			value = AttributeBox.DEFAULT_ATTRIBUTE_TEXT_FONT_SIZE;
			break;
		default:
			System.out.println("LandscapeEditorCore.getDefaultFontSize() Illegal target " + target);
			value = FontCache.DEFAULT_FONT_SIZE;
		}
		return(value);
	}

	public Font getTargetFont(int target)
	{
		Font font;

		switch (target) {
		case FontChooser.TARGET_ALL:
			font = FontCache.get("Helvetica", Font.PLAIN, 12);
			break;
		case FontChooser.TARGET_OPEN_CLASS:	// Open Entity
			font = EntityInstance.getOpenClassFont();
			break;
		case FontChooser.TARGET_CLOSED:	// Closed Entity
			font = EntityInstance.getClosedFont();
			break;
		case FontChooser.TARGET_OPEN:	// Small Font
			font = EntityInstance.getSmallFont();
			break;
		case FontChooser.TARGET_CARDINALS:	// Cardinals
			font = Cardinal.m_font;
			break;
		case FontChooser.TARGET_CLIENTS:
			font = ClientSupplierSet.getClientSupplierFont();
			break;
		case FontChooser.TARGET_RESULTS_TITLE:
			font = ResultBox.getTitleFont();
			break;
		case FontChooser.TARGET_RESULTS_TEXT:
			font = ResultBox.getTextFont();
			break;
		case FontChooser.TARGET_LEGEND_TITLE:
			font = LegendBox.getTitleFont();
			break;
		case FontChooser.TARGET_LEGEND_TEXT:
			font = LegendBox.getTextFont();
			break;
		case FontChooser.TARGET_QUERY_TITLE:
			font = QueryBox.getTitleFont();
			break;
		case FontChooser.TARGET_QUERY_TEXT:
			font = QueryBox.getTextFont();
			break;
		case FontChooser.TARGET_TOC:
			font = TextTree.getTextFont();
			break;
		case FontChooser.TARGET_UNDO:
			font = UndoBox.getTextFont();
			break;
		case FontChooser.TARGET_HISTORY:
			font = HistoryBox.getTextFont();
			break;
		case FontChooser.TARGET_MAP:
			font = MapBox.getTextFont();
			break;
		case FontChooser.TARGET_CLIPBOARD:
			font = ClipboardBox.getTextFont();
			break;
		case FontChooser.TARGET_TITLE:
			font = TextBox.getTitleFont();
			break;
		case FontChooser.TARGET_TEXTBOX:
			font = TextBox.getTextFont();
			break;
		case FontChooser.TARGET_FEEDBACK:
			font = Feedback.getTextFont();
			break;
		case FontChooser.TARGET_MENU:
			font = FontCache.getMenuFont();
			break;
		case FontChooser.TARGET_DIALOG:
			font = FontCache.getDialogFont();
			break;
		case FontChooser.TARGET_ATTR_TITLE:
			font = AttributeBox.getTitleFont();
			break;
		case FontChooser.TARGET_ATTR_TEXT:
			font = AttributeBox.getTextFont();
			break;

		default:
			System.out.println("LandscapeEditorCore.getTargetFont() Illegal target " + target);
			font = null;
		}
		return(font);
	}

	public void setTargetFont(int target, Font font)
	{
		switch (target) {
		case FontChooser.TARGET_ALL:
			break;
		case FontChooser.TARGET_OPEN_CLASS:
			EntityInstance.setOpenClassFont(font);
			break;
		case FontChooser.TARGET_CLOSED:
			EntityInstance.setClosedFont(font);
			break;
		case FontChooser.TARGET_OPEN:
			EntityInstance.setSmallFont(font);
			break;
		case FontChooser.TARGET_CARDINALS:
			Cardinal.setDefaultFont(font);
			break;
		case FontChooser.TARGET_CLIENTS:
			ClientSupplierSet.setClientSupplierFont(font);
			break;
		case FontChooser.TARGET_LEGEND_TITLE:
			m_legendBox.setTitleFont(font);
			if (m_legendBox != null) {
				m_legendBox.titleFontChanged(font);
			}
			break;
		case FontChooser.TARGET_LEGEND_TEXT:
			LegendBox.setTextFont(font);
			if (m_legendBox != null) {
				m_legendBox.textFontChanged(font);
			}
			break;
		case FontChooser.TARGET_RESULTS_TITLE:
			ResultBox.setTitleFont(font);
			break;
		case FontChooser.TARGET_RESULTS_TEXT:
			ResultBox.setTextFont(font);
			break;
		case FontChooser.TARGET_QUERY_TITLE:
			QueryBox.setTitleFont(font);
			if (m_queryBox != null) {
				m_queryBox.titleFontChanged(font);
			}
			break;
		case FontChooser.TARGET_QUERY_TEXT:
			QueryBox.setTextFont(font);
			if (m_queryBox != null) {
				m_queryBox.textFontChanged(font);
			}
			break;
		case FontChooser.TARGET_TOC:
			TextTree.setTextFont(font);
			if (m_tocBox != null) {
				m_tocBox.textFontChanged(font);
			}
			break;
		case FontChooser.TARGET_UNDO:
			UndoBox.setTextFont(font);
			if (m_undoBox != null) {
				m_undoBox.textFontChanged(font);
			}
			break;
		case FontChooser.TARGET_HISTORY:
			HistoryBox.setTextFont(font);
			if (m_historyBox != null) {
				m_historyBox.textFontChanged(font);
			}
			break;
		case FontChooser.TARGET_MAP:
			MapBox.setTextFont(font);
			if (m_mapBox != null) {
				m_mapBox.textFontChanged(font);
			}
			break;
		case FontChooser.TARGET_CLIPBOARD:
			ClipboardBox.setTextFont(font);
			if (m_clipboardBox != null) {
				m_clipboardBox.textFontChanged(font);
			}
			break;
		case FontChooser.TARGET_TITLE:
			TextBox.setTitleFont(font);
			if (m_leftTextBoxTitle != null) {
				m_leftTextBoxTitle.setFont(font);
			}
			if (m_rightTextBoxTitle != null) {
				m_rightTextBoxTitle.setFont(font);
			}
			break;
		case FontChooser.TARGET_TEXTBOX:
			TextBox.setTextFont(font);
			if (m_leftTextBox != null) {
				m_leftTextBox.textFontChanged(font);
			}
			if (m_rightTextBox != null) {
				m_rightTextBox.textFontChanged(font);
			}
			break;
		case FontChooser.TARGET_FEEDBACK:
			Feedback.setTextFont(font);
			if (m_feedback != null) {
				m_feedback.textFontChanged(font);
			}
			if (m_nameBox != null) {
				m_nameBox.textFontChanged(font);
			}
			break;
		case FontChooser.TARGET_MENU:
			setMenuFont(font);
			break;
		case FontChooser.TARGET_DIALOG:
			FontCache.setDialogFont(font);
			break;
		case FontChooser.TARGET_ATTR_TITLE:
			AttributeBox.setTitleFont(font);
			break;
		case FontChooser.TARGET_ATTR_TEXT:
			AttributeBox.setTextFont(font);
			break;

	}	}

	public void setTargetFont(int target, Font font, boolean name_default, boolean style_default, boolean size_default)
	{
		if (target == FontChooser.TARGET_ALL) {

			int	i;

			for (i = 0; i <= FontChooser.TARGET_LAST; ++i) {
				if (i == target) {
					continue;
				}
				if (name_default || style_default || size_default) {
					String  name;
					int		style;
					int		size;

					if (name_default) {
						name = getDefaultFontName(i);
					} else {
						name = font.getName();
					}
					if (style_default) {
						style = getDefaultFontStyle(i);
					} else {
						style = font.getStyle();
					}
					if (size_default) {
						size  = getDefaultFontSize(i);
					} else {
						size  = font.getSize();
					}
					setTargetFont(i, FontCache.get(name, style, size));
				} else {
					setTargetFont(i, font);
			}	}
		} else {
			setTargetFont(target, font);
			redrawDg();
	}	}

	public void handicapped(int size)
	{
		Font	font = FontCache.get("Dialog", Font.BOLD, size);

		setTargetFont(FontChooser.TARGET_ALL, font, true, true, false);
	}

	public int	remapToFontChooserId(int i)
	{
		// Return the font chooser number corresponding to external id if these differ
		if (i < 0 || i > FontChooser.TARGET_LAST) {
			return -1;
		}
		return i;
	}

	private void saveFonts(BufferedWriter bufferedWriter)
	{
		int		i;		// The number assigned externally
		int		target;	// The font chooser code for this font
		Font	font;
		String	name, default_name;
		int		style, default_style;
		int		size, default_size;
		String	s;

		try {
			for (i = 0; i <= FontChooser.TARGET_LAST; ++i) {
				target = remapToFontChooserId(i);
				if (target < 0 || target == FontChooser.TARGET_ALL) {
					continue;
				}
				font          = getTargetFont(target);
				name          = font.getName();
				style         = font.getStyle();
				size          = font.getSize();
				default_name  = getDefaultFontName(target);
				default_style = getDefaultFontStyle(target);
				default_size  = getDefaultFontSize(target);
				if (!name.equals(default_name) || style != default_style || size != default_size) {
					s = "font=" + i + "," + name + "," + style + "," + size;
					bufferedWriter.write(s, 0, s.length());
					bufferedWriter.newLine();
			}	}
		} catch (Exception e) {
			System.out.println("Exception  " + e + " caught when attempting to save fonts in $HOME/.lsedit");
	}	}


	private void loadSavedFont(String line)
	{
		int		target = 0;
		String	name;
		int		style;
		int		size;
		int		i, j;
		Font	font;
		char	c;

		try {
			for (i = 5; ; ++i) {
				if (i >= line.length()) {
					return;
				}
				c = line.charAt(i);
				if (c == ',') {
					break;
				}
				if (c < '0' || c > '9') {
					return;
				}
				target = target * 10 + (c - '0');
			}
			target = remapToFontChooserId(target);
			if (target < 0 || target == FontChooser.TARGET_ALL) {
				return;
			}
			++i;
			for (j = i; ; ++j) {
				if (j >= line.length()) {
					return;
				}
				c = line.charAt(j);
				if (c == ',') {
					break;
			}	}
			if (j <= i) {
				return;
			}
			name  = line.substring(i, j);
			style = 0;
			for (i = ++j; ; ++i) {
				if (i >= line.length()) {
					return;
				}
				c = line.charAt(i);
				if (c == ',') {
					break;
				}
				if (c < '0' || c > '9') {
					return;
				}
				style += style * 10 + (c - '0');
			}
			size = 0;
			for (++i; ; ++i) {
				if (i >= line.length()) {
					break;
				}
				c = line.charAt(i);
				if (c == '\n' || c == ' ') {
					break;
				}
				if (c < '0' || c > '9') {
					return;
				}
				size += size * 10 + (c - '0');
			}
			font = FontCache.get(name, style, size);
			setTargetFont(target, font);
		} catch (Exception e) {
			System.out.println("LandscapeEditorCore.loadSavedFont=" + target + " " + e);
		}
	}

	public void showValidAttributes(LandscapeClassObject o)
	{
		ResultBox resultBox = getResultBox();

		resultBox.clear();
		m_diagram.showValidAttributes(o, resultBox);
	}

	public void validateEntityAttributes(EntityClass ec)
	{
		ResultBox resultBox = getResultBox();

		resultBox.clear();
		m_diagram.validateEntityAttributes(ec, resultBox, true);
	}

	public void validateRelationAttributes(RelationClass rc)
	{
		ResultBox resultBox = getResultBox();

		resultBox.clear();
		m_diagram.validateRelationAttributes(rc, resultBox, true);
	}

	public void validateRelations(RelationClass rc)
	{
		ResultBox resultBox = getResultBox();

		resultBox.clear();
		m_diagram.validateRelations(rc, resultBox, true);
	}

	public void validateAll()
	{
		ResultBox resultBox = getResultBox();

		resultBox.clear();
		m_diagram.validateAll(resultBox);
	}

	// Interface TaFeedback

	public void showProgress(String str)
	{	
		if (m_nameBox != null) {
			m_nameBox.set(str);
	}	}

	public void updateProgress(int cnt) 
	{
		StringBuffer sb = new StringBuffer("Loading: ");
		for (int i=0; i<cnt; ++i) {
			sb.append('*');
		}
		doFeedback(new String(sb));
	}

	public void doFeedback(String str) 
	{
		if (m_feedback != null) {
			m_feedback.set(str);
	}	}

	public void showInfo(String str) 
	{
		if (m_nameBox != null) {
/*			System.out.println("LandscapeEditorCore.showInfo(" + str + ")");
			java.lang.Thread.dumpStack();
			System.out.println("-----");
 */
			m_nameBox.set(str);
	}	}

	public void error(String msg) 
	{
		doFeedback(msg);
		Util.beep();
	}

	public void showCycle(RelationClass rc, EntityInstance e, int maxCycleSize)
	{
		String		containsLabel = rc.getLabel();
		ResultBox	resultBox = getResultBox();

		if (resultBox != null) {
			EntityInstance	parent;
			int				i;

			resultBox.activate();
			resultBox.setResultTitle("Cycle from " + e + " backtracing " + containsLabel + " relation class" );
			parent = e;
			for (i = 0; i < maxCycleSize; ++i) {	// for safety [redundant]
				parent = parent.getContainedBy(rc);
				if (parent == e) {
					break;
				}
				resultBox.addResultEntity(parent);
			}
			resultBox.done("End of report");
		}
		JOptionPane.showMessageDialog(getFrame(), containsLabel + " relation forms cycle. See report", 
		                                          "Unable to build tree from TA", 
												  JOptionPane.ERROR_MESSAGE | JOptionPane.OK_OPTION);
	}

	public void noContainRelation(String taPath)
	{
		JOptionPane.showMessageDialog(getFrame(), "No containing relation class defined", 
		                                          "Unable to load '" + taPath + "'", 
												   JOptionPane.ERROR_MESSAGE | JOptionPane.OK_OPTION);
	}

	public void hasMultipleParents(RelationClass rc, EntityInstance e)
	{
		Diagram		diagram       = getDiagram();
		String		containsLabel = rc.getLabel();

		JFrame		frame         = getFrame();
		ResultBox	resultBox     = getResultBox();
		Enumeration	en;

		if (resultBox != null) {
			resultBox.activate();
			resultBox.setResultTitle("Parents of " + e);
			for (en = e.getParents(); en.hasMoreElements(); ) {
				e = (EntityInstance) en.nextElement();
				resultBox.addResultEntity(e);
			}
			resultBox.done(containsLabel + " is active containment edge");
		}
		JOptionPane.showMessageDialog(frame, e + " has multiple parents using " + containsLabel + " as containment edge. See Results", "Unable to build visualisation tree", JOptionPane.ERROR_MESSAGE | JOptionPane.OK_OPTION);
	}


	// Interface TaListener

	// abstract void setEnabledRedo(boolean value); -- in Do.java
	// abstract void setEnabledUndo(boolean value); -- in Do.java

	public void setPreferredSizeUndo(Vector edits, UndoableEdit lastEdit)
	{
		if (m_undoBox != null) {
			m_undoBox.setNewPreferredSize(edits, lastEdit);
	}	}

	public void undoHistoryChanged()
	{
		if (m_undoBox != null && m_undoBox.isActive()) {
			m_undoBox.fillUndoBox();
	}	}

	public void invertUndo()
	{
		if (m_undoBox != null) {
			m_undoBox.invertUndo();
	}	}

	public void entityCut(EntityInstance e)
	{
		if (m_resultBox != null) {
			m_resultBox.repaint();
		}
		if (m_findResults != null) {
			if (m_findResults.entityCut()) {
				JButton button = toolButton[PREV_FIND_BUTTON];
				boolean change = false;
				boolean	state  = !m_findResults.atBeginning();

				if (button.isEnabled() != state) {
					button.setEnabled(state);
					change = true;
				}

				button = toolButton[NEXT_FIND_BUTTON];
				state  = !m_findResults.atEnd();
				if (button.isEnabled() != state) {
					button.setEnabled(state);
					change = true;
				}
				if (change) {
					m_toolBar.revalidate();
		}	}	}

		m_diagram.entityCut(e);

		entityBeingMoved(e);
		if (m_historyBox != null) {
			m_historyBox.repaint();
		}
	}

	public void containerCut(EntityInstance parent, EntityInstance e)
	{
		if (m_resultBox != null) {
			m_resultBox.repaint();
		}
		if (!isTocHidden()) {
			m_tocBox.containerCut(parent, e);
		}
		if (m_historyBox != null) {
			m_historyBox.repaint();
		}
		m_diagram.containerCut(parent, e);
	}

	public void containerUncut(EntityInstance e)
	{
		if (m_resultBox != null) {
			m_resultBox.repaint();
		}
		if (!isTocHidden()) {
			m_tocBox.containerUncut(e);
		}
		if (m_historyBox != null) {
			m_historyBox.repaint();
		}
		m_diagram.containerUncut(e);
	}

	public void entityPasted(EntityInstance e)
	{
		if (m_resultBox != null) {
			m_resultBox.repaint();
		}
		entityMoved(e);
		if (m_historyBox != null) {
			m_historyBox.repaint();
	}	}
	
	public void entityBeingMoved(EntityInstance e)
	{
		if (!isTocHidden()) {
			m_tocBox.deleteTOC(e);
	}	}

	// The containment hierarchy in the diagram has changed
	// Recompute the TOC

	public void entityMoved(EntityInstance e)
	{
		if (!isTocHidden()) {
			m_tocBox.insertTOC(e);
	}	}

	// Some property of a class has changed that may alter how the legend/query box shows information

	public void classChanges()
	{
		if (m_legendBox != null) {
			m_legendBox.fillLegendBox();
		}
		if (m_queryBox != null) {
			m_queryBox.fillQueryBox();
	}	}

	public void containsClassChanging()
	{
		m_diagram.containsClassChanging();
	}

	public void containsClassChanged()
	{
		if (m_legendBox != null) {
			m_legendBox.containsClassChanged();
		}
		if (m_queryBox != null) {
			m_queryBox.containsClassChanged();
		}
		m_diagram.containsClassChanged();
	}

	// ToolBarEventHandler

	public void processKeyEvent(int key, int modifiers, Object object) 
	{
//		System.out.println("Process Key seen");

		if (key <= KeyEvent.VK_Z) {
			if (key >= KeyEvent.VK_A) {
				if ((modifiers & Event.SHIFT_MASK) != 0) {
					// Keep character as upper case but remove shift
					modifiers &= ~Event.SHIFT_MASK;
				} else {
					// Convert to lower case
					key += 'a' - KeyEvent.VK_A;
			}	}
		} else if ((key >= KeyEvent.VK_F1 && key <= KeyEvent.VK_F12) && (modifiers & (Event.ALT_MASK|Event.CTRL_MASK)) == 0) {
			// Utter stupidity:  VK_F1 is 0x70 smack bang in the middle of the lower case keys!!!
			// Co can't pass a lower cass key into processKeyEvent
			key += Do.FUNCTION_KEY;
		}	
		processKey(key, modifiers, object);
	}

	public void infoShown(LandscapeObject object)
	{
		if (LandscapeObject.g_infoShown != object) {
			LandscapeObject.g_infoShown = object;
			m_attributeBox.show(object);
	}	}

	// abstract void showInfo(String msg); -- shared with TaFeedback

} 
