package lsedit;

import java.awt.Color;
import java.awt.Graphics;
import java.util.*;
import java.io.*; 
import javax.swing.*;
import javax.swing.undo.UndoableEdit;

// 3 dimension objects have foreground colors, labels etc.
// This is everything but line objects such as edges

public abstract class LandscapeObject3D extends LandscapeObject {

	private String	m_id;			// The id of this entity or class (the name that identifies it uniquely in TA)
	private String	m_description;	// The description of this entity or class
	private String	m_label;		// The label for this entity or class

	/* Logical color's need to be kept separate from the JComponent colors
	 * otherwise when we paint a component we set its actual color to its
	 * logical color loosing the fact that it may not have had a logical color
	 * to begin with (ie. null->red if the class was red)
	 */

	private Color	m_labelColor  = null;
	private	Color	m_colorWhenOpen = null;

	// --------------
	// Public methods 
	// --------------

	public LandscapeObject3D() 
	{
		super();
	}

	public String toString() 
	{
		return m_id;
	}

	public String getId() 
	{
		return m_id;
	}

	public void setId(String id) 
	{
		m_id = id;
	}

	public boolean hasId(String id) 
	{
		return m_id.equals(id);
	}

	public String getDescription() 
	{
		return m_description;
	}

	public void setDescription(String description) 
	{
		if (description != null && description.length() == 0) {
			description = null;
		}
		m_description = description;
	}

	class SetDescription extends MyUndoableEdit implements UndoableEdit
	{
		String				 m_old;
		String				 m_new;

		SetDescription(String old)
		{
			m_old = old;
			m_new = getDescription();
			logEdit(this);
		}

		public String getPresentationName() 
		{
			return LandscapeObject3D.this + " Description";
		}

		public void undo()
		{
			setDescription(m_old);
		}

		public void redo()
		{
			setDescription(m_new);
		}
	}	

	public void updateDescription(String description)
	{
		String	old = m_description;

		if (description == null) {
			if (old == null) {
				return;
			}
		} else if (description.equals(old)) {
			return;
		}
		setDescription(description);
		if (undoEnabled()) {
			new SetDescription(old);
	}	}

	protected void setLabel(String label)
	{
		JComponent swingObject = getSwingObject();

		m_label = label;
		if (swingObject != null) {
			swingObject.setToolTipText(label);
	}	}

	class SetLabel extends MyUndoableEdit implements UndoableEdit
	{
		String				 m_old;
		String				 m_new;

		SetLabel(String old)
		{
			m_old = old;
			m_new = m_label;
			logEdit(this);
		}

		public String getPresentationName() 
		{
			return LandscapeObject3D.this + " Label " + m_new;
		}

		public void undo()
		{
			setLabel(m_old);
		}

		public void redo()
		{
			setLabel(m_new);
		}
	}	

	public void updateLabel(String label)
	{
		String old = m_label;

		if (label == null) {
			if (old == null) {
				return;
			}
		} else if (label.equals(old)) {
			return;
		}
		setLabel(label);
		if (undoEnabled()) {
			new SetLabel(old);
	}	}

	protected String getLabel()
	{
		return(m_label);
	}

	public Color getLabelColor()
	{
		return m_labelColor;
	}


	public Color getInheritedLabelColor() 
	{
		Color	ret;

		ret = getLabelColor();
		if (ret == null) {
			LandscapeClassObject	superclass;

			for (int i = 0; (superclass = derivedFrom(i)) != null; ++i) {
				ret = superclass.getInheritedLabelColor();
				if (ret != null) {
					break;
		}	}	}
		return ret;
	}

	public void setLabelColor(Color color) 
	{
		m_labelColor = color;
	}

	class SetLabelColor extends MyPaintableUndoableEdit implements UndoableEdit
	{
		Color                m_old;
		Color                m_new;

		SetLabelColor(Color old)
		{
			m_old = old;
			m_new = getLabelColor();;
			logEdit(this);
		}

		public String getPresentationName() 
		{
			return LandscapeObject3D.this + " LabelColor ";
		}

		public void undo()
		{
			setLabelColor(m_old);
		}

		public void redo()
		{
			setLabelColor(m_new);
		}

		public void paintComponent(Graphics g, int x, int y)
		{
			paintComponentColor(g, x, y, m_new);
		}
	
		public int getPreferredWidth()
		{
			return(getPreferredWidthColor(LandscapeObject3D.this));
		}
	}

	public void updateLabelColor(Color color)
	{
		Color oldcolor = getLabelColor();

		if (color == null) {
			if (oldcolor == null) {
				return;
			}
		} else if (color.equals(oldcolor)) {
			return;
		}
		setLabelColor(color);
		if (undoEnabled()) {
			new SetLabelColor(oldcolor);
	}	}

	public Color getColorWhenOpen()
	{
		return m_colorWhenOpen;
	}

	public Color getInheritedColorWhenOpen() 
	{
		Color	ret;

		ret = getColorWhenOpen();
		if (ret == null) {
			LandscapeClassObject	superclass;

			for (int i = 0; (superclass = derivedFrom(i)) != null; ++i) {
				ret = superclass.getInheritedColorWhenOpen();
				if (ret != null) {
					break;
		}	}	}
		return ret;
	}

	public void setColorWhenOpen(Color color) 
	{
		m_colorWhenOpen = color;
	}

	class SetColorWhenOpen extends MyPaintableUndoableEdit implements UndoableEdit
	{
		Color                m_old;
		Color                m_new;

		SetColorWhenOpen(Color old)
		{
			m_old = old;
			m_new = getColorWhenOpen();
			logEdit(this);
		}

		public String getPresentationName() 
		{
			return LandscapeObject3D.this + " ColorWhenOpen ";
		}

		public void undo()
		{
			setColorWhenOpen(m_old);
		}

		public void redo()
		{
			setColorWhenOpen(m_new);
		}

		public void paintComponent(Graphics g, int x, int y)
		{
			paintComponentColor(g, x, y, m_new);
		}
	
		public int getPreferredWidth()
		{
			return(getPreferredWidthColor(LandscapeObject3D.this));
		}
	}

	public void updateColorWhenOpen(Color color)
	{
		Color oldcolor = getColorWhenOpen();

		if (color == null) {
			if (oldcolor == null) {
				return;
			}
		} else if (color.equals(oldcolor)) {
			return;
		}
		setColorWhenOpen(color);
		if (undoEnabled()) {
			new SetColorWhenOpen(oldcolor);
	}	}

	public boolean canEditAttribute(int index)
	{
		if (index == 0) {
			// This is the id of the object
			return(false);
		}
		return(super.canEditAttribute(index));
	}
}

