package lsedit;

import java.util.Vector;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Enumeration;

import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JViewport;

public class LegendBox extends JComponent implements MouseListener /*, Scrollable */ 
{
	protected static final int MARGIN = 5;
	protected static final int GAP    = 5; 

	private class DisplayClassHierarchy implements ActionListener
	{
		private LegendBox				m_legendBox;
		private LandscapeClassObject	m_landscapeClass;
		int								m_x;
		int								m_y;
		JPopupMenu						m_popup = null;

 
		public DisplayClassHierarchy(LegendBox legendBox, LandscapeClassObject landscapeClass, int x, int y)
		{
			m_legendBox 	 = legendBox;
			m_landscapeClass = landscapeClass;
			m_x				 = x;
			m_y				 = y;
		}

		public void actionPerformed(ActionEvent e)
		{
			LandscapeClassObject	o      = m_landscapeClass;
			ClassInherits			dialog = new ClassInherits(m_ls, o);

			dialog.setLocation(m_x, m_y);
			dialog.setVisible(true);

			Vector	newv   = dialog.getResult();

			if (newv != null) {
				o.updateInherits(newv);
			}
	}	}


	private class EditClassAttributes implements ActionListener
	{
		private EntityClass				m_entity;
 
		public EditClassAttributes(EntityClass entity)
		{
			m_entity    = entity;
		}

		public void actionPerformed(ActionEvent e)
		{
			EditAttribute.Create(m_ls, m_entity);
			m_ls.repaint();
	}	}

	private class ShowValidAttributes implements ActionListener
	{
		private LandscapeClassObject m_o;
 
		public ShowValidAttributes(LandscapeClassObject o)
		{
			m_o = o;
		}

		public void actionPerformed(ActionEvent e)
		{
			m_ls.showValidAttributes(m_o);
	}	}

	private class CheckEntityAttributes implements ActionListener
	{
		private EntityClass				m_ec;
 
		public CheckEntityAttributes(EntityClass ec)
		{
			m_ec = ec;
		}

		public void actionPerformed(ActionEvent e)
		{
			m_ls.validateEntityAttributes(m_ec);
	}	}

	private class CheckRelationAttributes implements ActionListener
	{
		private RelationClass			m_rc;
 
		public CheckRelationAttributes(RelationClass rc)
		{
			m_rc = rc;
		}

		public void actionPerformed(ActionEvent e)
		{
			m_ls.validateRelationAttributes(m_rc);
	}	}

	private class CheckRelations implements ActionListener
	{
		private RelationClass			m_rc;
 
		public CheckRelations(RelationClass rc)
		{
			m_rc = rc;
		}

		public void actionPerformed(ActionEvent e)
		{
			m_ls.validateRelations(m_rc);
	}	}


	private class EditRelationClassAttributes implements ActionListener
	{
		private LandscapeEditorCore		m_ls;
		private RelationClass			m_relation;
 
		public EditRelationClassAttributes(LandscapeEditorCore ls, RelationClass relation)
		{
			m_ls	   = ls;
			m_relation = relation;
		}

		public void actionPerformed(ActionEvent e)
		{
			EditAttribute.Create(m_ls, m_relation);
			m_ls.repaint();
	}	}

	private class DeleteEntityClass implements ActionListener
	{
		private Diagram		m_diagram;
		private EntityClass	m_ec;
 
		public DeleteEntityClass(Diagram diagram, EntityClass ec)
		{
			m_diagram = diagram;
			m_ec      = ec;
		}

		public void actionPerformed(ActionEvent e)
		{
			EntityClass ec = m_ec;
			Enumeration en;
			EntityClass	ec1;
			String		message = null;

			for (en = m_diagram.enumEntityClasses(); en.hasMoreElements(); ) {
				ec1 = (EntityClass) en.nextElement();
				if (ec != ec1 && ec1.directlyInheritsFrom(ec)) {
					if (message != null) {
						message += ", ";
					} else {
						message = "";
					}
					message += ec1.getLabel();
			}	}
			if (message != null) {
				JOptionPane.showConfirmDialog(null, message + " inherit from " + ec.getLabel(), "Can't delete class", JOptionPane.DEFAULT_OPTION);
				return;
			}
			switch (JOptionPane.showConfirmDialog(null, "Delete class " + ec.getLabel(), "Delete all " + ec.getLabel() + " entities", JOptionPane.YES_NO_CANCEL_OPTION)) {
			case JOptionPane.YES_OPTION:
				m_ls.beginUndoRedo("Delete " + ec.getLabel() + " entity class");
				if (!m_diagram.updateDeleteAllEntities(ec)) {
					JOptionPane.showConfirmDialog(null, "Root member of class " + ec.getLabel(), "Can't delete root", JOptionPane.DEFAULT_OPTION);
					return;
				}
				m_diagram.updateRemoveEntityClass(ec);
				m_diagram.clearGroupFlags();
				m_ls.endUndoRedo();
				break;
			case JOptionPane.NO_OPTION:
				break;
			}
			m_ls.repaint();
	}	}

	private class DeleteRelationClass implements ActionListener
	{
		private	Diagram			m_diagram;
		private RelationClass	m_rc;
 
		public DeleteRelationClass(Diagram diagram, RelationClass rc)
		{
			m_diagram = diagram;
			m_rc      = rc;
		}

		public void actionPerformed(ActionEvent e)
		{
			RelationClass	rc = m_rc;
			Enumeration		en;
			RelationClass	rc1;
			int				promote;

			String		message = null;

			for (en = m_diagram.enumRelationClasses(); en.hasMoreElements(); ) {
				rc1 = (RelationClass) en.nextElement();
				if (rc != rc1 && rc1.directlyInheritsFrom(rc)) {
					if (message != null) {
						message += ", ";
					} else {
						message  = "";
					}
					message += rc1.getLabel();
			}	}
			if (message != null) {
				JOptionPane.showConfirmDialog(null, message + " inherit from " + rc.getLabel(), "Can't delete class", JOptionPane.DEFAULT_OPTION);
				return;
			}	

			switch (JOptionPane.showConfirmDialog(null, "Delete class " + rc.getLabel(), "Delete all " + rc.getLabel() + " edges", JOptionPane.YES_NO_CANCEL_OPTION)) {
			case JOptionPane.YES_OPTION:
				m_ls.beginUndoRedo("Delete " + rc.getLabel() + " relation class");
				m_diagram.updateDeleteAllEdges(rc);
				m_diagram.updateRemoveRelationClass(rc);
				m_ls.endUndoRedo();
				break;
			case JOptionPane.NO_OPTION:
				return;
			default:
				return;
			}
	}	}

	private class ShowConstraintsMatrix implements ActionListener
	{
		private Diagram			m_diagram;
		private RelationClass	m_rc;
 
		public ShowConstraintsMatrix(Diagram diagram, RelationClass rc)
		{
			m_diagram = diagram;
			m_rc      = rc;
		}

		public void actionPerformed(ActionEvent e)
		{
			EditConstraints.create(m_diagram, m_rc);
	}	}

	private class ShowConstraintsClosure implements ActionListener
	{
		private Diagram			m_diagram;
		private RelationClass	m_rc;
 
		public ShowConstraintsClosure(Diagram diagram, RelationClass rc)
		{
			m_diagram = diagram;
			m_rc      = rc;
		}

		public void actionPerformed(ActionEvent e)
		{
			ClosureConstraints.create(m_diagram, m_rc);
	}	}


	private class SetDefaultEntityClass implements ActionListener
	{
		private Diagram		m_diagram;
		private EntityClass	m_ec;
 
		public SetDefaultEntityClass(Diagram diagram, EntityClass ec)
		{
			m_diagram = diagram;
			m_ec      = ec;
		}

		public void actionPerformed(ActionEvent e)
		{
			m_diagram.setDefaultEntityClass(m_ec);
	}	}

	private class SetDefaultRelationClass implements ActionListener
	{
		private Diagram			m_diagram;
		private RelationClass	m_rc;
 
		public SetDefaultRelationClass(Diagram diagram, RelationClass rc)
		{
			m_diagram = diagram;
			m_rc      = rc;
		}

		public void actionPerformed(ActionEvent e)
		{
			m_diagram.setDefaultRelationClass(m_rc);
	}	}


	private class SetContainsRelation implements ActionListener
	{
		private LandscapeEditorCore		m_ls;
		private RelationClass			m_relation;
 
		public SetContainsRelation(LandscapeEditorCore ls, RelationClass relation)
		{
			m_ls	   = ls;
			m_relation = relation;
		}

		public void actionPerformed(ActionEvent e)
		{
			m_ls.updateContainsRelation(m_relation);
		}
	}

	private class EntityLabel extends EntityChkBox implements ItemListener, MouseListener
	{
		protected	LegendBox			m_legendBox;
		protected	JPopupMenu			m_popup = null;

		public EntityLabel(LegendBox legendBox, EntityClass ec, int index, int h) 
		{
			super(ec, index, h, false);

			m_legendBox = legendBox;
			setFont(m_textFont);
			addItemListener(this);
			addMouseListener(this);
		}

		public void setClassShown(boolean value)
		{
			if (m_ec.isShown() != value) {
				m_ec.setShown(value);
				m_ls.getDiagram().redrawDiagram();
		}	}

		public void itemStateChanged(ItemEvent ev)
		{
//			System.out.println("EntityLabel.itemStateChanged " + ev.getStateChange() + " " + isSelected());
			setClassShown(ev.getStateChange() == ItemEvent.SELECTED);
		}


		// MouseListener interface

		public void mouseClicked(MouseEvent e)
		{
		}

		public void mouseEntered(MouseEvent e)
		{
		}

		public void mouseExited(MouseEvent e)
		{
		}

		public void mousePressed(MouseEvent ev)
		{
			if (ev.isMetaDown()) {
				int					x  = ev.getX();
				int					y  = ev.getY();

				if (m_popup == null) {
					JMenuItem	mi;
					Diagram		diagram = m_ls.getDiagram();

					m_popup = new JPopupMenu("Class menu");

					mi = new JMenuItem("Edit inheritance rules");
					mi.addActionListener(new DisplayClassHierarchy(m_legendBox, m_ec, x, y)); 
					m_popup.add(mi);

					mi = new JMenuItem("Edit class attributes");
					mi.addActionListener(new EditClassAttributes(m_ec)); 
					m_popup.add(mi);

					mi = new JMenuItem("Show valid attributes");
					mi.addActionListener(new ShowValidAttributes(m_ec)); 
					m_popup.add(mi);

					mi = new JMenuItem("Validate attributes");
					mi.addActionListener(new CheckEntityAttributes(m_ec)); 
					m_popup.add(mi);



					mi = new JMenuItem("Create entities of this class");
					mi.addActionListener(new SetDefaultEntityClass(diagram, m_ec));
					m_popup.add(mi);

					if (m_ec != diagram.m_entityBaseClass) {
						mi = new JMenuItem("Delete " + m_ec.getLabel());
						mi.addActionListener(new DeleteEntityClass(diagram, m_ec));
						m_popup.add(mi);
					}
					m_legendBox.add(m_popup);
				}
				FontCache.setMenuTreeFont(m_popup); 
				m_popup.show(this, x, y);
		}	}

		public void mouseReleased(MouseEvent ev) 
		{
		}
	}
		
	class VisibleRelnChkBox extends RelnChkBox /* extends JComponent */ implements ItemListener, MouseListener
	{
		protected	LegendBox			m_legendBox;
		protected	JPopupMenu			m_popup;

		public VisibleRelnChkBox(LegendBox legendBox, RelationClass rc,  int index, Font font) 
		{
			super(rc, index, rc.isClassVisible(), font); 

			m_legendBox = legendBox;

			addItemListener(this);
			addMouseListener(this);
		}

		public boolean isClassVisible()
		{
			return(m_rc.isClassVisible());
		}

		public void setClassVisible(boolean value)
		{
			if (isClassVisible() != value) {
				m_rc.setClassVisible(value);
				m_ls.getDiagram().redrawDiagram();
		}	}

		public void itemStateChanged(ItemEvent ev)
		{
//			System.out.println("VisibleRelnChkBox.itemStateChanged " + ev.getStateChange() + " " + isSelected());
			setClassVisible(ev.getStateChange() == ItemEvent.SELECTED);
		}

		// MouseListener interface

		public void mouseClicked(MouseEvent e)
		{
		}

		public void mouseEntered(MouseEvent e)
		{
		}

		public void mouseExited(MouseEvent e)
		{
		}

		public void mousePressed(MouseEvent ev)
		{
			if (ev.isMetaDown()) {

				int		x           = ev.getX();
				int		y           = ev.getY();

				JMenuItem	mi;
				Diagram		diagram = m_ls.getDiagram();

				m_popup = new JPopupMenu("Relation menu");

				mi = new JMenuItem("Edit inheritance rules");
				mi.addActionListener(new DisplayClassHierarchy(m_legendBox, m_rc, x, y)); 
				m_popup.add(mi);

				mi = new JMenuItem("Edit class attributes");
				mi.addActionListener(new EditRelationClassAttributes(m_ls, (RelationClass) m_rc)); 
				m_popup.add(mi);

				mi = new JMenuItem("Edit relation constraints");
				mi.addActionListener(new ShowConstraintsMatrix(diagram, (RelationClass) m_rc));
				m_popup.add(mi);

				mi = new JMenuItem("Closure of constraints");
				mi.addActionListener(new ShowConstraintsClosure(diagram, (RelationClass) m_rc));
				m_popup.add(mi);

				mi = new JMenuItem("Show valid attributes");
				mi.addActionListener(new ShowValidAttributes(m_rc)); 
				m_popup.add(mi);

				mi = new JMenuItem("Validate attributes");
				mi.addActionListener(new CheckRelationAttributes(m_rc)); 
				m_popup.add(mi);

				mi = new JMenuItem("Validate relations");
				mi.addActionListener(new CheckRelations(m_rc)); 
				m_popup.add(mi);

				if (!m_rc.isContainsClass()) {

					if (m_rc != diagram.m_relationBaseClass) {
						mi = new JMenuItem("Delete " + m_rc.getLabel());
						mi.addActionListener(new DeleteRelationClass(diagram, m_rc));
						m_popup.add(mi);
					}

					mi = new JMenuItem("Create edges of this class");
					mi.addActionListener(new SetDefaultRelationClass(diagram, m_rc));
					m_popup.add(mi);

					mi = new JMenuItem("Forms heirarchy");
					mi.addActionListener(new SetContainsRelation(m_ls, (RelationClass) m_rc)); 
					m_popup.add(mi);
				}
				FontCache.setMenuTreeFont(m_popup); 
				m_legendBox.add(m_popup);
				m_popup.show(this, x, y);
		}	}
		
		public void mouseReleased(MouseEvent ev) 
		{
		}
	}

	protected LandscapeEditorCore   m_ls;
	protected JTabbedPane			m_tabbedPane;
	protected JScrollPane			m_scrollPane;

	public final static String DEFAULT_LEGEND_TITLE_FONT_NAME  = FontCache.DEFAULT_FONT_NAME;
	public final static int    DEFAULT_LEGEND_TITLE_FONT_STYLE = Font.BOLD;
	public final static int    DEFAULT_LEGEND_TITLE_FONT_SIZE  = 12;

	protected static Font	m_titleFont  = FontCache.get(DEFAULT_LEGEND_TITLE_FONT_NAME, DEFAULT_LEGEND_TITLE_FONT_STYLE, DEFAULT_LEGEND_TITLE_FONT_SIZE);

	public final static String DEFAULT_LEGEND_TEXT_FONT_NAME  = FontCache.DEFAULT_FONT_NAME;
	public final static int    DEFAULT_LEGEND_TEXT_FONT_STYLE = Font.PLAIN;
	public final static int    DEFAULT_LEGEND_TEXT_FONT_SIZE  = 11;

	protected static Font   m_textFont	 = FontCache.get(DEFAULT_LEGEND_TEXT_FONT_NAME, DEFAULT_LEGEND_TEXT_FONT_STYLE, DEFAULT_LEGEND_TEXT_FONT_SIZE);

	public    static final String m_helpStr	 = "This box shows the types of entities and relations that are present in the current landscape.";

	protected JLabel				m_ulabel;	// TODO underline it
	protected JLabel				m_elabel1;
	protected JLabel				m_elabel2;
	protected JLabel				m_rlabel;	// TODO underline it
	protected JLabel				m_clabel;
	protected JLabel				m_flabel1;
	protected JLabel				m_flabel2;

	protected int					m_width;
	protected int					m_height;

	// --------------
	// Public methods 
	// --------------

	public LegendBox(LandscapeEditorCore ls, JTabbedPane tabbedPane) 
	{
		m_ls          = ls;
		m_tabbedPane  = tabbedPane;

		m_ulabel = new JLabel("Entities");
		m_ulabel.setForeground(Color.red);
		m_ulabel.setFont(m_titleFont);

		m_elabel1 = new JLabel("Pass cursor over entity for description.");
		m_elabel1.setForeground(Color.black);
		m_elabel1.setFont(m_textFont);

		m_elabel2 = new JLabel("Right click for menu.");
		m_elabel2.setForeground(Color.black);
		m_elabel2.setFont(m_textFont);

		m_rlabel = new JLabel("Relations");
		m_rlabel.setForeground(Color.red);
		m_rlabel.setFont(m_titleFont);

		m_clabel = new JLabel("Hierarchy");
		m_clabel.setForeground(Color.red);
		m_clabel.setFont(m_titleFont);

		m_flabel1 = new JLabel("Checkboxes select visible relations.");
		m_flabel1.setForeground(Color.black);
		m_flabel1.setFont(m_textFont);

		m_flabel2 = new JLabel("Right click for menu.");
		m_flabel2.setForeground(Color.black);
		m_flabel2.setFont(m_textFont);


		setLayout(null);
		setBackground(Diagram.boxColor);
		setToolTipText(m_helpStr);

		m_scrollPane = new JScrollPane();
		m_scrollPane.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED); 
		m_scrollPane.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED); 

		m_scrollPane.setViewportView(this);

		tabbedPane.addTab("Legend", null, m_scrollPane, m_helpStr);
		addMouseListener(this);
	}

	public static Font getTitleFont()
	{
		return m_titleFont;
	}

	public static void setTitleFont(Font font)
	{
		m_titleFont = font;
	}

	public void titleFontChanged(Font font)
	{
		m_ulabel.setFont(font);
		m_rlabel.setFont(font);
		fillLegendBox();
	}

	public static Font getTextFont()
	{
		return m_textFont;
	}

	public static void setTextFont(Font font)
	{
		m_textFont = font;
	}

	public void textFontChanged(Font font)
	{
		m_elabel1.setFont(font);
		m_elabel2.setFont(font);
		m_flabel1.setFont(font);
		m_flabel2.setFont(font);
		fillLegendBox();
	}

	public void activate() 
	{
		m_tabbedPane.setSelectedComponent(m_scrollPane);
	}

	public boolean isActive() 
	{
		Component active;

		if (!isVisible()) {
			return(false);
		}
		active = m_tabbedPane.getSelectedComponent();
		return(active != null && m_scrollPane == active);
	}

	public void containsClassChanged()
	{
		fillLegendBox();
	}

/*
	public void setBounds(int x, int y, int width, int height)
	{
		super.setBounds(x,y,width,height);
		System.out.println("Legend size " + getBounds());
		return;
	}
*/

	protected void add(JComponent component)
	{
		Dimension	d;
		int			width, height;

		d      = component.getPreferredSize();
		width  = d.width;
		height = d.height;
		if (width > m_width) {
//			System.out.println("Width=" + width + " for " + component);
			m_width = width;
		}
		component.setBounds(MARGIN, m_height, width, height);
		super.add(component);
		m_height += height;
	}

	public void fillLegendBox()
	{
		Diagram				diagram;
		Enumeration			en;
		int					item,n,h;
		JViewport			viewport;
		int					width, height;
		Dimension 			dimension;
		RelationClass		contains;

/*		System.out.println("LegendBox.fillLegendBox()");
		java.lang.Thread.dumpStack();
		System.out.println("-----");
*/

		diagram = m_ls.getDiagram();

		removeAll();

		m_width  = 0;
		m_height = 0;

		// Draw legend for entities

		item = 0;
		n	 = 0;
		h    = Do.fontHeight(m_textFont); 

		EntityClass ec;
		String		id;

		m_height += 10;
		add(m_ulabel);

		if (diagram != null) {
			for (en = diagram.enumEntityClassesInOrder(); en.hasMoreElements(); ) {
				ec = (EntityClass) en.nextElement();
				id	 = ec.getId();

//				if (!id.equals(EntityClass.ENTITY_BASE_CLASS_ID)) {
				m_height += 10;
				add(new EntityLabel(this, ec, ++n, h));
		}	}

		if (n == 0) {
			m_height  += 10;
			add(new EntityLabel(this, diagram.m_entityBaseClass, ++n, h));
		}	

		m_height += 10;
		add(m_elabel1);
		add(m_elabel2);
		m_height += 20;
		add(m_rlabel);

		// Draw legend for relations

		m_height += GAP;

		n = 0;
		contains = null;
		if (diagram != null) {
			for (en = diagram.enumRelationClassesInOrder(); en.hasMoreElements(); ) {
				RelationClass rc = (RelationClass) en.nextElement();

				if (!rc.isContainsClass()) {
					add(new VisibleRelnChkBox(this, rc, ++n, m_textFont));
				} else {
					contains = rc;
		}	}	}

		if (contains != null) {
			m_height += 10;
			add(m_clabel);
			m_height += GAP;
			add(new VisibleRelnChkBox(this, contains, -1, m_textFont));
		}

		m_height += 20;
		add(m_flabel1);
		add(m_flabel2);

		// Max width is computed in the add() method
		m_width  += MARGIN;
		m_height += 10;

		dimension = new Dimension(m_width, m_height);
		setPreferredSize(dimension);
		setBounds(0, 0, m_width, m_height);
	}

/*
	public Dimension getMinimumSize()
	{
		return(getPreferredSize());
	}
*/
	
	public Dimension getMaximumSize()
	{
		return(getPreferredSize());
	}

	public void toggleRelationVisibility(int key) 
	{
		int				cnt = getComponentCount();
		int				i;
		Component		c;
		boolean			ns;

		ns = true;
		if (key == 0) {
			for (i = 0; i < cnt; ++i) {
				c = getComponent(i);
				if (c instanceof VisibleRelnChkBox) {
					if ( ((VisibleRelnChkBox) c).getIndex() == 1) {
						// Change everything the same way as the way the first one changed
						ns = !((VisibleRelnChkBox) c).isClassVisible();
						break;
			}	}	}

			for (i = 0; i < cnt; ++i) {
				c = getComponent(i);
				if (c instanceof VisibleRelnChkBox) {
					if (ns != ((VisibleRelnChkBox) c).isClassVisible()) {
						((VisibleRelnChkBox) c).doClick();
			}	}	}
		} else {
			for (i = 0; i < cnt; ++i) {
				c = getComponent(i);
				if (c instanceof VisibleRelnChkBox) {
					if (((VisibleRelnChkBox) c).getIndex() == key) {
						((VisibleRelnChkBox) c).doClick();
						break;
		}	}	}	}
	}

	// Generic 	MouseListener interface

	protected void doRightPopup(MouseEvent ev)
	{
		int				x, y;
		JPopupMenu		popupMenu;
				
		x         = ev.getX();
		y         = ev.getY();
		popupMenu = new JPopupMenu("Legend options");
		Do.createClassMenuItem(popupMenu, m_ls);
		FontCache.setMenuTreeFont(popupMenu); 
		add(popupMenu);
		popupMenu.show(this, x, y);
		remove(popupMenu);
	}

	public void mouseClicked(MouseEvent ev)
	{
		
		if (ev.isMetaDown()) {
			doRightPopup(ev);
	}	}

	public void mouseEntered(MouseEvent ev)
	{
	}

	public void mouseExited(MouseEvent e)
	{
	}

	public void mousePressed(MouseEvent ev)
	{
	}

	public void mouseReleased(MouseEvent ev)
	{
	}

/*
	// Scrollable interface
	// We need to implement this to stop iterative size changes..
	// The mapbox knows what size it wants to be and sets it on every validate
	// If we don't disable it the viewport tries to change the size to fit the window every time it validates

	public Dimension getPreferredScrollableViewportSize()
	{
		return(getSize());
	}
	 
	public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction)
	{
		return(50);
	}
	 
	public boolean getScrollableTracksViewportHeight() 
	{
		return(false);
	}

	public boolean getScrollableTracksViewportWidth() 
	{
		return(false);
	}

	public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction)
	{
		return(10);
	} 
*/
}



