package lsedit;

import java.awt.Event;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;

class MyCheckBoxMenuItem extends JCheckBoxMenuItem implements ActionListener
{
	ToolBarEventHandler	m_handler;
	int					m_modifiers;
	int					m_key;

	MyCheckBoxMenuItem(JComponent menu, String label, boolean state, ToolBarEventHandler handler, int modifiers, int key, String tooltipHelp)
	{
		super(label);
		setSelected(state);
		m_handler   = handler;
		if (menu instanceof JMenu) {
			((JMenu) menu).add(this);
		} else {
			((JPopupMenu) menu).add(this);
		}
		if (key <= 'Z') {
			if (key >= 'A') {
				modifiers |= Event.SHIFT_MASK;
			}
		} else if (key <= 'z') {
			if (key >= 'a') {
				modifiers &= ~Event.SHIFT_MASK;
				key += 'A' - 'a';
			}
		} else if (key >= Do.FUNCTION_KEY) {
			key -= Do.FUNCTION_KEY;
		}
		m_modifiers = modifiers;
		m_key       = key;

		if (tooltipHelp != null) {
			setToolTipText(tooltipHelp);
		}
		setAccelerator(KeyStroke.getKeyStroke(key, modifiers));
		addActionListener(this);
	}

	public int getKey()
	{
		return(m_key);
	}

	public void actionPerformed(ActionEvent ev)
	{
//		System.out.println("CheckBoxMenu clicked");
		m_handler.processKeyEvent(m_key, m_modifiers, null);
	}
}