package lsedit;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Enumeration;

import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;

public class QueryBox extends JComponent
{
	class ActiveRelnChkBox extends RelnChkBox /* extends JComponent */ implements ItemListener
	{
		public ActiveRelnChkBox(RelationClass rc,  int index, Font font) 
		{
			super(rc, index, rc.isActive(), font);
			addItemListener(this);
		}

		public boolean isActive()
		{
			return(m_rc.isActive());
		}

		public void setActive(boolean value)
		{
			if (m_rc.isActive() != value) {
				m_rc.setActiveState(value);
				repaint();
		}	}

		public void itemStateChanged(ItemEvent ev)
		{
			setActive(ev.getStateChange() == ItemEvent.SELECTED);
	}	}

	protected class GrpChkBox extends JCheckBox implements ItemListener
	{
		GrpChkBox(String label)
		{
			super(label);

			setSelected(m_ls.isGroupQuery());
			addItemListener(this);
		}

		protected void grpStateInfo() 
		{
			m_ls.doFeedback("Entities " + (m_ls.isGroupQuery() ? "are" : "aren't") + " grouped with queries");
		}

		public void itemStateChanged(ItemEvent ev)
		{
			m_ls.setGroupQuery(isSelected()); 
			grpStateInfo();
			m_ls.requestFocus();
	}	}

	public final static String DEFAULT_QUERY_TITLE_FONT_NAME  = FontCache.DEFAULT_FONT_NAME;
	public final static int    DEFAULT_QUERY_TITLE_FONT_STYLE = Font.BOLD;
	public final static int    DEFAULT_QUERY_TITLE_FONT_SIZE  = 12;

	protected static Font m_titleFont   = FontCache.get(DEFAULT_QUERY_TITLE_FONT_NAME, DEFAULT_QUERY_TITLE_FONT_STYLE, DEFAULT_QUERY_TITLE_FONT_SIZE);

	public final static String DEFAULT_QUERY_TEXT_FONT_NAME  = FontCache.DEFAULT_FONT_NAME;
	public final static int    DEFAULT_QUERY_TEXT_FONT_STYLE = Font.PLAIN;
	public final static int    DEFAULT_QUERY_TEXT_FONT_SIZE  = 11;

	protected static Font m_textFont    = FontCache.get(DEFAULT_QUERY_TEXT_FONT_NAME, DEFAULT_QUERY_TEXT_FONT_STYLE, DEFAULT_QUERY_TEXT_FONT_SIZE);

	public    static final String m_helpStr = "This box shows the relations which are active during queries";

	protected static final int MARGIN = 5;
	protected static final int GAP    = 5; 

	protected LandscapeEditorCore   m_ls;
	protected JTabbedPane			m_tabbedPane;
	protected JScrollPane			m_scrollPane;

	// Objects used in layout

	protected JLabel				m_ulabel;
	protected JLabel				m_clabel;
	protected JLabel				m_footer1;
	protected JLabel				m_footer2;

	protected int					m_width;
	protected int					m_height;

	protected GrpChkBox				m_grpChk;

	// --------------
	// Public methods 
	// --------------

	public QueryBox(LandscapeEditorCore ls, JTabbedPane tabbedPane) 
	{
		m_ls         = ls;
		m_tabbedPane = tabbedPane;

		setBackground(Diagram.boxColor);

		m_ulabel = new JLabel("Relations");
		m_ulabel.setFont(m_titleFont);
		m_ulabel.setForeground(Color.red);
		m_ulabel.setBackground(Diagram.boxColor);

		m_clabel = new JLabel("Hierarchy");
		m_clabel.setForeground(Color.red);
		m_clabel.setFont(m_titleFont);

		m_footer1 = new JLabel("Checkboxes select query relations.");
		m_footer1.setFont(m_textFont);
		m_footer1.setForeground(Color.black);
		m_footer1.setBackground(Diagram.boxColor);

		m_footer2 = new JLabel("Click relation arrow for description.");
		m_footer2.setFont(m_textFont);
		m_footer2.setForeground(Color.black);
		m_footer2.setBackground(Diagram.boxColor);


		m_grpChk = new GrpChkBox("Group with queries");
		m_grpChk.setFont(m_textFont);
		m_grpChk.setForeground(Color.black);

		setToolTipText(m_helpStr);
		m_scrollPane = new JScrollPane();
		m_scrollPane.setViewportView(this);
		tabbedPane.addTab("Queries", null, m_scrollPane, m_helpStr);	
	}

	public boolean isActive() 
	{
		Component active;

		if (!isVisible()) {
			return(false);
		}
		active = m_tabbedPane.getSelectedComponent();
		return(active != null && m_scrollPane == active);
	}	

	public void activate() 
	{
		m_tabbedPane.setSelectedComponent(m_scrollPane);
	}

	public void setGroupQuery(boolean value)
	{
		if (m_grpChk.isSelected() != value) {
			m_grpChk.setSelected(value);
	}	}

	public void containsClassChanged()
	{
		fillQueryBox();
	}

	public static Font getTitleFont()
	{
		return m_titleFont;
	}

	public static void setTitleFont(Font font)
	{
		m_titleFont = font;
	}

	public void titleFontChanged(Font font)
	{
		m_ulabel.setFont(font);
		fillQueryBox();
	}

	public static Font getTextFont()
	{
		return m_textFont;
	}

	public static void setTextFont(Font font)
	{
		m_textFont = font;
	}

	public void textFontChanged(Font font)
	{
		m_footer1.setFont(font);
		m_footer2.setFont(font);
		m_grpChk.setFont(font);
		fillQueryBox();
	}

	protected void add(JComponent component)
	{
		Dimension	d;
		int			width, height;

		d         = component.getPreferredSize();
		width     = d.width;
		height    = d.height;
		if (width > m_width) {
//			System.out.println("Width=" + width + " for " + component);
			m_width = width;
		}
		component.setBounds(MARGIN, m_height, width, height);
		super.add(component);
		m_height += height;
	}

	public void fillQueryBox() 
	{
		Diagram				diagram;
		Enumeration			en;
		RelationClass		rc, contains;
		Color				color;
		ActiveRelnChkBox	relnChk;
		int					n;
		Dimension			dimension;

		removeAll();

		m_width  = 0;
		m_height = 10;

		add(m_ulabel);

		// Draw legend for relations

		diagram  = m_ls.getDiagram();
		contains = null;
		n  = 0;
		if (diagram != null) {
			m_height += GAP;
			for (en = diagram.enumRelationClassesInOrder(); en.hasMoreElements(); ) {

				rc = (RelationClass) en.nextElement();

				if (!rc.isContainsClass()) {
					add(new ActiveRelnChkBox(rc, ++n, m_textFont));
				} else {
					contains = rc;
		}	}	}
		
		if (contains != null) {
			m_height += 10;
			add(m_clabel);
			m_height += GAP;
			add(new ActiveRelnChkBox(contains, ++n, m_textFont));
		}

		m_height += 20;
		add(m_footer1);
		add(m_footer2);
		m_height += 10;
		add(m_grpChk);

		dimension = new Dimension(m_width, m_height);
		setPreferredSize(dimension);
		setBounds(0, 0, m_width, m_height);
	}

	public void toggleRelationActivity(int key) 
	{
		int				cnt = getComponentCount();
		int				i;
		Component		c;
		boolean			ns;
		ActiveRelnChkBox box;

		if (key == 0) {
			ns = true;
			for (i = 0; i < cnt; ++i) {
				c = getComponent(i);
				if (c instanceof ActiveRelnChkBox) {
					box = (ActiveRelnChkBox) c;
					if (box.getIndex() == 1) {
						// Set everything same way as first
						ns = !box.isActive();
						break;
			}	}	}

			for (i = 0; i < cnt; ++i) {
				c = getComponent(i);
				if (c instanceof ActiveRelnChkBox) {
					box = (ActiveRelnChkBox) c;
					if (box.isActive() != ns) {
						if (!box.isContainsClass()) {
							box.doClick();
			}	}	}	}
		} else {
			for (i = 0; i < cnt; ++i) {
				c = getComponent(i);
				if (c instanceof ActiveRelnChkBox) {
					if (((ActiveRelnChkBox) c).getIndex() == key) {
						((ActiveRelnChkBox) c).doClick();
						break;
		}	}	}	}
	}
}

