package lsedit;


import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ReallyDelete extends JDialog implements ActionListener {

	protected LandscapeEditorCore	m_ls;
	protected JButton				m_ok;
	protected JButton				m_cancel;
	protected boolean				m_ret;
	
	public ReallyDelete(LandscapeEditorCore ls, String title)
	{
		super(ls.getFrame(), title, true);

		JFrame			frame;
		Container		contentPane;
		JPanel			grid;
		JPanel			panel;
		JLabel			label;
		
		m_ls       = ls;
		m_ret      = false;

		frame = ls.getFrame();

		setForeground(ColorCache.get(0,0,0));
		setBackground(ColorCache.get(192,192,192));
		setFont(FontCache.get("Dialog",Font.PLAIN,12));

		contentPane = getContentPane();
		
		grid           = new JPanel();
		grid.setLayout(new GridLayout(1,1));

		label          = new JLabel("Confirm deletion?");
		grid.add(label);
		
		contentPane.add(grid, BorderLayout.CENTER);
		 
		panel = new JPanel();
		panel.setLayout(new FlowLayout());

		m_ok = new JButton("Ok");
		panel.add(m_ok);
		m_ok.addActionListener(this);
		m_cancel = new JButton("Cancel");
		panel.add(m_cancel);
		m_cancel.addActionListener(this);

		contentPane.add(panel, BorderLayout.SOUTH);

		// Resize the window to the preferred size of its components

		this.pack();
	}

	public boolean confirmed()
	{
		return m_ret;
	}

	// ActionListener interface

	public void actionPerformed(ActionEvent ev)
	{
		Object	source;

		// Pop down the window when the button is clicked.
		// System.out.println("event: " + ev);

		source = ev.getSource();

		if (source == m_ok || source == m_cancel) {
			if (source == m_ok) {
				m_ret = true;
			}
			this.setVisible(false);
			return;
	}	}
}

