package lsedit;

import java.awt.Color;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

import javax.swing.undo.UndoableEdit;

public class RelationClass extends LandscapeClassObject /* extends LandscapeObject3D extends LandscapeObject */ {

	protected static final String FACTOR_ID      = "class_iofactor";
	protected static final String HIERARCHY_ID   = "class_hierarchy";
	protected static final String ACTIVE_ID      = "class_active";
	protected static final String VISIBLE_ID     = "class_visible";
	protected static final String ISCONTAINS_ID  = "class_iscontains";

	public static final int	ID_ATTR				= 0;
	public static final int	CLASSLABEL_ATTR		= 1;
	public static final int	CLASSDESC_ATTR		= 2;
	public static final int	CLASSSTYLE_ATTR		= 3;
	public static final int	COLOR_ATTR			= 4;
	public static final int	LABEL_COLOR_ATTR	= 5;
	public static final int	FACTOR_ATTR			= 6;
	public static final int ATTRS               = 7;

	public static final String[] attributeName =
	{
		"id",
		CLASSLABEL_ID,
		CLASSDESC_ID,
		CLASSSTYLE_ID,
		COLOR_ID,
		LABEL_COLOR_ID,
		FACTOR_ID
	};

	public static final int[] attributeType =
	{
		Attribute.STRING_TYPE,
		Attribute.STRING_TYPE,
		Attribute.TEXT_TYPE,
		Attribute.REL_STYLE_TYPE,
		Attribute.COLOR_OR_NULL_TYPE,
		Attribute.COLOR_TYPE,
		Attribute.DOUBLE_TYPE
	};

	protected static final String RELATION_BASE_CLASS_ID = "$RELATION";

	protected boolean m_active   = true;	// True if class active in queries
	protected boolean m_visible  = true;	// True if relations of this class should be visible
	protected boolean m_contains = false;	// True if this is the currently active contains class

	protected double  m_iofactor = -1;		// Where the relation should intersect entities as a percentage
	protected int	  m_cIndex   = -1;		// What is the offset of EntityShape[] for entity shape using this relation as contains

	// Permitted relations

	// This is the list of Entity class pairs that can participate in relations of this relation class
	// It can be presumed to be quite small.

	private Vector	m_relationList = new Vector();
		 
	protected int	m_ordinal;

	// --------------
	// Public methods
	// --------------

	public RelationClass(String id, int nid, Ta ta)
	{
		super(ta);
		setId(id);						// The string name of this relation class
		setNid(nid);					// The numeric id
		setLabel(id);					// The label of this relation
	}

	public int getCIndex()
	{
		return m_cIndex;
	}

	public void setCIndex(int value)
	{
		m_cIndex = value;
	}

	public String getStyleName(int style) 
	{
		return Util.getLineStyleName(style);
	}

	public void setContainsClass(boolean contains)
	{
		m_contains = contains;
	}

	// Is this the contains relation

	public boolean isContainsClass() 
	{
		return m_contains;
	}

	protected boolean processClassAttributes(Attribute attr) 
	{
		if (attr.id.equals(HIERARCHY_ID)) {
			m_cIndex = Integer.parseInt(attr.avi.value);
			return true;
		}
		if (attr.id.equals(FACTOR_ID)) {
			m_iofactor = Double.parseDouble(attr.avi.value);
			return true;
		}
		if (attr.id.equals(ACTIVE_ID)) {
			m_active = Util.parseBoolean(attr.avi.value);
			return true;
		}
		if (attr.id.equals(VISIBLE_ID)) {
			m_visible = Util.parseBoolean(attr.avi.value);
			return true;
		}
		if (attr.id.equals(ISCONTAINS_ID)) {
			m_contains = Util.parseBoolean(attr.avi.value);
			return true;
		}
		return super.processClassAttributes(attr);
	}

	public void reportClassAttributes(ResultBox resultBox)
	{
		resultBox.addText(HIERARCHY_ID);
		resultBox.addText(FACTOR_ID);
		resultBox.addText(ACTIVE_ID);
		resultBox.addText(VISIBLE_ID);
		resultBox.addText(ISCONTAINS_ID);

		super.reportClassAttributes(resultBox);
	}

	// If new, add an edge to the ERD (permitted relation)

	public Vector getRelationList()
	{
		return m_relationList;
	}

	public void addRelation(EntityClassPair ep)
	{
		m_relationList.addElement(ep);
	}

	public void addRelation(EntityClass ec1, EntityClass ec2) 
	{
		if (m_relationList == null) {
			m_relationList = new Vector();
		} else {
			Enumeration		en;
			EntityClassPair ep;

			for (en = m_relationList.elements(); en.hasMoreElements(); ) {
				ep = (EntityClassPair) en.nextElement();
				if (ep.equals(ec1, ec2)) {
					return;
				}
		}	}

		addRelation(new EntityClassPair(ec1, this, ec2));
	}

	public void removeRelation(EntityClassPair ep) 
	{
		Vector relationList;

		relationList = m_relationList;
		if (relationList != null) {
			relationList.remove(ep);
	}	}

	public boolean[][] getInheritedRelationArray()
	{
		Ta				ta = getTa();
		boolean[][]		array;
		boolean[]		row;
		Enumeration		en, en1, en2, en3;
		RelationClass	rc;
		int				i, j, size;
		Vector			srcs, dsts;
		EntityClassPair	ep;
		EntityClass		src1, dst1;
		int				from, to;

		i = 0;
		for (en = ta.enumEntityClassesInOrder(); en.hasMoreElements(); ++i) {
			src1 = (EntityClass) en.nextElement();
			src1.setOrderedId(i);
		}
		size = i;

		array = new boolean[size][];
		for (i = 0; i < size; ++i) {
			array[i] = row = new boolean[size];
			for (j = 0; j < size; ++j) {
				row[j] = false;
		}	}

		Vector	rcs     = getClassAndSuperclasses();
		for (en = rcs.elements(); en.hasMoreElements(); ) {
			rc = (RelationClass) en.nextElement();
			for (en1 = rc.m_relationList.elements(); en1.hasMoreElements(); ) {
				ep = (EntityClassPair) en1.nextElement();
				srcs = ta.getClassAndSubclasses(ep.m_entityClass1);
				dsts = ta.getClassAndSubclasses(ep.m_entityClass2);
				for (en2 = srcs.elements(); en2.hasMoreElements(); ) {
					src1 = (EntityClass) en2.nextElement();
					from = src1.getOrderedId();
					for (en3 = dsts.elements(); en3.hasMoreElements(); ) {
						dst1 = (EntityClass) en3.nextElement();
						to   = dst1.getOrderedId();
						array[from][to] = true;
		}	}	}	}
		return array;
	}

	// Return RelationInstance based on our RelationClass

	public RelationInstance newRelation(EntityInstance e1, EntityInstance e2) 
	{
		RelationInstance ri = new RelationInstance(this, e1, e2);
		return ri;
	}

	public void writeRelations(PrintStream ps) throws IOException 
	{
		Enumeration en;
		EntityClassPair ep;

		for (en = m_relationList.elements(); en.hasMoreElements(); ) {
			ep = (EntityClassPair) en.nextElement();
			ps.print(qt(getId()) + " " + qt(ep.m_entityClass1.getId()) + " " + qt(ep.m_entityClass2.getId()) + "\n");
		}
	}

	public void writeAttributes(PrintStream ps) throws IOException 
	{
		if (getNid() >= 2) {
			ps.print("(" + qt(getId()) + ") {\n");

			if (m_cIndex >= 0) {
				ps.print(HIERARCHY_ID + " = " + m_cIndex + " ");
			}
			if (m_iofactor >= 0) {
				ps.print(FACTOR_ID + " = " + m_iofactor + " ");
			}
			if (!m_active) {
				ps.print(ACTIVE_ID + " = false ");
			}
			if (!m_visible) {
				ps.print(VISIBLE_ID + " = false ");
			}
			if (m_contains) {
				ps.print(ISCONTAINS_ID + " = true ");
			}
			super.writeAttributes(ps);
			ps.print("}\n\n");
		}
	}

	// Accessor functions

	public boolean isClassVisible() 
	{
		return m_visible && !m_contains;
	}

	public void setClassVisible(boolean state) 
	{
		m_visible = state; 
	}

	public boolean isActive() 
	{
		return m_active;
	}

	public void setActiveState(boolean state) 
	{
		m_active = state; 
	}

	public void setOrdinal(int ord) 
	{
		m_ordinal = ord;
	}

	public double getIOfactor() 
	{
		if (m_iofactor >= 0) {
			return m_iofactor;
		}
		
		Diagram diagram = getDiagram();

		if (diagram.allowElision()) {
			double num = diagram.numVisibleRelationClasses();
			return (m_ordinal+1)/(num+1);
		}
		double num = diagram.numRelationClasses();
		return ((num > 2) ? (getNid()-1)/(num-1) : 0.5);
	}

	public void setIOfactor(double value)
	{
		m_iofactor = value;
	}

	class SetIOfactor extends MyUndoableEdit implements UndoableEdit
	{
		double	m_old;
		double  m_new;

		SetIOfactor(double old)
		{
			m_old = old;
			m_new = m_iofactor;
			logEdit(this);
		}

		public String getPresentationName() 
		{
			return RelationClass.this + " Change IO factor";
		}

		public void undo()
		{
			setIOfactor(m_old);
		}

		public void redo()
		{
			setIOfactor(m_new);
	}	}

	public void updateIOfactor(double value)
	{
		double	old = m_iofactor;
		if (old != value) {
			setIOfactor(value);
			if (undoEnabled()) {
				new SetIOfactor(old);
	}	}	}

	// The routines that follow hide the complexity of getting/setting attribute values
	// from EditAttributes

	public int getPrimaryAttributeCount()
	{
		return(ATTRS);
	}

	public String getLsAttributeNameAt(int index)
	{
		String	name;

		if (index < ATTRS) {
			name = attributeName[index];
		} else {
			name  = super.getLsAttributeNameAt(index);
		}
		return(name);
	}

	public int getLsAttributeTypeAt(int index)
	{
		int		ret;
	
		if (index < ATTRS) {
			ret = attributeType[index];
		} else {
			ret = super.getLsAttributeTypeAt(index);
		}
		return(ret);
	}

	public Object getLsAttributeValueAt(int index)
	{
		Object	value;

		switch (index) {
		case ID_ATTR:
			value = getId();
			break;
		case CLASSLABEL_ATTR:
			value = getLabel();
			break;
		case CLASSDESC_ATTR:
			value = getDescription();
			break;
		case CLASSSTYLE_ATTR:
			value = new Integer(getStyle());
			break;
		case COLOR_ATTR:
			value = getObjectColor();
			break;
		case LABEL_COLOR_ATTR:
			value = getLabelColor();
			break;
		case FACTOR_ATTR:
			value = new Double(m_iofactor);
			break;
		default:
			value = super.getLsAttributeValueAt(index);
		}
		return(value);
	}

	public void updateAttributeValueAt(int index, Object value)
	{
		switch (index) {
		case ID_ATTR:
			setId((String) value);
			break;
		case CLASSLABEL_ATTR:
			updateLabel((String) value);
			break;
		case CLASSDESC_ATTR:
			updateDescription((String) value);
			break;
		case CLASSSTYLE_ATTR:
			updateStyle(((Integer) value).intValue());
			break;
		case COLOR_ATTR:
			updateObjectColor((Color) value);
			break;
		case LABEL_COLOR_ATTR:
			updateLabelColor((Color) value);
			break;
		case FACTOR_ATTR:
			updateIOfactor(((Double) value).doubleValue());
			break;
		default:
			super.updateAttributeValueAt(index, value);
	}	}
}

