package lsedit;


// This object has the responsibility for laying out clients and supplier lists

public class SupplierSet extends ClientSupplierSet implements DiagramCoordinates 
{
	// --------------
	// Public methods
	// --------------

	public SupplierSet(Diagram diagram) 
	{
		super(diagram);
		setToolTipText("Suppliers are things outside the diagram that have edges from the diagram");
	}

	// Starting from the root of the graph add in any entity found which
	// has an edge whose source is going to be in the diagram, but whose
	// destination is neither in the diagram or containing the diagram.
	// Do not descend beneath entities thus added

	public void findSuppliers(EntityInstance root, EntityInstance drawRoot, boolean liftEdges)
	{
		m_drawRoot = drawRoot;
		root.addSuppliers(m_set, drawRoot, m_ls.isVisibleEdges(), m_ls.isVisibleEntities(), liftEdges);
		m_fullSize = m_set.size();
		setToolTipText(m_fullSize + " suppliers");
	}
	
	// Diagram coordinates interface (no multiple inheritence in Java)
	
	public int getDiagramX()
	{
		return(super.getDiagramX());
	}
	
	public int getDiagramY()
	{
		return(super.getDiagramY());
	}
}
