package lsedit;

import java.util.Vector;
import javax.swing.undo.UndoableEdit;


/* This interface decouples UndoableTa.java and TemporalTa.java from LandscapeEditorCore
 * That allows it to be used in other products more easily
 */

public interface TaListener {

	abstract void setEnabledRedo(boolean value);
	abstract void setEnabledUndo(boolean value);
	abstract void setPreferredSizeUndo(Vector edits, UndoableEdit lastEdit);
	abstract void undoHistoryChanged();

	abstract void entityCut(EntityInstance e);
	abstract void containerCut(EntityInstance parent, EntityInstance e);
	abstract void containerUncut(EntityInstance e);
	abstract void entityPasted(EntityInstance e);
	abstract void entityBeingMoved(EntityInstance e);
	abstract void entityMoved(EntityInstance e);

	abstract void classChanges();			// Some property of classes has changed
	abstract void containsClassChanging();
	abstract void containsClassChanged();

}

