package lsedit;

import java.awt.Rectangle;

import java.util.Enumeration;
import java.util.Vector;

import javax.swing.undo.UndoableEdit;

/* This class extends UnoableTa with the ability to actually update the TA
 * It knows about the diagram
 */

public class TemporalTa extends UndoableTa 
{
	public TemporalTa(TaListener taListener, TaFeedback taFeedback)
	{
		super(taListener, taFeedback);
	}

	class NewEntity extends MyUndoableEdit implements UndoableEdit
	{
		EntityInstance		 m_container;
		EntityInstance		 m_e;

		NewEntity(EntityInstance container, EntityInstance e)
		{
			m_container = container;
			m_e         = e;

			logEdit(this);
		}

		public String getPresentationName() 
		{
			return "Create entity " + m_e;
		}

		public void undo()
		{
			cutEntity(m_e);
			m_diagram.redrawDiagram();
		}

		public void redo()
		{
			pasteEntity(m_container, m_e);
			m_diagram.redrawDiagram();
		}
	}

	public EntityInstance updateNewEntity(EntityClass ec, EntityInstance container, Rectangle lyt, boolean doLayout)
	{
		EntityInstance	e = getNewEntity(ec, container);

		if (undoEnabled()) {
			new NewEntity(container, e);
		}


		if (doLayout) {
			if (lyt == null) {
				setInitialLocation(e, container);
			} else {
				// This will generate a 2nd edit in the Undo/Redo history
				e.updateDiagramBounds(lyt);
		}	}

		return(e);
	}

	class NewRelation extends MyUndoableEdit implements UndoableEdit
	{
		RelationInstance		 m_ri = null;

		NewRelation(RelationInstance ri)
		{
			m_ri = ri;
			logEdit(this);
		}

		public String getPresentationName() 
		{
			return "Create relation " + m_ri;
		}

		public void undo()
		{
			m_ri.getSrc().removeSrcRelation(m_ri);
			m_ri.getDst().removeDstRelation(m_ri);
			m_diagram.redrawDiagram();
		}

		public void redo()
		{
			m_ri.getSrc().addSrcRelation(m_ri);
			m_ri.getDst().addDstRelation(m_ri);
			m_diagram.redrawDiagram();
		}
	}	

	// Create a new edge

	public RelationInstance updateNewRelation(RelationClass rc, EntityInstance from, EntityInstance to)
	{
		RelationInstance ri = getNewRelation(rc, from, to);
		if (undoEnabled()) {
			new NewRelation(ri);
		}
		return ri;
	}

	class CutEntity extends MyUndoableEdit implements UndoableEdit
	{
		EntityInstance m_e;

		CutEntity(EntityInstance e)
		{
			m_e = e;
			logEdit(this);
		}

		public String getPresentationName() 
		{
			return m_e + " Deleted";
		}

		public void undo()
		{
			pasteEntity(null, m_e);
			m_diagram.redrawDiagram();
		}

		public void redo()
		{
			cutEntity(m_e);
			m_diagram.redrawDiagram();
	}	}

	public boolean updateCutEntity(EntityInstance e)
	{
		boolean ok = cutEntity(e);
		if (ok && undoEnabled()) {
			new CutEntity(e);
		}
		return ok;
	}

	public void updateDeleteAllEntities(EntityClass ec, EntityInstance rootedAt)
	{
		Enumeration			en;
		EntityInstance		child;

		if (rootedAt.getEntityClass() == ec) {
			updateCutEntity(rootedAt);
			return;
		}	

		for (en = rootedAt.getChildren(); en.hasMoreElements(); ) {
			child = (EntityInstance) en.nextElement();
			updateDeleteAllEntities(ec, child);
	}	}

	public boolean updateDeleteAllEntities(EntityClass ec)
	{
		if (m_rootInstance.getEntityClass() == ec) {
			return false;
		}
		updateDeleteAllEntities(ec, m_rootInstance);
		return true;
	}

	public void updateDeleteAllEdges(RelationClass rc, EntityInstance rootedAt)
	{
		Vector				dstRelList = rootedAt.getDstRelList();
		Enumeration			en;
		RelationInstance	ri;
		EntityInstance		child;
		int					i;

		for (i = dstRelList.size(); i > 0; ) {
			ri = (RelationInstance) dstRelList.elementAt(--i);
			if (ri.getRelationClass() == rc) {
				ri.updateDeleteEdge();
		}	}

		for (en = rootedAt.getChildren(); en.hasMoreElements(); ) {
			child = (EntityInstance) en.nextElement();
			updateDeleteAllEdges(rc, child);
	}	}

	public void updateDeleteAllEdges(RelationClass rc)
	{
		updateDeleteAllEdges(rc, m_rootInstance);
	}

	class CutClipboard extends MyUndoableEdit implements UndoableEdit
	{
		Clipboard	m_old_clipboard;
		Clipboard	m_new_clipboard;

		CutClipboard(Clipboard old_clipboard, Clipboard new_clipboard)
		{
			m_old_clipboard = old_clipboard;
			m_new_clipboard = new_clipboard;
			logEdit(this);
		}

		public String getPresentationName() 
		{
			if (m_new_clipboard.getExtendsClipboard() == null) {
				return "Cut";
			}
			return "Cut additional";
		}

		public void undo()
		{
			Clipboard clipboard = m_new_clipboard;
			int					i;
			EntityInstance		e;

			for (i = clipboard.size(); i > 0; ) {
				// Paste ancestors then children
				e = (EntityInstance) clipboard.elementAt(--i);
				pasteEntity(null, e);
			}
			m_diagram.setClipboard(m_old_clipboard);
			m_diagram.redrawDiagram();
		}

		public void redo()
		{
			cutClipboard(m_new_clipboard);
		}
	}	

	public boolean updateCutClipboard(Clipboard old_clipboard, Clipboard new_clipboard)
	{
		boolean ok = cutClipboard(new_clipboard);
		if (ok && undoEnabled()) {
			new CutClipboard(old_clipboard, new_clipboard);
		}
		return(ok);
	}

	class PasteClipboard extends MyUndoableEdit implements UndoableEdit
	{
		Clipboard			m_saved_clipboard;
		EntityInstance		m_container;

		PasteClipboard(Clipboard clipboard, EntityInstance container)
		{
			m_saved_clipboard = clipboard;
			m_container       = container;
			logEdit(this);
		}

		public String getPresentationName() 
		{
			return "Paste";
		}

		public void undo()
		{
			RelationClass		containsClass = getContainsClass();
			ClipboardEnumerator	en;
			EntityInstance		e;
			RelationInstance	ri;
			EntityInstance		container;
			int					i;

			i       = 0;
			for (en = m_saved_clipboard.clipboardElements(); en.hasMoreElements(); ++i) {
				// N.B. order irrelevant when pasting and unpasting -- all under same parent
				e = (EntityInstance) en.nextElement();
				cutEntity(e);
				container = en.oldContainer();

				// Duplication to considerable extent:	e.setContainedBy(m_oldContainers[i]);

				ri        = e.getContainedByRelation(containsClass);
				if (ri == null || ri.getSrc() != container) {
					// Must change container for e back to what it was
					if (ri != null) {
						ri.removeEdge();
					}
					ri = containsClass.newRelation(container, e);
					e.addDstRelation(ri); 
			}	}
			m_diagram.setClipboard(m_saved_clipboard);
			prepostorder();		// Can do at end when cutting
			m_diagram.redrawDiagram();
		}

		public void redo()
		{
			pasteClipboard(m_saved_clipboard, m_container);
		}
	}	

	public void updatePasteClipboard(Clipboard clipboard, EntityInstance pe) 
	{
		pasteClipboard(clipboard, pe);
		if (undoEnabled()) {
			new PasteClipboard(clipboard, pe);
		}
	}

	class MoveEntityContainment extends MyUndoableEdit implements UndoableEdit
	{
		EntityInstance	m_containedByOld;
		EntityInstance	m_containedByNew;
		EntityInstance	m_e;

		MoveEntityContainment(EntityInstance oldContainer, EntityInstance e)
		{
			m_containedByOld = oldContainer;
			m_containedByNew = e.getContainedBy();
			m_e              = e;

			logEdit(this);
		}

		public String getPresentationName() 
		{
			return m_e + " moved from " + m_containedByOld + " to " + m_containedByNew;
		}

		public void undo()
		{
			moveEntityContainment(m_containedByOld, m_e);
			m_diagram.redrawDiagram();
		}

		public void redo()
		{
			moveEntityContainment(m_containedByNew, m_e);
			m_diagram.redrawDiagram();
	}	}

	public void updateMoveEntityContainment(EntityInstance newContainer, EntityInstance me) 
	{
		EntityInstance oldContainer = me.getContainedBy();

		if (moveEntityContainment(newContainer, me)) {
			if (undoEnabled()) {
				new MoveEntityContainment(oldContainer, me);
	}	}	}
	
	class UpdateDeleteContainer extends MyUndoableEdit implements UndoableEdit
	{
		EntityInstance		m_e;

		UpdateDeleteContainer(EntityInstance e) 
		{
			m_e = e;
			logEdit(this);
		}

		public String getPresentationName() 
		{
			return "Deleting container " + m_e;
		}
	
		public void undo()
		{
			undeleteContainer(m_e);
			m_diagram.redrawDiagram();
		}

		public void redo()
		{
			deleteContainer(m_e);
			m_diagram.redrawDiagram();
		}
	}
	
	public void updateDeleteContainer(EntityInstance e)
	{
		deleteContainer(e);
		if (undoEnabled()) {
			new UpdateDeleteContainer(e);
		}
	}

	class ClusterEntity extends MyUndoableEdit implements UndoableEdit
	{
		EntityInstance		 m_container;
		EntityInstance		 m_e;

		ClusterEntity(EntityInstance container, EntityInstance e)
		{
			m_container = container;
			m_e         = e;

			logEdit(this);
		}


		public String getPresentationName() 
		{
			return "Create cluster " + m_e;
		}

		public void undo()
		{
			cutEntity(m_e);
			m_diagram.redrawDiagram();
		}

		public void redo()
		{
			pasteEntity(m_container, m_e);
			m_diagram.redrawDiagram();
		}
	}	

	// Transfer an entity from one TA to another using caching

	public EntityInstance updateClusterEntity(EntityInstance container, EntityInstance e)
	{
		EntityInstance ret = clusterEntity(container, e);
		
		if (undoEnabled()) {
			new ClusterEntity(container, ret);
   		} 
		return(ret);
	}

	class ImportEntity extends MyUndoableEdit implements UndoableEdit
	{
		EntityInstance		 m_container;
		EntityInstance		 m_e;
		EntityInstance		 m_match;
		EntityInstance		 m_ret;


		EntityClass			 m_old_match_parentClass;
		EntityInstance		 m_old_match_containedBy;
		double				 m_old_match_x, m_old_match_y, m_old_match_width, m_old_match_height;

		ImportEntity(EntityInstance container, EntityInstance e, EntityInstance match)
		{
			m_container = container;
			m_e         = e;
			m_match     = match;

			m_old_match_parentClass = (EntityClass) match.getParentClass();
			m_old_match_containedBy = match.getContainedBy();
			m_old_match_x           = match.xRelLocal();
			m_old_match_y           = match.yRelLocal();
			m_old_match_width       = match.widthRelLocal();
			m_old_match_height      = match.heightRelLocal();

			m_ret                   = importEntity(container, e, match);

			logEdit(this);
		}

		public EntityInstance getEntity()
		{
			return m_ret;
		}

		public String getPresentationName() 
		{
			return "Import entity " + m_e;
		}

		public void undo()
		{
			EntityInstance match = m_match;

			match.setRelLocal(m_old_match_x, m_old_match_y, m_old_match_width, m_old_match_height);
			moveEntityContainment(m_old_match_containedBy, match);
			match.setParentClass(m_old_match_parentClass);
			m_diagram.redrawDiagram();
		}

		public void redo()
		{
			m_ret = importEntity(m_container, m_e, m_match);
			m_diagram.redrawDiagram();
		}
	}	

	// Transfer an entity from one TA to another using caching

	public EntityInstance updateImportEntity(EntityInstance container, EntityInstance e, EntityInstance match)
	{
		EntityInstance ret;
		
		if (!undoEnabled()) {
			ret = importEntity(container, e, match);
		} else {
			ImportEntity ie;
			
			ie  = new ImportEntity(container, e, match);
			ret = ie.getEntity();     
		} 
		return(ret);
	}

	class RemoveEntityClass extends MyUndoableEdit implements UndoableEdit
	{
		EntityClass	m_ec, m_oldDefaultEntityClass;
;		Vector		m_eps;

		private void cacheEntityClassPairs(EntityClass ec)
		{
			Enumeration		en;
			RelationClass	rc;
			Vector			relationList;
			Vector			eps;
			EntityClassPair	ep;
			int				i;
			
			ec    = m_ec;
			eps   = null;
			for (en = m_relationClasses.elements(); en.hasMoreElements(); ) {
				rc           = (RelationClass) en.nextElement(); 
				relationList = rc.getRelationList();
				if (relationList != null) {
					for (i = relationList.size(); i > 0; ) {
						ep = (EntityClassPair) relationList.elementAt(--i);
						if (ep.m_entityClass1 == ec || ep.m_entityClass2 == ec) {
							if (eps == null) {
								eps = new Vector();
							}
							eps.addElement(ep);
			}	}	}	}
			m_eps = eps;
		}
							 
		RemoveEntityClass(EntityClass ec)
		{
			m_ec                    = ec;
			m_oldDefaultEntityClass = m_defaultEntityClass;
			if (logEdit(this)) {
				cacheEntityClassPairs(ec);
		}	}

		public String getPresentationName() 
		{
			return " Remove entity class " + m_ec.getLabel();
		}

		public void undo()
		{
			Vector	eps;

			m_entityClasses.put(m_ec.getId(), m_ec);
			
			eps = m_eps;
			if (eps != null) {
				EntityClassPair	ep;
				int				i;

				for (i = eps.size(); i > 0; ) {
					ep = (EntityClassPair) eps.elementAt(--i);
					ep.m_rc.addRelation(ep);
			}	}

			if (m_defaultEntityClass != m_oldDefaultEntityClass) {
				setDefaultEntityClass(m_oldDefaultEntityClass);
			}
			m_taListener.classChanges();
		}

		public void redo()
		{
			removeEntityClass(m_ec);
		}
	}	

	/* N.B.updateDeleteAllEntities(ec) first */

	public void updateRemoveEntityClass(EntityClass ec)
	{
		if (undoEnabled()) {
			new RemoveEntityClass(ec);
		}
		removeEntityClass(ec);
	}

	class RemoveRelationClass extends MyUndoableEdit implements UndoableEdit
	{
		RelationClass	m_rc, m_oldDefaultRelationClass;

		RemoveRelationClass(RelationClass rc)
		{
			m_rc = rc;
			m_oldDefaultRelationClass = m_defaultRelationClass;
			logEdit(this);
		}	

		public String getPresentationName() 
		{
			return " Remove relation class " + m_rc.getLabel();
		}

		public void undo()
		{
			m_relationClasses.put(m_rc.getId(), m_rc);
			if (m_defaultRelationClass != m_oldDefaultRelationClass) {
				setDefaultRelationClass(m_oldDefaultRelationClass);
			}
			m_taListener.classChanges();
		}

		public void redo()
		{
			removeRelationClass(m_rc);
		}
	}	

	// N.B. updateDeleteAllEdges(rc) first

	public void updateRemoveRelationClass(RelationClass rc)
	{
		if (undoEnabled()) {
			new RemoveRelationClass(rc);
		}
		removeRelationClass(rc);
	}

	class SwitchContainsClass extends MyUndoableEdit implements UndoableEdit
	{
		RelationClass		m_oldContainsClass;
		RelationClass		m_newContainsClass;
		Vector				m_oldForest;
		Vector				m_newForest;

		SwitchContainsClass(RelationClass newContainsClass, Vector newForest) 
		{
			Vector				oldForest;
			RelationInstance	ri;
			RelationClass		rc;
			Enumeration			en;

			m_oldContainsClass = m_containsClass;
			m_oldForest        = getForest();			

			m_newContainsClass = newContainsClass;
			m_newForest        = newForest;

			logEdit(this);
		}

		public String getPresentationName() 
		{
			return "Switch hierarchy from " + m_oldContainsClass.getLabel() + " to " + m_newContainsClass.getLabel();
		}
	
		public void undo()
		{
			switchContainsClass(m_oldContainsClass, m_oldForest);
			m_diagram.redrawDiagram();
		}

		public void redo()
		{
			switchContainsClass(m_newContainsClass, m_newForest);
			m_diagram.redrawDiagram();
		}
	}
	
	public void updateSwitchContainsClass(RelationClass newContainsClass, Vector newForest)
	{
		m_taListener.containsClassChanging();

		switchContainsClass(newContainsClass, newForest);
		if (undoEnabled()) {
			beginUndoRedo("Switch to " + newContainsClass.getLabel() + " hierarchy");
			new SwitchContainsClass(newContainsClass, newForest);
			endUndoRedo();
		}
		m_taListener.containsClassChanged();
	}
}

