package lsedit;

import java.awt.Color;
import java.awt.Font;

import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class TextBox extends JTextArea
{
	protected static final Color titleColor = Color.red.darker();

	public final static String DEFAULT_TEXT_TITLE_FONT_NAME  = FontCache.DEFAULT_FONT_NAME;
	public final static int    DEFAULT_TEXT_TITLE_FONT_STYLE = Font.BOLD;
	public final static int    DEFAULT_TEXT_TITLE_FONT_SIZE  = 14;

	protected static Font m_titleFont   = FontCache.get(DEFAULT_TEXT_TITLE_FONT_NAME, DEFAULT_TEXT_TITLE_FONT_STYLE, DEFAULT_TEXT_TITLE_FONT_SIZE);

	public final static String DEFAULT_TEXT_TEXT_FONT_NAME  = FontCache.DEFAULT_FONT_NAME;
	public final static int    DEFAULT_TEXT_TEXT_FONT_STYLE = Font.PLAIN;
	public final static int    DEFAULT_TEXT_TEXT_FONT_SIZE  = 11;

	protected static Font m_textFont = FontCache.get(DEFAULT_TEXT_TEXT_FONT_NAME, DEFAULT_TEXT_TEXT_FONT_STYLE, DEFAULT_TEXT_TEXT_FONT_SIZE);

	protected JScrollPane		  m_scroller;	// null if not under any JScrollPane
	protected String			  m_helpString;

	// --------------
	// Public methods 
	// --------------

	public TextBox(JScrollPane scroller, String helpString) 
	{
		m_scroller    = scroller;

		scroller.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED); 
		scroller.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED); 

		m_helpString  = helpString;
		setToolTipText(helpString);

		setBackground(Diagram.boxColor);
		setFont(m_textFont);
		setEditable(false);
//		setSize(5, 5);
		setLineWrap(true);


		if (scroller != null) {
			scroller.setViewportView(this);
	}	}

	public static Font getTitleFont()
	{
		return m_titleFont;
	}

	public static void setTitleFont(Font font)
	{
		m_titleFont = font;
	}

	public static Font getTextFont()
	{
		return m_textFont;
	}

	public static void setTextFont(Font font)
	{
		m_textFont = font;
	}

	public void textFontChanged(Font font)
	{
		setFont(font);
	}

	public void set(String text) 
	{
		setText(text); 
		repaint();
	}
}





