/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import lsedit.ColorCache;
import lsedit.Diagram;
import lsedit.EntityClass;
import lsedit.EntityInstance;
import lsedit.FontCache;
import lsedit.LandscapeClassObject;
import lsedit.LandscapeEditorCore;
import lsedit.LandscapeLayouter;
import lsedit.LandscapeObject;
import lsedit.RelationClass;
import lsedit.RelationInstance;
import lsedit.SortVector;
import lsedit.ToolBarEventHandler;
import lsedit.Util;

public class AAClusterLayout
extends LandscapeLayouter
implements ToolBarEventHandler {
    public static final int TYPE_COLUMN = 0;
    public static final int SOURCE_COLUMN = 1;
    public static final int RELATION_COLUMN = 2;
    public static final int TARGET_COLUMN = 3;
    public static final int ATTRIBUTE_COLUMN = 4;
    public static final int USE_COLUMN = 5;
    public static final int RULE_COMPONENTS = 6;
    public static final String[] g_columnnames = new String[]{"Type", "Source", "Relation", "Target", "Attribute", "Construct"};
    public static final int TYPE_DELETE = 0;
    public static final int TYPE_ANY = 1;
    public static final int TYPE_CLIENT = 2;
    public static final int TYPE_SUPPLIER = 3;
    public static final int TYPE_CLASS = 4;
    public static final int TYPE_CLIENT_CLASS = 5;
    public static final int TYPE_SUPPLIER_CLASS = 6;
    public static final String[] g_typenames = new String[]{"Delete", "Any", "Client", "Supplier", "Class", "Client class", "Supplier class"};
    public static final String g_all_entities = "ALL ENTITIES";
    public static final String g_all_relations = "ALL RELATIONS";
    public static final String g_null = "";
    public static final String g_all = "ALL";
    public static final String[] g_usenames = new String[]{"%a=%v", "%a", "%v", "%c:%a=%v", "%c:%a", "%c"};
    public static final String[] g_metrics = new String[]{"Jaccard", "Simple Matching", "Sorensen-Dice"};
    public static final String[] g_algorithms = new String[]{"Single Linkage", "Complete Linkage", "Weighted Average", "Unweighted Average"};
    public static final String[] g_debugs = new String[]{"Run Silently", "Minimal output", "Verbose debugging"};
    protected Vector m_rules;
    protected MyJTable m_table;
    protected static final int COMMAND = 0;
    protected static final int EXPORT = 1;
    protected static final int IMPORT = 2;
    protected static final int CUTPOINT = 3;
    protected static final String[] m_textfield_tags = new String[]{"aa:command[", "aa:export[", "aa:import[", "aa:cutpoint["};
    protected static final String[] m_textfield_titles = new String[]{"Command to execute AA:", "Exported file used by command:", "Imported file created by command:", "AA Cutpoint:"};
    protected static final String[] m_textfield_resets = new String[]{"/j2sdk1.4.2_04/bin/java.exe -classpath . aa.AA", "junk.mbd", "junk.rsf", "0.0"};
    protected static String[] m_textfield_defaults = new String[]{"/j2sdk1.4.2_04/bin/java.exe -classpath . aa.AA", "junk.mbd", "junk.rsf", "0.0"};
    protected static String[] m_textfield_currents = new String[]{"/j2sdk1.4.2_04/bin/java.exe -classpath . aa.AA", "junk.mbd", "junk.rsf", "0.0"};
    protected static final int DELETEEXPORT = 0;
    protected static final int DELETEIMPORT = 1;
    protected static final int LEAVES = 2;
    protected static final int FEEDBACK = 3;
    protected static final String[] m_checkbox_tags = new String[]{"aa:deleteExport[", "aa:deleteImport[", "aa:leaves[", "aa:feedback["};
    protected static final String[] m_checkbox_titles = new String[]{"Delete export file", "Delete import file", "Cluster leaves", "Feedback"};
    protected static final boolean[] m_checkbox_resets = new boolean[]{false, false, true, true};
    protected static boolean[] m_checkbox_defaults = new boolean[]{false, false, true, true};
    protected static boolean[] m_checkbox_currents = new boolean[]{false, false, true, true};
    protected static final int BUTTON_OK = 0;
    protected static final int BUTTON_CANCEL = 1;
    protected static final int BUTTON_ADD = 2;
    protected static final int BUTTON_HELP = 3;
    protected static final int BUTTON_UNDO = 4;
    protected static final int BUTTON_DEFAULT = 5;
    protected static final int BUTTON_SET = 6;
    protected static final int BUTTON_RESET = 7;
    protected static final String[] m_button_titles = new String[]{"Ok", "Cancel", "Add rule", "Help", null, "Default", "Set", "Reset"};
    protected static final String[] m_button_tips = new String[]{null, null, "Add a new rule", null, "Enable/disable undo", "Use remembered default", "Set default to current", "Set default to initial"};
    protected JComboBox m_metric = new JComboBox<String>(g_metrics);
    protected JComboBox m_algorithm = new JComboBox<String>(g_algorithms);
    protected JComboBox m_debug = new JComboBox<String>(g_debugs);
    protected Diagram m_dg;
    protected String m_ret;

    protected static String parameterString(int n) {
        return m_textfield_currents[n];
    }

    protected static boolean parameterBoolean(int n) {
        return m_checkbox_currents[n];
    }

    public String getTag() {
        return "aa:";
    }

    public void load(String string) {
        String string2;
        int n;
        for (n = 0; n < m_textfield_tags.length; ++n) {
            string2 = m_textfield_tags[n];
            if (!string.startsWith(string2)) continue;
            if ((string = string.substring(string2.length())).charAt(1) != ']' || string.charAt(2) != '=') {
                return;
            }
            int n2 = string.charAt(0) - 48;
            string = string.substring(3);
            switch (n2) {
                case 0: {
                    AAClusterLayout.m_textfield_defaults[n] = string;
                }
                case 1: {
                    AAClusterLayout.m_textfield_currents[n] = string;
                }
            }
            return;
        }
        for (n = 0; n < m_checkbox_tags.length; ++n) {
            string2 = m_checkbox_tags[n];
            if (!string.startsWith(string2)) continue;
            if ((string = string.substring(string2.length())).charAt(1) != ']' || string.charAt(2) != '=') {
                return;
            }
            int n3 = string.charAt(0) - 48;
            boolean bl = (string = string.substring(3)).charAt(0) == 't';
            switch (n3) {
                case 0: {
                    AAClusterLayout.m_checkbox_defaults[n] = bl;
                }
                case 1: {
                    AAClusterLayout.m_checkbox_currents[n] = bl;
                }
            }
            return;
        }
    }

    public void save(BufferedWriter bufferedWriter) throws IOException {
        String[] stringArray = m_textfield_resets;
        boolean[] blArray = m_checkbox_resets;
        String[] stringArray2 = m_textfield_defaults;
        boolean[] blArray2 = m_checkbox_defaults;
        for (int i = 0; i < 2; ++i) {
            String string;
            String string2;
            int n;
            for (n = 0; n < m_textfield_tags.length; ++n) {
                string2 = stringArray2[n];
                if (string2.equals(stringArray[n])) continue;
                string = m_textfield_tags[n];
                bufferedWriter.write(string, 0, string.length());
                bufferedWriter.write(g_null + i + "]=", 0, 3);
                bufferedWriter.write(string2, 0, string2.length());
                bufferedWriter.newLine();
            }
            for (n = 0; n < m_checkbox_tags.length; ++n) {
                boolean bl = blArray2[n];
                if (bl == blArray[n]) continue;
                string = m_checkbox_tags[n];
                bufferedWriter.write(string, 0, string.length());
                bufferedWriter.write(g_null + i + "]=", 0, 3);
                string2 = bl ? "true" : "false";
                bufferedWriter.write(string2, 0, string2.length());
                bufferedWriter.newLine();
            }
            stringArray = stringArray2;
            blArray = blArray2;
            stringArray2 = m_textfield_currents;
            blArray2 = m_checkbox_currents;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void log(String string) {
        if (AAClusterLayout.parameterBoolean(3)) {
            AAClusterLayout aAClusterLayout = this;
            synchronized (aAClusterLayout) {
                System.err.println(Util.toLocaleString() + ": " + string);
            }
        }
    }

    protected void message(String string) {
        this.log(string);
        JOptionPane.showMessageDialog(this.m_ls.getFrame(), string, "Error", 0);
    }

    public AAClusterLayout(LandscapeEditorCore landscapeEditorCore) {
        super(landscapeEditorCore);
        this.m_rules = new Vector();
        MyTableModel myTableModel = new MyTableModel();
        MyJTable myJTable = new MyJTable(myTableModel);
        myTableModel.setJTable(myJTable);
        this.m_table = myJTable;
        this.m_debug.setSelectedIndex(1);
    }

    public String getName() {
        return "AA Cluster";
    }

    public String getMenuLabel() {
        return "AA Cluster";
    }

    public boolean isConfigurable() {
        return true;
    }

    public boolean isLayouter() {
        return false;
    }

    public boolean configure(LandscapeEditorCore landscapeEditorCore, String string) {
        AAClusterConfigure aAClusterConfigure = new AAClusterConfigure(this, string);
        boolean bl = aAClusterConfigure.ok();
        aAClusterConfigure.dispose();
        return bl;
    }

    public boolean configure(LandscapeEditorCore landscapeEditorCore) {
        return this.configure(landscapeEditorCore, null);
    }

    protected void addKeyword(Vector vector, int n, LandscapeClassObject landscapeClassObject, LandscapeObject landscapeObject, String string, String string2) {
        String string3;
        switch (n) {
            case 4: 
            case 5: 
            case 6: {
                landscapeObject = landscapeClassObject;
            }
        }
        int n2 = string2.length();
        int n3 = 0;
        int n4 = 0;
        while ((string3 = landscapeObject.getLsAttributeNameAt(n4)) != null) {
            if (string3.length() > 0 && (string == null || string3.equalsIgnoreCase(string))) {
                ++n3;
                String string4 = g_null;
                block10: for (int i = 0; i < n2; ++i) {
                    char c = string2.charAt(i);
                    if (c != '%' || ++i == n2) {
                        string4 = string4 + c;
                        continue;
                    }
                    c = string2.charAt(i);
                    switch (c) {
                        case 'c': {
                            string4 = string4 + landscapeClassObject.getId();
                            continue block10;
                        }
                        case 'a': {
                            string4 = string4 + string3;
                            continue block10;
                        }
                        case 'v': {
                            string4 = string4 + landscapeObject.getLsAttributeValueAt(n4);
                            continue block10;
                        }
                        case '%': {
                            string4 = string4 + '%';
                            continue block10;
                        }
                        default: {
                            string4 = string4 + (37 + c);
                        }
                    }
                }
                vector.addElement(string4.replaceAll("[ \t\n\r\f]", g_null));
            }
            ++n4;
        }
        if (n3 == 0 && string == null && string2.indexOf(37) < 0) {
            vector.addElement(string2.replaceAll("[ \t\n\r\f]", g_null));
        }
    }

    protected void navigate(Vector vector, int n, RelationInstance relationInstance, EntityInstance entityInstance, Object object, Object object2, String string, String string2) {
        RelationClass relationClass = relationInstance.getRelationClass();
        if (!relationClass.isClassVisible()) {
            return;
        }
        if (object != null && object != relationClass) {
            return;
        }
        if (object2 == null) {
            this.addKeyword(vector, n, relationClass, relationInstance, string, string2);
            return;
        }
        EntityClass entityClass = (EntityClass)entityInstance.getParentClass();
        if (object2 != entityClass && object2 instanceof EntityClass) {
            return;
        }
        this.addKeyword(vector, n, entityClass, entityInstance, string, string2);
    }

    protected boolean write(Vector vector, String string) {
        Diagram diagram = this.m_ls.getDiagram();
        PrintWriter printWriter = null;
        try {
            this.log("Exporting " + string);
            FileWriter fileWriter = new FileWriter(string);
            BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
            printWriter = new PrintWriter(bufferedWriter);
        }
        catch (Exception exception) {
            this.message("Exception creating output stream " + string + ": " + exception);
            return false;
        }
        boolean bl = AAClusterLayout.parameterBoolean(2);
        Vector vector2 = new Vector();
        try {
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                EntityInstance entityInstance = (EntityInstance)enumeration.nextElement();
                EntityClass entityClass = (EntityClass)entityInstance.getParentClass();
                vector2.removeAllElements();
                Enumeration enumeration2 = this.m_rules.elements();
                block8: while (enumeration2.hasMoreElements()) {
                    RelationInstance relationInstance;
                    Enumeration enumeration3;
                    Object object;
                    Rule rule = (Rule)enumeration2.nextElement();
                    JComboBox jComboBox = rule.getValueAt(0);
                    int n = jComboBox.getSelectedIndex();
                    JComboBox jComboBox2 = rule.getValueAt(1);
                    Object object2 = jComboBox2.getSelectedItem();
                    if (object2 != null && object2 != entityClass && object2 instanceof EntityClass) continue;
                    JComboBox jComboBox3 = rule.getValueAt(2);
                    JComboBox jComboBox4 = rule.getValueAt(3);
                    JComboBox jComboBox5 = rule.getValueAt(4);
                    String string2 = (String)jComboBox5.getSelectedItem();
                    if (string2 == g_all) {
                        string2 = null;
                    }
                    JComboBox jComboBox6 = rule.getValueAt(5);
                    String string3 = (String)jComboBox6.getSelectedItem();
                    Object object3 = jComboBox3.getSelectedItem();
                    if (object3 == g_null) {
                        object3 = null;
                    }
                    if (object3 == null) {
                        this.addKeyword(vector2, n, entityClass, entityInstance, string2, string3);
                        continue;
                    }
                    if (!(object3 instanceof RelationClass)) {
                        object3 = null;
                    }
                    if ((object = jComboBox4.getSelectedItem()) == g_null) {
                        object = null;
                    }
                    switch (n) {
                        case 1: 
                        case 3: 
                        case 4: 
                        case 6: {
                            if (bl) {
                                enumeration3 = entityInstance.srcRelationElements();
                                while (enumeration3.hasMoreElements()) {
                                    relationInstance = (RelationInstance)enumeration3.nextElement();
                                    this.navigate(vector2, n, relationInstance, relationInstance.getDst(), object3, object, string2, string3);
                                }
                            } else {
                                enumeration3 = entityInstance.srcLiftedRelationElements();
                                while (enumeration3.hasMoreElements()) {
                                    relationInstance = (RelationInstance)enumeration3.nextElement();
                                    this.navigate(vector2, n, relationInstance, relationInstance.getDrawDst(), object3, object, string2, string3);
                                }
                            }
                            if (n != 3) break;
                            continue block8;
                        }
                    }
                    if (bl) {
                        enumeration3 = entityInstance.dstRelationElements();
                        while (enumeration3.hasMoreElements()) {
                            relationInstance = (RelationInstance)enumeration3.nextElement();
                            this.navigate(vector2, n, relationInstance, relationInstance.getSrc(), object3, object, string2, string3);
                        }
                        continue;
                    }
                    enumeration3 = entityInstance.dstLiftedRelationElements();
                    while (enumeration3.hasMoreElements()) {
                        relationInstance = (RelationInstance)enumeration3.nextElement();
                        this.navigate(vector2, n, relationInstance, relationInstance.getDrawSrc(), object3, object, string2, string3);
                    }
                }
                printWriter.print(entityInstance.getId());
                SortVector.byString(vector2);
                String string4 = null;
                enumeration2 = vector2.elements();
                while (enumeration2.hasMoreElements()) {
                    String string5 = (String)enumeration2.nextElement();
                    if (string5.equals(string4)) continue;
                    printWriter.print(" " + string5);
                    string4 = string5;
                }
                printWriter.print("\n");
            }
            printWriter.close();
            if (printWriter.checkError()) {
                this.message("An unknown error occurred writing output");
                return false;
            }
            this.log("Export written");
        }
        catch (Exception exception) {
            this.message("Exception writing output: " + exception);
            return false;
        }
        return true;
    }

    boolean waitFor(Process process) {
        try {
            int n = process.waitFor();
            this.log("Process returned exit value of " + n);
        }
        catch (Exception exception) {
            this.message("WaitFor failed: " + exception);
            return false;
        }
        return true;
    }

    protected boolean read(String string, EntityInstance entityInstance, boolean bl) {
        EntityInstance entityInstance2;
        BufferedReader bufferedReader;
        Diagram diagram = this.m_ls.getDiagram();
        boolean bl2 = false;
        Hashtable<String, EntityInstance> hashtable = new Hashtable<String, EntityInstance>(20);
        this.log("Importing '" + string + "'");
        try {
            FileReader fileReader = new FileReader(string);
            bufferedReader = new BufferedReader(fileReader);
        }
        catch (Exception exception) {
            this.message("Exception opening " + string + ": " + exception);
            return false;
        }
        int n = 0;
        String string2 = g_null;
        try {
            block6: while ((string2 = bufferedReader.readLine()) != null) {
                ++n;
                String string3 = string2.substring(0, 8);
                if (!string3.equals("contain ")) {
                    this.message("Expected to see 'contain ' but saw '" + string3 + "' in " + string + " at line " + n);
                    break;
                }
                int n2 = string2.indexOf(32, 8);
                if (n2 < 1) {
                    this.message("First token missing in " + string + " at line " + n);
                    break;
                }
                String string4 = string2.substring(8, n2);
                String string5 = string2.substring(n2 + 1);
                if (string5.length() < 1) {
                    this.message("First token missing in " + string + " at line " + n);
                    break;
                }
                if (string4.equals(string5)) continue;
                EntityInstance entityInstance3 = (EntityInstance)hashtable.get(string4);
                if (entityInstance3 == null) {
                    entityInstance3 = diagram.updateNewEntity(null, entityInstance, null, false);
                    entityInstance3.setLabel(string4);
                    hashtable.put(string4, entityInstance3);
                }
                if ((entityInstance2 = (EntityInstance)hashtable.get(string5)) == null) {
                    entityInstance2 = diagram.getCache(string5);
                }
                if (entityInstance2 == null) {
                    entityInstance2 = diagram.updateNewEntity(null, entityInstance3, null, false);
                    entityInstance2.setLabel(string5);
                    hashtable.put(string5, entityInstance2);
                    continue;
                }
                EntityInstance entityInstance4 = entityInstance2.getContainedBy();
                diagram.updateMoveEntityContainment(entityInstance3, entityInstance2);
                if (!bl) continue;
                while (true) {
                    entityInstance2 = entityInstance4;
                    entityInstance4 = entityInstance2.getContainedBy();
                    if (entityInstance2.getFirstChild() != null) continue block6;
                    diagram.updateCutEntity(entityInstance2);
                }
            }
        }
        catch (Exception exception) {
            this.message("Exception reading " + string + ": " + exception);
        }
        if (string2 == null) {
            Enumeration enumeration = hashtable.elements();
            while (enumeration.hasMoreElements()) {
                entityInstance2 = (EntityInstance)enumeration.nextElement();
                diagram.doRelayoutAll(entityInstance2);
            }
            bl2 = true;
        }
        hashtable.clear();
        try {
            bufferedReader.close();
        }
        catch (Exception exception) {
            this.message("Exception closing " + string + ": " + exception);
            return false;
        }
        return bl2;
    }

    public void doit(Vector vector, Vector vector2, EntityInstance entityInstance) {
        Object object;
        int n;
        double d;
        int n2;
        String string;
        String string2;
        String string3;
        block39: {
            String string4;
            do {
                string3 = AAClusterLayout.parameterString(1);
                string2 = AAClusterLayout.parameterString(0);
                string = AAClusterLayout.parameterString(2);
                String string5 = AAClusterLayout.parameterString(3);
                n2 = 0;
                d = -1.0;
                string4 = null;
                if (string3.length() == 0) {
                    string4 = "Please specify an export file to write to";
                } else if (string.length() != 0 && string2.length() == 0) {
                    string4 = "Please specify the command to execute AA";
                } else if (string2.length() != 0 && string.length() == 0) {
                    string4 = "Please specify an import file to read from";
                } else if (this.m_rules.isEmpty()) {
                    string4 = "Please specify rules for generating attribute values";
                } else {
                    try {
                        n2 = Integer.parseInt(string5);
                        if (n2 < 2) {
                            string4 = "Cutpoint specifies less than two clusters are to be formed";
                            n2 = 0;
                        }
                    }
                    catch (Throwable throwable) {
                        n2 = 0;
                        d = -2.0;
                    }
                    if (d == -2.0) {
                        try {
                            d = Double.parseDouble(string5);
                            if (d < 0.0 || d > 1.0) {
                                string4 = "Double precision cutpoint must be between 0.0 and 1.0";
                            }
                        }
                        catch (Throwable throwable) {
                            string4 = "Cutpoint '" + string5 + "' must be an integer or double precision value";
                        }
                    }
                }
                if (string4 == null) break block39;
            } while (this.configure(this.m_ls, string4));
            return;
        }
        if (!string3.endsWith(".mbd")) {
            string3 = string3 + ".mbd";
        }
        if (!string.endsWith(".rsf")) {
            string = string + ".rsf";
        }
        if ((n = vector2.size()) < 3) {
            this.m_ret = "Too few entities to reasonably cluster";
            return;
        }
        this.log("Using AA to cluster " + n + " items");
        if (!this.write(vector2, string3)) {
            return;
        }
        if (string2.length() == 0) {
            this.m_ret = "AA output written to file";
            return;
        }
        String string6 = string2 + " " + string3 + " " + string;
        Process process = null;
        String string7 = n2 != 0 ? g_null + n2 : g_null + d;
        string6 = string6 + " -c" + string7;
        int n3 = this.m_debug.getSelectedIndex();
        if (n3 > 0) {
            string6 = string6 + " -d" + n3;
        }
        if ((n3 = this.m_metric.getSelectedIndex()) > 0) {
            string6 = string6 + " -s" + n3;
        }
        if ((n3 = this.m_algorithm.getSelectedIndex()) > 0) {
            string6 = string6 + " -a" + n3;
        }
        this.log("Executing [" + string6 + "]");
        try {
            object = Runtime.getRuntime();
            if (object == null) {
                this.message("No runtime available");
                return;
            }
            process = ((Runtime)object).exec(string6);
            EchoOutput echoOutput = new EchoOutput("AA Stdout", process.getInputStream());
            new Thread(echoOutput).start();
            echoOutput = new EchoOutput("AA Stderr", process.getErrorStream());
            new Thread(echoOutput).start();
        }
        catch (Exception exception) {
            this.message("Exception executing [" + string6 + "] " + exception);
            return;
        }
        if (!this.waitFor(process)) {
            return;
        }
        if (!this.read(string = string.substring(0, string.length() - 4) + string7 + ".rsf", entityInstance, vector != vector2)) {
            return;
        }
        this.log("Import loaded");
        if (AAClusterLayout.parameterBoolean(1)) {
            try {
                object = new File(string);
                if (!((File)object).delete()) {
                    this.message("Unable to delete '" + object + "'");
                } else {
                    this.log("Deleted " + object);
                }
            }
            catch (Exception exception) {
                this.message("Exception deleting '" + string + "' " + exception);
            }
        }
        if (string3.length() != 0 && AAClusterLayout.parameterBoolean(0)) {
            try {
                object = new File(string3);
                if (!((File)object).delete()) {
                    this.message("Unable to delete '" + object + "'");
                } else {
                    this.log("Deleted " + object);
                }
            }
            catch (Exception exception) {
                this.message("Exception deleting '" + string3 + "' " + exception);
            }
        }
        this.m_ret = "Graph redrawn using AA Cluster Layout";
    }

    public void doLayout1(Vector vector, EntityInstance entityInstance) {
    }

    public String doLayout(Diagram diagram) {
        Vector vector;
        this.m_dg = diagram;
        Vector vector2 = diagram.getGroup();
        if (vector2 == null) {
            Util.beep();
            return "No group selected";
        }
        EntityInstance entityInstance = this.parentOfSet(vector2);
        if (entityInstance == null) {
            return "Cluster layout requires that all things laid out share same parent";
        }
        boolean bl = AAClusterLayout.parameterBoolean(2);
        if (!bl) {
            vector = vector2;
        } else {
            vector = new Vector();
            Enumeration enumeration = vector2.elements();
            while (enumeration.hasMoreElements()) {
                EntityInstance entityInstance2 = (EntityInstance)enumeration.nextElement();
                entityInstance2.gatherLeaves(vector);
            }
        }
        this.m_ret = "AA Cluster layout aborted";
        this.m_ls.setCursor(3);
        diagram.beginUndoRedo("Cluster layout");
        this.doit(vector2, vector, entityInstance);
        diagram.endUndoRedo();
        this.m_ls.setCursor(0);
        diagram.redrawDiagram();
        return this.m_ret;
    }

    public void processKeyEvent(int n, int n2, Object object) {
        Diagram diagram = this.m_ls.getDiagram();
        if (diagram != null) {
            String string = this.doLayout(diagram);
            this.m_ls.doFeedback(string);
            diagram.rescaleDiagram();
            this.m_ls.repaintDg();
        }
    }

    class EchoOutput
    implements Runnable {
        InputStream m_inputStream = null;
        String m_source;

        EchoOutput(String string, InputStream inputStream) {
            this.m_inputStream = inputStream;
            this.m_source = string;
        }

        public void run() {
            String string = this.m_source;
            try {
                String string2;
                InputStreamReader inputStreamReader = new InputStreamReader(this.m_inputStream);
                BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                while ((string2 = bufferedReader.readLine()) != null) {
                    AAClusterLayout.this.log(string + ": " + string2);
                }
                bufferedReader.close();
            }
            catch (Exception exception) {
                AAClusterLayout.this.log(string + " input error: " + exception);
            }
        }
    }

    class AAClusterConfigure
    extends JDialog
    implements ActionListener {
        protected JTextField[] m_textfields;
        protected JCheckBox[] m_checkboxes;
        protected JButton[] m_buttons;
        protected JLabel m_message;
        protected boolean m_isok;

        public AAClusterConfigure(AAClusterLayout aAClusterLayout2, String string) {
            JLabel jLabel;
            int n;
            super(aAClusterLayout2.getLs().getFrame(), aAClusterLayout2.getName() + " Configuration", true);
            this.m_isok = false;
            Font font = FontCache.getDialogFont();
            Font font2 = font.deriveFont(1);
            Container container = this.getContentPane();
            container.setLayout(new BorderLayout());
            this.setForeground(ColorCache.get(0, 0, 0));
            this.setBackground(ColorCache.get(192, 192, 192));
            this.setFont(font);
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BorderLayout());
            JPanel jPanel2 = new JPanel();
            GridLayout gridLayout = new GridLayout(7, 1, 0, 10);
            jPanel2.setLayout(gridLayout);
            JPanel jPanel3 = new JPanel();
            gridLayout = new GridLayout(7, 1, 0, 10);
            jPanel3.setLayout(gridLayout);
            this.m_textfields = new JTextField[m_textfield_tags.length];
            for (n = 0; n < m_textfield_tags.length; ++n) {
                JTextField jTextField;
                this.m_textfields[n] = jTextField = new JTextField(m_textfield_currents[n], 60);
                jLabel = new JLabel(m_textfield_titles[n], 4);
                jLabel.setFont(font2);
                jPanel2.add(jLabel);
                jTextField.setFont(font);
                jPanel3.add(jTextField);
            }
            jLabel = new JLabel("Similarity metric:", 4);
            jLabel.setFont(font2);
            jPanel2.add(jLabel);
            AAClusterLayout.this.m_metric.setFont(font2);
            jPanel3.add(AAClusterLayout.this.m_metric);
            jLabel = new JLabel("Cluster algorithm:", 4);
            jLabel.setFont(font2);
            jPanel2.add(jLabel);
            AAClusterLayout.this.m_algorithm.setFont(font2);
            jPanel3.add(AAClusterLayout.this.m_algorithm);
            jLabel = new JLabel("Tracing within AA:", 4);
            jLabel.setFont(font2);
            jPanel2.add(jLabel);
            AAClusterLayout.this.m_debug.setFont(font2);
            jPanel3.add(AAClusterLayout.this.m_debug);
            JPanel jPanel4 = new JPanel();
            jPanel4.setLayout(new FlowLayout(1, 15, 15));
            this.m_checkboxes = new JCheckBox[m_checkbox_tags.length];
            for (n = 0; n < m_checkbox_tags.length; ++n) {
                JCheckBox jCheckBox;
                this.m_checkboxes[n] = jCheckBox = new JCheckBox(m_checkbox_titles[n], m_checkbox_currents[n]);
                jCheckBox.setFont(font);
                jPanel4.add(jCheckBox);
            }
            jPanel.add("West", jPanel2);
            jPanel.add("East", jPanel3);
            jPanel.add("South", jPanel4);
            MyJTable myJTable = AAClusterLayout.this.m_table;
            myJTable.setFont(font);
            JTableHeader jTableHeader = myJTable.getTableHeader();
            jTableHeader.setFont(font2);
            FontMetrics fontMetrics = this.getFontMetrics(font);
            myJTable.setRowHeight(fontMetrics.getHeight() + 4);
            myJTable.setVisible(true);
            JScrollPane jScrollPane = new JScrollPane(myJTable);
            jScrollPane.setVisible(true);
            JPanel jPanel5 = new JPanel();
            jPanel5.setLayout(new BorderLayout());
            if (string == null) {
                string = AAClusterLayout.this.m_ls.getDiagram().undoEnabled() ? "You might wish to disable undo/redo operations" : "You might wish to enable undo/redo operations";
            }
            this.m_message = new JLabel(string, 0);
            this.m_message.setFont(font);
            this.m_message.setForeground(Color.RED);
            this.m_message.setSize(400, 50);
            this.m_message.setPreferredSize(new Dimension(400, 50));
            jPanel4 = new JPanel();
            jPanel4.setLayout(new FlowLayout(1, 15, 15));
            this.m_buttons = new JButton[m_button_titles.length];
            for (n = 0; n < m_button_titles.length; ++n) {
                JButton jButton;
                String string2 = m_button_titles[n];
                if (string2 == null) {
                    string2 = AAClusterLayout.this.undoLabel();
                }
                this.m_buttons[n] = jButton = new JButton(string2);
                jButton.setFont(font2);
                String string3 = m_button_tips[n];
                if (string3 != null) {
                    jButton.setToolTipText(string3);
                }
                jButton.addActionListener(this);
                jPanel4.add(jButton);
            }
            jPanel5.add("North", this.m_message);
            jPanel5.add("South", jPanel4);
            container.add("North", jPanel);
            container.add("Center", jScrollPane);
            container.add("South", jPanel5);
            this.pack();
            this.setVisible(true);
        }

        public boolean ok() {
            return this.m_isok;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            Object object = actionEvent.getSource();
            int n2 = -1;
            for (n = 0; n < m_button_titles.length; ++n) {
                if (object != this.m_buttons[n]) continue;
                n2 = n;
                break;
            }
            switch (n2) {
                case 7: {
                    for (n = 0; n < m_textfield_tags.length; ++n) {
                        AAClusterLayout.m_textfield_defaults[n] = m_textfield_resets[n];
                    }
                    for (n = 0; n < m_checkbox_tags.length; ++n) {
                        AAClusterLayout.m_checkbox_defaults[n] = m_checkbox_resets[n];
                    }
                }
                case 5: {
                    for (n = 0; n < m_textfield_tags.length; ++n) {
                        this.m_textfields[n].setText(m_textfield_defaults[n]);
                    }
                    for (n = 0; n < m_checkbox_tags.length; ++n) {
                        this.m_checkboxes[n].setSelected(m_checkbox_defaults[n]);
                    }
                    AAClusterLayout.this.m_metric.setSelectedIndex(0);
                    AAClusterLayout.this.m_algorithm.setSelectedIndex(0);
                    AAClusterLayout.this.m_debug.setSelectedIndex(0);
                    return;
                }
                case 6: {
                    for (n = 0; n < m_textfield_tags.length; ++n) {
                        AAClusterLayout.m_textfield_defaults[n] = this.m_textfields[n].getText();
                    }
                    for (n = 0; n < m_checkbox_tags.length; ++n) {
                        AAClusterLayout.m_checkbox_defaults[n] = this.m_checkboxes[n].isSelected();
                    }
                    return;
                }
                case 4: {
                    LandscapeEditorCore landscapeEditorCore = AAClusterLayout.this.m_ls;
                    landscapeEditorCore.invertUndo();
                    this.m_buttons[n2].setText(AAClusterLayout.this.undoLabel());
                    this.m_message.setText(AAClusterLayout.g_null);
                    return;
                }
                case 2: {
                    AAClusterLayout.this.m_rules.addElement(new Rule());
                    AAClusterLayout.this.m_table.revalidate();
                    AAClusterLayout.this.m_table.repaint();
                    return;
                }
                case 3: {
                    JOptionPane.showMessageDialog(AAClusterLayout.this.m_ls.getFrame(), "The AA clustering algorithm attempts to cluster nodes on the basis of\nattributes that have the same or somewhat similar values in distinct\nentities. Specify the rules here which will produce the input attribute\nvalues on which clustering is to be performed.  Each such rule contains\nsix components:\n\n1) The rule to use when navigating from the entity to be clustered.  If\n   client/supplier is specified restrict navigation to in/out edges. If\n\t  class is specified recover attributes from the entity/relation class.\n2) The entity class for which this rule is to be considered applicable.\n3) The relation class if any to use when navigating to the object from\n   which attributes are to be recovered.\n4) The class of entity reached from such relations if any from which the\n   attributes are to be recovered.\n5) The attribute to be recovered from the resulting entity or relation.\n   Select one of the choices or enter the name of the desired attribute.\n6) The format of the value to be emitted as input to AA. This is a format\n   string in which %c expands to class name, %a to attribute name, %v to\n   attribute value and %% to %.\n\nOutput values derived from any of the specified rules will be emitted.\nUse the [add] button to create new rules, and selecte [Delete] option in\nthe rules first component to delete existing rules.\n\nIf the cutpoint is an integer then AA will attempt to create this number\nof clusters.  If it is a double precision value between 0.0 and 1.0, this\nvalue will be used as the desired cutpoint.", "Help", 0);
                    return;
                }
                case 0: {
                    for (n = 0; n < m_textfield_tags.length; ++n) {
                        AAClusterLayout.m_textfield_currents[n] = this.m_textfields[n].getText();
                    }
                    for (n = 0; n < m_checkbox_tags.length; ++n) {
                        AAClusterLayout.m_checkbox_currents[n] = this.m_checkboxes[n].isSelected();
                    }
                    this.m_isok = true;
                }
                case 1: {
                    break;
                }
                default: {
                    return;
                }
            }
            this.setVisible(false);
        }
    }

    protected class MyJTable
    extends JTable {
        public MyJTable(AbstractTableModel abstractTableModel) {
            super(abstractTableModel);
        }

        public TableCellRenderer getCellRenderer(int n, int n2) {
            return new CellRenderer();
        }

        public TableCellEditor getCellEditor(int n, int n2) {
            return new CellEditor(n, n2);
        }
    }

    protected class MyTableModel
    extends AbstractTableModel {
        JTable m_table;

        public void setJTable(JTable jTable) {
            this.m_table = jTable;
        }

        public int getRowCount() {
            return AAClusterLayout.this.m_rules.size();
        }

        public int getColumnCount() {
            return 6;
        }

        public String getColumnName(int n) {
            return g_columnnames[n];
        }

        public boolean isCellEditable(int n, int n2) {
            Rule rule = (Rule)AAClusterLayout.this.m_rules.elementAt(n);
            JComboBox jComboBox = rule.getValueAt(n2);
            return jComboBox.getItemCount() > 1;
        }

        public Object getValueAt(int n, int n2) {
            Rule rule = (Rule)AAClusterLayout.this.m_rules.elementAt(n);
            JComboBox jComboBox = rule.getValueAt(n2);
            return jComboBox;
        }

        public void setValueAt(Object object, int n, int n2) {
        }
    }

    class CellEditor
    extends DefaultCellEditor {
        JComboBox m_comboBox;

        public CellEditor(int n, int n2) {
            super(((Rule)AAClusterLayout.this.m_rules.elementAt(n)).getValueAt(n2));
            this.m_comboBox = (JComboBox)this.editorComponent;
            this.setClickCountToStart(1);
            this.m_comboBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    CellEditor.this.fireEditingStopped();
                }
            });
        }

        public Object getCellEditorValue() {
            return this.m_comboBox;
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            return this.editorComponent;
        }
    }

    protected class CellRenderer
    extends JTextField
    implements TableCellRenderer {
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Object object2 = ((JComboBox)object).getSelectedItem();
            String string = object2 == null ? AAClusterLayout.g_null : (object2 instanceof LandscapeClassObject ? ((LandscapeClassObject)object2).getId() : (String)object2);
            this.setText(string);
            return this;
        }
    }

    class Rule
    implements ActionListener {
        private JComboBox[] m_components = new JComboBox[6];

        private void addAttributeNames(LandscapeObject landscapeObject, Vector vector) {
            String string;
            int n = 0;
            while ((string = landscapeObject.getLsAttributeNameAt(n)) != null) {
                if (string.length() > 0) {
                    vector.addElement(string);
                }
                ++n;
            }
        }

        private void addAllEntityAttributeNames(Vector vector) {
            Diagram diagram = AAClusterLayout.this.m_ls.getDiagram();
            if (diagram != null) {
                Enumeration enumeration = diagram.enumEntityClassesInOrder();
                while (enumeration.hasMoreElements()) {
                    EntityClass entityClass = (EntityClass)enumeration.nextElement();
                    this.addAttributeNames(entityClass, vector);
                }
            }
        }

        private void addAllRelationAttributeNames(Vector vector) {
            Diagram diagram = AAClusterLayout.this.m_ls.getDiagram();
            if (diagram != null) {
                Enumeration enumeration = diagram.enumRelationClassesInOrder();
                while (enumeration.hasMoreElements()) {
                    RelationClass relationClass = (RelationClass)enumeration.nextElement();
                    this.addAttributeNames(relationClass, vector);
                }
            }
        }

        private void setAttributeColumn() {
            JComboBox jComboBox = this.getValueAt(4);
            JComboBox jComboBox2 = this.getValueAt(0);
            JComboBox jComboBox3 = this.getValueAt(3);
            Object object = jComboBox3.getSelectedItem();
            jComboBox.removeAllItems();
            jComboBox.addItem(AAClusterLayout.g_all);
            switch (jComboBox2.getSelectedIndex()) {
                case 4: 
                case 5: 
                case 6: {
                    Object object2;
                    Serializable serializable;
                    if (!(object != null && object != AAClusterLayout.g_null || (object = ((JComboBox)(serializable = this.getValueAt(2))).getSelectedItem()) != null && object != AAClusterLayout.g_null)) {
                        object2 = this.getValueAt(1);
                        object = ((JComboBox)object2).getSelectedItem();
                    }
                    if (object != null) {
                        serializable = new Vector();
                        if (object == AAClusterLayout.g_all_entities) {
                            this.addAllEntityAttributeNames((Vector)serializable);
                        } else if (object == AAClusterLayout.g_all_relations) {
                            this.addAllRelationAttributeNames((Vector)serializable);
                        } else {
                            this.addAttributeNames((LandscapeObject)object, (Vector)serializable);
                        }
                        SortVector.byString((Vector)serializable);
                        String string = null;
                        object2 = ((Vector)serializable).elements();
                        while (object2.hasMoreElements()) {
                            String string2 = (String)object2.nextElement();
                            if (string2.equals(string)) continue;
                            jComboBox.addItem(string2);
                            string = string2;
                        }
                    }
                    jComboBox.setEditable(false);
                    break;
                }
                default: {
                    jComboBox.addItem(AAClusterLayout.g_null);
                    jComboBox.setEditable(true);
                }
            }
            jComboBox.setSelectedIndex(0);
        }

        private void addEntityClasses(JComboBox jComboBox) {
            Diagram diagram = AAClusterLayout.this.m_ls.getDiagram();
            Vector vector = new Vector();
            jComboBox.addItem(AAClusterLayout.g_all_entities);
            Enumeration enumeration = diagram.enumEntityClasses();
            while (enumeration.hasMoreElements()) {
                vector.addElement(enumeration.nextElement());
            }
            SortVector.byString(vector);
            enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                jComboBox.addItem(e);
            }
            jComboBox.setSelectedIndex(0);
        }

        private void addRelationClasses(JComboBox jComboBox) {
            Diagram diagram = AAClusterLayout.this.m_ls.getDiagram();
            Vector vector = new Vector();
            jComboBox.addItem(AAClusterLayout.g_all_relations);
            Enumeration enumeration = diagram.enumRelationClasses();
            while (enumeration.hasMoreElements()) {
                vector.addElement(enumeration.nextElement());
            }
            SortVector.byString(vector);
            enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                jComboBox.addItem(e);
            }
            jComboBox.setSelectedIndex(0);
        }

        private void setTargetColumn() {
            JComboBox jComboBox = this.getValueAt(3);
            JComboBox jComboBox2 = this.getValueAt(2);
            int n = jComboBox2.getSelectedIndex();
            jComboBox.removeAllItems();
            jComboBox.addItem(AAClusterLayout.g_null);
            if (n > 0) {
                this.addEntityClasses(jComboBox);
            }
            jComboBox.setSelectedIndex(0);
        }

        private void setRelationColumn() {
            JComboBox jComboBox = this.getValueAt(2);
            JComboBox jComboBox2 = this.getValueAt(0);
            jComboBox.removeAllItems();
            jComboBox.addItem(AAClusterLayout.g_null);
            this.addRelationClasses(jComboBox);
            jComboBox.setSelectedIndex(0);
        }

        private void setSourceColumn() {
            JComboBox jComboBox = this.getValueAt(1);
            Diagram diagram = AAClusterLayout.this.m_ls.getDiagram();
            jComboBox.removeAllItems();
            if (diagram == null) {
                jComboBox.addItem(AAClusterLayout.g_null);
            } else {
                this.addEntityClasses(jComboBox);
            }
        }

        public JComboBox getValueAt(int n) {
            return this.m_components[n];
        }

        public Rule() {
            this.m_components[0] = new JComboBox<String>(g_typenames);
            this.m_components[1] = new JComboBox();
            this.m_components[2] = new JComboBox();
            this.m_components[3] = new JComboBox();
            this.m_components[4] = new JComboBox();
            this.m_components[5] = new JComboBox<String>(g_usenames);
            JComboBox jComboBox = this.getValueAt(0);
            jComboBox.setSelectedIndex(1);
            jComboBox.setMaximumRowCount(g_typenames.length);
            jComboBox.addActionListener(this);
            jComboBox = this.getValueAt(1);
            jComboBox.setMaximumRowCount(12);
            jComboBox.addActionListener(this);
            this.setSourceColumn();
            jComboBox = this.getValueAt(2);
            jComboBox.setMaximumRowCount(12);
            jComboBox.addActionListener(this);
            this.setRelationColumn();
            jComboBox = this.getValueAt(3);
            jComboBox.setMaximumRowCount(12);
            jComboBox.addActionListener(this);
            this.setTargetColumn();
            jComboBox = this.getValueAt(4);
            jComboBox.setMaximumRowCount(12);
            jComboBox.addActionListener(this);
            this.setAttributeColumn();
            jComboBox = this.getValueAt(5);
            jComboBox.setSelectedIndex(0);
            jComboBox.setMaximumRowCount(g_usenames.length);
            jComboBox.setEditable(true);
            jComboBox.addActionListener(this);
        }

        public boolean repaintRow(int n) {
            return true;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            int n = 0;
            while (true) {
                if (n >= 6) {
                    return;
                }
                if (object == this.m_components[n]) break;
                ++n;
            }
            JComboBox jComboBox = (JComboBox)object;
            int n2 = jComboBox.getSelectedIndex();
            if (n2 < 0) {
                return;
            }
            switch (n) {
                case 0: {
                    switch (n2) {
                        case 0: {
                            AAClusterLayout.this.m_rules.remove(this);
                            break;
                        }
                        default: {
                            this.setSourceColumn();
                        }
                    }
                }
                case 1: {
                    this.setRelationColumn();
                }
                case 2: {
                    this.setTargetColumn();
                }
                case 3: {
                    this.setAttributeColumn();
                }
            }
            AAClusterLayout.this.m_table.revalidate();
            AAClusterLayout.this.m_table.repaint();
        }
    }
}

