/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import lsedit.ColorCache;
import lsedit.Diagram;
import lsedit.EntityInstance;
import lsedit.FontCache;
import lsedit.LandscapeEditorCore;
import lsedit.LandscapeLayouter;
import lsedit.RelationClass;
import lsedit.RelationInstance;
import lsedit.ToolBarEventHandler;
import lsedit.Util;

public class ACDCClusterLayout
extends LandscapeLayouter
implements ToolBarEventHandler {
    public static final String[] g_pattern = new String[]{"Body/Subgraph/Orphan", "Body/Orphan/Subgraph", "Body/Subgraph", "Body/Orphan", "Body", "Subgraph/Body/Orphan", "Subgraph/Orphan/Body", "Subgraph/Body", "Subgraph/Orphan", "Subgraph", "Orphan/Body/Subgraph", "Orphan/Subgraph/Body", "Orphan/Subgraph", "Orphan/Body", "Orphan"};
    public static final String[] g_patterncode = new String[]{"bso", "bos", "bs", "bo", "b", "sbo", "sob", "sb", "so", "s", "obs", "osb", "os", "ob", "o"};
    public static final String[] g_filter = new String[]{"All", "Files within Modules", "Files"};
    public static final String[] g_debugs = new String[]{"Run Silently", "Minimal output", "Verbose debugging"};
    protected static final int COMMAND = 0;
    protected static final int EXPORT = 1;
    protected static final int IMPORT = 2;
    protected static final int MAXSIZE = 3;
    protected static final int CONTAINER = 4;
    protected static final String[] m_textfield_tags = new String[]{"acdc:command[", "acdc:export[", "acdc:import[", "acdc:maxsize[", "acdc:container["};
    protected static final String[] m_textfield_titles = new String[]{"Command to execute ACDC:", "Exported file used by command:", "Imported file created by command:", "Optional maximum cluster size:", "Optional container:"};
    protected static final String[] m_textfield_resets = new String[]{"/j2sdk1.4.2_04/bin/java.exe -classpath . acdc.ACDC", "junk.ta", "junk.rsf", "", ""};
    protected static String[] m_textfield_defaults = new String[]{"/j2sdk1.4.2_04/bin/java.exe -classpath . acdc.ACDC", "junk.ta", "junk.rsf", "", ""};
    protected static String[] m_textfield_currents = new String[]{"/j2sdk1.4.2_04/bin/java.exe -classpath . acdc.ACDC", "junk.ta", "junk.rsf", "", ""};
    protected static final int DELETEEXPORT = 0;
    protected static final int DELETEIMPORT = 1;
    protected static final int LEAVES = 2;
    protected static final int FEEDBACK = 3;
    protected static final int GUI = 4;
    protected static final String[] m_checkbox_tags = new String[]{"acdc:deleteExport[", "acdc:deleteImport[", "acdc:leaves[", "acdc:feedback[", "acdc:gui["};
    protected static final String[] m_checkbox_titles = new String[]{"Delete export file", "Delete import file", "Cluster leaves", "Feedback", "Popup gui"};
    protected static final boolean[] m_checkbox_resets = new boolean[]{false, false, true, true, false};
    protected static boolean[] m_checkbox_defaults = new boolean[]{false, false, true, true, false};
    protected static boolean[] m_checkbox_currents = new boolean[]{false, false, true, true, false};
    protected static final int BUTTON_OK = 0;
    protected static final int BUTTON_CANCEL = 1;
    protected static final int BUTTON_HELP = 2;
    protected static final int BUTTON_UNDO = 3;
    protected static final int BUTTON_DEFAULT = 4;
    protected static final int BUTTON_SET = 5;
    protected static final int BUTTON_RESET = 6;
    protected static final String[] m_button_titles = new String[]{"Ok", "Cancel", "Help", null, "Default", "Set", "Reset"};
    protected static final String[] m_button_tips = new String[]{null, null, null, "Enable/disable undo", "Use remembered default", "Set default to current", "Set default to initial"};
    protected JComboBox m_pattern = new JComboBox<String>(g_pattern);
    protected JComboBox m_filter = new JComboBox<String>(g_filter);
    protected JComboBox m_debug = new JComboBox<String>(g_debugs);
    protected Diagram m_dg;
    protected String m_ret;

    protected static String parameterString(int n) {
        return m_textfield_currents[n];
    }

    protected static boolean parameterBoolean(int n) {
        return m_checkbox_currents[n];
    }

    public String getTag() {
        return "acdc:";
    }

    public void load(String string) {
        String string2;
        int n;
        for (n = 0; n < m_textfield_tags.length; ++n) {
            string2 = m_textfield_tags[n];
            if (!string.startsWith(string2)) continue;
            if ((string = string.substring(string2.length())).charAt(1) != ']' || string.charAt(2) != '=') {
                return;
            }
            int n2 = string.charAt(0) - 48;
            string = string.substring(3);
            switch (n2) {
                case 0: {
                    ACDCClusterLayout.m_textfield_defaults[n] = string;
                }
                case 1: {
                    ACDCClusterLayout.m_textfield_currents[n] = string;
                }
            }
            return;
        }
        for (n = 0; n < m_checkbox_tags.length; ++n) {
            string2 = m_checkbox_tags[n];
            if (!string.startsWith(string2)) continue;
            if ((string = string.substring(string2.length())).charAt(1) != ']' || string.charAt(2) != '=') {
                return;
            }
            int n3 = string.charAt(0) - 48;
            boolean bl = (string = string.substring(3)).charAt(0) == 't';
            switch (n3) {
                case 0: {
                    ACDCClusterLayout.m_checkbox_defaults[n] = bl;
                }
                case 1: {
                    ACDCClusterLayout.m_checkbox_currents[n] = bl;
                }
            }
            return;
        }
    }

    public void save(BufferedWriter bufferedWriter) throws IOException {
        String[] stringArray = m_textfield_resets;
        boolean[] blArray = m_checkbox_resets;
        String[] stringArray2 = m_textfield_defaults;
        boolean[] blArray2 = m_checkbox_defaults;
        for (int i = 0; i < 2; ++i) {
            String string;
            String string2;
            int n;
            for (n = 0; n < m_textfield_tags.length; ++n) {
                string2 = stringArray2[n];
                if (string2.equals(stringArray[n])) continue;
                string = m_textfield_tags[n];
                bufferedWriter.write(string, 0, string.length());
                bufferedWriter.write("" + i + "]=", 0, 3);
                bufferedWriter.write(string2, 0, string2.length());
                bufferedWriter.newLine();
            }
            for (n = 0; n < m_checkbox_tags.length; ++n) {
                boolean bl = blArray2[n];
                if (bl == blArray[n]) continue;
                string = m_checkbox_tags[n];
                bufferedWriter.write(string, 0, string.length());
                bufferedWriter.write("" + i + "]=", 0, 3);
                string2 = bl ? "true" : "false";
                bufferedWriter.write(string2, 0, string2.length());
                bufferedWriter.newLine();
            }
            stringArray = stringArray2;
            blArray = blArray2;
            stringArray2 = m_textfield_currents;
            blArray2 = m_checkbox_currents;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void log(String string) {
        if (ACDCClusterLayout.parameterBoolean(3)) {
            ACDCClusterLayout aCDCClusterLayout = this;
            synchronized (aCDCClusterLayout) {
                System.err.println(Util.toLocaleString() + ": " + string);
            }
        }
    }

    protected void message(String string) {
        this.log(string);
        JOptionPane.showMessageDialog(this.m_ls.getFrame(), string, "Error", 0);
    }

    public ACDCClusterLayout(LandscapeEditorCore landscapeEditorCore) {
        super(landscapeEditorCore);
        this.m_debug.setSelectedIndex(1);
    }

    public String getName() {
        return "ACDC Cluster";
    }

    public String getMenuLabel() {
        return "ACDC Cluster";
    }

    public boolean isConfigurable() {
        return true;
    }

    public boolean isLayouter() {
        return false;
    }

    public boolean configure(LandscapeEditorCore landscapeEditorCore, String string) {
        ACDCClusterConfigure aCDCClusterConfigure = new ACDCClusterConfigure(this, string);
        boolean bl = aCDCClusterConfigure.ok();
        aCDCClusterConfigure.dispose();
        return bl;
    }

    public boolean configure(LandscapeEditorCore landscapeEditorCore) {
        return this.configure(landscapeEditorCore, null);
    }

    protected boolean write(Vector vector, String string) {
        Object object;
        Enumeration enumeration;
        Diagram diagram = this.m_ls.getDiagram();
        PrintStream printStream = null;
        try {
            this.log("Exporting " + string);
            File file = new File(string);
            enumeration = new FileOutputStream(file);
            object = new BufferedOutputStream((OutputStream)((Object)enumeration));
            printStream = new PrintStream((OutputStream)object);
        }
        catch (Exception exception) {
            this.message("Exception creating export stream " + string + ": " + exception);
            return false;
        }
        boolean bl = ACDCClusterLayout.parameterBoolean(2);
        try {
            EntityInstance entityInstance;
            printStream.print("FACT TUPLE :\n");
            enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                entityInstance = (EntityInstance)enumeration.nextElement();
                entityInstance.writeInstance(printStream);
                entityInstance.orMark(0x4000000);
            }
            enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                EntityInstance entityInstance2;
                RelationClass relationClass;
                RelationInstance relationInstance;
                entityInstance = (EntityInstance)enumeration.nextElement();
                if (bl) {
                    object = entityInstance.srcRelationElements();
                    while (object.hasMoreElements()) {
                        relationInstance = (RelationInstance)object.nextElement();
                        relationClass = relationInstance.getRelationClass();
                        if (!relationClass.isClassVisible() || !(entityInstance2 = relationInstance.getDst()).isMarked(0x4000000)) continue;
                        relationInstance.writeRelation(printStream);
                    }
                    continue;
                }
                object = entityInstance.srcLiftedRelationElements();
                while (object.hasMoreElements()) {
                    relationInstance = (RelationInstance)object.nextElement();
                    relationClass = relationInstance.getRelationClass();
                    if (!relationClass.isClassVisible() || !(entityInstance2 = relationInstance.getDrawDst()).isMarked(0x4000000)) continue;
                    relationInstance.writeRelation(printStream);
                }
            }
            printStream.close();
            if (printStream.checkError()) {
                this.message("An unknown error occurred writing output");
                return false;
            }
            this.log("Export written");
        }
        catch (Exception exception) {
            this.message("Exception writing output: " + exception);
            return false;
        }
        return true;
    }

    boolean waitFor(Process process) {
        try {
            int n = process.waitFor();
            this.log("Process returned exit value of " + n);
        }
        catch (Exception exception) {
            this.message("WaitFor failed: " + exception);
            return false;
        }
        return true;
    }

    protected boolean read(String string, EntityInstance entityInstance, boolean bl) {
        EntityInstance entityInstance2;
        BufferedReader bufferedReader;
        Diagram diagram = this.m_ls.getDiagram();
        boolean bl2 = false;
        Hashtable<String, EntityInstance> hashtable = new Hashtable<String, EntityInstance>(20);
        this.log("Importing '" + string + "'");
        try {
            FileReader fileReader = new FileReader(string);
            bufferedReader = new BufferedReader(fileReader);
        }
        catch (Exception exception) {
            this.message("Exception opening " + string + ": " + exception);
            return false;
        }
        int n = 0;
        String string2 = "";
        try {
            block6: while ((string2 = bufferedReader.readLine()) != null) {
                ++n;
                String string3 = string2.substring(0, 8);
                if (!string3.equals("contain ")) {
                    this.message("Expected to see 'contain ' but saw '" + string3 + "' in " + string + " at line " + n);
                    break;
                }
                int n2 = string2.indexOf(32, 8);
                if (n2 < 1) {
                    this.message("First token missing in " + string + " at line " + n);
                    break;
                }
                String string4 = string2.substring(8, n2);
                String string5 = string2.substring(n2 + 1);
                if (string5.length() < 1) {
                    this.message("First token missing in " + string + " at line " + n);
                    break;
                }
                if (string4.equals(string5)) continue;
                EntityInstance entityInstance3 = (EntityInstance)hashtable.get(string4);
                if (entityInstance3 == null) {
                    entityInstance3 = diagram.updateNewEntity(null, entityInstance, null, false);
                    entityInstance3.setLabel(string4);
                    hashtable.put(string4, entityInstance3);
                }
                if ((entityInstance2 = (EntityInstance)hashtable.get(string5)) == null) {
                    entityInstance2 = diagram.getCache(string5);
                }
                if (entityInstance2 == null) {
                    entityInstance2 = diagram.updateNewEntity(null, entityInstance3, null, false);
                    entityInstance2.setLabel(string5);
                    hashtable.put(string5, entityInstance2);
                    continue;
                }
                EntityInstance entityInstance4 = entityInstance2.getContainedBy();
                diagram.updateMoveEntityContainment(entityInstance3, entityInstance2);
                if (!bl) continue;
                while (true) {
                    entityInstance2 = entityInstance4;
                    entityInstance4 = entityInstance2.getContainedBy();
                    if (entityInstance2.getFirstChild() != null) continue block6;
                    diagram.updateCutEntity(entityInstance2);
                }
            }
        }
        catch (Exception exception) {
            this.message("Exception reading " + string + ": " + exception);
        }
        if (string2 == null) {
            Enumeration enumeration = hashtable.elements();
            while (enumeration.hasMoreElements()) {
                entityInstance2 = (EntityInstance)enumeration.nextElement();
                diagram.doRelayoutAll(entityInstance2);
            }
            bl2 = true;
        }
        hashtable.clear();
        try {
            bufferedReader.close();
        }
        catch (Exception exception) {
            this.message("Exception closing " + string + ": " + exception);
            return false;
        }
        return bl2;
    }

    public void doit(Vector vector, Vector vector2, EntityInstance entityInstance) {
        Object object;
        int n;
        int n2;
        String string;
        String string2;
        String string3;
        block39: {
            String string4;
            do {
                string3 = ACDCClusterLayout.parameterString(1);
                string2 = ACDCClusterLayout.parameterString(0);
                string = ACDCClusterLayout.parameterString(2);
                String string5 = ACDCClusterLayout.parameterString(3);
                string5 = string5.trim();
                n2 = 0;
                string4 = null;
                if (string3.length() == 0) {
                    string4 = "Please specify an export file to write to";
                } else if (string.length() != 0 && string2.length() == 0) {
                    string4 = "Please specify the command to execute ACDC";
                } else if (string2.length() != 0 && string.length() == 0) {
                    string4 = "Please specify an import file to read from";
                } else if (string5.length() > 0) {
                    try {
                        n2 = Integer.parseInt(string5);
                        if (n2 < 1) {
                            string4 = "Maxsize size of a cluster must be positive";
                        }
                    }
                    catch (Throwable throwable) {
                        string4 = "Max cluster size '" + string5 + "' must be an integer";
                    }
                }
                if (string4 == null) break block39;
            } while (this.configure(this.m_ls, string4));
            return;
        }
        if (!string3.endsWith(".ta")) {
            string3 = string3 + ".ta";
        }
        if (!string.endsWith(".rsf")) {
            string = string + ".rsf";
        }
        if ((n = vector2.size()) < 3) {
            this.m_ret = "Too few entities to reasonably cluster";
            return;
        }
        this.log("Using ACDC to cluster " + n + " items");
        if (!this.write(vector2, string3)) {
            return;
        }
        if (string2.length() == 0) {
            this.m_ret = "ACDC output written to file";
            return;
        }
        String string6 = string2 + " " + string3 + " " + string;
        int n3 = this.m_pattern.getSelectedIndex();
        if (n3 < 0) {
            n3 = 0;
        }
        string6 = string6 + " +" + g_patterncode[n3];
        n3 = this.m_filter.getSelectedIndex();
        switch (n3) {
            case 0: {
                string6 = string6 + " -a";
                String string7 = ACDCClusterLayout.parameterString(4);
                string7 = string7.replaceAll("[ \t\n\r\f]", "");
                string6 = string6 + string7;
                break;
            }
            case 2: {
                string6 = string6 + " -u";
            }
        }
        if (n2 > 0) {
            string6 = string6 + " -l" + n2;
        }
        if (ACDCClusterLayout.parameterBoolean(4)) {
            string6 = string6 + " -t";
        }
        if ((n3 = this.m_debug.getSelectedIndex()) > 0) {
            string6 = string6 + " -d" + n3;
        }
        Process process = null;
        this.log("Executing [" + string6 + "]");
        try {
            object = Runtime.getRuntime();
            if (object == null) {
                this.message("No runtime available");
                return;
            }
            process = ((Runtime)object).exec(string6);
            EchoOutput echoOutput = new EchoOutput("ACDC Stdout", process.getInputStream());
            new Thread(echoOutput).start();
            echoOutput = new EchoOutput("ACDC Stderr", process.getErrorStream());
            new Thread(echoOutput).start();
        }
        catch (Exception exception) {
            this.message("Exception executing [" + string6 + "] " + exception);
            return;
        }
        if (!this.waitFor(process)) {
            return;
        }
        if (!this.read(string, entityInstance, vector != vector2)) {
            return;
        }
        this.log("Import loaded");
        if (ACDCClusterLayout.parameterBoolean(1)) {
            try {
                object = new File(string);
                if (!((File)object).delete()) {
                    this.message("Unable to delete '" + object + "'");
                } else {
                    this.log("Deleted " + object);
                }
            }
            catch (Exception exception) {
                this.message("Exception deleting '" + string + "' " + exception);
            }
        }
        if (string3.length() != 0 && ACDCClusterLayout.parameterBoolean(0)) {
            try {
                object = new File(string3);
                if (!((File)object).delete()) {
                    this.message("Unable to delete '" + object + "'");
                } else {
                    this.log("Deleted " + object);
                }
            }
            catch (Exception exception) {
                this.message("Exception deleting '" + string3 + "' " + exception);
            }
        }
        this.m_ret = "Graph redrawn using ACDC Cluster Layout";
    }

    public void doLayout1(Vector vector, EntityInstance entityInstance) {
    }

    public String doLayout(Diagram diagram) {
        Vector vector;
        this.m_dg = diagram;
        Vector vector2 = diagram.getGroup();
        if (vector2 == null) {
            Util.beep();
            return "No group selected";
        }
        EntityInstance entityInstance = this.parentOfSet(vector2);
        if (entityInstance == null) {
            return "Cluster layout requires that all things laid out share same parent";
        }
        boolean bl = ACDCClusterLayout.parameterBoolean(2);
        if (!bl) {
            vector = vector2;
        } else {
            vector = new Vector();
            Enumeration enumeration = vector2.elements();
            while (enumeration.hasMoreElements()) {
                EntityInstance entityInstance2 = (EntityInstance)enumeration.nextElement();
                entityInstance2.gatherLeaves(vector);
            }
        }
        this.m_ret = "ACDC Cluster layout aborted";
        this.m_ls.setCursor(3);
        diagram.beginUndoRedo("Cluster layout");
        this.doit(vector2, vector, entityInstance);
        diagram.endUndoRedo();
        this.m_ls.setCursor(0);
        diagram.redrawDiagram();
        return this.m_ret;
    }

    public void processKeyEvent(int n, int n2, Object object) {
        Diagram diagram = this.m_ls.getDiagram();
        if (diagram != null) {
            String string = this.doLayout(diagram);
            this.m_ls.doFeedback(string);
            diagram.rescaleDiagram();
            this.m_ls.repaintDg();
        }
    }

    class EchoOutput
    implements Runnable {
        InputStream m_inputStream = null;
        String m_source;

        EchoOutput(String string, InputStream inputStream) {
            this.m_inputStream = inputStream;
            this.m_source = string;
        }

        public void run() {
            String string = this.m_source;
            try {
                String string2;
                InputStreamReader inputStreamReader = new InputStreamReader(this.m_inputStream);
                BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                while ((string2 = bufferedReader.readLine()) != null) {
                    ACDCClusterLayout.this.log(string + ": " + string2);
                }
                bufferedReader.close();
            }
            catch (Exception exception) {
                ACDCClusterLayout.this.log(string + " input error: " + exception);
            }
        }
    }

    class ACDCClusterConfigure
    extends JDialog
    implements ActionListener {
        protected JTextField[] m_textfields;
        protected JCheckBox[] m_checkboxes;
        protected JButton[] m_buttons;
        protected JLabel m_message;
        protected boolean m_isok;

        public ACDCClusterConfigure(ACDCClusterLayout aCDCClusterLayout2, String string) {
            JLabel jLabel;
            int n;
            super(aCDCClusterLayout2.getLs().getFrame(), aCDCClusterLayout2.getName() + " Configuration", true);
            this.m_isok = false;
            Font font = FontCache.getDialogFont();
            Font font2 = font.deriveFont(1);
            Container container = this.getContentPane();
            container.setLayout(new BorderLayout());
            this.setForeground(ColorCache.get(0, 0, 0));
            this.setBackground(ColorCache.get(192, 192, 192));
            this.setFont(font);
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BorderLayout());
            JPanel jPanel2 = new JPanel();
            GridLayout gridLayout = new GridLayout(8, 1, 0, 10);
            jPanel2.setLayout(gridLayout);
            JPanel jPanel3 = new JPanel();
            gridLayout = new GridLayout(8, 1, 0, 10);
            jPanel3.setLayout(gridLayout);
            this.m_textfields = new JTextField[m_textfield_tags.length];
            for (n = 0; n < m_textfield_tags.length; ++n) {
                JTextField jTextField;
                this.m_textfields[n] = jTextField = new JTextField(m_textfield_currents[n], 60);
                jLabel = new JLabel(m_textfield_titles[n], 4);
                jLabel.setFont(font2);
                jPanel2.add(jLabel);
                jTextField.setFont(font);
                jPanel3.add(jTextField);
            }
            jLabel = new JLabel("Apply patterns:", 4);
            jLabel.setFont(font2);
            jPanel2.add(jLabel);
            ACDCClusterLayout.this.m_pattern.setFont(font2);
            jPanel3.add(ACDCClusterLayout.this.m_pattern);
            jLabel = new JLabel("Emit as output: ", 4);
            jLabel.setFont(font2);
            jPanel2.add(jLabel);
            ACDCClusterLayout.this.m_filter.setFont(font2);
            jPanel3.add(ACDCClusterLayout.this.m_filter);
            jLabel = new JLabel("Tracing within ACDC:", 4);
            jLabel.setFont(font2);
            jPanel2.add(jLabel);
            ACDCClusterLayout.this.m_debug.setFont(font2);
            jPanel3.add(ACDCClusterLayout.this.m_debug);
            jPanel.add("West", jPanel2);
            jPanel.add("East", jPanel3);
            JPanel jPanel4 = new JPanel();
            jPanel4.setLayout(new FlowLayout(1, 15, 15));
            this.m_checkboxes = new JCheckBox[m_checkbox_tags.length];
            for (n = 0; n < m_checkbox_tags.length; ++n) {
                JCheckBox jCheckBox;
                this.m_checkboxes[n] = jCheckBox = new JCheckBox(m_checkbox_titles[n], m_checkbox_currents[n]);
                jCheckBox.setFont(font);
                jPanel4.add(jCheckBox);
            }
            jPanel.add("South", jPanel4);
            JPanel jPanel5 = new JPanel();
            jPanel5.setLayout(new BorderLayout());
            if (string == null) {
                string = ACDCClusterLayout.this.m_ls.getDiagram().undoEnabled() ? "You might wish to disable undo/redo operations" : "You might wish to enable undo/redo operations";
            }
            this.m_message = new JLabel(string, 0);
            this.m_message.setFont(font);
            this.m_message.setForeground(Color.RED);
            this.m_message.setSize(400, 50);
            this.m_message.setPreferredSize(new Dimension(400, 50));
            jPanel4 = new JPanel();
            jPanel4.setLayout(new FlowLayout(1, 15, 15));
            this.m_buttons = new JButton[m_button_titles.length];
            for (n = 0; n < m_button_titles.length; ++n) {
                JButton jButton;
                String string2 = m_button_titles[n];
                if (string2 == null) {
                    string2 = ACDCClusterLayout.this.undoLabel();
                }
                this.m_buttons[n] = jButton = new JButton(string2);
                jButton.setFont(font2);
                String string3 = m_button_tips[n];
                if (string3 != null) {
                    jButton.setToolTipText(string3);
                }
                jButton.addActionListener(this);
                jPanel4.add(jButton);
            }
            jPanel5.add("North", this.m_message);
            jPanel5.add("South", jPanel4);
            container.add("North", jPanel);
            container.add("South", jPanel5);
            this.pack();
            this.setVisible(true);
        }

        public boolean ok() {
            return this.m_isok;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            Object object = actionEvent.getSource();
            int n2 = -1;
            for (n = 0; n < m_button_titles.length; ++n) {
                if (object != this.m_buttons[n]) continue;
                n2 = n;
                break;
            }
            switch (n2) {
                case 6: {
                    for (n = 0; n < m_textfield_tags.length; ++n) {
                        ACDCClusterLayout.m_textfield_defaults[n] = m_textfield_resets[n];
                    }
                    for (n = 0; n < m_checkbox_tags.length; ++n) {
                        ACDCClusterLayout.m_checkbox_defaults[n] = m_checkbox_resets[n];
                    }
                }
                case 4: {
                    for (n = 0; n < m_textfield_tags.length; ++n) {
                        this.m_textfields[n].setText(m_textfield_defaults[n]);
                    }
                    for (n = 0; n < m_checkbox_tags.length; ++n) {
                        this.m_checkboxes[n].setSelected(m_checkbox_defaults[n]);
                    }
                    ACDCClusterLayout.this.m_pattern.setSelectedIndex(0);
                    ACDCClusterLayout.this.m_filter.setSelectedIndex(0);
                    ACDCClusterLayout.this.m_debug.setSelectedIndex(1);
                    return;
                }
                case 5: {
                    for (n = 0; n < m_textfield_tags.length; ++n) {
                        ACDCClusterLayout.m_textfield_defaults[n] = this.m_textfields[n].getText();
                    }
                    for (n = 0; n < m_checkbox_tags.length; ++n) {
                        ACDCClusterLayout.m_checkbox_defaults[n] = this.m_checkboxes[n].isSelected();
                    }
                    return;
                }
                case 3: {
                    LandscapeEditorCore landscapeEditorCore = ACDCClusterLayout.this.m_ls;
                    landscapeEditorCore.invertUndo();
                    this.m_buttons[n2].setText(ACDCClusterLayout.this.undoLabel());
                    this.m_message.setText("");
                    return;
                }
                case 2: {
                    JOptionPane.showMessageDialog(ACDCClusterLayout.this.m_ls.getFrame(), "The ACDC clustering algorithm attempts to cluster nodes on the basis of software\nengineering patterns observed in how entities are connected by edges.  Patterns\nmay be executed in an arbitrary order.  The body pattern places those nodes\nwhose names end in '.c' or '.h' and which have the same prefix in a common cluster.\nThe subgraph pattern clusters nodes based on their dependencies.  The orphan pattern\nplaces orphans not in any cluster in the cluster containing nodes that most frequently\nreference this orphan.\n\nIt is recommended that 'All' output generated by ACDC be emitted.  When this option is\nselected all clusters generated by ACDC may optionally be placed under the named container.\n\nIf 'files' or 'files within modules' is specified ACDC will produce reduced output in which\nmuch of the clustering information computed by ACDC may be discarded before it generates\nany output. Nodes of type 'File'/'cFile' will be output when either option is specified\nwith these nodes only occurring under nodes of type 'cModule'/'Subsystem'/'cSubSystem'\nwhen modules are also requestd.  These two options will result in ACDC producing an empty\noutput file when none of the nodes to be clustered have such a type.  In such cases\nno clustering will be performed by LSEdit, since it will be provided no instructions on\nhow clustering is to be performed.  Even in cases where ACDC does produce output it is\nstressed that while the output from ACDC might suggest that most of the input used to drive\nACDC should be discarded, LSEdit will merely move documented nodes and all their descendants\ninto the specified containment hierachy documented in this output file.\n\nThe gui checkbox instructs ACDC to show its progress graphically as clustering is performed\nand exists primarily as a debugging aid.", "Help", 0);
                    return;
                }
                case 0: {
                    for (n = 0; n < m_textfield_tags.length; ++n) {
                        ACDCClusterLayout.m_textfield_currents[n] = this.m_textfields[n].getText();
                    }
                    for (n = 0; n < m_checkbox_tags.length; ++n) {
                        ACDCClusterLayout.m_checkbox_currents[n] = this.m_checkboxes[n].isSelected();
                    }
                    this.m_isok = true;
                }
                case 1: {
                    break;
                }
                default: {
                    return;
                }
            }
            this.setVisible(false);
        }
    }
}

