/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import lsedit.ColorCache;
import lsedit.FontCache;
import lsedit.LandscapeEditorCore;

public class ArrowDimensions
extends JDialog
implements ActionListener {
    private static final int LINE_WIDTH = 0;
    private static final int ARROW_LENGTH = 1;
    private static final int ARROW_ARC = 2;
    private static final int PIXELS_3D = 3;
    private static final int SHADOW_SIZE = 4;
    protected static final String[] m_textfield_tags = new String[]{"arrow:linewidth[", "arrow:linelength[", "arrow:arc[", "arrow:3dpixels[", "arrow:shadow["};
    protected static final String[] m_textfield_titles = new String[]{"Width of edge:", "Length of arrow edge:", "Arc between edge and arrow edge:", "3D highlighting weight:", "Incidental shadow size:"};
    protected static final String[] m_textfield_units = new String[]{"Pixels", "Pixels", "Radians", "Pixels", "Pixels"};
    protected static final String[] m_textfield_resets = new String[]{"1", "10.0", "0.4", "3", "5"};
    protected static String[] m_textfield_defaults = new String[]{"1", "10.0", "0.4", "3", "5"};
    protected static String[] m_textfield_currents = new String[]{"1", "10.0", "0.4", "3", "5"};
    public static int m_line_width = 1;
    public static double m_arrow_length = 10.0;
    public static double m_arrow_arc = 0.4;
    public static int m_pixels_3d = 3;
    public static int m_shadow_size = 5;
    private static final int FILL_ARROWHEAD = 0;
    private static final int CENTER_ARROWHEAD = 1;
    private static final int WEIGHTED_ARROWHEAD = 2;
    private static final int BLACKWHITE_3D = 3;
    protected static final String[] m_checkbox_tags = new String[]{"arrow:fill[", "arrow:center[", "arrow:weighted[", "arrow:blackwhite["};
    protected static final String[] m_checkbox_titles = new String[]{"Fill arrow head:", "Center arrow head:", "Permanently weight arrow head:", "3D in Black&White:"};
    protected static final boolean[] m_checkbox_resets = new boolean[]{true, false, true, true};
    protected static boolean[] m_checkbox_defaults = new boolean[]{true, false, true, true};
    protected static boolean[] m_checkbox_currents = new boolean[]{true, false, true, true};
    protected static final int BUTTON_OK = 0;
    protected static final int BUTTON_CANCEL = 1;
    protected static final int BUTTON_DEFAULT = 2;
    protected static final int BUTTON_SET = 3;
    protected static final int BUTTON_RESET = 4;
    protected static final String[] m_button_titles = new String[]{"Ok", "Cancel", "Default", "Set", "Reset"};
    protected static final String[] m_button_tips = new String[]{null, null, "Use remembered default", "Set default to current", "Set default to initial"};
    protected LandscapeEditorCore m_ls;
    protected JTextField[] m_textfields;
    protected JCheckBox[] m_checkboxes;
    protected JLabel m_message;
    protected JButton[] m_buttons;
    protected boolean m_ret;

    protected static void setNumericParameter(int n, String string) {
        try {
            string = string.trim();
            block1 : switch (n) {
                case 0: 
                case 3: 
                case 4: {
                    int n2 = Integer.parseInt(string);
                    switch (n) {
                        case 0: {
                            m_line_width = n2;
                            break;
                        }
                        case 3: {
                            m_pixels_3d = n2;
                            break;
                        }
                        case 4: {
                            m_shadow_size = n2;
                        }
                    }
                    break;
                }
                default: {
                    double d = Double.parseDouble(string);
                    switch (n) {
                        case 1: {
                            m_arrow_length = d;
                            break block1;
                        }
                        case 2: {
                            m_arrow_arc = d;
                        }
                    }
                }
            }
            ArrowDimensions.m_textfield_currents[n] = string;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected static void setBooleanParameter(int n, boolean bl) {
        ArrowDimensions.m_checkbox_currents[n] = bl;
    }

    public static void load(String string) {
        String string2;
        int n;
        for (n = 0; n < m_textfield_tags.length; ++n) {
            string2 = m_textfield_tags[n];
            if (!string.startsWith(string2)) continue;
            if ((string = string.substring(string2.length())).charAt(1) != ']' || string.charAt(2) != '=') {
                return;
            }
            int n2 = string.charAt(0) - 48;
            string = string.substring(3);
            switch (n2) {
                case 0: {
                    ArrowDimensions.m_textfield_defaults[n] = string;
                }
                case 1: {
                    ArrowDimensions.setNumericParameter(n, string);
                }
            }
            return;
        }
        for (n = 0; n < m_checkbox_tags.length; ++n) {
            string2 = m_checkbox_tags[n];
            if (!string.startsWith(string2)) continue;
            if ((string = string.substring(string2.length())).charAt(1) != ']' || string.charAt(2) != '=') {
                return;
            }
            int n3 = string.charAt(0) - 48;
            boolean bl = (string = string.substring(3)).charAt(0) == 't';
            switch (n3) {
                case 0: {
                    ArrowDimensions.m_checkbox_defaults[n] = bl;
                    break;
                }
                case 1: {
                    ArrowDimensions.setBooleanParameter(n, bl);
                }
            }
            return;
        }
    }

    public static void save(BufferedWriter bufferedWriter) throws IOException {
        String[] stringArray = m_textfield_resets;
        boolean[] blArray = m_checkbox_resets;
        String[] stringArray2 = m_textfield_defaults;
        boolean[] blArray2 = m_checkbox_defaults;
        for (int i = 0; i < 2; ++i) {
            String string;
            String string2;
            int n;
            for (n = 0; n < m_textfield_tags.length; ++n) {
                string2 = stringArray2[n];
                if (string2.equals(stringArray[n])) continue;
                string = m_textfield_tags[n];
                bufferedWriter.write(string, 0, string.length());
                bufferedWriter.write("" + i + "]=", 0, 3);
                bufferedWriter.write(string2, 0, string2.length());
                bufferedWriter.newLine();
            }
            for (n = 0; n < m_checkbox_tags.length; ++n) {
                boolean bl = blArray2[n];
                if (bl == blArray[n]) continue;
                string = m_checkbox_tags[n];
                bufferedWriter.write(string, 0, string.length());
                bufferedWriter.write("" + i + "]=", 0, 3);
                string2 = bl ? "true" : "false";
                bufferedWriter.write(string2, 0, string2.length());
                bufferedWriter.newLine();
            }
            stringArray = stringArray2;
            blArray = blArray2;
            stringArray2 = m_textfield_currents;
            blArray2 = m_checkbox_currents;
        }
    }

    public static boolean isFillArrowhead() {
        return m_checkbox_currents[0];
    }

    public static boolean isCenterArrowhead() {
        return m_checkbox_currents[1];
    }

    public static boolean isWeightedArrowhead() {
        return m_checkbox_currents[2];
    }

    public static boolean isBlackWhite3D() {
        return m_checkbox_currents[3];
    }

    protected ArrowDimensions(LandscapeEditorCore landscapeEditorCore) {
        super(landscapeEditorCore.getFrame(), "Modify visualization settings", true);
        JLabel jLabel;
        int n;
        this.m_ls = landscapeEditorCore;
        this.m_ret = false;
        Font font = FontCache.getDialogFont();
        Font font2 = font.deriveFont(1);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        this.setForeground(ColorCache.get(0, 0, 0));
        this.setBackground(ColorCache.get(192, 192, 192));
        this.setFont(font);
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        JPanel jPanel4 = new JPanel();
        jPanel.setLayout(new BorderLayout());
        GridLayout gridLayout = new GridLayout(9, 1);
        gridLayout.setVgap(10);
        jPanel2.setLayout(gridLayout);
        gridLayout = new GridLayout(9, 1);
        gridLayout.setVgap(10);
        jPanel3.setLayout(gridLayout);
        gridLayout = new GridLayout(9, 1);
        gridLayout.setVgap(10);
        jPanel4.setLayout(gridLayout);
        jPanel.add("West", jPanel2);
        jPanel.add("East", jPanel4);
        jPanel.add("Center", jPanel3);
        this.m_textfields = new JTextField[m_textfield_tags.length];
        for (n = 0; n < m_textfield_tags.length; ++n) {
            JTextField jTextField;
            jLabel = new JLabel(m_textfield_titles[n], 4);
            jLabel.setFont(font2);
            jPanel2.add(jLabel);
            this.m_textfields[n] = jTextField = new JTextField(m_textfield_currents[n], 12);
            jTextField.setFont(font);
            jTextField.addActionListener(this);
            jPanel3.add(jTextField);
            jLabel = new JLabel(m_textfield_units[n], 2);
            jLabel.setFont(font2);
            jPanel4.add(jLabel);
        }
        this.m_checkboxes = new JCheckBox[m_checkbox_tags.length];
        for (n = 0; n < m_checkbox_tags.length; ++n) {
            JCheckBox jCheckBox;
            jLabel = new JLabel(m_checkbox_titles[n], 4);
            jLabel.setFont(font2);
            jPanel2.add(jLabel);
            this.m_checkboxes[n] = jCheckBox = new JCheckBox("", m_checkbox_currents[n]);
            jCheckBox.setFont(font);
            jPanel3.add(jCheckBox);
        }
        container.add("North", jPanel);
        this.m_message = new JLabel(" ", 0);
        this.m_message.setFont(font);
        this.m_message.setForeground(Color.RED);
        this.m_message.setSize(400, 50);
        container.add("Center", this.m_message);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new FlowLayout(1, 15, 15));
        this.m_buttons = new JButton[m_button_titles.length];
        for (n = 0; n < m_button_titles.length; ++n) {
            JButton jButton;
            this.m_buttons[n] = jButton = new JButton(m_button_titles[n]);
            jButton.setFont(font2);
            String string = m_button_tips[n];
            if (string != null) {
                jButton.setToolTipText(string);
            }
            jButton.addActionListener(this);
            jPanel5.add(jButton);
        }
        container.add("South", jPanel5);
        this.pack();
        this.setVisible(true);
    }

    public boolean ok() {
        return this.m_ret;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        int n;
        Object object = actionEvent.getSource();
        int n2 = -1;
        for (n = 0; n < m_button_titles.length; ++n) {
            if (object != this.m_buttons[n]) continue;
            n2 = n;
            break;
        }
        switch (n2) {
            case 4: {
                for (n = 0; n < m_textfield_tags.length; ++n) {
                    ArrowDimensions.m_textfield_defaults[n] = m_textfield_resets[n];
                }
                for (n = 0; n < m_checkbox_tags.length; ++n) {
                    ArrowDimensions.m_checkbox_defaults[n] = m_checkbox_resets[n];
                }
            }
            case 2: {
                for (n = 0; n < m_textfield_tags.length; ++n) {
                    this.m_textfields[n].setText(m_textfield_defaults[n]);
                }
                for (n = 0; n < m_checkbox_tags.length; ++n) {
                    this.m_checkboxes[n].setSelected(m_checkbox_defaults[n]);
                }
                this.m_message.setText("Values set to initial default");
                return;
            }
            case 3: {
                for (n = 0; n < m_textfield_tags.length; ++n) {
                    ArrowDimensions.m_textfield_defaults[n] = this.m_textfields[n].getText();
                }
                for (n = 0; n < m_checkbox_tags.length; ++n) {
                    ArrowDimensions.m_checkbox_defaults[n] = this.m_checkboxes[n].isSelected();
                }
                return;
            }
        }
        block27: for (n = 0; n < m_textfield_tags.length; ++n) {
            JTextField jTextField = this.m_textfields[n];
            if (object != jTextField && n2 != 0) continue;
            String string = jTextField.getText();
            string = string.trim();
            String string2 = m_textfield_titles[n];
            switch (n) {
                case 0: 
                case 3: 
                case 4: {
                    try {
                        int n3 = Integer.parseInt(string);
                        if (n3 < 0) {
                            this.m_message.setText(string2 + " may not be negative");
                            return;
                        }
                        if (n3 <= 100) continue block27;
                        this.m_message.setText(string2 + " may not exceed 99");
                        return;
                    }
                    catch (Throwable throwable) {
                        this.m_message.setText(string2 + " not an integer");
                        return;
                    }
                }
                case 1: 
                case 2: {
                    try {
                        double d = Double.parseDouble(string);
                        if (Double.isNaN(d)) {
                            this.m_message.setText("Length is not a double precision number");
                            return;
                        }
                        if (d < 0.0) {
                            this.m_message.setText(string2 + " may not be negative");
                            return;
                        }
                        switch (n) {
                            case 2: {
                                if (!(d > 1.5)) break;
                                this.m_message.setText("The maximum allowed arc angle is 1.5 (very near pi/2)");
                                return;
                            }
                        }
                        continue block27;
                    }
                    catch (Throwable throwable) {
                        this.m_message.setText(string2 + " not a double precision value");
                        return;
                    }
                }
            }
        }
        switch (n2) {
            case 0: {
                for (n = 0; n < m_textfield_tags.length; ++n) {
                    ArrowDimensions.setNumericParameter(n, this.m_textfields[n].getText());
                }
                for (n = 0; n < m_checkbox_tags.length; ++n) {
                    ArrowDimensions.setBooleanParameter(n, this.m_checkboxes[n].isSelected());
                }
                this.m_ret = true;
            }
            case 1: {
                break;
            }
            default: {
                return;
            }
        }
        this.setVisible(false);
    }

    public static void create(LandscapeEditorCore landscapeEditorCore) {
        int n = m_line_width;
        double d = m_arrow_length;
        double d2 = m_arrow_arc;
        int n2 = m_pixels_3d;
        int n3 = m_shadow_size;
        boolean bl = ArrowDimensions.isFillArrowhead();
        boolean bl2 = ArrowDimensions.isCenterArrowhead();
        boolean bl3 = ArrowDimensions.isWeightedArrowhead();
        boolean bl4 = ArrowDimensions.isBlackWhite3D();
        ArrowDimensions arrowDimensions = new ArrowDimensions(landscapeEditorCore);
        if (arrowDimensions.ok() && (n != m_line_width || d != m_arrow_length || d2 != m_arrow_arc || n2 != m_pixels_3d || n3 != m_shadow_size || bl != ArrowDimensions.isFillArrowhead() || bl2 != ArrowDimensions.isCenterArrowhead() || bl3 != ArrowDimensions.isWeightedArrowhead() || bl4 != ArrowDimensions.isBlackWhite3D())) {
            landscapeEditorCore.repaint();
        }
        arrowDimensions.dispose();
    }
}

