/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Rectangle;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.Scrollable;
import lsedit.AttributeBoxPanel;
import lsedit.Diagram;
import lsedit.EntityClass;
import lsedit.FontCache;
import lsedit.LandscapeClassObject;
import lsedit.LandscapeEditorCore;
import lsedit.LandscapeObject;
import lsedit.LandscapeObject3D;
import lsedit.MySplitPane;
import lsedit.ShowAttributeColor;
import lsedit.ShowImage;
import lsedit.ShowLabel;
import lsedit.Util;

public class AttributeBox
extends MySplitPane
implements Scrollable {
    protected static final Color m_titleColor = Color.red.darker();
    public static final String DEFAULT_ATTRIBUTE_TITLE_FONT_NAME = "Helvetica";
    public static final int DEFAULT_ATTRIBUTE_TITLE_FONT_STYLE = 1;
    public static final int DEFAULT_ATTRIBUTE_TITLE_FONT_SIZE = 14;
    protected static Font m_titleFont = FontCache.get("Helvetica", 1, 14);
    public static final String DEFAULT_ATTRIBUTE_TEXT_FONT_NAME = "Helvetica";
    public static final int DEFAULT_ATTRIBUTE_TEXT_FONT_STYLE = 0;
    public static final int DEFAULT_ATTRIBUTE_TEXT_FONT_SIZE = 11;
    public static Font m_textFont = FontCache.get("Helvetica", 0, 11);
    protected static final String m_indent = "    ";
    protected static final String m_helpStr = "Hold shift down to freeze";
    protected static final int horizontal_margin = 10;
    protected static final int vertical_indent = 10;
    protected LandscapeEditorCore m_ls;
    protected JTabbedPane m_tabbedPane;
    protected JScrollPane m_scrollPane;
    protected GridLayout m_layout;
    protected JPanel m_left;
    protected JPanel m_right;
    protected BoxLayout m_left_layout;
    protected BoxLayout m_right_layout;
    protected LandscapeObject m_object = null;

    public AttributeBox(LandscapeEditorCore landscapeEditorCore, JTabbedPane jTabbedPane) {
        super(1);
        BoxLayout boxLayout;
        this.m_ls = landscapeEditorCore;
        this.m_tabbedPane = jTabbedPane;
        this.m_left = new AttributeBoxPanel();
        this.m_right = new AttributeBoxPanel();
        this.m_left.setBackground(Diagram.boxColor);
        this.m_right.setBackground(Diagram.boxColor);
        this.m_left_layout = boxLayout = new BoxLayout(this.m_left, 1);
        this.m_left.setLayout(boxLayout);
        this.m_right_layout = boxLayout = new BoxLayout(this.m_right, 1);
        this.m_right.setLayout(boxLayout);
        this.setLeftComponent(this.m_left);
        this.setRightComponent(this.m_right);
        this.setOneTouchExpandable(true);
        this.setDividerLocation(0.5);
        int n = jTabbedPane.getWidth();
        int n2 = jTabbedPane.getHeight();
        this.m_scrollPane = new JScrollPane();
        this.m_scrollPane.setBounds(0, 0, n, n2);
        Dimension dimension = this.m_scrollPane.getSize();
        this.setSize(dimension);
        this.setPreferredSize(dimension);
        this.setToolTipText(m_helpStr);
        this.m_scrollPane.setViewportView(this);
        jTabbedPane.addTab("Attrs", null, this.m_scrollPane, m_helpStr);
    }

    public static Font getTitleFont() {
        return m_titleFont;
    }

    public static void setTitleFont(Font font) {
        m_titleFont = font;
    }

    public static Font getTextFont() {
        return m_textFont;
    }

    public static void setTextFont(Font font) {
        m_textFont = font;
    }

    public void activate() {
        this.m_tabbedPane.setSelectedComponent(this.m_scrollPane);
    }

    public boolean isActive() {
        if (this.isVisible()) {
            Component component = this.m_tabbedPane.getSelectedComponent();
            return component != null && this.m_scrollPane == component;
        }
        return false;
    }

    public void validate() {
        Dimension dimension = this.m_scrollPane.getSize();
        this.setSize(dimension);
        this.setPreferredSize(dimension);
        super.validate();
    }

    public void fill(LandscapeObject landscapeObject) {
        LandscapeClassObject landscapeClassObject;
        ShowLabel showLabel;
        ShowLabel showLabel2;
        String string;
        int n;
        int n2;
        int n3 = 0;
        n3 = landscapeObject.getLsAttributeCount();
        int n4 = landscapeObject.getPrimaryAttributeCount();
        for (n2 = 0; n2 < n3 && (n = landscapeObject.getLsAttributeTypeAt(n2)) != 0; ++n2) {
            string = landscapeObject.getLsAttributeNameAt(n2);
            showLabel2 = new ShowLabel(string);
            Color color = n2 < n4 ? Color.blue : Color.red;
            showLabel2.setForeground(color);
            showLabel2.setFont(m_textFont);
            this.m_left.add(showLabel2);
            Object object = landscapeObject.getLsAttributeValueAt(n2);
            if (object == null) {
                showLabel2 = new ShowLabel("null");
                showLabel2.setForeground(Color.red);
                showLabel = showLabel2;
            } else {
                switch (n) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 11: 
                    case 12: 
                    case 15: 
                    case 16: {
                        showLabel = new ShowLabel(object.toString());
                        break;
                    }
                    case 7: 
                    case 8: {
                        showLabel = new ShowAttributeColor((Color)object);
                        showLabel.setOpaque(true);
                        break;
                    }
                    case 17: {
                        showLabel = new ShowImage((Integer)object);
                        break;
                    }
                    case 13: {
                        int n5 = (Integer)object;
                        String string2 = n5 < 0 || n5 >= EntityClass.styleName.length ? "" + n5 : EntityClass.styleName[n5];
                        showLabel = new ShowLabel(string2);
                        break;
                    }
                    case 14: {
                        int n5 = (Integer)object;
                        String string2 = n5 < 0 || n5 >= Util.lineStyleName.length ? "" + n5 : Util.lineStyleName[n5];
                        showLabel = new ShowLabel(string2);
                        break;
                    }
                    default: {
                        showLabel = new ShowLabel("");
                    }
                }
            }
            this.m_right.add(showLabel);
        }
        this.m_left.add(Box.createVerticalStrut(10));
        this.m_right.add(Box.createVerticalStrut(10));
        showLabel2 = new ShowLabel("Attributes");
        showLabel2.setForeground(Color.GREEN);
        this.m_left.add(showLabel2);
        showLabel2 = new ShowLabel("" + n3);
        this.m_right.add(showLabel2);
        string = landscapeObject instanceof LandscapeObject3D ? ((LandscapeObject3D)landscapeObject).getId() : "Relation";
        n2 = 0;
        while ((landscapeClassObject = landscapeObject.derivedFrom(n2)) != null) {
            this.m_left.add(Box.createVerticalStrut(10));
            this.m_right.add(Box.createVerticalStrut(10));
            showLabel2 = new ShowLabel("Superclass of");
            this.m_left.add(showLabel2);
            showLabel = new ShowLabel(string);
            this.m_right.add(showLabel);
            this.fill(landscapeClassObject);
            ++n2;
        }
    }

    public void fill() {
        LandscapeObject landscapeObject = this.m_object;
        boolean bl = false;
        this.m_left.removeAll();
        this.m_right.removeAll();
        this.m_left.repaint();
        this.m_right.repaint();
        if (landscapeObject == null) {
            this.m_left.add(Box.createVerticalStrut(10));
            this.m_right.add(Box.createVerticalStrut(10));
            ShowLabel showLabel = new ShowLabel("No object");
            this.m_left.add(showLabel);
        } else {
            this.fill(landscapeObject);
        }
        this.m_scrollPane.revalidate();
    }

    public void show(LandscapeObject landscapeObject) {
        if (this.m_object != landscapeObject) {
            this.m_object = landscapeObject;
            this.fill();
        }
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.getSize();
    }

    public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
        return 50;
    }

    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
        return 10;
    }
}

