/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import lsedit.Arrow;
import lsedit.ColorCache;
import lsedit.Diagram;
import lsedit.EntityInstance;
import lsedit.FontCache;
import lsedit.LandscapeEditorCore;
import lsedit.LandscapeLayouter;
import lsedit.ListVector;
import lsedit.MyListCellRenderer;
import lsedit.MyListModel;
import lsedit.RelationClass;
import lsedit.RelationInstance;
import lsedit.SortVector;
import lsedit.ToolBarEventHandler;
import lsedit.Util;

public class BunchClusterLayout
extends LandscapeLayouter
implements ToolBarEventHandler {
    public static final String[] g_clustering_approach = new String[]{"Agglomerative", "One level"};
    public static final String[] g_output_mode = new String[]{"Median", "Top", "Detailed"};
    public static final String[] g_cluster_algorithm = new String[]{"Hill climbing", "Genetic", "Exhaustive"};
    public static final String[] g_debug = new String[]{"Silent", "Minimal", "Verbose", "Diagnostic"};
    public static final String[] g_techniques = new String[]{"bunch.SASimpleTechnique"};
    public static final String[] g_selection_method = new String[]{"Tournament", "Roulette wheel"};
    public static final String[] g_calculator_classes = new String[]{"bunch.TurboMQIncrW", "bunch.TurboMQIncr", "bunch.TurboMQW", "bunch.TurboMQ", "bunch.ITurboMQ", "bunch.basicMQ"};
    protected static final int EXPORT = 0;
    protected static final int COMMAND = 1;
    protected static final int IMPORTDIR = 2;
    protected static final int IMPORTFILE = 3;
    protected static final int LIBRARYS = 4;
    protected static final int CLIENTS = 5;
    protected static final int SUPPLIERS = 6;
    protected static final int OMNIPRESENT = 7;
    protected static final int HC_POPULATION_SIZE = 8;
    protected static final int HC_SEARCH_SPACE = 9;
    protected static final int HC_RANDOMIZE = 10;
    protected static final int HC_INITIAL_TEMP = 11;
    protected static final int HC_ALPHA = 12;
    protected static final int GA_GENERATIONS = 13;
    protected static final int GA_POPULATION_SIZE = 14;
    protected static final int GA_CROSSOVER_PROB = 15;
    protected static final int GA_MUTATION_PROB = 16;
    protected static final int MAXRUNTIME = 17;
    protected static final int USERFILE = 18;
    protected static final int CLIENTS_MULTIPLIER = 19;
    protected static final int SUPPLIERS_MULTIPLIER = 20;
    protected static final int BOTH_MULTIPLIER = 21;
    protected static final String[] m_textfield_tags = new String[]{"bunch:export[", "bunch:command[", "bunch:importdir[", "bunch:import[", "bunch:librarys[", "bunch:clients[", "bunch:suppliers[", "bunch:omnipresent[", "bunch:hcpopulation[", "bunch:hcsearchspace[", "bunch:hcrandomize[", "bunch:hcinitial[", "bunch:hcalpha[", "bunch:gagenerations[", "bunch:gapopulation[", "bunch:gacrossover[", "bunch:gamutation[", "bunch:maxruntime[", "bunch:userfile[", "bunch:clientsmult[", "bunch:suppliermult[", "bunch:bothmult["};
    protected static final String[] m_textfield_titles = new String[]{"Initial graph file:", "Bunch command line interface:", "Bunch output directory:", "Import file:", "Library list:", "Omnipresent clients:", "Omnipresent suppliers:", "Omnipresent nodes:", null, null, null, null, null, "Number of Generations:", "Population Size", "Crossover Probability:", "Mutation Probability", null, "Input cluster file:", null, null, null};
    protected static final String[] m_textfield_resets = new String[]{"junk.ta", "\"/Program Files/Java/jdk1.5.0_03/bin/java.exe\" -classpath \".;bunch.jar\" clue.Clue", "", "junk.ta.bunch", "", "", "", "", "1", "0", "100", "1.0", "0.85", "500", "50", "0.6", "0.015", "1000", "", "0.3", "0.3", "0.3"};
    protected static String[] m_textfield_defaults = new String[]{"junk.ta", "\"/Program Files/Java/jdk1.5.0_03/bin/java.exe\" -classpath \".;bunch.jar\" clue.Clue", "", "junk.ta.bunch", "", "", "", "", "1", "0", "100", "1.0", "0.85", "500", "50", "0.6", "0.015", "1000", "", "0.3", "0.3", "0.3"};
    protected static String[] m_textfield_currents = new String[]{"junk.ta", "\"/Program Files/Java/jdk1.5.0_03/bin/java.exe\" -classpath \".;bunch.jar\" clue.Clue", "", "junk.ta.bunch", "", "", "", "", "1", "0", "100", "1.0", "0.85", "500", "50", "0.6", "0.015", "1000", "", "0.3", "0.3", "0.3"};
    protected JComboBox m_clustering_approach = new JComboBox<String>(g_clustering_approach);
    protected JComboBox m_output_mode = new JComboBox<String>(g_output_mode);
    protected JComboBox m_cluster_algorithm = new JComboBox<String>(g_cluster_algorithm);
    protected JComboBox m_selection_method = new JComboBox<String>(g_selection_method);
    protected JComboBox m_calculator_classes = new JComboBox<String>(g_calculator_classes);
    protected JComboBox m_debug = new JComboBox<String>(g_debug);
    protected static final int DELETEEXPORT = 0;
    protected static final int DELETEIMPORT = 1;
    protected static final int LEAVES = 2;
    protected static final int FEEDBACK = 3;
    protected static final int VANILLA = 4;
    protected static final int ANNEALING = 5;
    protected static final int TIMEOUT = 6;
    protected static final int LOCK_USER = 7;
    protected static final String[] m_checkbox_tags = new String[]{"bunch:deleteExport[", "bunch:deleteImport[", "bunch:leaves[", "bunch:feedback[", "bunch:vanilla[", "bunch:annealing[", "bunch:timeout[", "bunch:lockuser["};
    protected static final String[] m_checkbox_titles = new String[]{"Delete export file", "Delete import file", "Cluster leaves", "Feedback", "Vanilla", "Enable Simulated Annealing", "Limit runtime to", "Lock clusters"};
    protected static final boolean[] m_checkbox_resets = new boolean[]{false, false, true, true, false, false, false, false};
    protected static boolean[] m_checkbox_defaults = new boolean[]{false, false, true, true, false, false, false, false};
    protected static boolean[] m_checkbox_currents = new boolean[]{false, false, true, true, false, false, false, false};
    protected static final int BUTTON_OK = 0;
    protected static final int BUTTON_CANCEL = 1;
    protected static final int BUTTON_HELP = 2;
    protected static final int BUTTON_UNDO = 3;
    protected static final int BUTTON_DEFAULT = 4;
    protected static final int BUTTON_SET = 5;
    protected static final int BUTTON_RESET = 6;
    protected static final String[] m_button_titles = new String[]{"Ok", "Cancel", "Help", null, "Default", "Set", "Reset"};
    protected static final String[] m_button_tips = new String[]{null, null, null, "Enable/disable undo", "Use remembered default", "Set default to current", "Set default to initial"};
    protected static final int[] g_omnipresents = new int[]{256, 512, 1024, 1536};
    protected static final String[] g_omnipresent_names = new String[]{"LIBRARY_LIST", "OMNIPRESENT_CLIENTS", "OMNIPRESENT_SUPPLIERS", "OMNIPRESENT_BOTH"};
    protected Diagram m_dg;
    protected String m_ret;

    protected static String parameterString(int n) {
        return m_textfield_currents[n];
    }

    protected static void setParameterString(int n, String string) {
        BunchClusterLayout.m_textfield_currents[n] = string;
    }

    protected static boolean parameterBoolean(int n) {
        return m_checkbox_currents[n];
    }

    protected static void setParameterBoolean(int n, boolean bl) {
        BunchClusterLayout.m_checkbox_currents[n] = bl;
    }

    public String getTag() {
        return "bunch:";
    }

    public void load(String string) {
        String string2;
        int n;
        for (n = 0; n < m_textfield_tags.length; ++n) {
            string2 = m_textfield_tags[n];
            if (!string.startsWith(string2)) continue;
            if ((string = string.substring(string2.length())).charAt(1) != ']' || string.charAt(2) != '=') {
                return;
            }
            int n2 = string.charAt(0) - 48;
            string = string.substring(3);
            switch (n2) {
                case 0: {
                    BunchClusterLayout.m_textfield_defaults[n] = string;
                }
                case 1: {
                    BunchClusterLayout.m_textfield_currents[n] = string;
                }
            }
            return;
        }
        for (n = 0; n < m_checkbox_tags.length; ++n) {
            string2 = m_checkbox_tags[n];
            if (!string.startsWith(string2)) continue;
            if ((string = string.substring(string2.length())).charAt(1) != ']' || string.charAt(2) != '=') {
                return;
            }
            int n3 = string.charAt(0) - 48;
            boolean bl = (string = string.substring(3)).charAt(0) == 't';
            switch (n3) {
                case 0: {
                    BunchClusterLayout.m_checkbox_defaults[n] = bl;
                }
                case 1: {
                    BunchClusterLayout.m_checkbox_currents[n] = bl;
                }
            }
            return;
        }
    }

    public void save(BufferedWriter bufferedWriter) throws IOException {
        String[] stringArray = m_textfield_resets;
        boolean[] blArray = m_checkbox_resets;
        String[] stringArray2 = m_textfield_defaults;
        boolean[] blArray2 = m_checkbox_defaults;
        for (int i = 0; i < 2; ++i) {
            String string;
            String string2;
            int n;
            for (n = 0; n < m_textfield_tags.length; ++n) {
                string2 = stringArray2[n];
                if (string2.equals(stringArray[n])) continue;
                string = m_textfield_tags[n];
                bufferedWriter.write(string, 0, string.length());
                bufferedWriter.write("" + i + "]=", 0, 3);
                bufferedWriter.write(string2, 0, string2.length());
                bufferedWriter.newLine();
            }
            for (n = 0; n < m_checkbox_tags.length; ++n) {
                boolean bl = blArray2[n];
                if (bl == blArray[n]) continue;
                string = m_checkbox_tags[n];
                bufferedWriter.write(string, 0, string.length());
                bufferedWriter.write("" + i + "]=", 0, 3);
                string2 = bl ? "true" : "false";
                bufferedWriter.write(string2, 0, string2.length());
                bufferedWriter.newLine();
            }
            stringArray = stringArray2;
            blArray = blArray2;
            stringArray2 = m_textfield_currents;
            blArray2 = m_checkbox_currents;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void log(String string) {
        if (BunchClusterLayout.parameterBoolean(3)) {
            BunchClusterLayout bunchClusterLayout = this;
            synchronized (bunchClusterLayout) {
                System.err.println(Util.toLocaleString() + ": " + string);
            }
        }
    }

    protected void message(String string) {
        this.log(string);
        JOptionPane.showMessageDialog(this.m_ls.getFrame(), string, "Error", 0);
    }

    public BunchClusterLayout(LandscapeEditorCore landscapeEditorCore) {
        super(landscapeEditorCore);
        this.m_debug.setSelectedIndex(1);
    }

    public String getName() {
        return "Bunch Cluster";
    }

    public String getMenuLabel() {
        return "Bunch Cluster";
    }

    public boolean isConfigurable() {
        return true;
    }

    public boolean isLayouter() {
        return false;
    }

    public boolean configure(LandscapeEditorCore landscapeEditorCore, String string, Vector vector) {
        BunchClusterConfigure bunchClusterConfigure = new BunchClusterConfigure(this, string, vector);
        boolean bl = bunchClusterConfigure.ok();
        bunchClusterConfigure.dispose();
        return bl;
    }

    public boolean configure(LandscapeEditorCore landscapeEditorCore) {
        return this.configure(landscapeEditorCore, null, null);
    }

    protected boolean write(Vector vector, String string) {
        Object object;
        Enumeration enumeration;
        Diagram diagram = this.m_ls.getDiagram();
        PrintStream printStream = null;
        try {
            this.log("Exporting " + string);
            File file = new File(string);
            enumeration = new FileOutputStream(file);
            object = new BufferedOutputStream((OutputStream)((Object)enumeration));
            printStream = new PrintStream((OutputStream)object);
        }
        catch (Exception exception) {
            this.message("Exception creating export stream " + string + ": " + exception);
            return false;
        }
        boolean bl = BunchClusterLayout.parameterBoolean(2);
        try {
            EntityInstance entityInstance;
            enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                entityInstance = (EntityInstance)enumeration.nextElement();
                entityInstance.orMark(0x4000000);
            }
            enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                EntityInstance entityInstance2;
                int n;
                RelationClass relationClass;
                RelationInstance relationInstance;
                entityInstance = (EntityInstance)enumeration.nextElement();
                if (bl) {
                    object = entityInstance.srcRelationElements();
                    while (object.hasMoreElements()) {
                        relationInstance = (RelationInstance)object.nextElement();
                        relationClass = relationInstance.getRelationClass();
                        n = relationClass.getWeight();
                        if (n == 0 || !(entityInstance2 = relationInstance.getDst()).isMarked(0x4000000)) continue;
                        if (n > 0) {
                            if (n == 1) {
                                printStream.println(entityInstance.getId() + " " + entityInstance2.getId());
                                continue;
                            }
                            printStream.println(entityInstance.getId() + " " + entityInstance2.getId() + " " + n);
                            continue;
                        }
                        if ((n = -n) == 1) {
                            printStream.println(entityInstance2.getId() + " " + entityInstance.getId());
                            continue;
                        }
                        printStream.println(entityInstance2.getId() + " " + entityInstance.getId() + " " + n);
                    }
                    continue;
                }
                object = entityInstance.srcLiftedRelationElements();
                while (object.hasMoreElements()) {
                    relationInstance = (RelationInstance)object.nextElement();
                    relationClass = relationInstance.getRelationClass();
                    n = relationClass.getWeight();
                    if (n == 0 || !(entityInstance2 = relationInstance.getDrawDst()).isMarked(0x4000000)) continue;
                    if (n > 0) {
                        if (n == 1) {
                            printStream.println(entityInstance.getId() + " " + entityInstance2.getId());
                            continue;
                        }
                        printStream.println(entityInstance.getId() + " " + entityInstance2.getId() + " " + n);
                        continue;
                    }
                    if ((n = -n) == 1) {
                        printStream.println(entityInstance2.getId() + " " + entityInstance.getId());
                        continue;
                    }
                    printStream.println(entityInstance2.getId() + " " + entityInstance.getId() + " " + n);
                }
            }
            printStream.close();
            if (printStream.checkError()) {
                this.message("An unknown error occurred writing output");
                return false;
            }
            this.log("Export written");
        }
        catch (Exception exception) {
            this.message("Exception writing output: " + exception);
            return false;
        }
        return true;
    }

    boolean waitFor(Process process) {
        try {
            int n = process.waitFor();
            this.log("Process returned exit value of " + n);
        }
        catch (Exception exception) {
            this.message("WaitFor failed: " + exception);
            return false;
        }
        return true;
    }

    protected boolean read(String string, EntityInstance entityInstance, boolean bl) {
        EntityInstance entityInstance2;
        BufferedReader bufferedReader;
        Diagram diagram = this.m_ls.getDiagram();
        boolean bl2 = false;
        Hashtable<String, EntityInstance> hashtable = new Hashtable<String, EntityInstance>();
        this.log("Importing '" + string + "'");
        try {
            FileReader fileReader = new FileReader(string);
            bufferedReader = new BufferedReader(fileReader);
        }
        catch (Exception exception) {
            this.message("Exception opening " + string + ": " + exception);
            return false;
        }
        int n = 0;
        String string2 = "";
        try {
            block6: while ((string2 = bufferedReader.readLine()) != null) {
                ++n;
                String string3 = string2.substring(0, 3);
                if (!string3.equals("SS(")) {
                    this.message("Expected to see 'contain ' but saw '" + string3 + "' in " + string + " at line " + n);
                    break;
                }
                int n2 = string2.indexOf(41, 3);
                if (n2 < 1) {
                    this.message("First token missing in " + string + " at line " + n);
                    break;
                }
                String string4 = string2.substring(3, n2);
                EntityInstance entityInstance3 = (EntityInstance)hashtable.get(string4);
                if (entityInstance3 == null) {
                    entityInstance3 = diagram.updateNewEntity(null, entityInstance, null, false);
                    entityInstance3.setLabel(string4);
                    hashtable.put(string4, entityInstance3);
                }
                n2 = string2.indexOf(61, n2);
                while (n2 > 0) {
                    String string5;
                    int n3 = string2.indexOf(44, n2 += 2);
                    if ((string5 = n3 < 0 ? string2.substring(n2) : string2.substring(n2, n3)).length() < 1) {
                        this.message("Second token missing in " + string + " at line " + n);
                        continue block6;
                    }
                    entityInstance2 = (EntityInstance)hashtable.get(string5);
                    if (entityInstance2 == null) {
                        entityInstance2 = diagram.getCache(string5);
                    }
                    if (entityInstance2 == null) {
                        entityInstance2 = diagram.updateNewEntity(null, entityInstance3, null, false);
                        entityInstance2.setLabel(string5);
                        hashtable.put(string5, entityInstance2);
                    } else {
                        EntityInstance entityInstance4 = entityInstance2.getContainedBy();
                        diagram.updateMoveEntityContainment(entityInstance3, entityInstance2);
                        if (bl) {
                            while (true) {
                                entityInstance2 = entityInstance4;
                                entityInstance4 = entityInstance2.getContainedBy();
                                if (entityInstance2.getFirstChild() != null) break;
                                diagram.updateCutEntity(entityInstance2);
                            }
                        }
                    }
                    n2 = n3;
                }
            }
        }
        catch (Exception exception) {
            this.message("Exception reading " + string + ": " + exception);
        }
        if (string2 == null) {
            Enumeration enumeration = hashtable.elements();
            while (enumeration.hasMoreElements()) {
                entityInstance2 = (EntityInstance)enumeration.nextElement();
                diagram.doRelayoutAll(entityInstance2);
            }
            bl2 = true;
        }
        hashtable.clear();
        try {
            bufferedReader.close();
        }
        catch (Exception exception) {
            this.message("Exception closing " + string + ": " + exception);
            return false;
        }
        return bl2;
    }

    protected void emitParameter(PrintStream printStream, String string, String string2) {
        if (string2 != null && (string2 = string2.trim()).length() > 0) {
            printStream.println(string + "=" + string2);
        }
    }

    protected void emitParameter(PrintStream printStream, String string, int n) {
        String string2 = BunchClusterLayout.parameterString(n);
        if (string2 != null && (string2 = string2.trim()).length() > 0) {
            printStream.println(string + "=" + string2);
        }
    }

    public void doit(Vector vector, Vector vector2, EntityInstance entityInstance) {
        Object object;
        String string;
        block49: {
            String string2;
            String string3;
            int n;
            boolean bl;
            block48: {
                String string4;
                bl = false;
                n = vector2.size();
                if (n < 2) {
                    this.m_ret = "Too few entities to reasonably cluster";
                    return;
                }
                do {
                    string = BunchClusterLayout.parameterString(0);
                    string3 = BunchClusterLayout.parameterString(1);
                    string2 = BunchClusterLayout.parameterString(3);
                    string4 = null;
                    if (string.length() == 0) {
                        string4 = "Please specify an export file to write to";
                    }
                    if (string4 == null) break block48;
                    bl = true;
                } while (this.configure(this.m_ls, string4, vector2));
                return;
            }
            if (!bl && !this.configure(this.m_ls, null, vector2)) {
                return;
            }
            this.log("Using Bunch to cluster " + n + " items");
            if (!this.write(vector2, string)) {
                return;
            }
            if (string3.length() == 0) {
                this.m_ret = "Bunch output written to file";
                return;
            }
            int n2 = this.m_debug.getSelectedIndex();
            boolean bl2 = BunchClusterLayout.parameterBoolean(4);
            RunBunch runBunch = new RunBunch();
            new Thread(runBunch).start();
            Process process = runBunch.getProcess();
            if (process == null) {
                return;
            }
            if (!bl2) {
                boolean bl3;
                String string5;
                object = process.getOutputStream();
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream((OutputStream)object);
                PrintStream printStream = new PrintStream(bufferedOutputStream);
                this.log("Writing API instructions to bunch");
                if (n2 > 0) {
                    printStream.println("DEBUG=" + g_debug[n2]);
                }
                this.emitParameter(printStream, "MDG_INPUT_FILE_NAME", 0);
                if (string2 != null && string2.length() > 0) {
                    if (string2.endsWith(".bunch")) {
                        string5 = string2.substring(0, string2.length() - 6);
                    } else {
                        string5 = string2;
                        string2 = string2 + ".bunch";
                    }
                    this.emitParameter(printStream, "OUTPUT_FILE", string5);
                } else {
                    this.emitParameter(printStream, "OUTPUT_DIRECTORY", 2);
                }
                printStream.println("OUTPUT_FORMAT=Text");
                printStream.println("OUTPUT_TREE=True");
                int n3 = this.m_output_mode.getSelectedIndex();
                if (n3 >= 0) {
                    printStream.println("MDG_OUTPUT_MODE=" + g_output_mode[n3]);
                }
                if ((n3 = this.m_clustering_approach.getSelectedIndex()) >= 0) {
                    printStream.println("CLUSTERING_APPROACH=" + g_clustering_approach[n3]);
                }
                if ((n3 = this.m_cluster_algorithm.getSelectedIndex()) >= 0) {
                    printStream.println("CLUSTERING_ALG=" + g_cluster_algorithm[n3]);
                    switch (n3) {
                        case 0: {
                            this.emitParameter(printStream, "ALG_HC_POPULATION_SZ", 8);
                            this.emitParameter(printStream, "ALG_HC_HC_PCT", 9);
                            this.emitParameter(printStream, "ALG_HC_RND_PCT", 10);
                            if (!BunchClusterLayout.parameterBoolean(5)) break;
                            printStream.println("ALG_HC_SA_CLASS=" + g_techniques[0]);
                            string5 = BunchClusterLayout.parameterString(11);
                            String string6 = BunchClusterLayout.parameterString(12);
                            if (string5 == null) {
                                string5 = "";
                            }
                            if (string6 == null) {
                                string6 = "";
                            }
                            string5 = string5.trim();
                            string6 = string6.trim();
                            if (string5.length() <= 0 && string6.length() <= 0) break;
                            printStream.print("ALG_HC_SA_CONFIG=");
                            bl3 = false;
                            if (string5.length() > 0) {
                                printStream.print("InitialTemp=" + string5);
                                bl3 = true;
                            }
                            if (string6.length() <= 0) break;
                            if (bl3) {
                                printStream.print(",");
                            }
                            printStream.print("Alpha=" + string6);
                            break;
                        }
                        case 1: {
                            n3 = this.m_selection_method.getSelectedIndex();
                            if (n3 >= 0) {
                                printStream.println("ALG_GA_SELECTION_METHOD=" + g_selection_method[n3]);
                            }
                            this.emitParameter(printStream, "ALG_GA_NUM_GENERATIONS", 13);
                            this.emitParameter(printStream, "ALG_GA_POPULATION_SZ", 14);
                            this.emitParameter(printStream, "ALG_GA_CROSSOVER_PROB", 15);
                            this.emitParameter(printStream, "ALG_GA_MUTATION_PROB", 16);
                        }
                    }
                }
                if ((n3 = this.m_calculator_classes.getSelectedIndex()) >= 0) {
                    printStream.println("MQ_CALCULATOR_CLASS=" + g_calculator_classes[n3]);
                }
                this.emitParameter(printStream, "USER_DIRECTED_CLUSTER_SIL", 18);
                if (BunchClusterLayout.parameterBoolean(7)) {
                    this.emitParameter(printStream, "LOCK_USER_SET_CLUSTERS", "True");
                }
                if (BunchClusterLayout.parameterBoolean(6)) {
                    this.emitParameter(printStream, "TIMEOUT_TIME", 17);
                }
                for (n3 = 0; n3 < g_omnipresents.length; ++n3) {
                    bl3 = false;
                    int n4 = g_omnipresents[n3];
                    for (int i = 0; i < vector2.size(); ++i) {
                        EntityInstance entityInstance2 = (EntityInstance)vector2.elementAt(i);
                        if (entityInstance2.getOmnipresent() != n4) continue;
                        if (!bl3) {
                            printStream.print(g_omnipresent_names[n3] + "=");
                            bl3 = true;
                        } else {
                            printStream.print(",");
                        }
                        printStream.print(entityInstance2.getId());
                    }
                    if (!bl3) continue;
                    printStream.println("");
                }
                printStream.close();
                InputStream inputStream = process.getInputStream();
                int n5 = 32;
                try {
                    n5 = inputStream.read();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (n5 != 79) {
                    this.message("Bunch execution failed");
                    return;
                }
            }
            if (!this.waitFor(process)) {
                return;
            }
            if (string2 != null && string2.length() > 0) {
                if (!this.read(string2, entityInstance, vector != vector2)) {
                    return;
                }
                this.log("Import loaded");
                this.m_ret = "Graph redrawn using Bunch";
                if (BunchClusterLayout.parameterBoolean(1)) {
                    try {
                        object = new File(string2);
                        if (!((File)object).delete()) {
                            this.message("Unable to delete '" + object + "'");
                            break block49;
                        }
                        this.log("Deleted " + object);
                    }
                    catch (Exception exception) {
                        this.message("Exception deleting '" + string2 + "' " + exception);
                    }
                }
            } else {
                this.m_ret = "No import file name specified";
            }
        }
        if (string.length() != 0 && BunchClusterLayout.parameterBoolean(0)) {
            try {
                object = new File(string);
                if (!((File)object).delete()) {
                    this.message("Unable to delete '" + object + "'");
                } else {
                    this.log("Deleted " + object);
                }
            }
            catch (Exception exception) {
                this.message("Exception deleting '" + string + "' " + exception);
            }
        }
    }

    public void doLayout1(Vector vector, EntityInstance entityInstance) {
    }

    public String doLayout(Diagram diagram) {
        Vector vector;
        this.m_dg = diagram;
        Vector vector2 = diagram.getGroup();
        if (vector2 == null) {
            Util.beep();
            return "No group selected";
        }
        EntityInstance entityInstance = this.parentOfSet(vector2);
        if (entityInstance == null) {
            return "Cluster layout requires that all things laid out share same parent";
        }
        boolean bl = BunchClusterLayout.parameterBoolean(2);
        if (!bl) {
            vector = vector2;
        } else {
            vector = new Vector();
            Enumeration enumeration = vector2.elements();
            while (enumeration.hasMoreElements()) {
                EntityInstance entityInstance2 = (EntityInstance)enumeration.nextElement();
                entityInstance2.gatherLeaves(vector);
            }
        }
        this.m_ret = "Bunch Cluster layout aborted";
        this.m_ls.setCursor(3);
        diagram.beginUndoRedo("Cluster layout");
        this.doit(vector2, vector, entityInstance);
        diagram.endUndoRedo();
        this.m_ls.setCursor(0);
        diagram.redrawDiagram();
        return this.m_ret;
    }

    public void processKeyEvent(int n, int n2, Object object) {
        Diagram diagram = this.m_ls.getDiagram();
        if (diagram != null) {
            String string = this.doLayout(diagram);
            this.m_ls.doFeedback(string);
            diagram.rescaleDiagram();
            this.m_ls.repaintDg();
        }
    }

    class RunBunch
    implements Runnable {
        Process m_process = null;
        boolean m_waiting = true;

        RunBunch() {
        }

        public synchronized Process getProcess() {
            while (this.m_waiting) {
                try {
                    this.wait(1L);
                }
                catch (Exception exception) {
                    BunchClusterLayout.this.message("wait error: " + exception);
                }
            }
            return this.m_process;
        }

        public Process startCommand(String string) {
            Object object;
            Process process = null;
            BunchClusterLayout.this.log("Executing [" + string + "]");
            try {
                object = Runtime.getRuntime();
                if (object == null) {
                    BunchClusterLayout.this.message("No runtime available");
                } else {
                    process = ((Runtime)object).exec(string);
                }
            }
            catch (Exception exception) {
                BunchClusterLayout.this.message("Exception executing [" + string + "] " + exception);
                process = null;
            }
            if (process != null) {
                object = new ErrOutput(process.getErrorStream());
                new Thread((Runnable)object).start();
                if (BunchClusterLayout.parameterBoolean(4)) {
                    ErrOutput errOutput = new ErrOutput(process.getInputStream());
                    new Thread(errOutput).start();
                }
            }
            this.m_process = process;
            this.m_waiting = false;
            return process;
        }

        public void run() {
            String string = BunchClusterLayout.parameterString(1);
            this.startCommand(string);
        }
    }

    class ErrOutput
    implements Runnable {
        InputStream m_inputStream = null;

        ErrOutput(InputStream inputStream) {
            this.m_inputStream = inputStream;
        }

        public void run() {
            try {
                String string;
                InputStreamReader inputStreamReader = new InputStreamReader(this.m_inputStream);
                BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                while ((string = bufferedReader.readLine()) != null) {
                    BunchClusterLayout.this.log(string);
                }
                bufferedReader.close();
            }
            catch (Exception exception) {
                BunchClusterLayout.this.log("ErrOutput error: " + exception);
            }
        }
    }

    class EchoOutput
    implements Runnable {
        InputStream m_inputStream = null;
        String m_source;

        EchoOutput(String string, InputStream inputStream) {
            this.m_inputStream = inputStream;
            this.m_source = string;
        }

        public void run() {
            String string = this.m_source;
            try {
                String string2;
                InputStreamReader inputStreamReader = new InputStreamReader(this.m_inputStream);
                BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                while ((string2 = bufferedReader.readLine()) != null) {
                    BunchClusterLayout.this.log(string + ": " + string2);
                }
                bufferedReader.close();
            }
            catch (Exception exception) {
                BunchClusterLayout.this.log(string + " input error: " + exception);
            }
        }
    }

    class BunchClusterConfigure
    extends JDialog
    implements ActionListener {
        private JTabbedPane m_topPanel;
        private BasicTab m_basicTab;
        private OptionsTab m_optionsTab;
        private LibrariesTab m_librariesTab;
        private ClientsTab m_clientsTab;
        private SuppliersTab m_suppliersTab;
        private BothTab m_bothTab;
        private UserTab m_userTab;
        private WeightsTab m_weightsTab;
        protected Vector m_selected;
        protected ListVector m_sorted;
        protected JTextField[] m_textfields;
        protected JCheckBox[] m_checkboxes;
        protected JButton[] m_buttons;
        protected JLabel m_message;
        protected boolean m_isok;

        protected void setTabStates() {
            boolean bl = !this.m_checkboxes[4].isSelected();
            this.m_topPanel.remove(this.m_optionsTab);
            if (this.m_librariesTab != null) {
                this.m_topPanel.remove(this.m_librariesTab);
            }
            if (this.m_clientsTab != null) {
                this.m_topPanel.remove(this.m_clientsTab);
            }
            if (this.m_suppliersTab != null) {
                this.m_topPanel.remove(this.m_suppliersTab);
            }
            if (this.m_bothTab != null) {
                this.m_topPanel.remove(this.m_bothTab);
            }
            if (this.m_userTab != null) {
                this.m_topPanel.remove(this.m_userTab);
            }
            if (bl) {
                this.m_topPanel.addTab("Options", null, this.m_optionsTab, null);
                if (this.m_selected != null) {
                    if (this.m_librariesTab == null) {
                        this.m_librariesTab = new LibrariesTab();
                    }
                    if (this.m_clientsTab == null) {
                        this.m_clientsTab = new ClientsTab();
                    }
                    if (this.m_suppliersTab == null) {
                        this.m_suppliersTab = new SuppliersTab();
                    }
                    if (this.m_bothTab == null) {
                        this.m_bothTab = new BothTab();
                    }
                    if (this.m_userTab == null) {
                        this.m_userTab = new UserTab();
                    }
                    this.m_topPanel.addTab("Libraries", null, this.m_librariesTab, null);
                    this.m_topPanel.addTab("Clients", null, this.m_clientsTab, null);
                    this.m_topPanel.addTab("Suppliers", null, this.m_suppliersTab, null);
                    this.m_topPanel.addTab("Both", null, this.m_bothTab, null);
                    this.m_topPanel.addTab("User directed clustering", null, this.m_userTab, null);
                }
            }
        }

        public BunchClusterConfigure(BunchClusterLayout bunchClusterLayout2, String string, Vector vector) {
            int n;
            super(bunchClusterLayout2.getLs().getFrame(), bunchClusterLayout2.getName() + " Configuration", true);
            this.m_isok = false;
            this.m_selected = vector;
            this.m_sorted = new ListVector(vector.size());
            this.m_sorted.addAll(vector);
            SortVector.byString(this.m_sorted);
            Font font = FontCache.getDialogFont();
            Font font2 = font.deriveFont(1);
            Container container = this.getContentPane();
            container.setLayout(new BorderLayout());
            this.setForeground(ColorCache.get(0, 0, 0));
            this.setBackground(ColorCache.get(192, 192, 192));
            this.setFont(font);
            this.m_textfields = new JTextField[m_textfield_tags.length];
            for (n = 0; n < m_textfield_tags.length; ++n) {
                JTextField jTextField;
                this.m_textfields[n] = jTextField = new JTextField(m_textfield_currents[n], 60);
                jTextField.setFont(font);
            }
            this.m_checkboxes = new JCheckBox[m_checkbox_tags.length];
            for (n = 0; n < m_checkbox_tags.length; ++n) {
                JCheckBox jCheckBox;
                this.m_checkboxes[n] = jCheckBox = new JCheckBox(m_checkbox_titles[n], m_checkbox_currents[n]);
                jCheckBox.setFont(font);
            }
            this.m_topPanel = new JTabbedPane();
            this.m_optionsTab = new OptionsTab();
            this.m_basicTab = new BasicTab();
            this.m_weightsTab = new WeightsTab();
            this.m_topPanel.addTab("Basic", null, this.m_basicTab, null);
            this.m_topPanel.addTab("Weights", null, this.m_weightsTab, null);
            this.setTabStates();
            if (string == null) {
                string = BunchClusterLayout.this.m_ls.getDiagram().undoEnabled() ? "You might wish to disable undo/redo operations" : "You might wish to enable undo/redo operations";
            }
            this.m_message = new JLabel(string, 0);
            this.m_message.setFont(font);
            this.m_message.setForeground(Color.RED);
            this.m_message.setSize(400, 50);
            this.m_message.setPreferredSize(new Dimension(400, 50));
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new FlowLayout(1, 15, 15));
            this.m_buttons = new JButton[m_button_titles.length];
            for (n = 0; n < m_button_titles.length; ++n) {
                JButton jButton;
                String string2 = m_button_titles[n];
                if (string2 == null) {
                    string2 = BunchClusterLayout.this.undoLabel();
                }
                this.m_buttons[n] = jButton = new JButton(string2);
                jButton.setFont(font2);
                String string3 = m_button_tips[n];
                if (string3 != null) {
                    jButton.setToolTipText(string3);
                }
                jButton.addActionListener(this);
                jPanel.add(jButton);
            }
            container.add("North", this.m_topPanel);
            container.add("South", jPanel);
            container.add("Center", this.m_message);
            this.pack();
            this.setVisible(true);
        }

        public boolean ok() {
            return this.m_isok;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            Object object = actionEvent.getSource();
            int n2 = -1;
            for (n = 0; n < m_button_titles.length; ++n) {
                if (object != this.m_buttons[n]) continue;
                n2 = n;
                break;
            }
            switch (n2) {
                case 6: {
                    for (n = 0; n < m_textfield_tags.length; ++n) {
                        BunchClusterLayout.m_textfield_defaults[n] = m_textfield_resets[n];
                    }
                    for (n = 0; n < m_checkbox_tags.length; ++n) {
                        BunchClusterLayout.m_checkbox_defaults[n] = m_checkbox_resets[n];
                    }
                }
                case 4: {
                    for (n = 0; n < m_textfield_tags.length; ++n) {
                        this.m_textfields[n].setText(m_textfield_defaults[n]);
                    }
                    for (n = 0; n < m_checkbox_tags.length; ++n) {
                        this.m_checkboxes[n].setSelected(m_checkbox_defaults[n]);
                    }
                    BunchClusterLayout.this.m_clustering_approach.setSelectedIndex(0);
                    BunchClusterLayout.this.m_output_mode.setSelectedIndex(0);
                    BunchClusterLayout.this.m_cluster_algorithm.setSelectedIndex(0);
                    BunchClusterLayout.this.m_selection_method.setSelectedIndex(0);
                    BunchClusterLayout.this.m_debug.setSelectedIndex(1);
                    return;
                }
                case 5: {
                    for (n = 0; n < m_textfield_tags.length; ++n) {
                        BunchClusterLayout.m_textfield_defaults[n] = this.m_textfields[n].getText();
                    }
                    for (n = 0; n < m_checkbox_tags.length; ++n) {
                        BunchClusterLayout.m_checkbox_defaults[n] = this.m_checkboxes[n].isSelected();
                    }
                    return;
                }
                case 3: {
                    LandscapeEditorCore landscapeEditorCore = BunchClusterLayout.this.m_ls;
                    landscapeEditorCore.invertUndo();
                    this.m_buttons[n2].setText(BunchClusterLayout.this.undoLabel());
                    this.m_message.setText("");
                    return;
                }
                case 2: {
                    JOptionPane.showMessageDialog(BunchClusterLayout.this.m_ls.getFrame(), "The Bunch clustering algorithm attempts to cluster nodes by using the external bunch command line interface\nThis command line interface to bunch is named clue. For help and documentation on bunch please visit:\nhttp://serg.mcs.drexel.edu/bunch", "Help", 0);
                    return;
                }
                case 0: {
                    if (!this.m_weightsTab.isOk()) {
                        this.m_message.setText("Weights must be integers");
                        return;
                    }
                    this.m_weightsTab.setWeights();
                    for (n = 0; n < m_textfield_tags.length; ++n) {
                        BunchClusterLayout.m_textfield_currents[n] = this.m_textfields[n].getText();
                    }
                    for (n = 0; n < m_checkbox_tags.length; ++n) {
                        BunchClusterLayout.m_checkbox_currents[n] = this.m_checkboxes[n].isSelected();
                    }
                    this.m_isok = true;
                }
                case 1: {
                    break;
                }
                default: {
                    return;
                }
            }
            this.setVisible(false);
        }

        class UserTab
        extends Box
        implements ActionListener {
            private JTextField m_userfile;
            private JCheckBox m_lock;
            private JButton m_fileButton;
            private JButton m_clearButton;

            public UserTab() {
                super(1);
                this.m_fileButton = new JButton("Select...");
                this.m_clearButton = new JButton("Clear");
                Font font = FontCache.getDialogFont();
                Font font2 = font.deriveFont(1);
                JPanel jPanel = new JPanel();
                jPanel.add(new JLabel());
                this.add(jPanel);
                jPanel = new JPanel();
                jPanel.setLayout(new FlowLayout());
                JLabel jLabel = new JLabel(m_textfield_titles[18], 4);
                jLabel.setFont(font2);
                jPanel.add(jLabel);
                this.m_userfile = BunchClusterConfigure.this.m_textfields[18];
                this.m_userfile.setColumns(50);
                jPanel.add(this.m_userfile);
                this.m_fileButton.addActionListener(this);
                jPanel.add(this.m_fileButton);
                this.add(jPanel);
                jPanel = new JPanel();
                jPanel.setLayout(new FlowLayout());
                this.m_lock = BunchClusterConfigure.this.m_checkboxes[7];
                jPanel.add(this.m_lock);
                this.m_clearButton.addActionListener(this);
                jPanel.add(this.m_clearButton);
                this.add(jPanel);
            }

            public void actionPerformed(ActionEvent actionEvent) {
                Object object = actionEvent.getSource();
                if (object == this.m_fileButton) {
                    String string = BunchClusterLayout.this.m_ls.filePrompt("File to read preconfigured clustering from", this.m_userfile.getText(), 0, null);
                    if (string != null) {
                        this.m_userfile.setText(string);
                    }
                    return;
                }
                if (object == this.m_clearButton) {
                    this.m_userfile.setText("");
                    this.m_lock.setSelected(false);
                    return;
                }
            }
        }

        class BothTab
        extends OmnipresentTab
        implements ActionListener {
            JTextField m_multiple;

            protected int match() {
                return 1536;
            }

            protected String topLabel() {
                return "Clients and Suppliers:";
            }

            protected String generalLabel() {
                return "items";
            }

            protected String findText() {
                return "Find nodes having excessive edges";
            }

            protected JTextField multiple() {
                this.m_multiple = BunchClusterConfigure.this.m_textfields[21];
                return this.m_multiple;
            }

            protected String multipleLabel() {
                return "edges";
            }

            protected boolean find() {
                EntityInstance entityInstance;
                RelationClass relationClass;
                RelationInstance relationInstance;
                Enumeration enumeration;
                EntityInstance entityInstance2;
                int n;
                double d;
                ListVector listVector = BunchClusterConfigure.this.m_sorted;
                int n2 = listVector.size();
                boolean bl = false;
                boolean bl2 = BunchClusterLayout.parameterBoolean(2);
                String string = this.m_multiple.getText();
                try {
                    d = Double.parseDouble(string);
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(BunchClusterLayout.this.m_ls.getFrame(), "Multiple value '" + string + "' is not a double", "Can't find items", 2);
                    return false;
                }
                if (n2 == 0) {
                    return false;
                }
                int n3 = 0;
                for (n = 0; n < n2; ++n) {
                    entityInstance2 = (EntityInstance)listVector.elementAt(n);
                    if (bl2) {
                        enumeration = entityInstance2.srcRelationElements();
                        while (enumeration.hasMoreElements()) {
                            relationInstance = (RelationInstance)enumeration.nextElement();
                            relationClass = relationInstance.getRelationClass();
                            if (relationClass.getWeight() == 0 || !(entityInstance = relationInstance.getDst()).isMarked(0x4000000)) continue;
                            ++n3;
                        }
                        enumeration = entityInstance2.dstRelationElements();
                        while (enumeration.hasMoreElements()) {
                            relationInstance = (RelationInstance)enumeration.nextElement();
                            relationClass = relationInstance.getRelationClass();
                            if (relationClass.getWeight() == 0 || !(entityInstance = relationInstance.getSrc()).isMarked(0x4000000)) continue;
                            ++n3;
                        }
                        continue;
                    }
                    enumeration = entityInstance2.srcLiftedRelationElements();
                    while (enumeration.hasMoreElements()) {
                        relationInstance = (RelationInstance)enumeration.nextElement();
                        relationClass = relationInstance.getRelationClass();
                        if (relationClass.getWeight() == 0 || !(entityInstance = relationInstance.getDrawDst()).isMarked(0x4000000)) continue;
                        ++n3;
                    }
                    enumeration = entityInstance2.dstLiftedRelationElements();
                    while (enumeration.hasMoreElements()) {
                        relationInstance = (RelationInstance)enumeration.nextElement();
                        relationClass = relationInstance.getRelationClass();
                        if (relationClass.getWeight() == 0 || !(entityInstance = relationInstance.getDrawSrc()).isMarked(0x4000000)) continue;
                        ++n3;
                    }
                }
                if (n3 == 0) {
                    return false;
                }
                double d2 = d * (double)n3 / (double)n2;
                for (n = 0; n < n2; ++n) {
                    entityInstance2 = (EntityInstance)listVector.elementAt(n);
                    n3 = 0;
                    if (bl2) {
                        enumeration = entityInstance2.srcRelationElements();
                        while (enumeration.hasMoreElements()) {
                            relationInstance = (RelationInstance)enumeration.nextElement();
                            relationClass = relationInstance.getRelationClass();
                            if (relationClass.getWeight() == 0 || !(entityInstance = relationInstance.getDst()).isMarked(0x4000000)) continue;
                            ++n3;
                        }
                        enumeration = entityInstance2.dstRelationElements();
                        while (enumeration.hasMoreElements()) {
                            relationInstance = (RelationInstance)enumeration.nextElement();
                            relationClass = relationInstance.getRelationClass();
                            if (relationClass.getWeight() == 0 || !(entityInstance = relationInstance.getSrc()).isMarked(0x4000000)) continue;
                            ++n3;
                        }
                    } else {
                        enumeration = entityInstance2.srcLiftedRelationElements();
                        while (enumeration.hasMoreElements()) {
                            relationInstance = (RelationInstance)enumeration.nextElement();
                            relationClass = relationInstance.getRelationClass();
                            if (relationClass.getWeight() == 0 || !(entityInstance = relationInstance.getDrawDst()).isMarked(0x4000000)) continue;
                            ++n3;
                        }
                        enumeration = entityInstance2.dstLiftedRelationElements();
                        while (enumeration.hasMoreElements()) {
                            relationInstance = (RelationInstance)enumeration.nextElement();
                            relationClass = relationInstance.getRelationClass();
                            if (relationClass.getWeight() == 0 || !(entityInstance = relationInstance.getDrawSrc()).isMarked(0x4000000)) continue;
                            ++n3;
                        }
                    }
                    if (n3 <= 0 || !((double)n3 >= d2)) continue;
                    entityInstance2.orMark(1536);
                    bl = true;
                }
                return bl;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                super.actionPerformed(actionEvent);
            }
        }

        class SuppliersTab
        extends OmnipresentTab
        implements ActionListener {
            JTextField m_multiple;

            protected int match() {
                return 1024;
            }

            protected String topLabel() {
                return "Suppliers:";
            }

            protected String generalLabel() {
                return "suppliers";
            }

            protected String findText() {
                return "Find nodes having excessive inputs";
            }

            protected JTextField multiple() {
                this.m_multiple = BunchClusterConfigure.this.m_textfields[20];
                return this.m_multiple;
            }

            protected String multipleLabel() {
                return "inputs";
            }

            protected boolean find() {
                EntityInstance entityInstance;
                RelationClass relationClass;
                RelationInstance relationInstance;
                Enumeration enumeration;
                EntityInstance entityInstance2;
                int n;
                double d;
                ListVector listVector = BunchClusterConfigure.this.m_sorted;
                int n2 = listVector.size();
                boolean bl = this.positiveWeights();
                boolean bl2 = this.negativeWeights();
                boolean bl3 = false;
                boolean bl4 = BunchClusterLayout.parameterBoolean(2);
                String string = this.m_multiple.getText();
                try {
                    d = Double.parseDouble(string);
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(BunchClusterLayout.this.m_ls.getFrame(), "Multiple value '" + string + "' is not a double", "Can't find items", 2);
                    return false;
                }
                if (n2 == 0) {
                    return false;
                }
                int n3 = 0;
                for (n = 0; n < n2; ++n) {
                    entityInstance2 = (EntityInstance)listVector.elementAt(n);
                    if (bl) {
                        if (bl4) {
                            enumeration = entityInstance2.dstRelationElements();
                            while (enumeration.hasMoreElements()) {
                                relationInstance = (RelationInstance)enumeration.nextElement();
                                relationClass = relationInstance.getRelationClass();
                                if (relationClass.getWeight() <= 0 || !(entityInstance = relationInstance.getSrc()).isMarked(0x4000000)) continue;
                                ++n3;
                            }
                        } else {
                            enumeration = entityInstance2.dstLiftedRelationElements();
                            while (enumeration.hasMoreElements()) {
                                relationInstance = (RelationInstance)enumeration.nextElement();
                                relationClass = relationInstance.getRelationClass();
                                if (relationClass.getWeight() <= 0 || !(entityInstance = relationInstance.getDrawSrc()).isMarked(0x4000000)) continue;
                                ++n3;
                            }
                        }
                    }
                    if (!bl2) continue;
                    if (bl4) {
                        enumeration = entityInstance2.srcRelationElements();
                        while (enumeration.hasMoreElements()) {
                            relationInstance = (RelationInstance)enumeration.nextElement();
                            relationClass = relationInstance.getRelationClass();
                            if (relationClass.getWeight() >= 0 || !(entityInstance = relationInstance.getDst()).isMarked(0x4000000)) continue;
                            ++n3;
                        }
                        continue;
                    }
                    enumeration = entityInstance2.srcLiftedRelationElements();
                    while (enumeration.hasMoreElements()) {
                        relationInstance = (RelationInstance)enumeration.nextElement();
                        relationClass = relationInstance.getRelationClass();
                        if (relationClass.getWeight() >= 0 || !(entityInstance = relationInstance.getDrawDst()).isMarked(0x4000000)) continue;
                        ++n3;
                    }
                }
                if (n3 == 0) {
                    return false;
                }
                double d2 = d * (double)n3 / (double)n2;
                for (n = 0; n < n2; ++n) {
                    entityInstance2 = (EntityInstance)listVector.elementAt(n);
                    n3 = 0;
                    if (bl) {
                        if (bl4) {
                            enumeration = entityInstance2.dstRelationElements();
                            while (enumeration.hasMoreElements()) {
                                relationInstance = (RelationInstance)enumeration.nextElement();
                                relationClass = relationInstance.getRelationClass();
                                if (relationClass.getWeight() <= 0 || !(entityInstance = relationInstance.getSrc()).isMarked(0x4000000)) continue;
                                ++n3;
                            }
                        } else {
                            enumeration = entityInstance2.dstLiftedRelationElements();
                            while (enumeration.hasMoreElements()) {
                                relationInstance = (RelationInstance)enumeration.nextElement();
                                relationClass = relationInstance.getRelationClass();
                                if (relationClass.getWeight() <= 0 || !(entityInstance = relationInstance.getDrawSrc()).isMarked(0x4000000)) continue;
                                ++n3;
                            }
                        }
                    }
                    if (bl2) {
                        if (bl4) {
                            enumeration = entityInstance2.srcRelationElements();
                            while (enumeration.hasMoreElements()) {
                                relationInstance = (RelationInstance)enumeration.nextElement();
                                relationClass = relationInstance.getRelationClass();
                                if (relationClass.getWeight() >= 0 || !(entityInstance = relationInstance.getDst()).isMarked(0x4000000)) continue;
                                ++n3;
                            }
                        } else {
                            enumeration = entityInstance2.srcLiftedRelationElements();
                            while (enumeration.hasMoreElements()) {
                                relationInstance = (RelationInstance)enumeration.nextElement();
                                relationClass = relationInstance.getRelationClass();
                                if (relationClass.getWeight() >= 0 || !(entityInstance = relationInstance.getDrawDst()).isMarked(0x4000000)) continue;
                                ++n3;
                            }
                        }
                    }
                    if (n3 <= 0 || !((double)n3 >= d2)) continue;
                    entityInstance2.orMark(1024);
                    bl3 = true;
                }
                return bl3;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                super.actionPerformed(actionEvent);
            }
        }

        class ClientsTab
        extends OmnipresentTab
        implements ActionListener {
            JTextField m_multiple;

            protected int match() {
                return 512;
            }

            protected String topLabel() {
                return "Clients:";
            }

            protected String generalLabel() {
                return "clients";
            }

            protected String findText() {
                return "Find nodes having excessive outputs";
            }

            protected JTextField multiple() {
                this.m_multiple = BunchClusterConfigure.this.m_textfields[19];
                return this.m_multiple;
            }

            protected String multipleLabel() {
                return "outputs";
            }

            protected boolean find() {
                EntityInstance entityInstance;
                RelationClass relationClass;
                RelationInstance relationInstance;
                Enumeration enumeration;
                EntityInstance entityInstance2;
                int n;
                double d;
                ListVector listVector = BunchClusterConfigure.this.m_sorted;
                int n2 = listVector.size();
                boolean bl = this.positiveWeights();
                boolean bl2 = this.negativeWeights();
                boolean bl3 = false;
                boolean bl4 = BunchClusterLayout.parameterBoolean(2);
                String string = this.m_multiple.getText();
                try {
                    d = Double.parseDouble(string);
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(BunchClusterLayout.this.m_ls.getFrame(), "Multiple value '" + string + "' is not a double", "Can't find items", 2);
                    return false;
                }
                if (n2 == 0) {
                    return false;
                }
                int n3 = 0;
                for (n = 0; n < n2; ++n) {
                    entityInstance2 = (EntityInstance)listVector.elementAt(n);
                    if (bl) {
                        if (bl4) {
                            enumeration = entityInstance2.srcRelationElements();
                            while (enumeration.hasMoreElements()) {
                                relationInstance = (RelationInstance)enumeration.nextElement();
                                relationClass = relationInstance.getRelationClass();
                                if (relationClass.getWeight() <= 0 || !(entityInstance = relationInstance.getDst()).isMarked(0x4000000)) continue;
                                ++n3;
                            }
                        } else {
                            enumeration = entityInstance2.srcLiftedRelationElements();
                            while (enumeration.hasMoreElements()) {
                                relationInstance = (RelationInstance)enumeration.nextElement();
                                relationClass = relationInstance.getRelationClass();
                                if (relationClass.getWeight() <= 0 || !(entityInstance = relationInstance.getDrawDst()).isMarked(0x4000000)) continue;
                                ++n3;
                            }
                        }
                    }
                    if (!bl2) continue;
                    if (bl4) {
                        enumeration = entityInstance2.dstRelationElements();
                        while (enumeration.hasMoreElements()) {
                            relationInstance = (RelationInstance)enumeration.nextElement();
                            relationClass = relationInstance.getRelationClass();
                            if (relationClass.getWeight() >= 0 || !(entityInstance = relationInstance.getSrc()).isMarked(0x4000000)) continue;
                            ++n3;
                        }
                        continue;
                    }
                    enumeration = entityInstance2.dstLiftedRelationElements();
                    while (enumeration.hasMoreElements()) {
                        relationInstance = (RelationInstance)enumeration.nextElement();
                        relationClass = relationInstance.getRelationClass();
                        if (relationClass.getWeight() >= 0 || !(entityInstance = relationInstance.getDrawSrc()).isMarked(0x4000000)) continue;
                        ++n3;
                    }
                }
                if (n3 == 0) {
                    return false;
                }
                double d2 = d * (double)n3 / (double)n2;
                for (n = 0; n < n2; ++n) {
                    entityInstance2 = (EntityInstance)listVector.elementAt(n);
                    n3 = 0;
                    if (bl) {
                        if (bl4) {
                            enumeration = entityInstance2.srcRelationElements();
                            while (enumeration.hasMoreElements()) {
                                relationInstance = (RelationInstance)enumeration.nextElement();
                                relationClass = relationInstance.getRelationClass();
                                if (relationClass.getWeight() <= 0 || !(entityInstance = relationInstance.getDst()).isMarked(0x4000000)) continue;
                                ++n3;
                            }
                        } else {
                            enumeration = entityInstance2.srcLiftedRelationElements();
                            while (enumeration.hasMoreElements()) {
                                relationInstance = (RelationInstance)enumeration.nextElement();
                                relationClass = relationInstance.getRelationClass();
                                if (relationClass.getWeight() <= 0 || !(entityInstance = relationInstance.getDrawDst()).isMarked(0x4000000)) continue;
                                ++n3;
                            }
                        }
                    }
                    if (bl2) {
                        if (bl4) {
                            enumeration = entityInstance2.dstRelationElements();
                            while (enumeration.hasMoreElements()) {
                                relationInstance = (RelationInstance)enumeration.nextElement();
                                relationClass = relationInstance.getRelationClass();
                                if (relationClass.getWeight() >= 0 || !(entityInstance = relationInstance.getSrc()).isMarked(0x4000000)) continue;
                                ++n3;
                            }
                        } else {
                            enumeration = entityInstance2.dstLiftedRelationElements();
                            while (enumeration.hasMoreElements()) {
                                relationInstance = (RelationInstance)enumeration.nextElement();
                                relationClass = relationInstance.getRelationClass();
                                if (relationClass.getWeight() >= 0 || !(entityInstance = relationInstance.getDrawSrc()).isMarked(0x4000000)) continue;
                                ++n3;
                            }
                        }
                    }
                    if (n3 <= 0 || !((double)n3 >= d2)) continue;
                    entityInstance2.orMark(512);
                    bl3 = true;
                }
                return bl3;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                super.actionPerformed(actionEvent);
            }
        }

        class LibrariesTab
        extends OmnipresentTab
        implements ActionListener {
            protected int match() {
                return 256;
            }

            protected String topLabel() {
                return "Libraries:";
            }

            protected String generalLabel() {
                return "libraries";
            }

            protected String findText() {
                return "Find nodes having only inputs";
            }

            protected JTextField multiple() {
                return null;
            }

            protected String multipleLabel() {
                return null;
            }

            protected boolean find() {
                ListVector listVector = BunchClusterConfigure.this.m_sorted;
                int n = listVector.size();
                boolean bl = this.positiveWeights();
                boolean bl2 = this.negativeWeights();
                boolean bl3 = false;
                boolean bl4 = BunchClusterLayout.parameterBoolean(2);
                for (int i = 0; i < n; ++i) {
                    EntityInstance entityInstance;
                    RelationClass relationClass;
                    RelationInstance relationInstance;
                    Enumeration enumeration;
                    EntityInstance entityInstance2 = (EntityInstance)listVector.elementAt(i);
                    boolean bl5 = true;
                    if (bl4) {
                        if (bl) {
                            enumeration = entityInstance2.srcRelationElements();
                            while (enumeration.hasMoreElements()) {
                                relationInstance = (RelationInstance)enumeration.nextElement();
                                relationClass = relationInstance.getRelationClass();
                                if (relationClass.getWeight() <= 0 || !(entityInstance = relationInstance.getDst()).isMarked(0x4000000)) continue;
                                bl5 = false;
                                break;
                            }
                            if (!bl5) continue;
                        }
                        if (bl2) {
                            enumeration = entityInstance2.dstRelationElements();
                            while (enumeration.hasMoreElements()) {
                                relationInstance = (RelationInstance)enumeration.nextElement();
                                relationClass = relationInstance.getRelationClass();
                                if (relationClass.getWeight() >= 0 || !(entityInstance = relationInstance.getSrc()).isMarked(0x4000000)) continue;
                                bl5 = false;
                                break;
                            }
                            if (!bl5) {
                                continue;
                            }
                        }
                    } else {
                        if (bl) {
                            enumeration = entityInstance2.srcLiftedRelationElements();
                            while (enumeration.hasMoreElements()) {
                                relationInstance = (RelationInstance)enumeration.nextElement();
                                relationClass = relationInstance.getRelationClass();
                                if (relationClass.getWeight() <= 0 || !(entityInstance = relationInstance.getDrawDst()).isMarked(0x4000000)) continue;
                                bl5 = false;
                                break;
                            }
                            if (!bl5) continue;
                        }
                        if (bl2) {
                            enumeration = entityInstance2.dstLiftedRelationElements();
                            while (enumeration.hasMoreElements()) {
                                relationInstance = (RelationInstance)enumeration.nextElement();
                                relationClass = relationInstance.getRelationClass();
                                if (relationClass.getWeight() >= 0 || !(entityInstance = relationInstance.getDrawSrc()).isMarked(0x4000000)) continue;
                                bl5 = false;
                                break;
                            }
                            if (!bl5) continue;
                        }
                    }
                    entityInstance2.orMark(256);
                    bl3 = true;
                }
                return bl3;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                super.actionPerformed(actionEvent);
            }
        }

        abstract class OmnipresentTab
        extends JPanel
        implements ActionListener {
            MyListModel m_rest_model;
            JList m_rest;
            MyListModel m_omnipresent_model;
            JList m_omnipresent;
            JButton m_add;
            JButton m_remove;
            JButton m_find;
            JButton m_clear;

            protected abstract int match();

            protected abstract String topLabel();

            protected abstract String generalLabel();

            protected abstract String findText();

            protected abstract boolean find();

            protected abstract JTextField multiple();

            protected abstract String multipleLabel();

            public OmnipresentTab() {
                JList<String> jList;
                JList<String> jList2;
                Font font = FontCache.getDialogFont();
                Font font2 = font.deriveFont(1);
                this.m_rest_model = new MyListModel(BunchClusterConfigure.this.m_sorted, 0);
                this.m_omnipresent_model = new MyListModel(BunchClusterConfigure.this.m_sorted, this.match());
                this.m_rest = jList2 = new JList<String>(this.m_rest_model);
                this.m_omnipresent = jList = new JList<String>(this.m_omnipresent_model);
                jList2.setPrototypeCellValue("12345678901234567890");
                jList2.setVisibleRowCount(16);
                jList2.setCellRenderer(new MyListCellRenderer());
                jList.setPrototypeCellValue("12345678901234567890");
                jList.setVisibleRowCount(16);
                jList.setCellRenderer(new MyListCellRenderer());
                Box box = new Box(1);
                this.m_add = new JButton("=>");
                this.m_add.addActionListener(this);
                this.m_remove = new JButton("<=");
                this.m_remove.addActionListener(this);
                box.add(this.m_remove);
                box.add(this.m_add);
                GridBagLayout gridBagLayout = new GridBagLayout();
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                this.setFont(font2);
                this.setLayout(gridBagLayout);
                JLabel jLabel = new JLabel("Nodes:");
                jLabel.setFont(font2);
                gridBagConstraints.fill = 0;
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 0;
                gridBagConstraints.gridwidth = 1;
                gridBagConstraints.gridheight = 1;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.weighty = 0.0;
                gridBagConstraints.anchor = 17;
                gridBagLayout.setConstraints(jLabel, gridBagConstraints);
                this.add(jLabel);
                jLabel = new JLabel(this.topLabel());
                jLabel.setFont(font2);
                gridBagConstraints.fill = 0;
                gridBagConstraints.gridx = 2;
                gridBagConstraints.gridy = 0;
                gridBagConstraints.gridwidth = 0;
                gridBagConstraints.gridheight = 1;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.weighty = 0.0;
                gridBagConstraints.anchor = 17;
                gridBagLayout.setConstraints(jLabel, gridBagConstraints);
                this.add(jLabel);
                gridBagConstraints.fill = 1;
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 1;
                gridBagConstraints.gridwidth = 1;
                gridBagConstraints.gridheight = 1;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.anchor = 10;
                JScrollPane jScrollPane = new JScrollPane(jList2);
                gridBagLayout.setConstraints(jScrollPane, gridBagConstraints);
                this.add(jScrollPane);
                gridBagConstraints.fill = 0;
                gridBagConstraints.gridx = 1;
                gridBagConstraints.gridy = 1;
                gridBagConstraints.gridwidth = 1;
                gridBagConstraints.gridheight = 1;
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.weighty = 0.0;
                gridBagLayout.setConstraints(box, gridBagConstraints);
                this.add(box);
                gridBagConstraints.fill = 1;
                gridBagConstraints.gridx = 2;
                gridBagConstraints.gridy = 1;
                gridBagConstraints.gridwidth = 0;
                gridBagConstraints.gridheight = 1;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.weighty = 1.0;
                jList.setPreferredSize(jList2.getPreferredSize());
                jScrollPane = new JScrollPane(jList);
                gridBagLayout.setConstraints(jScrollPane, gridBagConstraints);
                this.add(jScrollPane);
                JPanel jPanel = new JPanel();
                jPanel.setLayout(new FlowLayout());
                this.m_clear = new JButton("Clear");
                this.m_clear.setToolTipText("Clear existing " + this.generalLabel());
                this.m_clear.addActionListener(this);
                this.m_find = new JButton("Find");
                this.m_find.setToolTipText(this.findText());
                this.m_find.addActionListener(this);
                jPanel.add(this.m_clear);
                jPanel.add(this.m_find);
                JTextField jTextField = this.multiple();
                if (jTextField != null) {
                    jTextField.setColumns(6);
                    jPanel.add(jTextField);
                    jLabel = new JLabel(" times average " + this.multipleLabel());
                    jLabel.setFont(font2);
                    jPanel.add(jLabel);
                }
                gridBagConstraints.fill = 0;
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 2;
                gridBagConstraints.gridwidth = 0;
                gridBagConstraints.gridheight = 1;
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.weighty = 0.0;
                gridBagLayout.setConstraints(jPanel, gridBagConstraints);
                this.add(jPanel);
            }

            protected boolean positiveWeights() {
                Diagram diagram = BunchClusterLayout.this.m_ls.getDiagram();
                if (diagram != null) {
                    Enumeration enumeration = diagram.enumRelationClassesInOrder();
                    while (enumeration.hasMoreElements()) {
                        RelationClass relationClass = (RelationClass)enumeration.nextElement();
                        if (relationClass.getWeight() <= 0) continue;
                        return true;
                    }
                }
                return false;
            }

            protected boolean negativeWeights() {
                Diagram diagram = BunchClusterLayout.this.m_ls.getDiagram();
                if (diagram != null) {
                    Enumeration enumeration = diagram.enumRelationClassesInOrder();
                    while (enumeration.hasMoreElements()) {
                        RelationClass relationClass = (RelationClass)enumeration.nextElement();
                        if (relationClass.getWeight() >= 0) continue;
                        return true;
                    }
                }
                return false;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = false;
                int n = this.match();
                Object object = actionEvent.getSource();
                if (object == this.m_add) {
                    int n2;
                    Object[] objectArray = this.m_rest.getSelectedValues();
                    if (objectArray != null && (n2 = objectArray.length) > 0) {
                        for (int i = 0; i < n2; ++i) {
                            EntityInstance entityInstance = (EntityInstance)objectArray[i];
                            entityInstance.orMark(n);
                        }
                        bl = true;
                    }
                } else if (object == this.m_remove) {
                    int n3;
                    Object[] objectArray = this.m_omnipresent.getSelectedValues();
                    if (objectArray != null && (n3 = objectArray.length) > 0) {
                        for (int i = 0; i < n3; ++i) {
                            EntityInstance entityInstance = (EntityInstance)objectArray[i];
                            entityInstance.nandMark(n);
                        }
                        bl = true;
                    }
                } else if (object == this.m_find || object == this.m_clear) {
                    EntityInstance entityInstance;
                    int n4;
                    ListVector listVector = BunchClusterConfigure.this.m_sorted;
                    int n5 = BunchClusterConfigure.this.m_sorted.size();
                    if (this.m_omnipresent_model.getSize() != 0) {
                        int n6 = JOptionPane.showConfirmDialog(BunchClusterLayout.this.m_ls.getFrame(), "This will clear the " + this.generalLabel() + "\n" + "you have already selected\n" + "and start again.\n" + "Are you sure?", "Cancel automatic calculation?", 2);
                        if (n6 != 0) {
                            return;
                        }
                        for (n4 = 0; n4 < n5; ++n4) {
                            entityInstance = (EntityInstance)listVector.elementAt(n4);
                            if (entityInstance.getOmnipresent() != n) continue;
                            entityInstance.nandMark(n);
                            bl = true;
                        }
                    }
                    if (object == this.m_find) {
                        for (n4 = 0; n4 < n5; ++n4) {
                            entityInstance = (EntityInstance)listVector.elementAt(n4);
                            entityInstance.orMark(0x4000000);
                        }
                        bl |= this.find();
                        for (n4 = 0; n4 < n5; ++n4) {
                            entityInstance = (EntityInstance)listVector.elementAt(n4);
                            entityInstance.nandMark(0x4000000);
                        }
                    }
                }
                if (bl) {
                    BunchClusterConfigure.this.m_sorted.stateChanged();
                }
            }
        }

        class OptionsTab
        extends Box
        implements ActionListener {
            JCheckBox m_timeout;
            JTextField m_maxruntime;

            protected JPanel newRow() {
                JPanel jPanel = new JPanel();
                jPanel.setLayout(new FlowLayout());
                return jPanel;
            }

            protected void setMaxRuntimeState() {
                this.m_maxruntime.setEnabled(this.m_timeout.isSelected());
            }

            public OptionsTab() {
                JTextField jTextField;
                super(1);
                Font font = FontCache.getDialogFont();
                Font font2 = font.deriveFont(1);
                JLabel jLabel = new JLabel("Use the following options to control Bunch's clustering engine: ");
                jLabel.setFont(font2);
                JPanel jPanel = this.newRow();
                jPanel.add(jLabel);
                this.add(jPanel);
                JLabel jLabel2 = new JLabel("Clustering Approach:");
                jLabel2.setFont(font2);
                jPanel = this.newRow();
                jPanel.add(jLabel2);
                JComboBox jComboBox = BunchClusterLayout.this.m_clustering_approach;
                jPanel.add(jComboBox);
                this.add(jPanel);
                JLabel jLabel3 = new JLabel("Clustering Algorithm:");
                jLabel3.setFont(font2);
                jPanel = this.newRow();
                jPanel.add(jLabel3);
                JComboBox jComboBox2 = BunchClusterLayout.this.m_calculator_classes;
                jPanel.add(jComboBox2);
                this.add(jPanel);
                JLabel jLabel4 = new JLabel("Output options:");
                jLabel4.setFont(font2);
                jPanel = this.newRow();
                jPanel.add(jLabel4);
                JComboBox jComboBox3 = BunchClusterLayout.this.m_output_mode;
                jPanel.add(BunchClusterLayout.this.m_output_mode);
                this.add(jPanel);
                Dimension dimension = jLabel3.getPreferredSize();
                jLabel2.setPreferredSize(dimension);
                jLabel4.setPreferredSize(dimension);
                Dimension dimension2 = jComboBox2.getPreferredSize();
                jComboBox.setPreferredSize(dimension2);
                jComboBox3.setPreferredSize(dimension2);
                jPanel = this.newRow();
                this.m_timeout = BunchClusterConfigure.this.m_checkboxes[6];
                this.m_timeout.addActionListener(this);
                jPanel.add(this.m_timeout);
                this.m_maxruntime = jTextField = BunchClusterConfigure.this.m_textfields[17];
                jTextField.setColumns(6);
                this.setMaxRuntimeState();
                jPanel.add(jTextField);
                jLabel = new JLabel("(ms)");
                jLabel.setFont(font2);
                jPanel.add(jLabel);
                this.add(jPanel);
                BunchClusterConfigure.this.pack();
                this.setVisible(true);
            }

            public void actionPerformed(ActionEvent actionEvent) {
                Object object = actionEvent.getSource();
                if (object == this.m_timeout) {
                    this.setMaxRuntimeState();
                    return;
                }
            }
        }

        class WeightsTab
        extends JPanel {
            private Box m_weights;

            public WeightsTab() {
                Box box;
                Diagram diagram = BunchClusterLayout.this.m_ls.getDiagram();
                this.setLayout(new BorderLayout());
                this.m_weights = box = new Box(1);
                if (diagram != null) {
                    Enumeration enumeration = diagram.enumRelationClassesInOrder();
                    while (enumeration.hasMoreElements()) {
                        RelationClass relationClass = (RelationClass)enumeration.nextElement();
                        box.add(new WeightedReln(relationClass));
                    }
                }
                Dimension dimension = BunchClusterConfigure.this.m_basicTab.getPreferredSize();
                JScrollPane jScrollPane = new JScrollPane(box);
                jScrollPane.setPreferredSize(dimension);
                this.add("Center", jScrollPane);
            }

            public boolean isOk() {
                Box box = this.m_weights;
                int n = box.getComponentCount();
                for (int i = 0; i < n; ++i) {
                    WeightedReln weightedReln = (WeightedReln)box.getComponent(i);
                    if (weightedReln.isOk()) continue;
                    return false;
                }
                return true;
            }

            public void setWeights() {
                Box box = this.m_weights;
                int n = box.getComponentCount();
                for (int i = 0; i < n; ++i) {
                    WeightedReln weightedReln = (WeightedReln)box.getComponent(i);
                    weightedReln.setWeight();
                }
            }

            class WeightedReln
            extends JPanel
            implements DocumentListener {
                protected JTextField m_textfield;
                protected Arrow m_arrow;
                protected JLabel m_inverted;
                protected RelationClass m_rc;

                protected void setInverted() {
                    boolean bl;
                    boolean bl2 = bl = this.m_textfield.getText().indexOf(45) >= 0;
                    if (this.m_textfield.getText().indexOf(45) >= 0) {
                        this.m_inverted.setText(" (Inverted)");
                    } else {
                        this.m_inverted.setText("");
                    }
                    this.m_arrow.setInvert(bl);
                }

                public WeightedReln(RelationClass relationClass) {
                    Arrow arrow;
                    JTextField jTextField;
                    Font font = FontCache.getDialogFont();
                    Font font2 = font.deriveFont(1);
                    FlowLayout flowLayout = new FlowLayout(0);
                    this.setLayout(flowLayout);
                    this.m_rc = relationClass;
                    int n = relationClass.getWeight();
                    this.m_textfield = jTextField = new JTextField("" + n);
                    jTextField.setFont(font);
                    jTextField.setColumns(5);
                    jTextField.getDocument().addDocumentListener(this);
                    this.add(jTextField);
                    Color color = relationClass.getInheritedObjectColor();
                    this.m_arrow = arrow = new Arrow(45, 20);
                    arrow.setBackground(color);
                    arrow.setStyle(relationClass.getInheritedStyle());
                    arrow.setToolTipText(relationClass.getDescription());
                    this.add(arrow);
                    color = relationClass.getInheritedLabelColor();
                    String string = relationClass.getLabel();
                    JLabel jLabel = new JLabel(string);
                    jLabel.setForeground(color);
                    jLabel.setFont(font);
                    this.add(jLabel);
                    this.m_inverted = new JLabel("");
                    this.m_inverted.setForeground(Color.RED);
                    this.m_inverted.setFont(font2);
                    this.setInverted();
                    this.add(this.m_inverted);
                }

                public boolean isOk() {
                    try {
                        int n = Integer.parseInt(this.m_textfield.getText());
                    }
                    catch (Exception exception) {
                        return false;
                    }
                    return true;
                }

                public void setWeight() {
                    int n;
                    try {
                        n = Integer.parseInt(this.m_textfield.getText());
                    }
                    catch (Exception exception) {
                        n = 0;
                    }
                    this.m_rc.setWeight(n);
                }

                public void changedUpdate(DocumentEvent documentEvent) {
                    this.setInverted();
                }

                public void insertUpdate(DocumentEvent documentEvent) {
                    this.setInverted();
                }

                public void removeUpdate(DocumentEvent documentEvent) {
                    this.setInverted();
                }
            }
        }

        class BasicTab
        extends JPanel
        implements ActionListener,
        DocumentListener {
            private JButton m_exportButton = new JButton("Select...");
            private JButton m_optionButton = new JButton("Options");
            private JButton m_dirButton = new JButton("Select...");
            private JButton m_importButton = new JButton("Select...");

            protected void setOptionState() {
                boolean bl = false;
                switch (BunchClusterLayout.this.m_cluster_algorithm.getSelectedIndex()) {
                    case 0: 
                    case 1: {
                        bl = true;
                    }
                }
                this.m_optionButton.setEnabled(bl);
            }

            protected void setImportFile() {
                if (!BunchClusterConfigure.this.m_checkboxes[4].isSelected()) {
                    BunchClusterConfigure.this.m_textfields[3].setText(Util.formFileName(BunchClusterConfigure.this.m_textfields[2].getText(), BunchClusterConfigure.this.m_textfields[0].getText() + ".bunch"));
                }
            }

            protected void setVanillaState() {
                boolean bl = !BunchClusterConfigure.this.m_checkboxes[4].isSelected();
                BunchClusterLayout.this.m_cluster_algorithm.setEnabled(bl);
                this.m_optionButton.setEnabled(bl);
                BunchClusterConfigure.this.m_textfields[2].setEnabled(bl);
                this.m_dirButton.setEnabled(bl);
                if (bl) {
                    this.setOptionState();
                    this.setImportFile();
                }
                BunchClusterConfigure.this.setTabStates();
            }

            public BasicTab() {
                this.setLayout(new BorderLayout());
                Font font = FontCache.getDialogFont();
                Font font2 = font.deriveFont(1);
                JPanel jPanel = new JPanel();
                GridLayout gridLayout = new GridLayout(6, 1, 0, 10);
                jPanel.setLayout(gridLayout);
                JPanel jPanel2 = new JPanel();
                gridLayout = new GridLayout(6, 1, 0, 10);
                jPanel2.setLayout(gridLayout);
                JPanel jPanel3 = new JPanel();
                gridLayout = new GridLayout(6, 1, 0, 10);
                jPanel3.setLayout(gridLayout);
                JLabel jLabel = new JLabel(m_textfield_titles[1], 4);
                jLabel.setFont(font2);
                jPanel.add(jLabel);
                jPanel2.add(BunchClusterConfigure.this.m_textfields[1]);
                JCheckBox jCheckBox = BunchClusterConfigure.this.m_checkboxes[4];
                jCheckBox.addActionListener(this);
                jPanel3.add(jCheckBox);
                jLabel = new JLabel(m_textfield_titles[0], 4);
                jLabel.setFont(font2);
                jPanel.add(jLabel);
                jPanel2.add(BunchClusterConfigure.this.m_textfields[0]);
                BunchClusterConfigure.this.m_textfields[0].getDocument().addDocumentListener(this);
                this.m_exportButton.setFont(font2);
                this.m_exportButton.addActionListener(this);
                jPanel3.add(this.m_exportButton);
                jLabel = new JLabel("Clustering method:", 4);
                jLabel.setFont(font2);
                jPanel.add(jLabel);
                BunchClusterLayout.this.m_cluster_algorithm.addActionListener(this);
                jPanel2.add(BunchClusterLayout.this.m_cluster_algorithm);
                this.m_optionButton.setFont(font2);
                this.m_optionButton.addActionListener(this);
                this.setOptionState();
                jPanel3.add(this.m_optionButton);
                jLabel = new JLabel(m_textfield_titles[2], 4);
                jLabel.setFont(font2);
                jPanel.add(jLabel);
                jPanel2.add(BunchClusterConfigure.this.m_textfields[2]);
                BunchClusterConfigure.this.m_textfields[2].getDocument().addDocumentListener(this);
                this.m_dirButton.setFont(font2);
                this.m_dirButton.addActionListener(this);
                jPanel3.add(this.m_dirButton);
                jLabel = new JLabel(m_textfield_titles[3], 4);
                jLabel.setFont(font2);
                jPanel.add(jLabel);
                jPanel2.add(BunchClusterConfigure.this.m_textfields[3]);
                this.m_importButton.setFont(font2);
                this.m_importButton.addActionListener(this);
                jPanel3.add(this.m_importButton);
                jLabel = new JLabel("Output diagnostics:", 4);
                jLabel.setFont(font2);
                jPanel.add(jLabel);
                jPanel2.add(BunchClusterLayout.this.m_debug);
                jPanel3.add(new JLabel(""));
                JPanel jPanel4 = new JPanel();
                jPanel4.setLayout(new FlowLayout(1, 15, 15));
                for (int i = 0; i <= 3; ++i) {
                    if (i == 2 && BunchClusterConfigure.this.m_selected != null) continue;
                    jPanel4.add(BunchClusterConfigure.this.m_checkboxes[i]);
                }
                this.add("West", jPanel);
                this.add("Center", jPanel2);
                this.add("East", jPanel3);
                this.add("South", jPanel4);
                this.setVanillaState();
            }

            public void actionPerformed(ActionEvent actionEvent) {
                Object object = actionEvent.getSource();
                if (object == this.m_exportButton) {
                    String string = BunchClusterLayout.this.m_ls.filePrompt("File to write to", BunchClusterConfigure.this.m_textfields[0].getText(), 2, null);
                    if (string != null) {
                        BunchClusterConfigure.this.m_textfields[0].setText(string);
                    }
                    return;
                }
                if (object == BunchClusterLayout.this.m_cluster_algorithm) {
                    this.setOptionState();
                    return;
                }
                if (object == this.m_optionButton) {
                    switch (BunchClusterLayout.this.m_cluster_algorithm.getSelectedIndex()) {
                        case 0: {
                            new HillClimbingConfiguration();
                            break;
                        }
                        case 1: {
                            new GeneticConfiguration();
                        }
                    }
                    return;
                }
                if (object == this.m_dirButton) {
                    String string = BunchClusterLayout.this.m_ls.filePrompt("Directory to read from", BunchClusterConfigure.this.m_textfields[2].getText(), 1, null);
                    if (string != null) {
                        BunchClusterConfigure.this.m_textfields[2].setText(string);
                    }
                    return;
                }
                if (object == this.m_importButton) {
                    String string = BunchClusterLayout.this.m_ls.filePrompt("File to read back from", BunchClusterConfigure.this.m_textfields[3].getText(), 2, null);
                    if (string != null) {
                        BunchClusterConfigure.this.m_textfields[3].setText(string);
                    }
                    return;
                }
                if (object == BunchClusterConfigure.this.m_checkboxes[4]) {
                    this.setVanillaState();
                    return;
                }
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                this.setImportFile();
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                this.setImportFile();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.setImportFile();
            }

            class GeneticConfiguration
            extends JDialog
            implements ActionListener {
                JTextField[] m_local_textfields;
                JLabel m_message;
                JButton m_ok;
                JButton m_cancel;

                public GeneticConfiguration() {
                    super(BunchClusterLayout.this.getLs().getFrame(), "Genetic Algorithm Configuration", true);
                    Font font = FontCache.getDialogFont();
                    Font font2 = font.deriveFont(1);
                    this.setLayout(new BorderLayout());
                    JPanel jPanel = new JPanel();
                    jPanel.setLayout(new BorderLayout());
                    JPanel jPanel2 = new JPanel();
                    GridLayout gridLayout = new GridLayout(5, 1, 0, 10);
                    jPanel2.setLayout(gridLayout);
                    JPanel jPanel3 = new JPanel();
                    gridLayout = new GridLayout(5, 1, 0, 10);
                    jPanel3.setLayout(gridLayout);
                    JLabel jLabel = new JLabel("GA Selection Method:", 2);
                    jLabel.setFont(font2);
                    jPanel2.add(jLabel);
                    jPanel3.add(BunchClusterLayout.this.m_selection_method);
                    this.m_local_textfields = new JTextField[17];
                    for (int i = 13; i <= 16; ++i) {
                        JTextField jTextField;
                        this.m_local_textfields[i] = jTextField = new JTextField(BunchClusterConfigure.this.m_textfields[i].getText(), 12);
                        jLabel = new JLabel(m_textfield_titles[i], 2);
                        jLabel.setFont(font2);
                        jPanel2.add(jLabel);
                        jTextField.setFont(font);
                        jPanel3.add(jTextField);
                    }
                    jPanel.add("West", jPanel2);
                    jPanel.add("East", jPanel3);
                    this.add("North", jPanel);
                    this.m_message = new JLabel("", 0);
                    this.m_message.setFont(font);
                    this.m_message.setForeground(Color.RED);
                    this.m_message.setSize(300, 50);
                    this.m_message.setPreferredSize(new Dimension(300, 50));
                    this.add("Center", this.m_message);
                    this.m_ok = new JButton("OK");
                    this.m_ok.addActionListener(this);
                    this.m_cancel = new JButton("Cancel");
                    this.m_cancel.addActionListener(this);
                    JPanel jPanel4 = new JPanel();
                    jPanel4.setLayout(new FlowLayout());
                    jPanel4.add(this.m_ok);
                    jPanel4.add(this.m_cancel);
                    this.add("South", jPanel4);
                    this.pack();
                    this.setVisible(true);
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    Object object = actionEvent.getSource();
                    if (object == this.m_ok) {
                        int n;
                        String string = null;
                        for (n = 13; n <= 16; ++n) {
                            String string2 = this.m_local_textfields[n].getText();
                            switch (n) {
                                case 13: {
                                    int n2;
                                    try {
                                        n2 = Integer.parseInt(string2);
                                    }
                                    catch (Exception exception) {
                                        string = "Generations not an integer";
                                    }
                                    break;
                                }
                                case 14: {
                                    int n2;
                                    try {
                                        n2 = Integer.parseInt(string2);
                                    }
                                    catch (Exception exception) {
                                        string = "Population size not an integer";
                                    }
                                    break;
                                }
                                case 15: {
                                    double d;
                                    try {
                                        d = Double.parseDouble(string2);
                                        if (!(d < 0.0) && !(d > 1.0)) break;
                                        string = "Crossover not a probability";
                                    }
                                    catch (Exception exception) {
                                        string = "Crossover probability not a double";
                                    }
                                    break;
                                }
                                case 16: {
                                    double d;
                                    try {
                                        d = Double.parseDouble(string2);
                                        if (!(d < 0.0) && !(d > 1.0)) break;
                                        string = "Mutation not a probability";
                                        break;
                                    }
                                    catch (Exception exception) {
                                        string = "Mutation probability not a double";
                                    }
                                }
                            }
                            if (string == null) continue;
                            this.m_message.setText(string);
                            return;
                        }
                        for (n = 13; n <= 16; ++n) {
                            BunchClusterConfigure.this.m_textfields[n].setText(this.m_local_textfields[n].getText());
                        }
                    } else if (object != this.m_cancel) {
                        return;
                    }
                    this.setVisible(false);
                }
            }

            class HillClimbingConfiguration
            extends JDialog
            implements ActionListener,
            ChangeListener {
                JTextField m_population_size;
                JSlider m_slider;
                JLabel m_slider_value;
                JTextField m_randomize;
                JComboBox m_techniques;
                JCheckBox m_annealing;
                JTextField m_initialTemp;
                JTextField m_alpha;
                JLabel m_message;
                JButton m_ok;
                JButton m_cancel;

                private void allowAnnealing() {
                    boolean bl = this.m_annealing.isSelected();
                    this.m_techniques.setEnabled(bl);
                    this.m_initialTemp.setEnabled(bl);
                    this.m_alpha.setEnabled(bl);
                }

                public HillClimbingConfiguration() {
                    int n;
                    super(BunchClusterLayout.this.getLs().getFrame(), "HillClimbing Configuration", true);
                    Box box = new Box(1);
                    Font font = FontCache.getDialogFont();
                    Border border = BorderFactory.createLineBorder(Color.BLACK);
                    border = BorderFactory.createTitledBorder(border, "Clustering options", 4, 2, font, Color.BLUE);
                    box.setBorder(border);
                    JPanel jPanel = new JPanel();
                    jPanel.setLayout(new FlowLayout());
                    JLabel jLabel = new JLabel("Population size: ");
                    jLabel.setFont(font);
                    jPanel.add(jLabel);
                    this.m_population_size = new JTextField(BunchClusterConfigure.this.m_textfields[8].getText());
                    this.m_population_size.setColumns(6);
                    jPanel.add(this.m_population_size);
                    box.add(jPanel);
                    jPanel = new JPanel();
                    jPanel.setLayout(new FlowLayout());
                    jLabel = new JLabel("Minimum % of Search Space to Consider:");
                    jPanel.add(jLabel);
                    box.add(jPanel);
                    jPanel = new JPanel();
                    jPanel.setLayout(new FlowLayout());
                    try {
                        n = Integer.parseInt(BunchClusterConfigure.this.m_textfields[9].getText());
                    }
                    catch (Exception exception) {
                        n = 0;
                    }
                    this.m_slider = new JSlider(0, 100, n);
                    Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>();
                    hashtable.put(new Integer(0), new JLabel("NAHC"));
                    hashtable.put(new Integer(100), new JLabel("SAHC"));
                    this.m_slider.setLabelTable(hashtable);
                    this.m_slider.setPaintLabels(true);
                    this.m_slider.addChangeListener(this);
                    jPanel.add(this.m_slider);
                    this.m_slider_value = new JLabel("" + n + "%");
                    this.m_slider_value.setForeground(Color.BLUE);
                    jPanel.add(this.m_slider_value);
                    box.add(jPanel);
                    jPanel = new JPanel();
                    jPanel.setLayout(new FlowLayout());
                    jLabel = new JLabel("Randomize %: ");
                    jPanel.add(jLabel);
                    this.m_randomize = new JTextField(BunchClusterConfigure.this.m_textfields[10].getText());
                    this.m_randomize.setColumns(6);
                    jPanel.add(this.m_randomize);
                    box.add(jPanel);
                    Box box2 = new Box(1);
                    border = BorderFactory.createLineBorder(Color.BLACK);
                    border = BorderFactory.createTitledBorder(border, "Simulated Annealing", 4, 2, font, Color.BLUE);
                    box2.setBorder(border);
                    jPanel = new JPanel();
                    jPanel.setLayout(new FlowLayout());
                    this.m_annealing = new JCheckBox(m_checkbox_titles[5], BunchClusterConfigure.this.m_checkboxes[5].isSelected());
                    this.m_annealing.addActionListener(this);
                    jPanel.add(this.m_annealing);
                    box2.add(jPanel);
                    jPanel = new JPanel();
                    jPanel.setLayout(new FlowLayout());
                    jLabel = new JLabel("Technique: ");
                    jPanel.add(jLabel);
                    this.m_techniques = new JComboBox<String>(g_techniques);
                    jPanel.add(this.m_techniques);
                    box2.add(jPanel);
                    jPanel = new JPanel();
                    jPanel.setLayout(new FlowLayout());
                    jLabel = new JLabel("P(accept)=exp(deltaMQ/T); T(k+1)=alpha*T(k)");
                    jLabel.setForeground(Color.RED);
                    jPanel.add(jLabel);
                    box2.add(jPanel);
                    jPanel = new JPanel();
                    jPanel.setLayout(new FlowLayout());
                    jLabel = new JLabel("Initial Temp. T(0): ");
                    jPanel.add(jLabel);
                    this.m_initialTemp = new JTextField(BunchClusterConfigure.this.m_textfields[11].getText());
                    jPanel.add(this.m_initialTemp);
                    jLabel = new JLabel("Alpha: ");
                    jPanel.add(jLabel);
                    this.m_alpha = new JTextField(BunchClusterConfigure.this.m_textfields[12].getText());
                    jPanel.add(this.m_alpha);
                    box2.add(jPanel);
                    this.allowAnnealing();
                    JPanel jPanel2 = new JPanel();
                    jPanel2.setLayout(new BorderLayout());
                    jPanel2.add("North", box);
                    jPanel2.add("South", box2);
                    this.setLayout(new BorderLayout());
                    this.add("North", jPanel2);
                    this.m_message = new JLabel("", 0);
                    this.m_message.setFont(font);
                    this.m_message.setForeground(Color.RED);
                    this.m_message.setSize(300, 50);
                    this.m_message.setPreferredSize(new Dimension(300, 50));
                    this.add("Center", this.m_message);
                    this.m_ok = new JButton("OK");
                    this.m_ok.addActionListener(this);
                    this.m_cancel = new JButton("Cancel");
                    this.m_cancel.addActionListener(this);
                    JPanel jPanel3 = new JPanel();
                    jPanel3.setLayout(new FlowLayout());
                    jPanel3.add(this.m_ok);
                    jPanel3.add(this.m_cancel);
                    this.add("South", jPanel3);
                    this.pack();
                    this.setVisible(true);
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    Object object = actionEvent.getSource();
                    if (object == this.m_annealing) {
                        this.allowAnnealing();
                        return;
                    }
                    if (object == this.m_ok) {
                        String string;
                        int n;
                        String string2 = null;
                        for (n = 8; n <= 12; ++n) {
                            switch (n) {
                                case 8: {
                                    string = this.m_population_size.getText();
                                    try {
                                        int n2 = Integer.parseInt(string);
                                    }
                                    catch (Exception exception) {
                                        string2 = "Population size not an integer";
                                    }
                                    break;
                                }
                                case 10: {
                                    double d;
                                    string = this.m_randomize.getText();
                                    try {
                                        d = Double.parseDouble(string);
                                    }
                                    catch (Exception exception) {
                                        string2 = "Randomize not a double";
                                    }
                                    break;
                                }
                                case 11: {
                                    double d;
                                    string = this.m_initialTemp.getText();
                                    try {
                                        d = Double.parseDouble(string);
                                    }
                                    catch (Exception exception) {
                                        string2 = "Initial temp not a double";
                                    }
                                    break;
                                }
                                case 12: {
                                    double d;
                                    string = this.m_alpha.getText();
                                    try {
                                        d = Double.parseDouble(string);
                                        break;
                                    }
                                    catch (Exception exception) {
                                        string2 = "Alpha not a double";
                                    }
                                }
                            }
                            if (string2 == null) continue;
                            this.m_message.setText(string2);
                            return;
                        }
                        for (n = 8; n <= 12; ++n) {
                            switch (n) {
                                case 8: {
                                    string = this.m_population_size.getText();
                                    break;
                                }
                                case 9: {
                                    string = "" + this.m_slider.getValue();
                                    break;
                                }
                                case 10: {
                                    string = this.m_randomize.getText();
                                    break;
                                }
                                case 11: {
                                    string = this.m_initialTemp.getText();
                                    break;
                                }
                                case 12: {
                                    string = this.m_alpha.getText();
                                    break;
                                }
                                default: {
                                    string = "";
                                }
                            }
                            BunchClusterConfigure.this.m_textfields[n].setText(string);
                        }
                        BunchClusterConfigure.this.m_checkboxes[5].setSelected(this.m_annealing.isSelected());
                    } else if (object != this.m_cancel) {
                        return;
                    }
                    this.setVisible(false);
                }

                public void stateChanged(ChangeEvent changeEvent) {
                    Object object = changeEvent.getSource();
                    if (object == this.m_slider) {
                        int n = this.m_slider.getValue();
                        this.m_slider_value.setText("" + n);
                        this.m_randomize.setText("" + (100 - n));
                        return;
                    }
                }
            }
        }
    }
}

