/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import lsedit.ColorCache;
import lsedit.Diagram;
import lsedit.EntityClass;
import lsedit.FontCache;
import lsedit.LandscapeClassObject;
import lsedit.LandscapeEditorCore;

public class ClassInherits
extends JDialog
implements ActionListener {
    private LandscapeEditorCore m_ls;
    private LandscapeClassObject m_o;
    private JCheckBox[] m_checkboxes;
    private LandscapeClassObject[] m_classes;
    private JButton m_ok;
    JButton m_cancel;
    Vector m_result;

    protected Enumeration inOrder() {
        if (this.m_o instanceof EntityClass) {
            return this.m_ls.enumEntityClassesInOrder();
        }
        return this.m_ls.enumRelationClassesInOrder();
    }

    protected LandscapeClassObject baseClass() {
        Diagram diagram = this.m_ls.getDiagram();
        if (this.m_o instanceof EntityClass) {
            return diagram.m_entityBaseClass;
        }
        return diagram.m_relationBaseClass;
    }

    protected Vector getInheritance() {
        LandscapeClassObject landscapeClassObject = this.baseClass();
        if (this.m_o == landscapeClassObject) {
            return null;
        }
        Vector<LandscapeClassObject> vector = new Vector<LandscapeClassObject>();
        LandscapeClassObject[] landscapeClassObjectArray = this.m_classes;
        JCheckBox[] jCheckBoxArray = this.m_checkboxes;
        if (jCheckBoxArray != null) {
            int n = jCheckBoxArray.length;
            for (int i = 0; i < n; ++i) {
                JCheckBox jCheckBox = jCheckBoxArray[i];
                if (!jCheckBox.isSelected()) continue;
                LandscapeClassObject landscapeClassObject2 = landscapeClassObjectArray[i];
                for (int j = 0; j < n; ++j) {
                    if (j == i || !jCheckBoxArray[j].isSelected() || !landscapeClassObjectArray[j].subclassOf(landscapeClassObject2)) continue;
                    landscapeClassObject2 = null;
                    break;
                }
                if (landscapeClassObject2 == null) continue;
                vector.add(landscapeClassObject2);
            }
        }
        if (vector.isEmpty()) {
            vector.add(landscapeClassObject);
        }
        return vector;
    }

    public ClassInherits(LandscapeEditorCore landscapeEditorCore, LandscapeClassObject landscapeClassObject) {
        super(landscapeEditorCore.getFrame(), landscapeClassObject.getLabel(), true);
        JLabel jLabel;
        LandscapeClassObject landscapeClassObject2;
        this.m_ls = landscapeEditorCore;
        this.m_o = landscapeClassObject;
        this.m_result = null;
        Font font = FontCache.getDialogFont();
        Font font2 = font.deriveFont(1);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        this.setForeground(ColorCache.get(0, 0, 0));
        this.setBackground(ColorCache.get(192, 192, 192));
        this.setFont(font);
        JPanel jPanel = new JPanel();
        GridLayout gridLayout = new GridLayout(0, 1);
        gridLayout.setVgap(10);
        jPanel.setLayout(gridLayout);
        this.m_checkboxes = null;
        this.m_classes = null;
        int n = 0;
        Enumeration enumeration = this.inOrder();
        while (enumeration.hasMoreElements()) {
            landscapeClassObject2 = (LandscapeClassObject)enumeration.nextElement();
            if (landscapeClassObject == landscapeClassObject2 || landscapeClassObject2.subclassOf(landscapeClassObject)) continue;
            ++n;
        }
        if (n > 0) {
            jLabel = new JLabel(" Inherits from: ");
            jLabel.setFont(font2);
            jPanel.add(jLabel);
            JCheckBox[] jCheckBoxArray = new JCheckBox[n];
            this.m_checkboxes = jCheckBoxArray;
            LandscapeClassObject[] landscapeClassObjectArray = new LandscapeClassObject[n];
            this.m_classes = landscapeClassObjectArray;
            int n2 = 0;
            enumeration = this.inOrder();
            while (enumeration.hasMoreElements()) {
                JCheckBox jCheckBox;
                landscapeClassObject2 = (LandscapeClassObject)enumeration.nextElement();
                if (landscapeClassObject == landscapeClassObject2 || landscapeClassObject2.subclassOf(landscapeClassObject)) continue;
                landscapeClassObjectArray[n2] = landscapeClassObject2;
                jCheckBoxArray[n2] = jCheckBox = new JCheckBox(landscapeClassObject2.getLabel());
                ++n2;
                jCheckBox.setSelected(landscapeClassObject.directlyInheritsFrom(landscapeClassObject2));
                jPanel.add(jCheckBox);
            }
        }
        boolean bl = false;
        enumeration = this.inOrder();
        while (enumeration.hasMoreElements()) {
            landscapeClassObject2 = (LandscapeClassObject)enumeration.nextElement();
            if (landscapeClassObject == landscapeClassObject2 || !landscapeClassObject2.directlyInheritsFrom(landscapeClassObject)) continue;
            if (!bl) {
                jLabel = new JLabel(" Inherited by: ");
                jLabel.setFont(font2);
                jPanel.add(jLabel);
                bl = true;
            }
            jLabel = new JLabel(" " + landscapeClassObject2.getLabel());
            jLabel.setForeground(Color.BLUE);
            jPanel.add(jLabel);
        }
        bl = false;
        enumeration = this.inOrder();
        while (enumeration.hasMoreElements()) {
            landscapeClassObject2 = (LandscapeClassObject)enumeration.nextElement();
            if (landscapeClassObject == landscapeClassObject2 || landscapeClassObject2.directlyInheritsFrom(landscapeClassObject) || !landscapeClassObject2.subclassOf(landscapeClassObject)) continue;
            if (!bl) {
                jLabel = new JLabel(" Indirectly by: ");
                jLabel.setFont(font2);
                jPanel.add(jLabel);
                bl = true;
            }
            jLabel = new JLabel(" " + landscapeClassObject2.getLabel());
            jLabel.setForeground(Color.RED);
            jPanel.add(jLabel);
        }
        container.add("Center", jPanel);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(1, 15, 15));
        this.m_ok = new JButton("Ok");
        this.m_ok.setFont(font2);
        jPanel2.add(this.m_ok);
        this.m_ok.addActionListener(this);
        this.m_cancel = new JButton("Cancel");
        this.m_cancel.setFont(font2);
        jPanel2.add(this.m_cancel);
        this.m_cancel.addActionListener(this);
        container.add("South", jPanel2);
        this.pack();
    }

    public Vector getResult() {
        return this.m_result;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.m_ok) {
            this.m_result = this.getInheritance();
        } else if (object != this.m_cancel) {
            return;
        }
        this.setVisible(false);
    }
}

