/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import lsedit.ColorCache;
import lsedit.Diagram;
import lsedit.EntityClass;
import lsedit.FontCache;
import lsedit.LandscapeEditorCore;
import lsedit.RelationClass;

public class ClosureConstraints
extends JDialog
implements ActionListener {
    private JButton m_ok = null;

    protected ClosureConstraints(JFrame jFrame, Diagram diagram, RelationClass relationClass) {
        super(jFrame, "Closure of constraints on " + relationClass.getLabel(), true);
        boolean[][] blArray = relationClass.getInheritedRelationArray();
        Font font = FontCache.getDialogFont();
        Font font2 = font.deriveFont(1);
        int n = diagram.numEntityClasses();
        EntityClass[] entityClassArray = new EntityClass[n];
        int n2 = 0;
        Enumeration enumeration = diagram.enumEntityClassesInOrder();
        while (enumeration.hasMoreElements()) {
            EntityClass entityClass;
            entityClassArray[n2] = entityClass = (EntityClass)enumeration.nextElement();
            ++n2;
        }
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        this.setForeground(ColorCache.get(0, 0, 0));
        this.setBackground(ColorCache.get(192, 192, 192));
        this.setFont(font);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(0, n + 1));
        JLabel jLabel = new JLabel("");
        jPanel.add(jLabel);
        for (n2 = 0; n2 < n; ++n2) {
            jLabel = new JLabel(entityClassArray[n2].getLabel());
            jLabel.setFont(font2);
            jPanel.add(jLabel);
        }
        for (n2 = 0; n2 < n; ++n2) {
            jLabel = new JLabel(entityClassArray[n2].getLabel() + " ");
            jLabel.setFont(font2);
            jPanel.add(jLabel);
            for (int i = 0; i < n; ++i) {
                JCheckBox jCheckBox = new JCheckBox();
                jCheckBox.setFont(font);
                jCheckBox.setToolTipText(entityClassArray[n2].getLabel() + "->" + entityClassArray[i].getLabel());
                jCheckBox.setEnabled(false);
                if (blArray[n2][i]) {
                    jCheckBox.setSelected(true);
                    jCheckBox.setForeground(Color.RED);
                }
                jPanel.add(jCheckBox);
            }
        }
        JScrollPane jScrollPane = new JScrollPane(jPanel);
        jScrollPane.setVisible(true);
        container.add((Component)jScrollPane, "Center");
        jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout());
        this.m_ok = new JButton("Ok");
        this.m_ok.setFont(font2);
        this.m_ok.addActionListener(this);
        jPanel.add(this.m_ok);
        container.add((Component)jPanel, "South");
        this.pack();
        this.setVisible(true);
    }

    public static void create(Diagram diagram, RelationClass relationClass) {
        LandscapeEditorCore landscapeEditorCore = diagram.getLs();
        ClosureConstraints closureConstraints = new ClosureConstraints(landscapeEditorCore.getFrame(), diagram, relationClass);
        closureConstraints.dispose();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object != this.m_ok) {
            return;
        }
        this.setVisible(false);
    }
}

