/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import lsedit.ColorCache;
import lsedit.Diagram;
import lsedit.EntityInstance;
import lsedit.FontCache;
import lsedit.LandscapeEditorCore;
import lsedit.LandscapeLayouter;
import lsedit.RelationClass;
import lsedit.RelationInstance;
import lsedit.Ta;
import lsedit.ToolBarEventHandler;
import lsedit.Util;
import lsedit.Version;

public class ClusterInterface
extends LandscapeLayouter
implements ToolBarEventHandler {
    protected static final int COMMAND = 0;
    protected static final int EXPORT = 1;
    protected static final int IMPORT = 2;
    protected static final String[] m_textfield_tags = new String[]{"clusterinterface:command[", "clusterinterface:export[", "clusterinterface:import["};
    protected static final String[] m_textfield_titles = new String[]{"Command to be executed:", "Exported file used by command:", "Imported file created by command:"};
    protected static final String[] m_textfield_resets = new String[]{"\"c:/Program Files/Java/jdk1.5.0_03/bin/java.exe\" -classpath . lsedit.LsClusterer", "", ""};
    protected static String[] m_textfield_defaults = new String[]{"\"c:/Program Files/Java/jdk1.5.0_03/bin/java.exe\" -classpath . lsedit.LsClusterer", "", ""};
    protected static String[] m_textfield_currents = new String[]{"\"c:/Program Files/Java/jdk1.5.0_03/bin/java.exe\" -classpath . lsedit.LsClusterer", "", ""};
    protected static final int DELETEEXPORT = 0;
    protected static final int DELETEIMPORT = 1;
    protected static final int LEAVES = 2;
    protected static final int FEEDBACK = 3;
    protected static final String[] m_checkbox_tags = new String[]{"clusterinterface:deleteExport[", "clusterinterface:deleteImport[", "clusterinterface:leaves[", "clusterinterface:feedback["};
    protected static final String[] m_checkbox_titles = new String[]{"Delete export file", "Delete import file", "Cluster leaves", "Feedback"};
    protected static final boolean[] m_checkbox_resets = new boolean[]{false, false, true, true};
    protected static boolean[] m_checkbox_defaults = new boolean[]{false, false, true, true};
    protected static boolean[] m_checkbox_currents = new boolean[]{false, false, true, true};
    protected static final int BUTTON_OK = 0;
    protected static final int BUTTON_CANCEL = 1;
    protected static final int BUTTON_HELP = 2;
    protected static final int BUTTON_UNDO = 3;
    protected static final int BUTTON_DEFAULT = 4;
    protected static final int BUTTON_SET = 5;
    protected static final int BUTTON_RESET = 6;
    protected static final String[] m_button_titles = new String[]{"Ok", "Cancel", "Help", null, "Default", "Set", "Reset"};
    protected static final String[] m_button_tips = new String[]{null, null, null, "Enable/disable undo", "Use remembered default", "Set default to current", "Set default to initial"};
    protected Diagram m_dg;
    private String m_ret;

    protected static String parameterString(int n) {
        return m_textfield_currents[n];
    }

    protected static boolean parameterBoolean(int n) {
        return m_checkbox_currents[n];
    }

    public String getTag() {
        return "clusterinterface:";
    }

    public void load(String string) {
        String string2;
        int n;
        for (n = 0; n < m_textfield_tags.length; ++n) {
            string2 = m_textfield_tags[n];
            if (!string.startsWith(string2)) continue;
            if ((string = string.substring(string2.length())).charAt(1) != ']' || string.charAt(2) != '=') {
                return;
            }
            int n2 = string.charAt(0) - 48;
            string = string.substring(3);
            switch (n2) {
                case 0: {
                    ClusterInterface.m_textfield_defaults[n] = string;
                }
                case 1: {
                    ClusterInterface.m_textfield_currents[n] = string;
                }
            }
            return;
        }
        for (n = 0; n < m_checkbox_tags.length; ++n) {
            string2 = m_checkbox_tags[n];
            if (!string.startsWith(string2)) continue;
            if ((string = string.substring(string2.length())).charAt(1) != ']' || string.charAt(2) != '=') {
                return;
            }
            int n3 = string.charAt(0) - 48;
            boolean bl = (string = string.substring(3)).charAt(0) == 't';
            switch (n3) {
                case 0: {
                    ClusterInterface.m_checkbox_defaults[n] = bl;
                }
                case 1: {
                    ClusterInterface.m_checkbox_currents[n] = bl;
                }
            }
            return;
        }
    }

    public void save(BufferedWriter bufferedWriter) throws IOException {
        String[] stringArray = m_textfield_resets;
        boolean[] blArray = m_checkbox_resets;
        String[] stringArray2 = m_textfield_defaults;
        boolean[] blArray2 = m_checkbox_defaults;
        for (int i = 0; i < 2; ++i) {
            String string;
            String string2;
            int n;
            for (n = 0; n < m_textfield_tags.length; ++n) {
                string2 = stringArray2[n];
                if (string2.equals(stringArray[n])) continue;
                string = m_textfield_tags[n];
                bufferedWriter.write(string, 0, string.length());
                bufferedWriter.write("" + i + "]=", 0, 3);
                bufferedWriter.write(string2, 0, string2.length());
                bufferedWriter.newLine();
            }
            for (n = 0; n < m_checkbox_tags.length; ++n) {
                boolean bl = blArray2[n];
                if (bl == blArray[n]) continue;
                string = m_checkbox_tags[n];
                bufferedWriter.write(string, 0, string.length());
                bufferedWriter.write("" + i + "]=", 0, 3);
                string2 = bl ? "true" : "false";
                bufferedWriter.write(string2, 0, string2.length());
                bufferedWriter.newLine();
            }
            stringArray = stringArray2;
            blArray = blArray2;
            stringArray2 = m_textfield_currents;
            blArray2 = m_checkbox_currents;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void log(String string) {
        if (ClusterInterface.parameterBoolean(3)) {
            ClusterInterface clusterInterface = this;
            synchronized (clusterInterface) {
                System.err.println(Util.toLocaleString() + ": " + string);
            }
        }
    }

    protected String message(String string) {
        this.log(string);
        JOptionPane.showMessageDialog(this.m_ls.getFrame(), string, "Error", 0);
        return string;
    }

    protected void transferNodes(EntityInstance entityInstance, EntityInstance entityInstance2) {
        EntityInstance entityInstance3 = null;
        EntityInstance entityInstance4 = null;
        Enumeration enumeration = entityInstance2.getChildren();
        while (enumeration.hasMoreElements()) {
            if (entityInstance4 == null) {
                entityInstance3 = this.m_dg.updateClusterEntity(entityInstance, entityInstance2);
            }
            entityInstance4 = (EntityInstance)enumeration.nextElement();
            this.transferNodes(entityInstance3, entityInstance4);
        }
        if (entityInstance4 == null) {
            String string = entityInstance2.getId();
            EntityInstance entityInstance5 = this.m_dg.getCache(string);
            entityInstance3 = this.m_dg.updateImportEntity(entityInstance, entityInstance2, entityInstance5);
            entityInstance3.nandMark(0x4000000);
        }
        entityInstance.nandMark(0x4000000);
    }

    boolean waitFor(Process process) {
        try {
            int n = process.waitFor();
            this.log("Process returned exit value of " + n);
        }
        catch (Exception exception) {
            this.message("WaitFor failed: " + exception);
            return false;
        }
        return true;
    }

    ClusterInterface(LandscapeEditorCore landscapeEditorCore) {
        super(landscapeEditorCore);
    }

    public String getName() {
        return "Cluster Interface";
    }

    public String getMenuLabel() {
        return "Cluster using program";
    }

    public void doit(Vector vector, Vector vector2, EntityInstance entityInstance) {
        EntityInstance entityInstance2;
        Enumeration enumeration;
        String string;
        Process process;
        String string2 = ClusterInterface.parameterString(1);
        String string3 = ClusterInterface.parameterString(0);
        String string4 = ClusterInterface.parameterString(2);
        if (string2.length() == 0 && string3.length() == 0) {
            this.m_ret = this.message("Please specify an export file to write to or command to pipe to");
            return;
        }
        WriteOutput writeOutput = new WriteOutput(vector2);
        if (string3.length() == 0) {
            writeOutput.write();
            this.m_ret = this.message("Export written to '" + string2 + "'. No command specified");
            return;
        }
        Ta ta = new Ta(this.m_ls);
        if (string4.length() == 0) {
            new Thread(writeOutput).start();
            process = writeOutput.getProcess();
            if (process == null) {
                return;
            }
            this.log("Reading subprocess output as our input");
            InputStream inputStream = writeOutput.getInputStream();
            string = ta.loadTA("", inputStream);
            if (string != null) {
                this.m_ret = this.message(string);
                return;
            }
            this.log("Import loaded");
            if (!this.waitFor(process)) {
                return;
            }
        } else {
            if (!writeOutput.write()) {
                return;
            }
            process = writeOutput.getProcess();
            if (process == null) {
                return;
            }
            if (!this.waitFor(process)) {
                return;
            }
            this.log("Importing '" + string4);
            string = ta.loadTA(string4, null);
            if (string != null) {
                this.m_ret = this.message(string);
                return;
            }
            this.log("Import loaded");
            if (ClusterInterface.parameterBoolean(1)) {
                try {
                    enumeration = new File(string4);
                    if (!((File)((Object)enumeration)).delete()) {
                        this.message("Unable to delete '" + enumeration + "'");
                    } else {
                        this.message("Deleted " + enumeration);
                    }
                }
                catch (Exception exception) {
                    this.message("Exception deleting '" + string4 + "' " + exception);
                }
            }
        }
        if (string2.length() != 0 && ClusterInterface.parameterBoolean(0)) {
            try {
                File file = new File(string2);
                if (!file.delete()) {
                    this.message("Unable to delete '" + file + "'");
                } else {
                    this.log("Deleted " + file);
                }
            }
            catch (Exception exception) {
                this.message("Exception deleting '" + string2 + "' " + exception);
            }
        }
        this.log("Reclustering");
        boolean bl = ClusterInterface.parameterBoolean(2);
        if (bl) {
            enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                entityInstance2 = (EntityInstance)enumeration.nextElement();
                entityInstance2.orMark(0x4000000);
            }
        }
        EntityInstance entityInstance3 = ta.getRootInstance();
        enumeration = entityInstance3.getChildren();
        while (enumeration.hasMoreElements()) {
            EntityInstance entityInstance4 = (EntityInstance)enumeration.nextElement();
            this.transferNodes(entityInstance, entityInstance4);
        }
        enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            entityInstance2 = (EntityInstance)enumeration.nextElement();
            entityInstance2.nandMark(0x4000000);
        }
        if (bl) {
            this.log("Removing redundant containers");
            enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                entityInstance2 = (EntityInstance)enumeration.nextElement();
                if (!entityInstance2.isMarked(0x4000000)) continue;
                this.m_dg.updateCutEntity(entityInstance2);
            }
        }
        this.m_ret = "Clustering operation complete";
    }

    public void doLayout1(Vector vector, EntityInstance entityInstance) {
    }

    public String doLayout(Diagram diagram) {
        Vector vector;
        this.m_dg = diagram;
        Vector vector2 = diagram.getGroup();
        if (vector2 == null) {
            Util.beep();
            return "No group selected";
        }
        EntityInstance entityInstance = this.parentOfSet(vector2);
        if (entityInstance == null) {
            return "Selected items do not have the same parent entity";
        }
        boolean bl = ClusterInterface.parameterBoolean(2);
        if (!bl) {
            vector = vector2;
        } else {
            vector = new Vector();
            Enumeration enumeration = vector2.elements();
            while (enumeration.hasMoreElements()) {
                EntityInstance entityInstance2 = (EntityInstance)enumeration.nextElement();
                entityInstance2.gatherLeaves(vector);
            }
        }
        this.m_ret = "Clustering attempt failed";
        this.m_ls.setCursor(3);
        diagram.beginUndoRedo("Cluster layout");
        this.doit(vector2, vector, entityInstance);
        diagram.endUndoRedo();
        this.m_ls.setCursor(0);
        diagram.redrawDiagram();
        return this.m_ret;
    }

    public boolean configure(LandscapeEditorCore landscapeEditorCore) {
        ClusterInterfaceDialog clusterInterfaceDialog = new ClusterInterfaceDialog();
        boolean bl = clusterInterfaceDialog.ok();
        clusterInterfaceDialog.dispose();
        return bl;
    }

    public boolean isConfigurable() {
        return true;
    }

    public boolean isLayouter() {
        return false;
    }

    public void processKeyEvent(int n, int n2, Object object) {
        Diagram diagram = this.m_ls.getDiagram();
        if (diagram != null) {
            String string = this.doLayout(diagram);
            this.m_ls.doFeedback(string);
            diagram.rescaleDiagram();
            this.m_ls.repaintDg();
        }
    }

    class WriteOutput
    implements Runnable {
        Process m_process = null;
        InputStream m_inputStream = null;
        boolean m_waiting = true;
        Vector m_selectedBoxes;

        WriteOutput(Vector vector) {
            this.m_selectedBoxes = vector;
        }

        public synchronized Process getProcess() {
            while (this.m_waiting) {
                try {
                    this.wait(1L);
                }
                catch (Exception exception) {
                    ClusterInterface.this.message("wait error: " + exception);
                }
            }
            return this.m_process;
        }

        public InputStream getInputStream() {
            return this.m_inputStream;
        }

        public Process startCommand(String string) {
            Object object;
            Process process = null;
            ClusterInterface.this.log("Executing [" + string + "]");
            try {
                object = Runtime.getRuntime();
                if (object == null) {
                    ClusterInterface.this.message("No runtime available");
                } else {
                    process = ((Runtime)object).exec(string);
                }
            }
            catch (Exception exception) {
                ClusterInterface.this.message("Exception executing [" + string + "] " + exception);
                process = null;
            }
            if (process != null) {
                object = new ErrOutput(process.getErrorStream());
                new Thread((Runnable)object).start();
                this.m_inputStream = process.getInputStream();
            }
            this.m_process = process;
            this.m_waiting = false;
            return process;
        }

        public boolean write() {
            PrintStream printStream;
            Object object;
            Enumeration enumeration;
            Vector vector = this.m_selectedBoxes;
            String string = ClusterInterface.parameterString(1);
            String string2 = ClusterInterface.parameterString(0);
            String string3 = ClusterInterface.parameterString(2);
            Diagram diagram = ClusterInterface.this.m_ls.getDiagram();
            Process process = null;
            File file = null;
            try {
                if (string.length() == 0) {
                    ClusterInterface.this.log("Piping output to subprocess");
                    process = this.startCommand(string2);
                    if (process == null) {
                        return false;
                    }
                    enumeration = process.getOutputStream();
                } else {
                    ClusterInterface.this.log("Exporting " + string);
                    file = new File(string);
                    enumeration = new FileOutputStream(file);
                }
                object = new BufferedOutputStream((OutputStream)((Object)enumeration));
                printStream = new PrintStream((OutputStream)object);
            }
            catch (Exception exception) {
                ClusterInterface.this.message("Exception creating output stream " + string + ": " + exception);
                return false;
            }
            boolean bl = ClusterInterface.parameterBoolean(2);
            try {
                EntityInstance entityInstance;
                RelationClass relationClass;
                RelationInstance relationInstance;
                EntityInstance entityInstance2;
                printStream.print("// Clusting TA file written by LSEdit " + Version.Number() + "\n\n");
                diagram.writeSchemeTuples(printStream);
                diagram.writeSchemeAttributes(printStream);
                printStream.print("\n\nFACT TUPLE :\n\n");
                enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    entityInstance2 = (EntityInstance)enumeration.nextElement();
                    entityInstance2.writeInstance(printStream);
                    entityInstance2.orMark(0x4000000);
                }
                enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    entityInstance2 = (EntityInstance)enumeration.nextElement();
                    if (bl) {
                        object = entityInstance2.srcRelationElements();
                        while (object.hasMoreElements()) {
                            relationInstance = (RelationInstance)object.nextElement();
                            relationClass = relationInstance.getRelationClass();
                            if (!relationClass.isClassVisible() || !(entityInstance = relationInstance.getDst()).isMarked(0x4000000)) continue;
                            relationInstance.writeRelation(printStream);
                        }
                        continue;
                    }
                    object = entityInstance2.srcLiftedRelationElements();
                    while (object.hasMoreElements()) {
                        relationInstance = (RelationInstance)object.nextElement();
                        relationClass = relationInstance.getRelationClass();
                        if (!relationClass.isClassVisible() || !(entityInstance = relationInstance.getDrawDst()).isMarked(0x4000000)) continue;
                        relationInstance.writeRelation(printStream);
                    }
                }
                printStream.print("\n\nFACT ATTRIBUTE :\n\n");
                int n = diagram.getCIndex();
                enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    entityInstance2 = (EntityInstance)enumeration.nextElement();
                    entityInstance2.writeAttribute(printStream, n);
                    if (bl) {
                        object = entityInstance2.srcRelationElements();
                        while (object.hasMoreElements()) {
                            relationInstance = (RelationInstance)object.nextElement();
                            relationClass = relationInstance.getRelationClass();
                            if (!relationClass.isClassVisible() || !(entityInstance = relationInstance.getDst()).isMarked(0x4000000)) continue;
                            relationInstance.writeAttributes(printStream);
                        }
                        continue;
                    }
                    object = entityInstance2.srcLiftedRelationElements();
                    while (object.hasMoreElements()) {
                        relationInstance = (RelationInstance)object.nextElement();
                        relationClass = relationInstance.getRelationClass();
                        if (!relationClass.isClassVisible() || !(entityInstance = relationInstance.getDrawDst()).isMarked(0x4000000)) continue;
                        relationInstance.writeAttributes(printStream);
                    }
                }
                printStream.flush();
                printStream.close();
                ClusterInterface.this.log("Export written");
            }
            catch (Exception exception) {
                ClusterInterface.this.message("Exception writing output: " + exception);
                return false;
            }
            return string.length() == 0 || string2.length() == 0 || (process = this.startCommand(string2)) != null;
        }

        public void run() {
            this.write();
        }
    }

    class ErrOutput
    implements Runnable {
        InputStream m_inputStream = null;

        ErrOutput(InputStream inputStream) {
            this.m_inputStream = inputStream;
        }

        public void run() {
            try {
                String string;
                InputStreamReader inputStreamReader = new InputStreamReader(this.m_inputStream);
                BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                while ((string = bufferedReader.readLine()) != null) {
                    ClusterInterface.this.log(string);
                }
                bufferedReader.close();
            }
            catch (Exception exception) {
                ClusterInterface.this.log("Syserr input error: " + exception);
            }
        }
    }

    class ClusterInterfaceDialog
    extends JDialog
    implements ActionListener {
        protected JTextField[] m_textfields;
        protected JCheckBox[] m_checkboxes;
        protected JButton[] m_buttons;
        protected JLabel m_message;
        protected boolean m_isok;

        public ClusterInterfaceDialog() {
            int n;
            super(ClusterInterface.this.m_ls.getFrame(), "Invoke external clustering tool", true);
            LandscapeEditorCore landscapeEditorCore = ClusterInterface.this.m_ls;
            this.m_isok = false;
            Font font = FontCache.getDialogFont();
            Font font2 = font.deriveFont(1);
            this.setForeground(ColorCache.get(0, 0, 0));
            this.setBackground(ColorCache.get(192, 192, 192));
            this.setFont(font);
            JPanel jPanel = new JPanel();
            JPanel jPanel2 = new JPanel();
            JPanel jPanel3 = new JPanel();
            jPanel.setLayout(new BorderLayout());
            GridLayout gridLayout = new GridLayout(3, 1, 0, 10);
            jPanel2.setLayout(gridLayout);
            gridLayout = new GridLayout(3, 1, 0, 10);
            jPanel3.setLayout(gridLayout);
            this.m_textfields = new JTextField[m_textfield_tags.length];
            for (n = 0; n < m_textfield_tags.length; ++n) {
                JTextField jTextField;
                this.m_textfields[n] = jTextField = new JTextField(m_textfield_currents[n], 60);
                JLabel jLabel = new JLabel(m_textfield_titles[n], 4);
                jLabel.setFont(font2);
                jPanel2.add(jLabel);
                jTextField.setFont(font);
                jPanel3.add(jTextField);
            }
            JPanel jPanel4 = new JPanel();
            jPanel4.setLayout(new FlowLayout(1, 15, 15));
            this.m_checkboxes = new JCheckBox[m_checkbox_tags.length];
            for (n = 0; n < m_checkbox_tags.length; ++n) {
                JCheckBox jCheckBox;
                this.m_checkboxes[n] = jCheckBox = new JCheckBox(m_checkbox_titles[n], m_checkbox_currents[n]);
                jCheckBox.setFont(font);
                jPanel4.add(jCheckBox);
            }
            jPanel.add("West", jPanel2);
            jPanel.add("East", jPanel3);
            jPanel.add("South", jPanel4);
            Container container = this.getContentPane();
            container.add("North", jPanel);
            this.m_message = new JLabel(" ", 0);
            String string = landscapeEditorCore.getDiagram().undoEnabled() ? "You might wish to disable undo/redo operations" : "You might wish to enable undo/redo operations";
            this.m_message.setText(string);
            this.m_message.setFont(font);
            this.m_message.setForeground(Color.RED);
            this.m_message.setSize(400, 50);
            this.m_message.setPreferredSize(new Dimension(400, 50));
            container.add("Center", this.m_message);
            JPanel jPanel5 = new JPanel();
            jPanel5.setLayout(new FlowLayout(1, 15, 15));
            this.m_buttons = new JButton[m_button_titles.length];
            for (n = 0; n < m_button_titles.length; ++n) {
                JButton jButton;
                string = m_button_titles[n];
                if (string == null) {
                    string = ClusterInterface.this.undoLabel();
                }
                this.m_buttons[n] = jButton = new JButton(string);
                jButton.setFont(font2);
                String string2 = m_button_tips[n];
                if (string2 != null) {
                    jButton.setToolTipText(string2);
                }
                jButton.addActionListener(this);
                jPanel5.add(jButton);
            }
            container.add("South", jPanel5);
            this.pack();
            this.setVisible(true);
        }

        public boolean ok() {
            return this.m_isok;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            Object object = actionEvent.getSource();
            int n2 = -1;
            for (n = 0; n < m_button_titles.length; ++n) {
                if (object != this.m_buttons[n]) continue;
                n2 = n;
                break;
            }
            switch (n2) {
                case 6: {
                    for (n = 0; n < m_textfield_tags.length; ++n) {
                        ClusterInterface.m_textfield_defaults[n] = m_textfield_resets[n];
                    }
                    for (n = 0; n < m_checkbox_tags.length; ++n) {
                        ClusterInterface.m_checkbox_defaults[n] = m_checkbox_resets[n];
                    }
                }
                case 4: {
                    for (n = 0; n < m_textfield_tags.length; ++n) {
                        this.m_textfields[n].setText(m_textfield_defaults[n]);
                    }
                    for (n = 0; n < m_checkbox_tags.length; ++n) {
                        this.m_checkboxes[n].setSelected(m_checkbox_defaults[n]);
                    }
                    return;
                }
                case 5: {
                    for (n = 0; n < m_textfield_tags.length; ++n) {
                        ClusterInterface.m_textfield_defaults[n] = this.m_textfields[n].getText();
                    }
                    for (n = 0; n < m_checkbox_tags.length; ++n) {
                        ClusterInterface.m_checkbox_defaults[n] = this.m_checkboxes[n].isSelected();
                    }
                    return;
                }
                case 3: {
                    LandscapeEditorCore landscapeEditorCore = ClusterInterface.this.m_ls;
                    landscapeEditorCore.invertUndo();
                    this.m_buttons[n2].setText(ClusterInterface.this.undoLabel());
                    this.m_message.setText("");
                    return;
                }
                case 2: {
                    JOptionPane.showMessageDialog(ClusterInterface.this.m_ls.getFrame(), "To merely export a file for later clustering provide an export filename.\nTo run an external clusterer provide the command that invokes that external tool.\nIf no export file specifying what is to be clustered is provided, this\ninformation will be piped directly to the specified commands standard input.\nThe provided command is expected to write instructions as to how clustering is to\nbe performed to the specified import file.  If no such file is specified it will\nbe presumed that this input is to be read directly from the provided commands\nstandard output stream.  Temporary files that are created may optionally be deleted\nwhen the clustering interface has no further use for them.\n\nThe export file contains TA specifying the nodes to be clustered and the edges\nbetween them considered relevant when performing that clustering.  The import file\nshould contain suitably structured TA showing how these exported nodes are to be\nclustered.  New containment hierarchies in the imported data will be constructed\nand the relevant nodes contained within such imported hierarchies moved into these\nhierarchies.  If sizing and positioning information is provided in the imported data\nthis information will be mirrored in the resulting internal TA.", "Help", 0);
                    return;
                }
                case 0: {
                    for (n = 0; n < m_textfield_tags.length; ++n) {
                        ClusterInterface.m_textfield_currents[n] = this.m_textfields[n].getText();
                    }
                    for (n = 0; n < m_checkbox_tags.length; ++n) {
                        ClusterInterface.m_checkbox_currents[n] = this.m_checkboxes[n].isSelected();
                    }
                    this.m_isok = true;
                }
                case 1: {
                    break;
                }
                default: {
                    return;
                }
            }
            this.setVisible(false);
        }
    }
}

