/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import lsedit.ClusterNode;
import lsedit.ColorCache;
import lsedit.Diagram;
import lsedit.Distance;
import lsedit.EntityInstance;
import lsedit.FontCache;
import lsedit.LandscapeEditorCore;
import lsedit.LandscapeLayouter;
import lsedit.RelationClass;
import lsedit.RelationInstance;
import lsedit.SortVector;
import lsedit.SpringLayout2;
import lsedit.SpringNode;
import lsedit.ToolBarEventHandler;
import lsedit.Util;

public class ClusterLayout
extends LandscapeLayouter
implements ToolBarEventHandler {
    protected static final int STIFFNESS = 0;
    protected static final int REPULSION = 1;
    protected static final int GAP = 2;
    protected static final int BORDER = 3;
    protected static final int ITERATIONS = 4;
    protected static final int TIMEOUT = 5;
    protected static final int FORM_CLUSTERS = 6;
    protected static final int SEPARATION_FACTOR = 7;
    protected static final String[] m_textfield_tags = new String[]{"clusterlayout:stiffness[", "clusterlayout:repulsion[", "clusterlayout:gap[", "clusterlayout:border[", "clusterlayout:iterations[", "clusterlayout:timeout[", "clusterlayout:clusters[", "clusterlayout:separation["};
    protected static final String[] m_textfield_titles = new String[]{"Edge stiffness", "Collision repulsion", "Ideal gap", "Border", "Iterations", "Timeout", "Number of clusters", "Separation factor"};
    protected static final String[] m_textfield_resets = new String[]{"0.05", "0.025", "0.01", "0.01", "1000", "300", "0", "2.5"};
    protected static String[] m_textfield_defaults = new String[]{"0.05", "0.025", "0.01", "0.01", "1000", "300", "0", "2.5"};
    protected static String[] m_textfield_currents = new String[]{"0.05", "0.025", "0.01", "0.01", "1000", "300", "0", "2.5"};
    protected double m_stiffness = 0.05;
    protected double m_repulsion = 0.025;
    protected double m_gap = 0.01;
    protected double m_border = 0.01;
    protected int m_iterations = 1000;
    protected int m_timeout = 300;
    protected int m_form_clusters = 0;
    protected double m_separation_factor = 2.5;
    protected static final int LEAVES = 0;
    protected static final int MUSTBE_RELATED = 1;
    protected static final int FEEDBACK = 2;
    protected static final String[] m_checkbox_tags = new String[]{"clusterlayout:leaves[", "clusterlayout:related[", "clusterlayout:feedback["};
    protected static final String[] m_checkbox_titles = new String[]{"Cluster leaves", "Must be related", "Provide feedback"};
    protected static final boolean[] m_checkbox_resets = new boolean[]{true, true, true};
    protected static boolean[] m_checkbox_defaults = new boolean[]{true, true, true};
    protected static boolean[] m_checkbox_currents = new boolean[]{true, true, true};
    protected static final int BUTTON_OK = 0;
    protected static final int BUTTON_CANCEL = 1;
    protected static final int BUTTON_HELP = 2;
    protected static final int BUTTON_UNDO = 3;
    protected static final int BUTTON_DEFAULT = 4;
    protected static final int BUTTON_SET = 5;
    protected static final int BUTTON_RESET = 6;
    protected static final String[] m_button_titles = new String[]{"Ok", "Cancel", "Help", null, "Default", "Set", "Reset"};
    protected static final String[] m_button_tips = new String[]{null, null, null, "Enable/disable undo", "Use remembered default", "Set default to current", "Set default to initial"};

    protected static boolean parameterBoolean(int n) {
        return m_checkbox_currents[n];
    }

    public String getTag() {
        return "clusterlayout:";
    }

    protected void setParameter(int n, String string) {
        string = string.trim();
        try {
            switch (n) {
                case 4: 
                case 5: 
                case 6: {
                    int n2 = Integer.parseInt(string);
                    switch (n) {
                        case 4: {
                            this.m_iterations = n2;
                            break;
                        }
                        case 5: {
                            this.m_timeout = n2;
                            break;
                        }
                        case 6: {
                            this.m_form_clusters = n2;
                        }
                    }
                    break;
                }
                default: {
                    double d = Double.parseDouble(string);
                    switch (n) {
                        case 0: {
                            this.m_stiffness = d;
                            break;
                        }
                        case 1: {
                            this.m_repulsion = d;
                            break;
                        }
                        case 2: {
                            this.m_gap = d;
                            break;
                        }
                        case 3: {
                            this.m_border = d;
                            break;
                        }
                        case 7: {
                            this.m_separation_factor = d;
                        }
                    }
                }
            }
            ClusterLayout.m_textfield_currents[n] = string;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void load(String string) {
        String string2;
        int n;
        for (n = 0; n < m_textfield_tags.length; ++n) {
            string2 = m_textfield_tags[n];
            if (!string.startsWith(string2)) continue;
            if ((string = string.substring(string2.length())).charAt(1) != ']' || string.charAt(2) != '=') {
                return;
            }
            int n2 = string.charAt(0) - 48;
            string = string.substring(3);
            switch (n2) {
                case 0: {
                    ClusterLayout.m_textfield_defaults[n] = string;
                }
                case 1: {
                    this.setParameter(n, string);
                }
            }
            return;
        }
        for (n = 0; n < m_checkbox_tags.length; ++n) {
            string2 = m_checkbox_tags[n];
            if (!string.startsWith(string2)) continue;
            if ((string = string.substring(string2.length())).charAt(1) != ']' || string.charAt(2) != '=') {
                return;
            }
            int n3 = string.charAt(0) - 48;
            boolean bl = (string = string.substring(3)).charAt(0) == 't';
            switch (n3) {
                case 0: {
                    ClusterLayout.m_checkbox_defaults[n] = bl;
                }
                case 1: {
                    ClusterLayout.m_checkbox_currents[n] = bl;
                }
            }
            return;
        }
    }

    public void save(BufferedWriter bufferedWriter) throws IOException {
        String[] stringArray = m_textfield_resets;
        boolean[] blArray = m_checkbox_resets;
        String[] stringArray2 = m_textfield_defaults;
        boolean[] blArray2 = m_checkbox_defaults;
        for (int i = 0; i < 2; ++i) {
            String string;
            String string2;
            int n;
            for (n = 0; n < m_textfield_tags.length; ++n) {
                string2 = stringArray2[n];
                if (string2.equals(stringArray[n])) continue;
                string = m_textfield_tags[n];
                bufferedWriter.write(string, 0, string.length());
                bufferedWriter.write("" + i + "]=", 0, 3);
                bufferedWriter.write(string2, 0, string2.length());
                bufferedWriter.newLine();
            }
            for (n = 0; n < m_checkbox_tags.length; ++n) {
                boolean bl = blArray2[n];
                if (bl == blArray[n]) continue;
                string = m_checkbox_tags[n];
                bufferedWriter.write(string, 0, string.length());
                bufferedWriter.write("" + i + "]=", 0, 3);
                string2 = bl ? "true" : "false";
                bufferedWriter.write(string2, 0, string2.length());
                bufferedWriter.newLine();
            }
            stringArray = stringArray2;
            blArray = blArray2;
            stringArray2 = m_textfield_currents;
            blArray2 = m_checkbox_currents;
        }
    }

    protected void log(String string) {
        if (ClusterLayout.parameterBoolean(2)) {
            System.out.println(Util.toLocaleString() + ": " + string);
        }
    }

    public ClusterLayout(LandscapeEditorCore landscapeEditorCore) {
        super(landscapeEditorCore);
    }

    public String getName() {
        return "Cluster";
    }

    public String getMenuLabel() {
        return "Cluster";
    }

    public boolean isConfigurable() {
        return true;
    }

    public boolean isLayouter() {
        return false;
    }

    public boolean configure(LandscapeEditorCore landscapeEditorCore) {
        ClusterConfigure clusterConfigure = new ClusterConfigure();
        boolean bl = clusterConfigure.ok();
        clusterConfigure.dispose();
        return bl;
    }

    public void doLayout1(Vector vector, EntityInstance entityInstance) {
        SpringNode springNode;
        double d;
        double d2;
        int n;
        EntityInstance entityInstance2;
        RelationClass relationClass;
        RelationInstance relationInstance;
        SpringNode springNode2;
        EntityInstance entityInstance3;
        Enumeration enumeration;
        Vector vector2;
        boolean bl = ClusterLayout.parameterBoolean(0);
        boolean bl2 = ClusterLayout.parameterBoolean(1);
        if (!bl) {
            vector2 = vector;
        } else {
            vector2 = new Vector();
            enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                entityInstance3 = (EntityInstance)enumeration.nextElement();
                entityInstance3.gatherLeaves(vector2);
            }
        }
        int n2 = vector2.size();
        if (n2 < 3) {
            return;
        }
        this.log("Clustering " + n2 + " items");
        SpringNode[] springNodeArray = new ClusterNode[n2];
        boolean[][] blArrayArray = new boolean[n2][];
        int n3 = 0;
        while (n3 < n2) {
            springNodeArray[n3] = springNode2 = new ClusterNode();
            blArrayArray[n3] = new boolean[n2 - n3];
            springNode2.m_e = entityInstance3 = (EntityInstance)vector2.elementAt(n3);
            springNode2.m_clients = 0;
            springNode2.m_suppliers = 0;
            springNode2.m_cluster = n3++;
            springNode2.m_next = null;
            entityInstance3.orMark(0x4000000);
        }
        if (bl) {
            for (n3 = 0; n3 < n2; ++n3) {
                springNode2 = springNodeArray[n3];
                entityInstance3 = springNode2.m_e;
                enumeration = entityInstance3.srcRelationElements();
                block3: while (enumeration.hasMoreElements()) {
                    relationInstance = (RelationInstance)enumeration.nextElement();
                    relationClass = relationInstance.getRelationClass();
                    if (!relationClass.isClassVisible() || !(entityInstance2 = relationInstance.getDst()).isMarked(0x4000000)) continue;
                    for (n = n3 + 1; n < n2; ++n) {
                        if (entityInstance2 != springNodeArray[n].m_e) continue;
                        blArrayArray[n3][n - n3] = true;
                        continue block3;
                    }
                }
                enumeration = entityInstance3.dstRelationElements();
                block5: while (enumeration.hasMoreElements()) {
                    relationInstance = (RelationInstance)enumeration.nextElement();
                    relationClass = relationInstance.getRelationClass();
                    if (!relationClass.isClassVisible() || !(entityInstance2 = relationInstance.getSrc()).isMarked(0x4000000)) continue;
                    for (n = n3 + 1; n < n2; ++n) {
                        if (entityInstance2 != springNodeArray[n].m_e) continue;
                        blArrayArray[n3][n - n3] = true;
                        continue block5;
                    }
                }
            }
        } else {
            for (n3 = 0; n3 < n2; ++n3) {
                springNode2 = springNodeArray[n3];
                entityInstance3 = springNode2.m_e;
                enumeration = entityInstance3.srcLiftedRelationElements();
                block8: while (enumeration.hasMoreElements()) {
                    relationInstance = (RelationInstance)enumeration.nextElement();
                    relationClass = relationInstance.getRelationClass();
                    if (!relationClass.isClassVisible() || !(entityInstance2 = relationInstance.getDrawDst()).isMarked(0x4000000)) continue;
                    for (n = n3 + 1; n < n2; ++n) {
                        if (entityInstance2 != springNodeArray[n].m_e) continue;
                        blArrayArray[n3][n - n3] = true;
                        continue block8;
                    }
                }
                enumeration = entityInstance3.dstLiftedRelationElements();
                block10: while (enumeration.hasMoreElements()) {
                    relationInstance = (RelationInstance)enumeration.nextElement();
                    relationClass = relationInstance.getRelationClass();
                    if (!relationClass.isClassVisible() || !(entityInstance2 = relationInstance.getDrawSrc()).isMarked(0x4000000)) continue;
                    for (n = n3 + 1; n < n2; ++n) {
                        if (entityInstance2 != springNodeArray[n].m_e) continue;
                        blArrayArray[n3][n - n3] = true;
                        continue block10;
                    }
                }
            }
        }
        this.log("Iterating over these " + n2 + " items");
        double d3 = this.m_stiffness;
        double d4 = this.m_repulsion;
        double d5 = this.m_gap;
        double d6 = this.m_border;
        double d7 = this.m_separation_factor;
        int n4 = this.m_iterations;
        int n5 = this.m_timeout;
        int n6 = this.m_form_clusters;
        SpringLayout2.place(springNodeArray, blArrayArray, n4, d5, d6, d3, d4, 0.0, 0.0, n5);
        this.log("Build graph for " + n2 + " items");
        Diagram diagram = this.m_ls.getDiagram();
        int n7 = n2;
        if (n6 != 1 && n6 < n7) {
            double d8;
            SpringNode springNode3;
            Vector<Distance> vector3 = new Vector<Distance>();
            for (n3 = 0; n3 < n2; ++n3) {
                springNode2 = springNodeArray[n3];
                d2 = springNode2.m_x;
                d = springNode2.m_y;
                for (n = n3 + 1; n < n2; ++n) {
                    if (bl2 && !blArrayArray[n3][n - n3]) continue;
                    springNode3 = springNodeArray[n];
                    double d9 = ((ClusterNode)springNode3).m_x - d2;
                    double d10 = ((ClusterNode)springNode3).m_y - d;
                    d8 = Math.sqrt(d9 * d9 + d10 * d10);
                    vector3.add(new Distance(d8, n3, n));
                }
            }
            int n8 = vector3.size();
            this.log("Sorting " + n8 + " of distances");
            SortVector.byDistance(vector3);
            double d11 = -1.0;
            for (n3 = 0; n3 < n8; ++n3) {
                Distance distance = (Distance)vector3.elementAt(n3);
                d8 = distance.m_length;
                if (d8 > d11 * d7 && n6 == 0 && d11 >= 0.0) break;
                d11 = d8;
                springNode2 = springNodeArray[distance.m_i];
                springNode3 = springNodeArray[distance.m_j];
                if (springNode2.m_cluster == ((ClusterNode)springNode3).m_cluster) continue;
                n = springNode2.m_cluster;
                springNode2 = springNodeArray[n];
                springNode = springNode3 = springNodeArray[((ClusterNode)springNode3).m_cluster];
                while (((ClusterNode)springNode).m_next != null) {
                    ((ClusterNode)springNode).m_cluster = n;
                    springNode = ((ClusterNode)springNode).m_next;
                }
                ((ClusterNode)springNode).m_cluster = n;
                ((ClusterNode)springNode).m_next = springNode2.m_next;
                springNode2.m_next = springNode3;
                if (--n7 <= n6 || n7 < 3) break;
            }
        }
        int n9 = n2 - 1;
        SpringNode springNode4 = null;
        if (n7 > n6) {
            this.log("Identifying utilities");
            n9 = -1;
            n7 = 0;
            for (n3 = 0; n3 < n2; ++n3) {
                springNode2 = springNodeArray[n3];
                if (springNode2.m_cluster != n3) continue;
                if (springNode2.m_next == null) {
                    if (springNode4 != null) {
                        springNode2.m_cluster = springNode4.m_cluster;
                        springNode2.m_next = springNode4.m_next;
                        springNode4.m_next = springNode2;
                        continue;
                    }
                    springNode4 = springNode2;
                }
                ++n7;
                n9 = n3;
            }
        }
        this.log("Reorganising " + n2 + " items into " + n7 + " selected clusters");
        n7 = 0;
        entityInstance2 = null;
        for (n3 = 0; n3 <= n9; ++n3) {
            springNode2 = springNodeArray[n3];
            if (springNode2.m_cluster != n3) continue;
            entityInstance2 = diagram.updateNewEntity(null, entityInstance, null, false);
            String string = "Cluster" + ++n7;
            if (springNode2 == springNode4) {
                string = n6 == 1 ? string + " (Layout)" : string + " (Utilities)";
            }
            entityInstance2.setLabel(string);
            int n10 = 1;
            entityInstance3 = springNode2.m_e;
            d2 = springNode2.m_x;
            d = springNode2.m_y;
            double d12 = entityInstance3.widthRelLocal() / 2.0;
            double d13 = entityInstance3.heightRelLocal() / 2.0;
            double d14 = d2 - d12;
            double d15 = d2 + d12;
            double d16 = d - d13;
            double d17 = d + d13;
            springNode = springNode2.m_next;
            while (springNode != null) {
                double d18;
                entityInstance3 = ((ClusterNode)springNode).m_e;
                d2 = ((ClusterNode)springNode).m_x;
                d = ((ClusterNode)springNode).m_y;
                d12 = entityInstance3.widthRelLocal() / 2.0;
                d13 = entityInstance3.heightRelLocal() / 2.0;
                double d19 = d2 - d12;
                if (d19 < d14) {
                    d14 = d19;
                }
                if ((d19 = d2 + d12) > d15) {
                    d15 = d19;
                }
                if ((d18 = d - d13) < d16) {
                    d16 = d18;
                }
                if ((d18 = d + d13) > d17) {
                    d17 = d18;
                }
                ++n10;
                springNode = ((ClusterNode)springNode).m_next;
            }
            entityInstance2.setDescription("Cluster of " + n10 + " items");
            double d20 = (1.0 - 2.0 * d6) / (d15 - d14);
            double d21 = d6 - d20 * d14;
            double d22 = (1.0 - 2.0 * d6) / (d17 - d16);
            double d23 = d6 - d22 * d16;
            springNode = springNode2;
            while (springNode != null) {
                entityInstance3 = ((ClusterNode)springNode).m_e;
                d2 = ((ClusterNode)springNode).m_x * d20 + d21;
                d = ((ClusterNode)springNode).m_y * d22 + d23;
                d12 = entityInstance3.widthRelLocal();
                d13 = entityInstance3.heightRelLocal();
                entityInstance3.updateRelLocal(d2 - d12 / 2.0, d - d13 / 2.0, d12, d13);
                EntityInstance entityInstance4 = entityInstance3.getContainedBy();
                diagram.updateMoveEntityContainment(entityInstance2, entityInstance3);
                if (bl) {
                    while (true) {
                        entityInstance3 = entityInstance4;
                        entityInstance4 = entityInstance3.getContainedBy();
                        if (entityInstance3.getFirstChild() != null) break;
                        diagram.updateCutEntity(entityInstance3);
                    }
                }
                springNode = ((ClusterNode)springNode).m_next;
            }
        }
        for (n3 = 0; n3 < n2; ++n3) {
            springNode2 = springNodeArray[n3];
            entityInstance3 = springNode2.m_e;
            entityInstance3.nandMark(0x4000000);
        }
        if (n7 == 1 && entityInstance2 != null) {
            diagram.navigateTo(entityInstance2);
        } else {
            diagram.redrawDiagram();
        }
        this.log("Finished forming " + n7 + " clusters");
    }

    public String doLayout(Diagram diagram) {
        Vector vector = diagram.getGroup();
        if (vector == null) {
            Util.beep();
            return "No group selected";
        }
        String string = this.allInDiagram(vector);
        if (string != null) {
            return string;
        }
        EntityInstance entityInstance = this.parentOfSet(vector);
        if (entityInstance == null) {
            return "Cluster layout requires that all things laid out share same parent";
        }
        this.m_ls.setCursor(3);
        diagram.beginUndoRedo("Cluster layout");
        this.doLayout1(vector, entityInstance);
        diagram.endUndoRedo();
        this.m_ls.setCursor(0);
        return "Graph redrawn using Cluster Layout";
    }

    public void processKeyEvent(int n, int n2, Object object) {
        Diagram diagram = this.m_ls.getDiagram();
        if (diagram != null) {
            String string = this.doLayout(diagram);
            this.m_ls.doFeedback(string);
            diagram.rescaleDiagram();
            this.m_ls.repaintDg();
        }
    }

    class ClusterConfigure
    extends JDialog
    implements ActionListener {
        protected JTextField[] m_textfields;
        protected JCheckBox[] m_checkboxes;
        protected JButton[] m_buttons;
        protected JLabel m_message;
        protected boolean m_ret;

        public ClusterConfigure() {
            JLabel jLabel;
            int n;
            super(ClusterLayout.this.getLs().getFrame(), "Cluster Configuration", true);
            this.m_ret = false;
            Font font = FontCache.getDialogFont();
            Font font2 = font.deriveFont(1);
            this.setForeground(ColorCache.get(0, 0, 0));
            this.setBackground(ColorCache.get(192, 192, 192));
            this.setFont(font);
            JPanel jPanel = new JPanel();
            JPanel jPanel2 = new JPanel();
            JPanel jPanel3 = new JPanel();
            JPanel jPanel4 = new JPanel();
            JPanel jPanel5 = new JPanel();
            jPanel.setLayout(new BorderLayout());
            GridLayout gridLayout = new GridLayout(8, 1, 0, 10);
            jPanel2.setLayout(gridLayout);
            gridLayout = new GridLayout(8, 1, 0, 10);
            jPanel3.setLayout(gridLayout);
            gridLayout = new GridLayout(8, 1, 0, 10);
            jPanel4.setLayout(gridLayout);
            gridLayout = new GridLayout(8, 1, 0, 10);
            jPanel5.setLayout(gridLayout);
            JPanel jPanel6 = jPanel2;
            JPanel jPanel7 = jPanel3;
            this.m_textfields = new JTextField[m_textfield_tags.length];
            for (n = 0; n < m_textfield_tags.length; ++n) {
                JTextField jTextField;
                if (n == 6) {
                    jPanel6 = jPanel4;
                    jPanel7 = jPanel5;
                }
                this.m_textfields[n] = jTextField = new JTextField(m_textfield_currents[n], 20);
                jLabel = new JLabel(m_textfield_titles[n], 4);
                jLabel.setFont(font2);
                jPanel6.add(jLabel);
                jTextField.setFont(font);
                jTextField.addActionListener(this);
                jPanel7.add(jTextField);
            }
            this.m_checkboxes = new JCheckBox[m_checkbox_tags.length];
            for (n = 0; n < m_checkbox_tags.length; ++n) {
                JCheckBox jCheckBox;
                this.m_checkboxes[n] = jCheckBox = new JCheckBox("", m_checkbox_currents[n]);
                jLabel = new JLabel(m_checkbox_titles[n], 4);
                jLabel.setFont(font2);
                jPanel6.add(jLabel);
                jCheckBox.setFont(font);
                jPanel7.add(jCheckBox);
            }
            JPanel jPanel8 = new JPanel();
            jPanel8.setLayout(new BorderLayout());
            jPanel8.add("West", jPanel2);
            jPanel8.add("East", jPanel3);
            JPanel jPanel9 = new JPanel();
            jPanel9.setLayout(new BorderLayout());
            jPanel9.add("West", jPanel4);
            jPanel9.add("East", jPanel5);
            jPanel.add("West", jPanel8);
            jPanel.add("East", jPanel9);
            Container container = this.getContentPane();
            container.add("North", jPanel);
            String string = ClusterLayout.this.m_ls.getDiagram().undoEnabled() ? "You might wish to disable undo/redo operations" : "You might wish to enable undo/redo operations";
            this.m_message = new JLabel(string, 0);
            this.m_message.setFont(font);
            this.m_message.setForeground(Color.RED);
            this.m_message.setSize(400, 50);
            this.m_message.setPreferredSize(new Dimension(400, 50));
            container.add("Center", this.m_message);
            JPanel jPanel10 = new JPanel();
            jPanel10.setLayout(new FlowLayout(1, 15, 15));
            this.m_buttons = new JButton[m_button_titles.length];
            for (n = 0; n < m_button_titles.length; ++n) {
                JButton jButton;
                string = m_button_titles[n];
                if (string == null) {
                    string = ClusterLayout.this.undoLabel();
                }
                this.m_buttons[n] = jButton = new JButton(string);
                jButton.setFont(font2);
                String string2 = m_button_tips[n];
                if (string2 != null) {
                    jButton.setToolTipText(string2);
                }
                jButton.addActionListener(this);
                jPanel10.add(jButton);
            }
            container.add("South", jPanel10);
            this.pack();
            this.setVisible(true);
        }

        public boolean ok() {
            return this.m_ret;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            Object object = actionEvent.getSource();
            int n2 = -1;
            for (n = 0; n < m_button_titles.length; ++n) {
                if (object != this.m_buttons[n]) continue;
                n2 = n;
                break;
            }
            switch (n2) {
                case 6: {
                    for (n = 0; n < m_textfield_tags.length; ++n) {
                        ClusterLayout.m_textfield_defaults[n] = m_textfield_resets[n];
                    }
                    for (n = 0; n < m_checkbox_tags.length; ++n) {
                        ClusterLayout.m_checkbox_defaults[n] = m_checkbox_resets[n];
                    }
                }
                case 4: {
                    for (n = 0; n < m_textfield_tags.length; ++n) {
                        this.m_textfields[n].setText(m_textfield_defaults[n]);
                    }
                    for (n = 0; n < m_checkbox_tags.length; ++n) {
                        this.m_checkboxes[n].setSelected(m_checkbox_defaults[n]);
                    }
                    return;
                }
                case 5: {
                    for (n = 0; n < m_textfield_tags.length; ++n) {
                        ClusterLayout.m_textfield_defaults[n] = this.m_textfields[n].getText();
                    }
                    for (n = 0; n < m_checkbox_tags.length; ++n) {
                        ClusterLayout.m_checkbox_defaults[n] = this.m_checkboxes[n].isSelected();
                    }
                    return;
                }
                case 3: {
                    LandscapeEditorCore landscapeEditorCore = ClusterLayout.this.m_ls;
                    landscapeEditorCore.invertUndo();
                    this.m_buttons[n2].setText(ClusterLayout.this.undoLabel());
                    this.m_message.setText("");
                    return;
                }
                case 2: {
                    JOptionPane.showMessageDialog(ClusterLayout.this.m_ls.getFrame(), "Stiffness\n  The stiffness of edges connecting related nodes\n  A larger value increases the force between related nodes\nRepulsive force\n  The repulsive force between overlapping nodes\n  A larger value thrusts overlapping nodes further apart\n  0     => disable collision detection\nIdeal gap\n  Fractional space between entities\nBorder\n  Fractional space to leave for border of diagram\nIterations\n  Number of times to iterate over the algorithm\nTimeout\n  Maximum number of seconds to spend iterating\n\nNumber of clusters\n Number of clusters to form. Use 0 to have the layouter use the\n separation factor to decide when to terminate clustering.\n Set to 1 to view the graph used to cluster\nSeparation factor\n Clustering stops when the minimum distance between nodes left\n to be clustered, is more than the prior minimum distance * factor.\nCluster leaves\n Cluster the leaves of the tree discarding all existing containers\nMustbe related\n If true items added to a cluster must have an edge to something in\n that cluster.  Otherwise clustering is purely spacial", "Help", 0);
                    return;
                }
            }
            block31: for (n = 0; n < m_textfield_tags.length; ++n) {
                JTextField jTextField = this.m_textfields[n];
                if (object != jTextField && n2 != 0) continue;
                String string = jTextField.getText();
                string = string.trim();
                String string2 = m_textfield_titles[n];
                switch (n) {
                    case 4: 
                    case 5: {
                        try {
                            int n3 = Integer.parseInt(string);
                            if (n3 > 0) continue block31;
                            this.m_message.setText(string2 + " must be positive");
                            return;
                        }
                        catch (Throwable throwable) {
                            this.m_message.setText(string2 + " not an integer value");
                            return;
                        }
                    }
                    case 6: {
                        try {
                            int n4 = Integer.parseInt(string);
                            if (n4 >= 0) continue block31;
                            this.m_message.setText(string2 + " may not be negative");
                            return;
                        }
                        catch (Throwable throwable) {
                            this.m_message.setText(string2 + " not an integer value");
                            return;
                        }
                    }
                    default: {
                        try {
                            double d = Double.parseDouble(string);
                            switch (n) {
                                case 2: 
                                case 3: {
                                    if (!(d < 0.0) && !(d >= 1.0)) break;
                                    this.m_message.setText(string2 + " must be in the range 0 to 1.0");
                                    return;
                                }
                            }
                            continue block31;
                        }
                        catch (Throwable throwable) {
                            this.m_message.setText(string2 + " not a double precision value");
                            return;
                        }
                    }
                }
            }
            switch (n2) {
                case 0: {
                    for (n = 0; n < m_textfield_tags.length; ++n) {
                        ClusterLayout.this.setParameter(n, this.m_textfields[n].getText());
                    }
                    for (n = 0; n < m_checkbox_tags.length; ++n) {
                        ClusterLayout.m_checkbox_currents[n] = this.m_checkboxes[n].isSelected();
                    }
                    this.m_ret = true;
                }
                case 1: {
                    break;
                }
                default: {
                    return;
                }
            }
            this.setVisible(false);
        }
    }
}

