/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.Color;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSlider;
import lsedit.ColorCache;
import lsedit.FontCache;

public class ColorChooser
extends JDialog
implements ActionListener {
    private static JColorChooser m_tcc = null;
    private JSlider m_slider;
    private JButton m_okButton;
    private JButton m_canButton;
    private JButton m_nullButton;
    private JButton m_clearButton;
    private Color m_color;
    int alpha;

    public ColorChooser(JFrame jFrame, String string, Color color, boolean bl, boolean bl2) {
        super(jFrame, string, true);
        Font font = FontCache.getDialogFont();
        Font font2 = font.deriveFont(1);
        this.m_slider = null;
        this.m_color = color;
        Container container = this.getContentPane();
        if (m_tcc == null) {
            m_tcc = new JColorChooser();
        }
        m_tcc.setFont(font);
        m_tcc.setColor(color == null ? Color.gray : color);
        container.add("North", m_tcc);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1, 15, 15));
        if (bl) {
            JPanel jPanel2 = new JPanel();
            this.m_slider = new JSlider(0, 255, 255);
            this.m_slider.setFont(font);
            this.m_slider.setMajorTickSpacing(50);
            this.m_slider.setPaintLabels(true);
            this.m_slider.setPaintTicks(true);
            this.alpha = color == null ? 255 : color.getAlpha();
            this.m_slider.setValue(this.alpha);
            jPanel2.add("Top", this.m_slider);
            JLabel jLabel = new JLabel("Alpha", 0);
            jLabel.setFont(font2);
            jPanel2.add("Bottom", jLabel);
            container.add("Center", jPanel2);
        }
        this.m_okButton = new JButton("OK");
        this.m_okButton.setFont(font2);
        this.m_okButton.addActionListener(this);
        jPanel.add(this.m_okButton);
        if (!bl2) {
            this.m_nullButton = null;
        } else {
            this.m_nullButton = new JButton("Null");
            this.m_nullButton.setFont(font2);
            this.m_nullButton.addActionListener(this);
            jPanel.add(this.m_nullButton);
        }
        this.m_clearButton = new JButton("Clear Cache");
        this.m_clearButton.setFont(font2);
        this.m_clearButton.addActionListener(this);
        jPanel.add(this.m_clearButton);
        this.m_canButton = new JButton("Cancel");
        this.m_canButton.setFont(font2);
        this.m_canButton.addActionListener(this);
        jPanel.add(this.m_canButton);
        container.add("South", jPanel);
        this.setLocation(20, 20);
        this.pack();
        this.setVisible(true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object != this.m_canButton) {
            if (object == this.m_okButton) {
                int n;
                this.m_color = m_tcc.getColor();
                if (this.m_slider != null && (n = this.m_slider.getValue()) != 255) {
                    this.m_color = ColorCache.get(this.m_color.getRed(), this.m_color.getGreen(), this.m_color.getBlue(), n);
                }
            } else if (object != null && object == this.m_nullButton) {
                this.m_color = null;
            } else {
                if (object == this.m_clearButton) {
                    int n = ColorCache.size();
                    ColorCache.clear();
                    JOptionPane.showMessageDialog(this, n + " colors have been removed from the cache");
                    return;
                }
                return;
            }
        }
        this.setVisible(false);
    }

    public Color getColor() {
        return this.m_color;
    }
}

