/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JViewport;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.undo.UndoableEdit;
import lsedit.Attribute;
import lsedit.AttributeValueItem;
import lsedit.Cardinal;
import lsedit.ClientSet;
import lsedit.ClientSupplierSet;
import lsedit.Clipboard;
import lsedit.ColorCache;
import lsedit.ColorChooser;
import lsedit.DiagramCoordinates;
import lsedit.EditModeHandler;
import lsedit.EntityClass;
import lsedit.EntityInstance;
import lsedit.FontCache;
import lsedit.LandscapeClassObject;
import lsedit.LandscapeEditorCore;
import lsedit.LandscapeLayouter;
import lsedit.LandscapeModeHandler;
import lsedit.LandscapeObject;
import lsedit.MapBox;
import lsedit.MyUndoableEdit;
import lsedit.RelationClass;
import lsedit.RelationComponent;
import lsedit.RelationInstance;
import lsedit.ResultBox;
import lsedit.SortVector;
import lsedit.SupplierSet;
import lsedit.TemporalTa;
import lsedit.TextTree;

public class Diagram
extends TemporalTa
implements MouseMotionListener,
DiagramCoordinates {
    public static final String RELN_HIDDEN_ID = "reln_hidden";
    public static final String EDGEMODE_ID = "edgemode";
    public static final String TOPCLIENTS_ID = "topclients";
    public static final String WANTCLIENTS_ID = "wantclients";
    public static final String WANTSUPPLIERS_ID = "wantsuppliers";
    public static final String WANTCARDINALS_ID = "wantcardinals";
    public static final String WANTOUTCARDINALS_ID = "wantoutcardinals";
    public static final int BG = 191;
    public static final Color boxColor = Color.lightGray;
    public static final Color lighterBoxColor = new Color(0xE0E0E0);
    protected static final int GAP = 5;
    protected static final int MARGIN = 10;
    protected static final double SMALL_SCALE_UP = 1.2;
    protected static final double SMALL_SCALE_DOWN = 0.8;
    protected static final String SMALL_SCALE_STRING = "20%";
    protected LandscapeEditorCore m_ls;
    protected boolean m_visited = false;
    protected double m_zoom_x = 1.0;
    protected double m_zoom_y = 1.0;
    protected EntityInstance m_drawRoot;
    protected Container m_edges = null;
    protected Container m_cardinals = null;
    protected int numVisibleRelationClasses = 0;
    protected boolean persistentQuery = false;
    protected boolean m_loaded = false;
    protected int mode;
    protected static int m_gridPixels = 1;
    protected static Color m_gridColor = Color.WHITE;
    protected int m_preserve_entity_marks = 0;
    protected int m_preserve_relation_marks = 0;
    protected Attribute m_relVisibilityAttr;
    protected boolean m_visibleEdges = true;
    protected boolean m_drawEdges = true;
    protected int newCnt = 0;
    protected boolean undoValid = false;
    protected EntityInstance m_keyEntity;
    protected ExitFlag m_exitFlag;
    protected SupplierSet m_supplierSet;
    protected ClientSet m_clientSet;
    protected Vector m_suppliers;
    protected Vector m_dClients;
    protected Vector m_dSuppliers;
    protected boolean m_suppliersSorted = false;
    protected boolean allClients = true;
    protected boolean allSuppliers = true;
    protected boolean m_modeHandlingActive = false;
    protected Clipboard m_clipboard = null;
    protected Vector m_oldChildren;

    protected Diagram getDiagram() {
        return this;
    }

    protected void findClientsAndSuppliers(boolean bl) {
        boolean bl2;
        boolean bl3;
        EntityInstance entityInstance = this.m_drawRoot;
        if (entityInstance == this.m_rootInstance) {
            bl3 = false;
            bl2 = false;
        } else {
            bl3 = this.m_ls.isShowSuppliers();
            bl2 = this.m_ls.isShowClients();
        }
        this.m_clientSet.removeAll();
        if (bl2) {
            this.m_clientSet.findClients(this.m_rootInstance, entityInstance, bl);
        }
        this.m_supplierSet.removeAll();
        if (bl3) {
            this.m_supplierSet.findSuppliers(this.m_rootInstance, entityInstance, bl);
        }
    }

    protected void setVisibilityFlags() {
        this.numVisibleRelationClasses = 0;
        Enumeration enumeration = this.enumRelationClasses();
        while (enumeration.hasMoreElements()) {
            RelationClass relationClass = (RelationClass)enumeration.nextElement();
            if (relationClass.isContainsClass() || !relationClass.isClassVisible()) continue;
            relationClass.setOrdinal(this.numVisibleRelationClasses++);
        }
        this.m_visibleEdges = this.numVisibleRelationClasses > 0;
    }

    public boolean contains(int n, int n2) {
        return this.m_loaded && super.contains(n, n2);
    }

    public void setPreserveEntityMarks(int n) {
        this.m_preserve_entity_marks = n;
    }

    public void setPreserveRelationMarks(int n) {
        this.m_preserve_relation_marks = n;
    }

    protected void paintChildren(Graphics graphics) {
        super.paintChildren(graphics);
    }

    public void repaint() {
        super.repaint();
    }

    public Component add(Component component) {
        if (component instanceof RelationComponent) {
            return this.m_edges.add(component);
        }
        if (component instanceof Cardinal) {
            return this.m_cardinals.add(component);
        }
        return super.add(component);
    }

    public void remove(Component component) {
        if (component instanceof RelationComponent) {
            this.m_edges.remove(component);
            return;
        }
        if (component instanceof Cardinal) {
            this.m_cardinals.remove(component);
            return;
        }
        super.remove(component);
    }

    public Diagram(LandscapeEditorCore landscapeEditorCore) {
        super(landscapeEditorCore, landscapeEditorCore);
        this.m_ls = landscapeEditorCore;
        this.setDiagram(this);
        this.setLayout(null);
        this.setLocation(0, 0);
        this.m_exitFlag = new ExitFlag();
        this.m_exitFlag.setLocation(3, 3);
        this.m_supplierSet = new SupplierSet(this);
        this.m_clientSet = new ClientSet(this);
        this.addMouseMotionListener(this);
        this.setPreserveEntityMarks(0);
        this.setPreserveRelationMarks(0);
    }

    public LandscapeEditorCore getLs() {
        return this.m_ls;
    }

    public void entityCut(EntityInstance entityInstance) {
        EntityInstance entityInstance2 = entityInstance.getContainedBy();
        EntityInstance entityInstance3 = this.m_diagram.getKeyEntity();
        if (entityInstance.hasDescendantOrSelf(this.getDrawRoot())) {
            this.navigateTo(entityInstance2);
        }
        if (entityInstance3 != null && entityInstance.hasDescendantOrSelf(entityInstance3)) {
            this.clearKeyEntity();
        }
    }

    public void containerCut(EntityInstance entityInstance, EntityInstance entityInstance2) {
        if (this.getKeyEntity() == entityInstance2) {
            this.clearKeyEntity();
        }
        if (entityInstance2 == this.getDrawRoot()) {
            this.navigateTo(entityInstance);
        }
        this.redrawDiagram();
    }

    public void containerUncut(EntityInstance entityInstance) {
        this.redrawDiagram();
    }

    public void doDelete(Object object) {
        String string;
        int n = 0;
        Vector vector = this.targetEntityRelations(object);
        if (vector != null) {
            this.beginUndoRedo("Delete");
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                if (e == null) continue;
                if (e instanceof RelationInstance) {
                    RelationInstance relationInstance = (RelationInstance)e;
                    n |= 1;
                    relationInstance.updateDeleteEdge();
                    continue;
                }
                if (e instanceof EntityInstance) {
                    EntityInstance entityInstance = (EntityInstance)e;
                    if (entityInstance.getContainedBy() == null) continue;
                    this.updateCutEntity(entityInstance);
                    n |= 2;
                    continue;
                }
                System.out.println("Can't delete object of type " + e.getClass());
            }
            this.endUndoRedo();
            if (n != 0) {
                if ((n & 2) != 0) {
                    this.clearGroupFlags();
                }
                this.redrawDiagram();
            }
        }
        switch (n) {
            case 0: {
                string = "Nothing selected to delete";
                break;
            }
            case 1: {
                string = "Edge(s) deleted";
                break;
            }
            case 2: {
                string = "Entity(s) deleted";
                break;
            }
            case 3: {
                this.m_diagram.clearGroupFlags();
                string = "Entity(s) and Edge(s) deleted";
                break;
            }
            default: {
                string = "???";
            }
        }
        this.m_ls.doFeedback(string);
    }

    public void duplicateEdges(RelationClass relationClass, RelationClass relationClass2) {
        if (this.m_rootInstance != null) {
            Enumeration enumeration = this.m_rootInstance.getChildren();
            while (enumeration.hasMoreElements()) {
                EntityInstance entityInstance = (EntityInstance)enumeration.nextElement();
                entityInstance.duplicateEdges(relationClass, relationClass2);
            }
        }
        if (relationClass.isContainsClass()) {
            int n = this.getCIndex(relationClass2);
            this.m_rootInstance.exchangePositioning(n, n, this.getMaxCIndex() + 1);
        }
    }

    public boolean updateContainsRelation(RelationClass relationClass) {
        Vector vector = this.establishForest(relationClass);
        if (vector != null) {
            this.updateSwitchContainsClass(relationClass, vector);
            this.redrawDiagram();
            return true;
        }
        return false;
    }

    public String loadDiagram(String string, Object object) {
        String string2 = this.loadTA(string, object);
        if (string2 != null) {
            return string2;
        }
        this.navigateToRoot();
        this.m_ls.addLseditHistory(string);
        EntityInstance entityInstance = this.m_rootInstance;
        if (entityInstance != null) {
            int n = 3;
            Attribute attribute = entityInstance.getLsAttribute(EDGEMODE_ID);
            if (attribute != null && attribute.avi != null && attribute.avi.value != null) {
                n = attribute.parseInt();
            }
            this.m_ls.setEdgeMode(n);
            boolean bl = true;
            attribute = entityInstance.getLsAttribute(TOPCLIENTS_ID);
            if (attribute != null && attribute.avi == null && attribute.avi.value != null) {
                bl = attribute.parseBoolean();
            }
            this.m_ls.setTopClients(bl);
            bl = true;
            attribute = entityInstance.getLsAttribute(WANTCLIENTS_ID);
            if (attribute != null && attribute.avi == null && attribute.avi.value != null) {
                bl = attribute.parseBoolean();
            }
            this.m_ls.setShowClients(bl);
            bl = true;
            attribute = entityInstance.getLsAttribute(WANTSUPPLIERS_ID);
            if (attribute != null && attribute.avi == null && attribute.avi.value != null) {
                bl = attribute.parseBoolean();
            }
            this.m_ls.setShowSuppliers(bl);
            bl = true;
            attribute = entityInstance.getLsAttribute(WANTSUPPLIERS_ID);
            if (attribute != null && attribute.avi == null && attribute.avi.value != null) {
                bl = attribute.parseBoolean();
            }
            this.m_ls.setShowSuppliers(bl);
            bl = false;
            attribute = entityInstance.getLsAttribute(WANTCARDINALS_ID);
            if (attribute != null && attribute.avi == null && attribute.avi.value != null) {
                bl = attribute.parseBoolean();
            }
            this.m_ls.setShowDstCardinals(bl);
            bl = false;
            attribute = entityInstance.getLsAttribute(WANTOUTCARDINALS_ID);
            if (attribute != null && attribute.avi == null && attribute.avi.value != null) {
                bl = attribute.parseBoolean();
            }
            this.m_ls.setShowSrcCardinals(bl);
            this.m_relVisibilityAttr = attribute = entityInstance.getLsAttribute(RELN_HIDDEN_ID);
            if (attribute != null) {
                AttributeValueItem attributeValueItem = attribute.avi;
                while (attributeValueItem != null) {
                    RelationClass relationClass;
                    if (attributeValueItem.value != null && (relationClass = this.getRelationClass(attributeValueItem.value)) != null) {
                        relationClass.setClassVisible(false);
                    }
                    attributeValueItem = attributeValueItem.next;
                }
            }
        }
        this.setVisibilityFlags();
        return string2;
    }

    public void cutGroup(Object object) {
        boolean bl = this.m_ls.isAddToClipboard();
        TextTree textTree = this.m_ls.getTocBox();
        Vector vector = object != null && object == textTree ? textTree.getGroup() : this.getGroup();
        if (vector == null || vector.size() == 0) {
            this.m_ls.error("Group not selected");
            return;
        }
        if (vector.contains(this.m_rootInstance)) {
            this.m_ls.error("Can't cut the root node in the diagram");
        }
        this.clearKeyEntity();
        Clipboard clipboard = new Clipboard(vector);
        String string = "Group copied to clipboard";
        Clipboard clipboard2 = this.getClipboard();
        if (clipboard2 != null && clipboard2.size() != 0) {
            if (bl) {
                clipboard.setExtendsClipboard(clipboard2);
                string = string + " - old cuts preserved";
            } else {
                string = string + " - old cuts discarded";
            }
        }
        this.updateCutClipboard(clipboard2, clipboard);
        this.m_ls.doFeedback(string);
    }

    public void pasteGroup(Object object) {
        Clipboard clipboard = this.getClipboard();
        if (clipboard == null) {
            this.m_ls.error("Clipboard empty");
            return;
        }
        TextTree textTree = this.m_ls.getTocBox();
        EntityInstance entityInstance = object != null && object == textTree ? textTree.targetEntity() : this.targetEntity(object);
        if (entityInstance != null) {
            this.updatePasteClipboard(clipboard, entityInstance);
            this.m_ls.doFeedback("Pasted entities into " + entityInstance.getEntityLabel());
        }
    }

    public boolean isUndoAvailable() {
        return this.undoValid;
    }

    public void rescaleDiagram() {
        this.m_drawRoot.resizeChildren();
        this.m_drawRoot.relocateChildren();
    }

    public EntityInstance containing(Rectangle rectangle) {
        return this.m_drawRoot.containing(rectangle);
    }

    public Vector setGroupRegion(Rectangle rectangle) {
        EntityInstance entityInstance = this.m_drawRoot.getMouseOver(rectangle.x, rectangle.y);
        if (entityInstance == null) {
            return null;
        }
        return entityInstance.groupRegion(rectangle);
    }

    public void setMode(int n) {
        this.mode = n;
    }

    public void setEdgeMode(int n) {
        Attribute attribute = this.m_rootInstance.getLsAttribute(EDGEMODE_ID);
        AttributeValueItem attributeValueItem = new AttributeValueItem(String.valueOf(n));
        if (attribute == null) {
            attribute = new Attribute(EDGEMODE_ID, attributeValueItem);
            this.m_rootInstance.putLsAttribute(attribute);
        } else {
            attribute.avi = attributeValueItem;
        }
    }

    public void setOption(String string, boolean bl) {
        Attribute attribute = this.m_rootInstance.getLsAttribute(string);
        AttributeValueItem attributeValueItem = new AttributeValueItem(bl);
        if (attribute == null) {
            attribute = new Attribute(string, attributeValueItem);
            this.m_rootInstance.putLsAttribute(attribute);
        } else {
            attribute.avi = attributeValueItem;
        }
    }

    public void setTopClients(boolean bl) {
        this.setOption(TOPCLIENTS_ID, bl);
    }

    public void setShowClients(boolean bl) {
        this.setOption(WANTCLIENTS_ID, bl);
    }

    public void setShowSuppliers(boolean bl) {
        this.setOption(WANTSUPPLIERS_ID, bl);
    }

    public void setShowDstCardinals(boolean bl) {
        this.setOption(WANTCARDINALS_ID, bl);
    }

    public void setShowSrcCardinals(boolean bl) {
        this.setOption(WANTOUTCARDINALS_ID, bl);
    }

    public int getEdgeMode() {
        return this.m_ls.getEdgeMode();
    }

    public EntityInstance getDrawRoot() {
        return this.m_drawRoot;
    }

    public void setDrawRoot(EntityInstance entityInstance) {
        EntityInstance entityInstance2 = this.m_drawRoot;
        if (entityInstance != entityInstance2) {
            this.m_drawRoot = entityInstance;
            if (entityInstance2 != null) {
                entityInstance2.setToolTipText();
            }
            if (entityInstance != null) {
                entityInstance.setToolTipText();
                entityInstance.setOpen();
                MapBox mapBox = this.m_ls.m_mapBox;
                if (mapBox != null) {
                    mapBox.fill(entityInstance);
                }
                this.m_ls.addHistoryEntity(entityInstance);
            }
        }
    }

    public void toggleDstElision(EntityInstance entityInstance) {
        Enumeration enumeration = this.enumRelationClasses();
        while (enumeration.hasMoreElements()) {
            RelationClass relationClass = (RelationClass)enumeration.nextElement();
            if (relationClass.isContainsClass() || !relationClass.isClassVisible()) continue;
            entityInstance.toggleDstElision(relationClass);
        }
    }

    public void toggleSrcElision(EntityInstance entityInstance) {
        Enumeration enumeration = this.enumRelationClasses();
        while (enumeration.hasMoreElements()) {
            RelationClass relationClass = (RelationClass)enumeration.nextElement();
            if (relationClass.isContainsClass() || !relationClass.isClassVisible()) continue;
            entityInstance.toggleSrcElision(relationClass);
        }
    }

    public void toggleEnteringElision(EntityInstance entityInstance) {
        Enumeration enumeration = this.enumRelationClasses();
        while (enumeration.hasMoreElements()) {
            RelationClass relationClass = (RelationClass)enumeration.nextElement();
            if (relationClass.isContainsClass() || !relationClass.isClassVisible()) continue;
            entityInstance.toggleEnteringElision(relationClass);
        }
    }

    public void toggleExitingElision(EntityInstance entityInstance) {
        Enumeration enumeration = this.enumRelationClasses();
        while (enumeration.hasMoreElements()) {
            RelationClass relationClass = (RelationClass)enumeration.nextElement();
            if (relationClass.isContainsClass() || !relationClass.isClassVisible()) continue;
            entityInstance.toggleExitingElision(relationClass);
        }
    }

    public void toggleInternalElision(EntityInstance entityInstance) {
        Enumeration enumeration = this.enumRelationClasses();
        while (enumeration.hasMoreElements()) {
            RelationClass relationClass = (RelationClass)enumeration.nextElement();
            if (relationClass.isContainsClass() || !relationClass.isClassVisible()) continue;
            entityInstance.toggleInternalElision(relationClass);
        }
    }

    public void setVisible(boolean bl) {
        if (this.m_drawRoot != null) {
            this.m_drawRoot.setVisible(bl);
        }
    }

    public void setEdgeVisibilityState(RelationClass relationClass, boolean bl) {
        relationClass.setClassVisible(bl);
        if (bl) {
            if (this.m_relVisibilityAttr != null) {
                this.m_relVisibilityAttr.removeFromList(relationClass.getId());
            }
        } else {
            if (this.m_relVisibilityAttr == null) {
                this.m_rootInstance.addAttribute(new Attribute(RELN_HIDDEN_ID, null));
                this.m_relVisibilityAttr = this.m_rootInstance.getLsAttribute(RELN_HIDDEN_ID);
            }
            this.m_relVisibilityAttr.addToList(relationClass.getId());
        }
        this.setVisibilityFlags();
    }

    public void toggleEdgeVisibility() {
        Enumeration enumeration = this.enumRelationClasses();
        while (enumeration.hasMoreElements()) {
            RelationClass relationClass = (RelationClass)enumeration.nextElement();
            if (relationClass.isContainsClass() || !relationClass.isClassVisible()) continue;
            this.setEdgeVisibilityState(relationClass, false);
        }
    }

    public void clearDrawEdges() {
        this.m_drawEdges = false;
    }

    public void setDrawEdges() {
        this.m_drawEdges = true;
    }

    public boolean getDrawEdges() {
        return this.m_drawEdges;
    }

    protected void getHighlightedEdges(EntityInstance entityInstance, EntityInstance entityInstance2, Vector vector) {
        RelationInstance relationInstance;
        Enumeration enumeration = entityInstance.srcRelationElements();
        while (enumeration.hasMoreElements()) {
            relationInstance = (RelationInstance)enumeration.nextElement();
            if (!relationInstance.getHighlightFlag() || !relationInstance.getRelationClass().isActive()) continue;
            vector.addElement(relationInstance);
        }
        enumeration = entityInstance.dstRelationElements();
        while (enumeration.hasMoreElements()) {
            relationInstance = (RelationInstance)enumeration.nextElement();
            EntityInstance entityInstance3 = relationInstance.getSrc();
            if (entityInstance2.hasDescendant(entityInstance3) || !relationInstance.getHighlightFlag() || !relationInstance.getRelationClass().isActive()) continue;
            vector.addElement(relationInstance);
        }
        enumeration = entityInstance.getChildren();
        while (enumeration.hasMoreElements()) {
            EntityInstance entityInstance4 = (EntityInstance)enumeration.nextElement();
            this.getHighlightedEdges(entityInstance4, entityInstance2, vector);
        }
    }

    public Vector getHighlightedEdges() {
        Vector vector = new Vector();
        EntityInstance entityInstance = this.m_drawRoot;
        this.getHighlightedEdges(entityInstance, entityInstance, vector);
        if (vector.size() == 0) {
            return null;
        }
        return vector;
    }

    public boolean clearFlags() {
        this.clearKeyEntity();
        boolean bl = false;
        if (!this.getDrawEdges()) {
            bl = true;
            this.setDrawEdges();
        }
        this.m_rootInstance.clearAllFlags();
        if (this.m_drawRoot != null) {
            this.m_drawRoot.setOpen();
        }
        return bl;
    }

    public void clearQueryFlags() {
        this.m_rootInstance.clearQueryFlags();
    }

    public void clearGroupFlags() {
        this.clearKeyEntity();
        this.setDrawEdges();
        this.m_rootInstance.clearGroupFlags();
    }

    public boolean toggleQueryPersistence() {
        this.persistentQuery = !this.persistentQuery;
        return this.persistentQuery;
    }

    public boolean getQueryPersistance() {
        return this.persistentQuery;
    }

    public int numVisibleRelationClasses() {
        return this.numVisibleRelationClasses;
    }

    public Vector getGroup() {
        Vector vector = new Vector();
        this.m_rootInstance.getGroup(vector);
        if (vector.isEmpty()) {
            return null;
        }
        return vector;
    }

    public Rectangle getGroupBoundingBox() {
        Vector vector = this.getGroup();
        if (vector == null || vector.isEmpty()) {
            return null;
        }
        double d = Double.MAX_VALUE;
        double d2 = Double.MAX_VALUE;
        double d3 = Double.MIN_VALUE;
        double d4 = Double.MIN_VALUE;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            EntityInstance entityInstance = (EntityInstance)enumeration.nextElement();
            Rectangle rectangle = entityInstance.getDiagramBounds();
            if ((double)rectangle.x < d) {
                d = rectangle.x;
            }
            if ((double)rectangle.y < d2) {
                d2 = rectangle.y;
            }
            if ((double)(rectangle.x + rectangle.width) > d3) {
                d3 = rectangle.x + rectangle.width;
            }
            if (!((double)(rectangle.y + rectangle.height) > d4)) continue;
            d4 = rectangle.y + rectangle.height;
        }
        return new Rectangle((int)d, (int)d2, (int)(d3 - d), (int)(d4 - d2));
    }

    public EntityInstance getKeyEntity() {
        return this.m_keyEntity;
    }

    public void clearKeyEntity() {
        if (this.m_keyEntity != null) {
            this.m_keyEntity.clearGroupKeyFlag();
            this.m_keyEntity.clearGroupFlag();
            this.m_keyEntity = null;
        }
    }

    public void setKeyEntity(EntityInstance entityInstance) {
        if (this.m_keyEntity != null) {
            this.m_keyEntity.clearGroupKeyFlag();
            this.m_keyEntity.setGroupFlag();
        }
        this.m_keyEntity = entityInstance;
        this.m_keyEntity.setGroupKeyFlag();
        this.m_keyEntity.setGroupFlag();
    }

    public Vector getRedBoxGroup() {
        Vector vector = new Vector();
        this.m_rootInstance.getRedBoxGroup(vector);
        if (vector.isEmpty()) {
            return null;
        }
        return vector;
    }

    public boolean isOverGroupRegion(int n, int n2) {
        Rectangle rectangle = this.getGroupBoundingBox();
        if (rectangle != null) {
            return rectangle.contains(n, n2);
        }
        return false;
    }

    public String show_groupList(ResultBox resultBox) {
        Vector vector = this.getGroup();
        String string = null;
        if (vector != null) {
            SortVector.byString(vector);
            resultBox.showResults("GROUP:", vector, "-- End of group --");
        } else {
            string = "No entities selected";
        }
        return string;
    }

    public String groupAll(ResultBox resultBox) {
        EntityInstance entityInstance;
        EntityInstance entityInstance2 = entityInstance = this.getKeyEntity();
        String string = null;
        if (entityInstance == null) {
            entityInstance2 = entityInstance = this.getDrawRoot();
        }
        boolean bl = this.clearFlags();
        if (!entityInstance2.isOpen()) {
            entityInstance2 = entityInstance2.getContainedBy();
        }
        Enumeration enumeration = entityInstance2.getChildren();
        while (enumeration.hasMoreElements()) {
            EntityInstance entityInstance3 = (EntityInstance)enumeration.nextElement();
            entityInstance3.setGroupFlag();
        }
        Vector vector = this.getGroup();
        if (vector != null) {
            if (!vector.contains(entityInstance)) {
                entityInstance = (EntityInstance)vector.firstElement();
            }
            this.setKeyEntity(entityInstance);
            this.setPreserveEntityMarks(196608);
            this.setPreserveRelationMarks(0);
            if (bl) {
                this.redrawDiagram();
            }
            string = this.show_groupList(resultBox);
        } else {
            string = "No entities selected";
        }
        return string;
    }

    public static int getGrid() {
        return m_gridPixels;
    }

    public static void setGrid(int n) {
        m_gridPixels = n;
    }

    public static Color getGridColor() {
        return m_gridColor;
    }

    public static void setGridColor(Color color) {
        m_gridColor = color;
    }

    public int setNewGridValue() {
        int n = Diagram.getGrid();
        SetNewGridDialog setNewGridDialog = new SetNewGridDialog(this.m_ls.getFrame());
        setNewGridDialog.finished();
        setNewGridDialog.dispose();
        setNewGridDialog = null;
        int n2 = Diagram.getGrid();
        if (n != n2 && this.m_ls.isShowGrid()) {
            this.repaint();
        }
        return n2;
    }

    public void setToViewport() {
        this.navigateToRoot();
    }

    public void invalidateAllEdges(EntityInstance entityInstance) {
        entityInstance.invalidateAllEdges();
        if (entityInstance.isOpen()) {
            Enumeration enumeration = entityInstance.getChildren();
            while (enumeration.hasMoreElements()) {
                this.invalidateAllEdges((EntityInstance)enumeration.nextElement());
            }
        }
    }

    protected void drawHighlightEdges(EntityInstance entityInstance) {
        entityInstance.drawHighlightedEdges();
        if (entityInstance.isOpen()) {
            Enumeration enumeration = entityInstance.getChildren();
            while (enumeration.hasMoreElements()) {
                this.drawHighlightEdges((EntityInstance)enumeration.nextElement());
            }
        }
    }

    protected void drawAllEdges(EntityInstance entityInstance, EntityInstance entityInstance2) {
        entityInstance.drawAllEdges(entityInstance2);
        if (entityInstance.isOpen()) {
            Enumeration enumeration = entityInstance.getChildren();
            while (enumeration.hasMoreElements()) {
                this.drawAllEdges((EntityInstance)enumeration.nextElement(), entityInstance2);
            }
        }
    }

    protected void doDrawEdges(EntityInstance entityInstance, EntityInstance entityInstance2) {
        if (this.getDrawEdges()) {
            if (this.m_visibleEdges) {
                this.drawAllEdges(entityInstance, entityInstance2);
            }
        } else {
            this.drawHighlightEdges(entityInstance);
        }
    }

    public boolean isValidateRoot() {
        return true;
    }

    public Dimension getPreferredSize() {
        int n;
        int n2;
        JComponent jComponent = (JComponent)this.getParent();
        if (jComponent == null) {
            n2 = 0;
            n = 0;
        } else {
            Insets insets = jComponent.getInsets();
            n2 = jComponent.getWidth() - insets.right - insets.left;
            if (n2 <= 0) {
                n2 = 0;
            }
            if ((n = jComponent.getHeight() - insets.bottom - insets.top) <= 0) {
                n2 = 0;
            }
            n2 = (int)((double)n2 * this.m_zoom_x);
            n = (int)((double)n * this.m_zoom_y);
        }
        Dimension dimension = super.getPreferredSize();
        if (dimension.width != n2 || dimension.height != n) {
            dimension.setSize(n2, n);
            this.setPreferredSize(dimension);
            jComponent.revalidate();
        }
        return dimension;
    }

    public void closeEntities() {
        String string = this.getContainsId();
        EntityInstance entityInstance = this.m_entityCache.getFirst();
        while (entityInstance != null) {
            if (entityInstance.isDstRelationElided(string)) {
                return;
            }
            entityInstance = this.m_entityCache.getNext();
        }
        entityInstance = this.m_entityCache.getFirst();
        while (entityInstance != null) {
            if (entityInstance != this.m_drawRoot && entityInstance != this.m_rootInstance) {
                entityInstance.toggleContainElision(string);
            }
            entityInstance = this.m_entityCache.getNext();
        }
        Enumeration enumeration = this.m_rootInstance.getChildren();
        while (enumeration.hasMoreElements()) {
            entityInstance = (EntityInstance)enumeration.nextElement();
            if (entityInstance == this.m_drawRoot) continue;
            entityInstance.toggleContainElision(string);
        }
    }

    public void validate() {
        EntityInstance entityInstance;
        int n;
        this.m_loaded = false;
        Dimension dimension = this.getSize();
        int n2 = dimension.width;
        int n3 = dimension.height;
        if (n2 < 1 || n3 < 1) {
            return;
        }
        if (this.m_cardinals == null) {
            this.m_cardinals = new Container();
            this.m_cardinals.setLayout(null);
        }
        if (this.m_edges == null) {
            this.m_edges = new Container();
            this.m_edges.setLayout(null);
        }
        this.removeAll();
        if (this.m_drawRoot == null) {
            return;
        }
        this.m_ls.setCursor(3);
        this.m_cardinals.removeAll();
        if (this.getLs().isShowDstCardinals() || this.getLs().isShowSrcCardinals()) {
            this.m_cardinals.setBounds(0, 0, n2, n3);
            this.add(this.m_cardinals);
        }
        this.m_edges.removeAll();
        this.m_edges.setBounds(0, 0, n2, n3);
        this.add(this.m_edges);
        if (!this.getDrawEdges()) {
            this.m_preserve_entity_marks |= 0x8000;
            this.m_preserve_relation_marks |= 0x400;
        }
        this.m_rootInstance.clearAllMarks(this.m_preserve_entity_marks, this.m_preserve_relation_marks);
        this.m_drawRoot.setOpen();
        n2 -= 30;
        n3 -= 20;
        int n4 = 0;
        Vector vector = null;
        Vector vector2 = null;
        boolean bl = this.m_ls.isTopClients();
        if (this.m_drawRoot != this.m_rootInstance) {
            this.add(this.m_exitFlag);
            this.m_exitFlag.activate();
        } else {
            this.repaint();
        }
        boolean bl2 = this.m_ls.isLiftEdges();
        this.findClientsAndSuppliers(bl2);
        if (this.m_clientSet.getFullSetSize() != 0) {
            n = 70;
            n3 -= n;
            if (bl) {
                this.m_clientSet.setBounds(15, 10, n2, 50);
                n4 = n;
            } else {
                this.m_clientSet.setBounds(15, this.getHeight() - 50 - 10, n2, 50);
            }
        }
        if (this.m_supplierSet.getFullSetSize() != 0) {
            n = 70;
            n3 -= n;
            if (!bl) {
                this.m_supplierSet.setBounds(15, 10, n2, 50);
                n4 = n;
            } else {
                this.m_supplierSet.setBounds(15, this.getHeight() - 50 - 10, n2, 50);
            }
        }
        ClientSupplierSet.compact(this.m_clientSet, this.m_supplierSet);
        vector = this.m_clientSet.getFullSet();
        if (vector != null && vector.size() == 0) {
            vector = null;
        }
        if ((vector2 = this.m_supplierSet.getFullSet()) != null && vector2.size() == 0) {
            vector2 = null;
        }
        this.m_drawRoot.setSize(n2, n3);
        if (!this.m_visited) {
            this.closeEntities();
            this.m_visited = true;
        }
        this.m_drawRoot.computeAllDiagramEdges(this.m_drawRoot, vector, vector2, null, bl2);
        this.m_drawRoot.liftAllDiagramEdges(bl2);
        this.m_drawRoot.setBothLocations(0, 0, 15, 10 + n4);
        this.m_drawRoot.addUnder(this);
        if (this.m_supplierSet.getFullSetSize() != 0) {
            this.m_supplierSet.order();
            this.add(this.m_supplierSet);
            this.m_supplierSet.setVisible(true);
        }
        if (this.m_clientSet.getFullSetSize() != 0) {
            this.m_clientSet.order();
            this.add(this.m_clientSet);
            this.m_clientSet.setVisible(true);
        }
        this.doDrawEdges(this.m_drawRoot, this.m_drawRoot);
        if (this.getLs().isShowDstCardinals()) {
            entityInstance = this.m_drawRoot;
            entityInstance.resetDstCardinals(this.m_numRelationClasses);
            entityInstance.calcDstEdgeCardinals(!this.getDrawEdges());
            entityInstance.showDstCardinals();
        }
        if (this.getLs().isShowSrcCardinals()) {
            entityInstance = this.m_drawRoot;
            entityInstance.resetSrcCardinals(this.m_numRelationClasses);
            entityInstance.calcSrcEdgeCardinals(!this.getDrawEdges());
            entityInstance.showSrcCardinals();
        }
        Container container = this.m_cardinals;
        int n5 = container.getComponentCount();
        for (int i = 0; i < n5; ++i) {
            Cardinal cardinal = (Cardinal)container.getComponent(i);
            cardinal.known();
        }
        this.m_ls.setCursor(0);
        this.m_loaded = true;
        this.repaint();
    }

    public void redrawDiagram() {
        this.revalidate();
    }

    public boolean shouldScrollDiagram() {
        return this.m_zoom_x > 1.0 || this.m_zoom_y > 1.0;
    }

    public void setZoom(double d, double d2) {
        this.m_zoom_x = d;
        this.m_zoom_y = d2;
        this.getPreferredSize();
        this.redrawDiagram();
    }

    public boolean updateZoom(double d, double d2) {
        double d3 = this.m_zoom_x;
        double d4 = this.m_zoom_y;
        if (d <= 1.0 && d2 <= 1.0 && d3 == 1.0 && d4 == 1.0) {
            return false;
        }
        double d5 = d3 * d;
        double d6 = d4 * d2;
        if (d5 < 1.0) {
            d5 = 1.0;
        }
        if (d6 < 1.0) {
            d6 = 1.0;
        }
        if (d5 != d3 || d6 != d4) {
            this.setZoom(d5, d6);
            if (this.undoEnabled()) {
                new Zoom(d3, d4);
            }
        }
        return true;
    }

    public boolean set_to_viewport() {
        if (!this.shouldScrollDiagram()) {
            return false;
        }
        double d = this.m_zoom_x;
        double d2 = this.m_zoom_y;
        this.setZoom(1.0, 1.0);
        if (this.undoEnabled()) {
            new Zoom(d, d2);
        }
        return true;
    }

    public void navigateTo(EntityInstance entityInstance) {
        LandscapeEditorCore landscapeEditorCore = this.getLs();
        this.setDrawRoot(entityInstance);
        landscapeEditorCore.setLeftBox();
        landscapeEditorCore.doFeedback("Now showing: " + entityInstance.getEntityLabel());
        this.redrawDiagram();
    }

    public void navigateToId(String string) {
        EntityInstance entityInstance = this.getCache(string);
        if (entityInstance != null) {
            this.navigateTo(entityInstance);
        }
    }

    public void navigateToRoot() {
        this.setPreserveEntityMarks(0);
        this.setPreserveRelationMarks(0);
        this.navigateTo(this.m_rootInstance);
    }

    public void navigateToDrawRootParent() {
        EntityInstance entityInstance = this.m_drawRoot.getContainedBy();
        if (entityInstance == null) {
            this.m_ls.error("At topmost landscape");
        } else {
            this.setPreserveEntityMarks(0);
            this.setPreserveRelationMarks(0);
            this.navigateTo(entityInstance);
        }
    }

    public boolean allowElision() {
        return this.getDrawEdges();
    }

    public boolean isModeHandlingActive() {
        return this.m_modeHandlingActive;
    }

    public void setModeHandlingActive(boolean bl) {
        this.m_modeHandlingActive = bl;
    }

    public RelationInstance targetRelation(Object object) {
        if (object != null) {
            if (object instanceof Vector) {
                Vector vector = (Vector)object;
                switch (vector.size()) {
                    case 0: {
                        this.m_ls.doFeedback("Target relation set is empty");
                        return null;
                    }
                    case 1: {
                        object = vector.firstElement();
                        break;
                    }
                    default: {
                        this.m_ls.doFeedback("Target relation set has multiple objects in it");
                        return null;
                    }
                }
            }
            if (object instanceof RelationInstance) {
                return (RelationInstance)object;
            }
            return null;
        }
        Vector vector = this.getHighlightedEdges();
        if (vector == null) {
            this.m_ls.doFeedback("Highlight the edge you wish to work on");
        } else {
            if (vector.size() == 1) {
                return (RelationInstance)vector.firstElement();
            }
            this.m_ls.doFeedback("Can't operate on " + vector.size() + " highlight edges");
        }
        return null;
    }

    public EntityInstance targetEntity(Object object) {
        if (object != null) {
            if (object instanceof Vector) {
                Vector vector = (Vector)object;
                switch (vector.size()) {
                    case 0: {
                        this.m_ls.doFeedback("Target entity set is empty");
                        return null;
                    }
                    case 1: {
                        object = vector.firstElement();
                        break;
                    }
                    default: {
                        this.m_ls.doFeedback("Target entity set has multiple objects in it");
                        return null;
                    }
                }
            }
            if (object instanceof EntityInstance) {
                return (EntityInstance)object;
            }
            return null;
        }
        EntityInstance entityInstance = this.getKeyEntity();
        if (entityInstance != null) {
            return entityInstance;
        }
        return this.getDrawRoot();
    }

    public Vector targetEntityRelations(Object object) {
        if (object != null) {
            if (object instanceof Vector) {
                Vector vector = (Vector)object;
                if (vector.size() > 0) {
                    return vector;
                }
                this.m_ls.doFeedback("Target set is empty");
                return null;
            }
            Vector<Object> vector = new Vector<Object>();
            vector.addElement(object);
            return vector;
        }
        Vector vector = this.getHighlightedEdges();
        Vector vector2 = this.getGroup();
        if (vector == null) {
            vector = vector2;
        } else if (vector2 != null) {
            vector.addAll(vector2);
        }
        if (vector == null) {
            this.m_ls.doFeedback("Select the entity/relations you wish to work on");
        }
        return vector;
    }

    public LandscapeObject targetEntityRelation(Object object) {
        Vector vector = this.targetEntityRelations(object);
        LandscapeObject landscapeObject = null;
        if (vector != null) {
            if (vector.size() != 1) {
                this.m_ls.doFeedback("Select a single entity or relation that you wish to work with");
            } else {
                landscapeObject = (LandscapeObject)vector.firstElement();
            }
            vector = null;
        }
        return landscapeObject;
    }

    public Vector targetRelations(Object object) {
        if (object != null) {
            if (object instanceof Vector) {
                Vector vector = (Vector)object;
                if (vector.size() > 0) {
                    return vector;
                }
                this.m_ls.doFeedback("Target relation set is empty");
                return null;
            }
            Vector<Object> vector = new Vector<Object>();
            vector.addElement(object);
            return vector;
        }
        Vector vector = this.getHighlightedEdges();
        if (vector == null) {
            this.m_ls.doFeedback("Select the edges you wish to work on");
        }
        return vector;
    }

    public Vector targetEntities(Object object) {
        if (object != null) {
            if (object instanceof Vector) {
                Vector vector = (Vector)object;
                if (vector.size() > 0) {
                    return vector;
                }
                this.m_ls.doFeedback("Target entity set is empty");
                return null;
            }
            Vector<Object> vector = new Vector<Object>();
            vector.addElement(object);
            return vector;
        }
        return this.getGroup();
    }

    public Clipboard getClipboard() {
        return this.m_clipboard;
    }

    protected void setClipboard(Clipboard clipboard) {
        this.m_clipboard = clipboard;
        this.m_ls.clipboardChanged();
    }

    protected void relayoutSubtree(EntityInstance entityInstance) {
        Enumeration enumeration = entityInstance.getChildren();
        while (enumeration.hasMoreElements()) {
            EntityInstance entityInstance2 = (EntityInstance)enumeration.nextElement();
            entityInstance2.setRelLocal(-1.0, -1.0, entityInstance2.widthRelLocal(), entityInstance2.heightRelLocal());
            this.relayoutSubtree(entityInstance2);
        }
    }

    protected void doRelayoutAll(EntityInstance entityInstance) {
        if (this.undoEnabled()) {
            new RelayoutSubtree(entityInstance);
        }
        this.relayoutSubtree(entityInstance);
    }

    protected void doRelayoutAll() {
        this.doRelayoutAll(this.m_drawRoot);
        this.redrawDiagram();
    }

    public String relayoutAll() {
        RelayoutDialog relayoutDialog = new RelayoutDialog();
        String string = relayoutDialog.msg();
        relayoutDialog.dispose();
        return string;
    }

    public String closeAll() {
        this.m_drawRoot.closeAll(this.getContainsId());
        this.redrawDiagram();
        return "Entities closed";
    }

    public String openAll() {
        this.m_drawRoot.openAll(this.getContainsId());
        return "Entities opened";
    }

    protected void centerDiagramOn(EntityInstance entityInstance) {
        double d = this.m_zoom_x;
        double d2 = this.m_zoom_y;
        if (d > 1.0 || d2 > 1.0) {
            int n;
            int n2;
            int n3;
            JScrollPane jScrollPane = this.m_ls.m_scrollDiagram;
            int n4 = 0;
            int n5 = 0;
            jScrollPane.validate();
            JViewport jViewport = jScrollPane.getViewport();
            Dimension dimension = jViewport.getExtentSize();
            if (d > 1.0) {
                n3 = this.getWidth();
                n2 = (int)((double)dimension.width / d);
                n = n3 - n2;
                n4 = entityInstance.getDiagramX() + entityInstance.getWidth() / 2 - n2;
                if (n4 >= n) {
                    n4 = n;
                }
                if (n4 <= 0) {
                    n4 = 0;
                }
            }
            if (d2 > 1.0) {
                n3 = this.getHeight();
                n2 = (int)((double)dimension.height / d2);
                n = n3 - n2;
                n5 = entityInstance.getDiagramY() + entityInstance.getHeight() / 2 - n2;
                if (n5 >= n) {
                    n5 = n;
                }
                if (n5 <= 0) {
                    n5 = 0;
                }
            }
            jViewport.setViewPosition(new Point(n4, n5));
        }
    }

    public String scaleEntity(int n, boolean bl) {
        Vector vector = this.getGroup();
        String string = null;
        EntityInstance entityInstance = null;
        if (vector != null) {
            block0 : switch (vector.size()) {
                case 0: {
                    break;
                }
                case 1: {
                    entityInstance = (EntityInstance)vector.firstElement();
                    if (entityInstance == this.getDrawRoot()) break;
                }
                default: {
                    switch (n) {
                        case 77: 
                        case 109: {
                            if (entityInstance != null) break block0;
                            entityInstance = (EntityInstance)vector.firstElement();
                            break block0;
                        }
                        default: {
                            Enumeration enumeration = vector.elements();
                            while (enumeration.hasMoreElements()) {
                                EntityInstance entityInstance2 = (EntityInstance)enumeration.nextElement();
                                switch (n) {
                                    case 120: {
                                        entityInstance2.scaleX(0.8, bl);
                                        break;
                                    }
                                    case 88: {
                                        entityInstance2.scaleX(1.2, bl);
                                        break;
                                    }
                                    case 121: {
                                        entityInstance2.scaleY(0.8, bl);
                                        break;
                                    }
                                    case 89: {
                                        entityInstance2.scaleY(1.2, bl);
                                        break;
                                    }
                                    case 122: {
                                        entityInstance2.scale(0.8, bl);
                                        break;
                                    }
                                    case 90: {
                                        entityInstance2.scale(1.2, bl);
                                    }
                                }
                            }
                            return string;
                        }
                    }
                }
            }
        }
        switch (n) {
            case 77: {
                if (entityInstance != null) {
                    if (this.updateZoom(1.2, 1.2)) {
                        string = "Magnified " + entityInstance.getEntityLabel();
                    }
                    this.centerDiagramOn(entityInstance);
                    break;
                }
            }
            case 90: {
                if (!this.updateZoom(1.2, 1.2)) break;
                string = "Zoomed in";
                break;
            }
            case 109: {
                if (entityInstance != null) {
                    if (this.updateZoom(0.8, 0.8)) {
                        string = "Reduced " + entityInstance.getEntityLabel();
                    }
                    this.centerDiagramOn(entityInstance);
                    break;
                }
            }
            case 122: {
                if (!this.updateZoom(0.8, 0.8)) break;
                string = "Zoomed out";
                break;
            }
            case 88: {
                if (!this.updateZoom(1.2, 1.0)) break;
                string = "Zoomed in X direction";
                break;
            }
            case 120: {
                if (!this.updateZoom(0.8, 1.0)) break;
                string = "Zoomed out X direction";
                break;
            }
            case 89: {
                if (!this.updateZoom(1.0, 1.2)) break;
                string = "Zoomed in Y direction";
                break;
            }
            case 121: {
                if (!this.updateZoom(1.0, 0.8)) break;
                string = "Zoomed out Y direction";
            }
        }
        string = string + " (20%) to " + this.m_zoom_x + "x" + this.m_zoom_y;
        return string;
    }

    public String handleElision(int n, Object object) {
        String string = "";
        Vector vector = this.targetEntities(object);
        boolean bl = false;
        EntityInstance entityInstance = null;
        String string2 = this.getContainsId();
        if (vector == null || vector.size() == 0) {
            return "Nothing selected";
        }
        switch (n) {
            case 99: {
                string = "Containment";
                entityInstance = vector.size() == 1 ? (EntityInstance)vector.elementAt(0) : this.getKeyEntity();
                if (entityInstance == null) {
                    return "Unable to identify key entity to open/close";
                }
                bl = entityInstance.isDstRelationElided(string2);
                break;
            }
            case 117: {
                string = "Target ";
                break;
            }
            case 115: {
                string = "Source ";
                break;
            }
            case 85: {
                string = "Entering";
                break;
            }
            case 83: {
                string = "Exiting";
                break;
            }
            case 73: {
                string = "Internal edges";
                break;
            }
            default: {
                return null;
            }
        }
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            EntityInstance entityInstance2 = (EntityInstance)enumeration.nextElement();
            switch (n) {
                case 99: {
                    if (entityInstance2 != entityInstance && bl != entityInstance2.isDstRelationElided(string2)) break;
                    entityInstance2.toggleContainElision(string2);
                    break;
                }
                case 117: {
                    this.toggleDstElision(entityInstance2);
                    break;
                }
                case 115: {
                    this.toggleSrcElision(entityInstance2);
                    break;
                }
                case 85: {
                    if (!entityInstance2.isOpen()) break;
                    this.toggleEnteringElision(entityInstance2);
                    break;
                }
                case 83: {
                    if (!entityInstance2.isOpen()) break;
                    this.toggleExitingElision(entityInstance2);
                    break;
                }
                case 73: {
                    if (!entityInstance2.isOpen()) break;
                    this.toggleInternalElision(entityInstance2);
                }
            }
        }
        this.redrawDiagram();
        return string + " elision toggled for group";
    }

    protected boolean handleEdgeExpansion(int n, Object object, ResultBox resultBox) {
        String string;
        String string2 = this.getContainsId();
        Vector vector = this.targetRelations(object);
        if (vector == null) {
            return false;
        }
        String string3 = null;
        switch (n) {
            case 105: {
                string = "Opened sources and destinations of edges.";
                break;
            }
            case 79: {
                string = "Opened sources of edges.";
                break;
            }
            case 111: {
                string = "Opened destination of edges.";
                break;
            }
            case 73: {
                string = "Closed source and destination of edges";
                break;
            }
            case 67: {
                string = "Closed source of edges";
                break;
            }
            default: {
                string = "Closed source and destination of edges";
            }
        }
        resultBox.setResultTitle("SELECTED RELATIONS:");
        EntityInstance entityInstance = this.getDrawRoot();
        Enumeration enumeration = vector.elements();
        block18: while (enumeration.hasMoreElements()) {
            RelationInstance relationInstance = (RelationInstance)enumeration.nextElement();
            relationInstance.setGroupAndHighlightFlag();
            EntityInstance entityInstance2 = relationInstance.getDrawSrc();
            EntityInstance entityInstance3 = relationInstance.getDrawDst();
            switch (n) {
                case 105: {
                    if (!entityInstance2.openEdgeExpansion(entityInstance2, entityInstance3, string2, "", resultBox)) continue block18;
                    string3 = string;
                    continue block18;
                }
                case 79: {
                    if (!entityInstance2.openSrcEdgeExpansion(entityInstance2, entityInstance3, string2, "", resultBox)) continue block18;
                    string3 = string;
                    continue block18;
                }
                case 111: {
                    if (!entityInstance3.openDstEdgeExpansion(entityInstance2, entityInstance3, string2, "", resultBox)) continue block18;
                    string3 = string;
                    continue block18;
                }
                case 73: {
                    entityInstance3 = relationInstance.getDst();
                    entityInstance2 = relationInstance.getSrc();
                    while ((entityInstance2 = entityInstance2.getContainedBy()) != null && entityInstance.hasDescendant(entityInstance2) && entityInstance2 != entityInstance3 && !entityInstance2.hasDescendant(entityInstance3)) {
                        if (!entityInstance2.setContainElision(string2)) continue;
                        string3 = string;
                    }
                    while ((entityInstance3 = entityInstance3.getContainedBy()) != null && entityInstance.hasDescendant(entityInstance3) && entityInstance2 != entityInstance3 && !entityInstance3.hasDescendant(entityInstance2)) {
                        if (!entityInstance3.setContainElision(string2)) continue;
                        string3 = string;
                    }
                    break;
                }
                case 67: {
                    entityInstance3 = relationInstance.getDst();
                    entityInstance2 = relationInstance.getSrc();
                    while ((entityInstance2 = entityInstance2.getContainedBy()) != null && entityInstance.hasDescendant(entityInstance2) && entityInstance2 != entityInstance3 && !entityInstance2.hasDescendant(entityInstance3)) {
                        if (!entityInstance2.setContainElision(string2)) continue;
                        string3 = string;
                    }
                    break;
                }
                case 99: {
                    entityInstance3 = relationInstance.getDst();
                    entityInstance2 = relationInstance.getSrc();
                    while ((entityInstance3 = entityInstance3.getContainedBy()) != null && entityInstance.hasDescendant(entityInstance3) && entityInstance2 != entityInstance3 && !entityInstance3.hasDescendant(entityInstance2)) {
                        if (!entityInstance3.setContainElision(string2)) continue;
                        string3 = string;
                    }
                    break;
                }
            }
            resultBox.addRelation(relationInstance);
        }
        resultBox.done("-- End --");
        this.clearDrawEdges();
        if (string3 != null) {
            this.m_ls.doFeedback(string3);
            return true;
        }
        switch (n) {
            case 79: 
            case 105: 
            case 111: {
                string3 = "No further expansion is possible";
                break;
            }
            default: {
                string3 = "No further contraction is possible";
            }
        }
        this.m_ls.error(string3);
        return false;
    }

    protected boolean goodQueryEdge(EntityInstance entityInstance, EntityInstance entityInstance2, EntityInstance entityInstance3) {
        if (entityInstance.hasDescendant(entityInstance2) || entityInstance2.hasDescendant(entityInstance)) {
            return false;
        }
        if (entityInstance.isClientOrSupplier()) {
            return entityInstance3.hasDescendant(entityInstance2);
        }
        return true;
    }

    protected void addToForwardEntityList(EntityInstance entityInstance, EntityInstance entityInstance2, RelationClass relationClass, Vector vector, boolean bl, boolean bl2) {
        RelationInstance relationInstance;
        EntityInstance entityInstance3 = this.getDrawRoot();
        Enumeration enumeration = entityInstance2.srcLiftedRelationElements();
        while (enumeration.hasMoreElements()) {
            EntityInstance entityInstance4;
            relationInstance = (RelationInstance)enumeration.nextElement();
            if (relationInstance.getRelationClass() != relationClass || (entityInstance4 = relationInstance.getDrawDst()) == null) continue;
            relationInstance.setHighlightFlag();
            entityInstance4.setRedBoxFlag();
            if (!bl) continue;
            entityInstance4.setGroupFlag();
        }
        enumeration = entityInstance2.srcRelationElements();
        while (enumeration.hasMoreElements()) {
            relationInstance = (RelationInstance)enumeration.nextElement();
            if (relationInstance.getRelationClass() != relationClass) continue;
            EntityInstance entityInstance5 = relationInstance.getDst();
            if (bl2 && !this.m_drawRoot.hasDescendantOrSelf(entityInstance5) || vector.indexOf(entityInstance5) >= 0) continue;
            vector.addElement(entityInstance5);
        }
    }

    protected int addForwardRelation(EntityInstance entityInstance, RelationClass relationClass, ResultBox resultBox, boolean bl, boolean bl2) {
        Vector vector = new Vector();
        this.addToForwardEntityList(entityInstance, entityInstance, relationClass, vector, bl, bl2);
        int n = vector.size();
        if (n > 0) {
            resultBox.addForwardRelation(entityInstance, relationClass, vector);
        }
        return n;
    }

    protected int showForwardEdges(EntityInstance entityInstance, ResultBox resultBox, boolean bl) {
        boolean bl2 = entityInstance.isMarked(6);
        int n = 0;
        Enumeration enumeration = this.enumRelationClasses();
        while (enumeration.hasMoreElements()) {
            RelationClass relationClass = (RelationClass)enumeration.nextElement();
            if (!relationClass.isActive()) continue;
            n += this.addForwardRelation(entityInstance, relationClass, resultBox, bl, bl2);
        }
        return n;
    }

    public void addToBackEntityList(EntityInstance entityInstance, EntityInstance entityInstance2, RelationClass relationClass, Vector vector, boolean bl, boolean bl2) {
        RelationInstance relationInstance;
        EntityInstance entityInstance3 = this.getDrawRoot();
        Enumeration enumeration = entityInstance2.dstLiftedRelationElements();
        while (enumeration.hasMoreElements()) {
            EntityInstance entityInstance4;
            relationInstance = (RelationInstance)enumeration.nextElement();
            if (relationInstance.getRelationClass() != relationClass || (entityInstance4 = relationInstance.getDrawSrc()) == null) continue;
            relationInstance.setHighlightFlag();
            entityInstance4.setRedBoxFlag();
            if (!bl) continue;
            entityInstance4.setGroupFlag();
        }
        enumeration = entityInstance2.dstRelationElements();
        while (enumeration.hasMoreElements()) {
            relationInstance = (RelationInstance)enumeration.nextElement();
            if (relationInstance.getRelationClass() != relationClass) continue;
            EntityInstance entityInstance5 = relationInstance.getSrc();
            if (bl2 && !this.m_drawRoot.hasDescendantOrSelf(entityInstance5) || vector.indexOf(entityInstance5) >= 0) continue;
            vector.addElement(entityInstance5);
        }
    }

    public int addBackRelation(EntityInstance entityInstance, RelationClass relationClass, ResultBox resultBox, boolean bl, boolean bl2) {
        Vector vector = new Vector();
        this.addToBackEntityList(entityInstance, entityInstance, relationClass, vector, bl, bl2);
        int n = vector.size();
        if (n > 0) {
            resultBox.addBackRelation(entityInstance, relationClass, vector);
        }
        return n;
    }

    public int showBackEdges(EntityInstance entityInstance, ResultBox resultBox, boolean bl) {
        boolean bl2 = entityInstance.isMarked(6);
        int n = 0;
        Enumeration enumeration = this.enumRelationClasses();
        while (enumeration.hasMoreElements()) {
            RelationClass relationClass = (RelationClass)enumeration.nextElement();
            if (!relationClass.isActive()) continue;
            n += this.addBackRelation(entityInstance, relationClass, resultBox, bl, bl2);
        }
        return n;
    }

    protected void getSrcRelationWithClosure(EntityInstance entityInstance, Vector vector, boolean bl) {
        EntityInstance entityInstance2 = this.getDrawRoot();
        Enumeration enumeration = entityInstance.srcRelationElements();
        while (enumeration.hasMoreElements()) {
            RelationInstance relationInstance = (RelationInstance)enumeration.nextElement();
            EntityInstance entityInstance3 = relationInstance.getDst();
            boolean bl2 = entityInstance3.isMarked(32768);
            relationInstance.setHighlightFlag();
            if (vector.indexOf(relationInstance) < 0) {
                vector.addElement(relationInstance);
            }
            if (bl2) continue;
            entityInstance3.setRedBoxFlag();
            if (bl) {
                entityInstance3.setGroupFlag();
            }
            this.getSrcRelationWithClosure(entityInstance3, vector, bl);
        }
    }

    protected int addRelations(EntityInstance entityInstance, RelationClass relationClass, Vector vector, ResultBox resultBox, boolean bl) {
        int n = 0;
        if (vector.size() > 0) {
            Vector<RelationInstance> vector2 = new Vector<RelationInstance>();
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                RelationInstance relationInstance = (RelationInstance)enumeration.nextElement();
                if (relationInstance.getRelationClass() != relationClass) continue;
                relationInstance.setHighlightFlag();
                vector2.add(relationInstance);
                ++n;
            }
            if (n > 0) {
                resultBox.addRelations(entityInstance, relationClass, vector2, bl);
            }
        }
        return n;
    }

    protected int showSrcEdgesWithClosure(EntityInstance entityInstance, ResultBox resultBox, boolean bl) {
        Diagram diagram = this.getDiagram();
        Vector vector = new Vector();
        int n = 0;
        diagram.clearQueryFlags();
        this.getSrcRelationWithClosure(entityInstance, vector, bl);
        diagram.clearQueryFlags();
        Enumeration enumeration = diagram.enumRelationClasses();
        while (enumeration.hasMoreElements()) {
            RelationClass relationClass = (RelationClass)enumeration.nextElement();
            if (!relationClass.isActive()) continue;
            n += this.addRelations(entityInstance, relationClass, vector, resultBox, true);
        }
        return n;
    }

    protected void getDstRelationWithClosure(EntityInstance entityInstance, Vector vector, boolean bl) {
        Enumeration enumeration = entityInstance.dstRelationElements();
        while (enumeration.hasMoreElements()) {
            RelationInstance relationInstance = (RelationInstance)enumeration.nextElement();
            EntityInstance entityInstance2 = relationInstance.getSrc();
            boolean bl2 = entityInstance2.isMarked(32768);
            relationInstance.setHighlightFlag();
            if (vector.indexOf(relationInstance) < 0) {
                vector.addElement(relationInstance);
            }
            if (bl2) continue;
            entityInstance2.setRedBoxFlag();
            if (bl) {
                entityInstance2.setGroupFlag();
            }
            this.getDstRelationWithClosure(entityInstance2, vector, bl);
        }
    }

    protected int showDstEdgesWithClosure(EntityInstance entityInstance, ResultBox resultBox, boolean bl) {
        Vector vector = new Vector();
        Diagram diagram = this.getDiagram();
        int n = 0;
        this.clearQueryFlags();
        this.getDstRelationWithClosure(entityInstance, vector, bl);
        this.clearQueryFlags();
        Enumeration enumeration = diagram.enumRelationClasses();
        while (enumeration.hasMoreElements()) {
            RelationClass relationClass = (RelationClass)enumeration.nextElement();
            if (!relationClass.isActive()) continue;
            n += this.addRelations(entityInstance, relationClass, vector, resultBox, false);
        }
        return n;
    }

    protected int showContents(EntityInstance entityInstance, ResultBox resultBox) {
        Vector vector = new Vector();
        int n = 0;
        Enumeration enumeration = entityInstance.getChildren();
        while (enumeration.hasMoreElements()) {
            vector.add(enumeration.nextElement());
            ++n;
        }
        if (n > 0) {
            SortVector.byString(vector);
        }
        resultBox.addContents(entityInstance, vector);
        return n;
    }

    protected int showContentsWithClosure(EntityInstance entityInstance, ResultBox resultBox) {
        int n = this.showContents(entityInstance, resultBox);
        Enumeration enumeration = entityInstance.getChildren();
        while (enumeration.hasMoreElements()) {
            n += this.showContentsWithClosure((EntityInstance)enumeration.nextElement(), resultBox);
        }
        return n;
    }

    protected int doQueryEntity(EntityInstance entityInstance, int n, ResultBox resultBox, boolean bl) {
        switch (n) {
            case 102: {
                return this.showForwardEdges(entityInstance, resultBox, bl);
            }
            case 98: {
                return this.showBackEdges(entityInstance, resultBox, bl);
            }
            case 70: {
                return this.showSrcEdgesWithClosure(entityInstance, resultBox, bl);
            }
            case 66: {
                return this.showDstEdgesWithClosure(entityInstance, resultBox, bl);
            }
            case 67: {
                return this.showContents(entityInstance, resultBox);
            }
            case 65: {
                return this.showContentsWithClosure(entityInstance, resultBox);
            }
        }
        return 0;
    }

    public void queryEntity(int n, Object object, ResultBox resultBox, boolean bl) {
        String string;
        EntityInstance entityInstance;
        Enumeration enumeration;
        int n2;
        String string2;
        Vector vector = this.targetEntities(object);
        if (!this.getQueryPersistance()) {
            this.clearQueryFlags();
        }
        switch (n) {
            case 98: 
            case 102: {
                string2 = n == 102 ? "FORWARD QUERY" : "BACKWARD QUERY";
                n2 = 0;
                if (vector != null) {
                    enumeration = vector.elements();
                    while (enumeration.hasMoreElements()) {
                        entityInstance = (EntityInstance)enumeration.nextElement();
                        if (entityInstance.isMarked(6)) {
                            n2 |= 2;
                            continue;
                        }
                        n2 |= 1;
                    }
                }
                switch (n2) {
                    case 2: {
                        string2 = string2 + " IN DIAGRAM";
                        break;
                    }
                    case 3: {
                        string2 = string2 + " IN DIAGRAM WHEN CLIENT/SUPPLIER";
                    }
                }
                break;
            }
            case 70: {
                string2 = "FORWARD QUERY (closure)";
                break;
            }
            case 66: {
                string2 = "BACKWARD QUERY (closure)";
                break;
            }
            default: {
                string2 = null;
            }
        }
        resultBox.setResultTitle(string2);
        if (vector == null || vector.isEmpty()) {
            string = "No entity or group is selected";
            this.m_ls.error(string);
        } else {
            n2 = 0;
            enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                entityInstance = (EntityInstance)enumeration.nextElement();
                n2 += this.doQueryEntity(entityInstance, n, resultBox, bl);
            }
            string = n2 == 0 ? "NO ENTITIES" : "-- End of Query --";
            this.clearDrawEdges();
        }
        resultBox.done(string);
    }

    protected void queryContents(int n, ResultBox resultBox, boolean bl) {
        String string;
        Vector vector = this.getGroup();
        switch (n) {
            case 65: {
                string = "CONTENTS (CLOSURE)";
                break;
            }
            case 67: {
                string = "CONTENTS";
                break;
            }
            default: {
                string = null;
            }
        }
        resultBox.setResultTitle(string);
        String string2 = "-- End of content --";
        if (vector == null || vector.isEmpty()) {
            this.doQueryEntity(this.getDrawRoot(), n, resultBox, bl);
        } else {
            int n2 = 0;
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                EntityInstance entityInstance = (EntityInstance)enumeration.nextElement();
                n2 += this.doQueryEntity(entityInstance, n, resultBox, bl);
            }
            if (n2 == 0) {
                string2 = "NO ENTITIES";
            }
        }
        resultBox.done(string2);
    }

    public void containsClassChanging() {
        RelationClass relationClass = this.getContainsClass();
        LandscapeEditorCore landscapeEditorCore = this.getLs();
        Vector vector = null;
        if (relationClass != null && this.m_ls.isFocusAncestor()) {
            vector = this.getGroup();
            if (vector == null) {
                vector = new Vector();
            }
            if (vector.size() == 0) {
                Enumeration enumeration = this.m_drawRoot.getChildren();
                while (enumeration.hasMoreElements()) {
                    vector.add(enumeration.nextElement());
                }
                if (vector.size() == 0) {
                    vector = null;
                }
            }
        }
        this.m_oldChildren = vector;
    }

    public void containsClassChanged() {
        Vector vector = this.m_oldChildren;
        if (vector != null) {
            EntityInstance entityInstance;
            EntityInstance entityInstance2;
            for (entityInstance2 = entityInstance = this.getDrawRoot(); entityInstance2 != null && !entityInstance2.hasDescendantsOrSelf(vector); entityInstance2 = entityInstance2.getContainedBy()) {
            }
            if (entityInstance2 != entityInstance && entityInstance2 != null) {
                this.navigateTo(entityInstance2);
            }
            this.m_oldChildren = null;
        }
        this.redrawDiagram();
    }

    public boolean newEntityClass() {
        String string = "Enter new entry class name";
        String string2;
        while ((string2 = JOptionPane.showInputDialog(string)) != null) {
            EntityClass entityClass = this.getEntityClass(string2);
            if (entityClass == null) {
                entityClass = this.addEntityClass(string2);
                entityClass.addParentClass(this.m_entityBaseClass);
                return true;
            }
            string = string2 + " in use. Enter new name";
        }
        return false;
    }

    public RelationClass newRelationClass() {
        String string = "Enter new relation class name";
        String string2;
        while ((string2 = JOptionPane.showInputDialog(string)) != null) {
            if ((string2 = string2.trim()) == null) {
                return null;
            }
            RelationClass relationClass = this.getRelationClass(string2);
            if (relationClass == null) {
                relationClass = this.addRelationClass(string2);
                relationClass.addParentClass(this.m_relationBaseClass);
                return relationClass;
            }
            string = string2 + " in use. Enter new name";
        }
        return null;
    }

    public void alsoValidateSubclasses(Vector vector, String string) {
        String string2;
        int n = vector.size();
        switch (n) {
            case 1: {
                return;
            }
            case 2: {
                LandscapeClassObject landscapeClassObject = (LandscapeClassObject)vector.elementAt(1);
                string2 = "Also validate subclass " + landscapeClassObject.getLabel();
                break;
            }
            default: {
                LandscapeClassObject landscapeClassObject = (LandscapeClassObject)vector.elementAt(1);
                string2 = "Also validate subclasses " + landscapeClassObject.getLabel();
                int n2 = 2;
                while (n2 < n) {
                    landscapeClassObject = (LandscapeClassObject)vector.elementAt(n2);
                    string2 = ++n2 == n ? string2 + " and " : string2 + ", ";
                    string2 = string2 + landscapeClassObject.getLabel();
                }
                break block0;
            }
        }
        LandscapeClassObject landscapeClassObject = (LandscapeClassObject)vector.elementAt(0);
        switch (JOptionPane.showConfirmDialog(null, string2, "Validating " + landscapeClassObject.getLabel() + string, 1)) {
            case 0: {
                break;
            }
            case 1: {
                vector.removeAllElements();
                vector.add(landscapeClassObject);
                break;
            }
            default: {
                vector.removeAllElements();
            }
        }
    }

    public void showValidAttributes(LandscapeClassObject landscapeClassObject, ResultBox resultBox) {
        resultBox.addResultTitle("Valid attributes of " + landscapeClassObject.getLabel());
        resultBox.activate();
        Vector vector = landscapeClassObject.getValidAttributes();
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            Attribute attribute = (Attribute)vector.elementAt(i);
            resultBox.addResultAttribute(attribute);
        }
        resultBox.addResultTitle("Lsedit class attributes");
        landscapeClassObject.reportClassAttributes(resultBox);
        resultBox.addResultTitle("Lsedit first order attributes");
        if (landscapeClassObject instanceof EntityClass) {
            EntityInstance.reportFirstOrderAttributes(resultBox);
        } else {
            RelationInstance.reportFirstOrderAttributes(resultBox);
        }
        resultBox.done("End of report");
    }

    public void validateEntityAttributes(EntityClass entityClass, ResultBox resultBox, boolean bl) {
        String string;
        int n;
        Vector vector = this.getClassAndSubclasses(entityClass);
        if (bl) {
            this.alsoValidateSubclasses(vector, " attributes");
            if (vector.size() == 0) {
                return;
            }
        }
        Vector[] vectorArray = new Vector[vector.size()];
        resultBox.addResultTitle("Validating attributes of " + entityClass.getLabel() + (vector.size() <= 1 ? "" : " and subclasses") + (this.m_drawRoot == this.m_rootInstance ? "" : " under " + this.m_drawRoot.getEntityLabel()));
        resultBox.activate();
        if (this.m_drawRoot != this.m_rootInstance) {
            n = this.m_drawRoot.validateEntityAttributes(vector, vectorArray, resultBox);
        } else {
            n = 0;
            Enumeration enumeration = this.m_rootInstance.getChildren();
            while (enumeration.hasMoreElements()) {
                EntityInstance entityInstance = (EntityInstance)enumeration.nextElement();
                n += entityInstance.validateEntityAttributes(vector, vectorArray, resultBox);
            }
        }
        switch (n) {
            case 0: {
                string = "No errors";
                break;
            }
            case 1: {
                string = "1 erroneous entity encountered during validation";
                break;
            }
            default: {
                string = n + " erroneous entities encountered during validation";
            }
        }
        resultBox.done(string);
    }

    public void validateRelationAttributes(RelationClass relationClass, ResultBox resultBox, boolean bl) {
        String string;
        Vector vector = this.getClassAndSubclasses(relationClass);
        if (bl) {
            this.alsoValidateSubclasses(vector, " attributes");
            if (vector.size() == 0) {
                return;
            }
        }
        Vector[] vectorArray = new Vector[vector.size()];
        resultBox.addResultTitle("Validating attributes of " + relationClass.getLabel() + (vector.size() <= 1 ? "" : " and subclasses") + (this.m_drawRoot == this.m_rootInstance ? "" : " under " + this.m_drawRoot.getEntityLabel()));
        resultBox.activate();
        int n = this.m_drawRoot.validateRelationAttributes(vector, vectorArray, resultBox);
        switch (n) {
            case 0: {
                string = "No errors";
                break;
            }
            case 1: {
                string = "1 erroneous relation encountered during validation";
                break;
            }
            default: {
                string = n + " erroneous relations encountered during validation";
            }
        }
        resultBox.done(string);
    }

    public void validateRelations(RelationClass relationClass, ResultBox resultBox, boolean bl) {
        String string;
        Vector vector = relationClass.getClassAndSubclasses(this.m_relationClasses);
        if (bl) {
            this.alsoValidateSubclasses(vector, " constraints");
            if (vector.size() == 0) {
                return;
            }
        }
        boolean[][][] blArrayArray = new boolean[vector.size()][][];
        resultBox.addResultTitle("Validating " + relationClass.getLabel() + " relations" + (vector.size() <= 1 ? "" : " and subclasses") + (this.m_drawRoot == this.m_rootInstance ? "" : " under " + this.m_drawRoot.getEntityLabel()));
        resultBox.activate();
        this.m_drawRoot.clearValidatedMark();
        int n = this.m_drawRoot.validateRelations(vector, blArrayArray, resultBox, this.m_rootInstance);
        switch (n) {
            case 0: {
                string = "No errors";
                break;
            }
            case 1: {
                string = "1 erroneous relation encountered during validation";
                break;
            }
            default: {
                string = n + " erroneous relations encountered during validation";
            }
        }
        resultBox.done(string);
    }

    public void validateAll(ResultBox resultBox) {
        this.validateEntityAttributes(this.m_entityBaseClass, resultBox, false);
        this.validateRelationAttributes(this.m_relationBaseClass, resultBox, false);
        this.validateRelations(this.m_relationBaseClass, resultBox, false);
    }

    public void entityPressed(MouseEvent mouseEvent, EntityInstance entityInstance, int n, int n2) {
        EditModeHandler editModeHandler = this.m_ls.getModeHandler();
        this.m_ls.showDescription(entityInstance, true);
        ((LandscapeModeHandler)editModeHandler).entityPressed(mouseEvent, entityInstance, n, n2);
    }

    public void entityDragged(MouseEvent mouseEvent, EntityInstance entityInstance, int n, int n2) {
        EditModeHandler editModeHandler = this.m_ls.getModeHandler();
        ((LandscapeModeHandler)editModeHandler).entityDragged(mouseEvent, entityInstance, n, n2);
    }

    public void entityReleased(MouseEvent mouseEvent, EntityInstance entityInstance, int n, int n2) {
        EditModeHandler editModeHandler = this.m_ls.getModeHandler();
        ((LandscapeModeHandler)editModeHandler).entityReleased(mouseEvent, entityInstance, n, n2);
        if (n2 > 0) {
            this.m_ls.toolButton[0].requestFocus();
            this.m_ls.requestFocus();
        }
    }

    public void relationPressed(MouseEvent mouseEvent, RelationInstance relationInstance, int n, int n2) {
        EditModeHandler editModeHandler = this.m_ls.getModeHandler();
        this.m_ls.showDescription(relationInstance, true);
        ((LandscapeModeHandler)editModeHandler).relationPressed(mouseEvent, relationInstance, n, n2);
    }

    public void relationDragged(MouseEvent mouseEvent, RelationInstance relationInstance, int n, int n2) {
        EditModeHandler editModeHandler = this.m_ls.getModeHandler();
        ((LandscapeModeHandler)editModeHandler).relationDragged(mouseEvent, relationInstance, n, n2);
    }

    public void relationReleased(MouseEvent mouseEvent, RelationInstance relationInstance, int n, int n2) {
        EditModeHandler editModeHandler = this.m_ls.getModeHandler();
        ((LandscapeModeHandler)editModeHandler).relationReleased(mouseEvent, relationInstance, n, n2);
        if (n2 > 0) {
            this.m_ls.toolButton[0].requestFocus();
            this.m_ls.requestFocus();
        }
    }

    public void movedOverThing(MouseEvent mouseEvent, Object object, int n, int n2) {
        EditModeHandler editModeHandler = this.m_ls.getModeHandler();
        ((LandscapeModeHandler)editModeHandler).movedOverThing(mouseEvent, object, n, n2);
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        this.movedOverThing(mouseEvent, this, mouseEvent.getX(), mouseEvent.getY());
    }

    public int getDiagramX() {
        return 0;
    }

    public int getDiagramY() {
        return 0;
    }

    public class RelayoutDialog
    extends JDialog
    implements ActionListener {
        LandscapeLayouter[] m_layouters;
        protected ButtonGroup m_buttonGroup;
        protected JRadioButton[] m_radioButtons;
        protected JButton[] m_buttons;
        protected JButton m_ok;
        protected JButton m_cancel;
        protected String m_msg;

        public RelayoutDialog() {
            int n;
            super(Diagram.this.m_ls.getFrame(), "Reconfigure layouters", true);
            this.m_msg = null;
            this.m_layouters = Diagram.this.m_ls.getLayouters();
            int n2 = this.m_layouters.length;
            LandscapeLayouter landscapeLayouter = Diagram.this.m_ls.getLayouter();
            Font font = FontCache.getDialogFont();
            Font font2 = font.deriveFont(1);
            int n3 = Diagram.this.getX() + 20;
            int n4 = Diagram.this.getY() + 20;
            this.setLocation(n3, n4);
            this.setForeground(ColorCache.get(0, 0, 0));
            this.setBackground(ColorCache.get(192, 192, 192));
            this.setFont(font);
            Container container = this.getContentPane();
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new GridLayout(n2, 1, 10, 10));
            this.m_buttonGroup = new ButtonGroup();
            this.m_radioButtons = new JRadioButton[n2];
            this.m_buttons = new JButton[n2];
            for (n = 0; n < n2; ++n) {
                JRadioButton jRadioButton;
                this.m_radioButtons[n] = jRadioButton = new JRadioButton(this.m_layouters[n].getMenuLabel());
                jRadioButton.setFont(font2);
                if (!this.m_layouters[n].isLayouter()) {
                    jRadioButton.setEnabled(false);
                } else {
                    if (this.m_layouters[n] == landscapeLayouter) {
                        jRadioButton.setSelected(true);
                    }
                    this.m_buttonGroup.add(jRadioButton);
                }
                jPanel.add(jRadioButton);
            }
            container.add((Component)jPanel, "West");
            jPanel = new JPanel();
            jPanel.setLayout(new GridLayout(n2, 1, 10, 10));
            for (n = 0; n < n2; ++n) {
                JButton jButton = this.m_layouters[n].isConfigurable() ? new JButton("configure") : new JButton("");
                this.m_buttons[n] = jButton;
                jPanel.add(jButton);
                jButton.addActionListener(this);
            }
            container.add((Component)jPanel, "East");
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new FlowLayout());
            this.m_ok = new JButton("Relayout subtree " + Diagram.this.m_drawRoot);
            jPanel2.add(this.m_ok);
            this.m_ok.addActionListener(this);
            this.m_cancel = new JButton("Don't Relayout");
            jPanel2.add(this.m_cancel);
            this.m_cancel.addActionListener(this);
            container.add((Component)jPanel2, "South");
            this.pack();
            this.setVisible(true);
        }

        public String msg() {
            return this.m_msg;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            int n = this.m_radioButtons.length;
            if (object == this.m_ok || object == this.m_cancel) {
                for (int i = 0; i < n; ++i) {
                    JRadioButton jRadioButton = this.m_radioButtons[i];
                    if (jRadioButton == null || !jRadioButton.isSelected()) continue;
                    Diagram.this.m_ls.defaultToLayouter(i);
                    if (object != this.m_ok) break;
                    Diagram.this.doRelayoutAll();
                    this.m_msg = "Prior graph layout deleted";
                    break;
                }
                this.setVisible(false);
                return;
            }
            for (int i = 0; i < n; ++i) {
                if (object != this.m_buttons[i]) continue;
                if (this.m_radioButtons[i].isEnabled()) {
                    this.m_radioButtons[i].setSelected(true);
                }
                this.m_layouters[i].configure(Diagram.this.m_ls);
                return;
            }
        }
    }

    class RelayoutSubtree
    extends MyUndoableEdit
    implements UndoableEdit {
        EntityInstance[] m_entities;
        double[] m_xRel;
        double[] m_yRel;
        double[] m_widthRel;
        double[] m_heightRel;
        LandscapeLayouter m_layouter;

        protected void saveInfo(EntityInstance entityInstance, int n) {
            int n2 = entityInstance.getPreorder() - n;
            this.m_entities[n2] = entityInstance;
            this.m_xRel[n2] = entityInstance.xRelLocal();
            this.m_yRel[n2] = entityInstance.yRelLocal();
            this.m_widthRel[n2] = entityInstance.widthRelLocal();
            this.m_heightRel[n2] = entityInstance.heightRelLocal();
            Enumeration enumeration = entityInstance.getChildren();
            while (enumeration.hasMoreElements()) {
                EntityInstance entityInstance2 = (EntityInstance)enumeration.nextElement();
                this.saveInfo(entityInstance2, n);
            }
        }

        RelayoutSubtree(EntityInstance entityInstance) {
            int n = entityInstance.nodesInSubtree();
            this.m_entities = new EntityInstance[n];
            this.m_xRel = new double[n];
            this.m_yRel = new double[n];
            this.m_widthRel = new double[n];
            this.m_heightRel = new double[n];
            this.m_layouter = Diagram.this.m_ls.getLayouter();
            this.saveInfo(entityInstance, entityInstance.getPreorder());
            Diagram.this.logEdit(this);
        }

        public String getPresentationName() {
            return "Relayout subtree " + this.m_entities[0];
        }

        public void undo() {
            EntityInstance[] entityInstanceArray = this.m_entities;
            double[] dArray = this.m_xRel;
            double[] dArray2 = this.m_yRel;
            double[] dArray3 = this.m_widthRel;
            double[] dArray4 = this.m_heightRel;
            int n = entityInstanceArray.length;
            for (int i = 1; i < n; ++i) {
                EntityInstance entityInstance = entityInstanceArray[i];
                if (entityInstance == null) continue;
                entityInstance.setRelLocal(dArray[i], dArray2[i], dArray3[i], dArray4[i]);
            }
            Diagram.this.m_ls.setLayouter(this.m_layouter);
            Diagram.this.redrawDiagram();
        }

        public void redo() {
            EntityInstance[] entityInstanceArray = this.m_entities;
            double[] dArray = this.m_xRel;
            double[] dArray2 = this.m_yRel;
            double[] dArray3 = this.m_widthRel;
            double[] dArray4 = this.m_heightRel;
            int n = entityInstanceArray.length;
            for (int i = 1; i < n; ++i) {
                EntityInstance entityInstance = entityInstanceArray[i];
                if (entityInstance == null) continue;
                entityInstance.setRelLocal(-1.0, -1.0, dArray3[i], dArray4[i]);
            }
            Diagram.this.m_ls.setLayouter(this.m_layouter);
            Diagram.this.redrawDiagram();
        }
    }

    class Zoom
    extends MyUndoableEdit
    implements UndoableEdit {
        double m_oldX;
        double m_oldY;
        double m_newX;
        double m_newY;

        Zoom(double d, double d2) {
            this.m_oldX = d;
            this.m_oldY = d2;
            this.m_newX = Diagram.this.m_zoom_x;
            this.m_newY = Diagram.this.m_zoom_y;
            Diagram.this.logEdit(this);
        }

        public String getPresentationName() {
            return " Zoom diagram";
        }

        public void undo() {
            Diagram.this.setZoom(this.m_oldX, this.m_oldY);
        }

        public void redo() {
            Diagram.this.setZoom(this.m_newX, this.m_newY);
        }
    }

    class SetNewGridDialog
    extends JDialog
    implements ChangeListener,
    ActionListener {
        JFrame m_frame;
        JSlider m_gridSlider;
        GridImage m_gridImage;
        JLabel m_feedback;
        JButton m_color;

        public SetNewGridDialog(JFrame jFrame) {
            JSlider jSlider;
            super(jFrame, "Set grid size", true);
            Container container = this.getContentPane();
            this.m_frame = jFrame;
            Font font = FontCache.getDialogFont();
            Font font2 = font.deriveFont(1);
            JLabel jLabel = new JLabel("Grid size when moving entities", 0);
            jLabel.setAlignmentX(0.5f);
            jLabel.setFont(font2);
            JLabel jLabel2 = new JLabel("Current grid size " + Diagram.getGrid(), 0);
            jLabel2.setAlignmentX(0.5f);
            jLabel2.setFont(font);
            jLabel2.setForeground(Color.BLUE);
            this.m_feedback = jLabel2;
            this.m_gridImage = new GridImage();
            this.m_gridSlider = jSlider = new JSlider(0, 0, 100, m_gridPixels);
            jSlider.addChangeListener(this);
            jSlider.setMajorTickSpacing(10);
            jSlider.setMinorTickSpacing(2);
            jSlider.setPaintTicks(true);
            jSlider.setPaintLabels(true);
            jSlider.setFont(font);
            jSlider.setPreferredSize(new Dimension(400, 50));
            jSlider.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BorderLayout());
            jPanel.add((Component)jLabel2, "North");
            jPanel.add((Component)this.m_gridImage, "Center");
            this.m_color = new JButton("Colour");
            this.m_color.addActionListener(this);
            jPanel.add((Component)this.m_color, "South");
            container.add((Component)jLabel, "North");
            container.add((Component)jSlider, "Center");
            container.add((Component)jPanel, "South");
            if (jFrame != null) {
                this.setLocation(jFrame.getX() + 200, jFrame.getY() + 300);
            }
            this.pack();
            this.setVisible(true);
        }

        public void finished() {
            this.m_gridSlider = null;
            this.m_gridImage = null;
            this.m_feedback = null;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == this.m_color) {
                ColorChooser colorChooser = new ColorChooser(this.m_frame, "Pick a grid color", m_gridColor, true, false);
                m_gridColor = colorChooser.getColor();
                colorChooser.dispose();
                this.m_feedback.setText("Color changed");
                this.m_gridImage.repaint();
                if (Diagram.this.m_ls.isShowGrid()) {
                    Diagram.this.repaint();
                }
            }
        }

        public void stateChanged(ChangeEvent changeEvent) {
            Object object = changeEvent.getSource();
            if (object == this.m_gridSlider) {
                int n = this.m_gridSlider.getValue();
                if (n < 1) {
                    n = 1;
                }
                Diagram.setGrid(n);
                this.m_feedback.setText("Grid size set to " + n);
                this.m_gridImage.repaint();
            }
        }

        class GridImage
        extends JComponent {
            public GridImage() {
                this.setPreferredSize(new Dimension(400, 100));
            }

            public void paintComponent(Graphics graphics) {
                int n = Diagram.getGrid();
                int n2 = this.getWidth();
                int n3 = this.getHeight();
                graphics.drawRect(0, 0, n2 - 1, n3 - 1);
                if (n > 1) {
                    int n4;
                    Color color = m_gridColor;
                    Color color2 = ColorCache.getInverse(color.getRGB());
                    graphics.setColor(color2);
                    graphics.fillRect(1, 1, n2 - 2, n2 - 2);
                    graphics.setColor(color);
                    for (n4 = n; n4 < n3; n4 += n) {
                        graphics.drawLine(0, n4, n2 - 1, n4);
                    }
                    for (n4 = n; n4 < n2; n4 += n) {
                        graphics.drawLine(n4, 0, n4, n3 - 1);
                    }
                }
            }
        }
    }

    class ExitFlag
    extends JComponent
    implements MouseListener {
        protected static final int EXIT_FLAG_DIM = 8;
        protected int m_priorcursor = -1;

        public ExitFlag() {
            this.addMouseListener(this);
        }

        public void setLocation(int n, int n2) {
            this.setBounds(n, n2, 8, 8);
        }

        public void activate() {
            this.setVisible(true);
        }

        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            graphics.setColor(boxColor.darker());
            graphics.drawRect(0, 0, 8, 8);
            graphics.drawLine(2, 4, 6, 4);
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (this.m_priorcursor != -1) {
                Diagram.this.getLs().setCursor(this.m_priorcursor);
                this.m_priorcursor = -1;
            }
            Diagram.this.navigateToDrawRootParent();
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            this.m_priorcursor = Diagram.this.getLs().setCursor(12);
        }

        public void mouseExited(MouseEvent mouseEvent) {
            if (this.m_priorcursor != -1) {
                Diagram.this.getLs().setCursor(this.m_priorcursor);
                this.m_priorcursor = -1;
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }
    }
}

