/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import lsedit.ColorCache;
import lsedit.Diagram;
import lsedit.EntityClass;
import lsedit.EntityClassPair;
import lsedit.FontCache;
import lsedit.LandscapeEditorCore;
import lsedit.RelationClass;

public class EditConstraints
extends JDialog
implements ActionListener {
    RelationClass m_rc;
    private JButton m_ok = null;
    private JButton m_restart = null;
    private JButton m_clear = null;
    private JButton m_cancel = null;
    EntityClass[] m_ecs;
    JCheckBox[][] m_array;
    int m_size;

    protected void clearArray() {
        int n = this.m_size;
        JCheckBox[][] jCheckBoxArray = this.m_array;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                this.m_array[i][j].setSelected(false);
            }
        }
    }

    protected void initArray() {
        int n = this.m_size;
        JCheckBox[][] jCheckBoxArray = this.m_array;
        this.clearArray();
        Vector vector = this.m_rc.getRelationList();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            EntityClassPair entityClassPair = (EntityClassPair)enumeration.nextElement();
            this.m_array[entityClassPair.m_entityClass1.getOrderedId()][entityClassPair.m_entityClass2.getOrderedId()].setSelected(true);
        }
    }

    protected void processArray() {
        Vector vector = this.m_rc.getRelationList();
        int n = vector.size();
        while (n > 0) {
            EntityClassPair entityClassPair = (EntityClassPair)vector.elementAt(--n);
            if (this.m_array[entityClassPair.m_entityClass1.getOrderedId()][entityClassPair.m_entityClass2.getOrderedId()].isSelected()) continue;
            vector.removeElementAt(n);
        }
        int n2 = this.m_size;
        for (n = 0; n < n2; ++n) {
            for (int i = 0; i < n2; ++i) {
                if (!this.m_array[n][i].isSelected()) continue;
                this.m_rc.addRelation(this.m_ecs[n], this.m_ecs[i]);
            }
        }
    }

    protected EditConstraints(JFrame jFrame, Diagram diagram, RelationClass relationClass) {
        super(jFrame, "Edit Constraints on " + relationClass.getLabel(), true);
        int n;
        int n2;
        Font font = FontCache.getDialogFont();
        Font font2 = font.deriveFont(1);
        this.m_rc = relationClass;
        this.m_size = n2 = diagram.numEntityClasses();
        this.m_ecs = new EntityClass[n2];
        int n3 = 0;
        Enumeration enumeration = diagram.enumEntityClassesInOrder();
        while (enumeration.hasMoreElements()) {
            EntityClass entityClass = (EntityClass)enumeration.nextElement();
            entityClass.setOrderedId(n3);
            this.m_ecs[n3] = entityClass;
            ++n3;
        }
        this.m_array = new JCheckBox[n2][];
        for (n3 = 0; n3 < n2; ++n3) {
            this.m_array[n3] = new JCheckBox[n2];
            for (n = 0; n < n2; ++n) {
                JCheckBox jCheckBox = new JCheckBox();
                jCheckBox.setFont(font);
                jCheckBox.setToolTipText(this.m_ecs[n3].getLabel() + "->" + this.m_ecs[n].getLabel());
                this.m_array[n3][n] = jCheckBox;
            }
        }
        this.initArray();
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        this.setForeground(ColorCache.get(0, 0, 0));
        this.setBackground(ColorCache.get(192, 192, 192));
        this.setFont(font);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(0, n2 + 1));
        JLabel jLabel = new JLabel("");
        jPanel.add(jLabel);
        for (n3 = 0; n3 < n2; ++n3) {
            jLabel = new JLabel(this.m_ecs[n3].getLabel());
            jLabel.setFont(font2);
            jPanel.add(jLabel);
        }
        for (n3 = 0; n3 < n2; ++n3) {
            jLabel = new JLabel(this.m_ecs[n3].getLabel() + " ");
            jLabel.setFont(font2);
            jPanel.add(jLabel);
            for (n = 0; n < n2; ++n) {
                jPanel.add(this.m_array[n3][n]);
            }
        }
        JScrollPane jScrollPane = new JScrollPane(jPanel);
        jScrollPane.setVisible(true);
        container.add((Component)jScrollPane, "Center");
        jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout());
        this.m_ok = new JButton("Ok");
        this.m_ok.setFont(font2);
        this.m_ok.addActionListener(this);
        jPanel.add(this.m_ok);
        this.m_restart = new JButton("Restart");
        this.m_restart.setFont(font2);
        this.m_restart.addActionListener(this);
        jPanel.add(this.m_restart);
        this.m_clear = new JButton("Clear");
        this.m_clear.setFont(font2);
        this.m_clear.addActionListener(this);
        jPanel.add(this.m_clear);
        this.m_cancel = new JButton("Cancel");
        this.m_cancel.setFont(font2);
        this.m_cancel.addActionListener(this);
        jPanel.add(this.m_cancel);
        container.add((Component)jPanel, "South");
        this.pack();
        this.setVisible(true);
    }

    public static void create(Diagram diagram, RelationClass relationClass) {
        LandscapeEditorCore landscapeEditorCore = diagram.getLs();
        EditConstraints editConstraints = new EditConstraints(landscapeEditorCore.getFrame(), diagram, relationClass);
        editConstraints.dispose();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.m_restart) {
            this.initArray();
            return;
        }
        if (object == this.m_clear) {
            this.clearArray();
            return;
        }
        if (object == this.m_ok) {
            this.processArray();
        } else if (object != this.m_cancel) {
            return;
        }
        this.setVisible(false);
    }
}

