/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.util.Enumeration;
import java.util.Vector;
import lsedit.Clipboard;
import lsedit.ClipboardEnumerator;
import lsedit.Diagram;
import lsedit.EntityClass;
import lsedit.EntityClassPair;
import lsedit.EntityInstance;
import lsedit.NoTaListener;
import lsedit.RelationClass;
import lsedit.RelationInstance;
import lsedit.Ta;
import lsedit.TaFeedback;
import lsedit.TaListener;

public class EditableTa
extends Ta {
    protected static TaListener m_noTaListener = null;
    protected TaListener m_taListener;
    protected Diagram m_diagram;

    public EditableTa(TaListener taListener, TaFeedback taFeedback) {
        super(taFeedback);
        if (taListener == null) {
            if (m_noTaListener == null) {
                m_noTaListener = new NoTaListener();
            }
            taListener = m_noTaListener;
        }
        this.m_taListener = taListener;
    }

    public void setDiagram(Diagram diagram) {
        this.m_diagram = diagram;
    }

    public void removeEntitiesFromCache() {
        int n;
        EntityInstance entityInstance = this.m_rootInstance;
        if (entityInstance != null) {
            entityInstance.removeTreeFromCache(this.m_entityCache);
        }
        if ((n = this.m_entityCache.size()) != 0) {
            System.out.println("Diagram.removeEntitiesFromCache failed count=" + n);
            this.m_entityCache.show();
        }
    }

    public void addEntitiesToCache() {
        this.m_rootInstance.addTreeToCache(this.m_entityCache);
    }

    public void setInitialLocation(EntityInstance entityInstance, EntityInstance entityInstance2) {
        int n = entityInstance2.getWidth();
        int n2 = entityInstance2.getHeight();
        entityInstance.setInitialLocation(entityInstance2);
        entityInstance.resize(n, n2);
        entityInstance.relocate(entityInstance2.getDiagramX(), entityInstance2.getDiagramY(), n, n2);
    }

    public EntityInstance getNewEntity(EntityClass entityClass, EntityInstance entityInstance) {
        String string;
        int n = 0;
        while (this.entityExists(string = "Entity#" + n)) {
            ++n;
        }
        if (entityClass == null && (entityClass = this.m_defaultEntityClass) == null) {
            entityClass = this.m_entityBaseClass;
        }
        EntityInstance entityInstance2 = entityClass.newEntity(string);
        this.putCache(entityInstance2);
        this.addEdge(entityInstance, entityInstance2, this.getContainsClass());
        this.prepostorder();
        this.m_taListener.entityPasted(entityInstance2);
        return entityInstance2;
    }

    public void markDeleted(EntityInstance entityInstance) {
        this.removeCache(entityInstance);
        entityInstance.markDeleted();
    }

    public void clearDeleted(EntityInstance entityInstance) {
        entityInstance.clearDeleted();
        this.putCache(entityInstance);
    }

    public void disconnectEdges(EntityInstance entityInstance, EntityInstance entityInstance2) {
        EntityInstance entityInstance3;
        RelationInstance relationInstance;
        this.markDeleted(entityInstance);
        Enumeration enumeration = entityInstance.srcRelationElements();
        while (enumeration.hasMoreElements()) {
            relationInstance = (RelationInstance)enumeration.nextElement();
            entityInstance3 = relationInstance.getDst();
            if (entityInstance2.hasDescendantOrSelf(entityInstance3)) continue;
            entityInstance3.removeDstRelation(relationInstance);
        }
        enumeration = entityInstance.dstRelationElements();
        while (enumeration.hasMoreElements()) {
            relationInstance = (RelationInstance)enumeration.nextElement();
            entityInstance3 = relationInstance.getSrc();
            if (entityInstance2.hasDescendantOrSelf(entityInstance3)) continue;
            entityInstance3.removeSrcRelation(relationInstance);
        }
        enumeration = entityInstance.getChildren();
        while (enumeration.hasMoreElements()) {
            EntityInstance entityInstance4 = (EntityInstance)enumeration.nextElement();
            this.disconnectEdges(entityInstance4, entityInstance2);
        }
    }

    public void reconnectEdges(EntityInstance entityInstance) {
        EntityInstance entityInstance2;
        RelationInstance relationInstance;
        Enumeration enumeration = entityInstance.getChildren();
        while (enumeration.hasMoreElements()) {
            EntityInstance entityInstance3 = (EntityInstance)enumeration.nextElement();
            this.reconnectEdges(entityInstance3);
        }
        this.clearDeleted(entityInstance);
        enumeration = entityInstance.srcRelationElements();
        while (enumeration.hasMoreElements()) {
            relationInstance = (RelationInstance)enumeration.nextElement();
            entityInstance2 = relationInstance.getDst();
            entityInstance2.addDstRelationIfAbsent(relationInstance);
        }
        enumeration = entityInstance.dstRelationElements();
        while (enumeration.hasMoreElements()) {
            relationInstance = (RelationInstance)enumeration.nextElement();
            entityInstance2 = relationInstance.getSrc();
            entityInstance2.addSrcRelationIfAbsent(relationInstance);
        }
    }

    private EntityInstance disconnectEdgesJustMe(EntityInstance entityInstance) {
        EntityInstance entityInstance2;
        RelationInstance relationInstance;
        RelationClass relationClass = this.getContainsClass();
        EntityInstance entityInstance3 = null;
        entityInstance.nandMark(196608);
        Enumeration enumeration = entityInstance.dstRelationElements();
        while (enumeration.hasMoreElements()) {
            relationInstance = (RelationInstance)enumeration.nextElement();
            entityInstance2 = relationInstance.getSrc();
            if (entityInstance2 == entityInstance) continue;
            if (entityInstance3 == null && relationInstance.getRelationClass() == relationClass) {
                entityInstance3 = entityInstance2;
            }
            entityInstance2.removeSrcRelation(relationInstance);
        }
        enumeration = entityInstance.srcRelationElements();
        while (enumeration.hasMoreElements()) {
            relationInstance = (RelationInstance)enumeration.nextElement();
            entityInstance2 = relationInstance.getDst();
            if (entityInstance2 != entityInstance) {
                entityInstance2.removeDstRelation(relationInstance);
            }
            if (relationInstance.getRelationClass() != relationClass) continue;
            entityInstance2.setContainedBy(entityInstance3);
            if (entityInstance3 == null) continue;
            entityInstance3.addContainment(entityInstance2);
        }
        return entityInstance3;
    }

    private EntityInstance reconnectEdgesJustMe(EntityInstance entityInstance) {
        EntityInstance entityInstance2;
        EntityInstance entityInstance3;
        RelationInstance relationInstance;
        RelationClass relationClass = this.getContainsClass();
        Enumeration enumeration = entityInstance.srcRelationElements();
        while (enumeration.hasMoreElements()) {
            relationInstance = (RelationInstance)enumeration.nextElement();
            entityInstance3 = relationInstance.getDst();
            if (entityInstance3 == entityInstance) continue;
            if (relationInstance.getRelationClass() == relationClass) {
                RelationInstance relationInstance2 = entityInstance3.getContainedByRelation(relationClass);
                if (relationInstance2 != null) {
                    entityInstance2 = relationInstance2.getSrc();
                    entityInstance2.removeSrcRelation(relationInstance2);
                    entityInstance3.removeDstRelation(relationInstance2);
                    entityInstance2.removeContainment(entityInstance3);
                }
                entityInstance3.addDstRelation(relationInstance);
                entityInstance.addContainment(entityInstance3);
                continue;
            }
            entityInstance3.addDstRelation(relationInstance);
        }
        entityInstance2 = null;
        enumeration = entityInstance.dstRelationElements();
        while (enumeration.hasMoreElements()) {
            relationInstance = (RelationInstance)enumeration.nextElement();
            entityInstance3 = relationInstance.getSrc();
            if (entityInstance3 == entityInstance) continue;
            entityInstance3.addSrcRelation(relationInstance);
            if (relationInstance.getRelationClass() != relationClass) continue;
            entityInstance2 = entityInstance3;
            entityInstance2.addContainment(entityInstance);
        }
        return entityInstance2;
    }

    public boolean cutEntity(EntityInstance entityInstance) {
        if (entityInstance == this.m_rootInstance) {
            this.error("Can't cut the root node in the diagram");
            return false;
        }
        this.m_taListener.entityBeingMovedCut(entityInstance);
        EntityInstance entityInstance2 = entityInstance.getContainedBy();
        this.disconnectEdges(entityInstance, entityInstance);
        entityInstance2.removeContainment(entityInstance);
        this.m_taListener.entityCut(entityInstance);
        return true;
    }

    public boolean cutClipboard(Clipboard clipboard) {
        boolean bl;
        boolean bl2 = bl = !clipboard.contains(this.m_rootInstance);
        if (!bl) {
            this.error("Can't cut the root node in the diagram");
        } else {
            int n = clipboard.size();
            for (int i = 0; i < n; ++i) {
                EntityInstance entityInstance = (EntityInstance)clipboard.elementAt(i);
                this.cutEntity(entityInstance);
            }
            this.prepostorder();
            this.m_diagram.setClipboard(clipboard);
            this.m_diagram.redrawDiagram();
        }
        return bl;
    }

    public void pasteClipboard(Clipboard clipboard, EntityInstance entityInstance) {
        ClipboardEnumerator clipboardEnumerator = clipboard.clipboardElements();
        while (clipboardEnumerator.hasMoreElements()) {
            EntityInstance entityInstance2 = (EntityInstance)clipboardEnumerator.nextElement();
            this.pasteEntity(entityInstance, entityInstance2);
        }
        this.m_diagram.setClipboard(null);
        this.m_diagram.redrawDiagram();
    }

    public void pasteEntity(EntityInstance entityInstance, EntityInstance entityInstance2) {
        if (entityInstance == null) {
            Object var3_3 = null;
            entityInstance = entityInstance2.getContainedBy();
        } else {
            RelationInstance relationInstance = entityInstance2.getContainedByRelation(this.getContainsClass());
            relationInstance.setSrc(entityInstance);
        }
        this.reconnectEdges(entityInstance2);
        this.prepostorder();
        if (entityInstance != null) {
            entityInstance.addContainment(entityInstance2);
        }
        this.m_taListener.entityPasted(entityInstance2);
    }

    public boolean moveEntityContainment(EntityInstance entityInstance, EntityInstance entityInstance2) {
        EntityInstance entityInstance3 = entityInstance2.getContainedBy();
        if (entityInstance3 == entityInstance) {
            return false;
        }
        this.m_taListener.entityBeingMovedCut(entityInstance2);
        entityInstance3.removeContainment(entityInstance2);
        entityInstance2.setContainedBy(entityInstance);
        entityInstance.addContainment(entityInstance2);
        this.prepostorder();
        this.m_taListener.entityMoved(entityInstance2);
        return true;
    }

    public EntityInstance clusterEntity(EntityInstance entityInstance, EntityInstance entityInstance2) {
        String string;
        EntityClass entityClass = entityInstance2.getEntityClass();
        if (entityClass != null) {
            entityClass = this.getEntityClass(entityClass.getId());
        }
        if (entityClass == null && (entityClass = this.m_defaultEntityClass) == null) {
            entityClass = this.m_entityBaseClass;
        }
        if (this.entityExists(string = entityInstance2.getId())) {
            int n = 0;
            while (this.entityExists(string = "Entity#" + n)) {
                ++n;
            }
        }
        EntityInstance entityInstance3 = entityClass.newEntity(string);
        this.putCache(entityInstance3);
        this.addEdge(entityInstance, entityInstance3, this.getContainsClass());
        if (entityInstance2.xRelLocal() >= 0.0 && entityInstance2.yRelLocal() >= 0.0 && entityInstance2.widthRelLocal() > 0.0 && entityInstance2.heightRelLocal() > 0.0) {
            entityInstance3.setRelLocal(entityInstance2);
        }
        return entityInstance3;
    }

    public EntityInstance importEntity(EntityInstance entityInstance, EntityInstance entityInstance2, EntityInstance entityInstance3) {
        EntityClass entityClass = entityInstance2.getEntityClass();
        if (entityClass != null) {
            entityClass = this.getEntityClass(entityClass.getId());
        }
        if (entityClass != null) {
            entityInstance3.setParentClass(entityClass);
        }
        this.moveEntityContainment(entityInstance, entityInstance3);
        if (entityInstance2.xRelLocal() >= 0.0 && entityInstance2.yRelLocal() >= 0.0 && entityInstance2.widthRelLocal() > 0.0 && entityInstance2.heightRelLocal() > 0.0) {
            entityInstance3.setRelLocal(entityInstance2);
        }
        return entityInstance3;
    }

    public void deleteContainer(EntityInstance entityInstance) {
        EntityInstance entityInstance2 = this.disconnectEdgesJustMe(entityInstance);
        if (entityInstance2 == null) {
            EntityInstance entityInstance3;
            this.m_rootInstance = entityInstance3 = entityInstance.getFirstChild();
            entityInstance2 = entityInstance3;
        }
        this.markDeleted(entityInstance);
        this.m_taListener.containerCut(entityInstance2, entityInstance);
    }

    public void undeleteContainer(EntityInstance entityInstance) {
        EntityInstance entityInstance2 = this.reconnectEdgesJustMe(entityInstance);
        this.clearDeleted(entityInstance);
        this.m_taListener.containerUncut(entityInstance);
    }

    public void removeEntityClass(EntityClass entityClass) {
        Enumeration enumeration = this.m_relationClasses.elements();
        while (enumeration.hasMoreElements()) {
            RelationClass relationClass = (RelationClass)enumeration.nextElement();
            Vector vector = relationClass.getRelationList();
            if (vector == null) continue;
            int n = vector.size();
            while (n > 0) {
                EntityClassPair entityClassPair = (EntityClassPair)vector.elementAt(--n);
                if (entityClassPair.m_entityClass1 != entityClass && entityClassPair.m_entityClass2 != entityClass) continue;
                vector.removeElementAt(n);
            }
        }
        if (this.m_defaultEntityClass == entityClass) {
            this.setDefaultEntityClass(this.m_entityBaseClass);
        }
        this.m_entityClasses.remove(entityClass.getId());
        this.m_taListener.classChanges();
    }

    public void removeRelationClass(RelationClass relationClass) {
        if (this.m_defaultRelationClass == relationClass) {
            this.setDefaultRelationClass(this.m_relationBaseClass);
        }
        this.m_relationClasses.remove(relationClass.getId());
        this.m_taListener.classChanges();
    }
}

