/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.Color;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Vector;
import javax.swing.undo.UndoableEdit;
import lsedit.Attribute;
import lsedit.Diagram;
import lsedit.EntityInstance;
import lsedit.LandscapeClassObject;
import lsedit.MyUndoableEdit;
import lsedit.ResultBox;
import lsedit.Ta;
import lsedit.Util;

public class EntityClass
extends LandscapeClassObject {
    public static final String ENTITY_BASE_CLASS_ID = "$ENTITY";
    protected static final String CLASSANGLE_ID = "class_angle";
    protected static final String CLASSIMAGE_ID = "class_image";
    public static final int ID_ATTR = 0;
    public static final int CLASSLABEL_ATTR = 1;
    public static final int CLASSDESC_ATTR = 2;
    public static final int CLASSSTYLE_ATTR = 3;
    public static final int CLASSANGLE_ATTR = 4;
    public static final int CLASSIMAGE_ATTR = 5;
    public static final int COLOR_ATTR = 6;
    public static final int LABEL_COLOR_ATTR = 7;
    public static final int OPEN_COLOR_ATTR = 8;
    public static final int ATTRS = 9;
    public static final String[] attributeName = new String[]{"id", "class_label", "class_description", "class_style", "class_angle", "class_image", "color", "labelcolor", "opencolor"};
    public static final int[] attributeType = new int[]{3, 3, 12, 13, 2, 17, 8, 8, 8};
    public static final int ENTITY_STYLE_NONE = -1;
    public static final int ENTITY_STYLE_3DBOX = 0;
    public static final int ENTITY_STYLE_2DBOX = 1;
    public static final int ENTITY_STYLE_FILE = 2;
    public static final int ENTITY_STYLE_DISK = 3;
    public static final int ENTITY_STYLE_FOLDER = 4;
    public static final int ENTITY_STYLE_SOURCEOBJ = 5;
    public static final int ENTITY_STYLE_CLASS = 6;
    public static final int ENTITY_STYLE_GROUP = 7;
    public static final int ENTITY_STYLE_LABELLED_GROUP = 8;
    public static final int ENTITY_STYLE_TRIANGLE = 9;
    public static final int ENTITY_STYLE_ROMBUS = 10;
    public static final int ENTITY_STYLE_TRAPEZOID = 11;
    public static final int ENTITY_STYLE_TRIANGLE2 = 12;
    public static final int ENTITY_STYLE_RECTANGLE = 13;
    public static final int ENTITY_STYLE_PENTAGON = 14;
    public static final int ENTITY_STYLE_HEXAGON = 15;
    public static final int ENTITY_STYLE_OCTAGON = 16;
    public static final int ENTITY_STYLE_DECAHEDRON = 17;
    public static final int ENTITY_STYLE_12SIDED = 18;
    public static final int ENTITY_STYLE_14SIDED = 19;
    public static final int ENTITY_STYLE_16SIDED = 20;
    public static final int ENTITY_STYLE_18SIDED = 21;
    public static final int ENTITY_STYLE_20SIDED = 22;
    public static final int ENTITY_STYLE_PAPER = 23;
    public static final int ENTITY_STYLE_SUNK_BOX = 24;
    public static final String[] styleName = new String[]{"3D Box", "2D Box", "File", "Disk", "Folder", "Source Object", "Class", "Group", "Labelled Group", "Triangle  (directed)", "Rombus    (directed)", "Trapezoid (directed)", "3-sided  Triangle", "4-sided  Diamond", "5-sided  Pentagon", "6-sided  Hexagon", "8-sided  Octagon", "10-sided Decahedron", "12 sided Polygon", "14 sided Polygon", "16 sided Polygon", "18 sided Polygon", "20 sided Dodecahedron", "Paper", "Sunken Box"};
    public static final int ENTITY_IMAGE_NONE = 0;
    public static final int ENTITY_IMAGE_ACTOR = 1;
    public static final int ENTITY_IMAGE_OVAL = 2;
    public static final int ENTITY_IMAGE_FRAME = 4;
    public static final int ENTITY_IMAGE_ROUNDED_FRAME = 8;
    public static final int ENTITY_IMAGE_X = 16;
    public static final int ENTITY_IMAGE_LAST = 16;
    public static final String[] imageName = new String[]{"Actor", "Oval", "Frame", "Rounded Frame", "X"};
    protected int m_image = 0;
    protected double m_angle = 0.0;
    private boolean m_shown = true;
    private int m_orderedId;

    public EntityClass(String string, int n, Ta ta) {
        super(ta);
        this.setId(string);
        this.setNid(n);
        this.setLabel(string);
    }

    public void setOrderedId(int n) {
        this.m_orderedId = n;
    }

    public int getOrderedId() {
        return this.m_orderedId;
    }

    public static String getEntityStyleName(int n) {
        if (n < 0 || n >= styleName.length) {
            return "";
        }
        return styleName[n];
    }

    public String getStyleName(int n) {
        return EntityClass.getEntityStyleName(n);
    }

    public int getImage() {
        return this.m_image;
    }

    public void setImage(int n) {
        this.m_image = n;
    }

    public void updateImage(int n) {
        int n2 = this.m_image;
        if (n2 != n) {
            this.setImage(n);
            if (this.undoEnabled()) {
                new SetImage(n2);
            }
        }
    }

    public double getAngle() {
        return this.m_angle;
    }

    public void setAngle(double d) {
        this.m_angle = d;
    }

    public void updateAngle(double d) {
        double d2 = this.m_angle;
        if (d != d2) {
            this.setAngle(d);
            if (this.undoEnabled()) {
                new SetAngle(d2);
            }
        }
    }

    public void setShown(boolean bl) {
        if (this.m_shown != bl) {
            Vector vector;
            Diagram diagram;
            if (!bl && (diagram = this.getDiagram()) != null && (vector = this.getDiagram().getGroup()) != null) {
                EntityInstance entityInstance;
                boolean bl2 = false;
                int n = vector.size();
                while (--n >= 0) {
                    entityInstance = (EntityInstance)vector.elementAt(n);
                    EntityClass entityClass = entityInstance.getEntityClass();
                    if (entityClass == this) {
                        entityInstance.clearGroupFlag();
                        vector.removeElementAt(n);
                        continue;
                    }
                    bl2 |= entityInstance.getGroupKeyFlag();
                }
                if (!bl2 && vector.size() > 0) {
                    entityInstance = (EntityInstance)vector.elementAt(0);
                    entityInstance.setGroupKeyFlag();
                }
            }
            this.m_shown = bl;
        }
    }

    public boolean isShown() {
        return this.m_shown;
    }

    protected boolean processClassAttributes(Attribute attribute) {
        if (attribute.avi != null) {
            if (attribute.id.equals(CLASSIMAGE_ID)) {
                this.setImage(Util.parseInt(attribute.avi.value));
                return true;
            }
            if (attribute.id.equals(CLASSANGLE_ID)) {
                this.setAngle(Util.parseReal(attribute.avi.value));
                return true;
            }
            if (super.processClassAttributes(attribute)) {
                return true;
            }
        }
        return false;
    }

    public void writeAttributes(PrintStream printStream) throws IOException {
        int n;
        printStream.print(this.qt(this.getId()) + " {\n");
        super.writeAttributes(printStream);
        double d = this.getAngle();
        if (d != 0.0) {
            printStream.print(" class_angle = " + d + "\n");
        }
        if ((n = this.getImage()) != 0) {
            printStream.print(" class_image = " + n + "\n");
        }
        printStream.print("}\n\n");
    }

    public void reportClassAttributes(ResultBox resultBox) {
        super.reportClassAttributes(resultBox);
        resultBox.addText(CLASSIMAGE_ID);
        resultBox.addText(CLASSANGLE_ID);
    }

    public EntityInstance newEntity(String string) {
        EntityInstance entityInstance = new EntityInstance(this, string);
        return entityInstance;
    }

    public void shapeChanges(int n, double d) {
        int n2 = this.getInheritedStyle();
        if (n == n2 && (n2 < 9 || n2 > 22)) {
            return;
        }
        Diagram diagram = this.getDiagram();
        if (diagram != null) {
            EntityInstance entityInstance = diagram.getRootInstance();
            if (entityInstance == null) {
                return;
            }
            entityInstance.shapeChanges(this);
        }
    }

    public int getPrimaryAttributeCount() {
        return 9;
    }

    public String getLsAttributeNameAt(int n) {
        String string = n < 9 ? attributeName[n] : super.getLsAttributeNameAt(n);
        return string;
    }

    public int getLsAttributeTypeAt(int n) {
        int n2 = n < 9 ? attributeType[n] : super.getLsAttributeTypeAt(n);
        return n2;
    }

    public Object getLsAttributeValueAt(int n) {
        Object object;
        switch (n) {
            case 0: {
                object = this.getId();
                break;
            }
            case 1: {
                object = this.getLabel();
                break;
            }
            case 2: {
                object = this.getDescription();
                break;
            }
            case 3: {
                object = new Integer(this.getStyle());
                break;
            }
            case 4: {
                object = new Double(this.getAngle());
                break;
            }
            case 5: {
                object = new Integer(this.getImage());
                break;
            }
            case 6: {
                object = this.getObjectColor();
                break;
            }
            case 7: {
                object = this.getLabelColor();
                break;
            }
            case 8: {
                object = this.getColorWhenOpen();
                break;
            }
            default: {
                object = super.getLsAttributeValueAt(n);
            }
        }
        return object;
    }

    public void updateAttributeValueAt(int n, Object object) {
        switch (n) {
            case 0: {
                this.setId((String)object);
                break;
            }
            case 1: {
                this.updateLabel((String)object);
                break;
            }
            case 2: {
                this.updateDescription((String)object);
                break;
            }
            case 3: {
                this.updateStyle((Integer)object);
                break;
            }
            case 4: {
                this.updateAngle((Double)object);
                break;
            }
            case 5: {
                this.updateImage((Integer)object);
                break;
            }
            case 6: {
                this.updateObjectColor((Color)object);
                break;
            }
            case 7: {
                this.updateLabelColor((Color)object);
                break;
            }
            case 8: {
                this.updateColorWhenOpen((Color)object);
                break;
            }
            default: {
                super.updateAttributeValueAt(n, object);
            }
        }
    }

    class SetAngle
    extends MyUndoableEdit
    implements UndoableEdit {
        double m_old;
        double m_new;

        SetAngle(double d) {
            this.m_old = d;
            this.m_new = EntityClass.this.getAngle();
            EntityClass.this.logEdit(this);
        }

        public String getPresentationName() {
            return EntityClass.this + " Angle " + this.m_new;
        }

        public void undo() {
            EntityClass.this.setAngle(this.m_old);
        }

        public void redo() {
            EntityClass.this.setAngle(this.m_new);
        }
    }

    class SetImage
    extends MyUndoableEdit
    implements UndoableEdit {
        int m_old;
        int m_new;

        SetImage(int n) {
            this.m_old = n;
            this.m_new = EntityClass.this.getImage();
            EntityClass.this.logEdit(this);
        }

        public String getPresentationName() {
            return EntityClass.this + " Change Image";
        }

        public void undo() {
            EntityClass.this.setImage(this.m_old);
        }

        public void redo() {
            EntityClass.this.setImage(this.m_new);
        }
    }
}

